/*
    Sherry Wang 7/6/2012
	TBI Tracker #1673: User Messaging and Web Application Control       
		- Create a new table [dbo].[APPLICATION_STATUS]
		- Create the history table and triggers for [dbo].[APPLICATION_STATUS]
		
    Sherry Wang 7/10/2012
	TBI Tracker #1673: User Messaging and Web Application Control   
		- Add role and apppages / role permissions for the new page
*/

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[APPLICATION_STATUS_STDREG_FK]') AND parent_object_id = OBJECT_ID(N'[dbo].[APPLICATION_STATUS]'))
ALTER TABLE [dbo].[APPLICATION_STATUS] DROP CONSTRAINT [APPLICATION_STATUS_STDREG_FK]
GO


/****** Object:  Table [dbo].[APPLICATION_STATUS]    Script Date: 07/06/2012 10:06:50 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[APPLICATION_STATUS]') AND type in (N'U'))
DROP TABLE [dbo].[APPLICATION_STATUS]
GO


CREATE TABLE [dbo].[APPLICATION_STATUS](
	[STD_REGISTRY_ID] [int] NOT NULL,
	[PROCESS_FLAG] [int] NOT NULL,
	[MESSAGE] [varchar](4000) NULL,
	[CREATEDBY] [varchar](30) NOT NULL,
	[CREATED] [datetime] NOT NULL,
	[UPDATEDBY] [varchar](30) NOT NULL,
	[UPDATED] [datetime] NOT NULL,
	[ROW_VERSION] [timestamp] NOT NULL,
 CONSTRAINT [APPLICATION_STATUS_PK] PRIMARY KEY CLUSTERED 
(
	[STD_REGISTRY_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

ALTER TABLE [dbo].[APPLICATION_STATUS]  WITH NOCHECK ADD  CONSTRAINT [APPLICATION_STATUS_STDREG_FK] FOREIGN KEY([STD_REGISTRY_ID])
REFERENCES [dbo].[STD_REGISTRY] ([ID])
GO

ALTER TABLE [dbo].[APPLICATION_STATUS] CHECK CONSTRAINT [APPLICATION_STATUS_STDREG_FK]
GO


if exists(Select * from sys.columns where name='bDelete' and object_id=object_id('APPLICATION_STATUS'))
BEGIN
Alter table APPLICATION_STATUS
DROP CONSTRAINT APPLICATION_STATUS_bDel_def
Alter table APPLICATION_STATUS
DROP column bDelete
END
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[APPLICATION_STATUS_H]') AND type in (N'U'))
begin
DROP TABLE [dbo].[APPLICATION_STATUS_H]
end;
Create Table [dbo].[APPLICATION_STATUS_H](
[Audit_APPLICATION_STATUS_H_ID] [int] IDENTITY(1,1) NOT NULL
, [Audit_Date] [datetime] NOT NULL
, [Audit_Type] [varchar](20) NOT NULL
, [Audit_ApplicationUser] [varchar](128)
, [Audit_SQLUser] [varchar](100)
, [STD_REGISTRY_ID] [int]
, [PROCESS_FLAG] [int]
, [MESSAGE] [varchar](4000)
, [CREATEDBY] [varchar](30)
, [CREATED] [datetime]
, [UPDATEDBY] [varchar](30)
, [UPDATED] [datetime]
, CONSTRAINT [APPLICATION_STATUS_H_PK] PRIMARY KEY CLUSTERED 
(
[Audit_APPLICATION_STATUS_H_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_APPLICATION_STATUS_H]'))
DROP TRIGGER [dbo].[TRG_APPLICATION_STATUS_H]
GO
Create trigger [dbo].[TRG_APPLICATION_STATUS_H] on [dbo].[APPLICATION_STATUS]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [dbo].[APPLICATION_STATUS_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [STD_REGISTRY_ID]
, [PROCESS_FLAG]
, [MESSAGE]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [STD_REGISTRY_ID]
, [PROCESS_FLAG]
, [MESSAGE]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[dbo].[TRG_APPLICATION_STATUS_DEL_H]'))
DROP TRIGGER [dbo].[TRG_APPLICATION_STATUS_DEL_H]
go
CREATE TRIGGER  [dbo].[TRG_APPLICATION_STATUS_DEL_H]
on  [dbo].[APPLICATION_STATUS] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [dbo].[APPLICATION_STATUS_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [STD_REGISTRY_ID]
, [PROCESS_FLAG]
, [MESSAGE]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [STD_REGISTRY_ID]
, [PROCESS_FLAG]
, [MESSAGE]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]

From Deleted
End
go


DECLARE @systemPageId int, @tbiAdminRoleId int

if Not exists(select * from STD_APPPAGE where Code = 'TBI_SYSTEM_AVAILABILITY')
begin
  INSERT INTO STD_APPPAGE([CODE],[NAME],[DESCRIPTION_TEXT],[SORT_ORDER],[INACTIVE_FLAG],[INACTIVE_DATE],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED])
  VALUES ('TBI_SYSTEM_AVAILABILITY', 'TBI System Availability', 'TBI System Availability', 1, 0, NULL, 'Increment 5', getdate(), 'Increment 5', getdate())
  SELECT @systemPageId = @@IDENTITY
end
else
begin
  SELECT @systemPageId = ID FROM STD_APPPAGE WHERE Code = 'TBI_SYSTEM_AVAILABILITY'
end

SELECT @tbiAdminRoleId = ID FROM STD_ROLE WHERE CODE = 'TBI ADMINISTRATOR'

if Not exists(select * from ROLE_PERMISSIONS where STD_ROLE_ID = @tbiAdminRoleId AND STD_APPPAGE_ID = @systemPageId)
	INSERT INTO ROLE_PERMISSIONS([STD_ROLE_ID],[STD_APPPAGE_ID],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED],[INSERT_FLAG],[UPDATE_FLAG],[DELETE_FLAG])
	VALUES(@tbiAdminRoleId, @systemPageId, 'Increment 5', 'Increment 5', getdate(), getdate(), 1, 1, 1)

go

begin
INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('05'
           ,'00'
           ,'064'
           ,0
           ,'TBI Tracker #1673: User Messaging and Web Application Control'
		   ,'Create a new table [dbo].[APPLICATION_STATUS] and its history table and triggers'
           ,'TBI'
           ,GETDATE())
end
GO