--Create table
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[SYSPARM_STDREG_FK]') AND parent_object_id = OBJECT_ID(N'[dbo].[SYSTEM_PARAMETERS]'))
ALTER TABLE [dbo].[SYSTEM_PARAMETERS] DROP CONSTRAINT [SYSPARM_STDREG_FK]
GO

/****** Object:  Table [dbo].[SYSTEM_PARAMETERS]    Script Date: 06/22/2012 12:17:35 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SYSTEM_PARAMETERS]') AND type in (N'U'))
DROP TABLE [dbo].[SYSTEM_PARAMETERS]
GO

/****** Object:  Table [dbo].[SYSTEM_PARAMETERS]    Script Date: 06/22/2012 12:17:44 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [dbo].[SYSTEM_PARAMETERS](
	[PARAMETER_ID] [int] IDENTITY(1,1) NOT NULL,
	[STD_REGISTRY_ID] [int] NOT NULL,
	[CODE] [varchar](100) NOT NULL,
	[DESCRIPTION] [varchar](1000) NOT NULL,
	[VALUE] [varchar](100) NOT NULL,
 CONSTRAINT [SYSPARM_PK] PRIMARY KEY CLUSTERED 
(
	[PARAMETER_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

ALTER TABLE [dbo].[SYSTEM_PARAMETERS]  WITH NOCHECK ADD  CONSTRAINT [SYSPARM_STDREG_FK] FOREIGN KEY([STD_REGISTRY_ID])
REFERENCES [dbo].[STD_REGISTRY] ([ID])
GO

ALTER TABLE [dbo].[SYSTEM_PARAMETERS] CHECK CONSTRAINT [SYSPARM_STDREG_FK]
GO

--Insert parameters
Delete from [dbo].[SYSTEM_PARAMETERS];
INSERT INTO [dbo].[SYSTEM_PARAMETERS] ([STD_REGISTRY_ID],[CODE],[DESCRIPTION],[VALUE])
     VALUES (4,'SIGNATURE_FLAG','Flag indicating whether CPRS note signing feature should be turned ON or OFF','FALSE');
INSERT INTO [dbo].[SYSTEM_PARAMETERS] ([STD_REGISTRY_ID],[CODE],[DESCRIPTION],[VALUE])
     VALUES (4,'PATIENT_BATCH_SIZE_PER_SITE','Maximum number of patients at each VistA site that should be selected for processing','2');
INSERT INTO [dbo].[SYSTEM_PARAMETERS] ([STD_REGISTRY_ID],[CODE],[DESCRIPTION],[VALUE])
     VALUES (4,'VISTA_SITE','VistA site participating in ETL test interfacing CPRS','914');
INSERT INTO [dbo].[SYSTEM_PARAMETERS] ([STD_REGISTRY_ID],[CODE],[DESCRIPTION],[VALUE])
     VALUES (4,'VISTA_SITE','VistA site participating in ETL test interfacing CPRS','932');
INSERT INTO [dbo].[SYSTEM_PARAMETERS] ([STD_REGISTRY_ID],[CODE],[DESCRIPTION],[VALUE])
     VALUES (4,'VISTA_SITE','VistA site participating in ETL test interfacing CPRS','943');
INSERT INTO [dbo].[SYSTEM_PARAMETERS] ([STD_REGISTRY_ID],[CODE],[DESCRIPTION],[VALUE])
     VALUES (4,'VISTA_SITE','VistA site participating in ETL test interfacing CPRS','944');
	 
begin
INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('05'
           ,'00'
           ,'063'
           ,0
           ,'Write Note Initial Setup'
           ,'Create and populate SYSTEM_PARAMETERS table needed for VITAS'
           ,'VITAS'
           ,GETDATE())
end
GO

