
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[EFR].[DOD_FRAGMENT_DETAIL_DOD_FRAGMENT_FK]') AND parent_object_id = OBJECT_ID(N'[EFR].[DOD_FRAGMENT_DETAIL]'))
ALTER TABLE [EFR].[DOD_FRAGMENT_DETAIL] DROP CONSTRAINT [DOD_FRAGMENT_DETAIL_DOD_FRAGMENT_FK]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[EFR].[DOD_FRAGMENT_DETAIL_STD_FRAGMENT_ANALYSIS_TYPE_FK]') AND parent_object_id = OBJECT_ID(N'[EFR].[DOD_FRAGMENT_DETAIL]'))
ALTER TABLE [EFR].[DOD_FRAGMENT_DETAIL] DROP CONSTRAINT [DOD_FRAGMENT_DETAIL_STD_FRAGMENT_ANALYSIS_TYPE_FK]
GO

IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_DOD_FRAGMENT_DETAIL_CREATED]') AND type = 'D')
BEGIN
ALTER TABLE [EFR].[DOD_FRAGMENT_DETAIL] DROP CONSTRAINT [DF_DOD_FRAGMENT_DETAIL_CREATED]
END

GO

IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_DOD_FRAGMENT_DETAIL_UPDATED]') AND type = 'D')
BEGIN
ALTER TABLE [EFR].[DOD_FRAGMENT_DETAIL] DROP CONSTRAINT [DF_DOD_FRAGMENT_DETAIL_UPDATED]
END

GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[EFR].[DOD_FRAGMENT_DOD_FRAGMENT_LAB_FK]') AND parent_object_id = OBJECT_ID(N'[EFR].[DOD_FRAGMENT]'))
ALTER TABLE [EFR].[DOD_FRAGMENT] DROP CONSTRAINT [DOD_FRAGMENT_DOD_FRAGMENT_LAB_FK]
GO

IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_DOD_FRAGMENT_TISSUE_SENT_FLAG]') AND type = 'D')
BEGIN
ALTER TABLE [EFR].[DOD_FRAGMENT] DROP CONSTRAINT [DF_DOD_FRAGMENT_TISSUE_SENT_FLAG]
END

GO

IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_DOD_FRAGMENT_CREATED]') AND type = 'D')
BEGIN
ALTER TABLE [EFR].[DOD_FRAGMENT] DROP CONSTRAINT [DF_DOD_FRAGMENT_CREATED]
END

GO

IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_DOD_FRAGMENT_UPDATED]') AND type = 'D')
BEGIN
ALTER TABLE [EFR].[DOD_FRAGMENT] DROP CONSTRAINT [DF_DOD_FRAGMENT_UPDATED]
END

GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[EFR].[DOD_FRAGMENT_DETAIL]') AND type in (N'U'))
DROP TABLE [EFR].[DOD_FRAGMENT_DETAIL]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[EFR].[DOD_FRAGMENT]') AND type in (N'U'))
DROP TABLE [EFR].[DOD_FRAGMENT]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [EFR].[DOD_FRAGMENT_LAB](
	[DOD_FRAGMENT_LAB_ID] [int] IDENTITY(1,1) NOT NULL,
	[PATIENT_ID] [int] NOT NULL,
	[LAB_NAME] [varchar](600) NOT NULL,
	[LAB_CODE] [varchar](200) NULL,
	[LAB_ID] [varchar](200) NULL,
	[LAB_ACCESSION_NUMBER] [varchar](200) NULL,
	[LAB_REPORT_DATE] [varchar](50) NULL,
	[PRODUCING_EVENT_DATE] [varchar](50) NULL,
	[ROW_VERSION] [timestamp] NOT NULL,
	[CREATED] [datetime] NOT NULL,
	[CREATEDBY] [varchar](30) NOT NULL,
	[UPDATED] [datetime] NOT NULL,
	[UPDATEDBY] [varchar](30) NOT NULL,
 CONSTRAINT [DOD_FRAGMENT_LAB_PK] PRIMARY KEY CLUSTERED 
(
	[DOD_FRAGMENT_LAB_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

ALTER TABLE [EFR].[DOD_FRAGMENT_LAB]  WITH NOCHECK ADD  CONSTRAINT [DOD_FRAGMENT_LAB_PATIENT_FK] FOREIGN KEY([PATIENT_ID])
REFERENCES [dbo].[PATIENT] ([PATIENT_ID])
GO

ALTER TABLE [EFR].[DOD_FRAGMENT_LAB] CHECK CONSTRAINT [DOD_FRAGMENT_LAB_PATIENT_FK]
GO

ALTER TABLE [EFR].[DOD_FRAGMENT_LAB] ADD  CONSTRAINT [DF_DOD_FRAGMENT_LAB_CREATED]  DEFAULT (getdate()) FOR [CREATED]
GO

ALTER TABLE [EFR].[DOD_FRAGMENT_LAB] ADD  CONSTRAINT [DF_DOD_FRAGMENT_LAB_UPDATED]  DEFAULT (getdate()) FOR [UPDATED]
GO


SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [EFR].[DOD_FRAGMENT_LAB_H](
	[Audit_DOD_FRAGMENT_LAB_H_ID] [int] IDENTITY(1,1) NOT NULL,
	[Audit_Date] [datetime] NOT NULL,
	[Audit_Type] [varchar](20) NOT NULL,
	[Audit_ApplicationUser] [varchar](128) NULL,
	[Audit_SQLUser] [varchar](100) NULL,
	[DOD_FRAGMENT_LAB_ID] [int] NULL,
	[PATIENT_ID] [int] NULL,
	[LAB_NAME] [varchar](600) NULL,
	[LAB_CODE] [varchar](200) NULL,
	[LAB_ID] [varchar](200) NULL,
	[LAB_ACCESSION_NUMBER] [varchar](200) NULL,
	[LAB_REPORT_DATE] [varchar](50) NULL,
	[PRODUCING_EVENT_DATE] [varchar](50) NULL,
	[CREATED] [datetime] NULL,
	[CREATEDBY] [varchar](30) NULL,
	[UPDATED] [datetime] NULL,
	[UPDATEDBY] [varchar](30) NULL,
 CONSTRAINT [DOD_FRAGMENT_LAB_H_PK] PRIMARY KEY CLUSTERED 
(
	[Audit_DOD_FRAGMENT_LAB_H_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO




SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TRIGGER  [EFR].[TRG_DOD_FRAGMENT_LAB_DEL_H]
on  [EFR].[DOD_FRAGMENT_LAB] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [EFR].[DOD_FRAGMENT_LAB_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [DOD_FRAGMENT_LAB_ID]
, [PATIENT_ID]
, [LAB_NAME]
, [LAB_CODE]
, [LAB_ID]
, [LAB_ACCESSION_NUMBER]
, [LAB_REPORT_DATE]
, [PRODUCING_EVENT_DATE]
, [CREATED]
, [CREATEDBY]
, [UPDATED]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [DOD_FRAGMENT_LAB_ID]
, [PATIENT_ID]
, [LAB_NAME]
, [LAB_CODE]
, [LAB_ID]
, [LAB_ACCESSION_NUMBER]
, [LAB_REPORT_DATE]
, [PRODUCING_EVENT_DATE]
, [CREATED]
, [CREATEDBY]
, [UPDATED]
, [UPDATEDBY]

From Deleted
End

GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

Create trigger [EFR].[TRG_DOD_FRAGMENT_LAB_H] on [EFR].[DOD_FRAGMENT_LAB]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [EFR].[DOD_FRAGMENT_LAB_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [DOD_FRAGMENT_LAB_ID]
, [PATIENT_ID]
, [LAB_NAME]
, [LAB_CODE]
, [LAB_ID]
, [LAB_ACCESSION_NUMBER]
, [LAB_REPORT_DATE]
, [PRODUCING_EVENT_DATE]
, [CREATED]
, [CREATEDBY]
, [UPDATED]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [DOD_FRAGMENT_LAB_ID]
, [PATIENT_ID]
, [LAB_NAME]
, [LAB_CODE]
, [LAB_ID]
, [LAB_ACCESSION_NUMBER]
, [LAB_REPORT_DATE]
, [PRODUCING_EVENT_DATE]
, [CREATED]
, [CREATEDBY]
, [UPDATED]
, [UPDATEDBY]

FROM INSERTED
End

GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [EFR].[DOD_FRAGMENT](
	[DOD_FRAGMENT_ID] [int] IDENTITY(1,1) NOT NULL,
	[DOD_FRAGMENT_LAB_ID] [int] NOT NULL,
	[FRAGMENT_ID_NUMBER] [varchar](200) NULL,
	[FRAGMENT_DESCRIPTION] [varchar](4000) NULL,
	[MASS] [varchar](200) NULL,
	[MASS_UNITS] [varchar](200) NULL,
	[LENGTH] [varchar](200) NULL,
	[LENGTH_UNITS] [varchar](200) NULL,
	[HEIGHT] [varchar](200) NULL,
	[HEIGHT_UNITS] [varchar](200) NULL,
	[WIDTH] [varchar](200) NULL,
	[WIDTH_UNITS] [varchar](200) NULL,
	[RADIOACTIVEINDICATOR] [varchar](200) NULL,
	[RADIOACTIVERESULTS] [varchar](1000) NULL,
	[COMMENTS] [varchar](4000) NULL,
	[TISSUE_SENT_FLAG] [bit] NULL,
	[TISSUE_ASSOCIATED_WITH_FRAGMENT] [varchar](4000) NULL,
	[ROW_VERSION] [timestamp] NOT NULL,
	[CREATED] [datetime] NOT NULL,
	[CREATEDBY] [varchar](30) NOT NULL,
	[UPDATED] [datetime] NOT NULL,
	[UPDATEDBY] [varchar](30) NOT NULL,
 CONSTRAINT [DOD_FRAGMENT_PK] PRIMARY KEY CLUSTERED 
(
	[DOD_FRAGMENT_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

ALTER TABLE [EFR].[DOD_FRAGMENT]  WITH NOCHECK ADD  CONSTRAINT [DOD_FRAGMENT_DOD_FRAGMENT_LAB_FK] FOREIGN KEY([DOD_FRAGMENT_LAB_ID])
REFERENCES [EFR].[DOD_FRAGMENT_LAB] ([DOD_FRAGMENT_LAB_ID])
GO

ALTER TABLE [EFR].[DOD_FRAGMENT] CHECK CONSTRAINT [DOD_FRAGMENT_DOD_FRAGMENT_LAB_FK]
GO

ALTER TABLE [EFR].[DOD_FRAGMENT] ADD  CONSTRAINT [DF_DOD_FRAGMENT_TISSUE_SENT_FLAG]  DEFAULT ((0)) FOR [TISSUE_SENT_FLAG]
GO

ALTER TABLE [EFR].[DOD_FRAGMENT] ADD  CONSTRAINT [DF_DOD_FRAGMENT_CREATED]  DEFAULT (getdate()) FOR [CREATED]
GO

ALTER TABLE [EFR].[DOD_FRAGMENT] ADD  CONSTRAINT [DF_DOD_FRAGMENT_UPDATED]  DEFAULT (getdate()) FOR [UPDATED]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TRIGGER  [EFR].[TRG_DOD_FRAGMENT_DEL_H]
on  [EFR].[DOD_FRAGMENT] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [EFR].[DOD_FRAGMENT_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [DOD_FRAGMENT_ID]
, [DOD_FRAGMENT_LAB_ID]
, [FRAGMENT_ID_NUMBER]
, [FRAGMENT_DESCRIPTION]
, [MASS]
, [MASS_UNITS]
, [LENGTH]
, [LENGTH_UNITS]
, [HEIGHT]
, [HEIGHT_UNITS]
, [WIDTH]
, [WIDTH_UNITS]
, [RADIOACTIVEINDICATOR]
, [RADIOACTIVERESULTS]
, [COMMENTS]
, [TISSUE_SENT_FLAG]
, [TISSUE_ASSOCIATED_WITH_FRAGMENT]
, [CREATED]
, [CREATEDBY]
, [UPDATED]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [DOD_FRAGMENT_ID]
, [DOD_FRAGMENT_LAB_ID]
, [FRAGMENT_ID_NUMBER]
, [FRAGMENT_DESCRIPTION]
, [MASS]
, [MASS_UNITS]
, [LENGTH]
, [LENGTH_UNITS]
, [HEIGHT]
, [HEIGHT_UNITS]
, [WIDTH]
, [WIDTH_UNITS]
, [RADIOACTIVEINDICATOR]
, [RADIOACTIVERESULTS]
, [COMMENTS]
, [TISSUE_SENT_FLAG]
, [TISSUE_ASSOCIATED_WITH_FRAGMENT]
, [CREATED]
, [CREATEDBY]
, [UPDATED]
, [UPDATEDBY]

From Deleted
End

GO


SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

Create trigger [EFR].[TRG_DOD_FRAGMENT_H] on [EFR].[DOD_FRAGMENT]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [EFR].[DOD_FRAGMENT_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [DOD_FRAGMENT_ID]
, [DOD_FRAGMENT_LAB_ID]
, [FRAGMENT_ID_NUMBER]
, [FRAGMENT_DESCRIPTION]
, [MASS]
, [MASS_UNITS]
, [LENGTH]
, [LENGTH_UNITS]
, [HEIGHT]
, [HEIGHT_UNITS]
, [WIDTH]
, [WIDTH_UNITS]
, [RADIOACTIVEINDICATOR]
, [RADIOACTIVERESULTS]
, [COMMENTS]
, [TISSUE_SENT_FLAG]
, [TISSUE_ASSOCIATED_WITH_FRAGMENT]
, [CREATED]
, [CREATEDBY]
, [UPDATED]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [DOD_FRAGMENT_ID]
, [DOD_FRAGMENT_LAB_ID]
, [FRAGMENT_ID_NUMBER]
, [FRAGMENT_DESCRIPTION]
, [MASS]
, [MASS_UNITS]
, [LENGTH]
, [LENGTH_UNITS]
, [HEIGHT]
, [HEIGHT_UNITS]
, [WIDTH]
, [WIDTH_UNITS]
, [RADIOACTIVEINDICATOR]
, [RADIOACTIVERESULTS]
, [COMMENTS]
, [TISSUE_SENT_FLAG]
, [TISSUE_ASSOCIATED_WITH_FRAGMENT]
, [CREATED]
, [CREATEDBY]
, [UPDATED]
, [UPDATEDBY]

FROM INSERTED
End

GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [EFR].[DOD_FRAGMENT_DETAIL](
	[DOD_FRAGMENT_DETAIL_ID] [int] IDENTITY(1,1) NOT NULL,
	[DOD_FRAGMENT_ID] [int] NOT NULL,
	[ANALYTE] [varchar](400) NULL,
	[ANALYSIS_METHOD] [varchar](400) NULL,
	[OTHER_ANALYTE] [varchar](400) NULL,
	[OTHER_ANALYSIS_METHOD] [varchar](400) NULL,
	[RESULT] [varchar](4000) NULL,
	[COMMENTS] [varchar](4000) NULL,
	[CAS_NUMBER] [varchar](100) NULL,
	[STD_FRAGMENT_ANALYSIS_TYPE_ID] [int] NULL,
	[ROW_VERSION] [timestamp] NOT NULL,
	[CREATED] [datetime] NOT NULL,
	[CREATEDBY] [varchar](30) NOT NULL,
	[UPDATED] [datetime] NOT NULL,
	[UPDATEDBY] [varchar](30) NOT NULL,
 CONSTRAINT [DOD_FRAGMENT_DETAIL_PK] PRIMARY KEY CLUSTERED 
(
	[DOD_FRAGMENT_DETAIL_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

ALTER TABLE [EFR].[DOD_FRAGMENT_DETAIL]  WITH NOCHECK ADD  CONSTRAINT [DOD_FRAGMENT_DETAIL_DOD_FRAGMENT_FK] FOREIGN KEY([DOD_FRAGMENT_ID])
REFERENCES [EFR].[DOD_FRAGMENT] ([DOD_FRAGMENT_ID])
GO

ALTER TABLE [EFR].[DOD_FRAGMENT_DETAIL] CHECK CONSTRAINT [DOD_FRAGMENT_DETAIL_DOD_FRAGMENT_FK]
GO

ALTER TABLE [EFR].[DOD_FRAGMENT_DETAIL]  WITH CHECK ADD  CONSTRAINT [DOD_FRAGMENT_DETAIL_STD_FRAGMENT_ANALYSIS_TYPE_FK] FOREIGN KEY([STD_FRAGMENT_ANALYSIS_TYPE_ID])
REFERENCES [EFR].[STD_FRAGMENT_ANALYSIS_TYPE] ([ID])
GO

ALTER TABLE [EFR].[DOD_FRAGMENT_DETAIL] CHECK CONSTRAINT [DOD_FRAGMENT_DETAIL_STD_FRAGMENT_ANALYSIS_TYPE_FK]
GO

ALTER TABLE [EFR].[DOD_FRAGMENT_DETAIL] ADD  CONSTRAINT [DF_DOD_FRAGMENT_DETAIL_CREATED]  DEFAULT (getdate()) FOR [CREATED]
GO

ALTER TABLE [EFR].[DOD_FRAGMENT_DETAIL] ADD  CONSTRAINT [DF_DOD_FRAGMENT_DETAIL_UPDATED]  DEFAULT (getdate()) FOR [UPDATED]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TRIGGER  [EFR].[TRG_DOD_FRAGMENT_DETAIL_DEL_H]
on  [EFR].[DOD_FRAGMENT_DETAIL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [EFR].[DOD_FRAGMENT_DETAIL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [DOD_FRAGMENT_DETAIL_ID]
, [DOD_FRAGMENT_ID]
, [ANALYTE]
, [ANALYSIS_METHOD]
, [OTHER_ANALYTE]
, [OTHER_ANALYSIS_METHOD]
, [RESULT]
, [COMMENTS]
, [CAS_NUMBER]
, [STD_FRAGMENT_ANALYSIS_TYPE_ID]
, [CREATED]
, [CREATEDBY]
, [UPDATED]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [DOD_FRAGMENT_DETAIL_ID]
, [DOD_FRAGMENT_ID]
, [ANALYTE]
, [ANALYSIS_METHOD]
, [OTHER_ANALYTE]
, [OTHER_ANALYSIS_METHOD]
, [RESULT]
, [COMMENTS]
, [CAS_NUMBER]
, [STD_FRAGMENT_ANALYSIS_TYPE_ID]
, [CREATED]
, [CREATEDBY]
, [UPDATED]
, [UPDATEDBY]

From Deleted
End

GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

Create trigger [EFR].[TRG_DOD_FRAGMENT_DETAIL_H] on [EFR].[DOD_FRAGMENT_DETAIL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [EFR].[DOD_FRAGMENT_DETAIL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [DOD_FRAGMENT_DETAIL_ID]
, [DOD_FRAGMENT_ID]
, [ANALYTE]
, [ANALYSIS_METHOD]
, [OTHER_ANALYTE]
, [OTHER_ANALYSIS_METHOD]
, [RESULT]
, [COMMENTS]
, [CAS_NUMBER]
, [STD_FRAGMENT_ANALYSIS_TYPE_ID]
, [CREATED]
, [CREATEDBY]
, [UPDATED]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [DOD_FRAGMENT_DETAIL_ID]
, [DOD_FRAGMENT_ID]
, [ANALYTE]
, [ANALYSIS_METHOD]
, [OTHER_ANALYTE]
, [OTHER_ANALYSIS_METHOD]
, [RESULT]
, [COMMENTS]
, [CAS_NUMBER]
, [STD_FRAGMENT_ANALYSIS_TYPE_ID]
, [CREATED]
, [CREATEDBY]
, [UPDATED]
, [UPDATEDBY]

FROM INSERTED
End

GO

INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('05'
           ,'00'
           ,'061'
           ,0
           ,'EFR drop and recreate DoD Fragment '
		   ,''
           ,'EFR'
           ,GETDATE())




