/*
    Sherry Wang 6/11/2012
	EFR Tracker #1601: The "VTA Data Extract" Export is not updating the "ISEFRPATIENT" column       
		- Create a new view [EFR].[VIEW_EFR_PATIENT]
		- Modify the stored procedure [EFRDataExportVTADataExtract] to retrieve ISEFRPATIENT correctly
*/

/****** Object:  View [EFR].[VIEW_EFR_PATIENT]    Script Date: 06/11/2012 15:28:05 ******/
IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[EFR].[VIEW_EFR_PATIENT]'))
DROP VIEW [EFR].[VIEW_EFR_PATIENT]
GO

CREATE VIEW [EFR].[VIEW_EFR_PATIENT] WITH SCHEMABINDING AS
	SELECT DISTINCT B.PATIENT_ID, B.SSN
	FROM dbo.REFERRAL A INNER JOIN dbo.PATIENT B ON A.PATIENT_ID = B.PATIENT_ID
	WHERE A.STD_REGISTRY_ID = 1


GO

/****** Object:  StoredProcedure [dbo].[EFRDataExportVTADataExtract]    Script Date: 06/11/2012 15:02:07 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EFRDataExportVTADataExtract]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[EFRDataExportVTADataExtract]
GO

CREATE PROCEDURE [dbo].[EFRDataExportVTADataExtract]

AS

--**************************************
--GET DATA FOR SOAP_KEYWORD

--DROP TABLE #VTASOAPKEYWORD
CREATE TABLE #VTASOAPKEYWORD
(
	PATIENT_ID INT,
	VTA_ID INT,
	SOAP_KEYWORD VARCHAR(100)
)

INSERT INTO #VTASOAPKEYWORD
SELECT
	VP.PATIENT_ID,
	VP.VTA_ID,
	VT.SOAP_KEYWORD
FROM
	[EFR].VTA_PATIENT VP
	JOIN [EFR].VTA_PATIENT_SOAP_KEYWORD VT ON VP.VTA_ID = VT.VTA_ID

--DROP TABLE #VTASOAPKEYWORDDATA
CREATE TABLE  #VTASOAPKEYWORDDATA
	(PATIENT_ID int,
	VTA_ID int,
	SOAP_1 VARCHAR(100),
	SOAP_2 VARCHAR(100),
	SOAP_3 VARCHAR(100),
	SOAP_4 VARCHAR(100),
	SOAP_5 VARCHAR(100),
	SOAP_6 VARCHAR(100),
	SOAP_7 VARCHAR(100),
	SOAP_8 VARCHAR(100),
	SOAP_9 VARCHAR(100),
	SOAP_10 VARCHAR(100))

INSERT INTO #VTASOAPKEYWORDDATA	
SELECT PATIENT_ID,VTA_ID, [1] as SOAP_1,[2] as SOAP_2,[3] as SOAP_3,[4] as SOAP_4,
[5] as SOAP_5,[6] as SOAP_6,[7] as SOAP_7,[8] as SOAP_8, [9] as SOAP_9,[10] as SOAP_10

FROM 

(

SELECT *, ROW_NUMBER() OVER(PARTITION BY PATIENT_ID ORDER BY soap_keyword) AS ROWNUM

FROM #VTASOAPKEYWORD

) A

PIVOT

(

MAX(soap_keyword)

FOR ROWNUM IN ([1],[2],[3],[4],[5],[6],[7],[8],[9],[10])

)B

--DROP TABLE #VTASOAPDATA
CREATE TABLE  #VTASOAPDATA
	(PATIENT_ID INT,
	SOAP_1 VARCHAR(100),
	SOAP_2 VARCHAR(100),
	SOAP_3 VARCHAR(100),
	SOAP_4 VARCHAR(100),
	SOAP_5 VARCHAR(100),
	SOAP_6 VARCHAR(100),
	SOAP_7 VARCHAR(100),
	SOAP_8 VARCHAR(100),
	SOAP_9 VARCHAR(100),
	SOAP_10 VARCHAR(100),
	TotalSOAP INT)
	
INSERT INTO #VTASOAPDATA
SELECT
	 PATIENT_ID,
	 MAX(SOAP_1),
	 MAX(SOAP_2),
	 MAX(SOAP_3),
	 MAX(SOAP_4),
	 MAX(SOAP_5),
	 MAX(SOAP_6),
	 MAX(SOAP_7),
	 MAX(SOAP_8),
	 MAX(SOAP_9),
	 MAX(SOAP_10),
	 NULL
FROM
	#VTASOAPKEYWORDDATA
GROUP BY PATIENT_ID

--DROP TABLE #VTASOAPDATACOUNT
CREATE TABLE #VTASOAPDATACOUNT
	(PATIENT_ID int,
	TotalCOUNT INT)

INSERT INTO #VTASOAPDATACOUNT
SELECT PATIENT_ID,COUNT(*) AS TOTALCOUNT
FROM #VTASOAPKEYWORD
GROUP BY PATIENT_ID 

UPDATE 
	VT
SET
	VT.TotalSOAP = VC.TOTalCOUNT

FROM
	#VTASOAPDATA VT
	JOIN #VTASOAPDATACOUNT VC ON VT.PATIENT_ID = VC.PATIENT_ID
	
--**************************************************	
--GET DATA FOR ICD9_CODE

--DROP TABLE #VTAICD9
CREATE TABLE #VTAICD9
(
	PATIENT_ID INT,
	VTA_ID INT,
	ICD9_CODE VARCHAR(30)
)

INSERT INTO #VTAICD9
SELECT
	VP.PATIENT_ID,
	VP.VTA_ID,
	VT.ICD9_CODE
FROM
	[EFR].VTA_PATIENT VP
	JOIN [EFR].VTA_PATIENT_ICD9 VT ON VP.VTA_ID = VT.VTA_ID
	--JOIN [EFR].STD_ICD9 SI ON VT.ICD9_CODE = SI.CODE

--DROP TABLE #VTAICD9DATA
CREATE TABLE  #VTAICD9DATA
	(PATIENT_ID INT,
	VTA_ID INT,
	ICD9_1 VARCHAR(100),
	ICD9_2 VARCHAR(100),
	ICD9_3 VARCHAR(100),
	ICD9_4 VARCHAR(100),
	ICD9_5 VARCHAR(100),
	ICD9_6 VARCHAR(100),
	ICD9_7 VARCHAR(100),
	ICD9_8 VARCHAR(100),
	ICD9_9 VARCHAR(100),
	ICD9_10 VARCHAR(100),
	ICD9_11 VARCHAR(100),
	ICD9_12 VARCHAR(100),
	ICD9_13 VARCHAR(100),
	ICD9_14 VARCHAR(100),
	ICD9_15 VARCHAR(100),
	ICD9_16 VARCHAR(100),
	ICD9_17 VARCHAR(100),
	ICD9_18 VARCHAR(100),
	ICD9_19 VARCHAR(100),
	ICD9_20 VARCHAR(100),
	ICD9_21 VARCHAR(100),
	ICD9_22 VARCHAR(100),
	ICD9_23 VARCHAR(100),
	ICD9_24 VARCHAR(100),
	ICD9_25 VARCHAR(100),
	ICD9_26 VARCHAR(100),
	ICD9_27 VARCHAR(100),
	ICD9_28 VARCHAR(100),
	ICD9_29 VARCHAR(100),
	ICD9_30 VARCHAR(100))

INSERT INTO #VTAICD9DATA	
SELECT PATIENT_ID,VTA_ID, [1] AS ICD9_1,[2] AS ICD9_2,[3] AS ICD9_3,[4] AS ICD9_4,
[5] AS ICD9_5,[6] AS ICD9_6,[7] AS ICD9_7,[8] AS ICD9_8,
[9] AS ICD9_9,[10] AS ICD9_10,[11] AS ICD9_11,[12] AS ICD9_12,
[13] AS ICD9_13,[14] AS ICD9_14,[15] AS ICD9_15,[16] AS ICD9_16,
[17] AS ICD9_17,[18] AS ICD9_18,[19] AS ICD9_19,[20] AS ICD9_20,
[21] AS ICD9_21,[22] AS ICD9_22,[23] AS ICD9_23,[24] AS ICD9_24,
[25] AS ICD9_25,[26] AS ICD9_26,[27] AS ICD9_27,[28] AS ICD9_28,
[29] AS ICD9_29,[30] AS ICD9_30

FROM 

(

SELECT *, row_number() OVER(PARTITION BY patient_id ORDER BY ICD9_CODE) AS ROWNUM

FROM #VTAICD9

) A

PIVOT

(

MAX(ICD9_CODE)

FOR ROWNUM IN ([1],[2],[3],[4],[5],[6],[7],[8],[9],[10],[11],[12],[13],[14],[15],[16],
[17],[18],[19],[20],[21],[22],[23],[24],[25],[26],[27],[28],[29],[30])

)B

--DROP TABLE #VTAICD9CODEDATA
CREATE TABLE  #VTAICD9CODEDATA
	(PATIENT_ID INT,
	ICD9_1 VARCHAR(100),
	ICD9_2 VARCHAR(100),
	ICD9_3 VARCHAR(100),
	ICD9_4 VARCHAR(100),
	ICD9_5 VARCHAR(100),
	ICD9_6 VARCHAR(100),
	ICD9_7 VARCHAR(100),
	ICD9_8 VARCHAR(100),
	ICD9_9 VARCHAR(100),
	ICD9_10 VARCHAR(100),
	ICD9_11 VARCHAR(100),
	ICD9_12 VARCHAR(100),
	ICD9_13 VARCHAR(100),
	ICD9_14 VARCHAR(100),
	ICD9_15 VARCHAR(100),
	ICD9_16 VARCHAR(100),
	ICD9_17 VARCHAR(100),
	ICD9_18 VARCHAR(100),
	ICD9_19 VARCHAR(100),
	ICD9_20 VARCHAR(100),
	ICD9_21 VARCHAR(100),
	ICD9_22 VARCHAR(100),
	ICD9_23 VARCHAR(100),
	ICD9_24 VARCHAR(100),
	ICD9_25 VARCHAR(100),
	ICD9_26 VARCHAR(100),
	ICD9_27 VARCHAR(100),
	ICD9_28 VARCHAR(100),
	ICD9_29 VARCHAR(100),
	ICD9_30 VARCHAR(100),
	TOTAL_ICD9CODE INT)
	
INSERT INTO #VTAICD9CODEDATA
SELECT
	PATIENT_ID,
	MAX(ICD9_1),
	MAX(ICD9_2),
	MAX(ICD9_3),
	MAX(ICD9_4),
	MAX(ICD9_5),
	MAX(ICD9_6),
	MAX(ICD9_7),
	MAX(ICD9_8),
	MAX(ICD9_9),
	MAX(ICD9_10),
	MAX(ICD9_11),
	MAX(ICD9_12),
	MAX(ICD9_13),
	MAX(ICD9_14),
	MAX(ICD9_15),
	MAX(ICD9_16),
	MAX(ICD9_17),
	MAX(ICD9_18),
	MAX(ICD9_19),
	MAX(ICD9_20),
	MAX(ICD9_21),
	MAX(ICD9_22),
	MAX(ICD9_23),
	MAX(ICD9_24),
	MAX(ICD9_25),
	MAX(ICD9_26),
	MAX(ICD9_27),
	MAX(ICD9_28),
	MAX(ICD9_29),
	MAX(ICD9_30),
	NULL
FROM
	#VTAICD9DATA
GROUP BY
	PATIENT_ID

CREATE TABLE #VTAICD9DATACOUNT
	(PATIENT_ID INT,
	TotalCOUNT INT)

INSERT INTO #VTAICD9DATACOUNT
SELECT 
	PATIENT_ID,
	COUNT(*) AS TOTALCOUNT
FROM
	#VTAICD9
GROUP BY
	PATIENT_ID 

UPDATE 
	VT
SET
	VT.TOTAL_ICD9CODE = VC.TOTALCOUNT
FROM
	#VTAICD9CODEDATA VT
	JOIN #VTAICD9DATACOUNT VC ON VT.PATIENT_ID = VC.PATIENT_ID

--**********************************************	
--GET VTA PATIENT DATA
	
SELECT
	VP.PATIENTSSN
	,VP.PATIENTICN
	,VP.PATIENTNAME
	,VP.PATIENTADDRESS
	,VP.CITY
	,VP.STATE
	,VP.ZIP
	,VP.COUNTRY
	,VP.HOME_PHONE
	,VP.WORK_PHONE
	,VP.OEFOIFINDICATOR
	,VP.DATEOFBIRTH
	,VP.DATEOFDEATH
	,VP.GENDER_CODE
	,VP.SVCBRANCH_CODE
	--,VP.ISEFRPATIENT
	,CASE WHEN ISNULL(EFRVIEW.PATIENT_ID, 0) > 0 THEN 1 ELSE 0 END AS ISEFRPATIENT
	,VI.ICD9_1
	,SI1.Description_Text AS ICD9_1_DESC
	,VI.ICD9_2
	,SI2.Description_Text AS ICD9_2_DESC
	,VI.ICD9_3
	,SI3.Description_Text AS ICD9_3_DESC
	,VI.ICD9_4
	,SI4.Description_Text AS ICD9_4_DESC
	,VI.ICD9_5
	,SI5.Description_Text AS ICD9_5_DESC
	,VI.ICD9_6
	,SI6.Description_Text AS ICD9_6_DESC
	,VI.ICD9_7
	,SI7.Description_Text AS ICD9_7_DESC
	,VI.ICD9_8
	,SI8.Description_Text AS ICD9_8_DESC
	,VI.ICD9_9
	,SI9.Description_Text AS ICD9_9_DESC
	,VI.ICD9_10
	,SI10.Description_Text AS ICD9_10_DESC
	,VI.ICD9_11
	,SI11.Description_Text AS ICD9_11_DESC
	,VI.ICD9_12
	,SI12.Description_Text AS ICD9_12_DESC
	,VI.ICD9_13
	,SI13.Description_Text AS ICD9_13_DESC
	,VI.ICD9_14
	,SI14.Description_Text AS ICD9_14_DESC
	,VI.ICD9_15
	,SI15.Description_Text AS ICD9_15_DESC
	,VI.ICD9_16
	,SI16.Description_Text AS ICD9_16_DESC
	,VI.ICD9_17
	,SI17.Description_Text AS ICD9_17_DESC
	,VI.ICD9_18
	,SI18.Description_Text AS ICD9_18_DESC
	,VI.ICD9_19
	,SI19.Description_Text AS ICD9_19_DESC
	,VI.ICD9_20
	,SI20.Description_Text AS ICD9_20_DESC
	,VI.ICD9_21
	,SI21.Description_Text AS ICD9_21_DESC
	,VI.ICD9_22
	,SI22.Description_Text AS ICD9_22_DESC
	,VI.ICD9_23
	,SI23.Description_Text AS ICD9_23_DESC
	,VI.ICD9_24
	,SI24.Description_Text AS ICD9_24_DESC
	,VI.ICD9_25
	,SI25.Description_Text AS ICD9_25_DESC
	,VI.ICD9_26
	,SI26.Description_Text AS ICD9_26_DESC
	,VI.ICD9_27
	,SI27.Description_Text AS ICD9_27_DESC
	,VI.ICD9_28
	,SI28.Description_Text AS ICD9_28_DESC
	,VI.ICD9_29
	,SI29.Description_Text AS ICD9_29_DESC
	,VI.ICD9_30
	,SI30.Description_Text AS ICD9_30_DESC
	,VI.TOTAL_ICD9CODE
	,VS.SOAP_1
	,VS.SOAP_2
	,VS.SOAP_3
	,VS.SOAP_4
	,VS.SOAP_5
	,VS.SOAP_6
	,VS.SOAP_7
	,VS.SOAP_8
	,VS.SOAP_9
	,VS.SOAP_10
	,VS.TotalSOAP
FROM
	[EFR].[VTA_PATIENT] VP
	LEFT JOIN [EFR].[VIEW_EFR_PATIENT] EFRVIEW ON VP.Patient_ID = EFRVIEW.PATIENT_ID
	LEFT JOIN #VTASOAPDATA VS ON VP.PATIENT_ID = VS.PATIENT_ID
	LEFT JOIN #VTAICD9CODEDATA VI ON VP.PATIENT_ID = VI.PATIENT_ID
	LEFT JOIN [EFR].[STD_ICD9] SI1 ON VI.ICD9_1 = SI1.CODE
	LEFT JOIN [EFR].[STD_ICD9] SI2 ON VI.ICD9_2 = SI2.CODE
	LEFT JOIN [EFR].[STD_ICD9] SI3 ON VI.ICD9_3 = SI3.CODE
	LEFT JOIN [EFR].[STD_ICD9] SI4 ON VI.ICD9_4 = SI4.CODE
	LEFT JOIN [EFR].[STD_ICD9] SI5 ON VI.ICD9_5 = SI5.CODE
	LEFT JOIN [EFR].[STD_ICD9] SI6 ON VI.ICD9_6 = SI6.CODE
	LEFT JOIN [EFR].[STD_ICD9] SI7 ON VI.ICD9_7 = SI7.CODE
	LEFT JOIN [EFR].[STD_ICD9] SI8 ON VI.ICD9_8 = SI8.CODE
	LEFT JOIN [EFR].[STD_ICD9] SI9 ON VI.ICD9_9 = SI9.CODE
	LEFT JOIN [EFR].[STD_ICD9] SI10 ON VI.ICD9_10 = SI10.CODE
	LEFT JOIN [EFR].[STD_ICD9] SI11 ON VI.ICD9_11 = SI11.CODE
	LEFT JOIN [EFR].[STD_ICD9] SI12 ON VI.ICD9_12 = SI12.CODE
	LEFT JOIN [EFR].[STD_ICD9] SI13 ON VI.ICD9_13 = SI13.CODE
	LEFT JOIN [EFR].[STD_ICD9] SI14 ON VI.ICD9_14 = SI14.CODE
	LEFT JOIN [EFR].[STD_ICD9] SI15 ON VI.ICD9_15 = SI15.CODE
	LEFT JOIN [EFR].[STD_ICD9] SI16 ON VI.ICD9_16 = SI16.CODE
	LEFT JOIN [EFR].[STD_ICD9] SI17 ON VI.ICD9_17 = SI17.CODE
	LEFT JOIN [EFR].[STD_ICD9] SI18 ON VI.ICD9_18 = SI18.CODE
	LEFT JOIN [EFR].[STD_ICD9] SI19 ON VI.ICD9_19 = SI19.CODE
	LEFT JOIN [EFR].[STD_ICD9] SI20 ON VI.ICD9_20 = SI20.CODE
	LEFT JOIN [EFR].[STD_ICD9] SI21 ON VI.ICD9_21 = SI21.CODE
	LEFT JOIN [EFR].[STD_ICD9] SI22 ON VI.ICD9_22 = SI22.CODE
	LEFT JOIN [EFR].[STD_ICD9] SI23 ON VI.ICD9_23 = SI23.CODE
	LEFT JOIN [EFR].[STD_ICD9] SI24 ON VI.ICD9_24 = SI24.CODE
	LEFT JOIN [EFR].[STD_ICD9] SI25 ON VI.ICD9_25 = SI25.CODE
	LEFT JOIN [EFR].[STD_ICD9] SI26 ON VI.ICD9_26 = SI26.CODE
	LEFT JOIN [EFR].[STD_ICD9] SI27 ON VI.ICD9_27 = SI27.CODE
	LEFT JOIN [EFR].[STD_ICD9] SI28 ON VI.ICD9_28 = SI28.CODE
	LEFT JOIN [EFR].[STD_ICD9] SI29 ON VI.ICD9_29 = SI29.CODE
	LEFT JOIN [EFR].[STD_ICD9] SI30 ON VI.ICD9_30 = SI30.CODE
	
	
DROP TABLE #VTASOAPKEYWORD
DROP TABLE #VTASOAPKEYWORDDATA
DROP TABLE #VTASOAPDATA
DROP TABLE #VTASOAPDATACOUNT
DROP TABLE #VTAICD9
DROP TABLE #VTAICD9DATA
DROP TABLE #VTAICD9CODEDATA
DROP TABLE #VTAICD9DATACOUNT


GO



begin
INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('05'
           ,'00'
           ,'056'
           ,0
           ,'EFR Tracker #1601: The "VTA Data Extract" Export is not updating the "ISEFRPATIENT" column'
		   ,'Create a new view [EFR].[VIEW_EFR_PATIENT] and modify the stored procedure [EFRDataExportVTADataExtract] to retrieve ISEFRPATIENT correctly'
           ,'EFR'
           ,GETDATE())
end
GO

