/*
	Sherry Wang   5/31/2012
	Tracker #1315: DoD Fragment Data (.net) 
	Alter column [EFR].[DOD_FRAGMENT].[TISSUE_SENT_FLAG] to a nullable field.
*/


IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_DOD_FRAGMENT_TISSUE_SENT_FLAG]') AND type = 'D')
BEGIN
ALTER TABLE [EFR].[DOD_FRAGMENT] DROP CONSTRAINT [DF_DOD_FRAGMENT_TISSUE_SENT_FLAG]
END

GO

if exists(select name from sys.columns where OBJECT_NAME(object_id) ='DOD_FRAGMENT' and name='TISSUE_SENT_FLAG')
begin
	ALTER TABLE [EFR].[DOD_FRAGMENT]
	ALTER COLUMN [TISSUE_SENT_FLAG] [bit] NULL
	
end

GO


/******************************************************
Description:   Stored Procedure for EFR Data Export.
			   Export Name - DoD Fragment Data.	  		   
*******************************************************/

ALTER PROCEDURE [dbo].[EFRDataExportDoDFragmentData]

AS

--**************************************
--GET DoD FRAGMENT DATA

SELECT
	P.SSN AS PATIENT_SSN,
	ISNULL(P.LAST_NAME, '') + ', ' + ISNULL(P.FIRST_NAME, '') + ' ' + ISNULL(P.MIDDLE_NAME, '') AS PATIENT_NAME,
	L.LAB_NAME,
	L.LAB_REPORT_DATE,
	L.LAB_ACCESSION_NUMBER,
	L.LAB_CODE,
	L.LAB_ID,
	L.PRODUCING_EVENT_DATE,
	F.FRAGMENT_ID_NUMBER,
	F.FRAGMENT_DESCRIPTION, 
	F.MASS AS FRAGMENT_MASS,
	F.MASS_UNITS,
	F.[LENGTH] AS FRAGMENT_LENGTH,
	F.LENGTH_UNITS,
	F.HEIGHT AS FRAGMENT_HEIGHT,
	F.HEIGHT_UNITS,
	F.WIDTH AS FRAGMENT_WIDTH,
	F.WIDTH_UNITS,
	F.RADIOACTIVEINDICATOR AS RADIOACTIVE_INDICATOR,
	F.RADIOACTIVERESULTS AS RADIOACTIVE_RESULTS,
	F.COMMENTS AS FRAGMENT_COMMENTS,
	CASE WHEN F.TISSUE_SENT_FLAG = 1 THEN 'True' 
	     WHEN F.TISSUE_SENT_FLAG = 0 THEN 'False' ELSE '' END AS TISSUE_SENT_INDICATOR,
	F.TISSUE_ASSOCIATED_WITH_FRAGMENT AS TISSUE_ASSOCIATED_WITH_FRAGMENT_DETAILS,
	D.ANALYTE,
	D.OTHER_ANALYTE AS OTHER_ANALYTE_DESCRIPTION,
	D.ANALYSIS_METHOD,
	T.NAME AS ANALYSIS_TYPE,
	D.RESULT,
	D.COMMENTS AS ANALYTE_COMMENTS,
	DAT.ORIGINALDATARECEIVEDDATE AS ORIGINAL_FRAGMENT_DATA_RECEIVED_DATE
FROM 
	[DBO].[PATIENT] P
	INNER JOIN [EFR].[DoD_FRAGMENT_LAB] L ON
		P.PATIENT_ID = L.PATIENT_ID 
	LEFT OUTER JOIN [EFR].[DoD_FRAGMENT] F ON 
		L.DOD_FRAGMENT_LAB_ID = F.DOD_FRAGMENT_LAB_ID 
	LEFT OUTER JOIN [EFR].[DOD_FRAGMENT_DETAIL] D ON
		F.DOD_FRAGMENT_ID = D.DOD_FRAGMENT_ID
	LEFT OUTER JOIN [EFR].[STD_FRAGMENT_ANALYSIS_TYPE] T ON
		D.STD_FRAGMENT_ANALYSIS_TYPE_ID = T.ID
	INNER JOIN (SELECT MIN(ORIGINALINPUTDATE) AS ORIGINALDATARECEIVEDDATE, PATIENTSSN
				  FROM [EFR].[DoD_FRAGMENT_DATA_RECEIVELOG] 
				  GROUP BY PATIENTSSN) DAT ON 
		P.SSN = DAT.PATIENTSSN
ORDER BY P.SSN, L.LAB_NAME, F.FRAGMENT_DESCRIPTION, D.ANALYTE



GO



begin

  Insert into [dbo].[DatabaseChangeLog]
      ([MajorReleaseNumber]
       , [MinorReleaseNumber]
       , [PointReleaseNumber]
       , [Hotfix]
       , [ScriptName]
       , [ScriptDescription]
       , [TargetRegistry]
       , [DateApplied])
  Values
      ('05'
       ,'00'
       ,'054'
       ,0
       ,'Tracker #1315: DoD Fragment Data (.net)'
       ,'Alter column [EFR].[DOD_FRAGMENT].[TISSUE_SENT_FLAG] to a nullable field.'
       ,'EFR'
      ,GETDATE())

End
