
--Vitas bug tracker 1491
--V.Naik --05/02/2012
--ALTER TABLE [dbo].[PROVIDER_H]
--The script will create column NTUSERNAME on table PROVIDER_H.
--The script will alter trigger [dbo].[TRG_PROVIDER_DEL_H] and [dbo].[TRG_PROVIDER_H] on PROVIDER table.

ALTER TABLE [dbo].[PROVIDER_H]
ADD NTUSERNAME VARCHAR(30) NULL

GO

ALTER TRIGGER  [dbo].[TRG_PROVIDER_DEL_H]
on  [dbo].[PROVIDER] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [dbo].[PROVIDER_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [PROVIDER_ID]
, [STD_INSTITUTION_ID]
, [VPID_NUMBER]
, [SSN]
, [DSN_NUMBER]
, [NPI_NUMBER]
, [FIRST_NAME]
, [MIDDLE_NAME]
, [LAST_NAME]
, [ADDRESS_LINE1]
, [ADDRESS_LINE2]
, [ADDRESS_LINE3]
, [CITY]
, [STATE]
, [COUNTY]
, [COUNTRY]
, [POSTAL_CODE]
, [ZIP_PLUS_4]
, [HOME_PHONE]
, [WORK_PHONE]
, [EMAIL_ADDRESS]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [FAX_NUMBER]
, [STAFFIEN]
, [PROVIDER_CLASS]
, [STA3N]
, [NTUSERNAME]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [PROVIDER_ID]
, [STD_INSTITUTION_ID]
, [VPID_NUMBER]
, [SSN]
, [DSN_NUMBER]
, [NPI_NUMBER]
, [FIRST_NAME]
, [MIDDLE_NAME]
, [LAST_NAME]
, [ADDRESS_LINE1]
, [ADDRESS_LINE2]
, [ADDRESS_LINE3]
, [CITY]
, [STATE]
, [COUNTY]
, [COUNTRY]
, [POSTAL_CODE]
, [ZIP_PLUS_4]
, [HOME_PHONE]
, [WORK_PHONE]
, [EMAIL_ADDRESS]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [FAX_NUMBER]
, [STAFFIEN]
, [PROVIDER_CLASS]
, [STA3N]
, [NTUSERNAME]

From Deleted
End

GO


ALTER trigger [dbo].[TRG_PROVIDER_H] on [dbo].[PROVIDER]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [dbo].[PROVIDER_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [PROVIDER_ID]
, [STD_INSTITUTION_ID]
, [VPID_NUMBER]
, [SSN]
, [DSN_NUMBER]
, [NPI_NUMBER]
, [FIRST_NAME]
, [MIDDLE_NAME]
, [LAST_NAME]
, [ADDRESS_LINE1]
, [ADDRESS_LINE2]
, [ADDRESS_LINE3]
, [CITY]
, [STATE]
, [COUNTY]
, [COUNTRY]
, [POSTAL_CODE]
, [ZIP_PLUS_4]
, [HOME_PHONE]
, [WORK_PHONE]
, [EMAIL_ADDRESS]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [FAX_NUMBER]
, [STAFFIEN]
, [PROVIDER_CLASS]
, [STA3N]
, [NTUSERNAME]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [PROVIDER_ID]
, [STD_INSTITUTION_ID]
, [VPID_NUMBER]
, [SSN]
, [DSN_NUMBER]
, [NPI_NUMBER]
, [FIRST_NAME]
, [MIDDLE_NAME]
, [LAST_NAME]
, [ADDRESS_LINE1]
, [ADDRESS_LINE2]
, [ADDRESS_LINE3]
, [CITY]
, [STATE]
, [COUNTY]
, [COUNTRY]
, [POSTAL_CODE]
, [ZIP_PLUS_4]
, [HOME_PHONE]
, [WORK_PHONE]
, [EMAIL_ADDRESS]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [FAX_NUMBER]
, [STAFFIEN]
, [PROVIDER_CLASS]
, [STA3N]
, [NTUSERNAME]

FROM INSERTED
End

GO

begin
INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('05'
           ,'00'
           ,'050'
           ,0
           ,'Tracker #1491'
		   ,'The script will create column NTUSERNAME on table PROVIDER_H and also alter triggers on PROVIDER table.'
           ,'VITAS'
           ,GETDATE())
end
GO




