
--V.Naik 05/30/2012
--VITAS bug tracker 1491
--CREATE TABLE
--[VITAS].[VITAS_USERS_PROVIDERS_NO_MATCH_DATA] to store users provider no match data.
--CREATE following TABLES to store users, provider and provider role raw data.
--[VITAS].[VITAS_USERS_RAW_DATA]
--[VITAS].[VITAS_PROVIDER_USERS_RAW_DATA]
--[VITAS].[VITAS_PROVIDER_USERS_ROLES_RAW_DATA]

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VITAS].[VITAS_USERS_PROVIDERS_NO_MATCH_DATA]') AND type in (N'U'))
DROP TABLE [VITAS].[VITAS_USERS_PROVIDERS_NO_MATCH_DATA]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [VITAS].[VITAS_USERS_PROVIDERS_NO_MATCH_DATA](
	[VITAS_USERS_PROVIDERS_NOMATCH_ID] [int] IDENTITY(1,1) NOT NULL,
	[NTUSERNAME] [varchar](30) NOT NULL,
	[STATION_NUMBER] [smallint] NOT NULL,
	[FILENAME] [varchar](50) NULL,
	[RUNDATE] [datetime] NOT NULL,
	[ROW_VERSION] [timestamp] NOT NULL,
	[CREATEDBY] [varchar](30) NOT NULL,
	[CREATED] [datetime] NOT NULL,
	[UPDATEDBY] [varchar](30) NOT NULL,
	[UPDATED] [datetime] NOT NULL,
 CONSTRAINT [VITAS_USERS_PROVIDERS_NOMATCH_PK] PRIMARY KEY CLUSTERED 
(
	[VITAS_USERS_PROVIDERS_NOMATCH_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

ALTER TABLE [VITAS].[VITAS_USERS_PROVIDERS_NO_MATCH_DATA] ADD  CONSTRAINT [DF_VITAS_USERS_PROVIDERS_NO_MATCH_DATA_Created]  DEFAULT (getdate()) FOR [CREATED]
GO

ALTER TABLE [VITAS].[VITAS_USERS_PROVIDERS_NO_MATCH_DATA] ADD  CONSTRAINT [DF_VITAS_USERS_PROVIDERS_NO_MATCH_DATA_Updated]  DEFAULT (getdate()) FOR [UPDATED]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VITAS].[VITAS_USERS_RAW_DATA]') AND type in (N'U'))
DROP TABLE [VITAS].[VITAS_USERS_RAW_DATA]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [VITAS].[VITAS_USERS_RAW_DATA](
	[VITAS_USERS_RAW_DATA_ID] [int] IDENTITY(1,1) NOT NULL,
	[USERNAME] [varchar](30) NOT NULL,
	[FILE_DATA] [varbinary](max) NULL,
	[FILE_NAME] [nvarchar](260) NULL,
	[CONTENT_TYPE] [varchar](50) NOT NULL,
	[RUNDATE] [datetime] NOT NULL,
	[ROW_VERSION] [timestamp] NOT NULL,
	[CREATEDBY] [varchar](30) NOT NULL,
	[CREATED] [datetime] NOT NULL,
	[UPDATEDBY] [varchar](30) NOT NULL,
	[UPDATED] [datetime] NOT NULL,
 CONSTRAINT [VITAS_USERS_RAW_DATA_PK] PRIMARY KEY CLUSTERED 
(
	[VITAS_USERS_RAW_DATA_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

ALTER TABLE [VITAS].[VITAS_USERS_RAW_DATA] ADD  CONSTRAINT [DF_VITAS_USERS_RAW_DATA_Created]  DEFAULT (getdate()) FOR [CREATED]
GO

ALTER TABLE [VITAS].[VITAS_USERS_RAW_DATA] ADD  CONSTRAINT [DF_VITAS_USERS_RAW_DATA_Updated]  DEFAULT (getdate()) FOR [UPDATED]
GO


IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VITAS].[VITAS_PROVIDER_USERS_RAW_DATA]') AND type in (N'U'))
DROP TABLE [VITAS].[VITAS_PROVIDER_USERS_RAW_DATA]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [VITAS].[VITAS_PROVIDER_USERS_RAW_DATA](
	[VITAS_PROVIDER_USERS_RAW_DATA_ID] [int] IDENTITY(1,1) NOT NULL,
	[NTUSERNAME] [varchar](30) NOT NULL,
	[STATION_NUMBER] [smallint] NOT NULL,
	[FILE_DATA] [varbinary](max) NULL,
	[FILE_NAME] [nvarchar](260) NULL,
	[CONTENT_TYPE] [varchar](50) NOT NULL,
	[RUNDATE] [datetime] NOT NULL,
	[ROW_VERSION] [timestamp] NOT NULL,
	[CREATEDBY] [varchar](30) NOT NULL,
	[CREATED] [datetime] NOT NULL,
	[UPDATEDBY] [varchar](30) NOT NULL,
	[UPDATED] [datetime] NOT NULL,
 CONSTRAINT [VITAS_PROVIDER_USERS_RAW_DATA_PK] PRIMARY KEY CLUSTERED 
(
	[VITAS_PROVIDER_USERS_RAW_DATA_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

ALTER TABLE [VITAS].[VITAS_PROVIDER_USERS_RAW_DATA] ADD  CONSTRAINT [DF_VITAS_PROVIDER_USERS_RAW_DATA_Created]  DEFAULT (getdate()) FOR [CREATED]
GO

ALTER TABLE [VITAS].[VITAS_PROVIDER_USERS_RAW_DATA] ADD  CONSTRAINT [DF_VITAS_PROVIDER_USERS_RAW_DATA_Updated]  DEFAULT (getdate()) FOR [UPDATED]
GO



IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VITAS].[VITAS_PROVIDER_USERS_ROLES_RAW_DATA]') AND type in (N'U'))
DROP TABLE [VITAS].[VITAS_PROVIDER_USERS_ROLES_RAW_DATA]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [VITAS].[VITAS_PROVIDER_USERS_ROLES_RAW_DATA](
	[VITAS_PROVIDER_USERS_ROLES_RAW_DATA_ID] [int] IDENTITY(1,1) NOT NULL,
	[NTUSERNAME] [varchar](30) NOT NULL,
	[STATION_NUMBER] [smallint] NOT NULL,
	[FILE_DATA] [varbinary](max) NULL,
	[FILE_NAME] [nvarchar](260) NULL,
	[CONTENT_TYPE] [varchar](50) NOT NULL,
	[RUNDATE] [datetime] NOT NULL,
	[ROW_VERSION] [timestamp] NOT NULL,
	[CREATEDBY] [varchar](30) NOT NULL,
	[CREATED] [datetime] NOT NULL,
	[UPDATEDBY] [varchar](30) NOT NULL,
	[UPDATED] [datetime] NOT NULL,
 CONSTRAINT [VITAS_PROVIDER_ROLES_RAW_DATA_PK] PRIMARY KEY CLUSTERED 
(
	[VITAS_PROVIDER_USERS_ROLES_RAW_DATA_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

ALTER TABLE [VITAS].[VITAS_PROVIDER_USERS_ROLES_RAW_DATA] ADD  CONSTRAINT [DF_VITAS_PROVIDER_ROLES_RAW_DATA_Created]  DEFAULT (getdate()) FOR [CREATED]
GO

ALTER TABLE [VITAS].[VITAS_PROVIDER_USERS_ROLES_RAW_DATA] ADD  CONSTRAINT [DF_VITAS_PROVIDER_ROLES_RAW_DATA_Updated]  DEFAULT (getdate()) FOR [UPDATED]
GO


begin

  Insert into [dbo].[DatabaseChangeLog]
      ([MajorReleaseNumber]
       , [MinorReleaseNumber]
       , [PointReleaseNumber]
       , [Hotfix]
       , [ScriptName]
       , [ScriptDescription]
       , [TargetRegistry]
       , [DateApplied])
  Values
      ('05'
       ,'00'
       ,'049'
       ,0
       ,'Tracker #1491'
       ,'The script will create table to store users provider no match data and also to store users, providers and provider user roles raw data from file.'
       ,'VITAS'
      ,GETDATE())

End





