--V.Naik 05/30/2012
--VITAS bug tracker 1484
--CREATE TABLEs
--[VITAS].[IM_RECALL_CPRS_POSTING_NOTES] TABLE to store data for CPRS posting notes.
--[VITAS].[STD_IM_RECALL_CPRS_POSTING_NOTES] to store Standard Notes.

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VITAS].[IM_RECALL_CPRS_POSTING_NOTES]') AND type in (N'U'))
DROP TABLE [VITAS].[IM_RECALL_CPRS_POSTING_NOTES]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING OFF
GO

CREATE TABLE [VITAS].[IM_RECALL_CPRS_POSTING_NOTES](
	[POSTING_NOTES_ID] [int] IDENTITY(1,1) NOT NULL,
	[PATIENT_ID] [int] NULL,
	[PATIENT_IEN] [varchar](50) NULL,
	[STA3N] [smallint] NULL,
	[RECALL_NOTE_ID] [int] NULL,
	[IMPLANT_ID] [int] NULL,
	[EXPLANT_ID] [int] NULL,
	[IMPLANT_TYPE] [varchar](255) NOT NULL,
	[IMPLANT_ITEM_NAME] [varchar](150) NULL,
	[SERIAL_NUMBER] [varchar](50) NULL,
	[MODEL_NUMBER] [varchar](100) NULL,
	[LOT_NUMBER] [varchar](50) NULL,
	[MANUFACTURER/DISTRIBUTOR] [varchar](100) NULL,
	[IMPLANT_ALERT_FLAG] [bit] NOT NULL,
	[SPECIALTY] [varchar](150) NULL,
	--[,REPLACE(S.Name,'NULL VALUE',IM.SPECIALTY_AREA) AS Specialty
	[RECALL_ID] [int] NOT NULL,
	[SOURCE_RECALL_ID] [varchar](50) NULL, 
	[RECALL_LETTER_URL] [varchar](500) NULL,
	[TARGET_DATE] [varchar](50) NULL,
	--,IM.STD_IM_NOTIFICATION_STATUS_ID
	--,NS.Name AS Notication_status
	[NOTE_TEXT] [varchar](2000) NOT NULL,
	[STD_IM_DEVICE_STATUS_ID] [int] NULL,
	[DATE_RECALL_ACTION_REQUIRED_POSTINGNOTE_SENT] [datetime] NULL,
	[DATE_RECALL_ACTIONCOMPLETE_POSTINGNOTE_SENT] [datetime] NULL,
	[DATE_RECALL_RESOLVED_POSTINGNOTE_SENT] [datetime] NULL,
	[POSTING_NOTES_SENT_FLAG] [bit] NULL,
	[ETL_PROCESS_NOTES] [varchar](500) NULL,
	[ROW_VERSION] [timestamp] NOT NULL,
	[CREATED] [datetime] NOT NULL,
	[CREATEDBY] [varchar](30) NOT NULL,
	[UPDATED] [datetime] NOT NULL,
	[UPDATEDBY] [varchar](30) NOT NULL,
 CONSTRAINT [IM_RECALL_CPRS_POSTING_NOTES_PK] PRIMARY KEY CLUSTERED 
(
	[POSTING_NOTES_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

ALTER TABLE [VITAS].[IM_RECALL_CPRS_POSTING_NOTES] ADD  CONSTRAINT [DF_IM_RECALL_CPRS_POSTING_NOTES_SENT_FLAG]  DEFAULT ((0)) FOR [POSTING_NOTES_SENT_FLAG]
GO

ALTER TABLE [VITAS].[IM_RECALL_CPRS_POSTING_NOTES] ADD  CONSTRAINT [DF_IM_RECALL_CPRS_POSTING_NOTES_CREATED]  DEFAULT (getdate()) FOR [CREATED]
GO

ALTER TABLE [VITAS].[IM_RECALL_CPRS_POSTING_NOTES] ADD  CONSTRAINT [DF_IM_RECALL_CPRS_POSTING_NOTES_UPDATED]  DEFAULT (getdate()) FOR [UPDATED]
GO


IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VITAS].[STD_IM_RECALL_CPRS_POSTING_NOTES]') AND type in (N'U'))
DROP TABLE [VITAS].[STD_IM_Recall_CPRS_POSTING_NOTES]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [VITAS].[STD_IM_RECALL_CPRS_POSTING_NOTES](
	[RECALL_NOTE_ID] [int] IDENTITY(1,1) NOT NULL,
	[NOTE_TEXT] [varchar](500) NOT NULL,
	[SORT_ORDER] [int] NOT NULL,
	[INACTIVE_FLAG] [bit] NOT NULL,
	[INACTIVE_DATE] [datetime] NULL,
	[CREATEDBY] [varchar](30) NOT NULL,
	[CREATED] [datetime] NOT NULL,
	[UPDATEDBY] [varchar](30) NOT NULL,
	[UPDATED] [datetime] NOT NULL,
	[ROW_VERSION] [timestamp] NOT NULL,
 CONSTRAINT [PK_STD_IM_RECALL_CPRS_POSTING_NOTES] PRIMARY KEY CLUSTERED 
(
	[RECALL_NOTE_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

ALTER TABLE [VITAS].[STD_IM_RECALL_CPRS_POSTING_NOTES] ADD  CONSTRAINT [DF_STD_IM_RECALL_CPRS_POSTING_NOTES_INACTIVE_FLAG]  DEFAULT ((0)) FOR [INACTIVE_FLAG]
GO

ALTER TABLE [VITAS].[STD_IM_RECALL_CPRS_POSTING_NOTES] ADD  CONSTRAINT [DF_STD_IM_RECALL_CPRS_POSTING_NOTES_CREATED]  DEFAULT (getdate()) FOR [CREATED]
GO

ALTER TABLE [VITAS].[STD_IM_RECALL_CPRS_POSTING_NOTES] ADD  CONSTRAINT [DF_STD_IM_RECALL_CPRS_POSTING_NOTES_UPDATED]  DEFAULT (getdate()) FOR [UPDATED]
GO

INSERT INTO [VITAS].[STD_IM_RECALL_CPRS_POSTING_NOTES]
(      [NOTE_TEXT]
      ,[SORT_ORDER]
      --,[INACTIVE_FLAG]
      --,[INACTIVE_DATE]
      ,[CREATEDBY]
      --,[CREATED]
      ,[UPDATEDBY])
      --,[UPDATED]
      --,[ROW_VERSION])
SELECT 
       'Action Required.' 
      ,1
      --,[INACTIVE_FLAG]
      --,[INACTIVE_DATE]
      ,'Initial_Load'
      ,'Initial_Load'
      
GO
      
      INSERT INTO [VITAS].[STD_IM_RECALL_CPRS_POSTING_NOTES]
(      [NOTE_TEXT]
      ,[SORT_ORDER]
      --,[INACTIVE_FLAG]
      --,[INACTIVE_DATE]
      ,[CREATEDBY]
      --,[CREATED]
      ,[UPDATEDBY])
      --,[UPDATED]
      --,[ROW_VERSION])
SELECT 
       'Action Complete with Ongoing Monitoring.' 
      ,2
      --,[INACTIVE_FLAG]
      --,[INACTIVE_DATE]
     ,'Initial_Load'
     ,'Initial_Load'
     
     GO
      
      INSERT INTO [VITAS].[STD_IM_RECALL_CPRS_POSTING_NOTES]
(      [NOTE_TEXT]
      ,[SORT_ORDER]
      --,[INACTIVE_FLAG]
      --,[INACTIVE_DATE]
      ,[CREATEDBY]
      --,[CREATED]
      ,[UPDATEDBY])
      --,[UPDATED]
      --,[ROW_VERSION])
SELECT 
       'Resolved.' 
      ,3
      --,[INACTIVE_FLAG]
      --,[INACTIVE_DATE]
     ,'Initial_Load'
     ,'Initial_Load'
     
GO
     

begin

  Insert into [dbo].[DatabaseChangeLog]
      ([MajorReleaseNumber]
       , [MinorReleaseNumber]
       , [PointReleaseNumber]
       , [Hotfix]
       , [ScriptName]
       , [ScriptDescription]
       , [TargetRegistry]
       , [DateApplied])
  Values
      ('05'
       ,'00'
       ,'048'
       ,0
       ,'Tracker #1484'
       ,'The script will create tables to transmit Recall Indicator to Vista/CPRS.'
       ,'VITAS'
      ,GETDATE())

End