
--V.Naik 05/30/2012
--VITAS bug tracker 1483
--CREATE TABLEs
--[VITAS].[STD_IM_IMPLANT_CPRS_POSTING_NOTES] to store Standard Notes.
--[VITAS].[IM_IMPLANT_CPRS_POSTING_NOTES] TABLE to store data for implant CPRS posting notes.

--CREATE TABLE [VITAS].[STD_IM_IMPLANT_CPRS_POSTING_NOTES]

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VITAS].[STD_IM_IMPLANT_CPRS_POSTING_NOTES]') AND type in (N'U'))
DROP TABLE [VITAS].[STD_IM_IMPLANT_CPRS_POSTING_NOTES]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [VITAS].[STD_IM_IMPLANT_CPRS_POSTING_NOTES](
	[NOTE_ID] [int] IDENTITY(1,1) NOT NULL,
	[NOTE_TEXT] [varchar](500) NOT NULL,
	[SORT_ORDER] [int] NOT NULL,
	[INACTIVE_FLAG] [bit] NOT NULL,
	[INACTIVE_DATE] [datetime] NULL,
	[CREATEDBY] [varchar](30) NOT NULL,
	[CREATED] [datetime] NOT NULL,
	[UPDATEDBY] [varchar](30) NOT NULL,
	[UPDATED] [datetime] NOT NULL,
	[ROW_VERSION] [timestamp] NOT NULL,
 CONSTRAINT [PK_STD_IM_IMPLANT_CPRS_POSTING_NOTES] PRIMARY KEY CLUSTERED 
(
	[NOTE_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

ALTER TABLE [VITAS].[STD_IM_IMPLANT_CPRS_POSTING_NOTES] ADD  CONSTRAINT [DF_STD_IM_IMPLANT_CPRS_POSTING_NOTES_INACTIVE_FLAG]  DEFAULT ((0)) FOR [INACTIVE_FLAG]
GO

ALTER TABLE [VITAS].[STD_IM_IMPLANT_CPRS_POSTING_NOTES] ADD  CONSTRAINT [DF_STD_IM_IMPLANT_CPRS_POSTING_NOTES_CREATED]  DEFAULT (getdate()) FOR [CREATED]
GO

ALTER TABLE [VITAS].[STD_IM_IMPLANT_CPRS_POSTING_NOTES] ADD  CONSTRAINT [DF_STD_IM_IMPLANT_CPRS_POSTING_NOTES_UPDATED]  DEFAULT (getdate()) FOR [UPDATED]
GO


INSERT INTO [VITAS].[STD_IM_IMPLANT_CPRS_POSTING_NOTES]
(      [NOTE_TEXT]
      ,[SORT_ORDER]
      --,[INACTIVE_FLAG]
      --,[INACTIVE_DATE]
      ,[CREATEDBY]
      --,[CREATED]
      ,[UPDATEDBY])
      --,[UPDATED]
      --,[ROW_VERSION])
SELECT 
       'This patient has implant. Please refer to VITAS for details.' 
      ,1
      --,[INACTIVE_FLAG]
      --,[INACTIVE_DATE]
      ,'Initial_Load'
      ,'Initial_Load'
      
GO
      
      INSERT INTO [VITAS].[STD_IM_IMPLANT_CPRS_POSTING_NOTES]
(      [NOTE_TEXT]
      ,[SORT_ORDER]
      --,[INACTIVE_FLAG]
      --,[INACTIVE_DATE]
      ,[CREATEDBY]
      --,[CREATED]
      ,[UPDATEDBY])
      --,[UPDATED]
      --,[ROW_VERSION])
SELECT 
       'This patient''s implant explanted. Please refer to VITAS for details.' 
      ,2
      --,[INACTIVE_FLAG]
      --,[INACTIVE_DATE]
     ,'Initial_Load'
     ,'Initial_Load'
     
 GO
 
 IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VITAS].[IM_IMPLANT_CPRS_POSTING_NOTES]') AND type in (N'U'))
DROP TABLE [VITAS].[IM_IMPLANT_CPRS_POSTING_NOTES]
GO

CREATE TABLE [VITAS].[IM_IMPLANT_CPRS_POSTING_NOTES] 
(
	 [POSTING_NOTES_ID] [int] IDENTITY(1,1) NOT NULL,
	 PATIENT_ID INT
	,PATIENT_IEN VARCHAR(50)
	,STA3N SMALLINT
	,POSTING_NOTEID INT
	,IMPLANT_ID INT
	,EXPLANT_ID INT
	,STD_IM_DEVICE_STATUS_ID INT
	,DATE_IMPLANT_POSTINGNOTE_SENT DATETIME
	,DATE_EXPLANT_POSTINGNOTE_SENT DATETIME
	,POSTING_NOTES_SENT_FLAG BIT CONSTRAINT [DF_IMPLANT_CPRS_POSTING_NOTES_SENT_FLAG]  DEFAULT ((0))
	,ETL_PROCESS_NOTES VARCHAR(500)
	,ROW_VERSION timestamp NOT NULL
	,CREATED DATETIME NOT NULL
	,CREATEDBY VARCHAR(30) NOT NULL
	,UPDATED datetime NOT NULL
	,UPDATEDBY VARCHAR(30) NOT NULL,

 CONSTRAINT [IM_IMPLANT_CPRS_POSTING_NOTES_PK] PRIMARY KEY CLUSTERED 
(
	[POSTING_NOTES_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO


ALTER TABLE [VITAS].[IM_IMPLANT_CPRS_POSTING_NOTES] ADD  CONSTRAINT [DF_IM_IMPLANT_CPRS_POSTING_NOTES_CREATED]  DEFAULT (getdate()) FOR [CREATED]
GO

ALTER TABLE [VITAS].[IM_IMPLANT_CPRS_POSTING_NOTES] ADD  CONSTRAINT [DF_IM_IMPLANT_CPRS_POSTING_NOTES_UPDATED]  DEFAULT (getdate()) FOR [UPDATED]
GO

GO
     
begin

  Insert into [dbo].[DatabaseChangeLog]
      ([MajorReleaseNumber]
       , [MinorReleaseNumber]
       , [PointReleaseNumber]
       , [Hotfix]
       , [ScriptName]
       , [ScriptDescription]
       , [TargetRegistry]
       , [DateApplied])
  Values
      ('05'
       ,'00'
       ,'047'
       ,0
       ,'Tracker #1483'
       ,'The script will create tables to transmit an implant indicator to VistA/CPRS.'
       ,'VITAS'
      ,GETDATE())

End
    


