/*   Sherry Wang  5/24/2012

	 VITAS Tracker #1560: Modify ETL Package EmailProviders.dtsx to use the modified version of PCP table 

	 1.  The new function [dbo].[GetVitasRecallProvider] will be called by the stored procedure [dbo].[usp_ETL_VITAS_SetRecallProviderIDs]
	 to find primary care physician or chief of staff for a new recalled implant item.
	 
	 The logic for determining who should be notified in case of a recall:
	 	PCP at the recalled implant surgery site
		  Chief of Staff at the recalled implant surgery site
				Patients PCP listed in the PCP table
					Chief of Staff at a location visited by the patient (PatientICNMaster table) 

	 2. The new stored procedure [dbo].[usp_ETL_VITAS_SetRecallProviderIDs] will be used by the ETL package EmailProviders.dtsx
	 to find primary care physician or chief of staff for each new recalled implant item.
	 
*/

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetVitasRecallProvider]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[GetVitasRecallProvider]
GO

CREATE FUNCTION [dbo].[GetVitasRecallProvider](
 @implantId int
)
RETURNS int
AS
BEGIN

  DECLARE @providerId int
  DECLARE @patientId int
  DECLARE @implantFacilityId int

  SET @providerId = NULL
  SET @patientId = NULL
  SET @implantFacilityId = NULL
 
  SELECT @patientId = B.PATIENT_ID, @implantFacilityId = B.STD_IMPLANT_FACILITY_ID
  FROM VITAS.IM_IMPLANT_ITEM A,
	   VITAS.IM_PATIENT_SURGERY B
  WHERE A.IM_PATIENT_SURGERY_ID = B.ID  AND A.ID = @implantId
  
  -- Find the PCP at the same location as the implant facility for the patient
  SELECT @providerId = A.PROVIDER_ID
  FROM dbo.PRIMARY_CARE_PHYSICIAN A,
	   dbo.PROVIDER B
  WHERE A.PROVIDER_ID = B.PROVIDER_ID
        AND A.PATIENT_ID = @patientId
		AND B.STD_INSTITUTION_ID = @implantFacilityId
		
  IF @providerId is NULL
  -- Find the Chief of Staff at the same location as the implant facility 
  BEGIN
	SELECT @providerId = C.PROVIDER_ID
	FROM dbo.PROVIDER_CLASS_DTL A, dbo.STD_PROVIDER_CLASS B,
		dbo.PROVIDER C
	WHERE A.STD_PROVIDER_CLASS_ID = B.ID
		AND A.PROVIDER_ID = C.PROVIDER_ID
		AND B.NAME = 'CHIEF OF STAFF'
		AND C.STD_INSTITUTION_ID = @implantFacilityId

	  IF @providerId is NULL
	  -- Find one PCP for the patient 
	  BEGIN
		  SELECT @providerId = B.PROVIDER_ID
		  FROM dbo.PRIMARY_CARE_PHYSICIAN A,
			   dbo.PROVIDER B
		  WHERE A.PROVIDER_ID = B.PROVIDER_ID
				AND A.PATIENT_ID = @patientId
				
		  IF @providerId is NULL
		  -- Find the Chief of Staff at the site that the patient once visited
		  BEGIN
			SELECT @providerId = B.PROVIDER_ID
			FROM dbo.PatientICNMaster A, 
				dbo.PROVIDER B, dbo.PROVIDER_CLASS_DTL C, 
				dbo.STD_PROVIDER_CLASS D
			WHERE A.Sta3n = B.STA3N AND B.PROVIDER_ID = C.PROVIDER_ID 
			  AND C.STD_PROVIDER_CLASS_ID = D.ID
			  AND D.NAME = 'CHIEF OF STAFF'
			  AND A.Patient_ID = @patientId
           END
	  END 
  END 

RETURN @providerId

END

GO


IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_ETL_VITAS_SetRecallProviderIDs]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_ETL_VITAS_SetRecallProviderIDs]
GO

CREATE PROCEDURE [dbo].[usp_ETL_VITAS_SetRecallProviderIDs]
AS
BEGIN
	UPDATE VITAS.IM_IMPLANT_ITEM
	SET PATIENT_LOCATION_PRIMARY_PROVIDER = dbo.GetVitasRecallProvider(ID)
	WHERE IMPLANT_ALERT_FLAG = 1 AND RECALL_EMAIL_PROCESSED is NULL
	
	-- Update the initial notification letter PROVIDER_ID column	
	UPDATE VITAS.IM_NOTIFICATION_LETTER 
	SET PROVIDER_ID = B.PATIENT_LOCATION_PRIMARY_PROVIDER
	FROM VITAS.IM_NOTIFICATION_LETTER A 
		INNER JOIN VITAS.IM_IMPLANT_ITEM B 
			ON A.IM_IMPLANT_ITEM_ID = B.ID
	WHERE A.PARENT_NOTIFICATION_LETTER_ID IS NULL
END



GO


begin

  Insert into [dbo].[DatabaseChangeLog]
      ([MajorReleaseNumber]
       , [MinorReleaseNumber]
       , [PointReleaseNumber]
       , [Hotfix]
       , [ScriptName]
       , [ScriptDescription]
       , [TargetRegistry]
       , [DateApplied])
  Values
      ('05'
       ,'00'
       ,'046'
       ,0
       ,'Tracker #1560: Modify ETL Package EmailProviders.dtsx to use the modified version of PCP table'
       ,'The stored procedure will be used to stamp recalled implant record with provider ID.'
       ,'VITAS'
      ,GETDATE())

End
