/*
    Sherry Wang 5/23/2012
	EFR Tracker #1315: DoD Fragment Data (.net)  
		- Add Analyte lookup values to [EFR].[VIEW_LOOKUP]
		- Delete Other Analysis Method from DBO.STD_GUI_CONTROLS table
		- Update Analyte record in DBO.STD_GUI_CONTROLS from Textbox to Dropdownlist
*/

ALTER VIEW [EFR].[VIEW_LOOKUP] WITH SCHEMABINDING AS
SELECT 'YESNO_NOTTESTED' AS LOOKUP_TYPE  
	   ,1 AS [ID]
       ,'Yes' AS [CODE]
       ,'Yes' AS [NAME]
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
UNION ALL
SELECT 'YESNO_NOTTESTED' AS LOOKUP_TYPE  
	   ,2 AS [ID]
       ,'No' AS [CODE]
       ,'No' AS [NAME]
       ,0 AS PARENT_ID
       ,2 AS SORT_ORDER
UNION ALL
SELECT 'YESNO_NOTTESTED' AS LOOKUP_TYPE  
	   ,3 AS [ID]
       ,'Not Tested' AS [CODE]
       ,'Not Tested' AS [NAME]
       ,0 AS PARENT_ID
       ,3 AS SORT_ORDER
UNION ALL
SELECT 'YESNO' AS LOOKUP_TYPE  
	   ,1 AS [ID]
       ,'Yes' AS [CODE]
       ,'Yes' AS [NAME]
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
UNION ALL
SELECT 'YESNO' AS LOOKUP_TYPE  
	   ,2 AS [ID]
       ,'No' AS [CODE]
       ,'No' AS [NAME]
       ,0 AS PARENT_ID
       ,2 AS SORT_ORDER
UNION ALL
SELECT 'DOD_ANALYTE_TYPE' AS LOOKUP_TYPE
	   , ID
	   , CODE
	   , NAME
	   , 0 AS PARENT_ID
	   , CASE upper([NAME]) 
		WHEN 'OTHER' THEN 9999	
		WHEN 'NONE' THEN 10000	
		ELSE 0 END  AS SORT_ORDER
FROM  EFR.STD_FRAGMENT_ANALYSIS_TYPE
UNION ALL
SELECT 'DOD_ANALYTE' AS LOOKUP_TYPE
	   , ID
	   , CODE
	   , NAME
	   , 0 AS PARENT_ID
	   , CASE upper([NAME]) 
		WHEN 'OTHER' THEN 9999	
		WHEN 'NONE' THEN 10000	
		ELSE 0 END  AS SORT_ORDER
FROM  EFR.STD_ANALYTETYPE
WHERE (FRAGMENT_FLAG = 1) AND (INACTIVE_FLAG = 0)

GO

DELETE FROM  DBO.STD_GUI_CONTROLS WHERE ID = 50

UPDATE dbo.STD_GUI_CONTROLS 
SET BASE_CONTROL_TYPE = 4, USER_CONTROL_ID = 'BaseControlDropdownListAnalyte',
	LOOKUP_LIST_CATEGORY = 'DOD_ANALYTE', DATA_ELEMENT_WIDTH = NULL, DATA_TYPE_MAX_LENGTH = NULL
WHERE ID = 47

begin

  Insert into [dbo].[DatabaseChangeLog]
      ([MajorReleaseNumber]
       , [MinorReleaseNumber]
       , [PointReleaseNumber]
       , [Hotfix]
       , [ScriptName]
       , [ScriptDescription]
       , [TargetRegistry]
       , [DateApplied])
  Values
      ('05'
       ,'00'
       ,'042'
       ,0
       ,'Tracker #1315: DoD Fragment Data (.net)'
       ,'1. Add Analyte lookup values to [EFR].[VIEW_LOOKUP].  2. Delete Other Analysis Method from DBO.STD_GUI_CONTROLS table. 3. Update Analyte record in DBO.STD_GUI_CONTROLS from Textbox to Dropdownlist.'
       ,'EFR'
      ,GETDATE())

End
