
--VACCR Bug tracker 1582
--05/20/2011 V.Naik
--Create SCHEMA [ONC] and table ONC.ONCOLOGY_DATA_VACCR to import/load VACCR data files.

IF  EXISTS (SELECT * FROM sys.schemas WHERE name = N'ONC')
DROP SCHEMA [ONC]
GO

CREATE SCHEMA [ONC] --AUTHORIZATION [ONC]
GO

--Drop table ONC.ONCOLOGY_DATA_VACCR
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ONC].[ONCOLOGY_DATA_VACCR]') AND type in (N'U'))
DROP TABLE [ONC].[ONCOLOGY_DATA_VACCR]
GO

----Create table ONCOLOGY_DATA_VACCR

CREATE TABLE [ONC].[ONCOLOGY_DATA_VACCR]
		(ID INT NOT NULL IDENTITY (1, 1), 
		RECORD_TYPE VARCHAR(1) NULL,
		REGISTRY_TYPE VARCHAR(1) NULL,
		FIN_CODING_SYSTEM VARCHAR(1) NULL,
		RESERVED_00 VARCHAR(13) NULL,
		NAACCR_RECORD_VERSION VARCHAR(3) NULL,
		NPI_REGISTRY_ID VARCHAR(10) NULL,
		REGISTRY_ID VARCHAR(10) NULL,
		TUMOR_RECORD_NUMBER VARCHAR(2) NULL,
		PATIENT_ID_NUMBER VARCHAR(8) NULL,
		PATIENT_SYSTEM_ID_HOSP VARCHAR(8) NULL,
		RESERVED_01 VARCHAR(37) NULL,
		ADDR_AT_DX_CITY VARCHAR(50) NULL,
		ADDR_AT_DX_STATE VARCHAR(2) NULL,
		ADDR_AT_DX_POSTAL_CODE VARCHAR(9) NULL,
		COUNTY_AT_DX VARCHAR(3) NULL,
		CENSUS_TRACT_1970_80_90 VARCHAR(6) NULL,
		CENSUSBLOCKGROUP_70_80_90 VARCHAR(1) NULL,
		CENSUS_COD_SYS_1970_80_90 VARCHAR(1) NULL,
		CENSUS_TR_CERT_1970_80_90 VARCHAR(1) NULL,
		CENSUS_TRACT_2000 VARCHAR(6) NULL,
		CENSUS_BLOCK_GROUP_2000 VARCHAR(1) NULL,
		CENSUS_TR_CERTAINTY_2000 VARCHAR(1) NULL,
		MARITAL_STATUS_AT_DX VARCHAR(1) NULL,
		RACE_1 VARCHAR(2) NULL,
		RACE_2 VARCHAR(2) NULL,
		RACE_3 VARCHAR(2) NULL,
		RACE_4 VARCHAR(2) NULL,
		RACE_5 VARCHAR(2) NULL,
		RACE_CODING_SYS_CURRENT VARCHAR(1) NULL,
		RACE_CODING_SYS_ORIGINAL VARCHAR(1) NULL,
		SPANISH_HISPANIC_ORIGIN VARCHAR(1) NULL,
		COMPUTED_ETHNICITY VARCHAR(1) NULL,
		COMPUTED_ETHNICITY_SOURCE VARCHAR(1) NULL,
		SEX VARCHAR(1) NULL,
		AGE_AT_DIAGNOSIS VARCHAR(3) NULL,
		DATE_OF_BIRTH VARCHAR(8) NULL,
		DATE_OF_BIRTH_FLAG VARCHAR(2) NULL,
		BIRTHPLACE VARCHAR(3) NULL,
		OCCUPATION_CODE_CENSUS VARCHAR(3) NULL,
		INDUSTRY_CODE_CENSUS VARCHAR(3) NULL,
		OCCUPATION_SOURCE VARCHAR(1) NULL,
		INDUSTRY_SOURCE VARCHAR(1) NULL,
		TEXT_USUAL_OCCUPATION VARCHAR(100) NULL,
		TEXT_USUAL_INDUSTRY VARCHAR(100) NULL,
		OCCUP_IND_CODING_SYSTEM VARCHAR(1) NULL,
		NHIA_DERIVED_HISP_ORIGIN VARCHAR(1) NULL,
		RACE_NAPIIA_DERIVED_API VARCHAR(2) NULL,
		IHS_LINK VARCHAR(1) NULL,
		GIS_COORDINATE_QUALITY VARCHAR(2) NULL,
		RURALURBAN_CONTINUUM_1993 VARCHAR(2) NULL,
		RURALURBAN_CONTINUUM_2003 VARCHAR(2) NULL,
		CENSUS_TRACT_2010 VARCHAR(6) NULL,
		CENSUS_BLOCK_GROUP_2010 VARCHAR(1) NULL,
		CENSUS_TR_CERTAINTY_2010 VARCHAR(1) NULL,
		RESERVED_02 VARCHAR(92) NULL,
		SEQUENCE_NUMBER_CENTRAL VARCHAR(2) NULL,
		DATE_OF_DIAGNOSIS VARCHAR(8) NULL,
		DATE_OF_DIAGNOSIS_FLAG VARCHAR(2) NULL,
		PRIMARY_SITE VARCHAR(4) NULL,
		LATERALITY VARCHAR(1) NULL,
		MORPH_TYPE_BEHAV_ICD_O_2 VARCHAR(5) NULL,
		MORPH_TYPE_BEHAV_ICD_O_3 VARCHAR(5) NULL,
		GRADE VARCHAR(1) NULL,
		GRADE_PATH_VALUE VARCHAR(1) NULL,
		GRADE_PATH_SYSTEM VARCHAR(1) NULL,
		SITE_CODING_SYS_CURRENT VARCHAR(1) NULL,
		SITE_CODING_SYS_ORIGINAL VARCHAR(1) NULL,
		MORPH_CODING_SYS_CURRENT VARCHAR(1) NULL,
		MORPH_CODING_SYS_ORIGINAL VARCHAR(1) NULL,
		DIAGNOSTIC_CONFIRMATION VARCHAR(1) NULL,
		TYPE_OF_REPORTING_SOURCE VARCHAR(1) NULL,
		CASEFINDING_SOURCE VARCHAR(2) NULL,
		AMBIGUOUS_TERMINOLOGY_DX VARCHAR(1) NULL,
		DATE_OF_CONCLUSIVE_DX VARCHAR(8) NULL,
		DATE_OF_CONCLUSIVE_DX_FLAG VARCHAR(2) NULL,
		MULT_TUM_RPT_AS_ONE_PRIM VARCHAR(2) NULL,
		DATE_OF_MULTIPLE_TUMORS VARCHAR(8) NULL,
		DATE_OF_MULT_TUMORS_FLAG VARCHAR(2) NULL,
		MULTIPLICITY_COUNTER VARCHAR(2) NULL,
		RESERVED_03 VARCHAR(100) NULL,
		NPI_REPORTING_FACILITY VARCHAR(10) NULL,
		REPORTING_FACILITY VARCHAR(10) NULL,
		NPI_ARCHIVE_FIN VARCHAR(10) NULL,
		ARCHIVE_FIN VARCHAR(10) NULL,
		ACCESSION_NUMBER_HOSP VARCHAR(9) NULL,
		SEQUENCE_NUMBER_HOSPITAL VARCHAR(2) NULL,
		ABSTRACTED_BY VARCHAR(3) NULL,
		DATE_OF_1ST_CONTACT VARCHAR(8) NULL,
		DATE_OF_1ST_CONTACT_FLAG VARCHAR(2) NULL,
		DATE_OF_INPATIENT_ADM VARCHAR(8) NULL,
		DATE_OF_INPT_ADM_FLAG VARCHAR(2) NULL,
		DATE_OF_INPATIENT_DISCH VARCHAR(8) NULL,
		DATE_OF_INPT_DISCH_FLAG VARCHAR(2) NULL,
		INPATIENT_STATUS VARCHAR(1) NULL,
		CLASS_OF_CASE VARCHAR(2) NULL,
		PRIMARY_PAYER_AT_DX VARCHAR(2) NULL,
		RX_HOSP_ASA_CLASS VARCHAR(1) NULL,
		RX_HOSP_SURG_APP_2010 VARCHAR(1) NULL,
		RX_HOSP_SURG_PRIM_SITE VARCHAR(2) NULL,
		RX_HOSP_SCOPE_REG_LN_SUR VARCHAR(1) NULL,
		RX_HOSP_SURG_OTH_REG_DIS VARCHAR(1) NULL,
		RX_HOSP_REG_LN_REMOVED VARCHAR(2) NULL,
		RESERVED_16 VARCHAR(1) NULL,
		RX_HOSP_RADIATION VARCHAR(1) NULL,
		RX_HOSP_CHEMO VARCHAR(2) NULL,
		RX_HOSP_HORMONE VARCHAR(2) NULL,
		RX_HOSP_BRM VARCHAR(2) NULL,
		RX_HOSP_OTHER VARCHAR(1) NULL,
		RX_HOSP_DX_STG_PROC VARCHAR(2) NULL,
		RX_HOSP_PALLIATIVE_PROC VARCHAR(1) NULL,
		RX_HOSP_SURG_SITE_98_02 VARCHAR(2) NULL,
		RX_HOSP_SCOPE_REG_98_02 VARCHAR(1) NULL,
		RX_HOSP_SURG_OTH_98_02 VARCHAR(1) NULL,
		RESERVED_04 VARCHAR(100) NULL,
		SEER_SUMMARY_STAGE_2000 VARCHAR(1) NULL,
		SEER_SUMMARY_STAGE_1977 VARCHAR(1) NULL,
		EOD_TUMOR_SIZE VARCHAR(3) NULL,
		EOD_EXTENSION VARCHAR(2) NULL,
		EOD_EXTENSION_PROST_PATH VARCHAR(2) NULL,
		EOD_LYMPH_NODE_INVOLV VARCHAR(1) NULL,
		REGIONAL_NODES_POSITIVE VARCHAR(2) NULL,
		REGIONAL_NODES_EXAMINED VARCHAR(2) NULL,
		EOD_OLD_13_DIGIT VARCHAR(13) NULL,
		EOD_OLD_2_DIGIT VARCHAR(2) NULL,
		EOD_OLD_4_DIGIT VARCHAR(4) NULL,
		CODING_SYSTEM_FOR_EOD VARCHAR(1) NULL,
		TNM_EDITION_NUMBER VARCHAR(2) NULL,
		TNM_PATH_T VARCHAR(4) NULL,
		TNM_PATH_N VARCHAR(4) NULL,
		TNM_PATH_M VARCHAR(4) NULL,
		TNM_PATH_STAGE_GROUP VARCHAR(4) NULL,
		TNM_PATH_DESCRIPTOR VARCHAR(1) NULL,
		TNM_PATH_STAGED_BY VARCHAR(1) NULL,
		TNM_CLIN_T VARCHAR(4) NULL,
		TNM_CLIN_N VARCHAR(4) NULL,
		TNM_CLIN_M VARCHAR(4) NULL,
		TNM_CLIN_STAGE_GROUP VARCHAR(4) NULL,
		TNM_CLIN_DESCRIPTOR VARCHAR(1) NULL,
		TNM_CLIN_STAGED_BY VARCHAR(1) NULL,
		PEDIATRIC_STAGE VARCHAR(2) NULL,
		PEDIATRIC_STAGING_SYSTEM VARCHAR(2) NULL,
		PEDIATRIC_STAGED_BY VARCHAR(1) NULL,
		TUMOR_MARKER_1 VARCHAR(1) NULL,
		TUMOR_MARKER_2 VARCHAR(1) NULL,
		TUMOR_MARKER_3 VARCHAR(1) NULL,
		LYMPH_VASCULAR_INVASION VARCHAR(1) NULL,
		CS_TUMOR_SIZE VARCHAR(3) NULL,
		CS_EXTENSION VARCHAR(3) NULL,
		CS_TUMOR_SIZE_EXT_EVAL VARCHAR(1) NULL,
		CS_LYMPH_NODES VARCHAR(3) NULL,
		CS_LYMPH_NODES_EVAL VARCHAR(1) NULL,
		CS_METS_AT_DX VARCHAR(2) NULL,
		CS_METS_EVAL VARCHAR(1) NULL,
		CS_METS_AT_DX_BONE VARCHAR(1) NULL,
		CS_METS_AT_DX_BRAIN VARCHAR(1) NULL,
		CS_METS_AT_DX_LIVER VARCHAR(1) NULL,
		CS_METS_AT_DX_LUNG VARCHAR(1) NULL,
		CS_SITE_SPECIFIC_FACTOR_1 VARCHAR(3) NULL,
		CS_SITE_SPECIFIC_FACTOR_2 VARCHAR(3) NULL,
		CS_SITE_SPECIFIC_FACTOR_3 VARCHAR(3) NULL,
		CS_SITE_SPECIFIC_FACTOR_4 VARCHAR(3) NULL,
		CS_SITE_SPECIFIC_FACTOR_5 VARCHAR(3) NULL,
		CS_SITE_SPECIFIC_FACTOR_6 VARCHAR(3) NULL,
		CS_SITE_SPECIFIC_FACTOR_7 VARCHAR(3) NULL,
		CS_SITE_SPECIFIC_FACTOR_8 VARCHAR(3) NULL,
		CS_SITE_SPECIFIC_FACTOR_9 VARCHAR(3) NULL,
		CS_SITE_SPECIFIC_FACTOR_10 VARCHAR(3) NULL,
		CS_SITE_SPECIFIC_FACTOR_11 VARCHAR(3) NULL,
		CS_SITE_SPECIFIC_FACTOR_12 VARCHAR(3) NULL,
		CS_SITE_SPECIFIC_FACTOR_13 VARCHAR(3) NULL,
		CS_SITE_SPECIFIC_FACTOR_14 VARCHAR(3) NULL,
		CS_SITE_SPECIFIC_FACTOR_15 VARCHAR(3) NULL,
		CS_SITE_SPECIFIC_FACTOR_16 VARCHAR(3) NULL,
		CS_SITE_SPECIFIC_FACTOR_17 VARCHAR(3) NULL,
		CS_SITE_SPECIFIC_FACTOR_18 VARCHAR(3) NULL,
		CS_SITE_SPECIFIC_FACTOR_19 VARCHAR(3) NULL,
		CS_SITE_SPECIFIC_FACTOR_20 VARCHAR(3) NULL,
		CS_SITE_SPECIFIC_FACTOR_21 VARCHAR(3) NULL,
		CS_SITE_SPECIFIC_FACTOR_22 VARCHAR(3) NULL,
		CS_SITE_SPECIFIC_FACTOR_23 VARCHAR(3) NULL,
		CS_SITE_SPECIFIC_FACTOR_24 VARCHAR(3) NULL,
		CS_SITE_SPECIFIC_FACTOR_25 VARCHAR(3) NULL,
		CS_PRERX_TUMOR_SIZE VARCHAR(3) NULL,
		CS_PRERX_EXTENSION VARCHAR(3) NULL,
		CS_PRERX_TUM_SZ_EXT_EVAL VARCHAR(1) NULL,
		CS_PRERX_LYMPH_NODES VARCHAR(3) NULL,
		CS_PRERX_REG_NODES_EVAL VARCHAR(1) NULL,
		CS_PRERX_METS_AT_DX VARCHAR(2) NULL,
		CS_PRERX_METS_EVAL VARCHAR(1) NULL,
		CS_POSTRX_TUMOR_SIZE VARCHAR(3) NULL,
		CS_POSTRX_EXTENSION VARCHAR(3) NULL,
		CS_POSTRX_LYMPH_NODES VARCHAR(3) NULL,
		CS_POSTRX_METS_AT_DX VARCHAR(2) NULL,
		DERIVED_AJCC_6_T VARCHAR(2) NULL,
		DERIVED_AJCC_6_T_DESCRIPT VARCHAR(1) NULL,
		DERIVED_AJCC_6_N VARCHAR(2) NULL,
		DERIVED_AJCC_6_N_DESCRIPT VARCHAR(1) NULL,
		DERIVED_AJCC_6_M VARCHAR(2) NULL,
		DERIVED_AJCC_6_M_DESCRIPT VARCHAR(1) NULL,
		DERIVED_AJCC_6_STAGE_GRP VARCHAR(2) NULL,
		DERIVED_AJCC_7_T VARCHAR(3) NULL,
		DERIVED_AJCC_7_T_DESCRIPT VARCHAR(1) NULL,
		DERIVED_AJCC_7_N VARCHAR(3) NULL,
		DERIVED_AJCC_7_N_DESCRIPT VARCHAR(1) NULL,
		DERIVED_AJCC_7_M VARCHAR(3) NULL,
		DERIVED_AJCC_7_M_DESCRIPT VARCHAR(1) NULL,
		DERIVED_AJCC_7_STAGE_GRP VARCHAR(3) NULL,
		DERIVED_PRERX_7_T VARCHAR(3) NULL,
		DERIVED_PRERX_7_T_DESCRIP VARCHAR(1) NULL,
		DERIVED_PRERX_7_N VARCHAR(3) NULL,
		DERIVED_PRERX_7_N_DESCRIP VARCHAR(1) NULL,
		DERIVED_PRERX_7_M VARCHAR(3) NULL,
		DERIVED_PRERX_7_M_DESCRIP VARCHAR(1) NULL,
		DERIVED_PRERX_7_STAGE_GRP VARCHAR(3) NULL,
		DERIVED_POSTRX_7_T VARCHAR(3) NULL,
		DERIVED_POSTRX_7_N VARCHAR(3) NULL,
		DERIVED_POSTRX_7_M VARCHAR(2) NULL,
		DERIVED_POSTRX_7_STGE_GRP VARCHAR(3) NULL,
		DERIVED_SS1977 VARCHAR(1) NULL,
		DERIVED_SS2000 VARCHAR(1) NULL,
		DERIVED_NEOADJUV_RX_FLAG VARCHAR(1) NULL,
		DERIVED_AJCC_FLAG VARCHAR(1) NULL,
		DERIVED_SS1977_FLAG VARCHAR(1) NULL,
		DERIVED_SS2000_FLAG VARCHAR(1) NULL,
		CS_VERSION_INPUT_CURRENT VARCHAR(6) NULL,
		CS_VERSION_INPUT_ORIGINAL VARCHAR(6) NULL,
		CS_VERSION_DERIVED VARCHAR(6) NULL,
		SEER_SITE_SPECIFIC_FACT_1 VARCHAR(1) NULL,
		SEER_SITE_SPECIFIC_FACT_2 VARCHAR(1) NULL,
		SEER_SITE_SPECIFIC_FACT_3 VARCHAR(1) NULL,
		SEER_SITE_SPECIFIC_FACT_4 VARCHAR(1) NULL,
		SEER_SITE_SPECIFIC_FACT_5 VARCHAR(1) NULL,
		SEER_SITE_SPECIFIC_FACT_6 VARCHAR(1) NULL,
		ICD_REVISION_COMORBID VARCHAR(1) NULL,
		COMORBID_COMPLICATION_1 VARCHAR(5) NULL,
		COMORBID_COMPLICATION_2 VARCHAR(5) NULL,
		COMORBID_COMPLICATION_3 VARCHAR(5) NULL,
		COMORBID_COMPLICATION_4 VARCHAR(5) NULL,
		COMORBID_COMPLICATION_5 VARCHAR(5) NULL,
		COMORBID_COMPLICATION_6 VARCHAR(5) NULL,
		COMORBID_COMPLICATION_7 VARCHAR(5) NULL,
		COMORBID_COMPLICATION_8 VARCHAR(5) NULL,
		COMORBID_COMPLICATION_9 VARCHAR(5) NULL,
		COMORBID_COMPLICATION_10 VARCHAR(5) NULL,
		RESERVED_05 VARCHAR(200) NULL,
		DATE_OF_INITIAL_RX_SEER VARCHAR(8) NULL,
		DATE_OF_INITAL_RX_FLAG VARCHAR(2) NULL,
		DATE_OF_1ST_CRS_RX_COC VARCHAR(8) NULL,
		DATE_OF_1ST_CRS_RX_FLAG VARCHAR(2) NULL,
		RX_DATE_SURGERY VARCHAR(8) NULL,
		RX_DATE_SURGERY_FLAG VARCHAR(2) NULL,
		RX_DATE_MOST_DEFIN_SURG VARCHAR(8) NULL,
		RX_DATE_MST_DEFIN_SRG_FLAG VARCHAR(2) NULL,
		RX_DATE_SURGICAL_DISCH VARCHAR(8) NULL,
		RX_DATE_SURG_DISCH_FLAG VARCHAR(2) NULL,
		RX_DATE_RADIATION VARCHAR(8) NULL,
		RX_DATE_RADIATION_FLAG VARCHAR(2) NULL,
		RX_DATE_RADIATION_ENDED VARCHAR(8) NULL,
		RX_DATE_RAD_ENDED_FLAG VARCHAR(2) NULL,
		RX_DATE_SYSTEMIC VARCHAR(8) NULL,
		RX_DATE_SYSTEMIC_FLAG VARCHAR(2) NULL,
		RX_DATE_CHEMO VARCHAR(8) NULL,
		RX_DATE_CHEMO_FLAG VARCHAR(2) NULL,
		RX_DATE_HORMONE VARCHAR(8) NULL,
		RX_DATE_HORMONE_FLAG VARCHAR(2) NULL,
		RX_DATE_BRM VARCHAR(8) NULL,
		RX_DATE_BRM_FLAG VARCHAR(2) NULL,
		RX_DATE_OTHER VARCHAR(8) NULL,
		RX_DATE_OTHER_FLAG VARCHAR(2) NULL,
		RX_DATE_DX_STG_PROC VARCHAR(8) NULL,
		RX_DATE_DX_STG_PROC_FLAG VARCHAR(2) NULL,
		RX_SUMM_TREATMENT_STATUS VARCHAR(1) NULL,
		RX_SUMM_SURG_PRIM_SITE VARCHAR(2) NULL,
		RX_SUMM_SCOPE_REG_LN_SUR VARCHAR(1) NULL,
		RX_SUMM_SURG_OTH_REG_DIS VARCHAR(1) NULL,
		RX_SUMM_REG_LN_EXAMINED VARCHAR(2) NULL,
		RX_SUMM_SURGICAL_APPROCH VARCHAR(1) NULL,
		RX_SUMM_SURGICAL_MARGINS VARCHAR(1) NULL,
		RX_SUMM_RECONSTRUCT_1ST VARCHAR(1) NULL,
		REASON_FOR_NO_SURGERY VARCHAR(1) NULL,
		RX_SUMM_DX_STG_PROC VARCHAR(2) NULL,
		RX_SUMM_PALLIATIVE_PROC VARCHAR(1) NULL,
		RX_SUMM_RADIATION VARCHAR(1) NULL,
		RX_SUMM_RAD_TO_CNS VARCHAR(1) NULL,
		RX_SUMM_SURG_RAD_SEQ VARCHAR(1) NULL,
		RX_SUMM_TRANSPLNT_ENDOCR VARCHAR(2) NULL,
		RX_SUMM_CHEMO VARCHAR(2) NULL,
		RX_SUMM_HORMONE VARCHAR(2) NULL,
		RX_SUMM_BRM VARCHAR(2) NULL,
		RX_SUMM_OTHER VARCHAR(1) NULL,
		REASON_FOR_NO_RADIATION VARCHAR(1) NULL,
		RX_CODING_SYSTEM_CURRENT VARCHAR(2) NULL,
		FIRST_COURSE_CALC_METHOD VARCHAR(1) NULL,
		RAD_REGIONAL_DOSE_CGY VARCHAR(5) NULL,
		RAD_NO_OF_TREATMENT_VOL VARCHAR(3) NULL,
		RAD_TREATMENT_VOLUME VARCHAR(2) NULL,
		RAD_LOCATION_OF_RX VARCHAR(1) NULL,
		RAD_REGIONAL_RX_MODALITY VARCHAR(2) NULL,
		RAD_BOOST_RX_MODALITY VARCHAR(2) NULL,
		RAD_BOOST_DOSE_CGY VARCHAR(5) NULL,
		RX_SUMM_SYSTEMIC_SUR_SEQ VARCHAR(1) NULL,
		RX_SUMM_SURGERY_TYPE VARCHAR(2) NULL,
		READM_SAME_HOSP_30_DAYS VARCHAR(1) NULL,
		RX_SUMM_SURG_SITE_98_02 VARCHAR(2) NULL,
		RX_SUMM_SCOPE_REG_98_02 VARCHAR(1) NULL,
		RX_SUMM_SURG_OTH_98_02 VARCHAR(1) NULL,
		RESERVED_06 VARCHAR(100) NULL,
		SUBSQ_RX_2ND_COURSE_DATE VARCHAR(8) NULL,
		SUBSQ_RX_2NDCRS_DATE_FLAG VARCHAR(2) NULL,
		SUBSQ_RX_2ND_COURSE_SURG VARCHAR(2) NULL,
		SUBSQ_RX_2ND_SCOPE_LN_SU VARCHAR(1) NULL,
		SUBSQ_RX_2ND_SURG_OTH VARCHAR(1) NULL,
		SUBSQ_RX_2ND_REG_LN_REM VARCHAR(2) NULL,
		SUBSQ_RX_2ND_COURSE_RAD VARCHAR(1) NULL,
		SUBSQ_RX_2ND_COURSE_CHEMO VARCHAR(1) NULL,
		SUBSQ_RX_2ND_COURSE_HORM VARCHAR(1) NULL,
		SUBSQ_RX_2ND_COURSE_BRM VARCHAR(1) NULL,
		SUBSQ_RX_2ND_COURSE_OTH VARCHAR(1) NULL,
		SUBSQ_RX_3RD_COURSE_DATE VARCHAR(8) NULL,
		SUBSQ_RX_3RDCRS_DATE_FLAG VARCHAR(2) NULL,
		SUBSQ_RX_3RD_COURSE_SURG VARCHAR(2) NULL,
		SUBSQ_RX_3RD_SCOPE_LN_SU VARCHAR(1) NULL,
		SUBSQ_RX_3RD_SURG_OTH VARCHAR(1) NULL,
		SUBSQ_RX_3RD_REG_LN_REM VARCHAR(2) NULL,
		SUBSQ_RX_3RD_COURSE_RAD VARCHAR(1) NULL,
		SUBSQ_RX_3RD_COURSE_CHEMO VARCHAR(1) NULL,
		SUBSQ_RX_3RD_COURSE_HORM VARCHAR(1) NULL,
		SUBSQ_RX_3RD_COURSE_BRM VARCHAR(1) NULL,
		SUBSQ_RX_3RD_COURSE_OTH VARCHAR(1) NULL,
		SUBSQ_RX_4TH_COURSE_DATE VARCHAR(8) NULL,
		SUBSQ_RX_4THCRS_DATE_FLAG VARCHAR(2) NULL,
		SUBSQ_RX_4TH_COURSE_SURG VARCHAR(2) NULL,
		SUBSQ_RX_4TH_SCOPE_LN_SU VARCHAR(1) NULL,
		SUBSQ_RX_4TH_SURG_OTH VARCHAR(1) NULL,
		SUBSQ_RX_4TH_REG_LN_REM VARCHAR(2) NULL,
		SUBSQ_RX_4TH_COURSE_RAD VARCHAR(1) NULL,
		SUBSQ_RX_4TH_COURSE_CHEMO VARCHAR(1) NULL,
		SUBSQ_RX_4TH_COURSE_HORM VARCHAR(1) NULL,
		SUBSQ_RX_4TH_COURSE_BRM VARCHAR(1) NULL,
		SUBSQ_RX_4TH_COURSE_OTH VARCHAR(1) NULL,
		SUBSQ_RX_RECONSTRUCT_DEL VARCHAR(1) NULL,
		RESERVED_07 VARCHAR(100) NULL,
		OVER_RIDE_SS_NODESPOS VARCHAR(1) NULL,
		OVER_RIDE_SS_TNM_N VARCHAR(1) NULL,
		OVER_RIDE_SS_TNM_M VARCHAR(1) NULL,
		OVER_RIDE_ACSN_CLASS_SEQ VARCHAR(1) NULL,
		OVER_RIDE_HOSPSEQ_DXCONF VARCHAR(1) NULL,
		OVER_RIDE_COC_SITE_TYPE VARCHAR(1) NULL,
		OVER_RIDE_HOSPSEQ_SITE VARCHAR(1) NULL,
		OVER_RIDE_SITE_TNM_STGGRP VARCHAR(1) NULL,
		OVER_RIDE_AGE_SITE_MORPH VARCHAR(1) NULL,
		OVER_RIDE_SEQNO_DXCONF VARCHAR(1) NULL,
		OVER_RIDE_SITE_LAT_SEQNO VARCHAR(1) NULL,
		OVER_RIDE_SURG_DXCONF VARCHAR(1) NULL,
		OVER_RIDE_SITE_TYPE VARCHAR(1) NULL,
		OVER_RIDE_HISTOLOGY VARCHAR(1) NULL,
		OVER_RIDE_REPORT_SOURCE VARCHAR(1) NULL,
		OVER_RIDE_ILL_DEFINE_SITE VARCHAR(1) NULL,
		OVER_RIDE_LEUK_LYMPHOMA VARCHAR(1) NULL,
		OVER_RIDE_SITE_BEHAVIOR VARCHAR(1) NULL,
		OVER_RIDE_SITE_EOD_DX_DT VARCHAR(1) NULL,
		OVER_RIDE_SITE_LAT_EOD VARCHAR(1) NULL,
		OVER_RIDE_SITE_LAT_MORPH VARCHAR(1) NULL,
		SITE_73_91_ICD_O_1 VARCHAR(4) NULL,
		MORPH_73_91_ICD_O_1 VARCHAR(6) NULL,
		ICD_O_2_CONVERSION_FLAG VARCHAR(1) NULL,
		CRC_CHECKSUM VARCHAR(10) NULL,
		SEER_CODING_SYS_CURRENT VARCHAR(1) NULL,
		SEER_CODING_SYS_ORIGINAL VARCHAR(1) NULL,
		COC_CODING_SYS_CURRENT VARCHAR(2) NULL,
		COC_CODING_SYS_ORIGINAL VARCHAR(2) NULL,
		VENDOR_NAME VARCHAR(10) NULL,
		SEER_TYPE_OF_FOLLOW_UP VARCHAR(1) NULL,
		SEER_RECORD_NUMBER VARCHAR(2) NULL,
		DIAGNOSTIC_PROC_73_87 VARCHAR(2) NULL,
		DATE_CASE_INITIATED VARCHAR(8) NULL,
		DATE_CASE_COMPLETED VARCHAR(8) NULL,
		DATE_CASE_COMPLETED_COC VARCHAR(8) NULL,
		DATE_CASE_LAST_CHANGED VARCHAR(8) NULL,
		DATE_CASE_REPORT_EXPORTED VARCHAR(8) NULL,
		DATE_CASE_REPORT_RECEIVED VARCHAR(8) NULL,
		DATE_CASE_REPORT_LOADED VARCHAR(8) NULL,
		DATE_TUMOR_RECORD_AVAILBL VARCHAR(8) NULL,
		ICD_O_3_CONVERSION_FLAG VARCHAR(1) NULL,
		OVER_RIDE_CS_1 VARCHAR(1) NULL,
		OVER_RIDE_CS_2 VARCHAR(1) NULL,
		OVER_RIDE_CS_3 VARCHAR(1) NULL,
		OVER_RIDE_CS_4 VARCHAR(1) NULL,
		OVER_RIDE_CS_5 VARCHAR(1) NULL,
		OVER_RIDE_CS_6 VARCHAR(1) NULL,
		OVER_RIDE_CS_7 VARCHAR(1) NULL,
		OVER_RIDE_CS_8 VARCHAR(1) NULL,
		OVER_RIDE_CS_9 VARCHAR(1) NULL,
		OVER_RIDE_CS_10 VARCHAR(1) NULL,
		OVER_RIDE_CS_11 VARCHAR(1) NULL,
		OVER_RIDE_CS_12 VARCHAR(1) NULL,
		OVER_RIDE_CS_13 VARCHAR(1) NULL,
		OVER_RIDE_CS_14 VARCHAR(1) NULL,
		OVER_RIDE_CS_15 VARCHAR(1) NULL,
		OVER_RIDE_CS_16 VARCHAR(1) NULL,
		OVER_RIDE_CS_17 VARCHAR(1) NULL,
		OVER_RIDE_CS_18 VARCHAR(1) NULL,
		OVER_RIDE_CS_19 VARCHAR(1) NULL,
		OVER_RIDE_CS_20 VARCHAR(1) NULL,
		RESERVED_08 VARCHAR(80) NULL,
		DATE_OF_LAST_CONTACT VARCHAR(8) NULL,
		DATE_OF_LAST_CONTACT_FLAG VARCHAR(2) NULL,
		VITAL_STATUS VARCHAR(1) NULL,
		CANCER_STATUS VARCHAR(1) NULL,
		QUALITY_OF_SURVIVAL VARCHAR(1) NULL,
		FOLLOW_UP_SOURCE VARCHAR(1) NULL,
		NEXT_FOLLOW_UP_SOURCE VARCHAR(1) NULL,
		ADDR_CURRENT_CITY VARCHAR(50) NULL,
		ADDR_CURRENT_STATE VARCHAR(2) NULL,
		ADDR_CURRENT_POSTAL_CODE VARCHAR(9) NULL,
		COUNTY_CURRENT VARCHAR(3) NULL,
		UNUSUAL_FOLLOW_UP_METHOD VARCHAR(1) NULL,
		RECURRENCE_DATE_1ST VARCHAR(8) NULL,
		RECURRENCE_DATE_1ST_FLAG VARCHAR(2) NULL,
		RECURRENCE_TYPE_1ST VARCHAR(2) NULL,
		FOLLOW_UP_CONTACT_CITY VARCHAR(50) NULL,
		FOLLOW_UP_CONTACT_STATE VARCHAR(2) NULL,
		FOLLOW_UP_CONTACT_POSTAL VARCHAR(9) NULL,
		CAUSE_OF_DEATH VARCHAR(4) NULL,
		ICD_REVISION_NUMBER VARCHAR(1) NULL,
		AUTOPSY VARCHAR(1) NULL,
		PLACE_OF_DEATH VARCHAR(3) NULL,
		FOLLOW_UP_SOURCE_CENTRAL VARCHAR(2) NULL,
		DATE_OF_DEATH_CANADA VARCHAR(8) NULL,
		DATE_OF_DEATH_CANADAFLAG VARCHAR(2) NULL,
		RESERVED_09 VARCHAR(50) NULL,
		VISN VARCHAR(2) NULL,
		AGENT_ORANGE_EXPOSURE VARCHAR(1) NULL,
		IONIZING_RADIATION_EXPOSURE VARCHAR(1) NULL,
		CHEMICAL_EXPOSURE VARCHAR(1) NULL,
		ASBESTOS_EXPOSURE VARCHAR(1) NULL,
		VIETNAM_SERVICE VARCHAR(1) NULL,
		LEBANON_SERVICE VARCHAR(1) NULL,
		GRENADA_SERVICE VARCHAR(1) NULL,
		PANAMA_SERVICE VARCHAR(1) NULL,
		PERSIAN_GULF_SERVICE VARCHAR(1) NULL,
		SOMALIA_SERVICE VARCHAR(1) NULL,
		YUGOSLAVIA_SERVICE VARCHAR(1) NULL,
		IRAQ_OIF_SERVICE VARCHAR(1) NULL,
		AFGHANISTAN_OEF_SERVICE VARCHAR(1) NULL,
		BRANCH_OF_SERVICE VARCHAR(2) NULL,
		FAMILY_HISTORY_OF_CANCER_TEXT VARCHAR(50) NULL,
		YEAR_FIRST_SEEN_THIS_CA VARCHAR(4) NULL,
		PREVIOUS_HISTORY_OF_CANCER VARCHAR(1) NULL,
		PREVIOUS_HISTORY_OF_CANCER_TEXT VARCHAR(20) NULL,
		AFIP_SUBMISSION VARCHAR(1) NULL,
		HEPATITIS_C VARCHAR(1) NULL,
		PERFORMANCE_STATUS_AT_DX VARCHAR(1) NULL,
		OTHER_STAGING_SYSTEM VARCHAR(15) NULL,
		CHEMOTHERAPEUTIC_AGENT_#1 VARCHAR(6) NULL,
		CHEMOTHERAPEUTIC_AGENT_#2 VARCHAR(6) NULL,
		CHEMOTHERAPEUTIC_AGENT_#3 VARCHAR(6) NULL,
		CHEMOTHERAPEUTIC_AGENT_#4 VARCHAR(6) NULL,
		CHEMOTHERAPEUTIC_AGENT_#5 VARCHAR(6) NULL,
		PROTOCOL_ELIGIBILITY_STAT VARCHAR(1) NULL,
		PROTOCOL_PARTICIPATION VARCHAR(2) NULL,
		SUBSQ_RX_2ND_SURG_DATE VARCHAR(8) NULL,
		SUBSQ_RX_2ND_RAD_DATE VARCHAR(8) NULL,
		SUBSQ_RX_2ND_CHEMO_DATE VARCHAR(8) NULL,
		SUBSQ_RX_2ND_HORM_DATE VARCHAR(8) NULL,
		SUBSQ_RX_2ND_BRM_DATE VARCHAR(8) NULL,
		SUBSQ_RX_2ND_OTHER_DATE VARCHAR(8) NULL,
		TOBACCO_HISTORY VARCHAR(1) NULL,
		ALCOHOL_HISTORY VARCHAR(1) NULL,
		FAMILY_HISTORY_OF_CANCER VARCHAR(1) NULL,
		SITE_OF_DISTANT_MET_1 VARCHAR(1) NULL,
		SITE_OF_DISTANT_MET_2 VARCHAR(1) NULL,
		SITE_OF_DISTANT_MET_3 VARCHAR(1) NULL,
		RECURRENCE_DISTANT_SITE_1 VARCHAR(1) NULL,
		RECURRENCE_DISTANT_SITE_2 VARCHAR(1) NULL,
		RECURRENCE_DISTANT_SITE_3 VARCHAR(1) NULL,
		FEE_BASIS VARCHAR(1) NULL,
		STATION_NUMBER VARCHAR(6) NULL,
		COC_ACCREDITATION VARCHAR(2) NULL,
		RESERVED_FOR_EXPANSION VARCHAR(791) NULL,
		NAME_LAST VARCHAR(40) NULL,
		NAME_FIRST VARCHAR(40) NULL,
		NAME_MIDDLE VARCHAR(40) NULL,
		NAME_PREFIX VARCHAR(3) NULL,
		NAME_SUFFIX VARCHAR(3) NULL,
		NAME_ALIAS VARCHAR(40) NULL,
		NAME_MAIDEN VARCHAR(40) NULL,
		NAME_SPOUSE_PARENT VARCHAR(60) NULL,
		MEDICAL_RECORD_NUMBER VARCHAR(11) NULL,
		MILITARY_RECORD_NO_SUFFIX VARCHAR(2) NULL,
		SOCIAL_SECURITY_NUMBER VARCHAR(9) NULL,
		ADDR_AT_DX_NO_AND_STREET VARCHAR(60) NULL,
		ADDR_AT_DX_SUPPLEMENTAL VARCHAR(60) NULL,
		ADDR_CURRENT_NO_AND_STREET VARCHAR(60) NULL,
		ADDR_CURRENT_SUPPLEMENTAL VARCHAR(60) NULL,
		TELEPHONE VARCHAR(10) NULL,
		DC_STATE_FILE_NUMBER VARCHAR(6) NULL,
		FOLLOW_UP_CONTACT_NAME VARCHAR(60) NULL,
		FOLLOW_UP_CONTACT_NO_AND_ST VARCHAR(60) NULL,
		FOLLOW_UP_CONTACT_SUPPL VARCHAR(60) NULL,
		LATITUDE VARCHAR(10) NULL,
		LONGITUDE VARCHAR(11) NULL,
		RESERVED_10 VARCHAR(200) NULL,
		NPI_FOLLOWING_REGISTRY VARCHAR(10) NULL,
		FOLLOWING_REGISTRY VARCHAR(10) NULL,
		NPI_INST_REFERRED_FROM VARCHAR(10) NULL,
		INSTITUTION_REFERRED_FROM VARCHAR(10) NULL,
		NPI_INST_REFERRED_TO VARCHAR(10) NULL,
		INSTITUTION_REFERRED_TO VARCHAR(10) NULL,
		RESERVED_11 VARCHAR(50) NULL,
		NPI_PHYSICIAN_MANAGING VARCHAR(10) NULL,
		PHYSICIAN_MANAGING VARCHAR(8) NULL,
		NPI_PHYSICIAN_FOLLOW_UP VARCHAR(10) NULL,
		PHYSICIAN_FOLLOW_UP VARCHAR(8) NULL,
		NPI_PHYSICIAN_PRIMARY_SURG VARCHAR(10) NULL,
		PHYSICIAN_PRIMARY_SURG VARCHAR(8) NULL,
		NPI_PHYSICIAN_3 VARCHAR(10) NULL,
		PHYSICIAN_3 VARCHAR(8) NULL,
		NPI_PHYSICIAN_4 VARCHAR(10) NULL,
		PHYSICIAN_4 VARCHAR(8) NULL,
		RESERVED_12 VARCHAR(50) NULL,
		PATH_REPORTING_FAC_ID_1 VARCHAR(25) NULL,
		PATH_REPORT_NUMBER_1 VARCHAR(20) NULL,
		PATH_DATE_SPEC_COLLECT_1 VARCHAR(14) NULL,
		PATH_REPORT_TYPE_1 VARCHAR(2) NULL,
		PATH_ORDERING_FAC_NO_1 VARCHAR(25) NULL,
		PATH_ORDER_PHYS_LIC_NO_1 VARCHAR(20) NULL,
		PATH_REPORTING_FAC_ID_2 VARCHAR(25) NULL,
		PATH_REPORT_NUMBER_2 VARCHAR(20) NULL,
		PATH_DATE_SPEC_COLLECT_2 VARCHAR(14) NULL,
		PATH_REPORT_TYPE_2 VARCHAR(2) NULL,
		PATH_ORDERING_FAC_NO_2 VARCHAR(25) NULL,
		PATH_ORDER_PHYS_LIC_NO_2 VARCHAR(20) NULL,
		PATH_REPORTING_FAC_ID_3 VARCHAR(25) NULL,
		PATH_REPORT_NUMBER_3 VARCHAR(20) NULL,
		PATH_DATE_SPEC_COLLECT_3 VARCHAR(14) NULL,
		PATH_REPORT_TYPE_3 VARCHAR(2) NULL,
		PATH_ORDERING_FAC_NO_3 VARCHAR(25) NULL,
		PATH_ORDER_PHYS_LIC_NO_3 VARCHAR(20) NULL,
		PATH_REPORTING_FAC_ID_4 VARCHAR(25) NULL,
		PATH_REPORT_NUMBER_4 VARCHAR(20) NULL,
		PATH_DATE_SPEC_COLLECT_4 VARCHAR(14) NULL,
		PATH_REPORT_TYPE_4 VARCHAR(2) NULL,
		PATH_ORDERING_FAC_NO_4 VARCHAR(25) NULL,
		PATH_ORDER_PHYS_LIC_NO_4 VARCHAR(20) NULL,
		PATH_REPORTING_FAC_ID_5 VARCHAR(25) NULL,
		PATH_REPORT_NUMBER_5 VARCHAR(20) NULL,
		PATH_DATE_SPEC_COLLECT_5 VARCHAR(14) NULL,
		PATH_REPORT_TYPE_5 VARCHAR(2) NULL,
		PATH_ORDERING_FAC_NO_5 VARCHAR(25) NULL,
		PATH_ORDER_PHYS_LIC_NO_5 VARCHAR(20) NULL,
		RESERVED_13 VARCHAR(500) NULL,
		TEXT_DX_PROC_PE VARCHAR(1000) NULL,
		TEXT_DX_PROC_XRAY_SCAN VARCHAR(1000) NULL,
		TEXT_DX_PROC_SCOPES VARCHAR(1000) NULL,
		TEXT_DX_PROC_LAB_TESTS VARCHAR(1000) NULL,
		TEXT_DX_PROC_OP VARCHAR(1000) NULL,
		TEXT_DX_PROC_PATH VARCHAR(1000) NULL,
		TEXT_PRIMARY_SITE_TITLE VARCHAR(100) NULL,
		TEXT_HISTOLOGY_TITLE VARCHAR(100) NULL,
		TEXT_STAGING VARCHAR(1000) NULL,
		RX_TEXT_SURGERY VARCHAR(1000) NULL,
		RX_TEXT_RADIATION_BEAM VARCHAR(1000) NULL,
		RX_TEXT_RADIATION_OTHER VARCHAR(1000) NULL,
		RX_TEXT_CHEMO VARCHAR(1000) NULL,
		RX_TEXT_HORMONE VARCHAR(1000) NULL,
		RX_TEXT_BRM VARCHAR(1000) NULL,
		RX_TEXT_OTHER VARCHAR(1000) NULL,
		TEXT_REMARKS VARCHAR(1000) NULL,
		TEXT_PLACE_OF_DIAGNOSIS VARCHAR(60) NULL,
		RESERVED_14 VARCHAR(2000) NULL,
		--CREATED DATETIME NOT NULL CONSTRAINT [DF_ONCOLOGY_DATA_VACCR_CREATED]  DEFAULT (getdate()),
		--CREATEDBY VARCHAR(30) NOT NULL CONSTRAINT [DF_ONCOLOGY_DATA_VACCR_CREATEDBY] DEFAULT ('Dataload_process'),
		CREATED DATETIME NOT NULL,
		CREATEDBY VARCHAR(30) NOT NULL,
		UPDATED DATETIME NULL,
		UPDATEDBY VARCHAR(30) NULL)
		
go

begin

  Insert into [dbo].[DatabaseChangeLog]
      ([MajorReleaseNumber]
       , [MinorReleaseNumber]
       , [PointReleaseNumber]
       , [Hotfix]
       , [ScriptName]
       , [ScriptDescription]
       , [TargetRegistry]
       , [DateApplied])
  Values
      ('05'
       ,'00'
       ,'039'
       ,0
       ,'Tracker #1582: Initial VACCR Setup'
       ,'Create table in V5_Registry database to import VACCR data files.'
       ,'VACCR'
      ,GETDATE())

End

