/*  Sherry Wang 5/17/2012
	EFR Tracker #1578: Add Provider ID to VITAS.IM_Notification_Letter table    
		- Add Provider ID to VITAS.IM_Notification_Letter table 
		- Drop and create VITAS.IM_Notification_Letter_H table
		- Drop and create triggers to populate the history table
*/
if not exists(Select * from sys.columns a, sys.tables b where  a.object_id = b.object_id  and  a.name = 'PROVIDER_ID' and  b.name = 'IM_NOTIFICATION_LETTER')
	ALTER TABLE [VITAS].[IM_NOTIFICATION_LETTER]
		ADD PROVIDER_ID [int] NULL
GO

IF  NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[VITAS].[FK_IM_NOTIFICATION_LETTER_PROVIDER]') AND parent_object_id = OBJECT_ID(N'[VITAS].[IM_NOTIFICATION_LETTER]'))
	ALTER TABLE [VITAS].[IM_NOTIFICATION_LETTER]  WITH CHECK ADD  CONSTRAINT [FK_IM_NOTIFICATION_LETTER_PROVIDER] FOREIGN KEY([PROVIDER_ID])
	REFERENCES [DBO].[PROVIDER] ([PROVIDER_ID])
GO


ALTER TABLE [VITAS].[IM_NOTIFICATION_LETTER] CHECK CONSTRAINT [FK_IM_NOTIFICATION_LETTER_PROVIDER]
GO
	
if exists(Select * from sys.columns where name='bDelete' and object_id=object_id('IM_NOTIFICATION_LETTER'))
BEGIN
Alter table IM_NOTIFICATION_LETTER
DROP CONSTRAINT IM_NOTIFICATION_LETTER_bDel_def
Alter table IM_NOTIFICATION_LETTER
DROP column bDelete
END
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VITAS].[IM_NOTIFICATION_LETTER_H]') AND type in (N'U'))
begin
DROP TABLE [VITAS].[IM_NOTIFICATION_LETTER_H]
end;
Create Table [VITAS].[IM_NOTIFICATION_LETTER_H](
[Audit_IM_NOTIFICATION_LETTER_H_ID] [int] IDENTITY(1,1) NOT NULL
, [Audit_Date] [datetime] NOT NULL
, [Audit_Type] [varchar](20) NOT NULL
, [Audit_ApplicationUser] [varchar](128)
, [Audit_SQLUser] [varchar](100)
, [ID] [int]
, [PARENT_NOTIFICATION_LETTER_ID] [int]
, [IM_IMPLANT_ITEM_ID] [int]
, [RECALL_ID] [int]
, [STD_IM_NOTIFICATION_STATUS_ID] [int]
, [STD_IM_NOTIFICATION_TYPE_ID] [int]
, [OTHER_NOTIFICATION_TEXT] [varchar](100)
, [NOTIFICATION_LETTER_FROM] [varchar](500)
, [NOTIFICATION_LETTER_TO] [varchar](500)
, [NOTIFICATION_BODY] [varchar](max)
, [NOTIFICATION_CLOSING] [varchar](500)
, [CREATED] [datetime]
, [CREATEDBY] [varchar](30)
, [UPDATED] [datetime]
, [UPDATEDBY] [varchar](30)
, [ROW_VERSON] [datetime]
, [PROVIDER_ID] [int]
, CONSTRAINT [IM_NOTIFICATION_LETTER_H_PK] PRIMARY KEY CLUSTERED 
(
[Audit_IM_NOTIFICATION_LETTER_H_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[VITAS].[TRG_IM_NOTIFICATION_LETTER_H]'))
DROP TRIGGER [VITAS].[TRG_IM_NOTIFICATION_LETTER_H]
GO
Create trigger [VITAS].[TRG_IM_NOTIFICATION_LETTER_H] on [VITAS].[IM_NOTIFICATION_LETTER]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [VITAS].[IM_NOTIFICATION_LETTER_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ID]
, [PARENT_NOTIFICATION_LETTER_ID]
, [IM_IMPLANT_ITEM_ID]
, [RECALL_ID]
, [STD_IM_NOTIFICATION_STATUS_ID]
, [STD_IM_NOTIFICATION_TYPE_ID]
, [OTHER_NOTIFICATION_TEXT]
, [NOTIFICATION_LETTER_FROM]
, [NOTIFICATION_LETTER_TO]
, [NOTIFICATION_BODY]
, [NOTIFICATION_CLOSING]
, [CREATED]
, [CREATEDBY]
, [UPDATED]
, [UPDATEDBY]
, [ROW_VERSON]
, [PROVIDER_ID]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ID]
, [PARENT_NOTIFICATION_LETTER_ID]
, [IM_IMPLANT_ITEM_ID]
, [RECALL_ID]
, [STD_IM_NOTIFICATION_STATUS_ID]
, [STD_IM_NOTIFICATION_TYPE_ID]
, [OTHER_NOTIFICATION_TEXT]
, [NOTIFICATION_LETTER_FROM]
, [NOTIFICATION_LETTER_TO]
, [NOTIFICATION_BODY]
, [NOTIFICATION_CLOSING]
, [CREATED]
, [CREATEDBY]
, [UPDATED]
, [UPDATEDBY]
, [ROW_VERSON]
, [PROVIDER_ID]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[VITAS].[TRG_IM_NOTIFICATION_LETTER_DEL_H]'))
DROP TRIGGER [VITAS].[TRG_IM_NOTIFICATION_LETTER_DEL_H]
go
CREATE TRIGGER  [VITAS].[TRG_IM_NOTIFICATION_LETTER_DEL_H]
on  [VITAS].[IM_NOTIFICATION_LETTER] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [VITAS].[IM_NOTIFICATION_LETTER_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ID]
, [PARENT_NOTIFICATION_LETTER_ID]
, [IM_IMPLANT_ITEM_ID]
, [RECALL_ID]
, [STD_IM_NOTIFICATION_STATUS_ID]
, [STD_IM_NOTIFICATION_TYPE_ID]
, [OTHER_NOTIFICATION_TEXT]
, [NOTIFICATION_LETTER_FROM]
, [NOTIFICATION_LETTER_TO]
, [NOTIFICATION_BODY]
, [NOTIFICATION_CLOSING]
, [CREATED]
, [CREATEDBY]
, [UPDATED]
, [UPDATEDBY]
, [ROW_VERSON]
, [PROVIDER_ID]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ID]
, [PARENT_NOTIFICATION_LETTER_ID]
, [IM_IMPLANT_ITEM_ID]
, [RECALL_ID]
, [STD_IM_NOTIFICATION_STATUS_ID]
, [STD_IM_NOTIFICATION_TYPE_ID]
, [OTHER_NOTIFICATION_TEXT]
, [NOTIFICATION_LETTER_FROM]
, [NOTIFICATION_LETTER_TO]
, [NOTIFICATION_BODY]
, [NOTIFICATION_CLOSING]
, [CREATED]
, [CREATEDBY]
, [UPDATED]
, [UPDATEDBY]
, [ROW_VERSON]
, [PROVIDER_ID]

From Deleted
End
go

begin

  Insert into [dbo].[DatabaseChangeLog]
      ([MajorReleaseNumber]
       , [MinorReleaseNumber]
       , [PointReleaseNumber]
       , [Hotfix]
       , [ScriptName]
       , [ScriptDescription]
       , [TargetRegistry]
       , [DateApplied])
  Values
      ('05'
       ,'00'
       ,'038'
       ,0
       ,'Tracker #1578: Add Provider ID to VITAS.IM_Notification_Letter table'
       ,'Add Provider ID to VITAS.IM_Notification_Letter table and its history table and make re-runnable.'
       ,'VITAS'
      ,GETDATE())

End