IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[vwEFRPatientOEFOIFHealthFactor]'))
DROP VIEW [dbo].[vwEFRPatientOEFOIFHealthFactor]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE VIEW [dbo].[vwEFRPatientOEFOIFHealthFactor]
AS
SELECT     PATIENT_ID, 1 AS HFExists
FROM         dbo.REFERRAL AS R
WHERE     EXISTS
                          (SELECT     REFERRAL_ID
                            FROM          dbo.REFERRAL_DETAIL
                            WHERE      (STD_HEALTHFACTOR_ID = 74) AND (REFERRAL_ID = R.REFERRAL_ID))

GO
begin
INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('05'
           ,'00'
           ,'036'
           ,0
           ,'Tracker #1567'
		   ,'Adds a view that contains EFR patients that have the Iraq/Afghan Service Health Factor.'
           ,'EFR'
           ,GETDATE())
end
GO

