

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[VITAS].[FK_IM_PRIMARY_CARE_PHYSICIAN_PATIENT]') AND parent_object_id = OBJECT_ID(N'[VITAS].[IM_PRIMARY_CARE_PHYSICIAN]'))
ALTER TABLE [VITAS].[IM_PRIMARY_CARE_PHYSICIAN] DROP CONSTRAINT [FK_IM_PRIMARY_CARE_PHYSICIAN_PATIENT]
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[VITAS].[FK_IM_PRIMARY_CARE_PHYSICIAN_Provider]') AND parent_object_id = OBJECT_ID(N'[VITAS].[IM_PRIMARY_CARE_PROVIDER]'))
ALTER TABLE [VITAS].[IM_PRIMARY_CARE_PHYSICIAN] DROP CONSTRAINT [FK_IM_PRIMARY_CARE_PHYSICIAN_PROVIDER]
GO
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VITAS].[IM_PRIMARY_CARE_PHYSICIAN]') AND type in (N'U'))
DROP TABLE [VITAS].[IM_PRIMARY_CARE_PHYSICIAN]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VITAS].[IM_PRIMARY_CARE_PHYSICIAN_H]') AND type in (N'U'))
DROP TABLE [VITAS].[IM_PRIMARY_CARE_PHYSICIAN_H]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [VITAS].[IM_PRIMARY_CARE_PHYSICIAN](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[PATIENT_ID] [int] NULL,
	[Provider_ID] [int] NULL,
	[ROW_VERSION] [timestamp] NOT NULL,
	[CREATED] [datetime] NOT NULL,
	[UPDATED] [datetime] NOT NULL,
	[CREATEDBY] [varchar](30) NOT NULL,
	[UPDATEDBY] [varchar](30) NOT NULL,
 CONSTRAINT [IM_PCP_PK] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [VITAS].[IM_PRIMARY_CARE_PHYSICIAN_H](
	[Audit_IM_PRIMARY_CARE_PHYSICIAN_H_ID] [int] IDENTITY(1,1) NOT NULL,
	[Audit_Date] [datetime] NOT NULL,
	[Audit_Type] [varchar](20) NOT NULL,
	[Audit_ApplicationUser] [varchar](128) NULL,
	[Audit_SQLUser] [varchar](100) NULL,
	[ID] [int] NULL,
	[PATIENT_ID] [int] NULL,
	[Provider_ID] [int] NULL,
	[CREATED] [datetime] NULL,
	[UPDATED] [datetime] NULL,
	[CREATEDBY] [varchar](30) NULL,
	[UPDATEDBY] [varchar](30) NULL,
 CONSTRAINT [IM_PRIMARY_CARE_PHYSICIAN_H_PK] PRIMARY KEY CLUSTERED 
(
	[Audit_IM_PRIMARY_CARE_PHYSICIAN_H_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

ALTER TABLE [VITAS].[IM_PRIMARY_CARE_PHYSICIAN]  WITH CHECK ADD  CONSTRAINT [FK_IM_PRIMARY_CARE_PHYSICIAN_PATIENT] FOREIGN KEY([PATIENT_ID])
REFERENCES [dbo].[PATIENT] ([PATIENT_ID])
ON UPDATE CASCADE
ON DELETE CASCADE
GO

ALTER TABLE [VITAS].[IM_PRIMARY_CARE_PHYSICIAN] CHECK CONSTRAINT [FK_IM_PRIMARY_CARE_PHYSICIAN_PATIENT]
GO

ALTER TABLE [VITAS].[IM_PRIMARY_CARE_PHYSICIAN]  WITH CHECK ADD  CONSTRAINT [FK_IM_PRIMARY_CARE_PHYSICIAN_PROVIDER] FOREIGN KEY([PROVIDER_ID])
REFERENCES [dbo].[PROVIDER] ([PROVIDER_ID])
ON UPDATE CASCADE
ON DELETE CASCADE
GO

ALTER TABLE [VITAS].[IM_PRIMARY_CARE_PHYSICIAN] CHECK CONSTRAINT [FK_IM_PRIMARY_CARE_PHYSICIAN_PROVIDER]
GO

IF  EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[VITAS].[TRG_IM_PRIMARY_CARE_PHYSICIAN_DEL_H]'))
DROP TRIGGER [VITAS].[TRG_IM_PRIMARY_CARE_PHYSICIAN_DEL_H]
GO

IF  EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[VITAS].[TRG_IM_PRIMARY_CARE_PHYSICIAN_H]'))
DROP TRIGGER [VITAS].[TRG_IM_PRIMARY_CARE_PHYSICIAN_H]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TRIGGER  [VITAS].[TRG_IM_PRIMARY_CARE_PHYSICIAN_DEL_H]
on  [VITAS].[IM_PRIMARY_CARE_PHYSICIAN] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [VITAS].[IM_PRIMARY_CARE_PHYSICIAN_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ID]
, [PATIENT_ID]
, [Provider_ID]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ID]
, [PATIENT_ID]
, [Provider_ID]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

From Deleted
End

GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

Create trigger [VITAS].[TRG_IM_PRIMARY_CARE_PHYSICIAN_H] on [VITAS].[IM_PRIMARY_CARE_PHYSICIAN]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [VITAS].[IM_PRIMARY_CARE_PHYSICIAN_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ID]
, [PATIENT_ID]
, [Provider_ID]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ID]
, [PATIENT_ID]
, [Provider_ID]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

FROM INSERTED
End

GO




begin

  Insert into [dbo].[DatabaseChangeLog]
      ([MajorReleaseNumber]
       , [MinorReleaseNumber]
       , [PointReleaseNumber]
       , [Hotfix]
       , [ScriptName]
       , [ScriptDescription]
       , [TargetRegistry]
       , [DateApplied])
  Values
      ('05'
       ,'00'
       ,'034'
       ,0
       ,'Tracker #1542'
       ,'Drop and recreate the Primary Care Physician table, History table and Triggers.'
       ,'VITAS'
      ,GETDATE())

End