--Z Goldman
--VITAS #1523
--	Added a column defaulting to 0 to VITAS.STD_IM_NO_ACTION_TAKEN table
--	Set CLEARS_RECALL flag for 'DECEASED','PATIENT IDENTIFIED IN ERROR','PREVIOUSLY EXPLANTED' to YES 

--Add new column to indicate whether this item should clear Recall Alert indicator, default to NO
IF NOT EXISTS( SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'STD_IM_NO_ACTION_TAKEN' AND  COLUMN_NAME = 'CLEARS_RECALL')
BEGIN
	IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_STD_IM_NO_ACTION_TAKEN_CLEARS_RECALL]') AND type = 'D')
	ALTER TABLE [VITAS].[STD_IM_NO_ACTION_TAKEN] DROP CONSTRAINT [DF_STD_IM_NO_ACTION_TAKEN_CLEARS_RECALL]

	ALTER TABLE VITAS.STD_IM_NO_ACTION_TAKEN
	ADD 
		CLEARS_RECALL bit NOT NULL,
		CONSTRAINT DF_STD_IM_NO_ACTION_TAKEN_CLEARS_RECALL  DEFAULT ((0)) FOR [CLEARS_RECALL]
END 
GO

--Standard data update
UPDATE VITAS.STD_IM_NO_ACTION_TAKEN
SET [CLEARS_RECALL]=1
WHERE [CODE] IN ('DECEASED','PATIENT IDENTIFIED IN ERROR','PREVIOUSLY EXPLANTED')

GO
begin

  Insert into [dbo].[DatabaseChangeLog]
      ([MajorReleaseNumber]
       , [MinorReleaseNumber]
       , [PointReleaseNumber]
       , [Hotfix]
       , [ScriptName]
       , [ScriptDescription]
       , [TargetRegistry]
       , [DateApplied])
  Values
      ('05'
       ,'00'
       ,'032'
       ,0
       ,'Tracker #1523'
       ,'Added column defaulting 0 to VITAS.STD_IM_NO_ACTION_TAKEN table, Set CLEARS_RECALL flag for "DECEASED", etc to YES'
       ,'VITAS'
      ,GETDATE())

End
GO
