/*	Z Goldman
	VITAS #1486 User Admin module
		Creates new roles
		Adds new app page category for patient search screens
		Assigns screen permissions for each new role
		Assigns new roles to current users
		Deletes old roles from all tables where they are involved
*/
--Allow reruns of this script
DELETE FROM ROLE_PERMISSIONS WHERE STD_ROLE_ID IN (400, 401, 402, 403, 404, 405, 406);
DELETE FROM USER_ROLES WHERE STD_ROLE_ID IN (400, 401, 402, 403, 404, 405, 406);
DELETE FROM STD_ROLE WHERE ID IN (400, 401, 402, 403, 404, 405, 406);

--Create new roles 
SET IDENTITY_INSERT [dbo].STD_ROLE ON

INSERT [dbo].STD_ROLE 
	([ID],[CODE],[NAME],[DESCRIPTION_TEXT],[SORT_ORDER],[INACTIVE_FLAG],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED],[STD_REGISTRY_ID],[SUPER_USER_FLAG]) 
VALUES 
	(400,'VITAS_Admin','VITAS Administrator','VITAS Administrator',0,0,'Increment 5','Increment 5',GETDATE(),GETDATE(), 4, 1);

INSERT [dbo].STD_ROLE 
	([ID],[CODE],[NAME],[DESCRIPTION_TEXT],[SORT_ORDER],[INACTIVE_FLAG],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED],[STD_REGISTRY_ID],[SUPER_USER_FLAG]) 
VALUES 
	(401,'VITAS_Implant','VITAS User','VITAS User',1,0,'Increment 5','Increment 5',GETDATE(),GETDATE(), 4, 0);

INSERT [dbo].STD_ROLE 
	([ID],[CODE],[NAME],[DESCRIPTION_TEXT],[SORT_ORDER],[INACTIVE_FLAG],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED],[STD_REGISTRY_ID],[SUPER_USER_FLAG]) 
VALUES 
	(402,'VITAS_ImplantMod','VITAS Editor','VITAS Editor',2,0,'Increment 5','Increment 5',GETDATE(),GETDATE(), 4, 0);

INSERT [dbo].STD_ROLE 
	([ID],[CODE],[NAME],[DESCRIPTION_TEXT],[SORT_ORDER],[INACTIVE_FLAG],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED],[STD_REGISTRY_ID],[SUPER_USER_FLAG]) 
VALUES 
	(403,'VITAS_Recall','VITAS Recall User','VITAS Recall User',3,0,'Increment 5','Increment 5',GETDATE(),GETDATE(), 4, 0);

INSERT [dbo].STD_ROLE 
	([ID],[CODE],[NAME],[DESCRIPTION_TEXT],[SORT_ORDER],[INACTIVE_FLAG],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED],[STD_REGISTRY_ID],[SUPER_USER_FLAG]) 
VALUES 
	(404,'VITAS_RecallMod','VITAS Recall Editor','VITAS Recall Editor',4,0,'Increment 5','Increment 5',GETDATE(),GETDATE(), 4, 0);

INSERT [dbo].STD_ROLE 
	([ID],[CODE],[NAME],[DESCRIPTION_TEXT],[SORT_ORDER],[INACTIVE_FLAG],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED],[STD_REGISTRY_ID],[SUPER_USER_FLAG]) 
VALUES 
	(405,'VITAS_ReportStd','VITAS Standard Report User','VITAS Standard Report User',5,0,'Increment 5','Increment 5',GETDATE(),GETDATE(), 4, 0);

INSERT [dbo].STD_ROLE 
	([ID],[CODE],[NAME],[DESCRIPTION_TEXT],[SORT_ORDER],[INACTIVE_FLAG],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED],[STD_REGISTRY_ID],[SUPER_USER_FLAG]) 
VALUES 
	(406,'VITAS_ReportAdH','VITAS Ad Hoc Report User','VITAS Ad Hoc Report User',6,0,'Increment 5','Increment 5',GETDATE(),GETDATE(), 4, 0);

SET IDENTITY_INSERT [dbo].STD_ROLE OFF
GO

--Add new app page categories for patient search screens and reporting
DELETE FROM [dbo].[STD_APPPAGE] WHERE [CODE]='VITAS_PATIENTS_SEARCH';
INSERT [dbo].[STD_APPPAGE]
	([CODE],[NAME],[DESCRIPTION_TEXT],[SORT_ORDER],[INACTIVE_FLAG],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
VALUES
	('VITAS_PATIENTS_SEARCH','VITAS PATIENTS SEARCH','VITAS PATIENTS SEARCH',1,0,'Increment 5','Increment 5',GETDATE(),GETDATE()); 

DELETE FROM [dbo].[STD_APPPAGE] WHERE [CODE]='VITAS_REPORTS';
INSERT [dbo].[STD_APPPAGE]
	([CODE],[NAME],[DESCRIPTION_TEXT],[SORT_ORDER],[INACTIVE_FLAG],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
VALUES
	('VITAS_REPORTS','VITAS REPORTS','VITAS REPORTS',1,0,'Increment 5','Increment 5',GETDATE(),GETDATE()); 
	
--Assign screen permissions for each role
INSERT INTO dbo.ROLE_PERMISSIONS 
	([STD_ROLE_ID],[STD_APPPAGE_ID],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED],[INSERT_FLAG],[UPDATE_FLAG],[DELETE_FLAG])
SELECT 400, dbo.STD_APPPAGE.ID, 'Increment 5', 'Increment 5', GETDATE(), GETDATE(), 1, 1, 1
FROM dbo.STD_APPPAGE WHERE [CODE] LIKE 'VITAS%';

INSERT INTO dbo.ROLE_PERMISSIONS 
	([STD_ROLE_ID],[STD_APPPAGE_ID],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED],[INSERT_FLAG],[UPDATE_FLAG],[DELETE_FLAG])
SELECT 401, dbo.STD_APPPAGE.ID, 'Increment 5', 'Increment 5', GETDATE(), GETDATE(), 1, 1, 1
FROM dbo.STD_APPPAGE WHERE [CODE]='VITAS_PATIENTS_SEARCH';

INSERT INTO dbo.ROLE_PERMISSIONS 
	([STD_ROLE_ID],[STD_APPPAGE_ID],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
SELECT 401, dbo.STD_APPPAGE.ID, 'Increment 5', 'Increment 5', GETDATE(), GETDATE()
FROM dbo.STD_APPPAGE WHERE [CODE]='VITAS_PATIENTS';

INSERT INTO dbo.ROLE_PERMISSIONS 
	([STD_ROLE_ID],[STD_APPPAGE_ID],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED],[INSERT_FLAG],[UPDATE_FLAG],[DELETE_FLAG])
SELECT 402, dbo.STD_APPPAGE.ID, 'Increment 5', 'Increment 5', GETDATE(), GETDATE(), 1, 1, 1
FROM dbo.STD_APPPAGE WHERE [CODE] IN ('VITAS_PATIENTS_SEARCH','VITAS_PATIENTS');

INSERT INTO dbo.ROLE_PERMISSIONS 
	([STD_ROLE_ID],[STD_APPPAGE_ID],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
SELECT 403, dbo.STD_APPPAGE.ID, 'Increment 5', 'Increment 5', GETDATE(), GETDATE()
FROM dbo.STD_APPPAGE WHERE [CODE]='VITAS_RECALLDATA';

INSERT INTO dbo.ROLE_PERMISSIONS 
	([STD_ROLE_ID],[STD_APPPAGE_ID],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED],[INSERT_FLAG],[UPDATE_FLAG],[DELETE_FLAG])
SELECT 403, dbo.STD_APPPAGE.ID, 'Increment 5', 'Increment 5', GETDATE(), GETDATE(), 1, 1, 1
FROM dbo.STD_APPPAGE WHERE [CODE]='VITAS_NOTIFICATIONS';

INSERT INTO dbo.ROLE_PERMISSIONS 
	([STD_ROLE_ID],[STD_APPPAGE_ID],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED],[INSERT_FLAG],[UPDATE_FLAG],[DELETE_FLAG])
SELECT 404, dbo.STD_APPPAGE.ID, 'Increment 5', 'Increment 5', GETDATE(), GETDATE(), 1, 1, 1
FROM dbo.STD_APPPAGE WHERE [CODE] IN ('VITAS_RECALLDATA','VITAS_NOTIFICATIONS');

INSERT INTO dbo.ROLE_PERMISSIONS 
	([STD_ROLE_ID],[STD_APPPAGE_ID],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED],[INSERT_FLAG],[UPDATE_FLAG],[DELETE_FLAG])
SELECT 405, dbo.STD_APPPAGE.ID, 'Increment 5', 'Increment 5', GETDATE(), GETDATE(), 1, 1, 1
FROM dbo.STD_APPPAGE WHERE [CODE] IN ('VITAS_REPORTS','VITAS_STANDARD_REPORTS');

INSERT INTO dbo.ROLE_PERMISSIONS 
	([STD_ROLE_ID],[STD_APPPAGE_ID],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED],[INSERT_FLAG],[UPDATE_FLAG],[DELETE_FLAG])
SELECT 406,dbo.STD_APPPAGE.ID,'Increment 5','Increment 5',GETDATE(),GETDATE(),1,1,1
FROM dbo.STD_APPPAGE WHERE [CODE] IN ('VITAS_REPORTS','VITAS_ADHOC_REPORTING');

--Assign new roles to current users
INSERT INTO dbo.USER_ROLES 
	([USER_ID],[STD_ROLE_ID],[STD_INSTITUTION_ID],[INACTIVE_FLAG],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
SELECT DISTINCT [USER_ID],400,[STD_INSTITUTION_ID],0,'Increment 5','Increment 5',GETDATE(),GETDATE()
FROM dbo.USER_ROLES WHERE dbo.USER_ROLES.[STD_ROLE_ID]=29 AND [INACTIVE_FLAG]=0;

INSERT INTO dbo.USER_ROLES 
	([USER_ID],[STD_ROLE_ID],[STD_INSTITUTION_ID],[INACTIVE_FLAG],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
SELECT DISTINCT [USER_ID],401,[STD_INSTITUTION_ID],0,'Increment 5','Increment 5',GETDATE(),GETDATE()
FROM dbo.USER_ROLES WHERE dbo.USER_ROLES.[STD_ROLE_ID] IN (30, 31, 32, 33, 34) AND [INACTIVE_FLAG]=0;



--Delete old roles
DELETE FROM ROLE_PERMISSIONS WHERE STD_ROLE_ID IN (29, 30, 31, 32, 33, 34);
DELETE FROM USER_ROLES WHERE STD_ROLE_ID IN (29, 30, 31, 32, 33, 34);
DELETE FROM STD_ROLE WHERE ID IN (29, 30, 31, 32, 33, 34);

begin

  Insert into [dbo].[DatabaseChangeLog]
      ([MajorReleaseNumber]
       , [MinorReleaseNumber]
       , [PointReleaseNumber]
       , [Hotfix]
       , [ScriptName]
       , [ScriptDescription]
       , [TargetRegistry]
       , [DateApplied])
  Values
      ('05'
       ,'00'
       ,'030'
       ,0
       ,'Tracker #1486'
       ,'Creates new roles, Adds new app page category, Assigns screen permissions for new roles, Assigns new roles to users, deletes old roles'
       ,'VITAS'
      ,GETDATE())

End



