--Z Goldman
--VITAS #1493 Add follow-up notifications 
--	Modified STD_IM_NOTIFICATION_TYPE and IM_NOTIFICATION_LETTER tables
--	Synchronized audit table IM_NOTIFICATION_LETTER_H with application table IM_NOTIFICATION_LETTER
--	Added standard data required for follow-up notifications
--	Transfered notifications from [IM_IMPLANT_ITEM] table to IM_NOTIFICATION_LETTER
--	Modified StoredProcedure [dbo].[SetRecallTargetDate] to generate recall alert notifications in IM_NOTIFICATION_LETTER table


--Drop [VITAS].[IM_NOTIFICATION_LETTER] to remove dependencies in further processing
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[VITAS].[FK_IM_NOTIFICATION_LETTER_IM_NOTIFICATION_LETTER]') AND parent_object_id = OBJECT_ID(N'[VITAS].[IM_NOTIFICATION_LETTER]'))
ALTER TABLE [VITAS].[IM_NOTIFICATION_LETTER] DROP CONSTRAINT [FK_IM_NOTIFICATION_LETTER_IM_NOTIFICATION_LETTER]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[VITAS].[FK_IM_NOTIFICATION_LETTER_IM_RECALL]') AND parent_object_id = OBJECT_ID(N'[VITAS].[IM_NOTIFICATION_LETTER]'))
ALTER TABLE [VITAS].[IM_NOTIFICATION_LETTER] DROP CONSTRAINT [FK_IM_NOTIFICATION_LETTER_IM_RECALL]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[VITAS].[FK_IM_NOTIFICATION_LETTER_IM_IMPLANT_ITEM]') AND parent_object_id = OBJECT_ID(N'[VITAS].[IM_NOTIFICATION_LETTER]'))
ALTER TABLE [VITAS].[IM_NOTIFICATION_LETTER] DROP CONSTRAINT [FK_IM_NOTIFICATION_LETTER_IM_IMPLANT_ITEM]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[VITAS].[FK_IM_NOTIFICATION_LETTER_STD_IM_NOTIFICATION_STATUS]') AND parent_object_id = OBJECT_ID(N'[VITAS].[IM_NOTIFICATION_LETTER]'))
ALTER TABLE [VITAS].[IM_NOTIFICATION_LETTER] DROP CONSTRAINT [FK_IM_NOTIFICATION_LETTER_STD_IM_NOTIFICATION_STATUS]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[VITAS].[FK_IM_NOTIFICATION_LETTER_IM_IMPLANT_ITEM]') AND parent_object_id = OBJECT_ID(N'[VITAS].[IM_NOTIFICATION_LETTER]'))
ALTER TABLE [VITAS].[IM_NOTIFICATION_LETTER] DROP CONSTRAINT [FK_IM_NOTIFICATION_LETTER_IM_IMPLANT_ITEM]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[VITAS].[FK_IM_NOTIFICATION_LETTER_IM_RECALL]') AND parent_object_id = OBJECT_ID(N'[VITAS].[IM_NOTIFICATION_LETTER]'))
ALTER TABLE [VITAS].[IM_NOTIFICATION_LETTER] DROP CONSTRAINT [FK_IM_NOTIFICATION_LETTER_IM_RECALL]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[VITAS].[FK_IM_NOTIFICATION_LETTER_IM_NOTIFICATION_LIST_DETAIL]') AND parent_object_id = OBJECT_ID(N'[VITAS].[IM_NOTIFICATION_LETTER]'))
ALTER TABLE [VITAS].[IM_NOTIFICATION_LETTER] DROP CONSTRAINT [FK_IM_NOTIFICATION_LETTER_IM_NOTIFICATION_LIST_DETAIL]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[VITAS].[FK_IM_PATIENT_ALERT_NOTIFICATION_STD_IM_ALERT]') AND parent_object_id = OBJECT_ID(N'[VITAS].[IM_NOTIFICATION_LETTER]'))
ALTER TABLE [VITAS].[IM_NOTIFICATION_LETTER] DROP CONSTRAINT [FK_IM_PATIENT_ALERT_NOTIFICATION_STD_IM_ALERT]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[VITAS].[FK_IM_PATIENT_ALERT_NOTIFICATION_STD_IM_NOTIFICATION_TYPE]') AND parent_object_id = OBJECT_ID(N'[VITAS].[IM_NOTIFICATION_LETTER]'))
ALTER TABLE [VITAS].[IM_NOTIFICATION_LETTER] DROP CONSTRAINT [FK_IM_PATIENT_ALERT_NOTIFICATION_STD_IM_NOTIFICATION_TYPE]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[VITAS].[FK_IM_PATIENT_ALERT_NOTIFICATION_STD_IM_OTHER_NOTIFICATION_TYPE]') AND parent_object_id = OBJECT_ID(N'[VITAS].[IM_NOTIFICATION_LETTER]'))
ALTER TABLE [VITAS].[IM_NOTIFICATION_LETTER] DROP CONSTRAINT [FK_IM_PATIENT_ALERT_NOTIFICATION_STD_IM_OTHER_NOTIFICATION_TYPE]
GO

IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_IM_NOTIFICATION_LETTER_CREATED]') AND type = 'D')
BEGIN
ALTER TABLE [VITAS].[IM_NOTIFICATION_LETTER] DROP CONSTRAINT [DF_IM_NOTIFICATION_LETTER_CREATED]
END

GO

IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_IM_NOTIFICATION_LETTER_UPDATED]') AND type = 'D')
BEGIN
ALTER TABLE [VITAS].[IM_NOTIFICATION_LETTER] DROP CONSTRAINT [DF_IM_NOTIFICATION_LETTER_UPDATED]
END

GO

/****** Object:  Table [VITAS].[IM_NOTIFICATION_LETTER]    Script Date: 03/28/2012 13:46:27 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VITAS].[IM_NOTIFICATION_LETTER]') AND type in (N'U'))
DROP TABLE [VITAS].[IM_NOTIFICATION_LETTER]
GO














--***************************************************
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_STD_IM_NOTIFICATION_TYPE_CREATED]') AND type = 'D')
BEGIN
ALTER TABLE [VITAS].[STD_IM_NOTIFICATION_TYPE] DROP CONSTRAINT [DF_STD_IM_NOTIFICATION_TYPE_CREATED]
END

GO

IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_STD_IM_NOTIFICATION_TYPE_UPDATED]') AND type = 'D')
BEGIN
ALTER TABLE [VITAS].[STD_IM_NOTIFICATION_TYPE] DROP CONSTRAINT [DF_STD_IM_NOTIFICATION_TYPE_UPDATED]
END

GO

/****** Object:  Table [VITAS].[STD_IM_NOTIFICATION_TYPE]    Script Date: 03/29/2012 09:57:41 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VITAS].[STD_IM_NOTIFICATION_TYPE]') AND type in (N'U'))
DROP TABLE [VITAS].[STD_IM_NOTIFICATION_TYPE]
GO

/****** Object:  Table [VITAS].[STD_IM_NOTIFICATION_TYPE]    Script Date: 03/29/2012 09:57:41 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [VITAS].[STD_IM_NOTIFICATION_TYPE](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[CODE] [varchar](50) NOT NULL,
	[NAME] [varchar](100) NOT NULL,
	[DESCRIPTION_TEXT] [varchar](500) NOT NULL,
	[SORT_ORDER] [int] NOT NULL,
	[NOTIFICATION_TEXT] [varchar](max) NULL,
	[INACTIVE_FLAG] [bit] NOT NULL,
	[INACTIVE_DATE] [datetime] NULL,
	[CREATEDBY] [varchar](30) NOT NULL,
	[CREATED] [datetime] NOT NULL,
	[UPDATEDBY] [varchar](30) NOT NULL,
	[UPDATED] [datetime] NOT NULL,
	[ROW_VERSION] [timestamp] NOT NULL,
 CONSTRAINT [PK_STD_IM_NOTIFICATION_TYPE] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

ALTER TABLE [VITAS].[STD_IM_NOTIFICATION_TYPE] ADD  CONSTRAINT [DF_STD_IM_NOTIFICATION_TYPE_CREATED]  DEFAULT (getdate()) FOR [CREATED]
GO

ALTER TABLE [VITAS].[STD_IM_NOTIFICATION_TYPE] ADD  CONSTRAINT [DF_STD_IM_NOTIFICATION_TYPE_UPDATED]  DEFAULT (getdate()) FOR [UPDATED]
GO















--***************************
SET IDENTITY_INSERT [VITAS].STD_IM_NOTIFICATION_TYPE ON
INSERT [VITAS].[STD_IM_NOTIFICATION_TYPE] ([ID],[CODE],[NAME],[DESCRIPTION_TEXT],[SORT_ORDER],[INACTIVE_FLAG],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED]) VALUES (1,'ALERT','Implant Alert Notification','Implant Alert Notification',1,0,'Initial',GETDATE(),'Initial',GETDATE());
INSERT [VITAS].[STD_IM_NOTIFICATION_TYPE] ([ID],[CODE],[NAME],[DESCRIPTION_TEXT],[SORT_ORDER],[INACTIVE_FLAG],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED]) VALUES (2,'F_REMINDER','Follow Up: Reminder of alert notice','Follow Up: Reminder of alert notice',2,0,'Initial',GETDATE(),'Initial',GETDATE());
INSERT [VITAS].[STD_IM_NOTIFICATION_TYPE] ([ID],[CODE],[NAME],[DESCRIPTION_TEXT],[SORT_ORDER],[INACTIVE_FLAG],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED]) VALUES (3,'OTHER','Other','Other',3,0,'Initial',GETDATE(),'Initial',GETDATE());
INSERT [VITAS].[STD_IM_NOTIFICATION_TYPE] ([ID],[CODE],[NAME],[DESCRIPTION_TEXT],[SORT_ORDER],[INACTIVE_FLAG],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED]) VALUES (4,'NULL VALUE','','NULL VALUE',4,0,'Initial',GETDATE(),'Initial',GETDATE());
SET IDENTITY_INSERT [VITAS].STD_IM_NOTIFICATION_TYPE OFF
GO

UPDATE [VITAS].STD_IM_NOTIFICATION_TYPE SET [NOTIFICATION_TEXT]='This notification is being sent to you on behalf of The Department of Veterans Affairs (VA) in order to inform you that you may be affected by a national recall issued for an implanted medical device. The VAs records indicate that you have received this implant as part of a prior medical procedure, and I would like to discuss this in more detail with you so that we can outline an appropriate course of action. Please contact my office as soon as possible to schedule an appointment.' WHERE [CODE]='ALERT';
GO











--******************************************************
/****** Object:  Table [VITAS].[IM_NOTIFICATION_LETTER]    Script Date: 03/28/2012 13:46:28 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [VITAS].[IM_NOTIFICATION_LETTER](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[PARENT_NOTIFICATION_LETTER_ID] [int] NULL,
	[IM_IMPLANT_ITEM_ID] [int] NOT NULL,
	[RECALL_ID] [int] NOT NULL,
	[STD_IM_NOTIFICATION_STATUS_ID] [int] NOT NULL,
	[STD_IM_NOTIFICATION_TYPE_ID] [int] NOT NULL,
	[OTHER_NOTIFICATION_TEXT] [varchar](100) NULL,
	[NOTIFICATION_LETTER_FROM] [varchar](500) NULL,
	[NOTIFICATION_LETTER_TO] [varchar](500) NULL,
	[NOTIFICATION_BODY] [varchar](max) NULL,
	[NOTIFICATION_CLOSING] [varchar](500) NULL,
	[CREATED] [datetime] NOT NULL,
	[CREATEDBY] [varchar](30) NOT NULL,
	[UPDATED] [datetime] NOT NULL,
	[UPDATEDBY] [varchar](30) NOT NULL,
	[ROW_VERSON] [timestamp] NOT NULL,
 CONSTRAINT [PK_IM_PATIENT_ALERT_NOTIFICATION] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'IM_NOTIFICATION_LETTER has one-to-one relationship with IM_NOTIFICATION_LIST_DETAIL.  So  IM_NOTIFICATION_LETTER.ID=IM_NOTIFICATION_LIST_DETAIL.ID' , @level0type=N'SCHEMA',@level0name=N'VITAS', @level1type=N'TABLE',@level1name=N'IM_NOTIFICATION_LETTER', @level2type=N'COLUMN',@level2name=N'ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Self Join Foreign Key, pointing to ID column in the same table.  A letter can be a follow-up for a letter sent out previously. ' , @level0type=N'SCHEMA',@level0name=N'VITAS', @level1type=N'TABLE',@level1name=N'IM_NOTIFICATION_LETTER', @level2type=N'COLUMN',@level2name=N'PARENT_NOTIFICATION_LETTER_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'IM_NOTIFICATION_LETTER_TABLE', @value=N'IM_NOTIFICATION_LIST_DETAIL AND IM_NOTIFICATION_LETTER  IS ONE TO ONE RELATIONSHIP' , @level0type=N'SCHEMA',@level0name=N'VITAS', @level1type=N'TABLE',@level1name=N'IM_NOTIFICATION_LETTER'
GO

ALTER TABLE [VITAS].[IM_NOTIFICATION_LETTER]  WITH CHECK ADD  CONSTRAINT [FK_IM_NOTIFICATION_LETTER_IM_NOTIFICATION_LETTER] FOREIGN KEY([PARENT_NOTIFICATION_LETTER_ID])
REFERENCES [VITAS].[IM_NOTIFICATION_LETTER] ([ID])
GO

ALTER TABLE [VITAS].[IM_NOTIFICATION_LETTER] CHECK CONSTRAINT [FK_IM_NOTIFICATION_LETTER_IM_NOTIFICATION_LETTER]
GO

ALTER TABLE [VITAS].[IM_NOTIFICATION_LETTER]  WITH CHECK ADD  CONSTRAINT [FK_IM_NOTIFICATION_LETTER_IM_RECALL] FOREIGN KEY([RECALL_ID])
REFERENCES [VITAS].[IM_RECALL] ([RECALL_ID])
GO

ALTER TABLE [VITAS].[IM_NOTIFICATION_LETTER] CHECK CONSTRAINT [FK_IM_NOTIFICATION_LETTER_IM_RECALL]
GO

ALTER TABLE [VITAS].[IM_NOTIFICATION_LETTER]  WITH CHECK ADD  CONSTRAINT [FK_IM_NOTIFICATION_LETTER_IM_IMPLANT_ITEM] FOREIGN KEY([IM_IMPLANT_ITEM_ID])
REFERENCES [VITAS].[IM_IMPLANT_ITEM] ([ID])
GO

ALTER TABLE [VITAS].[IM_NOTIFICATION_LETTER] CHECK CONSTRAINT [FK_IM_NOTIFICATION_LETTER_IM_IMPLANT_ITEM]
GO

ALTER TABLE [VITAS].[IM_NOTIFICATION_LETTER]  WITH CHECK ADD  CONSTRAINT [FK_IM_NOTIFICATION_LETTER_STD_IM_NOTIFICATION_STATUS] FOREIGN KEY([STD_IM_NOTIFICATION_STATUS_ID])
REFERENCES [VITAS].[STD_IM_NOTIFICATION_STATUS] ([ID])
GO

ALTER TABLE [VITAS].[IM_NOTIFICATION_LETTER] CHECK CONSTRAINT [FK_IM_NOTIFICATION_LETTER_STD_IM_NOTIFICATION_STATUS]
GO

ALTER TABLE [VITAS].[IM_NOTIFICATION_LETTER]  WITH CHECK ADD  CONSTRAINT [FK_IM_PATIENT_ALERT_NOTIFICATION_STD_IM_NOTIFICATION_TYPE] FOREIGN KEY([STD_IM_NOTIFICATION_TYPE_ID])
REFERENCES [VITAS].[STD_IM_NOTIFICATION_TYPE] ([ID])
GO

ALTER TABLE [VITAS].[IM_NOTIFICATION_LETTER] CHECK CONSTRAINT [FK_IM_PATIENT_ALERT_NOTIFICATION_STD_IM_NOTIFICATION_TYPE]
GO

ALTER TABLE [VITAS].[IM_NOTIFICATION_LETTER] ADD  CONSTRAINT [DF_IM_NOTIFICATION_LETTER_CREATED]  DEFAULT (getdate()) FOR [CREATED]
GO

ALTER TABLE [VITAS].[IM_NOTIFICATION_LETTER] ADD  CONSTRAINT [DF_IM_NOTIFICATION_LETTER_UPDATED]  DEFAULT (getdate()) FOR [UPDATED]
GO






/****** Object:  Table [VITAS].[IM_NOTIFICATION_LETTER_H]    Script Date: 04/16/2012 14:46:31 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VITAS].[IM_NOTIFICATION_LETTER_H]') AND type in (N'U'))
DROP TABLE [VITAS].[IM_NOTIFICATION_LETTER_H]
GO

/****** Object:  Table [VITAS].[IM_NOTIFICATION_LETTER_H]    Script Date: 04/16/2012 14:46:31 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [VITAS].[IM_NOTIFICATION_LETTER_H](
	[Audit_IM_NOTIFICATION_LETTER_H_ID] [int] IDENTITY(1,1) NOT NULL,
	[Audit_Date] [datetime] NOT NULL,
	[Audit_Type] [varchar](20) NOT NULL,
	[Audit_ApplicationUser] [varchar](128) NULL,
	[Audit_SQLUser] [varchar](100) NULL,
	[ID] [int] NULL,
	[PARENT_NOTIFICATION_LETTER_ID] [int] NULL,
	[IM_IMPLANT_ITEM_ID] [int] NULL,
	[RECALL_ID] [int] NULL,
	[STD_IM_NOTIFICATION_STATUS_ID] [int] NULL,
	[STD_IM_NOTIFICATION_TYPE_ID] [int] NULL,
	[OTHER_NOTIFICATION_TEXT] [varchar](100) NULL,
	[NOTIFICATION_LETTER_FROM] [varchar](500) NULL,
	[NOTIFICATION_LETTER_TO] [varchar](500) NULL,
	[NOTIFICATION_BODY] [varchar](max) NULL,
	[NOTIFICATION_CLOSING] [varchar](500) NULL,
	[CREATED] [datetime] NULL,
	[CREATEDBY] [varchar](30) NULL,
	[UPDATED] [datetime] NULL,
	[UPDATEDBY] [varchar](30) NULL,
 CONSTRAINT [IM_NOTIFICATION_LETTER_H_PK] PRIMARY KEY CLUSTERED 
(
	[Audit_IM_NOTIFICATION_LETTER_H_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO









--********************************************************************************
--Transfer notifications from [IM_IMPLANT_ITEM] table
INSERT INTO [VITAS].[IM_NOTIFICATION_LETTER] 
	([IM_IMPLANT_ITEM_ID] ,
	[RECALL_ID],
	[STD_IM_NOTIFICATION_STATUS_ID],
	[STD_IM_NOTIFICATION_TYPE_ID],
	[NOTIFICATION_LETTER_FROM],
	[NOTIFICATION_LETTER_TO],
	[NOTIFICATION_BODY],
	[NOTIFICATION_CLOSING],
	[CREATED],
	[CREATEDBY],
	[UPDATED],
	[UPDATEDBY])
SELECT [ID]
      ,[RECALL_ID]
      ,[STD_IM_NOTIFICATION_STATUS_ID]
      ,1
      ,[NOTIFICATION_LETTER_FROM]
      ,[NOTIFICATION_LETTER_TO]
      ,[NOTIFICATION_LETTER_BODY]
      ,[NOTIFICATION_LETTER_CLOSING]
      ,GETDATE()
      ,'Initial'
      ,GETDATE()
      ,'Initial'
  FROM [VITAS].[IM_IMPLANT_ITEM]
  WHERE [STD_IM_NOTIFICATION_STATUS_ID] IN (1, 2, 3) and [RECALL_ID] is NOT NULL

  
  
/****** Object:  StoredProcedure [dbo].[SetRecallTargetDate]    Script Date: 03/30/2012 08:08:59 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

ALTER PROCEDURE [dbo].[SetRecallTargetDate](@RecallID int, @TargetDate varchar(50), @Return int OUTPUT)
AS
BEGIN

	DECLARE @Manufacturer varchar(max)
	DECLARE	@Model varchar(max)
	DECLARE	@Serial varchar(max)
	DECLARE	@Lot varchar(max)

	DECLARE @Implant_Alert_Flag bit

	DECLARE	@Manufacturer_Values TABLE (ParmValue varchar(max)) 
	DECLARE	@Model_Values TABLE (ParmValue varchar(max))
	DECLARE	@Serial_Values TABLE (ParmValue varchar(max))
	DECLARE	@Lot_Values TABLE (ParmValue varchar(max))
	DECLARE	@ImplantID_Values TABLE (ParmValue int)

	DECLARE @CountSerial int
	DECLARE @CountLot int
	DECLARE @Case int
		
	-- Test data
	SET @RecallID = 45
	SET @TargetDate = '20120206'

	SET @Return = 0

	-- Determine @Implant_Alert_Flag value
	If ltrim(@TargetDate) = ''
		SET @Implant_Alert_Flag = 0
	Else
		SET @Implant_Alert_Flag = 1
		
	SELECT @Manufacturer = MANUFACTURER FROM VITAS.IM_RECALL WHERE Recall_ID = @RecallID
	SELECT @Model = MODEL FROM VITAS.IM_RECALL WHERE Recall_ID = @RecallID
	SELECT @Serial = SERIAL_NO FROM VITAS.IM_RECALL WHERE Recall_ID = @RecallID
	SELECT @Lot = LOT_NO FROM VITAS.IM_RECALL WHERE Recall_ID = @RecallID

	INSERT INTO @Manufacturer_Values (ParmValue) SELECT DISTINCT LTRIM(RTRIM(items)) FROM dbo.fncSplit(@Manufacturer, '|')
	INSERT INTO @Model_Values (ParmValue) SELECT DISTINCT LTRIM(RTRIM(items)) FROM dbo.fncSplit(@Model, ',')
	INSERT INTO @Serial_Values (ParmValue) SELECT DISTINCT LTRIM(RTRIM(items)) FROM dbo.fncSplit(@Serial, ',')
	INSERT INTO @Lot_Values (ParmValue) SELECT DISTINCT LTRIM(RTRIM(items)) FROM dbo.fncSplit(@Lot, ',')

	SELECT @CountSerial = count(*) FROM @Serial_Values
	SELECT @CountLot = count(*) FROM @Lot_Values

	SET @Case = 0
	If @CountSerial	> 0
		SET @Case = @Case + 2
	If @CountLot > 0
		SET @Case = @Case + 4
		
	If @Case = 0
		INSERT INTO @ImplantID_Values (ParmValue) 
		SELECT DISTINCT ID 
		FROM VITAS.IM_IMPLANT_ITEM
		WHERE 
			Recall_ID is NULL
			AND 
			(MANUFACTURER_TEXT IN (SELECT ParmValue FROM @Manufacturer_Values)
				OR
			DISTRIBUTOR_TEXT IN (SELECT ParmValue FROM @Manufacturer_Values))
			AND
			MODEL_NUMBER IN (SELECT ParmValue FROM @Model_Values)
	Else
		If @Case = 2
			INSERT INTO @ImplantID_Values (ParmValue) 
			SELECT DISTINCT ID 
			FROM VITAS.IM_IMPLANT_ITEM
			WHERE 
				Recall_ID is NULL
				AND 
				(MANUFACTURER_TEXT IN (SELECT ParmValue FROM @Manufacturer_Values)
					OR
				DISTRIBUTOR_TEXT IN (SELECT ParmValue FROM @Manufacturer_Values))
				AND
				MODEL_NUMBER IN (SELECT ParmValue FROM @Model_Values)
				AND
				SERIAL_NUMBER IN (SELECT ParmValue FROM @Serial_Values)
		Else
			If @Case = 4
				INSERT INTO @ImplantID_Values (ParmValue) 
				SELECT DISTINCT ID 
				FROM VITAS.IM_IMPLANT_ITEM
				WHERE 
					Recall_ID is NULL
					AND 
					(MANUFACTURER_TEXT IN (SELECT ParmValue FROM @Manufacturer_Values)
						OR
					DISTRIBUTOR_TEXT IN (SELECT ParmValue FROM @Manufacturer_Values))
					AND
					MODEL_NUMBER IN (SELECT ParmValue FROM @Model_Values)
					AND
					LOT_NUMBER IN (SELECT ParmValue FROM @Lot_Values)
			Else --@Case = 6
				INSERT INTO @ImplantID_Values (ParmValue) 
				SELECT DISTINCT ID 
				FROM VITAS.IM_IMPLANT_ITEM
				WHERE 
					Recall_ID is NULL
					AND 
					(MANUFACTURER_TEXT IN (SELECT ParmValue FROM @Manufacturer_Values)
						OR
					DISTRIBUTOR_TEXT IN (SELECT ParmValue FROM @Manufacturer_Values))
					AND
					MODEL_NUMBER IN (SELECT ParmValue FROM @Model_Values)
					AND
					SERIAL_NUMBER IN (SELECT ParmValue FROM @Serial_Values)
					AND
					LOT_NUMBER IN (SELECT ParmValue FROM @Lot_Values)

	BEGIN TRANSACTION SetTargetDate

	BEGIN TRY

		UPDATE VITAS.IM_RECALL
		SET TARGET_DATE = @TargetDate
		WHERE RECALL_ID = @RecallID 

		UPDATE VITAS.IM_IMPLANT_ITEM
		SET 
			Recall_ID = @RecallID, 
			Implant_Alert_Flag = @Implant_Alert_Flag,
			STD_IM_Notification_Status_ID = 1  
		FROM VITAS.IM_IMPLANT_ITEM  
		WHERE ID IN (SELECT ParmValue FROM @ImplantID_Values) 
		
--VITAS #1590 Follow-up Notifications********************************************************************
		INSERT INTO [VITAS].[IM_NOTIFICATION_LETTER] 
			([IM_IMPLANT_ITEM_ID],
			[RECALL_ID],
			[STD_IM_NOTIFICATION_STATUS_ID],
			[STD_IM_NOTIFICATION_TYPE_ID],
			[CREATED],
			[CREATEDBY],
			[UPDATED],
			[UPDATEDBY])
		SELECT [ID]
			  ,@RecallID
			  ,1
			  ,1
			  ,GETDATE()
			  ,'Initial'
			  ,GETDATE()
			  ,'Initial'
		FROM [VITAS].[IM_IMPLANT_ITEM]
		WHERE ID IN (SELECT ParmValue FROM @ImplantID_Values) 
--VITAS #1590 Follow-up Notifications********************************************************************

	COMMIT TRANSACTION SetTargetDate 

	END TRY

	BEGIN CATCH

		SELECT @Return = ERROR_NUMBER()
		ROLLBACK TRANSACTION SetTargetDate

	END CATCH

END

GO


begin

  Insert into [dbo].[DatabaseChangeLog]
      ([MajorReleaseNumber]
       , [MinorReleaseNumber]
       , [PointReleaseNumber]
       , [Hotfix]
       , [ScriptName]
       , [ScriptDescription]
       , [TargetRegistry]
       , [DateApplied])
  Values
      ('05'
       ,'00'
       ,'028'
       ,0
       ,'1493_FollowUpNotifications.sql 1493_SetRecallTargetDate.sql'
       ,'Changes to support 1493, Update Notification Letter subject options to include Follow Up  '
       ,'VITAS'
      ,GETDATE())

End



  