--EFR_DatabaseScript_Newbugtracker_1533_Incr5.sql
--Vina Naik
--Modified stored procedure EFRDataExportPatient so Referral export will reconcile with Patients export.'

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EFRDataExportPatient]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[EFRDataExportPatient]
GO


CREATE PROCEDURE [dbo].[EFRDataExportPatient]
	/*
	(
	@parameter1 int = 5,
	@parameter2 datatype OUTPUT
	)
	*/
AS
	/* SET NOCOUNT ON */
SELECT	PATIENT.SSN, PATIENT.PATIENT_ICN, PATIENT.LAST_NAME, PATIENT.FIRST_NAME, PATIENT.MIDDLE_NAME, REFERRAL.REFERRAL_ID, 
                      STD_REFERRALSTS.NAME AS REFERRAL_STATUS, STD_INSTITUTION.STATIONNUMBER AS HOME_VAMC_NUMBER, 
                      STD_INSTITUTION.NAME AS HOME_VAMC_NAME, STD_INSTITUTION_1.STATIONNUMBER AS REFERRAL_VAMC_NUMBER, 
                      STD_INSTITUTION_1.NAME AS REFERRAL_VAMC_NAME, STD_RACE.NAME AS RACE, STD_GENDER.NAME AS GENDER, STD_ETHNICITY.NAME AS ETHNICITY, CONVERT(varchar, PATIENT.BIRTH_DATE, 101) AS BIRTHDATE, 
                      CONVERT(varchar, PATIENT.DEATH_DATE, 101) AS DEATHDATE, PATIENT.STATE, PATIENT.COUNTRY, STD_SERVICEBRANCH.NAME AS SERVICE_BRANCH
FROM	PATIENT INNER JOIN
                      REFERRAL ON PATIENT.PATIENT_ID = REFERRAL.PATIENT_ID LEFT JOIN
                      STD_INSTITUTION ON PATIENT.STD_INSTITUTION_ID = STD_INSTITUTION.ID LEFT JOIN
                      STD_INSTITUTION AS STD_INSTITUTION_1 ON REFERRAL.STD_INSTITUTION_ID = STD_INSTITUTION_1.ID LEFT JOIN
                      STD_RACE ON PATIENT.STD_RACE_ID = STD_RACE.ID LEFT JOIN
                      STD_ETHNICITY ON PATIENT.STD_ETHNICITY_ID = STD_ETHNICITY.ID LEFT JOIN
                      STD_REFERRALSTS ON REFERRAL.STD_REFERRALSTS_ID = STD_REFERRALSTS.ID LEFT JOIN
                      STD_GENDER ON PATIENT.STD_GENDER_ID = STD_GENDER.ID LEFT JOIN
                      STD_SERVICEBRANCH ON PATIENT.STD_SERVICEBRANCH_ID = STD_SERVICEBRANCH.ID  
WHERE     (REFERRAL.STD_REGISTRY_ID = 1) AND (REFERRAL.STD_REFERRALSTS_ID <> 4)
GO


begin

  Insert into [dbo].[DatabaseChangeLog]
      ([MajorReleaseNumber]
       , [MinorReleaseNumber]
       , [PointReleaseNumber]
       , [Hotfix]
       , [ScriptName]
       , [ScriptDescription]
       , [TargetRegistry]
       , [DateApplied])
  Values
      ('05'
       ,'00'
       ,'027'
       ,0
       ,'EFR_DatabaseScript_NewBugtracker_1533_Incr5.sql'
       ,'Modified stored procedure EFRDataExportPatient so Referral export will reconcile with Patients export.'
       ,'EFR'
      ,GETDATE())

End


