/*
Sherry Wang 3/28/2012
Tracker #1469: ICD10 - display ICD code set indicator (.net)  
Add a new column called ICD_CODESET to [DVEIR].[ER_DIAG_DTL] table 
and [DVEIR].[ER_PROCEDURE_DTL] table.  Also added the column to their history tables
and the triggers populating history tables.
*/

ALTER TABLE [DVEIR].[ER_DIAG_DTL]
	ADD [ICD_CODESET] [int] NOT NULL DEFAULT 9

ALTER TABLE [DVEIR].[ER_DIAG_DTL_H]
	ADD [ICD_CODESET] [int] NOT NULL DEFAULT 9

GO

ALTER TRIGGER  [DVEIR].[TRG_ER_DIAG_DTL_DEL_H]
on  [DVEIR].[ER_DIAG_DTL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_DIAG_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_DIAG_DTL_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ER_ENCOUNTER_ID]
, [CODE]
, [DESCRIPTION_TEXT]
, [ICD_CODESET]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ER_DIAG_DTL_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ER_ENCOUNTER_ID]
, [CODE]
, [DESCRIPTION_TEXT]
, [ICD_CODESET]

From Deleted
End

GO

ALTER trigger [DVEIR].[TRG_ER_DIAG_DTL_H] on [DVEIR].[ER_DIAG_DTL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_DIAG_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_DIAG_DTL_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ER_ENCOUNTER_ID]
, [CODE]
, [DESCRIPTION_TEXT]
, [ICD_CODESET]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ER_DIAG_DTL_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ER_ENCOUNTER_ID]
, [CODE]
, [DESCRIPTION_TEXT]
, [ICD_CODESET]
FROM INSERTED
End

GO


ALTER TABLE [DVEIR].[ER_PROCEDURE_DTL]
	ADD [ICD_CODESET] [int] NULL 

ALTER TABLE [DVEIR].[ER_PROCEDURE_DTL_H]
	ADD [ICD_CODESET] [int] NULL 
GO
	
UPDATE [DVEIR].[ER_PROCEDURE_DTL]
SET ICD_CODESET = 9
WHERE ICD9_FLAG = 1

GO

ALTER TRIGGER  [DVEIR].[TRG_ER_PROCEDURE_DTL_DEL_H]
on  [DVEIR].[ER_PROCEDURE_DTL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_PROCEDURE_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_PROCEDURE_DTL_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ER_ENCOUNTER_ID]
, [CODE]
, [DESCRIPTION_TEXT]
, [ICD9_FLAG]
, [ICD_CODESET]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ER_PROCEDURE_DTL_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ER_ENCOUNTER_ID]
, [CODE]
, [DESCRIPTION_TEXT]
, [ICD9_FLAG]
, [ICD_CODESET]
From Deleted
End

GO

ALTER trigger [DVEIR].[TRG_ER_PROCEDURE_DTL_H] on [DVEIR].[ER_PROCEDURE_DTL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_PROCEDURE_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_PROCEDURE_DTL_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ER_ENCOUNTER_ID]
, [CODE]
, [DESCRIPTION_TEXT]
, [ICD9_FLAG]
, [ICD_CODESET]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ER_PROCEDURE_DTL_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ER_ENCOUNTER_ID]
, [CODE]
, [DESCRIPTION_TEXT]
, [ICD9_FLAG]
, [ICD_CODESET]
FROM INSERTED
End

GO

begin
INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('05'
           ,'00'
           ,'016'
           ,0
           ,'Bug tracker #1469'
           ,'Changes to support ICD-10'
           ,'DVEIR'
           ,GETDATE())
end
GO



