ALTER PROCEDURE [dbo].[EFRDataExportRelatedDiagnoses]
	/*
	(
	@parameter1 int = 5,
	@parameter2 datatype OUTPUT
	)
	*/
AS
	/* SET NOCOUNT ON */
	SELECT     PATIENT.SSN, PATIENT.PATIENT_ICN, PATIENT.LAST_NAME, 
	PATIENT.FIRST_NAME, PATIENT.MIDDLE_NAME, 
	EFR.EFR_ICD9_DIAG.ICD_CODESET AS ICD_CODE_SET,
	EFR.EFR_ICD9_DIAG.ICD9_CODE AS ICD_CODE, 
    EFR.EFR_ICD9_DIAG.ICD9_CODE_NAME AS ICD_CODE_NAME, 
    CONVERT(varchar, EFR.EFR_ICD9_DIAG.ENCOUNTER_DATETIME, 101) AS ENCOUNTER_DATE, 
    STD_INSTITUTION.STATIONNUMBER AS ENCOUNTER_VAMC_NUMBER, 
    STD_INSTITUTION.NAME AS ENCOUNTER_VAMC_NAME
FROM         EFR.EFR_ICD9_DIAG INNER JOIN
                      PATIENT ON EFR.EFR_ICD9_DIAG.PATIENT_ID = PATIENT.PATIENT_ID INNER JOIN
                      STD_INSTITUTION ON EFR.EFR_ICD9_DIAG.STD_INSTITUTION_ID = STD_INSTITUTION.ID 
                      INNER JOIN REFERRAL ON REFERRAL.PATIENT_ID=PATIENT.PATIENT_ID
WHERE STD_REGISTRY_ID=1
	AND REFERRAL.STD_REFERRALSTS_ID NOT IN (8, 9)
ORDER BY PATIENT.LAST_NAME


GO

begin
INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('05'
           ,'00'
           ,'015'
           ,0
           ,'Bug tracker #1567'
           ,'Changes to support Data Export Related Diagnosis'
           ,'EFR'
           ,GETDATE())
end
GO




