
ALTER TABLE [EFR].[EFR_ICD9_DIAG]
	ADD [ICD_CODESET] [int] NOT NULL DEFAULT 9

ALTER TABLE [EFR].[EFR_ICD9_DIAG_H]
	ADD [ICD_CODESET] [int] NOT NULL DEFAULT 9
GO


ALTER TRIGGER  [EFR].[TRG_EFR_ICD9_DIAG_DEL_H]
on  [EFR].[EFR_ICD9_DIAG] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [EFR].[EFR_ICD9_DIAG_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ICD9DIS_ID]
, [PATIENT_ID]
, [ICD9_CODE]
, [ICD9_CODE_NAME]
, [PRIMARYDIAG]
, [ENCOUNTER_DATETIME]
, [STD_INSTITUTION_ID]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ICD_CODESET]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ICD9DIS_ID]
, [PATIENT_ID]
, [ICD9_CODE]
, [ICD9_CODE_NAME]
, [PRIMARYDIAG]
, [ENCOUNTER_DATETIME]
, [STD_INSTITUTION_ID]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ICD_CODESET]

From Deleted
End

GO

ALTER trigger [EFR].[TRG_EFR_ICD9_DIAG_H] on [EFR].[EFR_ICD9_DIAG]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [EFR].[EFR_ICD9_DIAG_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ICD9DIS_ID]
, [PATIENT_ID]
, [ICD9_CODE]
, [ICD9_CODE_NAME]
, [PRIMARYDIAG]
, [ENCOUNTER_DATETIME]
, [STD_INSTITUTION_ID]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ICD_CODESET]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ICD9DIS_ID]
, [PATIENT_ID]
, [ICD9_CODE]
, [ICD9_CODE_NAME]
, [PRIMARYDIAG]
, [ENCOUNTER_DATETIME]
, [STD_INSTITUTION_ID]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ICD_CODESET]

FROM INSERTED
End

GO

begin
INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('05'
           ,'00'
           ,'014'
           ,0
           ,'Bug tracker #1566'
           ,'Changes to support ICD-10 in EFR'
           ,'EFR'
           ,GETDATE())
end










