IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EFRDataExportRelatedLabTests]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[EFRDataExportRelatedLabTests]
GO


CREATE PROCEDURE [dbo].[EFRDataExportRelatedLabTests]

AS

SELECT
P.SSN, 
P.LAST_NAME AS [Last Name],
P.FIRST_NAME AS [First Name],
P.MIDDLE_NAME as [Middle Name],
L.LAB_TEST_NAME AS [Test Name],
L.SPECIMEN_TYPE AS [Specimen Type],
L.LAB_COMPLETE_DATE AS [Result Date],
L.LAB_SPECIMEN_DATE AS [Date Specimen Collected],
L.LAB_RESULT_VALUE AS [Result],
L.LAB_RESULT_UNIT AS [Result Units],
L.REF_LOW AS [Ref Low],
L.REF_HIGH AS [Ref High],
L.ABNORMAL AS [Abnormal Indicator],
REQUEST_FACILITY.STATIONNUMBER AS [Request Site Number],
RESULT_FACILITY.STATIONNUMBER AS [Result Site Number],
L.LONINC_CODE AS [LOINC Code]
FROM 
	EFR.RELATED_LAB_TEST L
	INNER  JOIN [DBO].[PATIENT] P ON L.PATIENT_ID = P.PATIENT_ID
	LEFT OUTER JOIN [DBO].[STD_INSTITUTION] REQUEST_FACILITY
		ON L.REQUESTING_FACILITY_ID = REQUEST_FACILITY.ID
	LEFT OUTER JOIN [DBO].[STD_INSTITUTION] RESULT_FACILITY
		ON L.RESULTING_FACILITY_ID = RESULT_FACILITY.ID

GO
--EFR_V5_RelatedLabTest_02_NewSPforDataExport.sql

begin

  Insert into [dbo].[DatabaseChangeLog]
      ([MajorReleaseNumber]
       , [MinorReleaseNumber]
       , [PointReleaseNumber]
       , [Hotfix]
       , [ScriptName]
       , [ScriptDescription]
       , [TargetRegistry]
       , [DateApplied])
  Values
      ('05'
       ,'00'
       ,'012'
       ,0
       ,'Tracker 1559'
       ,'Add tables necessary for Lab Data of Interest.'
       ,'EFR'
      ,GETDATE())

End
GO




