/*
Sherry Wang   3/28/2012
Create a new table for EFR lab tests of interest.
*/

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[EFR].[RELATED_LAB_TEST_PATIENT_FK]') AND parent_object_id = OBJECT_ID(N'[EFR].[RELATED_LAB_TEST]'))
ALTER TABLE [EFR].[RELATED_LAB_TEST] DROP CONSTRAINT [RELATED_LAB_TEST_PATIENT_FK]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[EFR].[RELATED_LAB_TEST_REQUESTING_FACILITY_FK]') AND parent_object_id = OBJECT_ID(N'[EFR].[RELATED_LAB_TEST]'))
ALTER TABLE [EFR].[RELATED_LAB_TEST] DROP CONSTRAINT [RELATED_LAB_TEST_REQUESTING_FACILITY_FK]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[EFR].[RELATED_LAB_TEST_RESULTING_FACILITY_FK]') AND parent_object_id = OBJECT_ID(N'[EFR].[RELATED_LAB_TEST]'))
ALTER TABLE [EFR].[RELATED_LAB_TEST] DROP CONSTRAINT [RELATED_LAB_TEST_RESULTING_FACILITY_FK]
GO

IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_RELATED_LAB_TEST_CREATED_DATE]') AND type = 'D')
BEGIN
ALTER TABLE [EFR].[RELATED_LAB_TEST] DROP CONSTRAINT [DF_RELATED_LAB_TEST_CREATED_DATE]
END

GO

IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_RELATED_LAB_TEST_UPDATED_DATE]') AND type = 'D')
BEGIN
ALTER TABLE [EFR].[RELATED_LAB_TEST] DROP CONSTRAINT [DF_RELATED_LAB_TEST_UPDATED_DATE]
END

GO

/****** Object:  Table [EFR].[RELATED_LAB_TEST]    Script Date: 02/14/2012 15:52:51 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[EFR].[RELATED_LAB_TEST]') AND type in (N'U'))
DROP TABLE [EFR].[RELATED_LAB_TEST]
GO

CREATE TABLE [EFR].[RELATED_LAB_TEST](
	[RELATED_LAB_TEST_ID] [int] IDENTITY(1,1) NOT NULL,
	[PATIENT_ID] [int] NOT NULL,
	[REQUESTING_FACILITY_ID] [int] NULL,
	[RESULTING_FACILITY_ID] [int] NULL,
	[LAB_COMPLETE_DATE] [datetime] NULL,
	[LAB_SPECIMEN_DATE] [datetime] NULL,
	[LAB_TEST_NAME] [varchar](50) NULL,
	[LAB_RESULT_VALUE] [varchar](70) NULL,
	[LAB_RESULT_UNIT] [varchar](50) NULL,
	[ABNORMAL] [varchar](6) NULL,
	[LONINC_CODE] [varchar](50) NULL,
	[REF_HIGH] [varchar](70) NULL,
	[REF_LOW] [varchar](70) NULL,
	[SPECIMEN_TYPE] [varchar](80) NULL,
	[CREATEDBY] [varchar](30) NOT NULL,
	[CREATED] [datetime] NOT NULL,
	[UPDATEDBY] [varchar](30) NOT NULL,
	[UPDATED] [datetime] NOT NULL,
	[ROW_VERSION] [timestamp] NOT NULL,
 CONSTRAINT [RELATED_LAB_TEST_PK] PRIMARY KEY CLUSTERED 
(
	[RELATED_LAB_TEST_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

ALTER TABLE [EFR].[RELATED_LAB_TEST]  WITH NOCHECK ADD  CONSTRAINT [RELATED_LAB_TEST_PATIENT_FK] FOREIGN KEY([PATIENT_ID])
REFERENCES [dbo].[PATIENT] ([PATIENT_ID])
GO

ALTER TABLE [EFR].[RELATED_LAB_TEST] CHECK CONSTRAINT [RELATED_LAB_TEST_PATIENT_FK]
GO

ALTER TABLE [EFR].[RELATED_LAB_TEST]  WITH NOCHECK ADD  CONSTRAINT [RELATED_LAB_TEST_REQUESTING_FACILITY_FK] FOREIGN KEY([REQUESTING_FACILITY_ID])
REFERENCES [dbo].[STD_INSTITUTION] ([ID])
GO

ALTER TABLE [EFR].[RELATED_LAB_TEST] CHECK CONSTRAINT [RELATED_LAB_TEST_REQUESTING_FACILITY_FK]
GO

ALTER TABLE [EFR].[RELATED_LAB_TEST]  WITH NOCHECK ADD  CONSTRAINT [RELATED_LAB_TEST_RESULTING_FACILITY_FK] FOREIGN KEY([RESULTING_FACILITY_ID])
REFERENCES [dbo].[STD_INSTITUTION] ([ID])
GO

ALTER TABLE [EFR].[RELATED_LAB_TEST] CHECK CONSTRAINT [RELATED_LAB_TEST_RESULTING_FACILITY_FK]
GO

ALTER TABLE [EFR].[RELATED_LAB_TEST] ADD  CONSTRAINT [DF_RELATED_LAB_TEST_CREATED_DATE]  DEFAULT (getdate()) FOR [CREATED]
GO

ALTER TABLE [EFR].[RELATED_LAB_TEST] ADD  CONSTRAINT [DF_RELATED_LAB_TEST_UPDATED_DATE]  DEFAULT (getdate()) FOR [UPDATED]
GO

/* EFR_V5_CreateTable_RelatedLabTEst.sql */

begin
INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('05'
           ,'00'
           ,'008'
           ,0
           ,'Bug tracker #1559'
           ,'Creating Tables necessary for EFR Lab Tests of Interest'
           ,'EFR'
           ,GETDATE())
end 
GO