
--Date - 01/16/2012
--Vina Naik
--EFR INCR - 4.1 
--EFR Bug tracker #1539.
--Added ARCHIVED_FLAG = 0 when stored procedure select data from wfk_case_activity table.

/****** Object:  StoredProcedure [dbo].[ComprehensiveVhaSummaryReport]    Script Date: 01/16/2012 14:23:28 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ComprehensiveVhaSummaryReport]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[ComprehensiveVhaSummaryReport]
GO

/****** Object:  StoredProcedure [dbo].[ComprehensiveFacilityDetail_Report]    Script Date: 01/16/2012 14:23:28 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ComprehensiveFacilityDetail_Report]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[ComprehensiveFacilityDetail_Report]
GO

/****** Object:  StoredProcedure [dbo].[VisnSummaryReport_byVisnID2]    Script Date: 01/16/2012 14:23:28 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VisnSummaryReport_byVisnID2]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[VisnSummaryReport_byVisnID2]
GO

/****** Object:  StoredProcedure [dbo].[VisnSummaryReport_byVisnID]    Script Date: 01/16/2012 14:23:28 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VisnSummaryReport_byVisnID]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[VisnSummaryReport_byVisnID]
GO

/****** Object:  StoredProcedure [dbo].[VisnSummaryReport]    Script Date: 01/16/2012 14:23:28 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VisnSummaryReport]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[VisnSummaryReport]
GO

/****** Object:  StoredProcedure [dbo].[USP_EFR_REPORT_NEW_KIT_ORDERS_REQUIRED]    Script Date: 01/16/2012 14:23:28 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[USP_EFR_REPORT_NEW_KIT_ORDERS_REQUIRED]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[USP_EFR_REPORT_NEW_KIT_ORDERS_REQUIRED]
GO

/****** Object:  StoredProcedure [dbo].[USP_EFR_REPORT_EXISTING_KIT_ORDERS]    Script Date: 01/16/2012 14:23:28 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[USP_EFR_REPORT_EXISTING_KIT_ORDERS]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[USP_EFR_REPORT_EXISTING_KIT_ORDERS]
GO

/****** Object:  StoredProcedure [dbo].[usp_EFR_LETTER_INTERPRETATION_TXT]    Script Date: 01/16/2012 14:23:29 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_EFR_LETTER_INTERPRETATION_TXT]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_EFR_LETTER_INTERPRETATION_TXT]
GO

/****** Object:  StoredProcedure [dbo].[usp_EFR_LETTER_ANALYTE_DETAILS]    Script Date: 01/16/2012 14:23:29 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_EFR_LETTER_ANALYTE_DETAILS]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_EFR_LETTER_ANALYTE_DETAILS]
GO

/****** Object:  StoredProcedure [dbo].[usp_EFR_LABORDER_PATIENT]    Script Date: 01/16/2012 14:23:29 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_EFR_LABORDER_PATIENT]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_EFR_LABORDER_PATIENT]
GO

/****** Object:  StoredProcedure [dbo].[usp_EFR_LABORDER_DETAILS]    Script Date: 01/16/2012 14:23:29 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_EFR_LABORDER_DETAILS]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_EFR_LABORDER_DETAILS]
GO

/****** Object:  StoredProcedure [dbo].[usp_EFR_LABORDER_ANALYTES]    Script Date: 01/16/2012 14:23:29 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_EFR_LABORDER_ANALYTES]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_EFR_LABORDER_ANALYTES]
GO

/****** Object:  StoredProcedure [dbo].[usp_EFR_LABORDER_ACTIVITY]    Script Date: 01/16/2012 14:23:29 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_EFR_LABORDER_ACTIVITY]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_EFR_LABORDER_ACTIVITY]
GO

/****** Object:  StoredProcedure [dbo].[usp_EFR_LABORDER]    Script Date: 01/16/2012 14:23:29 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_EFR_LABORDER]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_EFR_LABORDER]
GO

/****** Object:  StoredProcedure [dbo].[ReportComprehensiveFacilityDetail]    Script Date: 01/16/2012 14:23:29 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ReportComprehensiveFacilityDetail]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[ReportComprehensiveFacilityDetail]
GO

/****** Object:  StoredProcedure [dbo].[EFRDataExportFragmentForm]    Script Date: 01/16/2012 14:23:29 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EFRDataExportFragmentForm]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[EFRDataExportFragmentForm]
GO

/****** Object:  StoredProcedure [dbo].[EFRDataExportBioQuestionnaire]    Script Date: 01/16/2012 14:23:29 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EFRDataExportBioQuestionnaire]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[EFRDataExportBioQuestionnaire]
GO

/****** Object:  StoredProcedure [dbo].[EFRDataExportBioInterpretation]    Script Date: 01/16/2012 14:23:29 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EFRDataExportBioInterpretation]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[EFRDataExportBioInterpretation]
GO

/****** Object:  StoredProcedure [dbo].[ComprehensiveVhaSummaryReport]    Script Date: 01/16/2012 14:23:29 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO




CREATE PROCEDURE [dbo].[ComprehensiveVhaSummaryReport]  

AS

BEGIN
    --select * from dbo.Report_VISN_Summary r
    
    set Nocount on
 
declare @startdate datetime = [dbo].[GetFiscalYearStartDate] (GETDATE())
declare @enddate datetime = [dbo].[GetTBIReportValidEndDate] (GETDATE())


Begin Try
    
--- Table Variable to Hold result sets
     
    Declare @VhaSummary table (
        Groups varchar(200) null,
        ParentGroup varchar(200) null,
        Footnote varchar(200) null,
        Category varchar(200) null,
        Summary1 int null,
        Summary2 int null,
        Summary3 int null,
        Percentage decimal(5,2),
        displyOrder int);
        

	/*  INITIAL SCREENING INFORMATION */
	
		-- as 'Total OEF/OIF Veterans Screened for possible TBI'
	    Insert @VhaSummary (Groups,ParentGroup, Category,Summary1,displyOrder)
		
		SELECT     
			'Initial Screening Information' AS Groups, 
			'Total OEF/OIF Veterans Screened for possible TBI' AS ParentGroup,  
			'Total OEF/OIF Veterans Screened for possible TBI' AS Category, 
			COUNT(DISTINCT p.PATIENT_ID) AS Summary1,
			1 as displyOrder
			
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id

		WHERE     
			(p.OEF_OIF_IND = 1) AND (r.STD_REGISTRY_ID = 2) 


		IF @@ROWCOUNT = 0
			INSERT INTO @VhaSummary
							(Groups,ParentGroup, Category,Summary1,displyOrder)
						VALUES     
							(
							 'Initial Screening Information'
							,'Total OEF/OIF Veterans Screened for possible TBI'
							,'Total OEF/OIF Veterans Screened for possible TBI'
							,0
							,1
							)

		-- 'Total OEF/OIF Veterans with self reported previous diagnosis of TBI'
		
	    Insert @VhaSummary (Groups,ParentGroup, Category,Summary2,displyOrder)
	    
		select 
		'Initial Screening Information' as Groups,
		'Total OEF/OIF Veterans Screened for possible TBI' AS ParentGroup,  
		' .. *Total number OEF/OIF Veterans with self reported previous diagnosis of TBI' as Category,
		count(DISTINCT p.PATIENT_ID) as Summar2
		,2 as displyOrder		
		from 
			dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
			on r.PATIENT_ID = p.PATIENT_ID
			join REFERRAL_DETAIL rd (nolock)
			on r.REFERRAL_ID = rd.REFERRAL_ID
			join dbo.viewFacilitiesByVisn v
			on r.STD_INSTITUTION_ID = v.institution_id
		where 
			p.OEF_OIF_IND = 1
			and r.STD_REGISTRY_ID = 2
			and rd.STD_HEALTHFACTOR_ID = 51;
			
		
		IF @@ROWCOUNT = 0
			INSERT INTO @VhaSummary
							(Groups,ParentGroup, Category,Summary2,displyOrder)
						VALUES     
							(
							 'Initial Screening Information'
							,'Total OEF/OIF Veterans Screened for possible TBI'
							,' .. *Total number OEF/OIF Veterans with self reported previous diagnosis of TBI'
							,0
							,2
							)		

		--  'Total OEF/OIF Veterans with negative initial TBI Screen'
		Insert @VhaSummary (Groups,ParentGroup, Category,Summary2,displyOrder)

		SELECT     
			'Initial Screening Information' AS Groups, 
			'Total OEF/OIF Veterans Screened for possible TBI' as ParentGroup, 
			' .. Total OEF/OIF Veterans with negative initial TBI Screen' AS Category, 
			COUNT(DISTINCT p.PATIENT_ID) AS Summar2,
			3 as displyOrder
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			INNER JOIN
			viewFacilitiesByVisn AS v 
			ON r.STD_INSTITUTION_ID = v.institution_id 
		
		WHERE     
			(p.OEF_OIF_IND = 1) AND (r.STD_REGISTRY_ID = 2) 
			AND
			r.REFERRAL_ID NOT IN  
			(
				select r2.REFERRAL_ID from dbo.REFERRAL r2(nolock)join dbo.REFERRAL_DETAIL rd2 (nolock) 
				on r2.REFERRAL_ID = rd2.REFERRAL_ID
				INNER JOIN
				viewFacilitiesByVisn AS v2 
				ON r2.STD_INSTITUTION_ID = v2.institution_id
				where rd2.STD_HEALTHFACTOR_ID = 63  )

		
		IF @@ROWCOUNT = 0
			INSERT INTO @VhaSummary
							(Groups,ParentGroup, Category,Summary2,displyOrder)
						VALUES     
							(
							 'Initial Screening Information'
							,'Total OEF/OIF Veterans Screened for possible TBI'
							,' .. Total OEF/OIF Veterans with negative initial TBI Screen'
							,0
							,3
							)

		--  'Total OEF/OIF Veterans with Positive initial TBI Screen'
		Insert @VhaSummary (Groups,ParentGroup, Category,Summary2,displyOrder)
		
		SELECT     
			'Initial Screening Information' AS Groups, 
			'Total OEF/OIF Veterans Screened for possible TBI' as ParentGroup, 
			' .. Total OEF/OIF Veterans with Positive initial TBI Screen' AS Category, 
			COUNT(DISTINCT p.PATIENT_ID) AS Summar2,
			4 as displyOrder
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
            INNER JOIN dbo.REFERRAL_DETAIL rd (nolock) 
			ON r.REFERRAL_ID = rd.REFERRAL_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			AND
			(rd.STD_HEALTHFACTOR_ID = 63)
		    

		IF @@ROWCOUNT = 0
			INSERT INTO @VhaSummary
							(Groups,ParentGroup, Category,Summary2,displyOrder)
						VALUES     
							(
							 'Initial Screening Information'
							,'Total OEF/OIF Veterans Screened for possible TBI'
							,' .. Total OEF/OIF Veterans with Positive initial TBI Screen'
							,0
							,5
							)

		-------------------------------
		-- Initial Positive Screen who declined a Comprehensive Evaluation
		Insert @VhaSummary (Groups,ParentGroup, Category,Summary3,displyOrder)
		
		SELECT     
			'Initial Screening Information' AS Groups, 
			' .. Total OEF/OIF Veterans with Positive initial TBI Screen' as ParentGroup,  
			' .... Initial Positive Screens who declined a Comprehensive Evaluation' AS Category, 
			COUNT(DISTINCT p.PATIENT_ID) AS Summar3,
			6 as displyOrder
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			AND
			(rd.STD_HEALTHFACTOR_ID = 53 )
			AND 
			r.REFERRAL_ID IN  
			(
				select r2.REFERRAL_ID from dbo.REFERRAL r2(nolock)join dbo.REFERRAL_DETAIL rd2 (nolock) 
				on r2.REFERRAL_ID = rd2.REFERRAL_ID
				INNER JOIN
				viewFacilitiesByVisn AS v2 
				ON r2.STD_INSTITUTION_ID = v2.institution_id
				where rd2.STD_HEALTHFACTOR_ID = 63 )
	
		
		IF @@ROWCOUNT = 0
			INSERT INTO @VhaSummary
							(Groups,ParentGroup, Category,Summary3,displyOrder)
						VALUES     
							(
							 'Initial Screening Information'
							,' .. Total OEF/OIF Veterans with Positive initial TBI Screen'
							,' .... Initial Positive Screens who declined a Comprehensive Evaluation'
							,0
							,6
							)
							
							
		-------------------------------
		-- Initial Positive Screen tracked for Comprehensive Evaluation
		Insert @VhaSummary (Groups,ParentGroup, Category,Summary3,displyOrder)

		SELECT     
			'Initial Screening Information' as Groups,
			' .. Total OEF/OIF Veterans with Positive initial TBI Screen' as ParentGroup,  
			' .... Initial Positive Screens Tracked for Comprehensive Evaluation' as Category,
			COUNT(DISTINCT p.PATIENT_ID) AS Summar3,
			7 as displyOrder
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
		WHERE     
			(p.OEF_OIF_IND = 1) AND (r.STD_REGISTRY_ID = 2)
			AND
			(rd.STD_HEALTHFACTOR_ID = 63 )
	
		IF @@ROWCOUNT = 0
			INSERT INTO @VhaSummary
							(Groups,ParentGroup, Category,Summary3,displyOrder)
						VALUES     
							(
							 'Initial Screening Information'
							,' .. Total OEF/OIF Veterans with Positive initial TBI Screen'
							,' .... Initial Positive Screens Tracked for Comprehensive Evaluation'
							,0
							,7
							)

		-------------------------------
		-- Initial Positive Screen who did NOT decline Comprehensive Evaluation
		Insert @VhaSummary (Groups, ParentGroup, Footnote, Category,Summary3,displyOrder)
	    
		select 
			'Initial Screening Information' as Groups,
			' .. Total OEF/OIF Veterans with Positive initial TBI Screen' as ParentGroup,  
			'*Not included in tracking TBI Screening tool and Comprehensive TBI Evaluation Process ' as Footnote,
			'Initial Positive Screens who did NOT decline Comprehensive Evaluation' as Category,
			count(DISTINCT p.PATIENT_ID) as Summar3,
			8 as displyOrder
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
		WHERE     
			(p.OEF_OIF_IND = 1) AND (r.STD_REGISTRY_ID = 2)
			AND
			(rd.STD_HEALTHFACTOR_ID = 63 )
					
		IF @@ROWCOUNT = 0
			INSERT INTO @VhaSummary
							(Groups, ParentGroup, Footnote, Category,Summary3,displyOrder)
						VALUES     
							(
							 'Initial Screening Information'
							,' .. Total OEF/OIF Veterans with Positive initial TBI Screen'
							,'*Not included in tracking TBI Screening tool and Comprehensive TBI Evaluation Process '
							,'Initial Positive Screens who did NOT decline Comprehensive Evaluation'
							,0
							,8
							)

	 /* COMPREHENSIVE EVALUATION:- COMPLETED/PENDING FURTHER EVALUATION  */

		-------------------------------
		-- Initial Positive Screen tracked for Comprehensive Evaluation
		Insert @VhaSummary (Groups,ParentGroup, Category,Summary1,displyOrder)

		select 
			'Comprehensive Evaluation - Completed/Pending Futher Evaluation' as Groups,
			'Initial Positive Screens Tracked for Comprehensive Evaluation' as ParentGroup,  
			'Initial Positive Screens Tracked for Comprehensive Evaluation' as Category,
			count(DISTINCT p.PATIENT_ID) as Summar1,
			9 as displyOrder
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
		WHERE     
			(p.OEF_OIF_IND = 1) AND (r.STD_REGISTRY_ID = 2)
			AND
			(rd.STD_HEALTHFACTOR_ID = 63 )
		
		IF @@ROWCOUNT = 0
			INSERT INTO @VhaSummary
							(Groups,ParentGroup, Category,Summary1,displyOrder)
						VALUES     
							(
							'Comprehensive Evaluation - Completed/Pending Futher Evaluation'
							,'Initial Positive Screens Tracked for Comprehensive Evaluation'
							,'Initial Positive Screens Tracked for Comprehensive Evaluation'
							,0
							,9
							)
		
		-- Comprehensive Evaluation Completed
		Insert @VhaSummary (Groups,ParentGroup, Category,Summary2,displyOrder)
		
		select 
			'Comprehensive Evaluation - Completed/Pending Futher Evaluation' as Groups,
			'Initial Positive Screens Tracked for Comprehensive Evaluation' as ParentGroup, 
			' .. Comprehensive Evaluations Completed' as Category,
			count(DISTINCT r.REFERRAL_ID) as Summar2 ,
			10 as displyOrder
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
			INNER JOIN WKF_CASE wfc
			ON r.REFERRAL_ID = wfc.REFERRAL_ID
			INNER JOIN TBI.TBI_TRACKING tt (nolock)
			on wfc.WKF_CASE_ID = tt.WKF_CASE_ID
		WHERE     
			(p.OEF_OIF_IND = 1) AND (r.STD_REGISTRY_ID = 2)
			and 
			(tt.REFERRAL_COMPLETE_DATE is not null)
			and 
			(r.STD_REFERRALSTS_ID = 3)


		IF @@ROWCOUNT = 0
			INSERT INTO @VhaSummary
							(Groups,ParentGroup, Category,Summary2,displyOrder)
						VALUES     
							(
							'Comprehensive Evaluation - Completed/Pending Futher Evaluation'
							,'Initial Positive Screens Tracked for Comprehensive Evaluation'
							,' .. Comprehensive Evaluations Completed'
							,0
							,10
							)


		-------------------------------
		-- Comfirmed TBI Diagnosis
		Insert @VhaSummary (Groups,ParentGroup, Category,Summary3,displyOrder)
		
		select 
			'Comprehensive Evaluation - Completed/Pending Futher Evaluation' as Groups,
			' .. Comprehensive Evaluations Completed' as ParentGroup, 
			' .... Comfirmed TBI Diagnosis' as Category,
			count(DISTINCT r.REFERRAL_ID) as Summar3,
			11 as displyOrder
		
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
			INNER JOIN WKF_CASE wfc
			ON r.REFERRAL_ID = wfc.REFERRAL_ID
			INNER JOIN TBI.TBI_TRACKING tt (nolock)
			on wfc.WKF_CASE_ID = tt.WKF_CASE_ID
		
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			and 
			(tt.TBI_DIAGNOSIS_IND = 1)
			and 
			(r.STD_REFERRALSTS_ID = 3)


		IF @@ROWCOUNT = 0
			INSERT INTO @VhaSummary
							(Groups,ParentGroup, Category,Summary3,displyOrder)
						VALUES     
							(
							'Comprehensive Evaluation - Completed/Pending Futher Evaluation'
							,' .. Comprehensive Evaluations Completed'
							,' .... Comfirmed TBI Diagnosis'
							,0
							,11
							)
							

		-------------------------------
		-- TBI Diagnosis Ruled Out
		Insert @VhaSummary (Groups,ParentGroup, Category,Summary3,displyOrder)

		select 
			'Comprehensive Evaluation - Completed/Pending Futher Evaluation' as Groups,
			' .. Comprehensive Evaluations Completed' as ParentGroup,
			' .... TBI Diagnosis Ruled Out' as Category,
			count(DISTINCT r.REFERRAL_ID) as Summar3 ,
			12 as displyOrder
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
			INNER JOIN WKF_CASE wfc
			ON r.REFERRAL_ID = wfc.REFERRAL_ID
			INNER JOIN TBI.TBI_TRACKING tt (nolock)
			on wfc.WKF_CASE_ID = tt.WKF_CASE_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			and
			(r.STD_REGISTRY_ID = 2)
			and 
			(tt.TBI_DIAGNOSIS_IND = 2)
			and 
			(r.STD_REFERRALSTS_ID = 3)



		IF @@ROWCOUNT = 0
			INSERT INTO @VhaSummary
							(Groups,ParentGroup, Category,Summary3,displyOrder)
						VALUES     
							(
							'Comprehensive Evaluation - Completed/Pending Futher Evaluation'
							,' .. Comprehensive Evaluations Completed'
							,' .... TBI Diagnosis Ruled Out'
							,0
							,12
							)

			
		-------------------------------
		-- TBI Diagnosis Pending
		Insert @VhaSummary (Groups,ParentGroup, Category,Summary3,displyOrder)
	    
		select 
			'Comprehensive Evaluation - Completed/Pending Futher Evaluation' as Groups,
			' .. Comprehensive Evaluations Completed' as ParentGroup,
			' .... TBI Diagnosis Uncertain Pending Further Evaluation' as Category,
			count(DISTINCT r.REFERRAL_ID) as Summar3 ,
			13 as displyOrder
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
			INNER JOIN WKF_CASE wfc
			ON r.REFERRAL_ID = wfc.REFERRAL_ID
			INNER JOIN TBI.TBI_TRACKING tt (nolock)
			on wfc.WKF_CASE_ID = tt.WKF_CASE_ID
		
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			and 
			(tt.TBI_DIAGNOSIS_IND = 0)
			and 
			(r.STD_REFERRALSTS_ID = 3)


		IF @@ROWCOUNT = 0
			INSERT INTO @VhaSummary
							(Groups,ParentGroup, Category,Summary3,displyOrder)
						VALUES     
							(
							'Comprehensive Evaluation - Completed/Pending Futher Evaluation'
							,' .. Comprehensive Evaluations Completed'
							,' .... TBI Diagnosis Uncertain Pending Further Evaluation'
							,0
							,13
							)
							


        /*  COMPREHENSIVE EVALUATION TO BE SCHEDULED OR PENDING CONTACT */

		-------------------------------
		-- Initial Positive Screen tracked for Comprehensive Evaluation
		Insert @VhaSummary (Groups,ParentGroup, Category,Summary1,displyOrder)
		
		select 
			'Comprehensive Evaluation - To be Scheduled or Pending Contact' as Groups,
			'Initial Positive Screens Tracked for Comprehensive Evaluation' as ParentGroup,
			'Initial Positive Screens Tracked for Comprehensive Evaluation' as Category,
			count(DISTINCT p.PATIENT_ID) as Summar1,
			14 as displyOrder
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			AND
			(rd.STD_HEALTHFACTOR_ID = 63 )
		
		IF @@ROWCOUNT = 0
			INSERT INTO @VhaSummary
							(Groups,ParentGroup, Category,Summary1,displyOrder)
						VALUES     
							(
							'Comprehensive Evaluation - To be Scheduled or Pending Contact'
							,'Initial Positive Screens Tracked for Comprehensive Evaluation'
							,'Initial Positive Screens Tracked for Comprehensive Evaluation'
							,0
							,14
							)
		
		-- Comprehensive Evaluation not Completed

		Insert @VhaSummary (Groups,ParentGroup, Category,Summary2,displyOrder)
	    
		select 
			'Comprehensive Evaluation - To be Scheduled or Pending Contact' as Groups,
			'Initial Positive Screens Tracked for Comprehensive Evaluation' as ParentGroup,
			' .. Comprehensive Evaluations not Completed' as Category,
			count(DISTINCT r.REFERRAL_ID) as Summar2 ,
			15 as displyOrder
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
		
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			AND 
			(r.STD_REFERRALSTS_ID <> 3)
			AND
			(rd.STD_HEALTHFACTOR_ID = 63)


		IF @@ROWCOUNT = 0
			INSERT INTO @VhaSummary
							(Groups,ParentGroup, Category,Summary2,displyOrder)
						VALUES     
							(
							'Comprehensive Evaluation - To be Scheduled or Pending Contact'
							,'Initial Positive Screens Tracked for Comprehensive Evaluation'
							,' .. Comprehensive Evaluations not Completed'
							,0
							,15
							)

		-------------------------------
		-- In Process Appointment Scheduled

		Insert @VhaSummary (Groups,ParentGroup, Category,Summary3,displyOrder)
		
		SELECT     
			'Comprehensive Evaluation - To be Scheduled or Pending Contact' AS Groups,
			' .. Comprehensive Evaluations not Completed' as ParentGroup, 
			' .... In Process Appointment Scheduled' AS Category, 
            COUNT(DISTINCT r.REFERRAL_ID) AS Summar3,
            16 as displyOrder
		FROM         
			WKF_CASE_ACTIVITY AS wca WITH (nolock) 
			INNER JOIN
			WKF_CASE AS wc WITH (nolock) 
			ON wca.WKF_CASE_ID = wc.WKF_CASE_ID 
			INNER JOIN
			REFERRAL AS r WITH (nolock) 
			ON wc.REFERRAL_ID = r.REFERRAL_ID
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			INNER JOIN
			REFERRAL_DETAIL AS rd WITH (nolock) 
			ON r.REFERRAL_ID = rd.REFERRAL_ID 
			INNER JOIN
			viewFacilitiesByVisn AS v 
			ON r.STD_INSTITUTION_ID = v.institution_id 
			INNER JOIN
			TBI.TBI_TRACKING AS tt WITH (nolock) 
			ON wc.WKF_CASE_ID = tt.WKF_CASE_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(r.STD_REGISTRY_ID = 2) 
			AND 
			(rd.STD_HEALTHFACTOR_ID = 63) 
			AND 
            (wca.TBI_EVALUATION_SCHEDULE_DATE IS NOT NULL) 
            AND 
            (wca.STD_TBIEVALDELAYTYPE_ID NOT IN (1, 2)) 
            AND 
            (r.STD_REFERRALSTS_ID <> 3)
            AND (wca.ARCHIVED_FLAG = 0) --Added per bug tracker #1539
		

		IF @@ROWCOUNT = 0
			INSERT INTO @VhaSummary
							(Groups,ParentGroup, Category,Summary3,displyOrder)
						VALUES     
							(
							'Comprehensive Evaluation - To be Scheduled or Pending Contact'
							,' .. Comprehensive Evaluations not Completed'
							,' .... In Process Appointment Scheduled'
							,0
							,16
							)

		-------------------------------
		-- Unable to Complete Comprehensive Evaluation

		Insert @VhaSummary (Groups,ParentGroup, Category,Summary3,displyOrder)

		select 
			'Comprehensive Evaluation - To be Scheduled or Pending Contact' as Groups,
			' .. Comprehensive Evaluations not Completed' as ParentGroup,
			' .... Unable to Complete Comprehensive Evaluation' as Category,
			count(p.PATIENT_ID) as Summary3,
			17 as displyOrder
		FROM         
			WKF_CASE_ACTIVITY AS wca WITH (nolock) 
			INNER JOIN
			WKF_CASE AS wc 
			ON wca.WKF_CASE_ID = wc.WKF_CASE_ID 
			INNER JOIN
			REFERRAL AS r WITH (nolock) 
			ON wc.REFERRAL_ID = r.REFERRAL_ID
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			INNER JOIN
			REFERRAL_DETAIL AS rd WITH (nolock) 
			ON r.REFERRAL_ID = rd.REFERRAL_ID 
			INNER JOIN
			viewFacilitiesByVisn AS v 
			ON r.STD_INSTITUTION_ID = v.institution_id 
			INNER JOIN
			TBI.TBI_TRACKING AS tt WITH (nolock) 
			ON wc.WKF_CASE_ID = tt.WKF_CASE_ID
			INNER JOIN
			(			SELECT     WKF_CASE.WKF_CASE_ID, WKF_CASE.REFERRAL_ID, 
						CASE WHEN ThreeNoShows.WKF_CASE_ID IS NULL THEN 0 ELSE 1 END as ThreeNoShows 
						FROM         (SELECT     WKF_CASE_ID
									   FROM          WKF_CASE_ACTIVITY AS wca2
									   WHERE      (STD_TBIEVALDELAYTYPE_ID IN (1, 2))
									   GROUP BY WKF_CASE_ID
									   HAVING      (COUNT(*) = 3)) AS ThreeNoShows 
						RIGHT OUTER JOIN
						WKF_CASE 
						ON ThreeNoShows.WKF_CASE_ID = WKF_CASE.WKF_CASE_ID) wcNoShow
			ON wc.WKF_CASE_ID = wcNoShow.WKF_CASE_ID
			
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(r.STD_REGISTRY_ID = 2) 
			AND 
			(rd.STD_HEALTHFACTOR_ID = 63) 
			AND 
            (r.STD_REFERRALSTS_ID = 3) 
            AND
            (
            wca.STD_TBISCHEDULESTS_ID in (1,4,5)
            OR 
            wcNoShow.ThreeNoShows = 1
            ) 
            AND (wca.ARCHIVED_FLAG = 0) --Added per bug tracker #1539
            
		IF @@ROWCOUNT = 0
			INSERT INTO @VhaSummary
							(Groups,ParentGroup, Category,Summary3,displyOrder)
						VALUES     
							(
							'Comprehensive Evaluation - To be Scheduled or Pending Contact'
							,' .. Comprehensive Evaluations not Completed'
							,' .... Unable to Complete Comprehensive Evaluation'
							,0
							,17
							)


	/*  LENGTH OF TIME TO COMPLETE COMPREHENSIVE EVALUATION FROM INITIAL POSITIVE SCREEN*/
	
		   	--Completed Comprehensive Evaluation with Completion Date
	   	Insert @VhaSummary (Groups,ParentGroup, Category,Summary1,displyOrder)

		select 
			'Length of Time to Complete Comprehensive Evaluation From Initial Positive Screen' as Groups,
			'Completed Comprehensive Evaluation with Completion Date' as ParentGroup,
			'Completed Comprehensive Evaluation with Completion Date' as Category,
			count(DISTINCT r.REFERRAL_ID) as Summary1 ,
			18 as displyOrder
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			--INNER JOIN
			--FactAmbEnc AS f WITH (nolock) 
            --ON f.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
			INNER JOIN WKF_CASE wfc
			ON r.REFERRAL_ID = wfc.REFERRAL_ID
			INNER JOIN TBI.TBI_TRACKING tt (nolock)
			on wfc.WKF_CASE_ID = tt.WKF_CASE_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			and 
			(tt.REFERRAL_COMPLETE_DATE is not null)
			and 
			(r.STD_REFERRALSTS_ID = 3)


		IF @@ROWCOUNT = 0
			INSERT INTO @VhaSummary
							(Groups,ParentGroup, Category,Summary1,displyOrder)
						VALUES     
							(
							'Length of Time to Complete Comprehensive Evaluation From Initial Positive Screen'
							,'Completed Comprehensive Evaluation with Completion Date'
							,'Completed Comprehensive Evaluation with Completion Date'
							,0
							,18
							)
	
	   	--Completed Comprehensive Evaluation within Completion Date
	   	Insert @VhaSummary (Groups,ParentGroup, Category,Summary2,displyOrder)
	
		select 
			'Length of Time to Complete Comprehensive Evaluation From Initial Positive Screen' as Groups,
			'.. Completed Comprehensive Evaluation within Thirty Days' as ParentGroup,
			'.. Completed Comprehensive Evaluation within Thirty Days' as Category,
			count(DISTINCT r.REFERRAL_ID) as Summary2 ,
			19 as displyOrder
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
			INNER JOIN WKF_CASE wfc
			ON r.REFERRAL_ID = wfc.REFERRAL_ID
			INNER JOIN TBI.TBI_TRACKING tt (nolock)
			on wfc.WKF_CASE_ID = tt.WKF_CASE_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			and 
			(tt.REFERRAL_COMPLETE_DATE is not null)
			and 
			(r.STD_REFERRALSTS_ID = 3)
			and 
			DATEDIFF(dd,r.REFERRAL_DATE,tt.REFERRAL_COMPLETE_DATE) <= 30 

	
		IF @@ROWCOUNT = 0
			INSERT INTO @VhaSummary
							(Groups,ParentGroup, Category,Summary2,displyOrder)
						VALUES     
							(
							'Length of Time to Complete Comprehensive Evaluation From Initial Positive Screen'
							,'.. Completed Comprehensive Evaluation within Thirty Days'
							,'.. Completed Comprehensive Evaluation within Thirty Days'
							,0
							,19
							)

	   	   	--Avg Number of Day from screening to Completion Date [Cummulative]
		Insert @VhaSummary (Groups,ParentGroup, Category,Summary2,displyOrder)
		
		select 
			'Length of Time to Complete Comprehensive Evaluation From Initial Positive Screen' as Groups,
			'.. Avg Number of Days from screen to Evaluation Completion (Cummulative)' as ParentGroup,
			'.. Avg Number of Days from screen to Evaluation Completion (Cummulative)' as Category, 
			avg(DATEDIFF(dd,r.REFERRAL_DATE,tt.REFERRAL_COMPLETE_DATE)) as summary2,
			20 as displyOrder
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
			INNER JOIN WKF_CASE wfc
			ON r.REFERRAL_ID = wfc.REFERRAL_ID
			INNER JOIN TBI.TBI_TRACKING tt (nolock)
			on wfc.WKF_CASE_ID = tt.WKF_CASE_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			and 
			(tt.REFERRAL_COMPLETE_DATE is not null)
			and 
			(r.STD_REFERRALSTS_ID = 3)


		IF @@ROWCOUNT = 0
			INSERT INTO @VhaSummary
							(Groups,ParentGroup, Category,Summary2,displyOrder)
						VALUES     
							(
 						    'Length of Time to Complete Comprehensive Evaluation From Initial Positive Screen'
							,'.. Avg Number of Days from screen to Evaluation Completion (Cummulative)'
							,'.. Avg Number of Days from screen to Evaluation Completion (Cummulative)'
							,0
							,20
							)

	   	   	--Avg Number of Day from screening to Completion Date [Current past 3 Month]
		
		Insert @VhaSummary (Groups,ParentGroup, Category, Footnote, Summary2,displyOrder)
	    
		select 
			'Length of Time to Complete Comprehensive Evaluation From Initial Positive Screen' as Groups,
			'.. Avg Number of Days from screen to Evaluation Completion (Current)' as ParentGroup,
			'.. Avg Number of Days from screen to Evaluation Completion (Current)' as Category,
			'***Reflects rolling 3 month average of most recent 3 month less first 30 days' as Footnote,
			avg(DATEDIFF(dd,r.REFERRAL_DATE,tt.REFERRAL_COMPLETE_DATE)) as summary2,
			21  as displyOrder
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			--INNER JOIN
			--FactAmbEnc AS f WITH (nolock) 
            --ON f.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
			INNER JOIN WKF_CASE wfc
			ON r.REFERRAL_ID = wfc.REFERRAL_ID
			INNER JOIN TBI.TBI_TRACKING tt (nolock)
			on wfc.WKF_CASE_ID = tt.WKF_CASE_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			and 
			(tt.REFERRAL_COMPLETE_DATE is not null)
			and 
			(r.STD_REFERRALSTS_ID = 3)
			and 
			r.REFERRAL_DATE >=  CONVERT(varchar, DATEADD(mm, -3, getdate()),101) 
		
			
		IF @@ROWCOUNT = 0
			INSERT INTO @VhaSummary
							(Groups,ParentGroup, Category,Footnote, Summary2,displyOrder)
						VALUES     
							(
							'Length of Time to Complete Comprehensive Evaluation From Initial Positive Screen'
							,'.. Avg Number of Days from screen to Evaluation Completion (Current)'
							,'.. Avg Number of Days from screen to Evaluation Completion (Current)'
							,'***Reflects rolling 3 month average of most recent 3 month less first 30 days'
							,0
							,21
							)

	
	SELECT 
		p3.Groups,
		p3.ParentGroup,
		p3.Footnote,
		p3.Category,
		p3.Summary1,
		p3.Summary2,
		p3.Summary3,
		p3.Total
		,
		CurrentSum = 
			Case
				WHEN Summary1 IS NOT NULL
				THEN Summary1 
				WHEN Summary2 IS NOT NULL
				THEN Summary2 
				WHEN Summary3 IS NOT NULL
				THEN Summary3
				ELSE 0
			END 
				
		,p3.displayOrder1
		--,
		--Percentage = 
		--	CASE
		--		WHEN Summary3 IS NOT NULL
		--			THEN CONVERT(decimal(5,2),Summary3/Total)
		--		WHEN Summary2 IS NOT NULL
		--			THEN CONVERT(decimal(5,2),Summary2/Total)
		--		ELSE	
		--			0
		--	END
		--	,CONVERT(decimal(5,2),23/30) as test
		 
	FROM
	(Select 
		p1.Groups,
		p1.ParentGroup,
		p1.Footnote,
		p1.Category,
		p1.Summary1,
		p1.Summary2,
		p1.Summary3,
		Total =
			CASE 
				WHEN p1.Summary1 IS NOT NULL
					THEN NULL
				WHEN p1.Category = p1.ParentGroup
					THEN NULL
				WHEN (p1.Summary2 IS NOT NULL) --AND (p1.Category <> p1.ParentGroup)
					THEN 
						pParent.Summary1
				WHEN (p1.Summary3 IS NOT NULL) --AND (p1.Category <> p1.ParentGroup)
					THEN 
						pParent.Summary2
				ELSE	
					NULL	
			END		
		
		,
		pParent.Summary1 as ParentSummary1,
		pParent.Summary2 as ParentSummary2,
		p1.displyOrder as displayOrder1
        
    FROM @VhaSummary p1
     LEFT OUTER JOIN
			@VhaSummary AS pParent 
			ON p1.ParentGroup = pParent.Category
			AND
			   p1.Groups = pParent.Groups
	) p3
	
	ORDER BY p3.displayOrder1
		
    
    --(SELECT ps2.Summary2 FROM @PatientSummary ps2 WHERE ps2.Category = p1.ParentGroup) as ParentSummary2,
		--(SELECT ps2.Summary1 FROM @PatientSummary ps2 WHERE ps2.Category = p1.ParentGroup) as ParentSummary1
		--Percentage = 
		--CASE 
		--	WHEN p1.Category = p1.ParentGroup 
		--		THEN ''
		--	WHEN (p1.Summary2 IS NOT NULL) AND (p1.Category <> p1.ParentGroup)
		--		THEN '1'
		--		--THEN SELECT p1.Summary2 FROM @PatientSummary ps2 WHERE ps2.Category = ps1.Category
		--END


End Try	
Begin catch
	Return
End Catch

END

	/* SET NOCOUNT ON */
	RETURN



GO

/****** Object:  StoredProcedure [dbo].[ComprehensiveFacilityDetail_Report]    Script Date: 01/16/2012 14:23:29 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



CREATE PROCEDURE [dbo].[ComprehensiveFacilityDetail_Report]
	(
	@visnId varchar(3),
	@FacilityID int
	)
AS

BEGIN

    
    set Nocount on
 
declare @startdate datetime = [dbo].[GetFiscalYearStartDate] (GETDATE())
declare @enddate datetime = [dbo].[GetTBIReportValidEndDate] (GETDATE())


Begin Try
    
--- Table Variable to Hold result sets
     
    Declare @FacilityDetailTable Table(
        FacilityID int null,
        PatientSSN varchar(12) null,
        PatientName varchar(100) null,
        Groups varchar(200) null,
        Category varchar(200) null);
        

	 /* COMPREHENSIVE EVALUATION:- COMPLETED/PENDING FURTHER EVALUATION  */

		-------------------------------
		-- Initial Positive Screen tracked for Comprehensive Evaluation
		Insert @FacilityDetailTable (FacilityID,PatientSSN,PatientName,Groups,Category)
				
		select distinct
			v.base_station_number,
			p.SSN as PatientSSN,
			isnull(p.FIRST_NAME,'') + ' '+ ISNULL(p.LAST_NAME,'') as PatientName,
			'Comprehensive Evaluation - Completed/Pending Futher Evaluation' as Groups,
			'Initial Positive Screens tracked for Comprehensive Evaluation' as Category
			
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			and
			(r.STD_REGISTRY_ID = 2)
			AND
			(rd.STD_HEALTHFACTOR_ID = 63 )
			AND
			(r.STD_REFERRALSTS_ID <> 16)
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(v.base_station_number = @FacilityID)
			
		
		-- Comprehensive Evaluation Completed
		Insert @FacilityDetailTable (FacilityID,PatientSSN,PatientName,Groups,Category)
		
		select distinct
			v.base_station_number,
			p.SSN as PatientSSN,
			isnull(p.FIRST_NAME,'') + ' '+ ISNULL(p.LAST_NAME,'') as PatientName, 
			'Comprehensive Evaluation - Completed/Pending Futher Evaluation' as Groups,
			' .. Comprehensive Evaluations Completed' as Category
			
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
			INNER JOIN WKF_CASE wfc
			ON r.REFERRAL_ID = wfc.REFERRAL_ID
			INNER JOIN TBI.TBI_TRACKING tt (nolock)
			on wfc.WKF_CASE_ID = tt.WKF_CASE_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			and
			(r.STD_REGISTRY_ID = 2)
			and 
			(tt.REFERRAL_COMPLETE_DATE is not null)
			and 
			(r.STD_REFERRALSTS_ID = 3)
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(v.base_station_number = @FacilityID)


		-------------------------------
		-- Comfirmed TBI Diagnosis
		Insert @FacilityDetailTable (FacilityID,PatientSSN,PatientName,Groups,Category)
				
		select distinct
			v.base_station_number,
			p.SSN as PatientSSN,
			isnull(p.FIRST_NAME,'') + ' '+ ISNULL(p.LAST_NAME,'') as PatientName,
			'Comprehensive Evaluation - Completed/Pending Futher Evaluation' as Groups,
			' .... Comfirmed TBI Diagnosis' as Category
			
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
			INNER JOIN WKF_CASE wfc
			ON r.REFERRAL_ID = wfc.REFERRAL_ID
			INNER JOIN TBI.TBI_TRACKING tt (nolock)
			on wfc.WKF_CASE_ID = tt.WKF_CASE_ID
		
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			and 
			(tt.TBI_DIAGNOSIS_IND = 1)
			and 
			(r.STD_REFERRALSTS_ID = 3)
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(v.base_station_number = @FacilityID)
			
			
		-------------------------------
		-- TBI Diagnosis Ruled Out
		Insert @FacilityDetailTable (FacilityID,PatientSSN,PatientName,Groups,Category)
				
		select distinct
			v.base_station_number,
			p.SSN as PatientSSN,
			isnull(p.FIRST_NAME,'') + ' '+ ISNULL(p.LAST_NAME,'') as PatientName,
			'Comprehensive Evaluation - Completed/Pending Futher Evaluation' as Groups,
			' .... TBI Diagnosis Ruled Out' as Category
			
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
			INNER JOIN WKF_CASE wfc
			ON r.REFERRAL_ID = wfc.REFERRAL_ID
			INNER JOIN TBI.TBI_TRACKING tt (nolock)
			on wfc.WKF_CASE_ID = tt.WKF_CASE_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			and 
			(tt.TBI_DIAGNOSIS_IND = 2)
			and 
			(r.STD_REFERRALSTS_ID = 3)
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(v.base_station_number = @FacilityID)
			


		-------------------------------
		-- TBI Diagnosis Pending
		Insert @FacilityDetailTable (FacilityID,PatientSSN,PatientName,Groups,Category)
				
		select distinct
			v.base_station_number,
			p.SSN as PatientSSN,
			isnull(p.FIRST_NAME,'') + ' '+ ISNULL(p.LAST_NAME,'') as PatientName,
			'Comprehensive Evaluation - Completed/Pending Futher Evaluation' as Groups,
			' .... TBI Diagnosis Uncertain Pending Further Evaluation' as Category
			 
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
			INNER JOIN WKF_CASE wfc
			ON r.REFERRAL_ID = wfc.REFERRAL_ID
			INNER JOIN TBI.TBI_TRACKING tt (nolock)
			on wfc.WKF_CASE_ID = tt.WKF_CASE_ID
		
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			and 
			(tt.TBI_DIAGNOSIS_IND = 0)
			and 
			(r.STD_REFERRALSTS_ID = 3)
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(v.base_station_number = @FacilityID)

        /*  COMPREHENSIVE EVALUATION TO BE SCHEDULED OR PENDING CONTACT */

		-------------------------------
		-- Initial Positive Screen tracked for Comprehensive Evaluation
		Insert @FacilityDetailTable (FacilityID,PatientSSN,PatientName,Groups,Category)
				
		select distinct
			v.base_station_number,
			p.SSN as PatientSSN,
			isnull(p.FIRST_NAME,'') + ' '+ ISNULL(p.LAST_NAME,'') as PatientName,
			'Comprehensive Evaluation - To be Scheduled or Pending Contact' as Groups,
			'Initial Positive Screens tracked for Comprehensive Evaluation' as Category
			
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			AND
			(rd.STD_HEALTHFACTOR_ID = 63 )
			AND
			r.STD_REFERRALSTS_ID <> 16
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(v.base_station_number = @FacilityID)
			
		
		-- Comprehensive Evaluation not Completed

		Insert @FacilityDetailTable (FacilityID,PatientSSN,PatientName,Groups,Category)
				
		select distinct
			v.base_station_number,
			p.SSN as PatientSSN,
			isnull(p.FIRST_NAME,'') + ' '+ ISNULL(p.LAST_NAME,'') as PatientName, 
			'Comprehensive Evaluation - To be Scheduled or Pending Contact' as Groups,
			' .. Comprehensive Evaluations not Completed' as Category

		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			--INNER JOIN
			--FactAmbEnc AS f WITH (nolock) 
            --ON f.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
		
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			AND 
			(r.STD_REFERRALSTS_ID <> 3)
			AND
			(rd.STD_HEALTHFACTOR_ID = 63)
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(v.base_station_number = @FacilityID)
			
		


		-------------------------------
		-- In Process Appointment Scheduled

		Insert @FacilityDetailTable (FacilityID,PatientSSN,PatientName,Groups,Category)
				
		select distinct
			v.base_station_number,
			p.SSN as PatientSSN,
			isnull(p.FIRST_NAME,'') + ' '+ ISNULL(p.LAST_NAME,'') as PatientName,
			'Comprehensive Evaluation - To be Scheduled or Pending Contact' AS Groups, 
			' .... In Process Appointment Scheduled' AS Category 
            
		FROM         
			WKF_CASE_ACTIVITY AS wca WITH (nolock) 
			INNER JOIN
			WKF_CASE AS wc WITH (nolock) 
			ON wca.WKF_CASE_ID = wc.WKF_CASE_ID 
			INNER JOIN
			REFERRAL AS r WITH (nolock) 
			ON wc.REFERRAL_ID = r.REFERRAL_ID
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			INNER JOIN
			REFERRAL_DETAIL AS rd WITH (nolock) 
			ON r.REFERRAL_ID = rd.REFERRAL_ID 
			INNER JOIN
			viewFacilitiesByVisn AS v 
			ON r.STD_INSTITUTION_ID = v.institution_id 
			INNER JOIN
			TBI.TBI_TRACKING AS tt WITH (nolock) 
			ON wc.WKF_CASE_ID = tt.WKF_CASE_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(r.STD_REGISTRY_ID = 2) 
			AND 
			(rd.STD_HEALTHFACTOR_ID = 63) 
			AND 
            (wca.TBI_EVALUATION_SCHEDULE_DATE IS NOT NULL) 
            AND 
            (wca.STD_TBIEVALDELAYTYPE_ID NOT IN (1, 2)) 
            AND 
            (r.STD_REFERRALSTS_ID <> 3)
            AND 
			(v.VisnID = @VisnID) 
			AND 
			(v.base_station_number = @FacilityID)
			 AND (wca.ARCHIVED_FLAG = 0) --Added per bug tracker #1539
			

		-------------------------------
		-- Unable to Complete Comprehensive Evaluation

		Insert @FacilityDetailTable (FacilityID,PatientSSN,PatientName,Groups,Category)
				
		select distinct
			v.base_station_number,
			p.SSN as PatientSSN,
			isnull(p.FIRST_NAME,'') + ' '+ ISNULL(p.LAST_NAME,'') as PatientName,
			'Comprehensive Evaluation - To be Scheduled or Pending Contact' as Groups,
			' .... Unable to Complete Comprehensive Evaluation' as Category
			
		FROM         
			WKF_CASE_ACTIVITY AS wca WITH (nolock) 
			INNER JOIN
			WKF_CASE AS wc 
			ON wca.WKF_CASE_ID = wc.WKF_CASE_ID 
			INNER JOIN
			REFERRAL AS r WITH (nolock) 
			ON wc.REFERRAL_ID = r.REFERRAL_ID
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			INNER JOIN
			REFERRAL_DETAIL AS rd WITH (nolock) 
			ON r.REFERRAL_ID = rd.REFERRAL_ID 
			INNER JOIN
			viewFacilitiesByVisn AS v 
			ON r.STD_INSTITUTION_ID = v.institution_id 
			INNER JOIN
			TBI.TBI_TRACKING AS tt WITH (nolock) 
			ON wc.WKF_CASE_ID = tt.WKF_CASE_ID
			INNER JOIN
			(			SELECT     WKF_CASE.WKF_CASE_ID, WKF_CASE.REFERRAL_ID, 
						CASE WHEN ThreeNoShows.WKF_CASE_ID IS NULL THEN 0 ELSE 1 END as ThreeNoShows 
						FROM         (SELECT     WKF_CASE_ID
									   FROM          WKF_CASE_ACTIVITY AS wca2
									   WHERE      (STD_TBIEVALDELAYTYPE_ID IN (1, 2))
									   GROUP BY WKF_CASE_ID
									   HAVING      (COUNT(*) = 3)) AS ThreeNoShows 
						RIGHT OUTER JOIN
						WKF_CASE 
						ON ThreeNoShows.WKF_CASE_ID = WKF_CASE.WKF_CASE_ID) wcNoShow
			ON wc.WKF_CASE_ID = wcNoShow.WKF_CASE_ID
			
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(r.STD_REGISTRY_ID = 2) 
			AND 
			(rd.STD_HEALTHFACTOR_ID = 63) 
			AND 
            (r.STD_REFERRALSTS_ID = 3) 
            AND
            (
            wca.STD_TBISCHEDULESTS_ID in (1,4,5)
            OR 
            wcNoShow.ThreeNoShows = 1
            ) 
            AND 
			(v.VisnID = @VisnID) 
			AND 
			(v.base_station_number = @FacilityID)
			AND (wca.ARCHIVED_FLAG = 0) --Added per bug tracker #1539
			
		


		
Select * from @FacilityDetailTable


End Try	
Begin catch
	Return
End Catch

END

	/* SET NOCOUNT ON */
	RETURN



GO

/****** Object:  StoredProcedure [dbo].[VisnSummaryReport_byVisnID2]    Script Date: 01/16/2012 14:23:29 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



CREATE PROCEDURE [dbo].[VisnSummaryReport_byVisnID2]
	(
	@visnId varchar(3)
	)
AS

BEGIN
    --select * from dbo.Report_VISN_Summary r
    
    set Nocount on
 
declare @startdate datetime = [dbo].[GetFiscalYearStartDate] (GETDATE())
declare @enddate datetime = [dbo].[GetTBIReportValidEndDate] (GETDATE())


Begin Try
    
--- Table Variable to Hold result sets
     
    Declare @PatientSummary table (
        VISN_ID varchar(10) null,
        Groups varchar(200) null,
        ParentGroup varchar(200) null,
        Footnote varchar(200) null,
        Category varchar(200) null,
        Summary1 int null,
        Summary2 int null,
        Summary3 int null,
        Percentage decimal(5,2));
        

	/*  INITIAL SCREENING INFORMATION */
	
		-- as 'Total Total OEF/OIF Veterans Screened for possible TBI'
	    Insert @PatientSummary (VISN_ID, Groups, ParentGroup, Category, Summary1)
		
		SELECT     
			v.VisnID,
			'Initial Screening Information' AS Groups,
			'Total OEF/OIF Veterans Screened for possible TBI' AS ParentGroup,  
			'Total OEF/OIF Veterans Screened for possible TBI' AS Category, 
			COUNT(DISTINCT p.PATIENT_ID) AS Summary1
			
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id

		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND (r.STD_REGISTRY_ID = 2) 
			AND (v.VisnID = @VisnID)
			
		GROUP BY 
			v.VisnID


		IF @@ROWCOUNT = 0
			INSERT INTO @PatientSummary
							(VISN_ID, Groups, ParentGroup, Category, Summary1)
						VALUES     
							(
							@VisnID
							,'Initial Screening Information'
							,'Total OEF/OIF Veterans Screened for possible TBI'
							,'Total OEF/OIF Veterans Screened for possible TBI'
							,0
							)

		-- 'Total OEF/OIF Veterans with self reported previous diagnosis of TBI'
		
	    Insert @PatientSummary (VISN_ID, Groups, ParentGroup, Category, Summary2)
	    
		select 
		v.VisnID , 
		'Initial Screening Information' as Groups,
		'Total OEF/OIF Veterans Screened for possible TBI' AS ParentGroup,  
		' .. *Total number OEF/OIF Veterans with self reported previous diagnosis of TBI' as Category,
		count(DISTINCT p.PATIENT_ID) as Summar2
				
		from 
			dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
			on r.PATIENT_ID = p.PATIENT_ID
			join REFERRAL_DETAIL rd (nolock)
			on r.REFERRAL_ID = rd.REFERRAL_ID
			join dbo.viewFacilitiesByVisn v
			on r.STD_INSTITUTION_ID = v.institution_id
		where 
			p.OEF_OIF_IND = 1
			and r.STD_REGISTRY_ID = 2
			and rd.STD_HEALTHFACTOR_ID = 51
			and v.VisnID = @VisnID
		group by 
			v.VisnID;
			
		
		IF @@ROWCOUNT = 0
			INSERT INTO @PatientSummary
							(VISN_ID,Groups, ParentGroup,Category,Summary2)
						VALUES     
							(
							@VisnID
							,'Initial Screening Information'
							,'Total OEF/OIF Veterans Screened for possible TBI'
							,' .. *Total number OEF/OIF Veterans with self reported previous diagnosis of TBI'
							,0
							)		

		--  'Total OEF/OIF Veterans with negative initial TBI Screen'
		Insert @PatientSummary (VISN_ID,Groups,ParentGroup,Category,Summary2)
	    
		SELECT     
			v.VisnID, 
			'Initial Screening Information' AS Groups,
			'Total OEF/OIF Veterans Screened for possible TBI' as ParentGroup, 
			' .. Total OEF/OIF Veterans with negative initial TBI Screen' AS Category, 
			COUNT(DISTINCT p.PATIENT_ID) AS Summar2
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			INNER JOIN
			viewFacilitiesByVisn AS v 
			ON r.STD_INSTITUTION_ID = v.institution_id 
		
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND (v.VisnID = @VisnID) 
			AND (r.STD_REGISTRY_ID = 2) 
			AND
			r.REFERRAL_ID NOT IN  
			(
				select r2.REFERRAL_ID from dbo.REFERRAL r2(nolock)join dbo.REFERRAL_DETAIL rd2 (nolock) 
				on r2.REFERRAL_ID = rd2.REFERRAL_ID
				INNER JOIN
				viewFacilitiesByVisn AS v2 
				ON r2.STD_INSTITUTION_ID = v2.institution_id
				where 
				(v2.VisnID = @VisnID) 
				AND
				rd2.STD_HEALTHFACTOR_ID = 63
		    )
		GROUP BY 
			v.VisnID

		
		IF @@ROWCOUNT = 0
			INSERT INTO @PatientSummary
							(VISN_ID,Groups,ParentGroup,Category,Summary2)
						VALUES     
							(
							@VisnID
							,'Initial Screening Information'
							,'Total OEF/OIF Veterans Screened for possible TBI'
							,' .. Total OEF/OIF Veterans with negative initial TBI Screen'
							,0
							)

		--  'Total OEF/OIF Veterans with Positive initial TBI Screen'
		Insert @PatientSummary (VISN_ID,Groups,ParentGroup,Category,Summary2)
		
		SELECT     
			v.VisnID, 
			'Initial Screening Information' AS Groups, 
			'Total OEF/OIF Veterans Screened for possible TBI' as ParentGroup, 
			' .. Total OEF/OIF Veterans with Positive initial TBI Screen' AS Category, 
			COUNT(DISTINCT p.PATIENT_ID) AS Summar2
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
            INNER JOIN dbo.REFERRAL_DETAIL rd (nolock) 
			ON r.REFERRAL_ID = rd.REFERRAL_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			AND
			(rd.STD_HEALTHFACTOR_ID = 63)
		    
		GROUP BY 
			v.VisnID


		IF @@ROWCOUNT = 0
			INSERT INTO @PatientSummary
							(VISN_ID,Groups,ParentGroup,Category,Summary2)
						VALUES     
							(
							@VisnID
							,'Initial Screening Information'
							,'Total OEF/OIF Veterans Screened for possible TBI'
							,' .. Total OEF/OIF Veterans with Positive initial TBI Screen'
							,0
							)

		-------------------------------
		-- Initial Positive Screen who declined a Comprehensive Evaluation
		Insert @PatientSummary (VISN_ID,Groups,ParentGroup,Category,Summary3)
	    
		SELECT     
			v.VisnID, 
			'Initial Screening Information' AS Groups,
			' .. Total OEF/OIF Veterans with Positive initial TBI Screen' as ParentGroup,  
			' .... Initial Positive Screens who declined a Comprehensive Evaluation' AS Category, 
			COUNT(DISTINCT p.PATIENT_ID) AS Summar3
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			AND
			(rd.STD_HEALTHFACTOR_ID = 53 )
			AND 
			r.REFERRAL_ID IN  
			(
				select r2.REFERRAL_ID from dbo.REFERRAL r2(nolock)join dbo.REFERRAL_DETAIL rd2 (nolock) 
				on r2.REFERRAL_ID = rd2.REFERRAL_ID
				INNER JOIN
				viewFacilitiesByVisn AS v2 
				ON r2.STD_INSTITUTION_ID = v2.institution_id
				where 
				(v2.VisnID = @VisnID) 
				AND
				rd2.STD_HEALTHFACTOR_ID = 63
		    )
	
		GROUP BY 
			v.VisnID
		
		IF @@ROWCOUNT = 0
			INSERT INTO @PatientSummary
							(VISN_ID,Groups,ParentGroup,Category,Summary3)
						VALUES     
							(
							@VisnID
							,'Initial Screening Information'
							,' .. Total OEF/OIF Veterans with Positive initial TBI Screen'
							,' .... Initial Positive Screens who declined a Comprehensive Evaluation'
							,0
							)
							
							
		-------------------------------
		-- Initial Positive Screen tracked for Comprehensive Evaluation
		Insert @PatientSummary (VISN_ID,Groups,ParentGroup,Category,Summary3)
	    

		SELECT     
			v.VisnID , 
			'Initial Screening Information' as Groups,
			' .. Total OEF/OIF Veterans with Positive initial TBI Screen' as ParentGroup,  
			' .... Initial Positive Screens Tracked for Comprehensive Evaluation' as Category,
			COUNT(DISTINCT p.PATIENT_ID) AS Summar3
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
	        INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			AND
			(rd.STD_HEALTHFACTOR_ID = 63 )
			AND
			(r.STD_REFERRALSTS_ID <> 16)
			
			--AND 
			--r.REFERRAL_ID IN  
			--(
			--	select r2.REFERRAL_ID from dbo.REFERRAL r2(nolock)join dbo.REFERRAL_DETAIL rd2 (nolock) 
			--	on r2.REFERRAL_ID = rd2.REFERRAL_ID
			--	INNER JOIN
			--	viewFacilitiesByVisn AS v2 
			--	ON r2.STD_INSTITUTION_ID = v2.institution_id
			--	where 
			--	(v2.VisnID = @VisnID) 
			--	AND
			--	rd2.STD_HEALTHFACTOR_ID = 54
		 --   )
	
		GROUP BY 
			v.VisnID

		IF @@ROWCOUNT = 0
			INSERT INTO @PatientSummary
							(VISN_ID,Groups,ParentGroup,Category,Summary3)
						VALUES     
							(
							@VisnID
							,'Initial Screening Information'
							,' .. Total OEF/OIF Veterans with Positive initial TBI Screen'
							,' .... Initial Positive Screens Tracked for Comprehensive Evaluation'
							,0
							)

		-------------------------------
		-- Initial Positive Screen who did NOT decline Comprehensive Evaluation
		Insert @PatientSummary (VISN_ID,Groups,ParentGroup, Footnote, Category,Summary3)
		
		select 
			v.VisnID , 
			'Initial Screening Information' as Groups,
			' .. Total OEF/OIF Veterans with Positive initial TBI Screen' as ParentGroup,  
			'*Not included in tracking TBI Screening tool and Comprehensive TBI Evaluation Process ' as Footnote,
			'Initial Positive Screens who did NOT decline Comprehensive Evaluation' as Category,
			count(DISTINCT p.PATIENT_ID) as Summar3
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			AND
			(rd.STD_HEALTHFACTOR_ID = 63 )
			AND
			(r.STD_REFERRALSTS_ID <> 16)
			
			--AND 
			--r.REFERRAL_ID IN  
			--(
			--	select r2.REFERRAL_ID from dbo.REFERRAL r2(nolock)join dbo.REFERRAL_DETAIL rd2 (nolock) 
			--	on r2.REFERRAL_ID = rd2.REFERRAL_ID
			--	INNER JOIN
			--	viewFacilitiesByVisn AS v2 
			--	ON r2.STD_INSTITUTION_ID = v2.institution_id
			--	where 
			--	(v2.VisnID = @VisnID) 
			--	AND
			--	rd2.STD_HEALTHFACTOR_ID = 54
		 --   )
	
		GROUP BY 
			v.VisnID
					
		IF @@ROWCOUNT = 0
			INSERT INTO @PatientSummary
							(VISN_ID,Groups,ParentGroup, Footnote, Category,Summary3)
						VALUES     
							(
							@VisnID
							,'Initial Screening Information'
							,' .. Total OEF/OIF Veterans with Positive initial TBI Screen'
							,'*Not included in tracking TBI Screening tool and Comprehensive TBI Evaluation Process '
							,'Initial Positive Screens who did NOT decline Comprehensive Evaluation'
							,0
							)

	 /* COMPREHENSIVE EVALUATION:- COMPLETED/PENDING FURTHER EVALUATION  */

		-------------------------------
		-- Initial Positive Screen tracked for Comprehensive Evaluation
		Insert @PatientSummary (VISN_ID,Groups,ParentGroup,Category,Summary1)
		
		select 
			v.VisnID , 
			'Comprehensive Evaluation - Completed/Pending Futher Evaluation' as Groups,
			'Initial Positive Screens Tracked for Comprehensive Evaluation' as ParentGroup,  
			'Initial Positive Screens Tracked for Comprehensive Evaluation' as Category,
			count(DISTINCT p.PATIENT_ID) as Summar1
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			AND
			(rd.STD_HEALTHFACTOR_ID = 63 )
			AND
			r.STD_REFERRALSTS_ID <> 16
			
			--AND 
			--r.REFERRAL_ID IN  
			--(
			--	select r2.REFERRAL_ID from dbo.REFERRAL r2(nolock)join dbo.REFERRAL_DETAIL rd2 (nolock) 
			--	on r2.REFERRAL_ID = rd2.REFERRAL_ID
			--	INNER JOIN
			--	viewFacilitiesByVisn AS v2 
			--	ON r2.STD_INSTITUTION_ID = v2.institution_id
			--	where 
			--	(v2.VisnID = @VisnID) 
			--	AND
			--	rd2.STD_HEALTHFACTOR_ID = 54
		 --   )
	
		GROUP BY 
			v.VisnID
		
		IF @@ROWCOUNT = 0
			INSERT INTO @PatientSummary
							(VISN_ID,Groups,ParentGroup, Category,Summary1)
						VALUES     
							(
							@VisnID
							,'Comprehensive Evaluation - Completed/Pending Futher Evaluation'
							,'Initial Positive Screens Tracked for Comprehensive Evaluation'
							,'Initial Positive Screens Tracked for Comprehensive Evaluation'
							,0
							)
		
		-- Comprehensive Evaluation Completed
		Insert @PatientSummary (VISN_ID,Groups,ParentGroup,Category,Summary2)
	    
		select 
			v.VisnID , 
			'Comprehensive Evaluation - Completed/Pending Futher Evaluation' as Groups,
			'Initial Positive Screens Tracked for Comprehensive Evaluation' as ParentGroup, 
			' .. Comprehensive Evaluations Completed' as Category,
			count(DISTINCT r.REFERRAL_ID) as Summar2 
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
			INNER JOIN WKF_CASE wfc
			ON r.REFERRAL_ID = wfc.REFERRAL_ID
			INNER JOIN TBI.TBI_TRACKING tt (nolock)
			on wfc.WKF_CASE_ID = tt.WKF_CASE_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			and 
			(tt.REFERRAL_COMPLETE_DATE is not null)
			and 
			(r.STD_REFERRALSTS_ID = 3)
		GROUP BY 
			v.VisnID

		IF @@ROWCOUNT = 0
			INSERT INTO @PatientSummary
							(VISN_ID,Groups,ParentGroup,Category,Summary2)
						VALUES     
							(
							@VisnID
							,'Comprehensive Evaluation - Completed/Pending Futher Evaluation'
							,'Initial Positive Screens Tracked for Comprehensive Evaluation'
							,' .. Comprehensive Evaluations Completed'
							,0
							)


		-------------------------------
		-- Comfirmed TBI Diagnosis
		Insert @PatientSummary (VISN_ID,Groups,ParentGroup,Category,Summary3)
		
		select 
			v.VisnID , 
			'Comprehensive Evaluation - Completed/Pending Futher Evaluation' as Groups,
			' .. Comprehensive Evaluations Completed' as ParentGroup, 
			' .... Comfirmed TBI Diagnosis' as Category,
			count(DISTINCT r.REFERRAL_ID) as Summar3 
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
			INNER JOIN WKF_CASE wfc
			ON r.REFERRAL_ID = wfc.REFERRAL_ID
			INNER JOIN TBI.TBI_TRACKING tt (nolock)
			on wfc.WKF_CASE_ID = tt.WKF_CASE_ID
		
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			and 
			(tt.TBI_DIAGNOSIS_IND = 1)
			and 
			(r.STD_REFERRALSTS_ID = 3)
		GROUP BY 
			v.VisnID

		IF @@ROWCOUNT = 0
			INSERT INTO @PatientSummary
							(VISN_ID,Groups,ParentGroup,Category,Summary3)
						VALUES     
							(
							@VisnID
							,'Comprehensive Evaluation - Completed/Pending Futher Evaluation'
							,' .. Comprehensive Evaluations Completed'
							,' .... Comfirmed TBI Diagnosis'
							,0
							)
							

		-------------------------------
		-- TBI Diagnosis Ruled Out
		Insert @PatientSummary (VISN_ID,Groups,ParentGroup,Category,Summary3)
	   
		select 
			v.VisnID , 
			'Comprehensive Evaluation - Completed/Pending Futher Evaluation' as Groups,
			' .. Comprehensive Evaluations Completed' as ParentGroup,
			' .... TBI Diagnosis Ruled Out' as Category,
			count(DISTINCT r.REFERRAL_ID) as Summar3 
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
			INNER JOIN WKF_CASE wfc
			ON r.REFERRAL_ID = wfc.REFERRAL_ID
			INNER JOIN TBI.TBI_TRACKING tt (nolock)
			on wfc.WKF_CASE_ID = tt.WKF_CASE_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			and 
			(tt.TBI_DIAGNOSIS_IND = 2)
			and 
			(r.STD_REFERRALSTS_ID = 3)
		GROUP BY 
			v.VisnID


		IF @@ROWCOUNT = 0
			INSERT INTO @PatientSummary
							(VISN_ID,Groups,ParentGroup,Category,Summary3)
						VALUES     
							(
							@VisnID
							,'Comprehensive Evaluation - Completed/Pending Futher Evaluation'
							,' .. Comprehensive Evaluations Completed'
							,' .... TBI Diagnosis Ruled Out'
							,0
							)

			
		-------------------------------
		-- TBI Diagnosis Pending
		Insert @PatientSummary (VISN_ID,Groups,ParentGroup,Category,Summary3)
	    
		select 
			v.VisnID , 
			'Comprehensive Evaluation - Completed/Pending Futher Evaluation' as Groups,
			' .. Comprehensive Evaluations Completed' as ParentGroup,
			' .... TBI Diagnosis Uncertain Pending Further Evaluation' as Category,
			count(DISTINCT r.REFERRAL_ID) as Summar3 
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
			INNER JOIN WKF_CASE wfc
			ON r.REFERRAL_ID = wfc.REFERRAL_ID
			INNER JOIN TBI.TBI_TRACKING tt (nolock)
			on wfc.WKF_CASE_ID = tt.WKF_CASE_ID
		
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			and 
			(tt.TBI_DIAGNOSIS_IND = 3)
			and 
			(r.STD_REFERRALSTS_ID = 3)
		GROUP BY 
			v.VisnID

		IF @@ROWCOUNT = 0
			INSERT INTO @PatientSummary
							(VISN_ID,Groups,ParentGroup,Category,Summary3)
						VALUES     
							(
							@VisnID
							,'Comprehensive Evaluation - Completed/Pending Futher Evaluation'
							,' .. Comprehensive Evaluations Completed'
							,' .... TBI Diagnosis Uncertain Pending Further Evaluation'
							,0
							)
							


        /*  COMPREHENSIVE EVALUATION TO BE SCHEDULED OR PENDING CONTACT */

		-------------------------------
		-- Initial Positive Screen tracked for Comprehensive Evaluation
		Insert @PatientSummary (VISN_ID,Groups,ParentGroup,Category,Summary1)
	    
		select 
			v.VisnID , 
			'Comprehensive Evaluation - To be Scheduled or Pending Contact' as Groups,
			'Initial Positive Screens Tracked for Comprehensive Evaluation' as ParentGroup,
			'Initial Positive Screens Tracked for Comprehensive Evaluation' as Category,
			count(DISTINCT p.PATIENT_ID) as Summar1
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			AND
			(rd.STD_HEALTHFACTOR_ID = 63 )
			AND
			r.STD_REFERRALSTS_ID <> 16
			--AND 
			--r.REFERRAL_ID IN  
			--(
			--	select r2.REFERRAL_ID from dbo.REFERRAL r2(nolock)join dbo.REFERRAL_DETAIL rd2 (nolock) 
			--	on r2.REFERRAL_ID = rd2.REFERRAL_ID
			--	INNER JOIN
			--	viewFacilitiesByVisn AS v2 
			--	ON r2.STD_INSTITUTION_ID = v2.institution_id
			--	where 
			--	(v2.VisnID = @VisnID) 
			--	AND
			--	rd2.STD_HEALTHFACTOR_ID = 54
		 --   )
	
		GROUP BY 
			v.VisnID
		
		IF @@ROWCOUNT = 0
			INSERT INTO @PatientSummary
							(VISN_ID,Groups,ParentGroup,Category,Summary1)
						VALUES     
							(
							@VisnID
							,'Comprehensive Evaluation - To be Scheduled or Pending Contact'
							,'Initial Positive Screens Tracked for Comprehensive Evaluation'
							,'Initial Positive Screens Tracked for Comprehensive Evaluation'
							,0
							)
		
		-- Comprehensive Evaluation not Completed

		Insert @PatientSummary (VISN_ID,Groups,ParentGroup,Category,Summary2)
	    
		select 
			v.VisnID , 
			'Comprehensive Evaluation - To be Scheduled or Pending Contact' as Groups,
			'Initial Positive Screens Tracked for Comprehensive Evaluation' as ParentGroup,
			' .. Comprehensive Evaluations not Completed' as Category,
			count(DISTINCT r.REFERRAL_ID) as Summar2 
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
			--INNER JOIN WKF_CASE wfc
			--ON r.REFERRAL_ID = wfc.REFERRAL_ID
			--INNER JOIN TBI_TRACKING tt (nolock)
			--on wfc.WKF_CASE_ID = tt.WKF_CASE_ID
			--join dbo.WKF_CASE_ACTIVITY wca (nolock)
			--on wfc.WKF_CASE_ID = wca.WKF_CASE_ID
		
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			AND 
			(r.STD_REFERRALSTS_ID <> 3)
			AND
			(rd.STD_HEALTHFACTOR_ID = 63)
		GROUP BY 
			v.VisnID

		IF @@ROWCOUNT = 0
			INSERT INTO @PatientSummary
							(VISN_ID,Groups,ParentGroup,Category,Summary2)
						VALUES     
							(
							@VisnID
							,'Comprehensive Evaluation - To be Scheduled or Pending Contact'
							,'Initial Positive Screens Tracked for Comprehensive Evaluation'
							,' .. Comprehensive Evaluations not Completed'
							,0
							)

		-------------------------------
		-- In Process Appointment Scheduled

		Insert @PatientSummary (VISN_ID,Groups,ParentGroup,Category,Summary3)
	    
		SELECT     
			v.VisnID, 
			'Comprehensive Evaluation - To be Scheduled or Pending Contact' AS Groups,
			' .. Comprehensive Evaluations not Completed' as ParentGroup, 
			' .... In Process Appointment Scheduled' AS Category, 
            COUNT(DISTINCT r.REFERRAL_ID) AS Summar3
		FROM         
			WKF_CASE_ACTIVITY AS wca WITH (nolock) 
			INNER JOIN
			WKF_CASE AS wc WITH (nolock) 
			ON wca.WKF_CASE_ID = wc.WKF_CASE_ID 
			INNER JOIN
			REFERRAL AS r WITH (nolock) 
			ON wc.REFERRAL_ID = r.REFERRAL_ID
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			INNER JOIN
			REFERRAL_DETAIL AS rd WITH (nolock) 
			ON r.REFERRAL_ID = rd.REFERRAL_ID 
			INNER JOIN
			viewFacilitiesByVisn AS v 
			ON r.STD_INSTITUTION_ID = v.institution_id 
			INNER JOIN
			TBI.TBI_TRACKING AS tt WITH (nolock) 
			ON wc.WKF_CASE_ID = tt.WKF_CASE_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(r.STD_REGISTRY_ID = 2) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(rd.STD_HEALTHFACTOR_ID = 63) 
			AND 
            (wca.TBI_EVALUATION_SCHEDULE_DATE IS NOT NULL) 
            AND 
            (ISNULL(wca.STD_TBIEVALDELAYTYPE_ID,0) NOT IN (1, 2)) 
            AND 
            (r.STD_REFERRALSTS_ID <> 3)
            AND (wca.ARCHIVED_FLAG = 0) --Added per bug tracker #1539
		GROUP BY 
			v.VisnID

		IF @@ROWCOUNT = 0
			INSERT INTO @PatientSummary
							(VISN_ID,Groups,ParentGroup,Category,Summary3)
						VALUES     
							(
							@VisnID
							,'Comprehensive Evaluation - To be Scheduled or Pending Contact'
							,' .. Comprehensive Evaluations not Completed'
							,' .... In Process Appointment Scheduled'
							,0
							)

		-------------------------------
		-- Unable to Complete Comprehensive Evaluation

		Insert @PatientSummary (VISN_ID,Groups,ParentGroup,Category,Summary3)
	    
		select 
			v.VisnID , 
			'Comprehensive Evaluation - To be Scheduled or Pending Contact' as Groups,
			' .. Comprehensive Evaluations not Completed' as ParentGroup,
			' .... Unable to Complete Comprehensive Evaluation' as Category,
			count(r.REFERRAL_ID) as Summary3  
		FROM         
			WKF_CASE_ACTIVITY AS wca WITH (nolock) 
			INNER JOIN
			WKF_CASE AS wc 
			ON wca.WKF_CASE_ID = wc.WKF_CASE_ID 
			INNER JOIN
			REFERRAL AS r WITH (nolock) 
			ON wc.REFERRAL_ID = r.REFERRAL_ID
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			INNER JOIN
			REFERRAL_DETAIL AS rd WITH (nolock) 
			ON r.REFERRAL_ID = rd.REFERRAL_ID 
			INNER JOIN
			viewFacilitiesByVisn AS v 
			ON r.STD_INSTITUTION_ID = v.institution_id 
			INNER JOIN
			TBI.TBI_TRACKING AS tt WITH (nolock) 
			ON wc.WKF_CASE_ID = tt.WKF_CASE_ID
			INNER JOIN
			(			SELECT     WKF_CASE.WKF_CASE_ID, WKF_CASE.REFERRAL_ID, 
						CASE WHEN ThreeNoShows.WKF_CASE_ID IS NULL THEN 0 ELSE 1 END as ThreeNoShows 
						FROM         (SELECT     WKF_CASE_ID
									   FROM          WKF_CASE_ACTIVITY AS wca2
									   WHERE      (STD_TBIEVALDELAYTYPE_ID IN (1, 2))
									   GROUP BY WKF_CASE_ID
									   HAVING      (COUNT(*) = 3)) AS ThreeNoShows 
						RIGHT OUTER JOIN
						WKF_CASE 
						ON ThreeNoShows.WKF_CASE_ID = WKF_CASE.WKF_CASE_ID) wcNoShow
			ON wc.WKF_CASE_ID = wcNoShow.WKF_CASE_ID
			
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(r.STD_REGISTRY_ID = 2) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(rd.STD_HEALTHFACTOR_ID = 63) 
			AND 
            (r.STD_REFERRALSTS_ID = 3) 
            AND
            (
            wca.STD_TBISCHEDULESTS_ID in (1,4,5)
            OR 
            wcNoShow.ThreeNoShows = 1
            )
            AND (wca.ARCHIVED_FLAG = 0) --Added per bug tracker #1539 
            
		GROUP BY 
			v.VisnID

		IF @@ROWCOUNT = 0
			INSERT INTO @PatientSummary
							(VISN_ID,Groups,ParentGroup,Category,Summary3)
						VALUES     
							(
							@VisnID
							,'Comprehensive Evaluation - To be Scheduled or Pending Contact'
							,' .. Comprehensive Evaluations not Completed'
							,' .... Unable to Complete Comprehensive Evaluation'
							,0
							)


	/*  LENGTH OF TIME TO COMPLETE COMPREHENSIVE EVALUATION FROM INITIAL POSITIVE SCREEN*/
	
		   	--Completed Comprehensive Evaluation with Completion Date
	   	Insert @PatientSummary (VISN_ID,Groups,ParentGroup,Category,Summary1)
	    
		select 
			v.VisnID , 
			'Length of Time to Complete Comprehensive Evaluation From Initial Positive Screen' as Groups,
			'Completed Comprehensive Evaluation with Completion Date' as ParentGroup,
			'Completed Comprehensive Evaluation with Completion Date' as Category,
			count(DISTINCT r.REFERRAL_ID) as Summary1 
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
			INNER JOIN WKF_CASE wfc
			ON r.REFERRAL_ID = wfc.REFERRAL_ID
			INNER JOIN TBI.TBI_TRACKING tt (nolock)
			on wfc.WKF_CASE_ID = tt.WKF_CASE_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			and 
			(tt.REFERRAL_COMPLETE_DATE is not null)
			and 
			(r.STD_REFERRALSTS_ID = 3)
		GROUP BY 
			v.VisnID

		IF @@ROWCOUNT = 0
			INSERT INTO @PatientSummary
							(VISN_ID,Groups,ParentGroup,Category,Summary1)
						VALUES     
							(
							@VisnID
							,'Length of Time to Complete Comprehensive Evaluation From Initial Positive Screen'
							,'Completed Comprehensive Evaluation with Completion Date'
							,'Completed Comprehensive Evaluation with Completion Date'
							,0
							)
	
	   	--Completed Comprehensive Evaluation within Completion Date
	   	Insert @PatientSummary (VISN_ID,Groups,ParentGroup,Category,Summary2)
	    
		select 
			v.VisnID , 
			'Length of Time to Complete Comprehensive Evaluation From Initial Positive Screen' as Groups,
			'.. Completed Comprehensive Evaluation within Thirty Days' as ParentGroup,
			'.. Completed Comprehensive Evaluation within Thirty Days' as Category,
			count(DISTINCT r.REFERRAL_ID) as Summary2 
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
			INNER JOIN WKF_CASE wfc
			ON r.REFERRAL_ID = wfc.REFERRAL_ID
			INNER JOIN TBI.TBI_TRACKING tt (nolock)
			on wfc.WKF_CASE_ID = tt.WKF_CASE_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			and 
			(tt.REFERRAL_COMPLETE_DATE is not null)
			and 
			(r.STD_REFERRALSTS_ID = 3)
			and 
			DATEDIFF(dd,r.REFERRAL_DATE,tt.REFERRAL_COMPLETE_DATE) <= 30 
		GROUP BY 
			v.VisnID
	
		IF @@ROWCOUNT = 0
			INSERT INTO @PatientSummary
							(VISN_ID,Groups,ParentGroup,Category,Summary2)
						VALUES     
							(
							@VisnID
							,'Length of Time to Complete Comprehensive Evaluation From Initial Positive Screen'
							,'.. Completed Comprehensive Evaluation within Thirty Days'
							,'.. Completed Comprehensive Evaluation within Thirty Days'
							,0
							)

	   	   	--Avg Number of Days from screening to Completion Date [Cummulative]
		Insert @PatientSummary (VISN_ID,Groups,ParentGroup,Category,Summary2)
	    
		select 
			v.VisnID , 
			'Length of Time to Complete Comprehensive Evaluation From Initial Positive Screen' as Groups,
			'.. Avg Number of Days from screen to Evaluation Completion (Cummulative)' as ParentGroup,
			'.. Avg Number of Days from screen to Evaluation Completion (Cummulative)' as Category, 
			avg(DATEDIFF(dd,r.REFERRAL_DATE,tt.REFERRAL_COMPLETE_DATE)) as summary2
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
			INNER JOIN WKF_CASE wfc
			ON r.REFERRAL_ID = wfc.REFERRAL_ID
			INNER JOIN TBI.TBI_TRACKING tt (nolock)
			on wfc.WKF_CASE_ID = tt.WKF_CASE_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			and 
			(tt.REFERRAL_COMPLETE_DATE is not null)
			and 
			(r.STD_REFERRALSTS_ID = 3)
		GROUP BY 
			v.VisnID


		IF @@ROWCOUNT = 0
			INSERT INTO @PatientSummary
							(VISN_ID,Groups,ParentGroup,Category,Summary2)
						VALUES     
							(
							@VisnID
							,'Length of Time to Complete Comprehensive Evaluation From Initial Positive Screen'
							,'.. Avg Number of Days from screen to Evaluation Completion (Cummulative)'
							,'.. Avg Number of Days from screen to Evaluation Completion (Cummulative)'
							,0
							)

	   	   	--Avg Number of Days from screening to Completion Date [Current past 3 Month]
		
		Insert @PatientSummary (VISN_ID,Groups,ParentGroup,Category, Footnote, Summary2)
	    
		select 
			v.VisnID , 
			'Length of Time to Complete Comprehensive Evaluation From Initial Positive Screen' as Groups,
			'.. Avg Number of Days from screen to Evaluation Completion (Current***)' as ParentGroup,
			'.. Avg Number of Days from screen to Evaluation Completion (Current***)' as Category,
			'***Reflects rolling 3 month average of most recent 3 month less first 30 days' as Footnote,
			avg(DATEDIFF(dd,r.REFERRAL_DATE,tt.REFERRAL_COMPLETE_DATE)) as summary2
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
			INNER JOIN WKF_CASE wfc
			ON r.REFERRAL_ID = wfc.REFERRAL_ID
			INNER JOIN TBI.TBI_TRACKING tt (nolock)
			on wfc.WKF_CASE_ID = tt.WKF_CASE_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			and 
			(tt.REFERRAL_COMPLETE_DATE is not null)
			and 
			(r.STD_REFERRALSTS_ID = 3)
			and 
			r.REFERRAL_DATE >=  CONVERT(varchar, DATEADD(mm, -3, getdate()),101) 
		
		GROUP BY 
			v.VisnID
			
		IF @@ROWCOUNT = 0
			INSERT INTO @PatientSummary
							(VISN_ID,Groups,ParentGroup,Category,Footnote, Summary2)
						VALUES     
							(
							@VisnID
							,'Length of Time to Complete Comprehensive Evaluation From Initial Positive Screen'
							,'.. Avg Number of Days from screen to Evaluation Completion (Current***)'
							,'.. Avg Number of Days from screen to Evaluation Completion (Current***)'
							,'***Reflects rolling 3 month average of most recent 3 month less first 30 days'
							,0
							)

		
	SELECT 
		p3.VISN_ID,
		p3.Groups,
		p3.ParentGroup,
		p3.Footnote,
		p3.Category,
		p3.Summary1,
		p3.Summary2,
		p3.Summary3,
		p3.Total
		,
		CurrentSum = 
			Case
				WHEN Summary1 IS NOT NULL
				THEN Summary1 
				WHEN Summary2 IS NOT NULL
				THEN Summary2 
				WHEN Summary3 IS NOT NULL
				THEN Summary3
				ELSE 0
			END 
				
		
		--,
		--Percentage = 
		--	CASE
		--		WHEN Summary3 IS NOT NULL
		--			THEN CONVERT(decimal(5,2),Summary3/Total)
		--		WHEN Summary2 IS NOT NULL
		--			THEN CONVERT(decimal(5,2),Summary2/Total)
		--		ELSE	
		--			0
		--	END
		--	,CONVERT(decimal(5,2),23/30) as test
		 
	FROM
	(Select 
		p1.VISN_ID,
		p1.Groups,
		p1.ParentGroup,
		p1.Footnote,
		p1.Category,
		p1.Summary1,
		p1.Summary2,
		p1.Summary3,
		Total =
			CASE 
				WHEN p1.Summary1 IS NOT NULL
					THEN NULL
				WHEN p1.Category = p1.ParentGroup
					THEN NULL
				WHEN (p1.Summary2 IS NOT NULL) --AND (p1.Category <> p1.ParentGroup)
					THEN 
						pParent.Summary1
				WHEN (p1.Summary3 IS NOT NULL) --AND (p1.Category <> p1.ParentGroup)
					THEN 
						pParent.Summary2
				ELSE	
					NULL	
			END		
		
		,
		pParent.Summary1 as ParentSummary1,
		pParent.Summary2 as ParentSummary2
        
    FROM @PatientSummary p1
     LEFT OUTER JOIN
			@PatientSummary AS pParent 
			ON p1.ParentGroup = pParent.Category
			AND
			   p1.Groups = pParent.Groups
	) p3
		
    
    --(SELECT ps2.Summary2 FROM @PatientSummary ps2 WHERE ps2.Category = p1.ParentGroup) as ParentSummary2,
		--(SELECT ps2.Summary1 FROM @PatientSummary ps2 WHERE ps2.Category = p1.ParentGroup) as ParentSummary1
		--Percentage = 
		--CASE 
		--	WHEN p1.Category = p1.ParentGroup 
		--		THEN ''
		--	WHEN (p1.Summary2 IS NOT NULL) AND (p1.Category <> p1.ParentGroup)
		--		THEN '1'
		--		--THEN SELECT p1.Summary2 FROM @PatientSummary ps2 WHERE ps2.Category = ps1.Category
		--END
        
End Try	
Begin catch
	Return
End Catch

END

	/* SET NOCOUNT ON */
	RETURN



GO

/****** Object:  StoredProcedure [dbo].[VisnSummaryReport_byVisnID]    Script Date: 01/16/2012 14:23:30 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



CREATE PROCEDURE [dbo].[VisnSummaryReport_byVisnID]
	(
	@visnId varchar(3)
	)
AS

BEGIN
    --select * from dbo.Report_VISN_Summary r
    
    set Nocount on
 
declare @startdate datetime = [dbo].[GetFiscalYearStartDate] (GETDATE())
declare @enddate datetime = [dbo].[GetTBIReportValidEndDate] (GETDATE())


Begin Try
    
--- Table Variable to Hold result sets
     
    Declare @PatientSummary table (
        VISN_ID varchar(10) null,
        Groups varchar(200) null,
        Footnote varchar(200) null,
        Category varchar(200) null,
        Summary1 int null,
        Summary2 int null,
        Summary3 int null,
        Percentage decimal(5,2));
        

	/*  INITIAL SCREENING INFORMATION */
	
		-- as 'Total Total OEF/OIF Veterans Screened for possible TBI'
	    Insert @PatientSummary (VISN_ID,Groups,Category,Summary1)
	    
		--select 
		--	v.VisnID , 
		--	'Initial Screening Information' as Groups,
		--	'Total OEF/OIF Veterans Screened for possible TBI' as Category,
		--	count(p.PATIENT_ID) as Summary1
			
		--from dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
		--on r.PATIENT_ID = p.PATIENT_ID
		--left join REFERRAL_DETAIL rd (nolock)
		--on r.REFERRAL_ID = rd.REFERRAL_ID
		--join dbo.FactAmbEnc f (nolock)
		--on f.PATIENT_ID = p.PATIENT_ID
		--join dbo.viewFacilitiesByVisn v
		--on r.STD_INSTITUTION_ID = v.institution_id

		--where p.OEF_OIF_IND = 1
		--and r.STD_REGISTRY_ID = 2
		--and v.VisnID = @VisnID
		--group by v.VisnID;
		
		SELECT     
			v.VisnID,
			'Initial Screening Information' AS Groups, 
			'Total OEF/OIF Veterans Screened for possible TBI' AS Category, 
			COUNT(DISTINCT p.PATIENT_ID) AS Summary1
			
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			--INNER JOIN
            --FactAmbEnc AS f WITH (nolock) 
            --ON f.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id

		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND (r.STD_REGISTRY_ID = 2) 
			AND (v.VisnID = @VisnID)
			
		GROUP BY 
			v.VisnID


		IF @@ROWCOUNT = 0
			INSERT INTO @PatientSummary
							(VISN_ID,Groups,Category,Summary1)
						VALUES     
							(
							@VisnID
							,'Initial Screening Information'
							,'Total OEF/OIF Veterans Screened for possible TBI'
							,0
							)

		-- 'Total OEF/OIF Veterans with self reported previous diagnosis of TBI'
		
	    Insert @PatientSummary (VISN_ID,Groups,Category,Summary2)
	    
		--select 
		--	v.VisnID , 
		--	'Initial Screening Information' as Groups,
		--	' .. OEF/OIF Veterans Screened with self reported previous diagnosis of TBI' as Category,
		--	count(p.PATIENT_ID) as Summar2
					
		--from dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
		--on r.PATIENT_ID = p.PATIENT_ID
		--left join REFERRAL_DETAIL rd (nolock)
		--on r.REFERRAL_ID = rd.REFERRAL_ID
		--join dbo.FactAmbEnc f (nolock)
		--on f.PATIENT_ID = p.PATIENT_ID
		--join dbo.viewFacilitiesByVisn v
		--on r.STD_INSTITUTION_ID = v.institution_id
		--where p.OEF_OIF_IND = 1
		--and r.STD_REGISTRY_ID = 2
		--and rd.STD_HEALTHFACTOR_ID = 51
		--and v.VisnID = @VisnID
		--group by v.VisnID;
		
		select 
		v.VisnID , 
		'Initial Screening Information' as Groups,
		' .. *Total number OEF/OIF Veterans with self reported previous diagnosis of TBI' as Category,
		count(DISTINCT p.PATIENT_ID) as Summar2
				
		from 
			dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
			on r.PATIENT_ID = p.PATIENT_ID
			join REFERRAL_DETAIL rd (nolock)
			on r.REFERRAL_ID = rd.REFERRAL_ID
			--join dbo.FactAmbEnc f (nolock)
			--on f.PATIENT_ID = p.PATIENT_ID
			join dbo.viewFacilitiesByVisn v
			on r.STD_INSTITUTION_ID = v.institution_id
		where 
			p.OEF_OIF_IND = 1
			and r.STD_REGISTRY_ID = 2
			and rd.STD_HEALTHFACTOR_ID = 51
			and v.VisnID = @VisnID
		group by 
			v.VisnID;
			
		
		IF @@ROWCOUNT = 0
			INSERT INTO @PatientSummary
							(VISN_ID,Groups,Category,Summary2)
						VALUES     
							(
							@VisnID
							,'Initial Screening Information'
							,' .. *Total number OEF/OIF Veterans with self reported previous diagnosis of TBI'
							,0
							)		

		--  'Total OEF/OIF Veterans with negative initial TBI Screen'
		Insert @PatientSummary (VISN_ID,Groups,Category,Summary2)
	    
		--select 
		--	v.VisnID , 
		--	'Initial Screening Information' as Groups,
		--	' .. Total OEF/OIF Veterans with negative initial TBI Screen' as Category,
		--	count(p.PATIENT_ID) as Summar2	 
		--from dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
		--on r.PATIENT_ID = p.PATIENT_ID
		--left join REFERRAL_DETAIL rd (nolock)
		--on r.REFERRAL_ID = rd.REFERRAL_ID
		--join dbo.FactAmbEnc f (nolock)
		--on f.PATIENT_ID = p.PATIENT_ID
		--join dbo.viewFacilitiesByVisn v
		--on r.STD_INSTITUTION_ID = v.institution_id

		--where p.OEF_OIF_IND = 1
		--and r.STD_REGISTRY_ID = 2
		--and rd.STD_HEALTHFACTOR_ID = 63
		--and v.VisnID = @VisnID
		--and rd.REFERRAL_ID is null
		--group by v.VisnID;

		SELECT     
			v.VisnID, 
			'Initial Screening Information' AS Groups, 
			' .. Total OEF/OIF Veterans with negative initial TBI Screen' AS Category, 
			COUNT(DISTINCT p.PATIENT_ID) AS Summar2
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			--INNER JOIN
			--FactAmbEnc AS f WITH (nolock) 
			--ON f.PATIENT_ID = p.PATIENT_ID 
			INNER JOIN
			viewFacilitiesByVisn AS v 
			ON r.STD_INSTITUTION_ID = v.institution_id 
		
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND (v.VisnID = @VisnID) 
			AND (r.STD_REGISTRY_ID = 2) 
			AND
			r.REFERRAL_ID NOT IN  
			(
				select r2.REFERRAL_ID from dbo.REFERRAL r2(nolock)join dbo.REFERRAL_DETAIL rd2 (nolock) 
				on r2.REFERRAL_ID = rd2.REFERRAL_ID
				INNER JOIN
				viewFacilitiesByVisn AS v2 
				ON r2.STD_INSTITUTION_ID = v2.institution_id
				where 
				(v2.VisnID = @VisnID) 
				AND
				rd2.STD_HEALTHFACTOR_ID = 63
		    )
		GROUP BY 
			v.VisnID

		
		IF @@ROWCOUNT = 0
			INSERT INTO @PatientSummary
							(VISN_ID,Groups,Category,Summary2)
						VALUES     
							(
							@VisnID
							,'Initial Screening Information'
							,' .. Total OEF/OIF Veterans with negative initial TBI Screen'
							,0
							)

		--  'Total OEF/OIF Veterans with Positive initial TBI Screen'
		Insert @PatientSummary (VISN_ID,Groups,Category,Summary2)
		
		--select 
		--	v.VisnID , 
		--	'Initial Screening Information' as Groups,
		--	' .. Total OEF/OIF Veterans with Positive initial TBI Screen' as Category,
		--	count(p.PATIENT_ID) as Summar2	 
		--from dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
		--on r.PATIENT_ID = p.PATIENT_ID
		--left join REFERRAL_DETAIL rd (nolock)
		--on r.REFERRAL_ID = rd.REFERRAL_ID
		--join dbo.FactAmbEnc f (nolock)
		--on f.PATIENT_ID = p.PATIENT_ID
		--join dbo.viewFacilitiesByVisn v
		--on r.STD_INSTITUTION_ID = v.institution_id

		--where p.OEF_OIF_IND = 1
		--and r.STD_REGISTRY_ID = 2
		--and rd.STD_HEALTHFACTOR_ID = 63
		--and v.VisnID = @VisnID
		--group by v.VisnID;
		
		SELECT     
			v.VisnID, 
			'Initial Screening Information' AS Groups, 
			' .. Total OEF/OIF Veterans with Positive initial TBI Screen' AS Category, 
			COUNT(DISTINCT p.PATIENT_ID) AS Summar2
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			--INNER JOIN
            --FactAmbEnc AS f WITH (nolock) 
            --ON f.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
            INNER JOIN dbo.REFERRAL_DETAIL rd (nolock) 
			ON r.REFERRAL_ID = rd.REFERRAL_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			AND
			(rd.STD_HEALTHFACTOR_ID = 63)
		    
		GROUP BY 
			v.VisnID


		IF @@ROWCOUNT = 0
			INSERT INTO @PatientSummary
							(VISN_ID,Groups,Category,Summary2)
						VALUES     
							(
							@VisnID
							,'Initial Screening Information'
							,' .. Total OEF/OIF Veterans with Positive initial TBI Screen'
							,0
							)

		-------------------------------
		-- Initial Positive Screen who declined a Comprehensive Evaluation
		Insert @PatientSummary (VISN_ID,Groups,Category,Summary3)
	    
		--select 
		--	v.VisnID , 
		--	'Initial Screening Information' as Groups,
		--	' .... Initial Positive Screen who declined a Comprehensive Evaluation' as Category,
		--	count(p.PATIENT_ID) as Summar3 
		--from dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
		--on r.PATIENT_ID = p.PATIENT_ID
		--left join REFERRAL_DETAIL rd (nolock)
		--on r.REFERRAL_ID = rd.REFERRAL_ID
		--join dbo.FactAmbEnc f (nolock)
		--on f.PATIENT_ID = p.PATIENT_ID
		--join dbo.viewFacilitiesByVisn v
		--on r.STD_INSTITUTION_ID = v.institution_id

		--where p.OEF_OIF_IND = 1
		--and r.STD_REGISTRY_ID = 2
		--and rd.STD_HEALTHFACTOR_ID = 63
		--and v.VisnID = @VisnID
		--and exists (select 1 from dbo.REFERRAL r2 (nolock) join dbo.REFERRAL_DETAIL rd2 (nolock)
		--			on r2.REFERRAL_ID = rd2.REFERRAL_ID and rd2.STD_HEALTHFACTOR_ID = 53 )
		--Group by v.VisnID;
		
		SELECT     
			v.VisnID, 
			'Initial Screening Information' AS Groups, 
			' .... Initial Positive Screens who declined a Comprehensive Evaluation' AS Category, 
			COUNT(DISTINCT p.PATIENT_ID) AS Summar3
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			--INNER JOIN
            --FactAmbEnc AS f WITH (nolock) 
            --ON f.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			AND
			(rd.STD_HEALTHFACTOR_ID = 53 )
			AND 
			r.REFERRAL_ID IN  
			(
				select r2.REFERRAL_ID from dbo.REFERRAL r2(nolock)join dbo.REFERRAL_DETAIL rd2 (nolock) 
				on r2.REFERRAL_ID = rd2.REFERRAL_ID
				INNER JOIN
				viewFacilitiesByVisn AS v2 
				ON r2.STD_INSTITUTION_ID = v2.institution_id
				where 
				(v2.VisnID = @VisnID) 
				AND
				rd2.STD_HEALTHFACTOR_ID = 63
		    )
	
		GROUP BY 
			v.VisnID
		
		IF @@ROWCOUNT = 0
			INSERT INTO @PatientSummary
							(VISN_ID,Groups,Category,Summary3)
						VALUES     
							(
							@VisnID
							,'Initial Screening Information'
							,' .... Initial Positive Screens who declined a Comprehensive Evaluation'
							,0
							)
							
							
		-------------------------------
		-- Initial Positive Screen tracked for Comprehensive Evaluation
		Insert @PatientSummary (VISN_ID,Groups,Category,Summary3)
	    
		--select 
		--	v.VisnID , 
		--	'Initial Screening Information' as Groups,
		--	' .... Initial Positive Screen tracked for Comprehensive Evaluation' as Category,
		--	count(p.PATIENT_ID) as Summar3
		--from dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
		--on r.PATIENT_ID = p.PATIENT_ID
		--left join REFERRAL_DETAIL rd (nolock)
		--on r.REFERRAL_ID = rd.REFERRAL_ID
		--join dbo.FactAmbEnc f (nolock)
		--on f.PATIENT_ID = p.PATIENT_ID
		--join dbo.viewFacilitiesByVisn v
		--on r.STD_INSTITUTION_ID = v.institution_id

		--where p.OEF_OIF_IND = 1
		--and r.STD_REGISTRY_ID = 2
		--and rd.STD_HEALTHFACTOR_ID = 63
		--and v.VisnID = @VisnID
		--and exists (select 1 from dbo.REFERRAL r2 (nolock) join dbo.REFERRAL_DETAIL rd2 (nolock)
		--			on r2.REFERRAL_ID = rd2.REFERRAL_ID and rd2.STD_HEALTHFACTOR_ID = 53 )
		--Group by v.VisnID;


		SELECT     
			v.VisnID , 
			'Initial Screening Information' as Groups,
			' .... Initial Positive Screens tracked for Comprehensive Evaluation' as Category,
			COUNT(DISTINCT p.PATIENT_ID) AS Summar3
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			--INNER JOIN
            --FactAmbEnc AS f WITH (nolock) 
            --ON f.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			AND
			(rd.STD_HEALTHFACTOR_ID = 63 )
			--AND 
			--r.REFERRAL_ID IN  
			--(
			--	select r2.REFERRAL_ID from dbo.REFERRAL r2(nolock)join dbo.REFERRAL_DETAIL rd2 (nolock) 
			--	on r2.REFERRAL_ID = rd2.REFERRAL_ID
			--	INNER JOIN
			--	viewFacilitiesByVisn AS v2 
			--	ON r2.STD_INSTITUTION_ID = v2.institution_id
			--	where 
			--	(v2.VisnID = @VisnID) 
			--	AND
			--	rd2.STD_HEALTHFACTOR_ID = 54
		 --   )
	
		GROUP BY 
			v.VisnID

		IF @@ROWCOUNT = 0
			INSERT INTO @PatientSummary
							(VISN_ID,Groups,Category,Summary3)
						VALUES     
							(
							@VisnID
							,'Initial Screening Information'
							,' .... Initial Positive Screens tracked for Comprehensive Evaluation'
							,0
							)

		-------------------------------
		-- Initial Positive Screen who did NOT decline Comprehensive Evaluation
		Insert @PatientSummary (VISN_ID,Groups, Footnote, Category,Summary3)
	    
		--select 
		--	v.VisnID , 
		--	'Initial Screening Information' as Groups,
		--	'*Not included in tracking TBI Screening tool and Comprehensive TBI Evaluation Process ' as Footnote,
		--	'Initial Positive Screen who did NOT decline Comprehensive Evaluation' as Category,
		--	count(p.PATIENT_ID) as Summar3
		--from dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
		--on r.PATIENT_ID = p.PATIENT_ID
		--left join REFERRAL_DETAIL rd (nolock)
		--on r.REFERRAL_ID = rd.REFERRAL_ID
		--join dbo.FactAmbEnc f (nolock)
		--on f.PATIENT_ID = p.PATIENT_ID
		--join dbo.viewFacilitiesByVisn v
		--on r.STD_INSTITUTION_ID = v.institution_id

		--where p.OEF_OIF_IND = 1
		--and r.STD_REGISTRY_ID = 2
		--and rd.STD_HEALTHFACTOR_ID = 63
		--and v.VisnID = @VisnID
		--and exists (select 1 from dbo.REFERRAL r2 (nolock) join dbo.REFERRAL_DETAIL rd2 (nolock)
		--			on r2.REFERRAL_ID = rd2.REFERRAL_ID and rd2.STD_HEALTHFACTOR_ID = 53 )

		--Group by v.VisnID;
		
		select 
			v.VisnID , 
			'Initial Screening Information' as Groups,
			'*Not included in tracking TBI Screening tool and Comprehensive TBI Evaluation Process ' as Footnote,
			'Initial Positive Screens who did NOT decline Comprehensive Evaluation' as Category,
			count(DISTINCT p.PATIENT_ID) as Summar3
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			--INNER JOIN
            --FactAmbEnc AS f WITH (nolock) 
            --ON f.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			AND
			(rd.STD_HEALTHFACTOR_ID = 63 )
			--AND 
			--r.REFERRAL_ID IN  
			--(
			--	select r2.REFERRAL_ID from dbo.REFERRAL r2(nolock)join dbo.REFERRAL_DETAIL rd2 (nolock) 
			--	on r2.REFERRAL_ID = rd2.REFERRAL_ID
			--	INNER JOIN
			--	viewFacilitiesByVisn AS v2 
			--	ON r2.STD_INSTITUTION_ID = v2.institution_id
			--	where 
			--	(v2.VisnID = @VisnID) 
			--	AND
			--	rd2.STD_HEALTHFACTOR_ID = 54
		 --   )
	
		GROUP BY 
			v.VisnID
					
		IF @@ROWCOUNT = 0
			INSERT INTO @PatientSummary
							(VISN_ID,Groups, Footnote, Category,Summary3)
						VALUES     
							(
							@VisnID
							,'Initial Screening Information'
							,'*Not included in tracking TBI Screening tool and Comprehensive TBI Evaluation Process '
							,'Initial Positive Screens who did NOT decline Comprehensive Evaluation'
							,0
							)

	 /* COMPREHENSIVE EVALUATION:- COMPLETED/PENDING FURTHER EVALUATION  */

		-------------------------------
		-- Initial Positive Screen tracked for Comprehensive Evaluation
		Insert @PatientSummary (VISN_ID,Groups,Category,Summary1)
	    
		--select 
		--	v.VisnID , 
		--	'Comprehensive Evaluation - Completed/Pending Futher Evaluation' as Groups,
		--	'Initial Positive Screen tracked for Comprehensive Evaluation' as Category,
		--	count(p.PATIENT_ID) as Summar1
		--from dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
		--on r.PATIENT_ID = p.PATIENT_ID
		--left join REFERRAL_DETAIL rd (nolock)
		--on r.REFERRAL_ID = rd.REFERRAL_ID
		--join dbo.FactAmbEnc f (nolock)
		--on f.PATIENT_ID = p.PATIENT_ID
		--join dbo.viewFacilitiesByVisn v
		--on r.STD_INSTITUTION_ID = v.institution_id

		--where p.OEF_OIF_IND = 1
		--and r.STD_REGISTRY_ID = 2
		--and rd.STD_HEALTHFACTOR_ID = 63
		--and v.VisnID = @VisnID
		--and exists (select 1 from dbo.REFERRAL r2 (nolock) join dbo.REFERRAL_DETAIL rd2 (nolock)
		--			on r2.REFERRAL_ID = rd2.REFERRAL_ID and rd2.STD_HEALTHFACTOR_ID = 53 )
		--Group by v.VisnID;
		
		select 
			v.VisnID , 
			'Comprehensive Evaluation - Completed/Pending Futher Evaluation' as Groups,
			'Initial Positive Screens tracked for Comprehensive Evaluation' as Category,
			count(DISTINCT p.PATIENT_ID) as Summar1
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			--INNER JOIN
            --FactAmbEnc AS f WITH (nolock) 
            --ON f.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			AND
			(rd.STD_HEALTHFACTOR_ID = 63 )
			--AND 
			--r.REFERRAL_ID IN  
			--(
			--	select r2.REFERRAL_ID from dbo.REFERRAL r2(nolock)join dbo.REFERRAL_DETAIL rd2 (nolock) 
			--	on r2.REFERRAL_ID = rd2.REFERRAL_ID
			--	INNER JOIN
			--	viewFacilitiesByVisn AS v2 
			--	ON r2.STD_INSTITUTION_ID = v2.institution_id
			--	where 
			--	(v2.VisnID = @VisnID) 
			--	AND
			--	rd2.STD_HEALTHFACTOR_ID = 54
		 --   )
	
		GROUP BY 
			v.VisnID
		
		IF @@ROWCOUNT = 0
			INSERT INTO @PatientSummary
							(VISN_ID,Groups,Category,Summary1)
						VALUES     
							(
							@VisnID
							,'Comprehensive Evaluation - Completed/Pending Futher Evaluation'
							,'Initial Positive Screens tracked for Comprehensive Evaluation'
							,0
							)
		
		-- Comprehensive Evaluation Completed
		Insert @PatientSummary (VISN_ID,Groups,Category,Summary2)
	    
		--select 
		--	v.VisnID , 
		--	'Comprehensive Evaluation - Completed/Pending Futher Evaluation' as Groups,
		--	' .. Comprehensive Evaluation Completed' as Category,
		--	count(p.PATIENT_ID) as Summar2 
		--from dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
		--on r.PATIENT_ID = p.PATIENT_ID
		--left join REFERRAL_DETAIL rd (nolock)
		--on r.REFERRAL_ID = rd.REFERRAL_ID
		--join dbo.FactAmbEnc f (nolock)
		--on f.PATIENT_ID = p.PATIENT_ID
		--join dbo.TBI_TRACKING tt (nolock)
		--on f.PATIENT_ID = tt.PATIENT_ID
		--join dbo.viewFacilitiesByVisn v
		--on r.STD_INSTITUTION_ID = v.institution_id

		--where p.OEF_OIF_IND = 1
		--and r.STD_REGISTRY_ID = 2
		--and v.VisnID = @VisnID
		--and tt.REFERRAL_COMPLETE_DATE is not null
		--and r.STD_REFERRALSTS_ID = 3
		--Group by v.VisnID;
		
		
		select 
			v.VisnID , 
			'Comprehensive Evaluation - Completed/Pending Futher Evaluation' as Groups,
			' .. Comprehensive Evaluations Completed' as Category,
			count(DISTINCT r.REFERRAL_ID) as Summar2 
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			--INNER JOIN
			--FactAmbEnc AS f WITH (nolock) 
            --ON f.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
			INNER JOIN WKF_CASE wfc
			ON r.REFERRAL_ID = wfc.REFERRAL_ID
			INNER JOIN TBI.TBI_TRACKING tt (nolock)
			on wfc.WKF_CASE_ID = tt.WKF_CASE_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			and 
			(tt.REFERRAL_COMPLETE_DATE is not null)
			and 
			(r.STD_REFERRALSTS_ID = 3)
		GROUP BY 
			v.VisnID

		IF @@ROWCOUNT = 0
			INSERT INTO @PatientSummary
							(VISN_ID,Groups,Category,Summary2)
						VALUES     
							(
							@VisnID
							,'Comprehensive Evaluation - Completed/Pending Futher Evaluation'
							,' .. Comprehensive Evaluations Completed'
							,0
							)


		-------------------------------
		-- Comfirmed TBI Diagnosis
		Insert @PatientSummary (VISN_ID,Groups,Category,Summary3)
	    
		--select 
		--	v.VisnID , 
		--	'Comprehensive Evaluation - Completed/Pending Futher Evaluation' as Groups,
		--	' .... Comfirmed TBI Diagnosis' as Category,
		--	count(p.PATIENT_ID) as Summar3 
		--from dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
		--on r.PATIENT_ID = p.PATIENT_ID
		--left join REFERRAL_DETAIL rd (nolock)
		--on r.REFERRAL_ID = rd.REFERRAL_ID
		--join dbo.FactAmbEnc f (nolock)
		--on f.PATIENT_ID = p.PATIENT_ID
		--join dbo.TBI_TRACKING tt (nolock)
		--on f.PATIENT_ID = tt.PATIENT_ID
		--join dbo.viewFacilitiesByVisn v
		--on r.STD_INSTITUTION_ID = v.institution_id

		--where p.OEF_OIF_IND = 1
		--and r.STD_REGISTRY_ID = 2
		--and tt.TBI_DIAGNOSIS_IND = 1
		--and v.VisnID = @VisnID
		--group by v.VisnID;
		
		select 
			v.VisnID , 
			'Comprehensive Evaluation - Completed/Pending Futher Evaluation' as Groups,
			' .... Comfirmed TBI Diagnosis' as Category,
			count(DISTINCT r.REFERRAL_ID) as Summar3 
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			--INNER JOIN
			--FactAmbEnc AS f WITH (nolock) 
            --ON f.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
			INNER JOIN WKF_CASE wfc
			ON r.REFERRAL_ID = wfc.REFERRAL_ID
			INNER JOIN TBI.TBI_TRACKING tt (nolock)
			on wfc.WKF_CASE_ID = tt.WKF_CASE_ID
		
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			and 
			(tt.TBI_DIAGNOSIS_IND = 1)
			and 
			(r.STD_REFERRALSTS_ID = 3)
		GROUP BY 
			v.VisnID

		IF @@ROWCOUNT = 0
			INSERT INTO @PatientSummary
							(VISN_ID,Groups,Category,Summary3)
						VALUES     
							(
							@VisnID
							,'Comprehensive Evaluation - Completed/Pending Futher Evaluation'
							,' .... Comfirmed TBI Diagnosis'
							,0
							)
							

		-------------------------------
		-- TBI Diagnosis Ruled Out
		Insert @PatientSummary (VISN_ID,Groups,Category,Summary3)
	    
		--select 
		--	v.VisnID , 
		--	'Comprehensive Evaluation - Completed/Pending Futher Evaluation' as Groups,
		--	' .... TBI Diagnosis Ruled Out' as Category,
		--	count(p.PATIENT_ID) as Summar3 
		--from dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
		--on r.PATIENT_ID = p.PATIENT_ID
		--left join REFERRAL_DETAIL rd (nolock)
		--on r.REFERRAL_ID = rd.REFERRAL_ID
		--join dbo.FactAmbEnc f (nolock)
		--on f.PATIENT_ID = p.PATIENT_ID
		--join dbo.TBI_TRACKING tt (nolock)
		--on f.PATIENT_ID = tt.PATIENT_ID
		--join dbo.viewFacilitiesByVisn v
		--on r.STD_INSTITUTION_ID = v.institution_id

		--where p.OEF_OIF_IND = 1
		--and r.STD_REGISTRY_ID = 2
		--and tt.TBI_DIAGNOSIS_IND = 2
		--and v.VisnID = @VisnID
		--group by v.VisnID;


		select 
			v.VisnID , 
			'Comprehensive Evaluation - Completed/Pending Futher Evaluation' as Groups,
			' .... TBI Diagnosis Ruled Out' as Category,
			count(DISTINCT r.REFERRAL_ID) as Summar3 
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			--INNER JOIN
			--FactAmbEnc AS f WITH (nolock) 
            --ON f.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
			INNER JOIN WKF_CASE wfc
			ON r.REFERRAL_ID = wfc.REFERRAL_ID
			INNER JOIN TBI.TBI_TRACKING tt (nolock)
			on wfc.WKF_CASE_ID = tt.WKF_CASE_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			and 
			(tt.TBI_DIAGNOSIS_IND = 2)
			and 
			(r.STD_REFERRALSTS_ID = 3)
		GROUP BY 
			v.VisnID


		IF @@ROWCOUNT = 0
			INSERT INTO @PatientSummary
							(VISN_ID,Groups,Category,Summary3)
						VALUES     
							(
							@VisnID
							,'Comprehensive Evaluation - Completed/Pending Futher Evaluation'
							,' .... TBI Diagnosis Ruled Out'
							,0
							)

			
		-------------------------------
		-- TBI Diagnosis Pending
		Insert @PatientSummary (VISN_ID,Groups,Category,Summary3)
	    
		--select 
		--	v.VisnID , 
		--	'Comprehensive Evaluation - Completed/Pending Futher Evaluation' as Groups,
		--	' .... TBI Diagnosis Uncertain Pending Further Evaluation' as Category,
		--	count(p.PATIENT_ID) as Summar3 
		--from dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
		--on r.PATIENT_ID = p.PATIENT_ID
		--left join REFERRAL_DETAIL rd (nolock)
		--on r.REFERRAL_ID = rd.REFERRAL_ID
		--join dbo.FactAmbEnc f (nolock)
		--on f.PATIENT_ID = p.PATIENT_ID
		--join dbo.TBI_TRACKING tt (nolock)
		--on f.PATIENT_ID = tt.PATIENT_ID
		--join dbo.viewFacilitiesByVisn v
		--on r.STD_INSTITUTION_ID = v.institution_id

		--where p.OEF_OIF_IND = 1
		--and r.STD_REGISTRY_ID = 2
		--and tt.TBI_DIAGNOSIS_IND = 0
		--and v.VisnID = @VisnID
		--group by v.VisnID;


		select 
			v.VisnID , 
			'Comprehensive Evaluation - Completed/Pending Futher Evaluation' as Groups,
			' .... TBI Diagnosis Uncertain Pending Further Evaluation' as Category,
			count(DISTINCT r.REFERRAL_ID) as Summar3 
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			--INNER JOIN
			--FactAmbEnc AS f WITH (nolock) 
            --ON f.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
			INNER JOIN WKF_CASE wfc
			ON r.REFERRAL_ID = wfc.REFERRAL_ID
			INNER JOIN TBI.TBI_TRACKING tt (nolock)
			on wfc.WKF_CASE_ID = tt.WKF_CASE_ID
		
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			and 
			(tt.TBI_DIAGNOSIS_IND = 0)
			and 
			(r.STD_REFERRALSTS_ID = 3)
		GROUP BY 
			v.VisnID

		IF @@ROWCOUNT = 0
			INSERT INTO @PatientSummary
							(VISN_ID,Groups,Category,Summary3)
						VALUES     
							(
							@VisnID
							,'Comprehensive Evaluation - Completed/Pending Futher Evaluation'
							,' .... TBI Diagnosis Uncertain Pending Further Evaluation'
							,0
							)
							


        /*  COMPREHENSIVE EVALUATION TO BE SCHEDULED OR PENDING CONTACT */

		-------------------------------
		-- Initial Positive Screen tracked for Comprehensive Evaluation
		Insert @PatientSummary (VISN_ID,Groups,Category,Summary1)
	    
		--select 
		--	v.VisnID , 
		--	'Comprehensive Evaluation - To be Scheduled or Pending Contact' as Groups,
		--	'Initial Positive Screen tracked for Comprehensive Evaluation' as Category,
		--	count(p.PATIENT_ID) as Summar1
		--from dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
		--on r.PATIENT_ID = p.PATIENT_ID
		--left join REFERRAL_DETAIL rd (nolock)
		--on r.REFERRAL_ID = rd.REFERRAL_ID
		--join dbo.FactAmbEnc f (nolock)
		--on f.PATIENT_ID = p.PATIENT_ID
		--join dbo.viewFacilitiesByVisn v
		--on r.STD_INSTITUTION_ID = v.institution_id

		--where p.OEF_OIF_IND = 1
		--and r.STD_REGISTRY_ID = 2
		--and rd.STD_HEALTHFACTOR_ID = 63
		--and v.VisnID = @VisnID
		--and exists (select 1 from dbo.REFERRAL r2 (nolock) join dbo.REFERRAL_DETAIL rd2 (nolock)
		--			on r2.REFERRAL_ID = rd2.REFERRAL_ID and rd2.STD_HEALTHFACTOR_ID = 53 )
		--Group by v.VisnID;
		
		select 
			v.VisnID , 
			'Comprehensive Evaluation - To be Scheduled or Pending Contact' as Groups,
			'Initial Positive Screens tracked for Comprehensive Evaluation' as Category,
			count(DISTINCT p.PATIENT_ID) as Summar1
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			--INNER JOIN
            --FactAmbEnc AS f WITH (nolock) 
            --ON f.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			AND
			(rd.STD_HEALTHFACTOR_ID = 63 )
			--AND 
			--r.REFERRAL_ID IN  
			--(
			--	select r2.REFERRAL_ID from dbo.REFERRAL r2(nolock)join dbo.REFERRAL_DETAIL rd2 (nolock) 
			--	on r2.REFERRAL_ID = rd2.REFERRAL_ID
			--	INNER JOIN
			--	viewFacilitiesByVisn AS v2 
			--	ON r2.STD_INSTITUTION_ID = v2.institution_id
			--	where 
			--	(v2.VisnID = @VisnID) 
			--	AND
			--	rd2.STD_HEALTHFACTOR_ID = 54
		 --   )
	
		GROUP BY 
			v.VisnID
		
		IF @@ROWCOUNT = 0
			INSERT INTO @PatientSummary
							(VISN_ID,Groups,Category,Summary1)
						VALUES     
							(
							@VisnID
							,'Comprehensive Evaluation - To be Scheduled or Pending Contact'
							,'Initial Positive Screens tracked for Comprehensive Evaluation'
							,0
							)
		
		-- Comprehensive Evaluation not Completed

		Insert @PatientSummary (VISN_ID,Groups,Category,Summary2)
	    
		select 
			v.VisnID , 
			'Comprehensive Evaluation - To be Scheduled or Pending Contact' as Groups,
			' .. Comprehensive Evaluations not Completed' as Category,
			count(DISTINCT r.REFERRAL_ID) as Summar2 
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			--INNER JOIN
			--FactAmbEnc AS f WITH (nolock) 
            --ON f.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
			--INNER JOIN WKF_CASE wfc
			--ON r.REFERRAL_ID = wfc.REFERRAL_ID
			--INNER JOIN TBI_TRACKING tt (nolock)
			--on wfc.WKF_CASE_ID = tt.WKF_CASE_ID
			--join dbo.WKF_CASE_ACTIVITY wca (nolock)
			--on wfc.WKF_CASE_ID = wca.WKF_CASE_ID
		
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			AND 
			(r.STD_REFERRALSTS_ID <> 3)
			AND
			(rd.STD_HEALTHFACTOR_ID = 63)
		GROUP BY 
			v.VisnID

		IF @@ROWCOUNT = 0
			INSERT INTO @PatientSummary
							(VISN_ID,Groups,Category,Summary2)
						VALUES     
							(
							@VisnID
							,'Comprehensive Evaluation - To be Scheduled or Pending Contact'
							,' .. Comprehensive Evaluations not Completed'
							,0
							)

		-------------------------------
		-- In Process Appointment Scheduled

		Insert @PatientSummary (VISN_ID,Groups,Category,Summary3)
	    
		--select 
		--	v.VisnID , 
		--	'Comprehensive Evaluation - To be Scheduled or Pending Contact' as Groups,
		--	' .... In Process Appointment Scheduled' as Category,
		--	count(DISTINCT r.REFERRAL_ID) as Summar3 
		--from dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
		--on r.PATIENT_ID = p.PATIENT_ID
		----join FactAmbEnc f (nolock) 
		----on f.PATIENT_ID = p.PATIENT_ID
		--join REFERRAL_DETAIL rd (nolock)
		--on r.REFERRAL_ID = rd.REFERRAL_ID
		--join dbo.TBI_TRACKING tt (nolock) 
		--on p.PATIENT_ID = tt.PATIENT_ID
		--join dbo.viewFacilitiesByVisn v
		--on r.STD_INSTITUTION_ID = v.institution_id
		--join dbo.WKF_CASE wc (nolock)
		--on p.PATIENT_ID = wc.PATIENT_ID
		--join dbo.WKF_CASE_ACTIVITY wca (nolock)
		--on wc.WKF_CASE_ID = wca.WKF_CASE_ID

		--where p.OEF_OIF_IND = 1
		--and r.STD_REGISTRY_ID = 2
		--and v.VisnID = @VisnID
		--and wca.STD_TBISCHEDULESTS_ID in (2,3)
		--group by v.VisnID;
		
		SELECT     
			v.VisnID, 
			'Comprehensive Evaluation - To be Scheduled or Pending Contact' AS Groups, 
			' .... In Process Appointment Scheduled' AS Category, 
            COUNT(DISTINCT r.REFERRAL_ID) AS Summar3
		FROM         
			WKF_CASE_ACTIVITY AS wca WITH (nolock) 
			INNER JOIN
			WKF_CASE AS wc WITH (nolock) 
			ON wca.WKF_CASE_ID = wc.WKF_CASE_ID 
			INNER JOIN
			REFERRAL AS r WITH (nolock) 
			ON wc.REFERRAL_ID = r.REFERRAL_ID
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			INNER JOIN
			REFERRAL_DETAIL AS rd WITH (nolock) 
			ON r.REFERRAL_ID = rd.REFERRAL_ID 
			INNER JOIN
			viewFacilitiesByVisn AS v 
			ON r.STD_INSTITUTION_ID = v.institution_id 
			INNER JOIN
			TBI.TBI_TRACKING AS tt WITH (nolock) 
			ON wc.WKF_CASE_ID = tt.WKF_CASE_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(r.STD_REGISTRY_ID = 2) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(rd.STD_HEALTHFACTOR_ID = 63) 
			AND 
            (wca.TBI_EVALUATION_SCHEDULE_DATE IS NOT NULL) 
            AND 
            (wca.STD_TBIEVALDELAYTYPE_ID NOT IN (1, 2)) 
            AND 
            (r.STD_REFERRALSTS_ID <> 3)
            AND (wca.ARCHIVED_FLAG = 0) --Added per bug tracker #1539 
		GROUP BY 
			v.VisnID

		IF @@ROWCOUNT = 0
			INSERT INTO @PatientSummary
							(VISN_ID,Groups,Category,Summary3)
						VALUES     
							(
							@VisnID
							,'Comprehensive Evaluation - To be Scheduled or Pending Contact'
							,' .... In Process Appointment Scheduled'
							,0
							)

		-------------------------------
		-- Unable to Complete Comprehensive Evaluation

		Insert @PatientSummary (VISN_ID,Groups,Category,Summary3)
	    
		--select 
		--	v.VisnID , 
		--	'Comprehensive Evaluation - To be Scheduled or Pending Contact' as Groups,
		--	' .... Unable to Complete Comprehensive Evaluation' as Category,
		--	count(p.PATIENT_ID) as Summary3  
		--from dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
		--on r.PATIENT_ID = p.PATIENT_ID
		--join FactAmbEnc f (nolock) 
		--on f.PATIENT_ID = p.PATIENT_ID
		--join REFERRAL_DETAIL rd (nolock)
		--on r.REFERRAL_ID = rd.REFERRAL_ID
		--join dbo.TBI_TRACKING tt (nolock) 
		--on p.PATIENT_ID = tt.PATIENT_ID
		--	join dbo.viewFacilitiesByVisn v
		--	on r.STD_INSTITUTION_ID = v.institution_id
		--	join dbo.WKF_CASE wc (nolock)
		--	on p.PATIENT_ID = wc.PATIENT_ID
		--	join dbo.WKF_CASE_ACTIVITY wca (nolock)
		--	on wc.WKF_CASE_ID = wca.WKF_CASE_ID

		--	where p.OEF_OIF_IND = 1
		--	and r.STD_REGISTRY_ID = 2
		--	and v.VisnID = @VisnID
		--	and wca.STD_TBISCHEDULESTS_ID in (4,5)
		--	group by v.VisnID;

		select 
			v.VisnID , 
			'Comprehensive Evaluation - To be Scheduled or Pending Contact' as Groups,
			' .... Unable to Complete Comprehensive Evaluation' as Category,
			count(p.PATIENT_ID) as Summary3  
		FROM         
			WKF_CASE_ACTIVITY AS wca WITH (nolock) 
			INNER JOIN
			WKF_CASE AS wc 
			ON wca.WKF_CASE_ID = wc.WKF_CASE_ID 
			INNER JOIN
			REFERRAL AS r WITH (nolock) 
			ON wc.REFERRAL_ID = r.REFERRAL_ID
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			INNER JOIN
			REFERRAL_DETAIL AS rd WITH (nolock) 
			ON r.REFERRAL_ID = rd.REFERRAL_ID 
			INNER JOIN
			viewFacilitiesByVisn AS v 
			ON r.STD_INSTITUTION_ID = v.institution_id 
			INNER JOIN
			TBI.TBI_TRACKING AS tt WITH (nolock) 
			ON wc.WKF_CASE_ID = tt.WKF_CASE_ID
			INNER JOIN
			(			SELECT     WKF_CASE.WKF_CASE_ID, WKF_CASE.REFERRAL_ID, 
						CASE WHEN ThreeNoShows.WKF_CASE_ID IS NULL THEN 0 ELSE 1 END as ThreeNoShows 
						FROM         (SELECT     WKF_CASE_ID
									   FROM          WKF_CASE_ACTIVITY AS wca2
									   WHERE      (STD_TBIEVALDELAYTYPE_ID IN (1, 2))
									   GROUP BY WKF_CASE_ID
									   HAVING      (COUNT(*) = 3)) AS ThreeNoShows 
						RIGHT OUTER JOIN
						WKF_CASE 
						ON ThreeNoShows.WKF_CASE_ID = WKF_CASE.WKF_CASE_ID) wcNoShow
			ON wc.WKF_CASE_ID = wcNoShow.WKF_CASE_ID
			
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(r.STD_REGISTRY_ID = 2) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(rd.STD_HEALTHFACTOR_ID = 63) 
			AND 
            (r.STD_REFERRALSTS_ID = 3) 
            AND
            (
            wca.STD_TBISCHEDULESTS_ID in (1,4,5)
            OR 
            wcNoShow.ThreeNoShows = 1
            ) 
            AND (wca.ARCHIVED_FLAG = 0) --Added per bug tracker #1539 
            
		GROUP BY 
			v.VisnID

		IF @@ROWCOUNT = 0
			INSERT INTO @PatientSummary
							(VISN_ID,Groups,Category,Summary3)
						VALUES     
							(
							@VisnID
							,'Comprehensive Evaluation - To be Scheduled or Pending Contact'
							,' .... Unable to Complete Comprehensive Evaluation'
							,0
							)


	/*  LENGTH OF TIME TO COMPLETE COMPREHENSIVE EVALUATION FROM INITIAL POSITIVE SCREEN*/
	
		   	--Completed Comprehensive Evaluation with Completion Date
	   	Insert @PatientSummary (VISN_ID,Groups,Category,Summary1)
	    
		--select 
		--	v.VisnID , 
		--	'Length of Time to Complete Comprehensive Evaluation From Initial Positive Screen' as Groups,
		--	'Completed Comprehensive Evaluation with Completion Date' as Category,
		--	count(p.PATIENT_ID) as Summary1  
		--from dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
		--on r.PATIENT_ID = p.PATIENT_ID
		--join FactAmbEnc f (nolock) 
		--on f.PATIENT_ID = p.PATIENT_ID
		--join REFERRAL_DETAIL rd (nolock)
		--on r.REFERRAL_ID = rd.REFERRAL_ID
		--join dbo.TBI_TRACKING tt (nolock) 
		--on p.PATIENT_ID = tt.PATIENT_ID
		--join dbo.viewFacilitiesByVisn v
		--on r.STD_INSTITUTION_ID = v.institution_id
		--join dbo.WKF_CASE wc (nolock)
		--on p.PATIENT_ID = wc.PATIENT_ID
		--join dbo.WKF_CASE_ACTIVITY wca (nolock)
		--on wc.WKF_CASE_ID = wca.WKF_CASE_ID

		--where p.OEF_OIF_IND = 1
		--and r.STD_REGISTRY_ID = 2
		--and v.VisnID = @VisnID
		--and tt.REFERRAL_COMPLETE_DATE is not null
		--group by v.VisnID;
	
		select 
			v.VisnID , 
			'Length of Time to Complete Comprehensive Evaluation From Initial Positive Screen' as Groups,
			'Completed Comprehensive Evaluation with Completion Date' as Category,
			count(DISTINCT r.REFERRAL_ID) as Summary1 
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			--INNER JOIN
			--FactAmbEnc AS f WITH (nolock) 
            --ON f.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
			INNER JOIN WKF_CASE wfc
			ON r.REFERRAL_ID = wfc.REFERRAL_ID
			INNER JOIN TBI.TBI_TRACKING tt (nolock)
			on wfc.WKF_CASE_ID = tt.WKF_CASE_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			and 
			(tt.REFERRAL_COMPLETE_DATE is not null)
			and 
			(r.STD_REFERRALSTS_ID = 3)
		GROUP BY 
			v.VisnID

		IF @@ROWCOUNT = 0
			INSERT INTO @PatientSummary
							(VISN_ID,Groups,Category,Summary1)
						VALUES     
							(
							@VisnID
							,'Length of Time to Complete Comprehensive Evaluation From Initial Positive Screen'
							,'Completed Comprehensive Evaluation with Completion Date'
							,0
							)
	
	   	--Completed Comprehensive Evaluation within Completion Date
	   	Insert @PatientSummary (VISN_ID,Groups,Category,Summary2)
	    
		--select 
		--	v.VisnID , 
		--	'Length of Time to Complete Comprehensive Evaluation From Initial Positive Screen' as Groups,
		--	'Completed Comprehensive Evaluation within Completion Date' as Category,
		--	count(p.PATIENT_ID) as Summary2  
		--from dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
		--on r.PATIENT_ID = p.PATIENT_ID
		--join FactAmbEnc f (nolock) 
		--on f.PATIENT_ID = p.PATIENT_ID
		--join REFERRAL_DETAIL rd (nolock)
		--on r.REFERRAL_ID = rd.REFERRAL_ID
		--join dbo.TBI_TRACKING tt (nolock) 
		--on p.PATIENT_ID = tt.PATIENT_ID
		--join dbo.viewFacilitiesByVisn v
		--on r.STD_INSTITUTION_ID = v.institution_id
		--join dbo.WKF_CASE wc (nolock)
		--on p.PATIENT_ID = wc.PATIENT_ID
		--join dbo.WKF_CASE_ACTIVITY wca (nolock)
		--on wc.WKF_CASE_ID = wca.WKF_CASE_ID

		--where p.OEF_OIF_IND = 1
		--and r.STD_REGISTRY_ID = 2
		--and v.VisnID = @VisnID
		--and tt.REFERRAL_COMPLETE_DATE is not null
		--and DATEDIFF(dd,tt.REFERRAL_COMPLETE_DATE,r.REFERRAL_DATE) <= 30 
		--group by v.VisnID;
	
		select 
			v.VisnID , 
			'Length of Time to Complete Comprehensive Evaluation From Initial Positive Screen' as Groups,
			'Completed Comprehensive Evaluation within Thirty Days' as Category,
			count(DISTINCT r.REFERRAL_ID) as Summary2 
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			--INNER JOIN
			--FactAmbEnc AS f WITH (nolock) 
            --ON f.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
			INNER JOIN WKF_CASE wfc
			ON r.REFERRAL_ID = wfc.REFERRAL_ID
			INNER JOIN TBI.TBI_TRACKING tt (nolock)
			on wfc.WKF_CASE_ID = tt.WKF_CASE_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			and 
			(tt.REFERRAL_COMPLETE_DATE is not null)
			and 
			(r.STD_REFERRALSTS_ID = 3)
			and 
			DATEDIFF(dd,tt.REFERRAL_COMPLETE_DATE,r.REFERRAL_DATE) <= 30 
		GROUP BY 
			v.VisnID
	
		IF @@ROWCOUNT = 0
			INSERT INTO @PatientSummary
							(VISN_ID,Groups,Category,Summary2)
						VALUES     
							(
							@VisnID
							,'Length of Time to Complete Comprehensive Evaluation From Initial Positive Screen'
							,'Completed Comprehensive Evaluation within Thirty Days'
							,0
							)

	   	   	--Avg Number of Days from screening to Completion Date [Cummulative]
		Insert @PatientSummary (VISN_ID,Groups,Category,Summary2)
	    
		--select 
		--	v.VisnID , 
		--	'Length of Time to Complete Comprehensive Evaluation From Initial Positive Screen' as Groups,
		--	'.. Avg Number of Days from screen to Evaluation Completion (Cummulative)' as Category, 
		--	avg(DATEDIFF(dd,tt.REFERRAL_COMPLETE_DATE,r.REFERRAL_DATE)) as summary2
		--from dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
		--on r.PATIENT_ID = p.PATIENT_ID
		--join FactAmbEnc f (nolock) 
		--on f.PATIENT_ID = p.PATIENT_ID
		--join REFERRAL_DETAIL rd (nolock)
		--on r.REFERRAL_ID = rd.REFERRAL_ID
		--join dbo.TBI_TRACKING tt (nolock) 
		--on p.PATIENT_ID = tt.PATIENT_ID
		--join dbo.viewFacilitiesByVisn v
		--on r.STD_INSTITUTION_ID = v.institution_id
		--join dbo.WKF_CASE wc (nolock)
		--on p.PATIENT_ID = wc.PATIENT_ID
		--join dbo.WKF_CASE_ACTIVITY wca (nolock)
		--on wc.WKF_CASE_ID = wca.WKF_CASE_ID

		--where p.OEF_OIF_IND = 1
		--and r.STD_REGISTRY_ID = 2
		--and v.VisnID = @VisnID
		--and tt.REFERRAL_COMPLETE_DATE is not null
		--and r.REFERRAL_DATE >= '9/1/2009'
		--group by v.VisnID;

		
		select 
			v.VisnID , 
			'Length of Time to Complete Comprehensive Evaluation From Initial Positive Screen' as Groups,
			'.. Avg Number of Days from screen to Evaluation Completion (Cummulative)' as Category, 
			avg(DATEDIFF(dd,tt.REFERRAL_COMPLETE_DATE,r.REFERRAL_DATE)) as summary2
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			--INNER JOIN
			--FactAmbEnc AS f WITH (nolock) 
            --ON f.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
			INNER JOIN WKF_CASE wfc
			ON r.REFERRAL_ID = wfc.REFERRAL_ID
			INNER JOIN TBI.TBI_TRACKING tt (nolock)
			on wfc.WKF_CASE_ID = tt.WKF_CASE_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			and 
			(tt.REFERRAL_COMPLETE_DATE is not null)
			and 
			(r.STD_REFERRALSTS_ID = 3)
		GROUP BY 
			v.VisnID


		IF @@ROWCOUNT = 0
			INSERT INTO @PatientSummary
							(VISN_ID,Groups,Category,Summary2)
						VALUES     
							(
							@VisnID
							,'Length of Time to Complete Comprehensive Evaluation From Initial Positive Screen'
							,'.. Avg Number of Days from screen to Evaluation Completion (Cummulative)'
							,0
							)

	   	   	--Avg Number of Days from screening to Completion Date [Current past 3 Month]
		
		Insert @PatientSummary (VISN_ID,Groups,Category, Footnote, Summary2)
	    
		--select 
		--	v.VisnID , 
		--	'Length of Time to Complete Comprehensive Evaluation From Initial Positive Screen' as Groups,
		--	'.. Avg Number of Days from screen to Evaluation Completion (Current)' as Category, 
		--	avg(DATEDIFF(dd,tt.REFERRAL_COMPLETE_DATE,r.REFERRAL_DATE)) as summary2
		--from dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
		--on r.PATIENT_ID = p.PATIENT_ID
		--join FactAmbEnc f (nolock) 
		--on f.PATIENT_ID = p.PATIENT_ID
		--join REFERRAL_DETAIL rd (nolock)
		--on r.REFERRAL_ID = rd.REFERRAL_ID
		--join dbo.TBI_TRACKING tt (nolock) 
		--on p.PATIENT_ID = tt.PATIENT_ID
		--join dbo.viewFacilitiesByVisn v
		--on r.STD_INSTITUTION_ID = v.institution_id
		--join dbo.WKF_CASE wc (nolock)
		--on p.PATIENT_ID = wc.PATIENT_ID
		--join dbo.WKF_CASE_ACTIVITY wca (nolock)
		--on wc.WKF_CASE_ID = wca.WKF_CASE_ID

		--where p.OEF_OIF_IND = 1
		--and r.STD_REGISTRY_ID = 2
		--and v.VisnID = @VisnID
		--and tt.REFERRAL_COMPLETE_DATE is not null
		--and r.REFERRAL_DATE >=  CONVERT(varchar, DATEADD(mm, -3, getdate()),101) 
		--group by v.VisnID;
		
		
		select 
			v.VisnID , 
			'Length of Time to Complete Comprehensive Evaluation From Initial Positive Screen' as Groups,
			'.. Avg Number of Days from screen to Evaluation Completion (Current)' as Category,
			'***Reflects rolling 3 month average of most recent 3 month less first 30 days' as Footnote,
			avg(DATEDIFF(dd,tt.REFERRAL_COMPLETE_DATE,r.REFERRAL_DATE)) as summary2
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			--INNER JOIN
			--FactAmbEnc AS f WITH (nolock) 
            --ON f.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
			INNER JOIN WKF_CASE wfc
			ON r.REFERRAL_ID = wfc.REFERRAL_ID
			INNER JOIN TBI.TBI_TRACKING tt (nolock)
			on wfc.WKF_CASE_ID = tt.WKF_CASE_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			and 
			(tt.REFERRAL_COMPLETE_DATE is not null)
			and 
			(r.STD_REFERRALSTS_ID = 3)
			and 
			r.REFERRAL_DATE >=  CONVERT(varchar, DATEADD(mm, -3, getdate()),101) 
		
		GROUP BY 
			v.VisnID
			
		IF @@ROWCOUNT = 0
			INSERT INTO @PatientSummary
							(VISN_ID,Groups,Category,Footnote, Summary2)
						VALUES     
							(
							@VisnID
							,'Length of Time to Complete Comprehensive Evaluation From Initial Positive Screen'
							,'.. Avg Number of Days from screen to Evaluation Completion (Current)'
							,'***Reflects rolling 3 month average of most recent 3 month less first 30 days'
							,0
							)

		
Select * from @PatientSummary


End Try	
Begin catch
	Return
End Catch

END

	/* SET NOCOUNT ON */
	RETURN



GO

/****** Object:  StoredProcedure [dbo].[VisnSummaryReport]    Script Date: 01/16/2012 14:23:30 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



CREATE PROCEDURE [dbo].[VisnSummaryReport]
	(
	@visnId varchar(3)
	)
AS

BEGIN
    --select * from dbo.Report_VISN_Summary r
    
    set Nocount on
 
declare @startdate datetime = [dbo].[GetFiscalYearStartDate] (GETDATE())
declare @enddate datetime = [dbo].[GetTBIReportValidEndDate] (GETDATE())


Begin Try
    
	



--- Table Variable to Hold result sets
     
    Declare @VISNSummary table (
        VISN_ID varchar(10) null,
        Groups varchar(200) null,
        Footnote varchar(200) null,
        Category varchar(200) null,
        Summary1 int null,
        Summary2 int null,
        Summary3 int null,
        Percentage decimal(5,2));
        

	/*  INITIAL SCREENING INFORMATION */
	
		-- as 'Total OEF/OIF Veterans Screened for possible TBI'
	    Insert @VISNSummary (VISN_ID,Groups,Category,Summary1)
	    
		--select 
		--	v.VisnID , 
		--	'Initial Screening Information' as Groups,
		--	'OEF/OIF Veterans Screened for possible TBI' as Category,
		--	count(p.PATIENT_ID) as Summary1
			
		--from dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
		--on r.PATIENT_ID = p.PATIENT_ID
		--left join REFERRAL_DETAIL rd (nolock)
		--on r.REFERRAL_ID = rd.REFERRAL_ID
		--join dbo.FactAmbEnc f (nolock)
		--on f.PATIENT_ID = p.PATIENT_ID
		--join dbo.viewFacilitiesByVisn v
		--on r.STD_INSTITUTION_ID = v.institution_id

		--where p.OEF_OIF_IND = 1
		--and r.STD_REGISTRY_ID = 2
		--and v.VisnID = @VisnID
		--group by v.VisnID;
		
		SELECT     
			v.VisnID,
			'Initial Screening Information' AS Groups, 
			'OEF/OIF Veterans Screened for possible TBI' AS Category, 
			COUNT(DISTINCT p.PATIENT_ID) AS Summary1
			
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			--INNER JOIN
            --FactAmbEnc AS f WITH (nolock) 
            --ON f.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id

		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND (r.STD_REGISTRY_ID = 2) 
			AND (v.VisnID = @VisnID)
			
		GROUP BY 
			v.VisnID


		IF @@ROWCOUNT = 0
			INSERT INTO @VISNSummary
							(VISN_ID,Groups,Category,Summary1)
						VALUES     
							(
							@VisnID
							,'Initial Screening Information'
							,'OEF/OIF Veterans Screened for possible TBI'
							,0
							)

		-- 'Total OEF/OIF Veterans with self reported previous diagnosis of TBI'
		
	    Insert @VISNSummary (VISN_ID,Groups,Category,Summary2)
	    
		--select 
		--	v.VisnID , 
		--	'Initial Screening Information' as Groups,
		--	' .. OEF/OIF Veterans Screened with self reported previous diagnosis of TBI' as Category,
		--	count(p.PATIENT_ID) as Summar2
					
		--from dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
		--on r.PATIENT_ID = p.PATIENT_ID
		--left join REFERRAL_DETAIL rd (nolock)
		--on r.REFERRAL_ID = rd.REFERRAL_ID
		--join dbo.FactAmbEnc f (nolock)
		--on f.PATIENT_ID = p.PATIENT_ID
		--join dbo.viewFacilitiesByVisn v
		--on r.STD_INSTITUTION_ID = v.institution_id
		--where p.OEF_OIF_IND = 1
		--and r.STD_REGISTRY_ID = 2
		--and rd.STD_HEALTHFACTOR_ID = 51
		--and v.VisnID = @VisnID
		--group by v.VisnID;
		
		select 
		v.VisnID , 
		'Initial Screening Information' as Groups,
		' .. *Total number OEF/OIF Veterans with self reported previous diagnosis of TBI' as Category,
		count(DISTINCT p.PATIENT_ID) as Summar2
				
		from 
			dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
			on r.PATIENT_ID = p.PATIENT_ID
			join REFERRAL_DETAIL rd (nolock)
			on r.REFERRAL_ID = rd.REFERRAL_ID
			--join dbo.FactAmbEnc f (nolock)
			--on f.PATIENT_ID = p.PATIENT_ID
			join dbo.viewFacilitiesByVisn v
			on r.STD_INSTITUTION_ID = v.institution_id
		where 
			p.OEF_OIF_IND = 1
			and r.STD_REGISTRY_ID = 2
			and rd.STD_HEALTHFACTOR_ID = 51
			and v.VisnID = @VisnID
		group by 
			v.VisnID;
			
		
		IF @@ROWCOUNT = 0
			INSERT INTO @VISNSummary
							(VISN_ID,Groups,Category,Summary2)
						VALUES     
							(
							@VisnID
							,'Initial Screening Information'
							,' .. *Total number OEF/OIF Veterans with self reported previous diagnosis of TBI'
							,0
							)		

		--  'Total OEF/OIF Veterans with negative initial TBI Screen'
		Insert @VISNSummary (VISN_ID,Groups,Category,Summary2)
	    
		--select 
		--	v.VisnID , 
		--	'Initial Screening Information' as Groups,
		--	' .. Total OEF/OIF Veterans with negative initial TBI Screen' as Category,
		--	count(p.PATIENT_ID) as Summar2	 
		--from dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
		--on r.PATIENT_ID = p.PATIENT_ID
		--left join REFERRAL_DETAIL rd (nolock)
		--on r.REFERRAL_ID = rd.REFERRAL_ID
		--join dbo.FactAmbEnc f (nolock)
		--on f.PATIENT_ID = p.PATIENT_ID
		--join dbo.viewFacilitiesByVisn v
		--on r.STD_INSTITUTION_ID = v.institution_id

		--where p.OEF_OIF_IND = 1
		--and r.STD_REGISTRY_ID = 2
		--and rd.STD_HEALTHFACTOR_ID = 63
		--and v.VisnID = @VisnID
		--and rd.REFERRAL_ID is null
		--group by v.VisnID;

		SELECT     
			v.VisnID, 
			'Initial Screening Information' AS Groups, 
			' .. Total OEF/OIF Veterans with negative initial TBI Screen' AS Category, 
			COUNT(DISTINCT p.PATIENT_ID) AS Summar2
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			--INNER JOIN
			--FactAmbEnc AS f WITH (nolock) 
			--ON f.PATIENT_ID = p.PATIENT_ID 
			INNER JOIN
			viewFacilitiesByVisn AS v 
			ON r.STD_INSTITUTION_ID = v.institution_id 
		
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND (v.VisnID = @VisnID) 
			AND (r.STD_REGISTRY_ID = 2) 
			AND
			r.REFERRAL_ID NOT IN  
			(
				select r2.REFERRAL_ID from dbo.REFERRAL r2(nolock)join dbo.REFERRAL_DETAIL rd2 (nolock) 
				on r2.REFERRAL_ID = rd2.REFERRAL_ID
				INNER JOIN
				viewFacilitiesByVisn AS v2 
				ON r2.STD_INSTITUTION_ID = v2.institution_id
				where 
				(v2.VisnID = @VisnID) 
				AND
				rd2.STD_HEALTHFACTOR_ID = 63
		    )
		GROUP BY 
			v.VisnID

		
		IF @@ROWCOUNT = 0
			INSERT INTO @VISNSummary
							(VISN_ID,Groups,Category,Summary2)
						VALUES     
							(
							@VisnID
							,'Initial Screening Information'
							,' .. Total OEF/OIF Veterans with negative initial TBI Screen'
							,0
							)

		--  'Total OEF/OIF Veterans with Positive initial TBI Screen'
		Insert @VISNSummary (VISN_ID,Groups,Category,Summary2)
		
		--select 
		--	v.VisnID , 
		--	'Initial Screening Information' as Groups,
		--	' .. Total OEF/OIF Veterans with Positive initial TBI Screen' as Category,
		--	count(p.PATIENT_ID) as Summar2	 
		--from dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
		--on r.PATIENT_ID = p.PATIENT_ID
		--left join REFERRAL_DETAIL rd (nolock)
		--on r.REFERRAL_ID = rd.REFERRAL_ID
		--join dbo.FactAmbEnc f (nolock)
		--on f.PATIENT_ID = p.PATIENT_ID
		--join dbo.viewFacilitiesByVisn v
		--on r.STD_INSTITUTION_ID = v.institution_id

		--where p.OEF_OIF_IND = 1
		--and r.STD_REGISTRY_ID = 2
		--and rd.STD_HEALTHFACTOR_ID = 63
		--and v.VisnID = @VisnID
		--group by v.VisnID;
		
		SELECT     
			v.VisnID, 
			'Initial Screening Information' AS Groups, 
			' .. Total OEF/OIF Veterans with Positive initial TBI Screen' AS Category, 
			COUNT(DISTINCT p.PATIENT_ID) AS Summar2
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			--INNER JOIN
            --FactAmbEnc AS f WITH (nolock) 
            --ON f.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
            INNER JOIN dbo.REFERRAL_DETAIL rd (nolock) 
			ON r.REFERRAL_ID = rd.REFERRAL_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			AND
			(rd.STD_HEALTHFACTOR_ID = 63)
		    
		GROUP BY 
			v.VisnID


		IF @@ROWCOUNT = 0
			INSERT INTO @VISNSummary
							(VISN_ID,Groups,Category,Summary2)
						VALUES     
							(
							@VisnID
							,'Initial Screening Information'
							,' .. Total OEF/OIF Veterans with Positive initial TBI Screen'
							,0
							)

		-------------------------------
		-- Initial Positive Screen who declined a Comprehensive Evaluation
		Insert @VISNSummary (VISN_ID,Groups,Category,Summary3)
	    
		--select 
		--	v.VisnID , 
		--	'Initial Screening Information' as Groups,
		--	' .... Initial Positive Screen who declined a Comprehensive Evaluation' as Category,
		--	count(p.PATIENT_ID) as Summar3 
		--from dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
		--on r.PATIENT_ID = p.PATIENT_ID
		--left join REFERRAL_DETAIL rd (nolock)
		--on r.REFERRAL_ID = rd.REFERRAL_ID
		--join dbo.FactAmbEnc f (nolock)
		--on f.PATIENT_ID = p.PATIENT_ID
		--join dbo.viewFacilitiesByVisn v
		--on r.STD_INSTITUTION_ID = v.institution_id

		--where p.OEF_OIF_IND = 1
		--and r.STD_REGISTRY_ID = 2
		--and rd.STD_HEALTHFACTOR_ID = 63
		--and v.VisnID = @VisnID
		--and exists (select 1 from dbo.REFERRAL r2 (nolock) join dbo.REFERRAL_DETAIL rd2 (nolock)
		--			on r2.REFERRAL_ID = rd2.REFERRAL_ID and rd2.STD_HEALTHFACTOR_ID = 53 )
		--Group by v.VisnID;
		
		SELECT     
			v.VisnID, 
			'Initial Screening Information' AS Groups, 
			' .... Initial Positive Screens who declined a Comprehensive Evaluation' AS Category, 
			COUNT(DISTINCT p.PATIENT_ID) AS Summar3
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			--INNER JOIN
            --FactAmbEnc AS f WITH (nolock) 
            --ON f.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			AND
			(rd.STD_HEALTHFACTOR_ID = 53 )
			AND 
			r.REFERRAL_ID IN  
			(
				select r2.REFERRAL_ID from dbo.REFERRAL r2(nolock)join dbo.REFERRAL_DETAIL rd2 (nolock) 
				on r2.REFERRAL_ID = rd2.REFERRAL_ID
				INNER JOIN
				viewFacilitiesByVisn AS v2 
				ON r2.STD_INSTITUTION_ID = v2.institution_id
				where 
				(v2.VisnID = @VisnID) 
				AND
				rd2.STD_HEALTHFACTOR_ID = 63
		    )
	
		GROUP BY 
			v.VisnID
		
		IF @@ROWCOUNT = 0
			INSERT INTO @VISNSummary
							(VISN_ID,Groups,Category,Summary3)
						VALUES     
							(
							@VisnID
							,'Initial Screening Information'
							,' .... Initial Positive Screens who declined a Comprehensive Evaluation'
							,0
							)
							
							
		-------------------------------
		-- Initial Positive Screen tracked for Comprehensive Evaluation
		Insert @VISNSummary (VISN_ID,Groups,Category,Summary3)
	    
		--select 
		--	v.VisnID , 
		--	'Initial Screening Information' as Groups,
		--	' .... Initial Positive Screen tracked for Comprehensive Evaluation' as Category,
		--	count(p.PATIENT_ID) as Summar3
		--from dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
		--on r.PATIENT_ID = p.PATIENT_ID
		--left join REFERRAL_DETAIL rd (nolock)
		--on r.REFERRAL_ID = rd.REFERRAL_ID
		--join dbo.FactAmbEnc f (nolock)
		--on f.PATIENT_ID = p.PATIENT_ID
		--join dbo.viewFacilitiesByVisn v
		--on r.STD_INSTITUTION_ID = v.institution_id

		--where p.OEF_OIF_IND = 1
		--and r.STD_REGISTRY_ID = 2
		--and rd.STD_HEALTHFACTOR_ID = 63
		--and v.VisnID = @VisnID
		--and exists (select 1 from dbo.REFERRAL r2 (nolock) join dbo.REFERRAL_DETAIL rd2 (nolock)
		--			on r2.REFERRAL_ID = rd2.REFERRAL_ID and rd2.STD_HEALTHFACTOR_ID = 53 )
		--Group by v.VisnID;


		SELECT     
			v.VisnID , 
			'Initial Screening Information' as Groups,
			' .... Initial Positive Screens tracked for Comprehensive Evaluation' as Category,
			COUNT(DISTINCT p.PATIENT_ID) AS Summar3
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			--INNER JOIN
            --FactAmbEnc AS f WITH (nolock) 
            --ON f.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			AND
			(rd.STD_HEALTHFACTOR_ID = 63 )
			--AND 
			--r.REFERRAL_ID IN  
			--(
			--	select r2.REFERRAL_ID from dbo.REFERRAL r2(nolock)join dbo.REFERRAL_DETAIL rd2 (nolock) 
			--	on r2.REFERRAL_ID = rd2.REFERRAL_ID
			--	INNER JOIN
			--	viewFacilitiesByVisn AS v2 
			--	ON r2.STD_INSTITUTION_ID = v2.institution_id
			--	where 
			--	(v2.VisnID = @VisnID) 
			--	AND
			--	rd2.STD_HEALTHFACTOR_ID = 54
		 --   )
	
		GROUP BY 
			v.VisnID

		IF @@ROWCOUNT = 0
			INSERT INTO @VISNSummary
							(VISN_ID,Groups,Category,Summary3)
						VALUES     
							(
							@VisnID
							,'Initial Screening Information'
							,' .... Initial Positive Screens tracked for Comprehensive Evaluation'
							,0
							)

		-------------------------------
		-- Initial Positive Screen who did NOT decline Comprehensive Evaluation
		Insert @VISNSummary (VISN_ID,Groups, Footnote, Category,Summary3)
	    
		--select 
		--	v.VisnID , 
		--	'Initial Screening Information' as Groups,
		--	'*Not included in tracking TBI Screening tool and Comprehensive TBI Evaluation Process ' as Footnote,
		--	'Initial Positive Screen who did NOT decline Comprehensive Evaluation' as Category,
		--	count(p.PATIENT_ID) as Summar3
		--from dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
		--on r.PATIENT_ID = p.PATIENT_ID
		--left join REFERRAL_DETAIL rd (nolock)
		--on r.REFERRAL_ID = rd.REFERRAL_ID
		--join dbo.FactAmbEnc f (nolock)
		--on f.PATIENT_ID = p.PATIENT_ID
		--join dbo.viewFacilitiesByVisn v
		--on r.STD_INSTITUTION_ID = v.institution_id

		--where p.OEF_OIF_IND = 1
		--and r.STD_REGISTRY_ID = 2
		--and rd.STD_HEALTHFACTOR_ID = 63
		--and v.VisnID = @VisnID
		--and exists (select 1 from dbo.REFERRAL r2 (nolock) join dbo.REFERRAL_DETAIL rd2 (nolock)
		--			on r2.REFERRAL_ID = rd2.REFERRAL_ID and rd2.STD_HEALTHFACTOR_ID = 53 )

		--Group by v.VisnID;
		
		select 
			v.VisnID , 
			'Initial Screening Information' as Groups,
			'*Not included in tracking TBI Screening tool and Comprehensive TBI Evaluation Process ' as Footnote,
			'Initial Positive Screens who did NOT decline Comprehensive Evaluation' as Category,
			count(DISTINCT p.PATIENT_ID) as Summar3
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			--INNER JOIN
            --FactAmbEnc AS f WITH (nolock) 
            --ON f.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			AND
			(rd.STD_HEALTHFACTOR_ID = 63 )
			--AND 
			--r.REFERRAL_ID IN  
			--(
			--	select r2.REFERRAL_ID from dbo.REFERRAL r2(nolock)join dbo.REFERRAL_DETAIL rd2 (nolock) 
			--	on r2.REFERRAL_ID = rd2.REFERRAL_ID
			--	INNER JOIN
			--	viewFacilitiesByVisn AS v2 
			--	ON r2.STD_INSTITUTION_ID = v2.institution_id
			--	where 
			--	(v2.VisnID = @VisnID) 
			--	AND
			--	rd2.STD_HEALTHFACTOR_ID = 54
		 --   )
	
		GROUP BY 
			v.VisnID
					
		IF @@ROWCOUNT = 0
			INSERT INTO @VISNSummary
							(VISN_ID,Groups, Footnote, Category,Summary3)
						VALUES     
							(
							@VisnID
							,'Initial Screening Information'
							,'*Not included in tracking TBI Screening tool and Comprehensive TBI Evaluation Process '
							,'Initial Positive Screens who did NOT decline Comprehensive Evaluation'
							,0
							)

	 /* COMPREHENSIVE EVALUATION:- COMPLETED/PENDING FURTHER EVALUATION  */

		-------------------------------
		-- Initial Positive Screen tracked for Comprehensive Evaluation
		Insert @VISNSummary (VISN_ID,Groups,Category,Summary1)
	    
		--select 
		--	v.VisnID , 
		--	'Comprehensive Evaluation - Completed/Pending Futher Evaluation' as Groups,
		--	'Initial Positive Screen tracked for Comprehensive Evaluation' as Category,
		--	count(p.PATIENT_ID) as Summar1
		--from dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
		--on r.PATIENT_ID = p.PATIENT_ID
		--left join REFERRAL_DETAIL rd (nolock)
		--on r.REFERRAL_ID = rd.REFERRAL_ID
		--join dbo.FactAmbEnc f (nolock)
		--on f.PATIENT_ID = p.PATIENT_ID
		--join dbo.viewFacilitiesByVisn v
		--on r.STD_INSTITUTION_ID = v.institution_id

		--where p.OEF_OIF_IND = 1
		--and r.STD_REGISTRY_ID = 2
		--and rd.STD_HEALTHFACTOR_ID = 63
		--and v.VisnID = @VisnID
		--and exists (select 1 from dbo.REFERRAL r2 (nolock) join dbo.REFERRAL_DETAIL rd2 (nolock)
		--			on r2.REFERRAL_ID = rd2.REFERRAL_ID and rd2.STD_HEALTHFACTOR_ID = 53 )
		--Group by v.VisnID;
		
		select 
			v.VisnID , 
			'Comprehensive Evaluation - Completed/Pending Futher Evaluation' as Groups,
			'Initial Positive Screens tracked for Comprehensive Evaluation' as Category,
			count(DISTINCT p.PATIENT_ID) as Summar1
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			--INNER JOIN
            --FactAmbEnc AS f WITH (nolock) 
            --ON f.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			AND
			(rd.STD_HEALTHFACTOR_ID = 63 )
			--AND 
			--r.REFERRAL_ID IN  
			--(
			--	select r2.REFERRAL_ID from dbo.REFERRAL r2(nolock)join dbo.REFERRAL_DETAIL rd2 (nolock) 
			--	on r2.REFERRAL_ID = rd2.REFERRAL_ID
			--	INNER JOIN
			--	viewFacilitiesByVisn AS v2 
			--	ON r2.STD_INSTITUTION_ID = v2.institution_id
			--	where 
			--	(v2.VisnID = @VisnID) 
			--	AND
			--	rd2.STD_HEALTHFACTOR_ID = 54
		 --   )
	
		GROUP BY 
			v.VisnID
		
		IF @@ROWCOUNT = 0
			INSERT INTO @VISNSummary
							(VISN_ID,Groups,Category,Summary1)
						VALUES     
							(
							@VisnID
							,'Comprehensive Evaluation - Completed/Pending Futher Evaluation'
							,'Initial Positive Screens tracked for Comprehensive Evaluation'
							,0
							)
		
		-- Comprehensive Evaluation Completed
		Insert @VISNSummary (VISN_ID,Groups,Category,Summary2)
	    
		--select 
		--	v.VisnID , 
		--	'Comprehensive Evaluation - Completed/Pending Futher Evaluation' as Groups,
		--	' .. Comprehensive Evaluation Completed' as Category,
		--	count(p.PATIENT_ID) as Summar2 
		--from dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
		--on r.PATIENT_ID = p.PATIENT_ID
		--left join REFERRAL_DETAIL rd (nolock)
		--on r.REFERRAL_ID = rd.REFERRAL_ID
		--join dbo.FactAmbEnc f (nolock)
		--on f.PATIENT_ID = p.PATIENT_ID
		--join dbo.TBI_TRACKING tt (nolock)
		--on f.PATIENT_ID = tt.PATIENT_ID
		--join dbo.viewFacilitiesByVisn v
		--on r.STD_INSTITUTION_ID = v.institution_id

		--where p.OEF_OIF_IND = 1
		--and r.STD_REGISTRY_ID = 2
		--and v.VisnID = @VisnID
		--and tt.REFERRAL_COMPLETE_DATE is not null
		--and r.STD_REFERRALSTS_ID = 3
		--Group by v.VisnID;
		
		
		select 
			v.VisnID , 
			'Comprehensive Evaluation - Completed/Pending Futher Evaluation' as Groups,
			' .. Comprehensive Evaluations Completed' as Category,
			count(DISTINCT r.REFERRAL_ID) as Summar2 
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			--INNER JOIN
			--FactAmbEnc AS f WITH (nolock) 
            --ON f.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
			INNER JOIN WKF_CASE wfc
			ON r.REFERRAL_ID = wfc.REFERRAL_ID
			INNER JOIN TBI.TBI_TRACKING tt (nolock)
			on wfc.WKF_CASE_ID = tt.WKF_CASE_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			and 
			(tt.REFERRAL_COMPLETE_DATE is not null)
			and 
			(r.STD_REFERRALSTS_ID = 3)
		GROUP BY 
			v.VisnID

		IF @@ROWCOUNT = 0
			INSERT INTO @VISNSummary
							(VISN_ID,Groups,Category,Summary2)
						VALUES     
							(
							@VisnID
							,'Comprehensive Evaluation - Completed/Pending Futher Evaluation'
							,' .. Comprehensive Evaluations Completed'
							,0
							)


		-------------------------------
		-- Comfirmed TBI Diagnosis
		Insert @VISNSummary (VISN_ID,Groups,Category,Summary3)
	    
		--select 
		--	v.VisnID , 
		--	'Comprehensive Evaluation - Completed/Pending Futher Evaluation' as Groups,
		--	' .... Comfirmed TBI Diagnosis' as Category,
		--	count(p.PATIENT_ID) as Summar3 
		--from dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
		--on r.PATIENT_ID = p.PATIENT_ID
		--left join REFERRAL_DETAIL rd (nolock)
		--on r.REFERRAL_ID = rd.REFERRAL_ID
		--join dbo.FactAmbEnc f (nolock)
		--on f.PATIENT_ID = p.PATIENT_ID
		--join dbo.TBI_TRACKING tt (nolock)
		--on f.PATIENT_ID = tt.PATIENT_ID
		--join dbo.viewFacilitiesByVisn v
		--on r.STD_INSTITUTION_ID = v.institution_id

		--where p.OEF_OIF_IND = 1
		--and r.STD_REGISTRY_ID = 2
		--and tt.TBI_DIAGNOSIS_IND = 1
		--and v.VisnID = @VisnID
		--group by v.VisnID;
		
		select 
			v.VisnID , 
			'Comprehensive Evaluation - Completed/Pending Futher Evaluation' as Groups,
			' .... Comfirmed TBI Diagnosis' as Category,
			count(DISTINCT r.REFERRAL_ID) as Summar3 
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			--INNER JOIN
			--FactAmbEnc AS f WITH (nolock) 
            --ON f.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
			INNER JOIN WKF_CASE wfc
			ON r.REFERRAL_ID = wfc.REFERRAL_ID
			INNER JOIN TBI.TBI_TRACKING tt (nolock)
			on wfc.WKF_CASE_ID = tt.WKF_CASE_ID
		
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			and 
			(tt.TBI_DIAGNOSIS_IND = 1)
			and 
			(r.STD_REFERRALSTS_ID = 3)
		GROUP BY 
			v.VisnID

		IF @@ROWCOUNT = 0
			INSERT INTO @VISNSummary
							(VISN_ID,Groups,Category,Summary3)
						VALUES     
							(
							@VisnID
							,'Comprehensive Evaluation - Completed/Pending Futher Evaluation'
							,' .... Comfirmed TBI Diagnosis'
							,0
							)
							

		-------------------------------
		-- TBI Diagnosis Ruled Out
		Insert @VISNSummary (VISN_ID,Groups,Category,Summary3)
	    
		--select 
		--	v.VisnID , 
		--	'Comprehensive Evaluation - Completed/Pending Futher Evaluation' as Groups,
		--	' .... TBI Diagnosis Ruled Out' as Category,
		--	count(p.PATIENT_ID) as Summar3 
		--from dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
		--on r.PATIENT_ID = p.PATIENT_ID
		--left join REFERRAL_DETAIL rd (nolock)
		--on r.REFERRAL_ID = rd.REFERRAL_ID
		--join dbo.FactAmbEnc f (nolock)
		--on f.PATIENT_ID = p.PATIENT_ID
		--join dbo.TBI_TRACKING tt (nolock)
		--on f.PATIENT_ID = tt.PATIENT_ID
		--join dbo.viewFacilitiesByVisn v
		--on r.STD_INSTITUTION_ID = v.institution_id

		--where p.OEF_OIF_IND = 1
		--and r.STD_REGISTRY_ID = 2
		--and tt.TBI_DIAGNOSIS_IND = 2
		--and v.VisnID = @VisnID
		--group by v.VisnID;


		select 
			v.VisnID , 
			'Comprehensive Evaluation - Completed/Pending Futher Evaluation' as Groups,
			' .... TBI Diagnosis Ruled Out' as Category,
			count(DISTINCT r.REFERRAL_ID) as Summar3 
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			--INNER JOIN
			--FactAmbEnc AS f WITH (nolock) 
            --ON f.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
			INNER JOIN WKF_CASE wfc
			ON r.REFERRAL_ID = wfc.REFERRAL_ID
			INNER JOIN TBI.TBI_TRACKING tt (nolock)
			on wfc.WKF_CASE_ID = tt.WKF_CASE_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			and 
			(tt.TBI_DIAGNOSIS_IND = 2)
			and 
			(r.STD_REFERRALSTS_ID = 3)
		GROUP BY 
			v.VisnID


		IF @@ROWCOUNT = 0
			INSERT INTO @VISNSummary
							(VISN_ID,Groups,Category,Summary3)
						VALUES     
							(
							@VisnID
							,'Comprehensive Evaluation - Completed/Pending Futher Evaluation'
							,' .... TBI Diagnosis Ruled Out'
							,0
							)

			
		-------------------------------
		-- TBI Diagnosis Pending
		Insert @VISNSummary (VISN_ID,Groups,Category,Summary3)
	    
		--select 
		--	v.VisnID , 
		--	'Comprehensive Evaluation - Completed/Pending Futher Evaluation' as Groups,
		--	' .... TBI Diagnosis Uncertain Pending Further Evaluation' as Category,
		--	count(p.PATIENT_ID) as Summar3 
		--from dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
		--on r.PATIENT_ID = p.PATIENT_ID
		--left join REFERRAL_DETAIL rd (nolock)
		--on r.REFERRAL_ID = rd.REFERRAL_ID
		--join dbo.FactAmbEnc f (nolock)
		--on f.PATIENT_ID = p.PATIENT_ID
		--join dbo.TBI_TRACKING tt (nolock)
		--on f.PATIENT_ID = tt.PATIENT_ID
		--join dbo.viewFacilitiesByVisn v
		--on r.STD_INSTITUTION_ID = v.institution_id

		--where p.OEF_OIF_IND = 1
		--and r.STD_REGISTRY_ID = 2
		--and tt.TBI_DIAGNOSIS_IND = 0
		--and v.VisnID = @VisnID
		--group by v.VisnID;


		select 
			v.VisnID , 
			'Comprehensive Evaluation - Completed/Pending Futher Evaluation' as Groups,
			' .... TBI Diagnosis Uncertain Pending Further Evaluation' as Category,
			count(DISTINCT r.REFERRAL_ID) as Summar3 
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			--INNER JOIN
			--FactAmbEnc AS f WITH (nolock) 
            --ON f.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
			INNER JOIN WKF_CASE wfc
			ON r.REFERRAL_ID = wfc.REFERRAL_ID
			INNER JOIN TBI.TBI_TRACKING tt (nolock)
			on wfc.WKF_CASE_ID = tt.WKF_CASE_ID
		
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			and 
			(tt.TBI_DIAGNOSIS_IND = 0)
			and 
			(r.STD_REFERRALSTS_ID = 3)
		GROUP BY 
			v.VisnID

		IF @@ROWCOUNT = 0
			INSERT INTO @VISNSummary
							(VISN_ID,Groups,Category,Summary3)
						VALUES     
							(
							@VisnID
							,'Comprehensive Evaluation - Completed/Pending Futher Evaluation'
							,' .... TBI Diagnosis Uncertain Pending Further Evaluation'
							,0
							)
							


        /*  COMPREHENSIVE EVALUATION TO BE SCHEDULED OR PENDING CONTACT */

		-------------------------------
		-- Initial Positive Screen tracked for Comprehensive Evaluation
		Insert @VISNSummary (VISN_ID,Groups,Category,Summary1)
	    
		--select 
		--	v.VisnID , 
		--	'Comprehensive Evaluation - To be Scheduled or Pending Contact' as Groups,
		--	'Initial Positive Screen tracked for Comprehensive Evaluation' as Category,
		--	count(p.PATIENT_ID) as Summar1
		--from dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
		--on r.PATIENT_ID = p.PATIENT_ID
		--left join REFERRAL_DETAIL rd (nolock)
		--on r.REFERRAL_ID = rd.REFERRAL_ID
		--join dbo.FactAmbEnc f (nolock)
		--on f.PATIENT_ID = p.PATIENT_ID
		--join dbo.viewFacilitiesByVisn v
		--on r.STD_INSTITUTION_ID = v.institution_id

		--where p.OEF_OIF_IND = 1
		--and r.STD_REGISTRY_ID = 2
		--and rd.STD_HEALTHFACTOR_ID = 63
		--and v.VisnID = @VisnID
		--and exists (select 1 from dbo.REFERRAL r2 (nolock) join dbo.REFERRAL_DETAIL rd2 (nolock)
		--			on r2.REFERRAL_ID = rd2.REFERRAL_ID and rd2.STD_HEALTHFACTOR_ID = 53 )
		--Group by v.VisnID;
		
		select 
			v.VisnID , 
			'Comprehensive Evaluation - To be Scheduled or Pending Contact' as Groups,
			'Initial Positive Screens tracked for Comprehensive Evaluation' as Category,
			count(DISTINCT p.PATIENT_ID) as Summar1
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			--INNER JOIN
            --FactAmbEnc AS f WITH (nolock) 
            --ON f.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			AND
			(rd.STD_HEALTHFACTOR_ID = 63 )
			--AND 
			--r.REFERRAL_ID IN  
			--(
			--	select r2.REFERRAL_ID from dbo.REFERRAL r2(nolock)join dbo.REFERRAL_DETAIL rd2 (nolock) 
			--	on r2.REFERRAL_ID = rd2.REFERRAL_ID
			--	INNER JOIN
			--	viewFacilitiesByVisn AS v2 
			--	ON r2.STD_INSTITUTION_ID = v2.institution_id
			--	where 
			--	(v2.VisnID = @VisnID) 
			--	AND
			--	rd2.STD_HEALTHFACTOR_ID = 54
		 --   )
	
		GROUP BY 
			v.VisnID
		
		IF @@ROWCOUNT = 0
			INSERT INTO @VISNSummary
							(VISN_ID,Groups,Category,Summary1)
						VALUES     
							(
							@VisnID
							,'Comprehensive Evaluation - To be Scheduled or Pending Contact'
							,'Initial Positive Screens tracked for Comprehensive Evaluation'
							,0
							)
		
		-- Comprehensive Evaluation not Completed

		Insert @VISNSummary (VISN_ID,Groups,Category,Summary2)
	    
		select 
			v.VisnID , 
			'Comprehensive Evaluation - To be Scheduled or Pending Contact' as Groups,
			' .. Comprehensive Evaluations not Completed' as Category,
			count(DISTINCT r.REFERRAL_ID) as Summar2 
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			--INNER JOIN
			--FactAmbEnc AS f WITH (nolock) 
            --ON f.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
			--INNER JOIN WKF_CASE wfc
			--ON r.REFERRAL_ID = wfc.REFERRAL_ID
			--INNER JOIN TBI_TRACKING tt (nolock)
			--on wfc.WKF_CASE_ID = tt.WKF_CASE_ID
			--join dbo.WKF_CASE_ACTIVITY wca (nolock)
			--on wfc.WKF_CASE_ID = wca.WKF_CASE_ID
		
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			AND 
			(r.STD_REFERRALSTS_ID <> 3)
			AND
			(rd.STD_HEALTHFACTOR_ID = 63)
		GROUP BY 
			v.VisnID

		IF @@ROWCOUNT = 0
			INSERT INTO @VISNSummary
							(VISN_ID,Groups,Category,Summary2)
						VALUES     
							(
							@VisnID
							,'Comprehensive Evaluation - To be Scheduled or Pending Contact'
							,' .. Comprehensive Evaluations not Completed'
							,0
							)

		-------------------------------
		-- In Process Appointment Scheduled

		Insert @VISNSummary (VISN_ID,Groups,Category,Summary3)
	    
		--select 
		--	v.VisnID , 
		--	'Comprehensive Evaluation - To be Scheduled or Pending Contact' as Groups,
		--	' .... In Process Appointment Scheduled' as Category,
		--	count(DISTINCT r.REFERRAL_ID) as Summar3 
		--from dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
		--on r.PATIENT_ID = p.PATIENT_ID
		----join FactAmbEnc f (nolock) 
		----on f.PATIENT_ID = p.PATIENT_ID
		--join REFERRAL_DETAIL rd (nolock)
		--on r.REFERRAL_ID = rd.REFERRAL_ID
		--join dbo.TBI_TRACKING tt (nolock) 
		--on p.PATIENT_ID = tt.PATIENT_ID
		--join dbo.viewFacilitiesByVisn v
		--on r.STD_INSTITUTION_ID = v.institution_id
		--join dbo.WKF_CASE wc (nolock)
		--on p.PATIENT_ID = wc.PATIENT_ID
		--join dbo.WKF_CASE_ACTIVITY wca (nolock)
		--on wc.WKF_CASE_ID = wca.WKF_CASE_ID

		--where p.OEF_OIF_IND = 1
		--and r.STD_REGISTRY_ID = 2
		--and v.VisnID = @VisnID
		--and wca.STD_TBISCHEDULESTS_ID in (2,3)
		--group by v.VisnID;
		
		SELECT     
			v.VisnID, 
			'Comprehensive Evaluation - To be Scheduled or Pending Contact' AS Groups, 
			' .... In Process Appointment Scheduled' AS Category, 
            COUNT(DISTINCT r.REFERRAL_ID) AS Summar3
		FROM         
			WKF_CASE_ACTIVITY AS wca WITH (nolock) 
			INNER JOIN
			WKF_CASE AS wc WITH (nolock) 
			ON wca.WKF_CASE_ID = wc.WKF_CASE_ID 
			INNER JOIN
			REFERRAL AS r WITH (nolock) 
			ON wc.REFERRAL_ID = r.REFERRAL_ID
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			INNER JOIN
			REFERRAL_DETAIL AS rd WITH (nolock) 
			ON r.REFERRAL_ID = rd.REFERRAL_ID 
			INNER JOIN
			viewFacilitiesByVisn AS v 
			ON r.STD_INSTITUTION_ID = v.institution_id 
			INNER JOIN
			TBI.TBI_TRACKING AS tt WITH (nolock) 
			ON wc.WKF_CASE_ID = tt.WKF_CASE_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(r.STD_REGISTRY_ID = 2) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(rd.STD_HEALTHFACTOR_ID = 63) 
			AND 
            (wca.TBI_EVALUATION_SCHEDULE_DATE IS NOT NULL) 
            AND 
            (wca.STD_TBIEVALDELAYTYPE_ID NOT IN (1, 2)) 
            AND 
            (r.STD_REFERRALSTS_ID <> 3)
            AND (wca.ARCHIVED_FLAG = 0) --Added per bug tracker #1539
		GROUP BY 
			v.VisnID

		IF @@ROWCOUNT = 0
			INSERT INTO @VISNSummary
							(VISN_ID,Groups,Category,Summary3)
						VALUES     
							(
							@VisnID
							,'Comprehensive Evaluation - To be Scheduled or Pending Contact'
							,' .... In Process Appointment Scheduled'
							,0
							)

		-------------------------------
		-- Unable to Complete Comprehensive Evaluation

		Insert @VISNSummary (VISN_ID,Groups,Category,Summary3)
	    
		--select 
		--	v.VisnID , 
		--	'Comprehensive Evaluation - To be Scheduled or Pending Contact' as Groups,
		--	' .... Unable to Complete Comprehensive Evaluation' as Category,
		--	count(p.PATIENT_ID) as Summary3  
		--from dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
		--on r.PATIENT_ID = p.PATIENT_ID
		--join FactAmbEnc f (nolock) 
		--on f.PATIENT_ID = p.PATIENT_ID
		--join REFERRAL_DETAIL rd (nolock)
		--on r.REFERRAL_ID = rd.REFERRAL_ID
		--join dbo.TBI_TRACKING tt (nolock) 
		--on p.PATIENT_ID = tt.PATIENT_ID
		--	join dbo.viewFacilitiesByVisn v
		--	on r.STD_INSTITUTION_ID = v.institution_id
		--	join dbo.WKF_CASE wc (nolock)
		--	on p.PATIENT_ID = wc.PATIENT_ID
		--	join dbo.WKF_CASE_ACTIVITY wca (nolock)
		--	on wc.WKF_CASE_ID = wca.WKF_CASE_ID

		--	where p.OEF_OIF_IND = 1
		--	and r.STD_REGISTRY_ID = 2
		--	and v.VisnID = @VisnID
		--	and wca.STD_TBISCHEDULESTS_ID in (4,5)
		--	group by v.VisnID;

		select 
			v.VisnID , 
			'Comprehensive Evaluation - To be Scheduled or Pending Contact' as Groups,
			' .... Unable to Complete Comprehensive Evaluation' as Category,
			count(p.PATIENT_ID) as Summary3  
		FROM         
			WKF_CASE_ACTIVITY AS wca WITH (nolock) 
			INNER JOIN
			WKF_CASE AS wc 
			ON wca.WKF_CASE_ID = wc.WKF_CASE_ID 
			INNER JOIN
			REFERRAL AS r WITH (nolock) 
			ON wc.REFERRAL_ID = r.REFERRAL_ID
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			INNER JOIN
			REFERRAL_DETAIL AS rd WITH (nolock) 
			ON r.REFERRAL_ID = rd.REFERRAL_ID 
			INNER JOIN
			viewFacilitiesByVisn AS v 
			ON r.STD_INSTITUTION_ID = v.institution_id 
			INNER JOIN
			TBI.TBI_TRACKING AS tt WITH (nolock) 
			ON wc.WKF_CASE_ID = tt.WKF_CASE_ID
			INNER JOIN
			(			SELECT     WKF_CASE.WKF_CASE_ID, WKF_CASE.REFERRAL_ID, 
						CASE WHEN ThreeNoShows.WKF_CASE_ID IS NULL THEN 0 ELSE 1 END as ThreeNoShows 
						FROM         (SELECT     WKF_CASE_ID
									   FROM          WKF_CASE_ACTIVITY AS wca2
									   WHERE      (STD_TBIEVALDELAYTYPE_ID IN (1, 2))
									   GROUP BY WKF_CASE_ID
									   HAVING      (COUNT(*) = 3)) AS ThreeNoShows 
						RIGHT OUTER JOIN
						WKF_CASE 
						ON ThreeNoShows.WKF_CASE_ID = WKF_CASE.WKF_CASE_ID) wcNoShow
			ON wc.WKF_CASE_ID = wcNoShow.WKF_CASE_ID
			
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(r.STD_REGISTRY_ID = 2) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(rd.STD_HEALTHFACTOR_ID = 63) 
			AND 
            (r.STD_REFERRALSTS_ID = 3) 
            AND
            (
            wca.STD_TBISCHEDULESTS_ID in (1,4,5)
            OR 
            wcNoShow.ThreeNoShows = 1
            )
            AND (wca.ARCHIVED_FLAG = 0) --Added per bug tracker #1539 
            
		GROUP BY 
			v.VisnID

		IF @@ROWCOUNT = 0
			INSERT INTO @VISNSummary
							(VISN_ID,Groups,Category,Summary3)
						VALUES     
							(
							@VisnID
							,'Comprehensive Evaluation - To be Scheduled or Pending Contact'
							,' .... Unable to Complete Comprehensive Evaluation'
							,0
							)


	/*  LENGTH OF TIME TO COMPLETE COMPREHENSIVE EVALUATION FROM INITIAL POSITIVE SCREEN*/
	
		   	--Completed Comprehensive Evaluation with Completion Date
	   	Insert @VISNSummary (VISN_ID,Groups,Category,Summary1)
	    
		--select 
		--	v.VisnID , 
		--	'Length of Time to Complete Comprehensive Evaluation From Initial Positive Screen' as Groups,
		--	'Completed Comprehensive Evaluation with Completion Date' as Category,
		--	count(p.PATIENT_ID) as Summary1  
		--from dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
		--on r.PATIENT_ID = p.PATIENT_ID
		--join FactAmbEnc f (nolock) 
		--on f.PATIENT_ID = p.PATIENT_ID
		--join REFERRAL_DETAIL rd (nolock)
		--on r.REFERRAL_ID = rd.REFERRAL_ID
		--join dbo.TBI_TRACKING tt (nolock) 
		--on p.PATIENT_ID = tt.PATIENT_ID
		--join dbo.viewFacilitiesByVisn v
		--on r.STD_INSTITUTION_ID = v.institution_id
		--join dbo.WKF_CASE wc (nolock)
		--on p.PATIENT_ID = wc.PATIENT_ID
		--join dbo.WKF_CASE_ACTIVITY wca (nolock)
		--on wc.WKF_CASE_ID = wca.WKF_CASE_ID

		--where p.OEF_OIF_IND = 1
		--and r.STD_REGISTRY_ID = 2
		--and v.VisnID = @VisnID
		--and tt.REFERRAL_COMPLETE_DATE is not null
		--group by v.VisnID;
	
		select 
			v.VisnID , 
			'Length of Time to Complete Comprehensive Evaluation From Initial Positive Screen' as Groups,
			'Completed Comprehensive Evaluation with Completion Date' as Category,
			count(DISTINCT r.REFERRAL_ID) as Summary1 
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			--INNER JOIN
			--FactAmbEnc AS f WITH (nolock) 
            --ON f.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
			INNER JOIN WKF_CASE wfc
			ON r.REFERRAL_ID = wfc.REFERRAL_ID
			INNER JOIN TBI.TBI_TRACKING tt (nolock)
			on wfc.WKF_CASE_ID = tt.WKF_CASE_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			and 
			(tt.REFERRAL_COMPLETE_DATE is not null)
			and 
			(r.STD_REFERRALSTS_ID = 3)
		GROUP BY 
			v.VisnID

		IF @@ROWCOUNT = 0
			INSERT INTO @VISNSummary
							(VISN_ID,Groups,Category,Summary1)
						VALUES     
							(
							@VisnID
							,'Length of Time to Complete Comprehensive Evaluation From Initial Positive Screen'
							,'Completed Comprehensive Evaluation with Completion Date'
							,0
							)
	
	   	--Completed Comprehensive Evaluation within Completion Date
	   	Insert @VISNSummary (VISN_ID,Groups,Category,Summary2)
	    
		--select 
		--	v.VisnID , 
		--	'Length of Time to Complete Comprehensive Evaluation From Initial Positive Screen' as Groups,
		--	'Completed Comprehensive Evaluation within Completion Date' as Category,
		--	count(p.PATIENT_ID) as Summary2  
		--from dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
		--on r.PATIENT_ID = p.PATIENT_ID
		--join FactAmbEnc f (nolock) 
		--on f.PATIENT_ID = p.PATIENT_ID
		--join REFERRAL_DETAIL rd (nolock)
		--on r.REFERRAL_ID = rd.REFERRAL_ID
		--join dbo.TBI_TRACKING tt (nolock) 
		--on p.PATIENT_ID = tt.PATIENT_ID
		--join dbo.viewFacilitiesByVisn v
		--on r.STD_INSTITUTION_ID = v.institution_id
		--join dbo.WKF_CASE wc (nolock)
		--on p.PATIENT_ID = wc.PATIENT_ID
		--join dbo.WKF_CASE_ACTIVITY wca (nolock)
		--on wc.WKF_CASE_ID = wca.WKF_CASE_ID

		--where p.OEF_OIF_IND = 1
		--and r.STD_REGISTRY_ID = 2
		--and v.VisnID = @VisnID
		--and tt.REFERRAL_COMPLETE_DATE is not null
		--and DATEDIFF(dd,tt.REFERRAL_COMPLETE_DATE,r.REFERRAL_DATE) <= 30 
		--group by v.VisnID;
	
		select 
			v.VisnID , 
			'Length of Time to Complete Comprehensive Evaluation From Initial Positive Screen' as Groups,
			'Completed Comprehensive Evaluation within Thirty Days' as Category,
			count(DISTINCT r.REFERRAL_ID) as Summary2 
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			--INNER JOIN
			--FactAmbEnc AS f WITH (nolock) 
            --ON f.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
			INNER JOIN WKF_CASE wfc
			ON r.REFERRAL_ID = wfc.REFERRAL_ID
			INNER JOIN TBI.TBI_TRACKING tt (nolock)
			on wfc.WKF_CASE_ID = tt.WKF_CASE_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			and 
			(tt.REFERRAL_COMPLETE_DATE is not null)
			and 
			(r.STD_REFERRALSTS_ID = 3)
			and 
			DATEDIFF(dd,tt.REFERRAL_COMPLETE_DATE,r.REFERRAL_DATE) <= 30 
		GROUP BY 
			v.VisnID
	
		IF @@ROWCOUNT = 0
			INSERT INTO @VISNSummary
							(VISN_ID,Groups,Category,Summary2)
						VALUES     
							(
							@VisnID
							,'Length of Time to Complete Comprehensive Evaluation From Initial Positive Screen'
							,'Completed Comprehensive Evaluation within Thirty Days'
							,0
							)

	   	   	--Avg Number of Day from screening to Completion Date [Cummulative]
		Insert @VISNSummary (VISN_ID,Groups,Category,Summary2)
	    
		--select 
		--	v.VisnID , 
		--	'Length of Time to Complete Comprehensive Evaluation From Initial Positive Screen' as Groups,
		--	'.. Avg Number of Day from screen to Evaluation Completion (Cummulative)' as Category, 
		--	avg(DATEDIFF(dd,tt.REFERRAL_COMPLETE_DATE,r.REFERRAL_DATE)) as summary2
		--from dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
		--on r.PATIENT_ID = p.PATIENT_ID
		--join FactAmbEnc f (nolock) 
		--on f.PATIENT_ID = p.PATIENT_ID
		--join REFERRAL_DETAIL rd (nolock)
		--on r.REFERRAL_ID = rd.REFERRAL_ID
		--join dbo.TBI_TRACKING tt (nolock) 
		--on p.PATIENT_ID = tt.PATIENT_ID
		--join dbo.viewFacilitiesByVisn v
		--on r.STD_INSTITUTION_ID = v.institution_id
		--join dbo.WKF_CASE wc (nolock)
		--on p.PATIENT_ID = wc.PATIENT_ID
		--join dbo.WKF_CASE_ACTIVITY wca (nolock)
		--on wc.WKF_CASE_ID = wca.WKF_CASE_ID

		--where p.OEF_OIF_IND = 1
		--and r.STD_REGISTRY_ID = 2
		--and v.VisnID = @VisnID
		--and tt.REFERRAL_COMPLETE_DATE is not null
		--and r.REFERRAL_DATE >= '9/1/2009'
		--group by v.VisnID;

		
		select 
			v.VisnID , 
			'Length of Time to Complete Comprehensive Evaluation From Initial Positive Screen' as Groups,
			'.. Avg Number of Day from screen to Evaluation Completion (Cummulative)' as Category, 
			avg(DATEDIFF(dd,tt.REFERRAL_COMPLETE_DATE,r.REFERRAL_DATE)) as summary2
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			--INNER JOIN
			--FactAmbEnc AS f WITH (nolock) 
            --ON f.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
			INNER JOIN WKF_CASE wfc
			ON r.REFERRAL_ID = wfc.REFERRAL_ID
			INNER JOIN TBI.TBI_TRACKING tt (nolock)
			on wfc.WKF_CASE_ID = tt.WKF_CASE_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			and 
			(tt.REFERRAL_COMPLETE_DATE is not null)
			and 
			(r.STD_REFERRALSTS_ID = 3)
		GROUP BY 
			v.VisnID


		IF @@ROWCOUNT = 0
			INSERT INTO @VISNSummary
							(VISN_ID,Groups,Category,Summary2)
						VALUES     
							(
							@VisnID
							,'Length of Time to Complete Comprehensive Evaluation From Initial Positive Screen'
							,'.. Avg Number of Day from screen to Evaluation Completion (Cummulative)'
							,0
							)

	   	   	--Avg Number of Day from screening to Completion Date [Current past 3 Month]
		
		Insert @VISNSummary (VISN_ID,Groups,Category, Footnote, Summary2)
	    
		--select 
		--	v.VisnID , 
		--	'Length of Time to Complete Comprehensive Evaluation From Initial Positive Screen' as Groups,
		--	'.. Avg Number of Day from screen to Evaluation Completion (Current)' as Category, 
		--	avg(DATEDIFF(dd,tt.REFERRAL_COMPLETE_DATE,r.REFERRAL_DATE)) as summary2
		--from dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
		--on r.PATIENT_ID = p.PATIENT_ID
		--join FactAmbEnc f (nolock) 
		--on f.PATIENT_ID = p.PATIENT_ID
		--join REFERRAL_DETAIL rd (nolock)
		--on r.REFERRAL_ID = rd.REFERRAL_ID
		--join dbo.TBI_TRACKING tt (nolock) 
		--on p.PATIENT_ID = tt.PATIENT_ID
		--join dbo.viewFacilitiesByVisn v
		--on r.STD_INSTITUTION_ID = v.institution_id
		--join dbo.WKF_CASE wc (nolock)
		--on p.PATIENT_ID = wc.PATIENT_ID
		--join dbo.WKF_CASE_ACTIVITY wca (nolock)
		--on wc.WKF_CASE_ID = wca.WKF_CASE_ID

		--where p.OEF_OIF_IND = 1
		--and r.STD_REGISTRY_ID = 2
		--and v.VisnID = @VisnID
		--and tt.REFERRAL_COMPLETE_DATE is not null
		--and r.REFERRAL_DATE >=  CONVERT(varchar, DATEADD(mm, -3, getdate()),101) 
		--group by v.VisnID;
		
		
		select 
			v.VisnID , 
			'Length of Time to Complete Comprehensive Evaluation From Initial Positive Screen' as Groups,
			'.. Avg Number of Day from screen to Evaluation Completion (Current)' as Category,
			'***Reflects rolling 3 month average of most recent 3 month less first 30 days' as Footnote,
			avg(DATEDIFF(dd,tt.REFERRAL_COMPLETE_DATE,r.REFERRAL_DATE)) as summary2
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			--INNER JOIN
			--FactAmbEnc AS f WITH (nolock) 
            --ON f.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
			INNER JOIN WKF_CASE wfc
			ON r.REFERRAL_ID = wfc.REFERRAL_ID
			INNER JOIN TBI.TBI_TRACKING tt (nolock)
			on wfc.WKF_CASE_ID = tt.WKF_CASE_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			and 
			(tt.REFERRAL_COMPLETE_DATE is not null)
			and 
			(r.STD_REFERRALSTS_ID = 3)
			and 
			r.REFERRAL_DATE >=  CONVERT(varchar, DATEADD(mm, -3, getdate()),101) 
		
		GROUP BY 
			v.VisnID
			
		IF @@ROWCOUNT = 0
			INSERT INTO @VISNSummary
							(VISN_ID,Groups,Category,Footnote, Summary2)
						VALUES     
							(
							@VisnID
							,'Length of Time to Complete Comprehensive Evaluation From Initial Positive Screen'
							,'.. Avg Number of Day from screen to Evaluation Completion (Current)'
							,'***Reflects rolling 3 month average of most recent 3 month less first 30 days'
							,0
							)

		
Select * from @VISNSummary


End Try	
Begin catch
	Return
End Catch

END

	/* SET NOCOUNT ON */
	RETURN


GO

/****** Object:  StoredProcedure [dbo].[USP_EFR_REPORT_NEW_KIT_ORDERS_REQUIRED]    Script Date: 01/16/2012 14:23:30 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



CREATE PROCEDURE [dbo].[USP_EFR_REPORT_NEW_KIT_ORDERS_REQUIRED]

AS
	 SET NOCOUNT ON 
		
		SELECT     WKF_CASE.WKF_CASE_ID, PATIENT.LAST_NAME + ', ' + PATIENT.FIRST_NAME + ' ' + PATIENT.MIDDLE_NAME AS PatientName, 
							  STD_INSTITUTION.NAME, STD_WKFCASETYPE.Name AS [Kit Type], REFERRAL.VAMC_CONTACT_NAME, REFERRAL.VAMC_CONTACT_PHONE, 
							  REFERRAL.ADDRESS_LINE1, REFERRAL.ADDRESS_LINE2, REFERRAL.ADDRESS_LINE3, REFERRAL.CITY, REFERRAL.COUNTRY, 
							  REFERRAL.COUNTY, REFERRAL.POSTAL_CODE, REFERRAL.STATE, REFERRAL.ZIP_PLUS_4
		FROM         WKF_CASE INNER JOIN
							  STD_WKFCASETYPE ON WKF_CASE.STD_WKFCASETYPE_ID = STD_WKFCASETYPE.ID INNER JOIN
							  REFERRAL ON WKF_CASE.REFERRAL_ID = REFERRAL.REFERRAL_ID INNER JOIN
							  PATIENT ON REFERRAL.PATIENT_ID = PATIENT.PATIENT_ID INNER JOIN
							  STD_INSTITUTION ON REFERRAL.STD_INSTITUTION_ID = STD_INSTITUTION.ID
		WHERE     (WKF_CASE.STD_WKFCASETYPE_ID IN (3, 4)) AND (WKF_CASE.STD_WKFCASESTS_ID = 2) AND (REFERRAL.STD_REFERRALSTS_ID = 5) AND 
							  (NOT EXISTS
								  (SELECT     NULL AS EMPTY
									FROM          (SELECT DISTINCT WKF_CASE_ID
															FROM          WKF_CASE_ACTIVITY
															WHERE      (STD_WKFACTIVITYTYPE_ID = 1) AND (ARCHIVED_FLAG = 0)) AS KitOrderedActivity --ARCHIVED_FLAG = 0 Added per bug tracker #1539
									WHERE      (WKF_CASE_ID = WKF_CASE.WKF_CASE_ID)))
		ORDER BY STD_INSTITUTION.NAME, [Kit Type]

RETURN


GO

/****** Object:  StoredProcedure [dbo].[USP_EFR_REPORT_EXISTING_KIT_ORDERS]    Script Date: 01/16/2012 14:23:30 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



CREATE PROCEDURE [dbo].[USP_EFR_REPORT_EXISTING_KIT_ORDERS]
	/*
	(
	@parameter1 int = 5,
	@parameter2 datatype OUTPUT
	)
	*/
AS
	 SET NOCOUNT ON 
	 SELECT [t0].[WKF_CASE_ID], ([t15].[LAST_NAME] + ', '+ [t15].[FIRST_NAME] + ' ' + [t15].[MIDDLE_NAME]) AS FULLNAME, [t0].[CREATED], [t0].[REPRESENTATIVE_NAME], [t0].[CONTACT_NAME], [t0].[ADDRESS_LINE1], [t0].[ADDRESS_LINE2], [t0].[ADDRESS_LINE3], [t0].[CITY], [t0].[COUNTRY], [t0].[COUNTY],  [t0].[POSTAL_CODE], [t0].[STATE], [t0].[ZIP_PLUS_4], [t15].[VAMC_CONTACT_PHONE], [t2].[CODE] 
FROM [dbo].[WKF_CASE_ACTIVITY] AS [t0]
INNER JOIN [dbo].[STD_WKFACTIVITYSTS] AS [t1] ON [t1].[ID] = [t0].[STD_WKFACTIVITYSTS_ID]
INNER JOIN [dbo].[STD_WKFACTIVITYTYPE] AS [t2] ON [t2].[ID] = [t0].[STD_WKFACTIVITYTYPE_ID]
INNER JOIN ([dbo].[WKF_CASE] AS [t3]
    INNER JOIN [dbo].[STD_WKFCASETYPE] AS [t4] ON [t4].[ID] = [t3].[STD_WKFCASETYPE_ID]
    LEFT OUTER JOIN (
        SELECT 1 AS [test], [t5].[STD_REGISTRY_ID], [t5].[REFERRAL_ID], [t5].[STD_REFERRALSTS_ID], [t5].[PATIENT_ID], [t5].[STD_INSTITUTION_ID], [t5].[REFERRAL_DATE], [t5].[REFERRAL_CLASS_TEXT], [t5].[PROVIDER_ID_NUMBER], [t5].[PROVIDER_NAME], [t5].[PROVIDER_PHONE], [t5].[PROVIDER_EMAIL], [t5].[CREATEDBY], [t5].[CREATED], [t5].[UPDATEDBY], [t5].[UPDATED], [t5].[ROW_VERSION], [t5].[COMMENT_TEXT], [t5].[ADDRESS_LINE1], [t5].[ADDRESS_LINE2], [t5].[ADDRESS_LINE3], [t5].[CITY], [t5].[COUNTRY], [t5].[COUNTY], [t5].[POSTAL_CODE], [t5].[STATE], [t5].[VAMC_CONTACT_EMAIL], [t5].[VAMC_CONTACT_NAME], [t5].[VAMC_CONTACT_PHONE], [t5].[ZIP_PLUS_4], [t5].[VAMC_CONTACT_FAX], [t5].[PROVIDER_ADDRESS_LINE1], [t5].[PROVIDER_ADDRESS_LINE2], [t5].[PROVIDER_ADDRESS_LINE3], [t5].[PROVIDER_CITY], [t5].[PROVIDER_STATE], [t5].[PROVIDER_COUNTY], [t5].[PROVIDER_COUNTRY], [t5].[PROVIDER_POSTAL_CODE], [t5].[PROVIDER_ZIP_PLUS_4], [t5].[PROVIDER_FAX], [t5].[STD_REMINDERCLASS_ID], [t5].[REVIEW_BY], [t5].[REVIEW_DATE], [t5].[DUPLICATE_FLAG], [t6].[PATIENT_ID] AS [PATIENT_ID2], [t6].[STD_INSTITUTION_ID] AS [STD_INSTITUTION_ID2], [t6].[SSN], [t6].[VPID_NUMBER], [t6].[PATIENT_ICN], [t6].[FIRST_NAME], [t6].[MIDDLE_NAME], [t6].[LAST_NAME], [t6].[BIRTH_DATE] as [BIRTH_DATE_TEXT], [t6].[DEATH_DATE] as [DEATH_DATE_TEXT], [t6].[ADDRESS_LINE1] AS [ADDRESS_LINE12], [t6].[ADDRESS_LINE2] AS [ADDRESS_LINE22], [t6].[ADDRESS_LINE3] AS [ADDRESS_LINE32], [t6].[CITY] AS [CITY2], [t6].[STATE] AS [STATE2], [t6].[COUNTY] AS [COUNTY2], [t6].[COUNTRY] AS [COUNTRY2], [t6].[POSTAL_CODE] AS [POSTAL_CODE2], [t6].[HOME_PHONE], [t6].[EMAIL_ADDRESS], [t6].[OEF_OIF_IND], [t6].[CREATEDBY] AS [CREATEDBY2], [t6].[CREATED] AS [CREATED2], [t6].[UPDATEDBY] AS [UPDATEDBY2], [t6].[UPDATED] AS [UPDATED2], [t6].[ROW_VERSION] AS [ROW_VERSION2], [t6].[BIRTH_DATE], [t6].[DEATH_DATE], [t6].[DOD_PATIENT_ID], [t6].[STD_COMBATLOCATION_ID], [t6].[STD_ETHNICITY_ID], [t6].[STD_GENDER_ID], [t6].[STD_MARITALSTATUS_ID], [t6].[STD_RACE_ID], [t6].[STD_SERVICEBRANCH_ID], [t6].[ZIP_PLUS_4] AS [ZIP_PLUS_42], [t6].[WORK_PHONE], [t8].[test] AS [test2], [t8].[ID], [t8].[NAME], [t8].[ACTIVATIONDATE], [t8].[DEACTIVATIONDATE], [t8].[STATIONNUMBER], [t8].[VISTANAME], [t8].[AGENCY_ID], [t8].[STREETCOUNTRY_ID], [t8].[STREETADDRESSLINE1], [t8].[STREETADDRESSLINE2], [t8].[STREETADDRESSLINE3], [t8].[STREETCITY], [t8].[STREETSTATE_ID], [t8].[STREETCOUNTY_ID], [t8].[STREETPOSTALCODE], [t8].[MAILINGCOUNTRY_ID], [t8].[MAILINGADDRESSLINE1], [t8].[MAILINGADDRESSLINE2], [t8].[MAILINGADDRESSLINE3], [t8].[MAILINGCITY], [t8].[MAILINGSTATE_ID], [t8].[MAILINGCOUNTY_ID], [t8].[MAILINGPOSTALCODE], [t8].[STD_FACILITYTYPE_ID], [t8].[MFN_ZEG_RECIPIENT], [t8].[PARENT_ID], [t8].[REALIGNEDFROM_ID], [t8].[REALIGNEDTO_ID], [t8].[VISN_ID], [t8].[ROW_VERSION] AS [ROW_VERSION3], [t8].[CREATED] AS [CREATED3], [t8].[UPDATED] AS [UPDATED3], [t8].[CREATEDBY] AS [CREATEDBY3], [t8].[UPDATEDBY] AS [UPDATEDBY3], [t9].[PATIENT_ID] AS [PATIENT_ID3], [t9].[STD_INSTITUTION_ID] AS [STD_INSTITUTION_ID3], [t9].[SSN] AS [SSN2], [t9].[VPID_NUMBER] AS [VPID_NUMBER2], [t9].[PATIENT_ICN] AS [PATIENT_ICN2], [t9].[FIRST_NAME] AS [FIRST_NAME2], [t9].[MIDDLE_NAME] AS [MIDDLE_NAME2], [t9].[LAST_NAME] AS [LAST_NAME2], [t9].[BIRTH_DATE] AS [BIRTH_DATE_TEXT2], [t9].[DEATH_DATE] AS [DEATH_DATE_TEXT2], [t9].[ADDRESS_LINE1] AS [ADDRESS_LINE13], [t9].[ADDRESS_LINE2] AS [ADDRESS_LINE23], [t9].[ADDRESS_LINE3] AS [ADDRESS_LINE33], [t9].[CITY] AS [CITY3], [t9].[STATE] AS [STATE3], [t9].[COUNTY] AS [COUNTY3], [t9].[COUNTRY] AS [COUNTRY3], [t9].[POSTAL_CODE] AS [POSTAL_CODE3], [t9].[HOME_PHONE] AS [HOME_PHONE2], [t9].[EMAIL_ADDRESS] AS [EMAIL_ADDRESS2], [t9].[OEF_OIF_IND] AS [OEF_OIF_IND2], [t9].[CREATEDBY] AS [CREATEDBY4], [t9].[CREATED] AS [CREATED4], [t9].[UPDATEDBY] AS [UPDATEDBY4], [t9].[UPDATED] AS [UPDATED4], [t9].[ROW_VERSION] AS [ROW_VERSION4], [t9].[BIRTH_DATE] AS [BIRTH_DATE2], [t9].[DEATH_DATE] AS [DEATH_DATE2], [t9].[DOD_PATIENT_ID] AS [DOD_PATIENT_ID2], [t9].[STD_COMBATLOCATION_ID] AS [STD_COMBATLOCATION_ID2], [t9].[STD_ETHNICITY_ID] AS [STD_ETHNICITY_ID2], [t9].[STD_GENDER_ID] AS [STD_GENDER_ID2], [t9].[STD_MARITALSTATUS_ID] AS [STD_MARITALSTATUS_ID2], [t9].[STD_RACE_ID] AS [STD_RACE_ID2], [t9].[STD_SERVICEBRANCH_ID] AS [STD_SERVICEBRANCH_ID2], [t9].[ZIP_PLUS_4] AS [ZIP_PLUS_43], [t9].[WORK_PHONE] AS [WORK_PHONE2], [t11].[test] AS [test3], [t11].[ID] AS [ID2], [t11].[NAME] AS [NAME2], [t11].[ACTIVATIONDATE] AS [ACTIVATIONDATE2], [t11].[DEACTIVATIONDATE] AS [DEACTIVATIONDATE2], [t11].[STATIONNUMBER] AS [STATIONNUMBER2], [t11].[VISTANAME] AS [VISTANAME2], [t11].[AGENCY_ID] AS [AGENCY_ID2], [t11].[STREETCOUNTRY_ID] AS [STREETCOUNTRY_ID2], [t11].[STREETADDRESSLINE1] AS [STREETADDRESSLINE12], [t11].[STREETADDRESSLINE2] AS [STREETADDRESSLINE22], [t11].[STREETADDRESSLINE3] AS [STREETADDRESSLINE32], [t11].[STREETCITY] AS [STREETCITY2], [t11].[STREETSTATE_ID] AS [STREETSTATE_ID2], [t11].[STREETCOUNTY_ID] AS [STREETCOUNTY_ID2], [t11].[STREETPOSTALCODE] AS [STREETPOSTALCODE2], [t11].[MAILINGCOUNTRY_ID] AS [MAILINGCOUNTRY_ID2], [t11].[MAILINGADDRESSLINE1] AS [MAILINGADDRESSLINE12], [t11].[MAILINGADDRESSLINE2] AS [MAILINGADDRESSLINE22], [t11].[MAILINGADDRESSLINE3] AS [MAILINGADDRESSLINE32], [t11].[MAILINGCITY] AS [MAILINGCITY2], [t11].[MAILINGSTATE_ID] AS [MAILINGSTATE_ID2], [t11].[MAILINGCOUNTY_ID] AS [MAILINGCOUNTY_ID2], [t11].[MAILINGPOSTALCODE] AS [MAILINGPOSTALCODE2], [t11].[STD_FACILITYTYPE_ID] AS [STD_FACILITYTYPE_ID2], [t11].[MFN_ZEG_RECIPIENT] AS [MFN_ZEG_RECIPIENT2], [t11].[PARENT_ID] AS [PARENT_ID2], [t11].[REALIGNEDFROM_ID] AS [REALIGNEDFROM_ID2], [t11].[REALIGNEDTO_ID] AS [REALIGNEDTO_ID2], [t11].[VISN_ID] AS [VISN_ID2], [t11].[ROW_VERSION] AS [ROW_VERSION5], [t11].[CREATED] AS [CREATED5], [t11].[UPDATED] AS [UPDATED5], [t11].[CREATEDBY] AS [CREATEDBY5], [t11].[UPDATEDBY] AS [UPDATEDBY5], [t12].[PATIENT_ID] AS [PATIENT_ID4], [t12].[STD_INSTITUTION_ID] AS [STD_INSTITUTION_ID4], [t12].[SSN] AS [SSN3], [t12].[VPID_NUMBER] AS [VPID_NUMBER3], [t12].[PATIENT_ICN] AS [PATIENT_ICN3], [t12].[FIRST_NAME] AS [FIRST_NAME3], [t12].[MIDDLE_NAME] AS [MIDDLE_NAME3], [t12].[LAST_NAME] AS [LAST_NAME3], [t12].[BIRTH_DATE] AS [BIRTH_DATE_TEXT3], [t12].[DEATH_DATE] AS [DEATH_DATE_TEXT3], [t12].[ADDRESS_LINE1] AS [ADDRESS_LINE14], [t12].[ADDRESS_LINE2] AS [ADDRESS_LINE24], [t12].[ADDRESS_LINE3] AS [ADDRESS_LINE34], [t12].[CITY] AS [CITY4], [t12].[STATE] AS [STATE4], [t12].[COUNTY] AS [COUNTY4], [t12].[COUNTRY] AS [COUNTRY4], [t12].[POSTAL_CODE] AS [POSTAL_CODE4], [t12].[HOME_PHONE] AS [HOME_PHONE3], [t12].[EMAIL_ADDRESS] AS [EMAIL_ADDRESS3], [t12].[OEF_OIF_IND] AS [OEF_OIF_IND3], [t12].[CREATEDBY] AS [CREATEDBY6], [t12].[CREATED] AS [CREATED6], [t12].[UPDATEDBY] AS [UPDATEDBY6], [t12].[UPDATED] AS [UPDATED6], [t12].[ROW_VERSION] AS [ROW_VERSION6], [t12].[BIRTH_DATE] AS [BIRTH_DATE3], [t12].[DEATH_DATE] AS [DEATH_DATE3], [t12].[DOD_PATIENT_ID] AS [DOD_PATIENT_ID3], [t12].[STD_COMBATLOCATION_ID] AS [STD_COMBATLOCATION_ID3], [t12].[STD_ETHNICITY_ID] AS [STD_ETHNICITY_ID3], [t12].[STD_GENDER_ID] AS [STD_GENDER_ID3], [t12].[STD_MARITALSTATUS_ID] AS [STD_MARITALSTATUS_ID3], [t12].[STD_RACE_ID] AS [STD_RACE_ID3], [t12].[STD_SERVICEBRANCH_ID] AS [STD_SERVICEBRANCH_ID3], [t12].[ZIP_PLUS_4] AS [ZIP_PLUS_44], [t12].[WORK_PHONE] AS [WORK_PHONE3], [t14].[test] AS [test4], [t14].[ID] AS [ID3], [t14].[NAME] AS [NAME3], [t14].[ACTIVATIONDATE] AS [ACTIVATIONDATE3], [t14].[DEACTIVATIONDATE] AS [DEACTIVATIONDATE3], [t14].[STATIONNUMBER] AS [STATIONNUMBER3], [t14].[VISTANAME] AS [VISTANAME3], [t14].[AGENCY_ID] AS [AGENCY_ID3], [t14].[STREETCOUNTRY_ID] AS [STREETCOUNTRY_ID3], [t14].[STREETADDRESSLINE1] AS [STREETADDRESSLINE13], [t14].[STREETADDRESSLINE2] AS [STREETADDRESSLINE23], [t14].[STREETADDRESSLINE3] AS [STREETADDRESSLINE33], [t14].[STREETCITY] AS [STREETCITY3], [t14].[STREETSTATE_ID] AS [STREETSTATE_ID3], [t14].[STREETCOUNTY_ID] AS [STREETCOUNTY_ID3], [t14].[STREETPOSTALCODE] AS [STREETPOSTALCODE3], [t14].[MAILINGCOUNTRY_ID] AS [MAILINGCOUNTRY_ID3], [t14].[MAILINGADDRESSLINE1] AS [MAILINGADDRESSLINE13], [t14].[MAILINGADDRESSLINE2] AS [MAILINGADDRESSLINE23], [t14].[MAILINGADDRESSLINE3] AS [MAILINGADDRESSLINE33], [t14].[MAILINGCITY] AS [MAILINGCITY3], [t14].[MAILINGSTATE_ID] AS [MAILINGSTATE_ID3], [t14].[MAILINGCOUNTY_ID] AS [MAILINGCOUNTY_ID3], [t14].[MAILINGPOSTALCODE] AS [MAILINGPOSTALCODE3], [t14].[STD_FACILITYTYPE_ID] AS [STD_FACILITYTYPE_ID3], [t14].[MFN_ZEG_RECIPIENT] AS [MFN_ZEG_RECIPIENT3], [t14].[PARENT_ID] AS [PARENT_ID3], [t14].[REALIGNEDFROM_ID] AS [REALIGNEDFROM_ID3], [t14].[REALIGNEDTO_ID] AS [REALIGNEDTO_ID3], [t14].[VISN_ID] AS [VISN_ID3], [t14].[ROW_VERSION] AS [ROW_VERSION7], [t14].[CREATED] AS [CREATED7], [t14].[UPDATED] AS [UPDATED7], [t14].[CREATEDBY] AS [CREATEDBY7], [t14].[UPDATEDBY] AS [UPDATEDBY7]
        FROM [dbo].[REFERRAL] AS [t5]
        INNER JOIN [dbo].[PATIENT] AS [t6] ON [t6].[PATIENT_ID] = [t5].[PATIENT_ID]
        LEFT OUTER JOIN (
            SELECT 1 AS [test], [t7].[ID], [t7].[NAME], [t7].[ACTIVATIONDATE], [t7].[DEACTIVATIONDATE], [t7].[STATIONNUMBER], [t7].[VISTANAME], [t7].[AGENCY_ID], [t7].[STREETCOUNTRY_ID], [t7].[STREETADDRESSLINE1], [t7].[STREETADDRESSLINE2], [t7].[STREETADDRESSLINE3], [t7].[STREETCITY], [t7].[STREETSTATE_ID], [t7].[STREETCOUNTY_ID], [t7].[STREETPOSTALCODE], [t7].[MAILINGCOUNTRY_ID], [t7].[MAILINGADDRESSLINE1], [t7].[MAILINGADDRESSLINE2], [t7].[MAILINGADDRESSLINE3], [t7].[MAILINGCITY], [t7].[MAILINGSTATE_ID], [t7].[MAILINGCOUNTY_ID], [t7].[MAILINGPOSTALCODE], [t7].[STD_FACILITYTYPE_ID], [t7].[MFN_ZEG_RECIPIENT], [t7].[PARENT_ID], [t7].[REALIGNEDFROM_ID], [t7].[REALIGNEDTO_ID], [t7].[VISN_ID], [t7].[ROW_VERSION], [t7].[CREATED], [t7].[UPDATED], [t7].[CREATEDBY], [t7].[UPDATEDBY]
            FROM [dbo].[STD_INSTITUTION] AS [t7]
            ) AS [t8] ON [t8].[ID] = [t5].[STD_INSTITUTION_ID]
        INNER JOIN [dbo].[PATIENT] AS [t9] ON [t9].[PATIENT_ID] = [t5].[PATIENT_ID]
        LEFT OUTER JOIN (
            SELECT 1 AS [test], [t10].[ID], [t10].[NAME], [t10].[ACTIVATIONDATE], [t10].[DEACTIVATIONDATE], [t10].[STATIONNUMBER], [t10].[VISTANAME], [t10].[AGENCY_ID], [t10].[STREETCOUNTRY_ID], [t10].[STREETADDRESSLINE1], [t10].[STREETADDRESSLINE2], [t10].[STREETADDRESSLINE3], [t10].[STREETCITY], [t10].[STREETSTATE_ID], [t10].[STREETCOUNTY_ID], [t10].[STREETPOSTALCODE], [t10].[MAILINGCOUNTRY_ID], [t10].[MAILINGADDRESSLINE1], [t10].[MAILINGADDRESSLINE2], [t10].[MAILINGADDRESSLINE3], [t10].[MAILINGCITY], [t10].[MAILINGSTATE_ID], [t10].[MAILINGCOUNTY_ID], [t10].[MAILINGPOSTALCODE], [t10].[STD_FACILITYTYPE_ID], [t10].[MFN_ZEG_RECIPIENT], [t10].[PARENT_ID], [t10].[REALIGNEDFROM_ID], [t10].[REALIGNEDTO_ID], [t10].[VISN_ID], [t10].[ROW_VERSION], [t10].[CREATED], [t10].[UPDATED], [t10].[CREATEDBY], [t10].[UPDATEDBY]
            FROM [dbo].[STD_INSTITUTION] AS [t10]
            ) AS [t11] ON [t11].[ID] = [t5].[STD_INSTITUTION_ID]
        INNER JOIN [dbo].[PATIENT] AS [t12] ON [t12].[PATIENT_ID] = [t5].[PATIENT_ID]
        LEFT OUTER JOIN (
            SELECT 1 AS [test], [t13].[ID], [t13].[NAME], [t13].[ACTIVATIONDATE], [t13].[DEACTIVATIONDATE], [t13].[STATIONNUMBER], [t13].[VISTANAME], [t13].[AGENCY_ID], [t13].[STREETCOUNTRY_ID], [t13].[STREETADDRESSLINE1], [t13].[STREETADDRESSLINE2], [t13].[STREETADDRESSLINE3], [t13].[STREETCITY], [t13].[STREETSTATE_ID], [t13].[STREETCOUNTY_ID], [t13].[STREETPOSTALCODE], [t13].[MAILINGCOUNTRY_ID], [t13].[MAILINGADDRESSLINE1], [t13].[MAILINGADDRESSLINE2], [t13].[MAILINGADDRESSLINE3], [t13].[MAILINGCITY], [t13].[MAILINGSTATE_ID], [t13].[MAILINGCOUNTY_ID], [t13].[MAILINGPOSTALCODE], [t13].[STD_FACILITYTYPE_ID], [t13].[MFN_ZEG_RECIPIENT], [t13].[PARENT_ID], [t13].[REALIGNEDFROM_ID], [t13].[REALIGNEDTO_ID], [t13].[VISN_ID], [t13].[ROW_VERSION], [t13].[CREATED], [t13].[UPDATED], [t13].[CREATEDBY], [t13].[UPDATEDBY]
            FROM [dbo].[STD_INSTITUTION] AS [t13]
            ) AS [t14] ON [t14].[ID] = [t5].[STD_INSTITUTION_ID]
        ) AS [t15] ON [t15].[REFERRAL_ID] = [t3].[REFERRAL_ID]) ON [t3].[WKF_CASE_ID] = [t0].[WKF_CASE_ID]
WHERE (NOT (EXISTS(
    SELECT NULL AS [EMPTY]
    FROM (
        SELECT DISTINCT [t16].[WKF_CASE_ACTIVITY_ID]
        FROM [EFR].[SHIPPING_DETAIL] AS [t16]
        WHERE ([t16].[RECEIVED_DATE] IS NOT NULL) OR ([t16].[STD_SHIPMENTSTS_ID] IS NOT NULL)
        ) AS [t17]
    WHERE [t17].[WKF_CASE_ACTIVITY_ID] = ([t0].[WKF_CASE_ACTIVITY_ID])
    ))) AND (([t3].[STD_WKFCASETYPE_ID] = 3) OR ([t3].[STD_WKFCASETYPE_ID] = 4)) AND ([t3].[STD_WKFCASESTS_ID] = 2) AND ([t15].[STD_REFERRALSTS_ID] = 5) AND ([t0].[STD_WKFACTIVITYTYPE_ID] = 1)
    AND (t0.ARCHIVED_FLAG = 0) --Added per bug tracker #1539
ORDER BY [t3].[WKF_CASE_ID]	RETURN


GO

/****** Object:  StoredProcedure [dbo].[usp_EFR_LETTER_INTERPRETATION_TXT]    Script Date: 01/16/2012 14:23:30 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



-- =============================================
-- Author:		David Hassell	
-- Create date: 08/03/2010
-- Description:	this SQL was originally included
--              in PatientBioLabIntrprtnLetter.rdl
-- Revision:    01/10/2012 V.Naik
--				Stored procedure modified per reference bug tracker #1473.
--              @interpretationDate modified to select MAX([t3].CONTACT_DATE) instead of TOP 1.
--				Added @secinterpretationDate to select updated date from EFR.INTERPRETATION_LETTER table 
-- =============================================
CREATE PROCEDURE [dbo].[usp_EFR_LETTER_INTERPRETATION_TXT]
	@intActivityID int,
	@reportType int
AS
BEGIN
	DECLARE @gender varchar(500)  
	--this was originally designed to include a salutation based on gender, 
	--but since the gender does not give enough information (for example Ms or Mrs) 
	--then it was modified to return only name
	DECLARE @lastFourDigitsSSN varchar(4) = ''
	DECLARE @patientLastName varchar(500)
	DECLARE @WorkflowType varchar(100)
	--DECLARE @interpretationDate Date
	DECLARE @secinterpretationDate Date

	SELECT TOP (1) @lastFourDigitsSSN = RIGHT([t3].[SSN],4)
		FROM [dbo].[WKF_CASE_ACTIVITY] AS [t0]
		INNER JOIN [dbo].[WKF_CASE] AS [t1] ON [t1].[WKF_CASE_ID] = [t0].[WKF_CASE_ID]
		LEFT OUTER JOIN [dbo].[REFERRAL] AS [t2] ON [t2].[REFERRAL_ID] = [t1].[REFERRAL_ID]
		LEFT OUTER JOIN [dbo].[PATIENT] AS [t3] ON [t3].[PATIENT_ID] = [t2].[PATIENT_ID]
		WHERE [t0].[WKF_CASE_ACTIVITY_ID] = @intActivityId 
		AND [t0].ARCHIVED_FLAG = 0 --Added per bug tracker #1539

	SELECT TOP (1) @patientLastName  = [t3].[LAST_NAME]
		FROM [dbo].[WKF_CASE_ACTIVITY] AS [t0]
		INNER JOIN [dbo].[WKF_CASE] AS [t1] ON [t1].[WKF_CASE_ID] = [t0].[WKF_CASE_ID]
		LEFT OUTER JOIN [dbo].[REFERRAL] AS [t2] ON [t2].[REFERRAL_ID] = [t1].[REFERRAL_ID]
		LEFT OUTER JOIN [dbo].[PATIENT] AS [t3] ON [t3].[PATIENT_ID] = [t2].[PATIENT_ID]
		WHERE [t0].[WKF_CASE_ACTIVITY_ID] = @intActivityId
		AND [t0].ARCHIVED_FLAG = 0 --Added per bug tracker #1539

	SELECT TOP (1) @WorkflowType = [t2].[CODE]
		FROM [dbo].[WKF_CASE_ACTIVITY] AS [t0]
		INNER JOIN [dbo].[WKF_CASE] AS [t1] ON [t1].[WKF_CASE_ID] = [t0].[WKF_CASE_ID]
		INNER JOIN [dbo].[STD_WKFCASETYPE] AS [t2] ON [t2].[ID] = [t1].[STD_WKFCASETYPE_ID]
		WHERE [t0].[WKF_CASE_ACTIVITY_ID] = @intActivityId
		AND [t0].ARCHIVED_FLAG = 0 --Added per bug tracker #1539
		
	--SELECT @interpretationDate = MAX([t3].CONTACT_DATE)
	--	FROM [dbo].[WKF_CASE_ACTIVITY] AS [t0]
	--	INNER JOIN [dbo].[WKF_CASE] AS [t1] ON [t1].[WKF_CASE_ID] = [t0].[WKF_CASE_ID]
	--	INNER JOIN [dbo].[REFERRAL] AS [t2] ON [t2].[REFERRAL_ID] = [t1].[REFERRAL_ID]
	--	INNER JOIN [EFR].[CONTACT_LOG] AS [t3] ON [t3].[REFERRAL_ID] = [t2].[REFERRAL_ID]
	--	WHERE [t0].[WKF_CASE_ACTIVITY_ID] = @intActivityId
	--	AND [t3].CONTACT_REASON_TEXT = 'Interpretation Letter Printed'
	--	GROUP BY [t0].[WKF_CASE_ACTIVITY_ID]
		
		
		SELECT @secinterpretationDate = MAX(UPDATED)
		FROM [EFR].[INTERPRETATION_LETTER] 
		WHERE [WKF_CASE_ACTIVITY_ID] = @intActivityId
		GROUP BY [WKF_CASE_ACTIVITY_ID]
	
	if @reportType = 0
	BEGIN
		--Patient Letter
		SELECT TOP (1) @gender =  [t4].[value]
			FROM (
				SELECT ([t3].[FIRST_NAME] + ' ') + [t3].[LAST_NAME] AS [value], [t0].[WKF_CASE_ACTIVITY_ID]
				FROM [dbo].[WKF_CASE_ACTIVITY] AS [t0]
				INNER JOIN [dbo].[WKF_CASE] AS [t1] ON [t1].[WKF_CASE_ID] = [t0].[WKF_CASE_ID]
				LEFT OUTER JOIN [dbo].[REFERRAL] AS [t2] ON [t2].[REFERRAL_ID] = [t1].[REFERRAL_ID]
				LEFT OUTER JOIN [dbo].[PATIENT] AS [t3] ON [t3].[PATIENT_ID] = [t2].[PATIENT_ID]
				WHERE [t0].ARCHIVED_FLAG = 0 --Added per bug tracker #1539
			) AS [t4]
			WHERE [t4].[WKF_CASE_ACTIVITY_ID] = @intActivityId
			
			
			


		SELECT ISNULL([t0].[PATIENT_INTERPRETATION_TEXT],'') AS [InterpretationText]
			, ISNULL([t0].[PATIENT_NAME],'') AS [Name]
			, '' AS [FacilityName]
			, ISNULL([t0].[PATIENT_ADDR1],'') AS [AddressPart1]
			, ISNULL([t0].[PATIENT_ADDR2],'') AS [AddressPart2]
			, ISNULL([t0].[PATIENT_ADDR3],'') AS [AddressPart3]
			, ISNULL([t0].[PATIENT_CITY],'') AS [City]
			, ISNULL([t0].[PATIENT_STATE],'') AS [State]
			, ISNULL([t0].[PATIENT_POSTAL],'') AS [Zip]
		  --, [t0].[PATIENT_COUNTRY] AS [Country]
			,CASE
				WHEN [t0].[PATIENT_COUNTRY] = 'United States' THEN ''
				WHEN [t0].[PATIENT_COUNTRY] = 'USA' THEN ''
				WHEN [t0].[PATIENT_COUNTRY] = 'U.S.A.' THEN ''
				WHEN [t0].[PATIENT_COUNTRY] = 'U.S.' THEN ''
				WHEN [t0].[PATIENT_COUNTRY] = 'United States of America' THEN ''
				WHEN [t0].[PATIENT_COUNTRY] = 'US' THEN ''
				ELSE ISNULL([t0].[PATIENT_COUNTRY],'')
			 END as [Country]
			, ISNULL(@gender,'') AS [Gender]
			, ISNULL(@lastFourDigitsSSN,'') AS [Last4SSN]
			, ISNULL(@patientLastName,'') AS [PatientLastName]
			, ISNULL(@WorkflowType,'') AS [WorkflowType]
			--, ISNULL(@interpretationDate, GETDATE()) AS [InterpretationDate]
			, ISNULL(@secinterpretationDate,'')  AS [InterpretationDate]
			, ISNULL([t0].FROM_ADDRESS,'') as [FROM_ADDRESS]
			, ISNULL([t0].Letter_SUBJECT,'') as [Letter_SUBJECT]
			, ISNULL([t0].CCName,'') as [CCName]
			, ISNULL([t0].[PATIENT_COMMENT],'') as SigningComments
			, ISNULL([t1].NAME,'') as SigningName
			, ISNULL([t1].TITLE,'') as SigningTitle
			, ISNULL([t1].ADDITIONAL_DESCRIPTION,'') as SigningAdditionalDescription

		FROM [EFR].[INTERPRETATION_LETTER] AS [t0]
		LEFT JOIN STD_SIGNING_CLINICIAN [t1]
		ON [t0].STD_SIGNING_CLINICIAN_ID = [t1].ID
		WHERE [t0].[WKF_CASE_ACTIVITY_ID] = @intActivityId

	END


	if @reportType = 1
	BEGIN
	--Provider Letter

		SELECT ISNULL([t0].[PROVIDER_INTERPRETATION_TEXT],'') AS [InterpretationText]
			, (ISNULL([t0].[PATIENT_NAME],'') + ' - ') + ISNULL(@lastFourDigitsSSN,'') AS [Gender]
			, ISNULL([t0].[PROVIDER_NAME],'') AS [Name]
			, ISNULL([t0].[PROVIDER_INSTITUTION_NAME],'') AS [FacilityName]
			, ISNULL([t0].[PROVIDER_ADDR1],'') AS [AddressPart1]
			, ISNULL([t0].[PROVIDER_ADDR2],'') AS [AddressPart2]
			, ISNULL([t0].[PROVIDER_ADDR3],'') AS [AddressPart3]
			, ISNULL([t0].[PROVIDER_CITY],'') AS [City]
			, ISNULL([t0].[PROVIDER_STATE],'') AS [State]
			, ISNULL([t0].[PROVIDER_POSTAL],'') AS [Zip]
			--, [t0].[PROVIDER_COUNTRY] AS [Country]
			,CASE
			WHEN [t0].[PROVIDER_COUNTRY] = 'United States' THEN ''
			WHEN [t0].[PROVIDER_COUNTRY] = 'USA' THEN ''
			WHEN [t0].[PROVIDER_COUNTRY] = 'U.S.A.' THEN ''
			WHEN [t0].[PROVIDER_COUNTRY] = 'U.S.' THEN ''
			WHEN [t0].[PROVIDER_COUNTRY] = 'United States of America' THEN ''
			WHEN [t0].[PROVIDER_COUNTRY] = 'US' THEN ''
			ELSE ISNULL([t0].[PROVIDER_COUNTRY],'')
			END as [Country]
			, ISNULL(@patientLastName,'') AS [PatientLastName]
			, ISNULL(@WorkflowType,'') AS [WorkflowType]
			--, ISNULL(@interpretationDate, GETDATE()) AS [InterpretationDate]
			, ISNULL(@secinterpretationDate,'')  AS [InterpretationDate]
			, ISNULL([t0].FROM_ADDRESS,'') as [FROM_ADDRESS]
			, ISNULL([t0].Letter_SUBJECT,'') as [Letter_SUBJECT]
			, ISNULL([t0].CCName,'') as [CCName]
			, ISNULL([t0].[PROVIDER_COMMENTS],'') as SigningComments
			, ISNULL([t1].NAME,'') as SigningName
			, ISNULL([t1].TITLE,'') as SigningTitle
			, ISNULL([t1].ADDITIONAL_DESCRIPTION,'') as SigningAdditionalDescription

		FROM [EFR].[INTERPRETATION_LETTER] AS [t0]
		LEFT JOIN STD_SIGNING_CLINICIAN [t1]
		ON [t0].STD_SIGNING_CLINICIAN_ID = [t1].ID
		WHERE [t0].[WKF_CASE_ACTIVITY_ID] = @intActivityId



	END
	
	
END



GO

/****** Object:  StoredProcedure [dbo].[usp_EFR_LETTER_ANALYTE_DETAILS]    Script Date: 01/16/2012 14:23:30 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





-- =============================================
-- Author:		David Hassell
-- Create date: 08/03/2010
-- Description:	This procedure was formerly in 
--              PatientBioLabIntrprtnLetter.rdl
-- =============================================
CREATE PROCEDURE [dbo].[usp_EFR_LETTER_ANALYTE_DETAILS]
	@activityID int
AS
BEGIN

	Declare @activityType int 



	SELECT TOP (1) @activityType = [t2].[ID]
	FROM [dbo].[WKF_CASE_ACTIVITY] AS [t0]
	INNER JOIN ([dbo].[WKF_CASE] AS [t1]
		INNER JOIN [dbo].[STD_WKFCASETYPE] AS [t2] ON [t2].[ID] = [t1].[STD_WKFCASETYPE_ID]) ON [t1].[WKF_CASE_ID] = [t0].[WKF_CASE_ID]
	WHERE [t0].[WKF_CASE_ACTIVITY_ID] = @activityId
	  AND [t0].ARCHIVED_FLAG = 0 --Added per bug tracker #1539


	IF @activityType = 3
		BEGIN
			--Biological Monitoring Lab Analytes
			SELECT [t0].[TEST_NAME] AS [TestMethod], 
				--JH 8/16/2010: per build 2 design removing U235 items from letter report
				--[Analyte] =
				--CASE [t0].[TEST_NAME]
				--WHEN 'RATIO U235/U238' THEN [t0].[TEST_NAME]
				--ELSE [t0].[ANALYTE_NAME]
				--END
				[t0].[ANALYTE_NAME] as  [Analyte]
				, 
				--JH 8/16/2010: per build 2 design, display comment text if result is not present
				[Result] = 
				CASE [t0].[RESULT_TEXT]
				WHEN NULL THEN [t0].OTHER_COMMENT_TEXT 
				WHEN '' THEN [t0].OTHER_COMMENT_TEXT
				ELSE [t0].[RESULT_TEXT]
				END
				, [t0].[RESULT_UNIT_NUMBER] AS [Units],
				--JH 8/16/2010: per build 2 design, range will be the TEFSC range
				--[t0].[ORIGINAL_RANGE_NUMBER] AS [Range]
				[t0].[TEFSC_REFERENCE_RANGE] + ' ' + [TEFSC_UNITS] as [Range]
				,
				--JH 8/16/2010: per build 2 design, adding above TEFSC reference range
				[TEFSC_ABOVE_REFERENCE_RANGE] = 
				CASE [t0].TEFSC_ABOVE_REFERENCE_RANGE
				WHEN 1 THEN 'Yes'
				WHEN 0 THEN 'No'
				ELSE 'No'
				END
			FROM 
			(
			SELECT     TEST_NAME 
						, [RESULT_TEXT] =
							CASE CHARINDEX ('LOD' , RESULT_TEXT)
							WHEN 0 THEN RESULT_TEXT
							WHEN NULL THEN RESULT_TEXT
							ELSE RESULT_TEXT + '*'
							END
						, [std_units].CODE AS RESULT_UNIT_NUMBER , ANALYSIS_DETAIL.LAB_REFERENCE_RANGE AS [ORIGINAL_RANGE_NUMBER] , ANALYSIS_DETAIL_ID, 
						  FRAGMENT_ANALYSIS_ID, SPECIMEN_ANALYSIS_ID, STD_TEST_NAME_ID, ANALYTE_NAME, TEFSC_ABOVE_REFERENCE_RANGE, OTHER_COMMENT_TEXT, TEFSC_REFERENCE_RANGE, STD_UNIT1.NAME as [TEFSC_UNITS]
			FROM         EFR.ANALYSIS_DETAIL 
							INNER JOIN
						 EFR.STD_TEST_NAME ON ANALYSIS_DETAIL.STD_TEST_NAME_ID = STD_TEST_NAME.ID
							LEFT OUTER JOIN 
						 [EFR].STD_UNITS AS [std_units] on [std_units].ID = ANALYSIS_DETAIL.RESULT_UNIT_ID
							LEFT OUTER JOIN
						 [EFR].STD_UNITS AS [STD_UNIT1] on [STD_UNIT1].ID = ANALYSIS_DETAIL.TEFSC_REFERENCE_RANGE_UNIT_ID
			
    			--JH 8/16/2010: per build 2 design removing U235 items from letter report
    			--WHERE STD_TEST_NAME.CODE IN ('STANDARDIZED','RATIO U235/U238')
    			WHERE STD_TEST_NAME.CODE = 'STANDARDIZED' 
    			
    			)
			AS t0
			LEFT OUTER JOIN [EFR].[SPECIMEN_ANALYSIS] AS [t1] ON [t1].[SPECIMEN_ANALYSIS_ID] = [t0].[SPECIMEN_ANALYSIS_ID]
			LEFT OUTER JOIN [EFR].[FRAGMENT_ANALYSIS] AS [t2] ON [t2].[FRAGMENT_ANALYSIS_ID] = [t0].[FRAGMENT_ANALYSIS_ID]
			WHERE (([t1].[WKF_CASE_ACTIVITY_ID] = @activityId) OR ([t2].[WKF_CASE_ACTIVITY_ID] = @activityId))
		END

		IF @activityType = 4
		BEGIN
			--Fragment Analyis Lab Analytes
			SELECT [t1].[CODE] AS [TestMethod], [t0].[ANALYTE_NAME] AS [Analyte]
			--JH 8/16/2010: per build 2 design, display comment text if result is not present
			--, [std_units].CODE AS [Result]
			,[Result] = 
				CASE [t0].[RESULT_TEXT]
				WHEN NULL THEN [t0].OTHER_COMMENT_TEXT 
				WHEN '' THEN [t0].OTHER_COMMENT_TEXT
				ELSE [t0].[RESULT_TEXT]
				END
			--JH 8/16/2010: per build 2 design, range will be the TEFSC range
			--, [t0].LAB_REFERENCE_RANGE AS [Range]
			,[t0].TEFSC_REFERENCE_RANGE + '' + [STD_UNITS1].[NAME]  as [Range]
			--JH 8/16/2010: per build 2 design, adding above TEFSC reference range
			,[TEFSC_ABOVE_REFERENCE_RANGE] = 
				CASE [t0].TEFSC_ABOVE_REFERENCE_RANGE
				WHEN 1 THEN 'Yes'
				WHEN 0 THEN 'No'
				ELSE 'No'
				END
			
			FROM 
			
						(SELECT     TEST_NAME 
						, [RESULT_TEXT] =
							CASE CHARINDEX ('LOD' , RESULT_TEXT)
							WHEN 0 THEN RESULT_TEXT
							WHEN NULL THEN RESULT_TEXT
							ELSE RESULT_TEXT + '*'
							END
						, ANALYSIS_DETAIL.LAB_REFERENCE_RANGE AS [ORIGINAL_RANGE_NUMBER] , ANALYSIS_DETAIL_ID, 
						  FRAGMENT_ANALYSIS_ID, SPECIMEN_ANALYSIS_ID, STD_TEST_NAME_ID, ANALYTE_NAME, TEFSC_ABOVE_REFERENCE_RANGE, OTHER_COMMENT_TEXT, TEFSC_REFERENCE_RANGE
						  ,STD_ANALYSISMETHOD_ID,RESULT_UNIT_ID,[TEFSC_REFERENCE_RANGE_UNIT_ID]
			FROM         EFR.ANALYSIS_DETAIL)
			AS [t0]
			--[EFR].[ANALYSIS_DETAIL] AS [t0]
			LEFT OUTER JOIN [EFR].[STD_ANALYSISMETHOD] AS [t1] ON [t1].[ID] = [t0].[STD_ANALYSISMETHOD_ID]
			LEFT OUTER JOIN [EFR].[SPECIMEN_ANALYSIS] AS [t2] ON [t2].[SPECIMEN_ANALYSIS_ID] = [t0].[SPECIMEN_ANALYSIS_ID]
			LEFT OUTER JOIN [EFR].[FRAGMENT_ANALYSIS] AS [t3] ON [t3].[FRAGMENT_ANALYSIS_ID] = [t0].[FRAGMENT_ANALYSIS_ID]
			LEFT OUTER JOIN [EFR].STD_UNITS AS [std_units] on [std_units].ID = [t0].RESULT_UNIT_ID
			LEFT OUTER JOIN [EFR].STD_UNITS as [STD_UNITS1] on [STD_UNITS1].ID = [t0].[TEFSC_REFERENCE_RANGE_UNIT_ID]
			WHERE ([t2].[WKF_CASE_ACTIVITY_ID] = @activityId) OR ([t3].[WKF_CASE_ACTIVITY_ID] = @activityId)

		END
		

	END




GO

/****** Object:  StoredProcedure [dbo].[usp_EFR_LABORDER_PATIENT]    Script Date: 01/16/2012 14:23:31 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





-- =============================================
-- Author:		Jim Hagerty
-- Create date: 08/20/2010
-- Description:	Proc for Lab Order SSRS
-- =============================================
CREATE PROCEDURE [dbo].[usp_EFR_LABORDER_PATIENT]
	@activityId int
AS
BEGIN
          
          SELECT     STD_SERVICEBRANCH.NAME
          FROM         WKF_CASE_ACTIVITY INNER JOIN
          WKF_CASE ON WKF_CASE_ACTIVITY.WKF_CASE_ID = WKF_CASE.WKF_CASE_ID INNER JOIN
          PATIENT ON WKF_CASE.PATIENT_ID = PATIENT.PATIENT_ID INNER JOIN
          STD_SERVICEBRANCH ON PATIENT.STD_SERVICEBRANCH_ID = STD_SERVICEBRANCH.ID
          WHERE     (WKF_CASE_ACTIVITY.WKF_CASE_ACTIVITY_ID = @activityId)
          AND (WKF_CASE_ACTIVITY.ARCHIVED_FLAG = 0) --Added per bug tracker #1539
        
        
	END




GO

/****** Object:  StoredProcedure [dbo].[usp_EFR_LABORDER_DETAILS]    Script Date: 01/16/2012 14:23:31 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO




-- =============================================
-- Author:		Jim Hagerty
-- Create date: 08/20/2010
-- Description:	Proc for Lab Order SSRS
-- =============================================
CREATE PROCEDURE [dbo].[usp_EFR_LABORDER_DETAILS]
	@activityId int
AS
BEGIN
          
          SELECT
          ISNULL(EFR.LAB_ORDER_DETAIL.OTHER_ANALYTE_NAME,0) as OTHER_ANALYTE_NAME,
          WKF_CASE_ACTIVITY.WKF_CASE_ACTIVITY_ID,
          EFR.LAB_ORDER.LAB_ORDER_ID,
          PATIENT.PATIENT_ID,
          WKF_CASE.WKF_CASE_ID,
          PATIENT.SERVICE_STATUS,
          PATIENT.FIRST_NAME,
          PATIENT.MIDDLE_NAME,
          PATIENT.LAST_NAME,
          PATIENT.SSN,
          EFR.LAB_ORDER.SAMPLE_DESC,
          EFR.LAB_ORDER_DETAIL.STD_ANALYTETYPE_ID
          FROM WKF_CASE_ACTIVITY
          INNER JOIN
          EFR.LAB_ORDER ON WKF_CASE_ACTIVITY.WKF_CASE_ACTIVITY_ID = EFR.LAB_ORDER.WKF_CASE_ACTIVITY_ID
          INNER JOIN
          WKF_CASE ON WKF_CASE_ACTIVITY.WKF_CASE_ID = WKF_CASE.WKF_CASE_ID
          INNER JOIN
          PATIENT ON WKF_CASE.PATIENT_ID = PATIENT.PATIENT_ID
          INNER JOIN
          EFR.LAB_ORDER_DETAIL ON EFR.LAB_ORDER.LAB_ORDER_ID = EFR.LAB_ORDER_DETAIL.LAB_ORDER_ID
          WHERE     (WKF_CASE_ACTIVITY.WKF_CASE_ACTIVITY_ID = @activityId)
					AND (WKF_CASE_ACTIVITY.ARCHIVED_FLAG = 0) --Added per bug tracker #1539
        
        
	END




GO

/****** Object:  StoredProcedure [dbo].[usp_EFR_LABORDER_ANALYTES]    Script Date: 01/16/2012 14:23:31 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





-- =============================================
-- Author:		Jim Hagerty
-- Create date: 08/20/2010
-- Description:	Proc for Lab Order SSR
----Revision: 01/16/2012 Added ARCHIVED_FLAG = 0 reference bug tracker #1539.
-- =============================================
CREATE PROCEDURE [dbo].[usp_EFR_LABORDER_ANALYTES]
	@activityId int
AS
BEGIN
	
          SELECT     (SELECT     COUNT(EFR.STD_ANALYTETYPE.ID) AS Expr1
          FROM          WKF_CASE_ACTIVITY INNER JOIN
          EFR.LAB_ORDER ON WKF_CASE_ACTIVITY.WKF_CASE_ACTIVITY_ID = EFR.LAB_ORDER.WKF_CASE_ACTIVITY_ID INNER JOIN
          EFR.LAB_ORDER_DETAIL ON EFR.LAB_ORDER.LAB_ORDER_ID = EFR.LAB_ORDER_DETAIL.LAB_ORDER_ID INNER JOIN
          EFR.STD_ANALYTETYPE ON EFR.LAB_ORDER_DETAIL.STD_ANALYTETYPE_ID = EFR.STD_ANALYTETYPE.ID
          WHERE      (WKF_CASE_ACTIVITY.WKF_CASE_ACTIVITY_ID = @activityId) AND (EFR.STD_ANALYTETYPE.ID = 3) AND (WKF_CASE_ACTIVITY.ARCHIVED_FLAG = 0)) AS Aluminum,
          (SELECT     COUNT(STD_ANALYTETYPE_1.ID) AS Expr1
          FROM          WKF_CASE_ACTIVITY AS WKF_CASE_ACTIVITY_1 INNER JOIN
          EFR.LAB_ORDER AS LAB_ORDER_1 ON
          WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = LAB_ORDER_1.WKF_CASE_ACTIVITY_ID INNER JOIN
          EFR.LAB_ORDER_DETAIL AS LAB_ORDER_DETAIL_1 ON
          LAB_ORDER_1.LAB_ORDER_ID = LAB_ORDER_DETAIL_1.LAB_ORDER_ID INNER JOIN
          EFR.STD_ANALYTETYPE AS STD_ANALYTETYPE_1 ON
          LAB_ORDER_DETAIL_1.STD_ANALYTETYPE_ID = STD_ANALYTETYPE_1.ID
          WHERE      (WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = @activityId) AND (STD_ANALYTETYPE_1.ID = 1) AND (WKF_CASE_ACTIVITY_1.ARCHIVED_FLAG = 0)) AS Arsenic,
          (SELECT     COUNT(STD_ANALYTETYPE_1.ID) AS Expr1
          FROM          WKF_CASE_ACTIVITY AS WKF_CASE_ACTIVITY_1 INNER JOIN
          EFR.LAB_ORDER AS LAB_ORDER_1 ON
          WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = LAB_ORDER_1.WKF_CASE_ACTIVITY_ID INNER JOIN
          EFR.LAB_ORDER_DETAIL AS LAB_ORDER_DETAIL_1 ON
          LAB_ORDER_1.LAB_ORDER_ID = LAB_ORDER_DETAIL_1.LAB_ORDER_ID INNER JOIN
          EFR.STD_ANALYTETYPE AS STD_ANALYTETYPE_1 ON
          LAB_ORDER_DETAIL_1.STD_ANALYTETYPE_ID = STD_ANALYTETYPE_1.ID
          WHERE      (WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = @activityId) AND (STD_ANALYTETYPE_1.ID = 2) AND (WKF_CASE_ACTIVITY_1.ARCHIVED_FLAG = 0)) AS Cadmium,
          (SELECT     COUNT(STD_ANALYTETYPE_1.ID) AS Expr1
          FROM          WKF_CASE_ACTIVITY AS WKF_CASE_ACTIVITY_1 INNER JOIN
          EFR.LAB_ORDER AS LAB_ORDER_1 ON
          WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = LAB_ORDER_1.WKF_CASE_ACTIVITY_ID INNER JOIN
          EFR.LAB_ORDER_DETAIL AS LAB_ORDER_DETAIL_1 ON
          LAB_ORDER_1.LAB_ORDER_ID = LAB_ORDER_DETAIL_1.LAB_ORDER_ID INNER JOIN
          EFR.STD_ANALYTETYPE AS STD_ANALYTETYPE_1 ON
          LAB_ORDER_DETAIL_1.STD_ANALYTETYPE_ID = STD_ANALYTETYPE_1.ID
          WHERE      (WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = @activityId) AND (STD_ANALYTETYPE_1.ID = 6) AND (WKF_CASE_ACTIVITY_1.ARCHIVED_FLAG = 0)) AS Chromium,
          (SELECT     COUNT(STD_ANALYTETYPE_1.ID) AS Expr1
          FROM          WKF_CASE_ACTIVITY AS WKF_CASE_ACTIVITY_1 INNER JOIN
          EFR.LAB_ORDER AS LAB_ORDER_1 ON
          WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = LAB_ORDER_1.WKF_CASE_ACTIVITY_ID INNER JOIN
          EFR.LAB_ORDER_DETAIL AS LAB_ORDER_DETAIL_1 ON
          LAB_ORDER_1.LAB_ORDER_ID = LAB_ORDER_DETAIL_1.LAB_ORDER_ID INNER JOIN
          EFR.STD_ANALYTETYPE AS STD_ANALYTETYPE_1 ON
          LAB_ORDER_DETAIL_1.STD_ANALYTETYPE_ID = STD_ANALYTETYPE_1.ID
          WHERE      (WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = @activityId) AND (STD_ANALYTETYPE_1.ID = 5) AND (WKF_CASE_ACTIVITY_1.ARCHIVED_FLAG = 0)) AS Cobalt,
          (SELECT     COUNT(STD_ANALYTETYPE_1.ID) AS Expr1
          FROM          WKF_CASE_ACTIVITY AS WKF_CASE_ACTIVITY_1 INNER JOIN
          EFR.LAB_ORDER AS LAB_ORDER_1 ON
          WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = LAB_ORDER_1.WKF_CASE_ACTIVITY_ID INNER JOIN
          EFR.LAB_ORDER_DETAIL AS LAB_ORDER_DETAIL_1 ON
          LAB_ORDER_1.LAB_ORDER_ID = LAB_ORDER_DETAIL_1.LAB_ORDER_ID INNER JOIN
          EFR.STD_ANALYTETYPE AS STD_ANALYTETYPE_1 ON
          LAB_ORDER_DETAIL_1.STD_ANALYTETYPE_ID = STD_ANALYTETYPE_1.ID
          WHERE      (WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = @activityId) AND (STD_ANALYTETYPE_1.ID = 10) AND (WKF_CASE_ACTIVITY_1.ARCHIVED_FLAG = 0)) AS Copper,
          (SELECT     COUNT(STD_ANALYTETYPE_1.ID) AS Expr1
          FROM          WKF_CASE_ACTIVITY AS WKF_CASE_ACTIVITY_1 INNER JOIN
          EFR.LAB_ORDER AS LAB_ORDER_1 ON
          WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = LAB_ORDER_1.WKF_CASE_ACTIVITY_ID INNER JOIN
          EFR.LAB_ORDER_DETAIL AS LAB_ORDER_DETAIL_1 ON
          LAB_ORDER_1.LAB_ORDER_ID = LAB_ORDER_DETAIL_1.LAB_ORDER_ID INNER JOIN
          EFR.STD_ANALYTETYPE AS STD_ANALYTETYPE_1 ON
          LAB_ORDER_DETAIL_1.STD_ANALYTETYPE_ID = STD_ANALYTETYPE_1.ID
          WHERE      (WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = @activityId) AND (STD_ANALYTETYPE_1.ID = 4) AND (WKF_CASE_ACTIVITY_1.ARCHIVED_FLAG = 0)) AS Iron,
          (SELECT     COUNT(STD_ANALYTETYPE_1.ID) AS Expr1
          FROM          WKF_CASE_ACTIVITY AS WKF_CASE_ACTIVITY_1 INNER JOIN
          EFR.LAB_ORDER AS LAB_ORDER_1 ON
          WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = LAB_ORDER_1.WKF_CASE_ACTIVITY_ID INNER JOIN
          EFR.LAB_ORDER_DETAIL AS LAB_ORDER_DETAIL_1 ON
          LAB_ORDER_1.LAB_ORDER_ID = LAB_ORDER_DETAIL_1.LAB_ORDER_ID INNER JOIN
          EFR.STD_ANALYTETYPE AS STD_ANALYTETYPE_1 ON
          LAB_ORDER_DETAIL_1.STD_ANALYTETYPE_ID = STD_ANALYTETYPE_1.ID
          WHERE      (WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = @activityId) AND (STD_ANALYTETYPE_1.ID = 8) AND (WKF_CASE_ACTIVITY_1.ARCHIVED_FLAG = 0)) AS Manganese,
          (SELECT     COUNT(STD_ANALYTETYPE_1.ID) AS Expr1
          FROM          WKF_CASE_ACTIVITY AS WKF_CASE_ACTIVITY_1 INNER JOIN
          EFR.LAB_ORDER AS LAB_ORDER_1 ON
          WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = LAB_ORDER_1.WKF_CASE_ACTIVITY_ID INNER JOIN
          EFR.LAB_ORDER_DETAIL AS LAB_ORDER_DETAIL_1 ON
          LAB_ORDER_1.LAB_ORDER_ID = LAB_ORDER_DETAIL_1.LAB_ORDER_ID INNER JOIN
          EFR.STD_ANALYTETYPE AS STD_ANALYTETYPE_1 ON
          LAB_ORDER_DETAIL_1.STD_ANALYTETYPE_ID = STD_ANALYTETYPE_1.ID
          WHERE      (WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = @activityId) AND (STD_ANALYTETYPE_1.ID = 7) AND (WKF_CASE_ACTIVITY_1.ARCHIVED_FLAG = 0)) AS Nickel,
          (SELECT     COUNT(STD_ANALYTETYPE_1.ID) AS Expr1
          FROM          WKF_CASE_ACTIVITY AS WKF_CASE_ACTIVITY_1 INNER JOIN
          EFR.LAB_ORDER AS LAB_ORDER_1 ON
          WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = LAB_ORDER_1.WKF_CASE_ACTIVITY_ID INNER JOIN
          EFR.LAB_ORDER_DETAIL AS LAB_ORDER_DETAIL_1 ON
          LAB_ORDER_1.LAB_ORDER_ID = LAB_ORDER_DETAIL_1.LAB_ORDER_ID INNER JOIN
          EFR.STD_ANALYTETYPE AS STD_ANALYTETYPE_1 ON
          LAB_ORDER_DETAIL_1.STD_ANALYTETYPE_ID = STD_ANALYTETYPE_1.ID
          WHERE      (WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = @activityId) AND (STD_ANALYTETYPE_1.ID = 9) AND (WKF_CASE_ACTIVITY_1.ARCHIVED_FLAG = 0)) AS Lead,
          (SELECT     COUNT(STD_ANALYTETYPE_1.ID) AS Expr1
          FROM          WKF_CASE_ACTIVITY AS WKF_CASE_ACTIVITY_1 INNER JOIN
          EFR.LAB_ORDER AS LAB_ORDER_1 ON
          WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = LAB_ORDER_1.WKF_CASE_ACTIVITY_ID INNER JOIN
          EFR.LAB_ORDER_DETAIL AS LAB_ORDER_DETAIL_1 ON
          LAB_ORDER_1.LAB_ORDER_ID = LAB_ORDER_DETAIL_1.LAB_ORDER_ID INNER JOIN
          EFR.STD_ANALYTETYPE AS STD_ANALYTETYPE_1 ON
          LAB_ORDER_DETAIL_1.STD_ANALYTETYPE_ID = STD_ANALYTETYPE_1.ID
          WHERE      (WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = @activityId) AND (STD_ANALYTETYPE_1.ID = 10) AND (WKF_CASE_ACTIVITY_1.ARCHIVED_FLAG = 0)) AS Uranium,
          (SELECT     COUNT(STD_ANALYTETYPE_1.ID) AS Expr1
          FROM          WKF_CASE_ACTIVITY AS WKF_CASE_ACTIVITY_1 INNER JOIN
          EFR.LAB_ORDER AS LAB_ORDER_1 ON
          WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = LAB_ORDER_1.WKF_CASE_ACTIVITY_ID INNER JOIN
          EFR.LAB_ORDER_DETAIL AS LAB_ORDER_DETAIL_1 ON
          LAB_ORDER_1.LAB_ORDER_ID = LAB_ORDER_DETAIL_1.LAB_ORDER_ID INNER JOIN
          EFR.STD_ANALYTETYPE AS STD_ANALYTETYPE_1 ON
          LAB_ORDER_DETAIL_1.STD_ANALYTETYPE_ID = STD_ANALYTETYPE_1.ID
          WHERE      (WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = @activityId) AND (STD_ANALYTETYPE_1.ID = 13) AND (WKF_CASE_ACTIVITY_1.ARCHIVED_FLAG = 0)) AS Uranium235,
          (SELECT     COUNT(STD_ANALYTETYPE_1.ID) AS Expr1
          FROM          WKF_CASE_ACTIVITY AS WKF_CASE_ACTIVITY_1 INNER JOIN
          EFR.LAB_ORDER AS LAB_ORDER_1 ON
          WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = LAB_ORDER_1.WKF_CASE_ACTIVITY_ID INNER JOIN
          EFR.LAB_ORDER_DETAIL AS LAB_ORDER_DETAIL_1 ON
          LAB_ORDER_1.LAB_ORDER_ID = LAB_ORDER_DETAIL_1.LAB_ORDER_ID INNER JOIN
          EFR.STD_ANALYTETYPE AS STD_ANALYTETYPE_1 ON
          LAB_ORDER_DETAIL_1.STD_ANALYTETYPE_ID = STD_ANALYTETYPE_1.ID
          WHERE      (WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = @activityId) AND (STD_ANALYTETYPE_1.ID = 11) AND (WKF_CASE_ACTIVITY_1.ARCHIVED_FLAG = 0)) AS Tungsten,
          (SELECT     COUNT(STD_ANALYTETYPE_1.ID) AS Expr1
          FROM          WKF_CASE_ACTIVITY AS WKF_CASE_ACTIVITY_1 INNER JOIN
          EFR.LAB_ORDER AS LAB_ORDER_1 ON
          WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = LAB_ORDER_1.WKF_CASE_ACTIVITY_ID INNER JOIN
          EFR.LAB_ORDER_DETAIL AS LAB_ORDER_DETAIL_1 ON
          LAB_ORDER_1.LAB_ORDER_ID = LAB_ORDER_DETAIL_1.LAB_ORDER_ID INNER JOIN
          EFR.STD_ANALYTETYPE AS STD_ANALYTETYPE_1 ON
          LAB_ORDER_DETAIL_1.STD_ANALYTETYPE_ID = STD_ANALYTETYPE_1.ID
          WHERE      (WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = @activityId) AND (STD_ANALYTETYPE_1.ID = 14) AND (WKF_CASE_ACTIVITY_1.ARCHIVED_FLAG = 0)) AS Zinc,
		   (SELECT     COUNT(STD_ANALYTETYPE_1.ID) AS Expr1
          FROM          WKF_CASE_ACTIVITY AS WKF_CASE_ACTIVITY_1 INNER JOIN
          EFR.LAB_ORDER AS LAB_ORDER_1 ON
          WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = LAB_ORDER_1.WKF_CASE_ACTIVITY_ID INNER JOIN
          EFR.LAB_ORDER_DETAIL AS LAB_ORDER_DETAIL_1 ON
          LAB_ORDER_1.LAB_ORDER_ID = LAB_ORDER_DETAIL_1.LAB_ORDER_ID INNER JOIN
          EFR.STD_ANALYTETYPE AS STD_ANALYTETYPE_1 ON
          LAB_ORDER_DETAIL_1.STD_ANALYTETYPE_ID = STD_ANALYTETYPE_1.ID
          WHERE      (WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = @activityId) AND (STD_ANALYTETYPE_1.ID = 15) AND (WKF_CASE_ACTIVITY_1.ARCHIVED_FLAG = 0)) AS Other,
          (SELECT Top 1  OTHER_ANALYTE_NAME 
          FROM          WKF_CASE_ACTIVITY AS WKF_CASE_ACTIVITY_1 INNER JOIN
          EFR.LAB_ORDER AS LAB_ORDER_1 ON
          WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = LAB_ORDER_1.WKF_CASE_ACTIVITY_ID INNER JOIN
          EFR.LAB_ORDER_DETAIL AS LAB_ORDER_DETAIL_1 ON
          LAB_ORDER_1.LAB_ORDER_ID = LAB_ORDER_DETAIL_1.LAB_ORDER_ID INNER JOIN
          EFR.STD_ANALYTETYPE AS STD_ANALYTETYPE_1 ON
          LAB_ORDER_DETAIL_1.STD_ANALYTETYPE_ID = STD_ANALYTETYPE_1.ID
          WHERE      (WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = @activityId) AND (STD_ANALYTETYPE_1.ID = 15) AND (WKF_CASE_ACTIVITY_1.ARCHIVED_FLAG = 0)) AS OtherName
		

	END




GO

/****** Object:  StoredProcedure [dbo].[usp_EFR_LABORDER_ACTIVITY]    Script Date: 01/16/2012 14:23:31 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO




-- =============================================
-- Author:		Jim Hagerty
-- Create date: 08/20/2010
-- Description:	Proc for Lab Order SSRS
-- =============================================
CREATE PROCEDURE [dbo].[usp_EFR_LABORDER_ACTIVITY]
	@activityId int
AS
BEGIN
          SELECT     TOP (1) 
          WKF_CASE_ACTIVITY.WKF_CASE_ACTIVITY_ID,
          '' as PATIENT_ID
          , EFR.LAB_ORDER.LAB_ORDER_ID
          , EFR.LAB_ORDER.LAB_SEND_DATE
          FROM         WKF_CASE_ACTIVITY INNER JOIN
          EFR.LAB_ORDER ON WKF_CASE_ACTIVITY.WKF_CASE_ACTIVITY_ID = EFR.LAB_ORDER.WKF_CASE_ACTIVITY_ID
          WHERE     (WKF_CASE_ACTIVITY.WKF_CASE_ACTIVITY_ID = @activityId)
          AND (WKF_CASE_ACTIVITY.ARCHIVED_FLAG = 0) --Added per bug tracker #1539
          ORDER BY EFR.LAB_ORDER.LAB_SEND_DATE
        
	END




GO

/****** Object:  StoredProcedure [dbo].[usp_EFR_LABORDER]    Script Date: 01/16/2012 14:23:31 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO




-- =============================================
-- Author:		Jim Hagerty
-- Create date: 08/20/2010
-- Description:	Proc for Lab Order SSRS
-- =============================================
CREATE PROCEDURE [dbo].[usp_EFR_LABORDER]
	@activityId int
AS
BEGIN
          
          
          SELECT
          WKF_CASE_ACTIVITY.WKF_CASE_ACTIVITY_ID,
          EFR.LAB_ORDER.LAB_ORDER_ID,
          PATIENT.PATIENT_ID,
          WKF_CASE.WKF_CASE_ID,
          PATIENT.STD_SERVICEBRANCH_ID,
          PATIENT.SERVICE_STATUS,
          STD_SERVICEBRANCH.NAME,
          PATIENT.FIRST_NAME,
          PATIENT.MIDDLE_NAME,
          PATIENT.LAST_NAME,
          PATIENT.SSN,
          EFR.LAB_ORDER.SAMPLE_DESC,
          EFR.LAB_ORDER.SPECIAL_INSTRUCTION,
          EFR.LAB_ORDER.BSO_NUMBER
          FROM WKF_CASE_ACTIVITY
          INNER JOIN
          EFR.LAB_ORDER ON WKF_CASE_ACTIVITY.WKF_CASE_ACTIVITY_ID = EFR.LAB_ORDER.WKF_CASE_ACTIVITY_ID
          INNER JOIN
          WKF_CASE ON WKF_CASE_ACTIVITY.WKF_CASE_ID = WKF_CASE.WKF_CASE_ID
          INNER JOIN
          PATIENT ON WKF_CASE.PATIENT_ID = PATIENT.PATIENT_ID
          INNER JOIN
          STD_SERVICEBRANCH ON PATIENT.STD_SERVICEBRANCH_ID = STD_SERVICEBRANCH.ID
          WHERE     (WKF_CASE_ACTIVITY.WKF_CASE_ACTIVITY_ID = @activityId)
					AND (WKF_CASE_ACTIVITY.ARCHIVED_FLAG = 0) --Added per bug tracker #1539
        
        
        
	END




GO

/****** Object:  StoredProcedure [dbo].[ReportComprehensiveFacilityDetail]    Script Date: 01/16/2012 14:23:31 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



CREATE PROCEDURE [dbo].[ReportComprehensiveFacilityDetail]
	(
	@visnId varchar(3),
	@FacilityID varchar(20)
	)
AS

BEGIN
    --select top 10 * from dbo.viewFacilitiesByVisn
    
    set Nocount on
 
declare @startdate datetime = [dbo].[GetFiscalYearStartDate] (GETDATE())
declare @enddate datetime = [dbo].[GetTBIReportValidEndDate] (GETDATE())


Begin Try
    
--- Table Variable to Hold result sets
     
    Declare @FacilitySummary table (
        FacilityID varchar(20) null,
        Groups varchar(200) null,
        Footnote varchar(200) null,
        Category varchar(200) null,
        Summary1 int null,
        Summary2 int null,
        Summary3 int null,
        Percentage decimal(5,2));
        

	 /* COMPREHENSIVE EVALUATION:- COMPLETED/PENDING FURTHER EVALUATION  */

		-------------------------------
		-- Initial Positive Screen tracked for Comprehensive Evaluation
		Insert @FacilitySummary (FacilityID,Groups,Category,Summary1)
	    
		--select 
		--	v.VisnID , 
		--	'Comprehensive Evaluation - Completed/Pending Futher Evaluation' as Groups,
		--	'Initial Positive Screen tracked for Comprehensive Evaluation' as Category,
		--	count(p.PATIENT_ID) as Summar1
		--from dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
		--on r.PATIENT_ID = p.PATIENT_ID
		--left join REFERRAL_DETAIL rd (nolock)
		--on r.REFERRAL_ID = rd.REFERRAL_ID
		--join dbo.FactAmbEnc f (nolock)
		--on f.PATIENT_ID = p.PATIENT_ID
		--join dbo.viewFacilitiesByVisn v
		--on r.STD_INSTITUTION_ID = v.institution_id

		--where p.OEF_OIF_IND = 1
		--and r.STD_REGISTRY_ID = 2
		--and rd.STD_HEALTHFACTOR_ID = 63
		--and v.VisnID = @VisnID
		--and exists (select 1 from dbo.REFERRAL r2 (nolock) join dbo.REFERRAL_DETAIL rd2 (nolock)
		--			on r2.REFERRAL_ID = rd2.REFERRAL_ID and rd2.STD_HEALTHFACTOR_ID = 53 )
		--Group by v.VisnID;
		
		select distinct
			v.Name,
			'Comprehensive Evaluation - Completed/Pending Futher Evaluation' as Groups,
			'Initial Positive Screens tracked for Comprehensive Evaluation' as Category,
			p.PATIENT_ID
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			--INNER JOIN
            --FactAmbEnc AS f WITH (nolock) 
            --ON f.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			and
			(r.STD_REGISTRY_ID = 2)
			AND
			(rd.STD_HEALTHFACTOR_ID = 63 )
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(v.Name = @FacilityID)
			
			
			--AND 
			--r.REFERRAL_ID IN  
			--(
			--	select r2.REFERRAL_ID from dbo.REFERRAL r2(nolock)join dbo.REFERRAL_DETAIL rd2 (nolock) 
			--	on r2.REFERRAL_ID = rd2.REFERRAL_ID
			--	INNER JOIN
			--	viewFacilitiesByVisn AS v2 
			--	ON r2.STD_INSTITUTION_ID = v2.institution_id
			--	where 
			--	(v2.VisnID = @VisnID) 
			--	AND
			--	rd2.STD_HEALTHFACTOR_ID = 54
		 --   )

		
		IF @@ROWCOUNT = 0
			INSERT INTO @FacilitySummary
							(FacilityID,Groups,Category,Summary1)
						VALUES     
							(
							@FacilityID
							,'Comprehensive Evaluation - Completed/Pending Futher Evaluation'
							,'Initial Positive Screens tracked for Comprehensive Evaluation'
							,0
							)
		
		-- Comprehensive Evaluation Completed
		Insert @FacilitySummary (FacilityID,Groups,Category,Summary2)
	    
		--select 
		--	v.VisnID , 
		--	'Comprehensive Evaluation - Completed/Pending Futher Evaluation' as Groups,
		--	' .. Comprehensive Evaluation Completed' as Category,
		--	count(p.PATIENT_ID) as Summar2 
		--from dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
		--on r.PATIENT_ID = p.PATIENT_ID
		--left join REFERRAL_DETAIL rd (nolock)
		--on r.REFERRAL_ID = rd.REFERRAL_ID
		--join dbo.FactAmbEnc f (nolock)
		--on f.PATIENT_ID = p.PATIENT_ID
		--join dbo.TBI_TRACKING tt (nolock)
		--on f.PATIENT_ID = tt.PATIENT_ID
		--join dbo.viewFacilitiesByVisn v
		--on r.STD_INSTITUTION_ID = v.institution_id

		--where p.OEF_OIF_IND = 1
		--and r.STD_REGISTRY_ID = 2
		--and v.VisnID = @VisnID
		--and tt.REFERRAL_COMPLETE_DATE is not null
		--and r.STD_REFERRALSTS_ID = 3
		--Group by v.VisnID;
		
		
		select distinct
			v.Name , 
			'Comprehensive Evaluation - Completed/Pending Futher Evaluation' as Groups,
			' .. Comprehensive Evaluations Completed' as Category,
			r.REFERRAL_ID 
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			--INNER JOIN
			--FactAmbEnc AS f WITH (nolock) 
            --ON f.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
			INNER JOIN WKF_CASE wfc
			ON r.REFERRAL_ID = wfc.REFERRAL_ID
			INNER JOIN TBI.TBI_TRACKING tt (nolock)
			on wfc.WKF_CASE_ID = tt.WKF_CASE_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			and
			(r.STD_REGISTRY_ID = 2)
			and 
			(tt.REFERRAL_COMPLETE_DATE is not null)
			and 
			(r.STD_REFERRALSTS_ID = 3)
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(v.Name = @FacilityID)

		IF @@ROWCOUNT = 0
			INSERT INTO @FacilitySummary
							(FacilityID,Groups,Category,Summary2)
						VALUES     
							(
							@FacilityID
							,'Comprehensive Evaluation - Completed/Pending Futher Evaluation'
							,' .. Comprehensive Evaluations Completed'
							,0
							)


		-------------------------------
		-- Comfirmed TBI Diagnosis
		Insert @FacilitySummary (FacilityID,Groups,Category,Summary3)
	    
		--select 
		--	v.VisnID , 
		--	'Comprehensive Evaluation - Completed/Pending Futher Evaluation' as Groups,
		--	' .... Comfirmed TBI Diagnosis' as Category,
		--	count(p.PATIENT_ID) as Summar3 
		--from dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
		--on r.PATIENT_ID = p.PATIENT_ID
		--left join REFERRAL_DETAIL rd (nolock)
		--on r.REFERRAL_ID = rd.REFERRAL_ID
		--join dbo.FactAmbEnc f (nolock)
		--on f.PATIENT_ID = p.PATIENT_ID
		--join dbo.TBI_TRACKING tt (nolock)
		--on f.PATIENT_ID = tt.PATIENT_ID
		--join dbo.viewFacilitiesByVisn v
		--on r.STD_INSTITUTION_ID = v.institution_id

		--where p.OEF_OIF_IND = 1
		--and r.STD_REGISTRY_ID = 2
		--and tt.TBI_DIAGNOSIS_IND = 1
		--and v.VisnID = @VisnID
		--group by v.VisnID;
		
		select distinct
			v.Name , 
			'Comprehensive Evaluation - Completed/Pending Futher Evaluation' as Groups,
			' .... Comfirmed TBI Diagnosis' as Category,
			r.REFERRAL_ID 
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			--INNER JOIN
			--FactAmbEnc AS f WITH (nolock) 
            --ON f.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
			INNER JOIN WKF_CASE wfc
			ON r.REFERRAL_ID = wfc.REFERRAL_ID
			INNER JOIN TBI.TBI_TRACKING tt (nolock)
			on wfc.WKF_CASE_ID = tt.WKF_CASE_ID
		
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			and 
			(tt.TBI_DIAGNOSIS_IND = 1)
			and 
			(r.STD_REFERRALSTS_ID = 3)
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(v.Name = @FacilityID)
			
			


		IF @@ROWCOUNT = 0
			INSERT INTO @FacilitySummary
							(FacilityID,Groups,Category,Summary3)
						VALUES     
							(
							@FacilityID
							,'Comprehensive Evaluation - Completed/Pending Futher Evaluation'
							,' .... Comfirmed TBI Diagnosis'
							,0
							)
							

		-------------------------------
		-- TBI Diagnosis Ruled Out
		Insert @FacilitySummary (FacilityID,Groups,Category,Summary3)
	    
		--select 
		--	v.VisnID , 
		--	'Comprehensive Evaluation - Completed/Pending Futher Evaluation' as Groups,
		--	' .... TBI Diagnosis Ruled Out' as Category,
		--	count(p.PATIENT_ID) as Summar3 
		--from dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
		--on r.PATIENT_ID = p.PATIENT_ID
		--left join REFERRAL_DETAIL rd (nolock)
		--on r.REFERRAL_ID = rd.REFERRAL_ID
		--join dbo.FactAmbEnc f (nolock)
		--on f.PATIENT_ID = p.PATIENT_ID
		--join dbo.TBI_TRACKING tt (nolock)
		--on f.PATIENT_ID = tt.PATIENT_ID
		--join dbo.viewFacilitiesByVisn v
		--on r.STD_INSTITUTION_ID = v.institution_id

		--where p.OEF_OIF_IND = 1
		--and r.STD_REGISTRY_ID = 2
		--and tt.TBI_DIAGNOSIS_IND = 2
		--and v.VisnID = @VisnID
		--group by v.VisnID;


		select DISTINCT
			v.Name , 
			'Comprehensive Evaluation - Completed/Pending Futher Evaluation' as Groups,
			' .... TBI Diagnosis Ruled Out' as Category,
			r.REFERRAL_ID 
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			--INNER JOIN
			--FactAmbEnc AS f WITH (nolock) 
            --ON f.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
			INNER JOIN WKF_CASE wfc
			ON r.REFERRAL_ID = wfc.REFERRAL_ID
			INNER JOIN TBI.TBI_TRACKING tt (nolock)
			on wfc.WKF_CASE_ID = tt.WKF_CASE_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			and 
			(tt.TBI_DIAGNOSIS_IND = 2)
			and 
			(r.STD_REFERRALSTS_ID = 3)
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(v.Name = @FacilityID)
			


		IF @@ROWCOUNT = 0
			INSERT INTO @FacilitySummary
							(FacilityID,Groups,Category,Summary3)
						VALUES     
							(
							@FacilityID
							,'Comprehensive Evaluation - Completed/Pending Futher Evaluation'
							,' .... TBI Diagnosis Ruled Out'
							,0
							)

			
		-------------------------------
		-- TBI Diagnosis Pending
		Insert @FacilitySummary (FacilityID,Groups,Category,Summary3)
	    
		--select 
		--	v.VisnID , 
		--	'Comprehensive Evaluation - Completed/Pending Futher Evaluation' as Groups,
		--	' .... TBI Diagnosis Uncertain Pending Further Evaluation' as Category,
		--	count(p.PATIENT_ID) as Summar3 
		--from dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
		--on r.PATIENT_ID = p.PATIENT_ID
		--left join REFERRAL_DETAIL rd (nolock)
		--on r.REFERRAL_ID = rd.REFERRAL_ID
		--join dbo.FactAmbEnc f (nolock)
		--on f.PATIENT_ID = p.PATIENT_ID
		--join dbo.TBI_TRACKING tt (nolock)
		--on f.PATIENT_ID = tt.PATIENT_ID
		--join dbo.viewFacilitiesByVisn v
		--on r.STD_INSTITUTION_ID = v.institution_id

		--where p.OEF_OIF_IND = 1
		--and r.STD_REGISTRY_ID = 2
		--and tt.TBI_DIAGNOSIS_IND = 0
		--and v.VisnID = @VisnID
		--group by v.VisnID;


		select DISTINCT
			v.Name , 
			'Comprehensive Evaluation - Completed/Pending Futher Evaluation' as Groups,
			' .... TBI Diagnosis Uncertain Pending Further Evaluation' as Category,
			r.REFERRAL_ID 
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			--INNER JOIN
			--FactAmbEnc AS f WITH (nolock) 
            --ON f.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
			INNER JOIN WKF_CASE wfc
			ON r.REFERRAL_ID = wfc.REFERRAL_ID
			INNER JOIN TBI.TBI_TRACKING tt (nolock)
			on wfc.WKF_CASE_ID = tt.WKF_CASE_ID
		
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			and 
			(tt.TBI_DIAGNOSIS_IND = 0)
			and 
			(r.STD_REFERRALSTS_ID = 3)
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(v.Name = @FacilityID)
			
	

		IF @@ROWCOUNT = 0
			INSERT INTO @FacilitySummary
							(FacilityID,Groups,Category,Summary3)
						VALUES     
							(
							@FacilityID
							,'Comprehensive Evaluation - Completed/Pending Futher Evaluation'
							,' .... TBI Diagnosis Uncertain Pending Further Evaluation'
							,0
							)
							


        /*  COMPREHENSIVE EVALUATION TO BE SCHEDULED OR PENDING CONTACT */

		-------------------------------
		-- Initial Positive Screen tracked for Comprehensive Evaluation
		Insert @FacilitySummary (FacilityID,Groups,Category,Summary1)
	    
		--select 
		--	v.VisnID , 
		--	'Comprehensive Evaluation - To be Scheduled or Pending Contact' as Groups,
		--	'Initial Positive Screen tracked for Comprehensive Evaluation' as Category,
		--	count(p.PATIENT_ID) as Summar1
		--from dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
		--on r.PATIENT_ID = p.PATIENT_ID
		--left join REFERRAL_DETAIL rd (nolock)
		--on r.REFERRAL_ID = rd.REFERRAL_ID
		--join dbo.FactAmbEnc f (nolock)
		--on f.PATIENT_ID = p.PATIENT_ID
		--join dbo.viewFacilitiesByVisn v
		--on r.STD_INSTITUTION_ID = v.institution_id

		--where p.OEF_OIF_IND = 1
		--and r.STD_REGISTRY_ID = 2
		--and rd.STD_HEALTHFACTOR_ID = 63
		--and v.VisnID = @VisnID
		--and exists (select 1 from dbo.REFERRAL r2 (nolock) join dbo.REFERRAL_DETAIL rd2 (nolock)
		--			on r2.REFERRAL_ID = rd2.REFERRAL_ID and rd2.STD_HEALTHFACTOR_ID = 53 )
		--Group by v.VisnID;
		
		select DISTINCT
			v.Name , 
			'Comprehensive Evaluation - To be Scheduled or Pending Contact' as Groups,
			'Initial Positive Screens tracked for Comprehensive Evaluation' as Category,
			 p.PATIENT_ID
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			--INNER JOIN
            --FactAmbEnc AS f WITH (nolock) 
            --ON f.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			AND
			(rd.STD_HEALTHFACTOR_ID = 63 )
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(v.Name = @FacilityID)
			
			--AND 
			--r.REFERRAL_ID IN  
			--(
			--	select r2.REFERRAL_ID from dbo.REFERRAL r2(nolock)join dbo.REFERRAL_DETAIL rd2 (nolock) 
			--	on r2.REFERRAL_ID = rd2.REFERRAL_ID
			--	INNER JOIN
			--	viewFacilitiesByVisn AS v2 
			--	ON r2.STD_INSTITUTION_ID = v2.institution_id
			--	where 
			--	(v2.VisnID = @VisnID) 
			--	AND
			--	rd2.STD_HEALTHFACTOR_ID = 54
		 --   )
	
		
		IF @@ROWCOUNT = 0
			INSERT INTO @FacilitySummary
							(FacilityID,Groups,Category,Summary1)
						VALUES     
							(
							@FacilityID
							,'Comprehensive Evaluation - To be Scheduled or Pending Contact'
							,'Initial Positive Screens tracked for Comprehensive Evaluation'
							,0
							)
		
		-- Comprehensive Evaluation not Completed

		Insert @FacilitySummary (FacilityID,Groups,Category,Summary2)
	    
		select DISTINCT
			v.Name , 
			'Comprehensive Evaluation - To be Scheduled or Pending Contact' as Groups,
			' .. Comprehensive Evaluations not Completed' as Category,
			r.REFERRAL_ID 
		FROM         
			REFERRAL AS r WITH (nolock) 
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			--INNER JOIN
			--FactAmbEnc AS f WITH (nolock) 
            --ON f.PATIENT_ID = p.PATIENT_ID 
            INNER JOIN
            viewFacilitiesByVisn AS v 
            ON r.STD_INSTITUTION_ID = v.institution_id
			INNER JOIN REFERRAL_DETAIL rd (nolock)
			ON r.REFERRAL_ID = rd.REFERRAL_ID
			--INNER JOIN WKF_CASE wfc
			--ON r.REFERRAL_ID = wfc.REFERRAL_ID
			--INNER JOIN TBI_TRACKING tt (nolock)
			--on wfc.WKF_CASE_ID = tt.WKF_CASE_ID
			--join dbo.WKF_CASE_ACTIVITY wca (nolock)
			--on wfc.WKF_CASE_ID = wca.WKF_CASE_ID
		
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(r.STD_REGISTRY_ID = 2)
			AND 
			(r.STD_REFERRALSTS_ID <> 3)
			AND
			(rd.STD_HEALTHFACTOR_ID = 63)
			AND 
			(v.VisnID = @VisnID) 
			AND 
			(v.Name = @FacilityID)
			
		

		IF @@ROWCOUNT = 0
			INSERT INTO @FacilitySummary
							(FacilityID,Groups,Category,Summary2)
						VALUES     
							(
							@FacilityID
							,'Comprehensive Evaluation - To be Scheduled or Pending Contact'
							,' .. Comprehensive Evaluations not Completed'
							,0
							)

		-------------------------------
		-- In Process Appointment Scheduled

		Insert @FacilitySummary (FacilityID,Groups,Category,Summary3)
	    
		--select 
		--	v.VisnID , 
		--	'Comprehensive Evaluation - To be Scheduled or Pending Contact' as Groups,
		--	' .... In Process Appointment Scheduled' as Category,
		--	count(DISTINCT r.REFERRAL_ID) as Summar3 
		--from dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
		--on r.PATIENT_ID = p.PATIENT_ID
		----join FactAmbEnc f (nolock) 
		----on f.PATIENT_ID = p.PATIENT_ID
		--join REFERRAL_DETAIL rd (nolock)
		--on r.REFERRAL_ID = rd.REFERRAL_ID
		--join dbo.TBI_TRACKING tt (nolock) 
		--on p.PATIENT_ID = tt.PATIENT_ID
		--join dbo.viewFacilitiesByVisn v
		--on r.STD_INSTITUTION_ID = v.institution_id
		--join dbo.WKF_CASE wc (nolock)
		--on p.PATIENT_ID = wc.PATIENT_ID
		--join dbo.WKF_CASE_ACTIVITY wca (nolock)
		--on wc.WKF_CASE_ID = wca.WKF_CASE_ID

		--where p.OEF_OIF_IND = 1
		--and r.STD_REGISTRY_ID = 2
		--and v.VisnID = @VisnID
		--and wca.STD_TBISCHEDULESTS_ID in (2,3)
		--group by v.VisnID;
		
		SELECT  DISTINCT   
			v.Name, 
			'Comprehensive Evaluation - To be Scheduled or Pending Contact' AS Groups, 
			' .... In Process Appointment Scheduled' AS Category, 
            r.REFERRAL_ID
		FROM         
			WKF_CASE_ACTIVITY AS wca WITH (nolock) 
			INNER JOIN
			WKF_CASE AS wc WITH (nolock) 
			ON wca.WKF_CASE_ID = wc.WKF_CASE_ID 
			INNER JOIN
			REFERRAL AS r WITH (nolock) 
			ON wc.REFERRAL_ID = r.REFERRAL_ID
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			INNER JOIN
			REFERRAL_DETAIL AS rd WITH (nolock) 
			ON r.REFERRAL_ID = rd.REFERRAL_ID 
			INNER JOIN
			viewFacilitiesByVisn AS v 
			ON r.STD_INSTITUTION_ID = v.institution_id 
			INNER JOIN
			TBI.TBI_TRACKING AS tt WITH (nolock) 
			ON wc.WKF_CASE_ID = tt.WKF_CASE_ID
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(r.STD_REGISTRY_ID = 2) 
			AND 
			(rd.STD_HEALTHFACTOR_ID = 63) 
			AND 
            (wca.TBI_EVALUATION_SCHEDULE_DATE IS NOT NULL) 
            AND 
            (wca.STD_TBIEVALDELAYTYPE_ID NOT IN (1, 2)) 
            AND 
            (r.STD_REFERRALSTS_ID <> 3)
            AND 
			(v.VisnID = @VisnID) 
			AND 
			(v.Name = @FacilityID)
			AND wca.ARCHIVED_FLAG = 0 --Added per bug tracker #1539
			
		

		IF @@ROWCOUNT = 0
			INSERT INTO @FacilitySummary
							(FacilityID,Groups,Category,Summary3)
						VALUES     
							(
							@FacilityID
							,'Comprehensive Evaluation - To be Scheduled or Pending Contact'
							,' .... In Process Appointment Scheduled'
							,0
							)

		-------------------------------
		-- Unable to Complete Comprehensive Evaluation

		Insert @FacilitySummary (FacilityID,Groups,Category,Summary3)
	    
		--select 
		--	v.VisnID , 
		--	'Comprehensive Evaluation - To be Scheduled or Pending Contact' as Groups,
		--	' .... Unable to Complete Comprehensive Evaluation' as Category,
		--	count(p.PATIENT_ID) as Summary3  
		--from dbo.REFERRAL r (nolock) join dbo.PATIENT p (nolock)
		--on r.PATIENT_ID = p.PATIENT_ID
		--join FactAmbEnc f (nolock) 
		--on f.PATIENT_ID = p.PATIENT_ID
		--join REFERRAL_DETAIL rd (nolock)
		--on r.REFERRAL_ID = rd.REFERRAL_ID
		--join dbo.TBI_TRACKING tt (nolock) 
		--on p.PATIENT_ID = tt.PATIENT_ID
		--	join dbo.viewFacilitiesByVisn v
		--	on r.STD_INSTITUTION_ID = v.institution_id
		--	join dbo.WKF_CASE wc (nolock)
		--	on p.PATIENT_ID = wc.PATIENT_ID
		--	join dbo.WKF_CASE_ACTIVITY wca (nolock)
		--	on wc.WKF_CASE_ID = wca.WKF_CASE_ID

		--	where p.OEF_OIF_IND = 1
		--	and r.STD_REGISTRY_ID = 2
		--	and v.VisnID = @VisnID
		--	and wca.STD_TBISCHEDULESTS_ID in (4,5)
		--	group by v.VisnID;

		select distinct
			v.Name , 
			'Comprehensive Evaluation - To be Scheduled or Pending Contact' as Groups,
			' .... Unable to Complete Comprehensive Evaluation' as Category,
			p.PATIENT_ID
		FROM         
			WKF_CASE_ACTIVITY AS wca WITH (nolock) 
			INNER JOIN
			WKF_CASE AS wc 
			ON wca.WKF_CASE_ID = wc.WKF_CASE_ID 
			INNER JOIN
			REFERRAL AS r WITH (nolock) 
			ON wc.REFERRAL_ID = r.REFERRAL_ID
			INNER JOIN
			PATIENT AS p WITH (nolock) 
			ON r.PATIENT_ID = p.PATIENT_ID 
			INNER JOIN
			REFERRAL_DETAIL AS rd WITH (nolock) 
			ON r.REFERRAL_ID = rd.REFERRAL_ID 
			INNER JOIN
			viewFacilitiesByVisn AS v 
			ON r.STD_INSTITUTION_ID = v.institution_id 
			INNER JOIN
			TBI.TBI_TRACKING AS tt WITH (nolock) 
			ON wc.WKF_CASE_ID = tt.WKF_CASE_ID
			INNER JOIN
			(			SELECT     WKF_CASE.WKF_CASE_ID, WKF_CASE.REFERRAL_ID, 
						CASE WHEN ThreeNoShows.WKF_CASE_ID IS NULL THEN 0 ELSE 1 END as ThreeNoShows 
						FROM         (SELECT     WKF_CASE_ID
									   FROM          WKF_CASE_ACTIVITY AS wca2
									   WHERE      (STD_TBIEVALDELAYTYPE_ID IN (1, 2))
									   GROUP BY WKF_CASE_ID
									   HAVING      (COUNT(*) = 3)) AS ThreeNoShows 
						RIGHT OUTER JOIN
						WKF_CASE 
						ON ThreeNoShows.WKF_CASE_ID = WKF_CASE.WKF_CASE_ID) wcNoShow
			ON wc.WKF_CASE_ID = wcNoShow.WKF_CASE_ID
			
		WHERE     
			(p.OEF_OIF_IND = 1) 
			AND 
			(r.STD_REGISTRY_ID = 2) 
			AND 
			(rd.STD_HEALTHFACTOR_ID = 63) 
			AND 
            (r.STD_REFERRALSTS_ID = 3) 
            AND
            (
            wca.STD_TBISCHEDULESTS_ID in (1,4,5)
            OR 
            wcNoShow.ThreeNoShows = 1
            )
            AND wca.ARCHIVED_FLAG = 0 --Added per bug tracker #1539 
            AND 
			(v.VisnID = @VisnID) 
			AND 
			(v.Name = @FacilityID)
			
		

		IF @@ROWCOUNT = 0
			INSERT INTO @FacilitySummary
							(FacilityID,Groups,Category,Summary3)
						VALUES     
							(
							@FacilityID
							,'Comprehensive Evaluation - To be Scheduled or Pending Contact'
							,' .... Unable to Complete Comprehensive Evaluation'
							,0
							)



		
Select * from @FacilitySummary


End Try	
Begin catch
	Return
End Catch

END

	/* SET NOCOUNT ON */
	RETURN



GO

/****** Object:  StoredProcedure [dbo].[EFRDataExportFragmentForm]    Script Date: 01/16/2012 14:23:31 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



CREATE PROCEDURE [dbo].[EFRDataExportFragmentForm]
	/*
	(
	@parameter1 int = 5,
	@parameter2 datatype OUTPUT
	)
	*/
AS
	/* SET NOCOUNT ON */
SELECT     WKF_CASE.REFERRAL_ID, PATIENT.SSN, PATIENT.PATIENT_ICN, PATIENT.LAST_NAME, PATIENT.FIRST_NAME, PATIENT.MIDDLE_NAME, 
                      WKF_CASE_ACTIVITY.WKF_CASE_ID AS WORKFLOW_ID, 
                      EFR.QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM.WKF_CASE_ACTIVITY_ID AS FORM_ID, 
                      EFR.QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM.Fragment_1_Location, 
                      EFR.QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM.Fragment_2_Location, 
                      EFR.QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM.Fragment_3_Location, CONVERT(varchar, 
                      EFR.QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM.Date_Fragment_Removal, 101) AS Date_Fragment_Removal, 
                      EFR.QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM.Duty_Location_Injury_Occurred, 
                      EFR.QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM.Other_Location_Injury_Occurred, 
                      EFR.QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM.Name_Referring_VAMC AS FORM_VAMC_NAME, 
                      SUBSTRING(EFR.QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM.Name_Referring_VAMC,PATINDEX('%(%',EFR.QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM.Name_Referring_VAMC)+1,(PATINDEX('%)%',EFR.QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM.Name_Referring_VAMC)-2)) AS FORM_VAMC_NUMBER,
                      EFR.QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM.Referring_VAMC_Street_Address1 AS VAMC_Street_Adress1, 
                      EFR.QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM.Referring_VAMC_Street_Address2 AS VAMC_Street_Adress2, 
                      EFR.QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM.Referring_VAMC_Street_Address3 AS VAMC_Street_Adress3, 
                      EFR.QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM.Referring_VAMC_City AS VAMC_City, 
                      EFR.QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM.Referring_VAMC_State AS VAMC_State, 
                      EFR.QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM.Referring_VAMC_PostalCode AS VAMC_PostalCode, 
                      EFR.QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM.Referring_VAMC_ZipPlus4 AS VAMC_ZipPlus4, 
                      EFR.QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM.Referring_VAMC_Country AS VAMC_Country, 
                      EFR.QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM.Referring_Provider_Name AS Provider_Name, 
                      EFR.QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM.Provider_Pager_Number AS Provider_Pager_Number, 
                      EFR.QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM.Provider_Telephone_Number AS Provider_Telephone_Number, 
                      EFR.QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM.Provider_Fax_Number AS Provider_Fax_Number, 
                      EFR.QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM.Referring_Facility_Contact_Name AS VAMC_Contact_Name, 
                      EFR.QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM.Referring_Facility_Contact_Phone AS VAMC_Contact_Phone, 
                      EFR.QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM.Referring_VAMC_MailCode AS VAMC_MailCode
FROM         EFR.QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM INNER JOIN
                      WKF_CASE_ACTIVITY ON 
                      EFR.QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM.WKF_CASE_ACTIVITY_ID = WKF_CASE_ACTIVITY.WKF_CASE_ACTIVITY_ID INNER JOIN
                      WKF_CASE ON WKF_CASE_ACTIVITY.WKF_CASE_ID = WKF_CASE.WKF_CASE_ID INNER JOIN
                      PATIENT ON WKF_CASE.PATIENT_ID = PATIENT.PATIENT_ID
WHERE     (WKF_CASE_ACTIVITY.STD_WKFACTIVITYSTS_ID = 2) 
		   AND (WKF_CASE_ACTIVITY.ARCHIVED_FLAG = 0) --Added per bug tracker #1539

GO

/****** Object:  StoredProcedure [dbo].[EFRDataExportBioQuestionnaire]    Script Date: 01/16/2012 14:23:31 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



CREATE PROCEDURE [dbo].[EFRDataExportBioQuestionnaire]
	/*
	(
	@parameter1 int = 5,
	@parameter2 datatype OUTPUT
	)
	*/
AS
	/* SET NOCOUNT ON */
SELECT     WC.REFERRAL_ID, P.SSN, P.PATIENT_ICN, P.LAST_NAME, P.FIRST_NAME, P.MIDDLE_NAME, 
                      W.WKF_CASE_ID AS WORKFLOW_ID, 
                      K.WKF_CASE_ACTIVITY_ID AS QUESTIONNAIRE_ID,
                      
                      K.VAMC_Name AS QUESTIONNAIRE_VAMC_NAME, 
                      QUESTIONNAIRE_VAMC_NUMBER=case when PATINDEX('%(%',K.VAMC_Name)>0 and PATINDEX('%)%',K.VAMC_Name)>3 then SUBSTRING(K.VAMC_Name,PATINDEX('%(%',K.VAMC_Name)+1,(PATINDEX('%)%',K.VAMC_Name)-2))
                                                                       else ''
                                                                   end,
                      K.VAMC_Street_Address1, 
                      K.VAMC_Street_Address2, 
                      K.VAMC_Street_Address3, 
                      K.VAMC_City, 
                      K.VAMC_State, 
                      K.VAMC_PostalCiode AS VAMC_PostalCode, 
                      K.VAMC_ZipPlus4, 
                      K.VAMC_Country, CONVERT(varchar, 
                      K.Form_Complete_Date, 101) AS Form_Complete_Date, 
                      K.Branch_of_Services AS Branch_Of_Service, 
                      K.Injury_Geographical_Location, 
                      K.Injury_Geographical_Location_other, 
                      K.Injury_City AS Injury_City_Iraq, 
                      K.Injury_Month, 
                      K.Injury_Day, 
                      K.Injury_Year, 
                      K.Who_Referred_You, 
                      K.Who_Referred_You_Other, 
                      K.Bullet_Injury_Ind, 
                      K.Blast_Explosion_Ind, 
                      K.Distance_from_Explosion_Meter, 
                      K.Injured_on_Vehicle_Ind, 
                      K.Injured_by_OtherSource_Desc, CONVERT(int, 
                      K.Injured_by_IED_FLAG) AS Injured_by_IED_FLAG, CONVERT(int, 
                      K.Injured_by_RPG_FLAG) AS Injured_by_RPG_FLAG, CONVERT(int, 
                      K.Injured_by_LandMine_FLAG) AS Injured_by_LandMine_FLAG, CONVERT(int, 
                      K.Injured_by_Grenade_FLAG) AS Injured_by_Grenade_FLAG, CONVERT(int, 
                      K.Injured_by_EnemyFire_FLAG) AS Injured_by_EnemyFire_FLAG, CONVERT(int, 
                      K.Injured_by_FriendlyFire_FLAG) AS Injured_by_FriendlyFire_FLAG, CONVERT(int, 
                      K.Injured_by_UnknownSource_FLAG) AS Injured_by_UnknownSource_FLAG, 
                      CONVERT(int, K.Injured_by_OtherSource_FLAG) AS Injured_by_OtherSource_FLAG,
                      CONVERT(int, K.Injury_Back_Head) AS Injury_Back_Head, CONVERT(int, 
                      K.Injury_Back_Neck) AS Injury_Back_Neck, CONVERT(int, 
                      K.Injury_Upper_Back) AS Injury_Upper_Back, CONVERT(int, 
                      K.Injury_Lower_Back) AS Injury_Lower_Back, CONVERT(int, 
                      K.Injury_Buttocks) AS Injury_Buttocks, CONVERT(int, 
                      K.Injury_Front_Head) AS Injury_Front_Head, CONVERT(int, 
                      K.Injury_Front_Neck) AS Injury_Front_Neck, CONVERT(int, 
                      K.Injury_Chest) AS Injury_Chest, CONVERT(int, 
                      K.Injury_Abdomen) AS Injury_Abdomen, CONVERT(int, 
                      K.Injury_Groin_Pelvis) AS Injury_Groin_Pelvis, CONVERT(int, 
                      K.Injury_Left_Shoulder) AS Injury_Left_Shoulder, CONVERT(int, 
                      K.Injury_Left_Upper_Arm) AS Injury_Left_Upper_Arm, CONVERT(int, 
                      K.Injury_Left_Lower_Arm) AS Injury_Left_Lower_Arm, CONVERT(int, 
                      K.Injury_Left_Hand_Wrist_Fingers) AS Injury_Left_Hand_Wrist_Fingers, 
                      CONVERT(int, K.Injury_Left_Upper_Leg_Thigh) AS Injury_Left_Upper_Leg_Thigh, 
                      CONVERT(int, K.Injury_Left_Knee) AS Injury_Left_Knee, CONVERT(int, 
                      K.Injury_Left_Lower_Leg) AS Injury_Left_Lower_Leg, CONVERT(int, 
                      K.Injury_Left_Ankle) AS Injury_Left_Ankle, CONVERT(int, 
                      K.Injury_Left_Foot_Toes) AS Injury_Left_Foot_Toes, CONVERT(int, 
                      K.Injury_Right_Shoulder) AS Injury_Right_Shoulder, CONVERT(int, 
                      K.Injury_Right_Upper_Arm) AS Injury_Right_Upper_Arm, CONVERT(int, 
                      K.Injury_Right_Lower_Arm) AS Injury_Right_Lower_Arm, CONVERT(int, 
                      K.Injury_Right_Hand_Wrist_Fingers) AS Injury_Right_Hand_Wrist_Fingers, 
                      CONVERT(int, K.Injury_Right_Upper_Leg_Thigh) 
                      AS Injury_Right_Upper_Leg_Thigh, CONVERT(int, K.Injury_Right_Knee) 
                      AS Injury_Right_Knee, CONVERT(int, K.Injury_Right_Lower_Leg) 
                      AS Injury_Right_Lower_Leg, CONVERT(int, K.Injury_Right_Ankle) 
                      AS Injury_Right_Ankle, CONVERT(int, K.Injury_Right_Foot_Toes) 
                      AS Injury_Right_Foot_Toes, K.Shrapnel_Frag_Bullet_Surgery_Ind, 
                      K.Send_to_Lab_Analysis_Ind, 
                      K.Fragment_Remains_inPatient_Ind, CONVERT(int, 
                      K.Remain_in_Back_Head) AS Remain_in_Back_Head, CONVERT(int, 
                      K.Remain_in_Back_Neck) AS Remain_in_Back_Neck, CONVERT(int, 
                      K.Remain_in_Upper_Back) AS Remain_in_Upper_Back, CONVERT(int, 
                      K.Remain_in_Lower_Back) AS Remain_in_Lower_Back, CONVERT(int, 
                      K.Remain_in_Buttocks) AS Remain_in_Buttocks, CONVERT(int, 
                      K.Remain_in_Front_Head) AS Remain_in_Front_Head, CONVERT(int, 
                      K.Remain_in_Front_Neck) AS Remain_in_Front_Neck, CONVERT(int, 
                      K.Remain_in_Chest) AS Remain_in_Chest, CONVERT(int, 
                      K.Remain_in_Abdomen) AS Remain_in_Abdomen, CONVERT(int, 
                      K.Remain_in_Groin_Pelvis) AS Remain_in_Groin_Pelvis, CONVERT(int, 
                      K.Remain_in_Left_Shoulder) AS Remain_in_Left_Shoulder, CONVERT(int, 
                      K.Remain_in_Left_Upper_Arm) AS Remain_in_Left_Upper_Arm, CONVERT(int, 
                      K.Remain_in_Left_Lower_Arm) AS Remain_in_Left_Lower_Arm, CONVERT(int, 
                      K.Remain_in_Left_Hand_Wrist_Fingers) AS Remain_in_Left_Hand_Wrist_Fingers, 
                      CONVERT(int, K.Remain_in_Left_Upper_Leg_Thigh) 
                      AS Remain_in_Left_Upper_Leg_Thigh, CONVERT(int, K.Remain_in_Left_Knee) 
                      AS Remain_in_Left_Knee, CONVERT(int, K.Remain_in_Left_Lower_Leg) 
                      AS Remain_in_Left_Lower_Leg, CONVERT(int, K.Remain_in_Left_Ankle) 
                      AS Remain_in_Left_Ankle, CONVERT(int, K.Remain_in_Left_Foot_Toes) 
                      AS Remain_in_Left_Foot_Toes, CONVERT(int, K.Remain_in_Right_Shoulder) 
                      AS Remain_in_Right_Shoulder, CONVERT(int, K.Remain_in_Right_Upper_Arm) 
                      AS Remain_in_Right_Upper_Arm, CONVERT(int, K.Remain_in_Right_Lower_Arm) 
                      AS Remain_in_Right_Lower_Arm, CONVERT(int, 
                      K.Remain_in_Right_Hand_Wrist_Fingers) 
                      AS Remain_in_Right_Hand_Wrist_Fingers, CONVERT(int, 
                      K.Remain_in_Right_Upper_Leg_Thigh) AS Remain_in_Right_Upper_Leg_Thigh, 
                      CONVERT(int, K.Remain_in_Right_Knee) AS Remain_in_Right_Knee, 
                      CONVERT(int, K.Remain_in_Right_Lower_Leg) AS Remain_in_Right_Lower_Leg, 
                      CONVERT(int, K.Remain_in_Right_Ankle) AS Remain_in_Right_Ankle, 
                      CONVERT(int, K.Remain_in_Right_Foot_Toes) AS Remain_in_Right_Foot_Toes, 
                      CONVERT(int, K.TREATLOCAT_FIELD) AS TREATLOCAT_FIELD, CONVERT(int, 
                      K.TREATLOCAT_SUPPORTHOSP) AS TREATLOCAT_SUPPORTHOSP, CONVERT(int, 
                      K.TREATLOCAT_GERMANY) AS TREATLOCAT_GERMANY, CONVERT(int, 
                      K.TREATLOCAT_FACILITY) AS TREATLOCAT_US_FACILITY, CONVERT(int, 
                      K.TREATLOCAT_MEDCENTER) AS TREATLOCAT_MEDCENTER, 
                      K.TREATLOCAT_FIELD_Where, 
                      K.TREATLOCAT_SUPPORTHOSP_Where, 
                      K.TREATLOCAT_FACILITY_Where AS TREATLOCAT_US_FACILITY_WHERE, 
                      K.TREATLOCAT_MEDCENTER_Where, 
                      K.Other_Foreign_Material_Ind, 
                      K.Other_Foreign_Material_Desc, 
                      K.Other_Foreign_Material_DescLoca, 
                      K.Shrapnel_In_Body_Ind, 
                      K.Shrapnel_In_Body_Desc, 
                      K.Shrapnel_In_Body_DescLoca, 
                      K.Urine_Collection_Ind, CONVERT(varchar, 
                      K.Date_Urine_Collected, 101) AS Date_Urine_Collected
FROM         WKF_CASE_ACTIVITY W INNER JOIN
                      WKF_CASE WC ON W.WKF_CASE_ID = WC.WKF_CASE_ID INNER JOIN
                      EFR.QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT  K ON 
                      W.WKF_CASE_ACTIVITY_ID = K.WKF_CASE_ACTIVITY_ID INNER
                       JOIN
                      PATIENT  P ON WC.PATIENT_ID = P.PATIENT_ID
WHERE     (w.STD_WKFACTIVITYSTS_ID = 2)
			AND (W.ARCHIVED_FLAG = 0) --Added per bug tracker #1539



GO

/****** Object:  StoredProcedure [dbo].[EFRDataExportBioInterpretation]    Script Date: 01/16/2012 14:23:32 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



CREATE PROCEDURE [dbo].[EFRDataExportBioInterpretation]
	/*
	(
	@parameter1 int = 5,
	@parameter2 datatype OUTPUT
	)
	*/
AS
	/* SET NOCOUNT ON */
	SELECT     REFERRAL.REFERRAL_ID, PATIENT.SSN, PATIENT.PATIENT_ICN, PATIENT.LAST_NAME, PATIENT.FIRST_NAME, PATIENT.MIDDLE_NAME, 
                      WKF_CASE.WKF_CASE_ID AS WORKFLOW_ID, EFR.SPECIMEN_ANALYSIS.SPECIMEN_ANALYSIS_ID AS ANALYSIS_ID, 
                      EFR.STD_TEST_NAME.NAME AS TEST_NAME, EFR.ANALYSIS_DETAIL.ANALYTE_NAME, EFR.ANALYSIS_DETAIL.TEFSC_REFERENCE_RANGE, 
                      EFR.STD_UNITS.NAME AS TEFSC_REFERENCE_RANGE_UNIT, CONVERT(int, EFR.ANALYSIS_DETAIL.TEFSC_ABOVE_REFERENCE_RANGE) 
                      AS TEFSC_ABOVE_REFERENCE_RANGE
FROM         WKF_CASE_ACTIVITY INNER JOIN
                      EFR.SPECIMEN_ANALYSIS ON WKF_CASE_ACTIVITY.WKF_CASE_ACTIVITY_ID = EFR.SPECIMEN_ANALYSIS.WKF_CASE_ACTIVITY_ID INNER JOIN
                      EFR.ANALYSIS_DETAIL ON EFR.SPECIMEN_ANALYSIS.SPECIMEN_ANALYSIS_ID = EFR.ANALYSIS_DETAIL.SPECIMEN_ANALYSIS_ID INNER JOIN
                      EFR.STD_TEST_NAME ON EFR.ANALYSIS_DETAIL.STD_TEST_NAME_ID = EFR.STD_TEST_NAME.ID INNER JOIN
                      EFR.STD_UNITS ON EFR.ANALYSIS_DETAIL.TEFSC_REFERENCE_RANGE_UNIT_ID = EFR.STD_UNITS.ID INNER JOIN
                      WKF_CASE ON WKF_CASE_ACTIVITY.WKF_CASE_ID = WKF_CASE.WKF_CASE_ID INNER JOIN
                      REFERRAL ON WKF_CASE.REFERRAL_ID = REFERRAL.REFERRAL_ID INNER JOIN
                      PATIENT ON REFERRAL.PATIENT_ID = PATIENT.PATIENT_ID
WHERE     (WKF_CASE_ACTIVITY.WKF_CASE_ID IN
                          (SELECT     WKF_CASE_1.WKF_CASE_ID
                            FROM          WKF_CASE_ACTIVITY AS WKF_CASE_ACTIVITY_1 INNER JOIN
                                                   WKF_CASE AS WKF_CASE_1 ON WKF_CASE_ACTIVITY_1.WKF_CASE_ID = WKF_CASE_1.WKF_CASE_ID INNER JOIN
                                                   REFERRAL AS REFERRAL_1 ON WKF_CASE_1.REFERRAL_ID = REFERRAL_1.REFERRAL_ID
                            WHERE      (REFERRAL_1.STD_REGISTRY_ID = 1) AND (WKF_CASE_ACTIVITY_1.STD_WKFACTIVITYSTS_ID = 10) AND 
                                                   (WKF_CASE_1.STD_WKFCASETYPE_ID = 3))) AND (WKF_CASE_ACTIVITY.STD_WKFACTIVITYTYPE_ID = 4) AND 
                      (EFR.ANALYSIS_DETAIL.STD_TEST_NAME_ID = 4) 
                      AND (WKF_CASE_ACTIVITY.ARCHIVED_FLAG = 0) --Added per bug tracker #1539
ORDER BY PATIENT.LAST_NAME, PATIENT.FIRST_NAME, ANALYSIS_ID DESC


GO



begin

  Insert into [dbo].[DatabaseChangeLog]
      ([MajorReleaseNumber]
       , [MinorReleaseNumber]
       , [PointReleaseNumber]
       , [Hotfix]
       , [ScriptName]
       , [ScriptDescription]
       , [TargetRegistry]
       , [DateApplied])
  Values
      ('05'
       ,'00'
       ,'007'
       ,0
       ,'DatabaseScript_trckr_1539.sql'
       ,'Added ARCHIVED_FLAG = 0 into sps when stored procedure select data from wfk_case_activity table.'
       ,'EFR'
      ,GETDATE())

End






