

--Vina Naik
--EFR Bug tracker #1577.
--Fixing how Inelegibles Referrals and Acceptables Referrals are Handled by AutoTriage'

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AutoTriageReferrals_Accept]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[AutoTriageReferrals_Accept]
GO

CREATE PROCEDURE [dbo].[AutoTriageReferrals_Accept] (@RecordsProcessed int OUTPUT)
AS
BEGIN

  SET @RecordsProcessed = 0
  
 --12/20/2011 Modified dbo.CalcRiskCategory function

  CREATE TABLE #AcceptReferrals(ReferralID int, PatientID int)

  INSERT INTO #AcceptReferrals(ReferralID, PatientID)
  SELECT r.Referral_ID, r.Patient_ID
  FROM Referral r LEFT JOIN vwEFRHealthFactorsByReferral_Helper v ON r.Referral_ID = v.Referral_ID
   LEFT JOIN (SELECT Patient_ID FROM Referral WHERE STD_Registry_ID = 1 AND STD_ReferralSTS_ID <> 4 AND Duplicate_Flag = 0 AND COMMENT_TEXT IS NULL) AS dup ON r.Patient_ID = dup.Patient_ID 
  WHERE r.STD_ReferralSTS_ID = 4 
  AND r.STD_Registry_ID = 1
  AND dbo.CalcRiskCategory(v.HF_BLAST_EXPLOSION_INJURY, v.HF_BULLET_INJURY, v.HF_FRAGMENTS_IN_BODY, v.HF_FRAGMENTS_ON_RADIOGRAPH, v.HF_FRAGMENTS_REMOVED_IN_SURGERY,v.Referral_ID) < 12
  AND dup.Patient_ID is NULL

  -- *** remove referrals with no dups against triaged referrals but patient ID appears more than once in new queue ***
  DELETE FROM #AcceptReferrals
  FROM #AcceptReferrals a INNER JOIN (SELECT PatientID FROM #AcceptReferrals GROUP BY PatientID HAVING count(*) > 1) as b ON a.PatientID = b.PatientID
  
  --12/07/2011 Added code to
  --Process only the certain number of records and delete rest of the records from #AcceptReferrals table.
  --Number of records = value of AcceptMax column in EFR.SystemParameters table.
  
	CREATE TABLE #ProcessAcceptReferrals
	(ReferralID INT, PatientID INT)

	DECLARE @Number INT
	DECLARE @Statement NVARCHAR(500)

	SELECT  @Number = AcceptMax FROM EFR.SystemParameters

	SET @Statement = 'SELECT TOP ' + CONVERT(VARCHAR,@Number)+  ' * FROM #AcceptReferrals'
	
	INSERT INTO #ProcessAcceptReferrals
	EXEC sp_executesql @Statement

	DELETE A
	--SELECT A.*
	FROM #AcceptReferrals A
			LEFT JOIN #ProcessAcceptReferrals P ON A.ReferralID = P.ReferralID AND 
							 A.PatientID = P.PatientID 
	WHERE	P.ReferralID IS NULL AND
			P.PatientID IS NULL 
  
  BEGIN TRANSACTION AcceptNewReferrals

  BEGIN TRY

    INSERT INTO WKF_CASE(PATIENT_ID, STD_WKFCASESTS_ID, STD_WKFCASETYPE_ID, REFERRAL_ID, PARENT_CASE_ID, CASE_NUMBER, CASE_START_DATE, CASE_DUE_DATE, CREATEDBY, CREATED, UPDATEDBY, UPDATED)
    SELECT PatientID, 2, 3, ReferralID, NULL, '', getdate(), NULL, 'AutoTriage', getdate(), 'AutoTriage', getdate() 
    FROM #AcceptReferrals

    UPDATE REFERRAL 
    SET STD_ReferralSTS_ID = 5, Review_By = 'AutoTriage', Review_Date = getdate(), Updated = getdate(), UpdatedBy = 'AutoTriage' 
    FROM REFERRAL r INNER JOIN #AcceptReferrals p ON r.Referral_ID = p.ReferralID

    COMMIT TRANSACTION AcceptNewReferrals

    SELECT @RecordsProcessed = count(*) FROM #AcceptReferrals

  END TRY

  BEGIN CATCH

    ROLLBACK TRANSACTION AcceptNewReferrals

  END CATCH 

  DROP TABLE #AcceptReferrals

END

GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AutoTriageReferrals_Duplicates]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[AutoTriageReferrals_Duplicates]
GO

CREATE PROCEDURE [dbo].[AutoTriageReferrals_Duplicates] (@RecordsProcessed int OUTPUT)
AS
BEGIN

  --DECLARE @CTR int

  SET @RecordsProcessed = 0
  
  --12/07/2011 Added code to process only the number of records.
  --Number of records = value of DuplicateMax column in EFR.SystemParameters table.
  
  --02/14/2012 Added code to update Ineligible referral to duplicate referral when we
  --receive eligible referral for the patient.
  
  CREATE TABLE #ProcessIneligibleReferrals
  (ReferralID INT)
  
  --DECLARE @Num INT
  DECLARE @SQL NVARCHAR(500)

  --SELECT  @Number = DuplicateMax FROM EFR.SystemParameters

  SET @SQL = 'SELECT DISTINCT r.Referral_ID FROM Referral r 
  INNER JOIN (SELECT Patient_ID FROM Referral WHERE STD_Registry_ID = 1 AND STD_ReferralSTS_ID <> 4 AND Duplicate_Flag = 0 AND COMMENT_TEXT IS NULL) AS dup ON r.Patient_ID = dup.Patient_ID 
  WHERE r.STD_ReferralSTS_ID = 9 
  AND r.STD_Registry_ID = 1
  AND r.Duplicate_Flag = 0'
   
  INSERT INTO #ProcessIneligibleReferrals
  EXEC sp_executesql @SQL
  
  --SELECT * FROM #ProcessIneligibleReferrals
  
 BEGIN TRANSACTION DupReferrals
 
 BEGIN TRY	
 
  UPDATE REFERRAL 
  SET STD_ReferralSTS_ID = 9, Review_By = 'AutoTriage', Review_Date = getdate(), Comment_Text = 'Duplicate', Duplicate_Flag = 1, Updated = getdate(), UpdatedBy = 'AutoTriage' 
  FROM #ProcessIneligibleReferrals P
  JOIN Referral r ON P.ReferralID = R.referral_ID
  INNER JOIN (SELECT Patient_ID FROM Referral WHERE STD_Registry_ID = 1 AND STD_ReferralSTS_ID <> 4 AND Duplicate_Flag = 0 AND COMMENT_TEXT IS NULL) AS dup ON r.Patient_ID = dup.Patient_ID 
  WHERE r.STD_ReferralSTS_ID = 9 
  AND r.STD_Registry_ID = 1
  AND r.Duplicate_Flag = 0
  
 SELECT @RecordsProcessed = COUNT(*) FROM #ProcessIneligibleReferrals
  
  CREATE TABLE #ProcessDupReferrals
  (ReferralID INT)
  
  DECLARE @Number INT
  DECLARE @Statement NVARCHAR(500)

  SELECT  @Number = DuplicateMax FROM EFR.SystemParameters
  
  SELECT  @Number = @Number - @RecordsProcessed

  SET @Statement = 'SELECT TOP ' + CONVERT(VARCHAR,@Number)+  
  ' r.Referral_ID FROM Referral r 
  INNER JOIN (SELECT Patient_ID FROM Referral WHERE STD_Registry_ID = 1 AND STD_ReferralSTS_ID <> 4 AND Duplicate_Flag = 0) AS dup ON r.Patient_ID = dup.Patient_ID 
  WHERE r.STD_ReferralSTS_ID = 4 
  AND r.STD_Registry_ID = 1
  -- AND r.Duplicate_Flag = 0'
   
  INSERT INTO #ProcessDupReferrals
  EXEC sp_executesql @Statement
 
  --12/09/2011 updated following update statement to SET STD_ReferralSTS_ID equal to 9 instead of 8
  
  UPDATE REFERRAL 
  SET STD_ReferralSTS_ID = 9, Review_By = 'AutoTriage', Review_Date = getdate(), Comment_Text = 'Duplicate', Duplicate_Flag = 1, Updated = getdate(), UpdatedBy = 'AutoTriage' 
  FROM #ProcessDupReferrals P
  JOIN Referral r ON P.ReferralID = R.referral_ID
  INNER JOIN (SELECT Patient_ID FROM Referral WHERE STD_Registry_ID = 1 AND STD_ReferralSTS_ID <> 4 AND Duplicate_Flag = 0) AS dup ON r.Patient_ID = dup.Patient_ID 
  WHERE r.STD_ReferralSTS_ID = 4 
  AND r.STD_Registry_ID = 1
  -- AND r.Duplicate_Flag = 0
  
 COMMIT TRANSACTION DupReferrals
 
  --SET @RecordsProcessed = @CTR
 
SELECT @RecordsProcessed = @RecordsProcessed + COUNT(*) FROM #ProcessDupReferrals
  
 END TRY

  BEGIN CATCH

    ROLLBACK TRANSACTION DupReferrals

  END CATCH 
  
  DROP TABLE #ProcessDupReferrals
  DROP TABLE #ProcessIneligibleReferrals

END

GO

begin
INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('05'
           ,'00'
           ,'006'
           ,0
           ,'Bug tracker #1577'
           ,'Fixing how Inelegibles and Acceptables are Handled by AutoTriage'
           ,'EFR'
           ,GETDATE())
end




