
--Create triggers on V5_Registry

IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[EFR].[TRG_ANALYSIS_DETAIL_H]'))
DROP TRIGGER [EFR].[TRG_ANALYSIS_DETAIL_H]
GO
Create trigger [EFR].[TRG_ANALYSIS_DETAIL_H] on [EFR].[ANALYSIS_DETAIL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [EFR].[ANALYSIS_DETAIL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ANALYSIS_DETAIL_ID]
, [FRAGMENT_ANALYSIS_ID]
, [SPECIMEN_ANALYSIS_ID]
, [STD_ANALYSISMETHOD_ID]
, [STD_FRAGMENT_ANALYSIS_TYPE_ID]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [TEST_NAME]
, [ANALYTE_NAME]
, [ANALYSIS_METHOD_NAME]
, [RESULT_TEXT]
, [RESULT_UNIT_ID]
, [LAB_REFERENCE_RANGE]
, [LAB_ABOVE_REFERENCE_RANGE]
, [LAB_REFERENCE_RANGE_UNIT_ID]
, [TEFSC_ABOVE_REFERENCE_RANGE]
, [TEFSC_REFERENCE_RANGE]
, [TEFSC_REFERENCE_RANGE_UNIT_ID]
, [CUSTOM_RANGE_NUMBER]
, [CUSTOM_INDICATOR_NUMBER]
, [EVAL_COMMENT_TEXT]
, [OTHER_COMMENT_TEXT]
, [CAS_NUMBER]
, [SITE_CODE]
, [OTHER_ANALYTETYPE_NAME]
, [STD_ANALYTETYPE_ID]
, [STD_TEST_NAME_ID]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ANALYSIS_DETAIL_ID]
, [FRAGMENT_ANALYSIS_ID]
, [SPECIMEN_ANALYSIS_ID]
, [STD_ANALYSISMETHOD_ID]
, [STD_FRAGMENT_ANALYSIS_TYPE_ID]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [TEST_NAME]
, [ANALYTE_NAME]
, [ANALYSIS_METHOD_NAME]
, [RESULT_TEXT]
, [RESULT_UNIT_ID]
, [LAB_REFERENCE_RANGE]
, [LAB_ABOVE_REFERENCE_RANGE]
, [LAB_REFERENCE_RANGE_UNIT_ID]
, [TEFSC_ABOVE_REFERENCE_RANGE]
, [TEFSC_REFERENCE_RANGE]
, [TEFSC_REFERENCE_RANGE_UNIT_ID]
, [CUSTOM_RANGE_NUMBER]
, [CUSTOM_INDICATOR_NUMBER]
, [EVAL_COMMENT_TEXT]
, [OTHER_COMMENT_TEXT]
, [CAS_NUMBER]
, [SITE_CODE]
, [OTHER_ANALYTETYPE_NAME]
, [STD_ANALYTETYPE_ID]
, [STD_TEST_NAME_ID]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[EFR].[TRG_ANALYSIS_DETAIL_DEL_H]'))
DROP TRIGGER [EFR].[TRG_ANALYSIS_DETAIL_DEL_H]
go
CREATE TRIGGER  [EFR].[TRG_ANALYSIS_DETAIL_DEL_H]
on  [EFR].[ANALYSIS_DETAIL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [EFR].[ANALYSIS_DETAIL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ANALYSIS_DETAIL_ID]
, [FRAGMENT_ANALYSIS_ID]
, [SPECIMEN_ANALYSIS_ID]
, [STD_ANALYSISMETHOD_ID]
, [STD_FRAGMENT_ANALYSIS_TYPE_ID]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [TEST_NAME]
, [ANALYTE_NAME]
, [ANALYSIS_METHOD_NAME]
, [RESULT_TEXT]
, [RESULT_UNIT_ID]
, [LAB_REFERENCE_RANGE]
, [LAB_ABOVE_REFERENCE_RANGE]
, [LAB_REFERENCE_RANGE_UNIT_ID]
, [TEFSC_ABOVE_REFERENCE_RANGE]
, [TEFSC_REFERENCE_RANGE]
, [TEFSC_REFERENCE_RANGE_UNIT_ID]
, [CUSTOM_RANGE_NUMBER]
, [CUSTOM_INDICATOR_NUMBER]
, [EVAL_COMMENT_TEXT]
, [OTHER_COMMENT_TEXT]
, [CAS_NUMBER]
, [SITE_CODE]
, [OTHER_ANALYTETYPE_NAME]
, [STD_ANALYTETYPE_ID]
, [STD_TEST_NAME_ID]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ANALYSIS_DETAIL_ID]
, [FRAGMENT_ANALYSIS_ID]
, [SPECIMEN_ANALYSIS_ID]
, [STD_ANALYSISMETHOD_ID]
, [STD_FRAGMENT_ANALYSIS_TYPE_ID]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [TEST_NAME]
, [ANALYTE_NAME]
, [ANALYSIS_METHOD_NAME]
, [RESULT_TEXT]
, [RESULT_UNIT_ID]
, [LAB_REFERENCE_RANGE]
, [LAB_ABOVE_REFERENCE_RANGE]
, [LAB_REFERENCE_RANGE_UNIT_ID]
, [TEFSC_ABOVE_REFERENCE_RANGE]
, [TEFSC_REFERENCE_RANGE]
, [TEFSC_REFERENCE_RANGE_UNIT_ID]
, [CUSTOM_RANGE_NUMBER]
, [CUSTOM_INDICATOR_NUMBER]
, [EVAL_COMMENT_TEXT]
, [OTHER_COMMENT_TEXT]
, [CAS_NUMBER]
, [SITE_CODE]
, [OTHER_ANALYTETYPE_NAME]
, [STD_ANALYTETYPE_ID]
, [STD_TEST_NAME_ID]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[EFR].[TRG_CLINICAL_DETAIL_H]'))
DROP TRIGGER [EFR].[TRG_CLINICAL_DETAIL_H]
GO
Create trigger [EFR].[TRG_CLINICAL_DETAIL_H] on [EFR].[CLINICAL_DETAIL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [EFR].[CLINICAL_DETAIL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [CLINICAL_DETAIL_ID]
, [PATIENT_ID]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [CLINICAL_DETAIL_ID]
, [PATIENT_ID]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[EFR].[TRG_CLINICAL_DETAIL_DEL_H]'))
DROP TRIGGER [EFR].[TRG_CLINICAL_DETAIL_DEL_H]
go
CREATE TRIGGER  [EFR].[TRG_CLINICAL_DETAIL_DEL_H]
on  [EFR].[CLINICAL_DETAIL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [EFR].[CLINICAL_DETAIL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [CLINICAL_DETAIL_ID]
, [PATIENT_ID]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [CLINICAL_DETAIL_ID]
, [PATIENT_ID]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[EFR].[TRG_CONTACT_LOG_H]'))
DROP TRIGGER [EFR].[TRG_CONTACT_LOG_H]
GO
Create trigger [EFR].[TRG_CONTACT_LOG_H] on [EFR].[CONTACT_LOG]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [EFR].[CONTACT_LOG_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [CONTACT_LOG_ID]
, [REFERRAL_ID]
, [CONTACT_DATE]
, [CONTACT_METHOD_TEXT]
, [CONTACT_FIRST_NAME]
, [CONTACT_LAST_NAME]
, [CONTACT_PHONE]
, [CONTACT_EMAIL]
, [CONTACT_ADDR1]
, [CONTACT_ADDR2]
, [CONTACT_ADDR3]
, [CONTACT_STATE]
, [CONTACT_CITY]
, [CONTACT_POSTAL]
, [CONTACT_ZIPPLUS4]
, [CONTACT_COUNTRY]
, [CONTACT_REASON_TEXT]
, [CONTACT_MESSAGE_TEXT]
, [TELEMEDICINE_PROVIDER_FLAG]
, [TELEMEDICINE_PATIENT_FLAG]
, [INPATIENT_EVAL_RECOM_FLAG]
, [INPATIENT_EVAL_DATE]
, [FOLLOWUP_REQUIRED_FLAG]
, [FOLLOWUP_REQUIRED_DATE]
, [FOLLOWUP_COMPL_DATE]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [DATE_REMIND_ME_ON]
, [FOLLOWUP_REASON_TEXT]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [CONTACT_LOG_ID]
, [REFERRAL_ID]
, [CONTACT_DATE]
, [CONTACT_METHOD_TEXT]
, [CONTACT_FIRST_NAME]
, [CONTACT_LAST_NAME]
, [CONTACT_PHONE]
, [CONTACT_EMAIL]
, [CONTACT_ADDR1]
, [CONTACT_ADDR2]
, [CONTACT_ADDR3]
, [CONTACT_STATE]
, [CONTACT_CITY]
, [CONTACT_POSTAL]
, [CONTACT_ZIPPLUS4]
, [CONTACT_COUNTRY]
, [CONTACT_REASON_TEXT]
, [CONTACT_MESSAGE_TEXT]
, [TELEMEDICINE_PROVIDER_FLAG]
, [TELEMEDICINE_PATIENT_FLAG]
, [INPATIENT_EVAL_RECOM_FLAG]
, [INPATIENT_EVAL_DATE]
, [FOLLOWUP_REQUIRED_FLAG]
, [FOLLOWUP_REQUIRED_DATE]
, [FOLLOWUP_COMPL_DATE]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [DATE_REMIND_ME_ON]
, [FOLLOWUP_REASON_TEXT]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[EFR].[TRG_CONTACT_LOG_DEL_H]'))
DROP TRIGGER [EFR].[TRG_CONTACT_LOG_DEL_H]
go
CREATE TRIGGER  [EFR].[TRG_CONTACT_LOG_DEL_H]
on  [EFR].[CONTACT_LOG] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [EFR].[CONTACT_LOG_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [CONTACT_LOG_ID]
, [REFERRAL_ID]
, [CONTACT_DATE]
, [CONTACT_METHOD_TEXT]
, [CONTACT_FIRST_NAME]
, [CONTACT_LAST_NAME]
, [CONTACT_PHONE]
, [CONTACT_EMAIL]
, [CONTACT_ADDR1]
, [CONTACT_ADDR2]
, [CONTACT_ADDR3]
, [CONTACT_STATE]
, [CONTACT_CITY]
, [CONTACT_POSTAL]
, [CONTACT_ZIPPLUS4]
, [CONTACT_COUNTRY]
, [CONTACT_REASON_TEXT]
, [CONTACT_MESSAGE_TEXT]
, [TELEMEDICINE_PROVIDER_FLAG]
, [TELEMEDICINE_PATIENT_FLAG]
, [INPATIENT_EVAL_RECOM_FLAG]
, [INPATIENT_EVAL_DATE]
, [FOLLOWUP_REQUIRED_FLAG]
, [FOLLOWUP_REQUIRED_DATE]
, [FOLLOWUP_COMPL_DATE]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [DATE_REMIND_ME_ON]
, [FOLLOWUP_REASON_TEXT]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [CONTACT_LOG_ID]
, [REFERRAL_ID]
, [CONTACT_DATE]
, [CONTACT_METHOD_TEXT]
, [CONTACT_FIRST_NAME]
, [CONTACT_LAST_NAME]
, [CONTACT_PHONE]
, [CONTACT_EMAIL]
, [CONTACT_ADDR1]
, [CONTACT_ADDR2]
, [CONTACT_ADDR3]
, [CONTACT_STATE]
, [CONTACT_CITY]
, [CONTACT_POSTAL]
, [CONTACT_ZIPPLUS4]
, [CONTACT_COUNTRY]
, [CONTACT_REASON_TEXT]
, [CONTACT_MESSAGE_TEXT]
, [TELEMEDICINE_PROVIDER_FLAG]
, [TELEMEDICINE_PATIENT_FLAG]
, [INPATIENT_EVAL_RECOM_FLAG]
, [INPATIENT_EVAL_DATE]
, [FOLLOWUP_REQUIRED_FLAG]
, [FOLLOWUP_REQUIRED_DATE]
, [FOLLOWUP_COMPL_DATE]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [DATE_REMIND_ME_ON]
, [FOLLOWUP_REASON_TEXT]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[EFR].[TRG_EFR_ICD9_DIAG_H]'))
DROP TRIGGER [EFR].[TRG_EFR_ICD9_DIAG_H]
GO
Create trigger [EFR].[TRG_EFR_ICD9_DIAG_H] on [EFR].[EFR_ICD9_DIAG]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [EFR].[EFR_ICD9_DIAG_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ICD9DIS_ID]
, [PATIENT_ID]
, [ICD9_CODE]
, [ICD9_CODE_NAME]
, [PRIMARYDIAG]
, [ENCOUNTER_DATETIME]
, [STD_INSTITUTION_ID]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ICD9DIS_ID]
, [PATIENT_ID]
, [ICD9_CODE]
, [ICD9_CODE_NAME]
, [PRIMARYDIAG]
, [ENCOUNTER_DATETIME]
, [STD_INSTITUTION_ID]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[EFR].[TRG_EFR_ICD9_DIAG_DEL_H]'))
DROP TRIGGER [EFR].[TRG_EFR_ICD9_DIAG_DEL_H]
go
CREATE TRIGGER  [EFR].[TRG_EFR_ICD9_DIAG_DEL_H]
on  [EFR].[EFR_ICD9_DIAG] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [EFR].[EFR_ICD9_DIAG_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ICD9DIS_ID]
, [PATIENT_ID]
, [ICD9_CODE]
, [ICD9_CODE_NAME]
, [PRIMARYDIAG]
, [ENCOUNTER_DATETIME]
, [STD_INSTITUTION_ID]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ICD9DIS_ID]
, [PATIENT_ID]
, [ICD9_CODE]
, [ICD9_CODE_NAME]
, [PRIMARYDIAG]
, [ENCOUNTER_DATETIME]
, [STD_INSTITUTION_ID]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[EFR].[TRG_EHR_LAB_TEST_H]'))
DROP TRIGGER [EFR].[TRG_EHR_LAB_TEST_H]
GO
Create trigger [EFR].[TRG_EHR_LAB_TEST_H] on [EFR].[EHR_LAB_TEST]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [EFR].[EHR_LAB_TEST_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [EHR_TEST_ID]
, [EHR_ID]
, [TEST_NAME]
, [UNITS]
, [LOW_REF]
, [HIGH_REF]
, [COMMENT]
, [VALUE]
, [BOUNDARY_STATUS]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [EHR_TEST_ID]
, [EHR_ID]
, [TEST_NAME]
, [UNITS]
, [LOW_REF]
, [HIGH_REF]
, [COMMENT]
, [VALUE]
, [BOUNDARY_STATUS]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[EFR].[TRG_EHR_LAB_TEST_DEL_H]'))
DROP TRIGGER [EFR].[TRG_EHR_LAB_TEST_DEL_H]
go
CREATE TRIGGER  [EFR].[TRG_EHR_LAB_TEST_DEL_H]
on  [EFR].[EHR_LAB_TEST] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [EFR].[EHR_LAB_TEST_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [EHR_TEST_ID]
, [EHR_ID]
, [TEST_NAME]
, [UNITS]
, [LOW_REF]
, [HIGH_REF]
, [COMMENT]
, [VALUE]
, [BOUNDARY_STATUS]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [EHR_TEST_ID]
, [EHR_ID]
, [TEST_NAME]
, [UNITS]
, [LOW_REF]
, [HIGH_REF]
, [COMMENT]
, [VALUE]
, [BOUNDARY_STATUS]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_ACUITY_EXAM_DTL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_ACUITY_EXAM_DTL_H]
GO
Create trigger [DVEIR].[TRG_ER_ACUITY_EXAM_DTL_H] on [DVEIR].[ER_ACUITY_EXAM_DTL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_ACUITY_EXAM_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_ACUITY_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_ACUITY_MTHD_ID]
, [STD_ER_ACUITY_TYPE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [VISION_CORRECTED_IND]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [Pinhole]
, [IsPinhole]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ER_ACUITY_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_ACUITY_MTHD_ID]
, [STD_ER_ACUITY_TYPE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [VISION_CORRECTED_IND]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [Pinhole]
, [IsPinhole]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[DVEIR].[TRG_ER_ACUITY_EXAM_DTL_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_ACUITY_EXAM_DTL_DEL_H]
go
CREATE TRIGGER  [DVEIR].[TRG_ER_ACUITY_EXAM_DTL_DEL_H]
on  [DVEIR].[ER_ACUITY_EXAM_DTL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_ACUITY_EXAM_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_ACUITY_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_ACUITY_MTHD_ID]
, [STD_ER_ACUITY_TYPE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [VISION_CORRECTED_IND]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [Pinhole]
, [IsPinhole]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ER_ACUITY_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_ACUITY_MTHD_ID]
, [STD_ER_ACUITY_TYPE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [VISION_CORRECTED_IND]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [Pinhole]
, [IsPinhole]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_ANGLE_RECESSION_EXAM_DTL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_ANGLE_RECESSION_EXAM_DTL_H]
GO
Create trigger [DVEIR].[TRG_ER_ANGLE_RECESSION_EXAM_DTL_H] on [DVEIR].[ER_ANGLE_RECESSION_EXAM_DTL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_ANGLE_RECESSION_EXAM_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_ANGLE_RECESSION_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_ANGLE_RECESSION_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ER_ANGLE_RECESSION_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_ANGLE_RECESSION_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[DVEIR].[TRG_ER_ANGLE_RECESSION_EXAM_DTL_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_ANGLE_RECESSION_EXAM_DTL_DEL_H]
go
CREATE TRIGGER  [DVEIR].[TRG_ER_ANGLE_RECESSION_EXAM_DTL_DEL_H]
on  [DVEIR].[ER_ANGLE_RECESSION_EXAM_DTL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_ANGLE_RECESSION_EXAM_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_ANGLE_RECESSION_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_ANGLE_RECESSION_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ER_ANGLE_RECESSION_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_ANGLE_RECESSION_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_ANTERIOR_EXAM_DTL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_ANTERIOR_EXAM_DTL_H]
GO
Create trigger [DVEIR].[TRG_ER_ANTERIOR_EXAM_DTL_H] on [DVEIR].[ER_ANTERIOR_EXAM_DTL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_ANTERIOR_EXAM_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_ANTERIOR_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_ANTERIOR_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ER_ANTERIOR_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_ANTERIOR_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[DVEIR].[TRG_ER_ANTERIOR_EXAM_DTL_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_ANTERIOR_EXAM_DTL_DEL_H]
go
CREATE TRIGGER  [DVEIR].[TRG_ER_ANTERIOR_EXAM_DTL_DEL_H]
on  [DVEIR].[ER_ANTERIOR_EXAM_DTL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_ANTERIOR_EXAM_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_ANTERIOR_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_ANTERIOR_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ER_ANTERIOR_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_ANTERIOR_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_BROW_EXAM_DTL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_BROW_EXAM_DTL_H]
GO
Create trigger [DVEIR].[TRG_ER_BROW_EXAM_DTL_H] on [DVEIR].[ER_BROW_EXAM_DTL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_BROW_EXAM_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_BROW_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_BROW_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ER_BROW_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_BROW_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[DVEIR].[TRG_ER_BROW_EXAM_DTL_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_BROW_EXAM_DTL_DEL_H]
go
CREATE TRIGGER  [DVEIR].[TRG_ER_BROW_EXAM_DTL_DEL_H]
on  [DVEIR].[ER_BROW_EXAM_DTL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_BROW_EXAM_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_BROW_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_BROW_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ER_BROW_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_BROW_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_CORNEA_EXAM_DTL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_CORNEA_EXAM_DTL_H]
GO
Create trigger [DVEIR].[TRG_ER_CORNEA_EXAM_DTL_H] on [DVEIR].[ER_CORNEA_EXAM_DTL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_CORNEA_EXAM_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_CORNEA_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_CORNEA_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ER_CORNEA_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_CORNEA_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[DVEIR].[TRG_ER_CORNEA_EXAM_DTL_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_CORNEA_EXAM_DTL_DEL_H]
go
CREATE TRIGGER  [DVEIR].[TRG_ER_CORNEA_EXAM_DTL_DEL_H]
on  [DVEIR].[ER_CORNEA_EXAM_DTL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_CORNEA_EXAM_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_CORNEA_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_CORNEA_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ER_CORNEA_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_CORNEA_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_DIAG_DTL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_DIAG_DTL_H]
GO
Create trigger [DVEIR].[TRG_ER_DIAG_DTL_H] on [DVEIR].[ER_DIAG_DTL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_DIAG_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_DIAG_DTL_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ER_ENCOUNTER_ID]
, [CODE]
, [DESCRIPTION_TEXT]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ER_DIAG_DTL_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ER_ENCOUNTER_ID]
, [CODE]
, [DESCRIPTION_TEXT]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[DVEIR].[TRG_ER_DIAG_DTL_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_DIAG_DTL_DEL_H]
go
CREATE TRIGGER  [DVEIR].[TRG_ER_DIAG_DTL_DEL_H]
on  [DVEIR].[ER_DIAG_DTL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_DIAG_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_DIAG_DTL_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ER_ENCOUNTER_ID]
, [CODE]
, [DESCRIPTION_TEXT]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ER_DIAG_DTL_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ER_ENCOUNTER_ID]
, [CODE]
, [DESCRIPTION_TEXT]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_DIAG_DTL_ETL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_DIAG_DTL_ETL_H]
GO
Create trigger [DVEIR].[TRG_ER_DIAG_DTL_ETL_H] on [DVEIR].[ER_DIAG_DTL_ETL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_DIAG_DTL_ETL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_DIAG_DTL_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ER_ENCOUNTER_ID]
, [CODE]
, [DESCRIPTION_TEXT]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ER_DIAG_DTL_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ER_ENCOUNTER_ID]
, [CODE]
, [DESCRIPTION_TEXT]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[DVEIR].[TRG_ER_DIAG_DTL_ETL_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_DIAG_DTL_ETL_DEL_H]
go
CREATE TRIGGER  [DVEIR].[TRG_ER_DIAG_DTL_ETL_DEL_H]
on  [DVEIR].[ER_DIAG_DTL_ETL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_DIAG_DTL_ETL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_DIAG_DTL_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ER_ENCOUNTER_ID]
, [CODE]
, [DESCRIPTION_TEXT]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ER_DIAG_DTL_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ER_ENCOUNTER_ID]
, [CODE]
, [DESCRIPTION_TEXT]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_DISC_EXAM_DTL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_DISC_EXAM_DTL_H]
GO
Create trigger [DVEIR].[TRG_ER_DISC_EXAM_DTL_H] on [DVEIR].[ER_DISC_EXAM_DTL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_DISC_EXAM_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_DISC_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_DISC_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ER_DISC_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_DISC_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[DVEIR].[TRG_ER_DISC_EXAM_DTL_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_DISC_EXAM_DTL_DEL_H]
go
CREATE TRIGGER  [DVEIR].[TRG_ER_DISC_EXAM_DTL_DEL_H]
on  [DVEIR].[ER_DISC_EXAM_DTL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_DISC_EXAM_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_DISC_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_DISC_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ER_DISC_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_DISC_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_ENCOUNTER_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_ENCOUNTER_H]
GO
Create trigger [DVEIR].[TRG_ER_ENCOUNTER_H] on [DVEIR].[ER_ENCOUNTER]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_ENCOUNTER_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_ENCOUNTER_ID]
, [REFERRAL_ID]
, [PROVIDER_ID]
, [STA6A]
, [VISIT_DATE]
, [CHIEF_COMPLAINT_TEXT]
, [TBI_IND]
, [TBI_READ_PRBLM_IND]
, [TBI_DIPLOPIA_IND]
, [TBI_DAZZLING_IND]
, [TBI_PHOTOPHOBIA_IND]
, [OTHER_NEUROLOGICAL_IND]
, [NEUROLOGICAL_COMMENT_TEXT]
, [DIAGNOSIS_SUMMARY_COMMENT_TEXT]
, [PROCEDURE_SUMMARY_COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [CURRENTLY_HOSPITALIZED_IND]
, [TBI_EYE_STRAIN_IND]
, [TBI_BLURRED_VISION_IND]
, [PRIMARYCLINICSTOP]
, [PRIMARYCLINICSTOPDESC]
, [SendTo_DoD_DVEIR_FLAG]
, [Ready_to_Send_to_DVEIR_FLAG]
, [UniqueVHAEncounterIDPrimaryKey]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ER_ENCOUNTER_ID]
, [REFERRAL_ID]
, [PROVIDER_ID]
, [STA6A]
, [VISIT_DATE]
, [CHIEF_COMPLAINT_TEXT]
, [TBI_IND]
, [TBI_READ_PRBLM_IND]
, [TBI_DIPLOPIA_IND]
, [TBI_DAZZLING_IND]
, [TBI_PHOTOPHOBIA_IND]
, [OTHER_NEUROLOGICAL_IND]
, [NEUROLOGICAL_COMMENT_TEXT]
, [DIAGNOSIS_SUMMARY_COMMENT_TEXT]
, [PROCEDURE_SUMMARY_COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [CURRENTLY_HOSPITALIZED_IND]
, [TBI_EYE_STRAIN_IND]
, [TBI_BLURRED_VISION_IND]
, [PRIMARYCLINICSTOP]
, [PRIMARYCLINICSTOPDESC]
, [SendTo_DoD_DVEIR_FLAG]
, [Ready_to_Send_to_DVEIR_FLAG]
, [UniqueVHAEncounterIDPrimaryKey]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[DVEIR].[TRG_ER_ENCOUNTER_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_ENCOUNTER_DEL_H]
go
CREATE TRIGGER  [DVEIR].[TRG_ER_ENCOUNTER_DEL_H]
on  [DVEIR].[ER_ENCOUNTER] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_ENCOUNTER_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_ENCOUNTER_ID]
, [REFERRAL_ID]
, [PROVIDER_ID]
, [STA6A]
, [VISIT_DATE]
, [CHIEF_COMPLAINT_TEXT]
, [TBI_IND]
, [TBI_READ_PRBLM_IND]
, [TBI_DIPLOPIA_IND]
, [TBI_DAZZLING_IND]
, [TBI_PHOTOPHOBIA_IND]
, [OTHER_NEUROLOGICAL_IND]
, [NEUROLOGICAL_COMMENT_TEXT]
, [DIAGNOSIS_SUMMARY_COMMENT_TEXT]
, [PROCEDURE_SUMMARY_COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [CURRENTLY_HOSPITALIZED_IND]
, [TBI_EYE_STRAIN_IND]
, [TBI_BLURRED_VISION_IND]
, [PRIMARYCLINICSTOP]
, [PRIMARYCLINICSTOPDESC]
, [SendTo_DoD_DVEIR_FLAG]
, [Ready_to_Send_to_DVEIR_FLAG]
, [UniqueVHAEncounterIDPrimaryKey]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ER_ENCOUNTER_ID]
, [REFERRAL_ID]
, [PROVIDER_ID]
, [STA6A]
, [VISIT_DATE]
, [CHIEF_COMPLAINT_TEXT]
, [TBI_IND]
, [TBI_READ_PRBLM_IND]
, [TBI_DIPLOPIA_IND]
, [TBI_DAZZLING_IND]
, [TBI_PHOTOPHOBIA_IND]
, [OTHER_NEUROLOGICAL_IND]
, [NEUROLOGICAL_COMMENT_TEXT]
, [DIAGNOSIS_SUMMARY_COMMENT_TEXT]
, [PROCEDURE_SUMMARY_COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [CURRENTLY_HOSPITALIZED_IND]
, [TBI_EYE_STRAIN_IND]
, [TBI_BLURRED_VISION_IND]
, [PRIMARYCLINICSTOP]
, [PRIMARYCLINICSTOPDESC]
, [SendTo_DoD_DVEIR_FLAG]
, [Ready_to_Send_to_DVEIR_FLAG]
, [UniqueVHAEncounterIDPrimaryKey]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_ENCOUNTER_ETL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_ENCOUNTER_ETL_H]
GO
Create trigger [DVEIR].[TRG_ER_ENCOUNTER_ETL_H] on [DVEIR].[ER_ENCOUNTER_ETL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_ENCOUNTER_ETL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_ENCOUNTER_ID]
, [REFERRAL_ID]
, [PROVIDER_ID]
, [STA6A]
, [VISIT_DATE]
, [CHIEF_COMPLAINT_TEXT]
, [TBI_IND]
, [TBI_READ_PRBLM_IND]
, [TBI_DIPLOPIA_IND]
, [TBI_DAZZLING_IND]
, [TBI_PHOTOPHOBIA_IND]
, [OTHER_NEUROLOGICAL_IND]
, [NEUROLOGICAL_COMMENT_TEXT]
, [DIAGNOSIS_SUMMARY_COMMENT_TEXT]
, [PROCEDURE_SUMMARY_COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [CURRENTLY_HOSPITALIZED_IND]
, [TBI_EYE_STRAIN_IND]
, [TBI_BLURRED_VISION_IND]
, [PRIMARYCLINICSTOP]
, [PRIMARYCLINICSTOPDESC]
, [SendTo_DoD_DVEIR_FLAG]
, [Ready_to_Send_to_DVEIR_FLAG]
, [UniqueVHAEncounterIDPrimaryKey]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ER_ENCOUNTER_ID]
, [REFERRAL_ID]
, [PROVIDER_ID]
, [STA6A]
, [VISIT_DATE]
, [CHIEF_COMPLAINT_TEXT]
, [TBI_IND]
, [TBI_READ_PRBLM_IND]
, [TBI_DIPLOPIA_IND]
, [TBI_DAZZLING_IND]
, [TBI_PHOTOPHOBIA_IND]
, [OTHER_NEUROLOGICAL_IND]
, [NEUROLOGICAL_COMMENT_TEXT]
, [DIAGNOSIS_SUMMARY_COMMENT_TEXT]
, [PROCEDURE_SUMMARY_COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [CURRENTLY_HOSPITALIZED_IND]
, [TBI_EYE_STRAIN_IND]
, [TBI_BLURRED_VISION_IND]
, [PRIMARYCLINICSTOP]
, [PRIMARYCLINICSTOPDESC]
, [SendTo_DoD_DVEIR_FLAG]
, [Ready_to_Send_to_DVEIR_FLAG]
, [UniqueVHAEncounterIDPrimaryKey]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[DVEIR].[TRG_ER_ENCOUNTER_ETL_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_ENCOUNTER_ETL_DEL_H]
go
CREATE TRIGGER  [DVEIR].[TRG_ER_ENCOUNTER_ETL_DEL_H]
on  [DVEIR].[ER_ENCOUNTER_ETL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_ENCOUNTER_ETL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_ENCOUNTER_ID]
, [REFERRAL_ID]
, [PROVIDER_ID]
, [STA6A]
, [VISIT_DATE]
, [CHIEF_COMPLAINT_TEXT]
, [TBI_IND]
, [TBI_READ_PRBLM_IND]
, [TBI_DIPLOPIA_IND]
, [TBI_DAZZLING_IND]
, [TBI_PHOTOPHOBIA_IND]
, [OTHER_NEUROLOGICAL_IND]
, [NEUROLOGICAL_COMMENT_TEXT]
, [DIAGNOSIS_SUMMARY_COMMENT_TEXT]
, [PROCEDURE_SUMMARY_COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [CURRENTLY_HOSPITALIZED_IND]
, [TBI_EYE_STRAIN_IND]
, [TBI_BLURRED_VISION_IND]
, [PRIMARYCLINICSTOP]
, [PRIMARYCLINICSTOPDESC]
, [SendTo_DoD_DVEIR_FLAG]
, [Ready_to_Send_to_DVEIR_FLAG]
, [UniqueVHAEncounterIDPrimaryKey]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ER_ENCOUNTER_ID]
, [REFERRAL_ID]
, [PROVIDER_ID]
, [STA6A]
, [VISIT_DATE]
, [CHIEF_COMPLAINT_TEXT]
, [TBI_IND]
, [TBI_READ_PRBLM_IND]
, [TBI_DIPLOPIA_IND]
, [TBI_DAZZLING_IND]
, [TBI_PHOTOPHOBIA_IND]
, [OTHER_NEUROLOGICAL_IND]
, [NEUROLOGICAL_COMMENT_TEXT]
, [DIAGNOSIS_SUMMARY_COMMENT_TEXT]
, [PROCEDURE_SUMMARY_COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [CURRENTLY_HOSPITALIZED_IND]
, [TBI_EYE_STRAIN_IND]
, [TBI_BLURRED_VISION_IND]
, [PRIMARYCLINICSTOP]
, [PRIMARYCLINICSTOPDESC]
, [SendTo_DoD_DVEIR_FLAG]
, [Ready_to_Send_to_DVEIR_FLAG]
, [UniqueVHAEncounterIDPrimaryKey]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_ENCOUNTER_REVIEWCOMMENT_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_ENCOUNTER_REVIEWCOMMENT_H]
GO
Create trigger [DVEIR].[TRG_ER_ENCOUNTER_REVIEWCOMMENT_H] on [DVEIR].[ER_ENCOUNTER_REVIEWCOMMENT]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_ENCOUNTER_REVIEWCOMMENT_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ID]
, [ER_ENCOUNTER_ID]
, [DATE_ENTERED]
, [RESOLVED_FLAG]
, [RESOLVED_BY]
, [DATE_RESOLVED]
, [APPROVED_FLAG]
, [APPROVED_BY]
, [DATE_APPROVED]
, [LOCATIONPAGE]
, [ANCHORid]
, [LOCATION_FRIENDLY_NAME]
, [CREATED]
, [CREATEDBY]
, [UPDATED]
, [UPDATEDBY]
, [COMMENT_TEXT]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ID]
, [ER_ENCOUNTER_ID]
, [DATE_ENTERED]
, [RESOLVED_FLAG]
, [RESOLVED_BY]
, [DATE_RESOLVED]
, [APPROVED_FLAG]
, [APPROVED_BY]
, [DATE_APPROVED]
, [LOCATIONPAGE]
, [ANCHORid]
, [LOCATION_FRIENDLY_NAME]
, [CREATED]
, [CREATEDBY]
, [UPDATED]
, [UPDATEDBY]
, [COMMENT_TEXT]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[DVEIR].[TRG_ER_ENCOUNTER_REVIEWCOMMENT_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_ENCOUNTER_REVIEWCOMMENT_DEL_H]
go
CREATE TRIGGER  [DVEIR].[TRG_ER_ENCOUNTER_REVIEWCOMMENT_DEL_H]
on  [DVEIR].[ER_ENCOUNTER_REVIEWCOMMENT] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_ENCOUNTER_REVIEWCOMMENT_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ID]
, [ER_ENCOUNTER_ID]
, [DATE_ENTERED]
, [RESOLVED_FLAG]
, [RESOLVED_BY]
, [DATE_RESOLVED]
, [APPROVED_FLAG]
, [APPROVED_BY]
, [DATE_APPROVED]
, [LOCATIONPAGE]
, [ANCHORid]
, [LOCATION_FRIENDLY_NAME]
, [CREATED]
, [CREATEDBY]
, [UPDATED]
, [UPDATEDBY]
, [COMMENT_TEXT]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ID]
, [ER_ENCOUNTER_ID]
, [DATE_ENTERED]
, [RESOLVED_FLAG]
, [RESOLVED_BY]
, [DATE_RESOLVED]
, [APPROVED_FLAG]
, [APPROVED_BY]
, [DATE_APPROVED]
, [LOCATIONPAGE]
, [ANCHORid]
, [LOCATION_FRIENDLY_NAME]
, [CREATED]
, [CREATEDBY]
, [UPDATED]
, [UPDATEDBY]
, [COMMENT_TEXT]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_EXAM_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_EXAM_H]
GO
Create trigger [DVEIR].[TRG_ER_EXAM_H] on [DVEIR].[ER_EXAM]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_EXAM_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_EXAM_ID]
, [PATIENT_ID]
, [PATIENT_VISIT_COUNT]
, [LEFT_REFRACTION_NUMBER]
, [RIGHT_REFRACTION_NUMBER]
, [LEFT_COLOR_RESPONSE_NUMBER]
, [RIGHT_COLOR_RESPONSE_NUMBER]
, [LEFT_CONFRONTATION_NUMBER]
, [RIGHT_CONFRONTATION_NUMBER]
, [LEFT_MEAN_DEVIATION_NUMBER]
, [RIGHT_MEAN_DEVIATION_NUMBER]
, [LEFT_STD_DEVIATION_NUMBER]
, [RIGHT_STD_DEVIATION_NUMBER]
, [LEFT_FIXATION_LOSS_NUMBER]
, [RIGHT_FIXATION_LOSS_NUMBER]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [LEFT_SPHERE_NUMBER]
, [RIGHT_SPHERE_NUMBER]
, [LEFT_CYLINDER_NUMBER]
, [RIGHT_CYLINDER_NUMBER]
, [LEFT_MEAN_DEVIATION_COMMENTS]
, [RIGHT_MEAN_DEVIATION_COMMENTS]
, [LEFT_REFRACTION_UNKNOWN_FLAG]
, [RIGHT_REFRACTION_UNKNOWN_FLAG]
, [LEFT_KINETIC_VISUAL_FIELDS_GOLDMAN_COMMENTS]
, [RIGHT_KINETIC_VISUAL_FIELDS_GOLDMAN_COMMENTS]
, [LEFT_CONFRONTATION_PERFORMED]
, [RIGHT_CONFRONTATION_PERFORMED]
, [LEFT_CONFRONTATION_STATUS]
, [RIGHT_CONFRONTATION_STATUS]
, [LEFT_REFERENCE_SCALE]
, [RIGHT_REFERENCE_SCALE]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ER_EXAM_ID]
, [PATIENT_ID]
, [PATIENT_VISIT_COUNT]
, [LEFT_REFRACTION_NUMBER]
, [RIGHT_REFRACTION_NUMBER]
, [LEFT_COLOR_RESPONSE_NUMBER]
, [RIGHT_COLOR_RESPONSE_NUMBER]
, [LEFT_CONFRONTATION_NUMBER]
, [RIGHT_CONFRONTATION_NUMBER]
, [LEFT_MEAN_DEVIATION_NUMBER]
, [RIGHT_MEAN_DEVIATION_NUMBER]
, [LEFT_STD_DEVIATION_NUMBER]
, [RIGHT_STD_DEVIATION_NUMBER]
, [LEFT_FIXATION_LOSS_NUMBER]
, [RIGHT_FIXATION_LOSS_NUMBER]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [LEFT_SPHERE_NUMBER]
, [RIGHT_SPHERE_NUMBER]
, [LEFT_CYLINDER_NUMBER]
, [RIGHT_CYLINDER_NUMBER]
, [LEFT_MEAN_DEVIATION_COMMENTS]
, [RIGHT_MEAN_DEVIATION_COMMENTS]
, [LEFT_REFRACTION_UNKNOWN_FLAG]
, [RIGHT_REFRACTION_UNKNOWN_FLAG]
, [LEFT_KINETIC_VISUAL_FIELDS_GOLDMAN_COMMENTS]
, [RIGHT_KINETIC_VISUAL_FIELDS_GOLDMAN_COMMENTS]
, [LEFT_CONFRONTATION_PERFORMED]
, [RIGHT_CONFRONTATION_PERFORMED]
, [LEFT_CONFRONTATION_STATUS]
, [RIGHT_CONFRONTATION_STATUS]
, [LEFT_REFERENCE_SCALE]
, [RIGHT_REFERENCE_SCALE]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[DVEIR].[TRG_ER_EXAM_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_EXAM_DEL_H]
go
CREATE TRIGGER  [DVEIR].[TRG_ER_EXAM_DEL_H]
on  [DVEIR].[ER_EXAM] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_EXAM_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_EXAM_ID]
, [PATIENT_ID]
, [PATIENT_VISIT_COUNT]
, [LEFT_REFRACTION_NUMBER]
, [RIGHT_REFRACTION_NUMBER]
, [LEFT_COLOR_RESPONSE_NUMBER]
, [RIGHT_COLOR_RESPONSE_NUMBER]
, [LEFT_CONFRONTATION_NUMBER]
, [RIGHT_CONFRONTATION_NUMBER]
, [LEFT_MEAN_DEVIATION_NUMBER]
, [RIGHT_MEAN_DEVIATION_NUMBER]
, [LEFT_STD_DEVIATION_NUMBER]
, [RIGHT_STD_DEVIATION_NUMBER]
, [LEFT_FIXATION_LOSS_NUMBER]
, [RIGHT_FIXATION_LOSS_NUMBER]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [LEFT_SPHERE_NUMBER]
, [RIGHT_SPHERE_NUMBER]
, [LEFT_CYLINDER_NUMBER]
, [RIGHT_CYLINDER_NUMBER]
, [LEFT_MEAN_DEVIATION_COMMENTS]
, [RIGHT_MEAN_DEVIATION_COMMENTS]
, [LEFT_REFRACTION_UNKNOWN_FLAG]
, [RIGHT_REFRACTION_UNKNOWN_FLAG]
, [LEFT_KINETIC_VISUAL_FIELDS_GOLDMAN_COMMENTS]
, [RIGHT_KINETIC_VISUAL_FIELDS_GOLDMAN_COMMENTS]
, [LEFT_CONFRONTATION_PERFORMED]
, [RIGHT_CONFRONTATION_PERFORMED]
, [LEFT_CONFRONTATION_STATUS]
, [RIGHT_CONFRONTATION_STATUS]
, [LEFT_REFERENCE_SCALE]
, [RIGHT_REFERENCE_SCALE]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ER_EXAM_ID]
, [PATIENT_ID]
, [PATIENT_VISIT_COUNT]
, [LEFT_REFRACTION_NUMBER]
, [RIGHT_REFRACTION_NUMBER]
, [LEFT_COLOR_RESPONSE_NUMBER]
, [RIGHT_COLOR_RESPONSE_NUMBER]
, [LEFT_CONFRONTATION_NUMBER]
, [RIGHT_CONFRONTATION_NUMBER]
, [LEFT_MEAN_DEVIATION_NUMBER]
, [RIGHT_MEAN_DEVIATION_NUMBER]
, [LEFT_STD_DEVIATION_NUMBER]
, [RIGHT_STD_DEVIATION_NUMBER]
, [LEFT_FIXATION_LOSS_NUMBER]
, [RIGHT_FIXATION_LOSS_NUMBER]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [LEFT_SPHERE_NUMBER]
, [RIGHT_SPHERE_NUMBER]
, [LEFT_CYLINDER_NUMBER]
, [RIGHT_CYLINDER_NUMBER]
, [LEFT_MEAN_DEVIATION_COMMENTS]
, [RIGHT_MEAN_DEVIATION_COMMENTS]
, [LEFT_REFRACTION_UNKNOWN_FLAG]
, [RIGHT_REFRACTION_UNKNOWN_FLAG]
, [LEFT_KINETIC_VISUAL_FIELDS_GOLDMAN_COMMENTS]
, [RIGHT_KINETIC_VISUAL_FIELDS_GOLDMAN_COMMENTS]
, [LEFT_CONFRONTATION_PERFORMED]
, [RIGHT_CONFRONTATION_PERFORMED]
, [LEFT_CONFRONTATION_STATUS]
, [RIGHT_CONFRONTATION_STATUS]
, [LEFT_REFERENCE_SCALE]
, [RIGHT_REFERENCE_SCALE]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_EXAM_DTL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_EXAM_DTL_H]
GO
Create trigger [DVEIR].[TRG_ER_EXAM_DTL_H] on [DVEIR].[ER_EXAM_DTL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_EXAM_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_EXAM_LOOKUP_ID_CATEGORY]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [COMMENT_NAME]
, [STD_EXAM_LOOKUP_ID_VALUE]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ER_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_EXAM_LOOKUP_ID_CATEGORY]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [COMMENT_NAME]
, [STD_EXAM_LOOKUP_ID_VALUE]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[DVEIR].[TRG_ER_EXAM_DTL_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_EXAM_DTL_DEL_H]
go
CREATE TRIGGER  [DVEIR].[TRG_ER_EXAM_DTL_DEL_H]
on  [DVEIR].[ER_EXAM_DTL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_EXAM_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_EXAM_LOOKUP_ID_CATEGORY]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [COMMENT_NAME]
, [STD_EXAM_LOOKUP_ID_VALUE]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ER_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_EXAM_LOOKUP_ID_CATEGORY]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [COMMENT_NAME]
, [STD_EXAM_LOOKUP_ID_VALUE]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_EXAM_ETL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_EXAM_ETL_H]
GO
Create trigger [DVEIR].[TRG_ER_EXAM_ETL_H] on [DVEIR].[ER_EXAM_ETL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_EXAM_ETL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_EXAM_ID]
, [PATIENT_ID]
, [PATIENT_VISIT_COUNT]
, [LEFT_REFRACTION_NUMBER]
, [RIGHT_REFRACTION_NUMBER]
, [LEFT_COLOR_RESPONSE_NUMBER]
, [RIGHT_COLOR_RESPONSE_NUMBER]
, [LEFT_CONFRONTATION_NUMBER]
, [RIGHT_CONFRONTATION_NUMBER]
, [LEFT_MEAN_DEVIATION_NUMBER]
, [RIGHT_MEAN_DEVIATION_NUMBER]
, [LEFT_STD_DEVIATION_NUMBER]
, [RIGHT_STD_DEVIATION_NUMBER]
, [LEFT_FIXATION_LOSS_NUMBER]
, [RIGHT_FIXATION_LOSS_NUMBER]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [LEFT_SPHERE_NUMBER]
, [RIGHT_SPHERE_NUMBER]
, [LEFT_CYLINDER_NUMBER]
, [RIGHT_CYLINDER_NUMBER]
, [LEFT_MEAN_DEVIATION_COMMENTS]
, [RIGHT_MEAN_DEVIATION_COMMENTS]
, [LEFT_REFRACTION_UNKNOWN_FLAG]
, [RIGHT_REFRACTION_UNKNOWN_FLAG]
, [LEFT_KINETIC_VISUAL_FIELDS_GOLDMAN_COMMENTS]
, [RIGHT_KINETIC_VISUAL_FIELDS_GOLDMAN_COMMENTS]
, [LEFT_CONFRONTATION_PERFORMED]
, [RIGHT_CONFRONTATION_PERFORMED]
, [LEFT_CONFRONTATION_STATUS]
, [RIGHT_CONFRONTATION_STATUS]
, [LEFT_REFERENCE_SCALE]
, [RIGHT_REFERENCE_SCALE]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ER_EXAM_ID]
, [PATIENT_ID]
, [PATIENT_VISIT_COUNT]
, [LEFT_REFRACTION_NUMBER]
, [RIGHT_REFRACTION_NUMBER]
, [LEFT_COLOR_RESPONSE_NUMBER]
, [RIGHT_COLOR_RESPONSE_NUMBER]
, [LEFT_CONFRONTATION_NUMBER]
, [RIGHT_CONFRONTATION_NUMBER]
, [LEFT_MEAN_DEVIATION_NUMBER]
, [RIGHT_MEAN_DEVIATION_NUMBER]
, [LEFT_STD_DEVIATION_NUMBER]
, [RIGHT_STD_DEVIATION_NUMBER]
, [LEFT_FIXATION_LOSS_NUMBER]
, [RIGHT_FIXATION_LOSS_NUMBER]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [LEFT_SPHERE_NUMBER]
, [RIGHT_SPHERE_NUMBER]
, [LEFT_CYLINDER_NUMBER]
, [RIGHT_CYLINDER_NUMBER]
, [LEFT_MEAN_DEVIATION_COMMENTS]
, [RIGHT_MEAN_DEVIATION_COMMENTS]
, [LEFT_REFRACTION_UNKNOWN_FLAG]
, [RIGHT_REFRACTION_UNKNOWN_FLAG]
, [LEFT_KINETIC_VISUAL_FIELDS_GOLDMAN_COMMENTS]
, [RIGHT_KINETIC_VISUAL_FIELDS_GOLDMAN_COMMENTS]
, [LEFT_CONFRONTATION_PERFORMED]
, [RIGHT_CONFRONTATION_PERFORMED]
, [LEFT_CONFRONTATION_STATUS]
, [RIGHT_CONFRONTATION_STATUS]
, [LEFT_REFERENCE_SCALE]
, [RIGHT_REFERENCE_SCALE]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[DVEIR].[TRG_ER_EXAM_ETL_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_EXAM_ETL_DEL_H]
go
CREATE TRIGGER  [DVEIR].[TRG_ER_EXAM_ETL_DEL_H]
on  [DVEIR].[ER_EXAM_ETL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_EXAM_ETL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_EXAM_ID]
, [PATIENT_ID]
, [PATIENT_VISIT_COUNT]
, [LEFT_REFRACTION_NUMBER]
, [RIGHT_REFRACTION_NUMBER]
, [LEFT_COLOR_RESPONSE_NUMBER]
, [RIGHT_COLOR_RESPONSE_NUMBER]
, [LEFT_CONFRONTATION_NUMBER]
, [RIGHT_CONFRONTATION_NUMBER]
, [LEFT_MEAN_DEVIATION_NUMBER]
, [RIGHT_MEAN_DEVIATION_NUMBER]
, [LEFT_STD_DEVIATION_NUMBER]
, [RIGHT_STD_DEVIATION_NUMBER]
, [LEFT_FIXATION_LOSS_NUMBER]
, [RIGHT_FIXATION_LOSS_NUMBER]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [LEFT_SPHERE_NUMBER]
, [RIGHT_SPHERE_NUMBER]
, [LEFT_CYLINDER_NUMBER]
, [RIGHT_CYLINDER_NUMBER]
, [LEFT_MEAN_DEVIATION_COMMENTS]
, [RIGHT_MEAN_DEVIATION_COMMENTS]
, [LEFT_REFRACTION_UNKNOWN_FLAG]
, [RIGHT_REFRACTION_UNKNOWN_FLAG]
, [LEFT_KINETIC_VISUAL_FIELDS_GOLDMAN_COMMENTS]
, [RIGHT_KINETIC_VISUAL_FIELDS_GOLDMAN_COMMENTS]
, [LEFT_CONFRONTATION_PERFORMED]
, [RIGHT_CONFRONTATION_PERFORMED]
, [LEFT_CONFRONTATION_STATUS]
, [RIGHT_CONFRONTATION_STATUS]
, [LEFT_REFERENCE_SCALE]
, [RIGHT_REFERENCE_SCALE]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ER_EXAM_ID]
, [PATIENT_ID]
, [PATIENT_VISIT_COUNT]
, [LEFT_REFRACTION_NUMBER]
, [RIGHT_REFRACTION_NUMBER]
, [LEFT_COLOR_RESPONSE_NUMBER]
, [RIGHT_COLOR_RESPONSE_NUMBER]
, [LEFT_CONFRONTATION_NUMBER]
, [RIGHT_CONFRONTATION_NUMBER]
, [LEFT_MEAN_DEVIATION_NUMBER]
, [RIGHT_MEAN_DEVIATION_NUMBER]
, [LEFT_STD_DEVIATION_NUMBER]
, [RIGHT_STD_DEVIATION_NUMBER]
, [LEFT_FIXATION_LOSS_NUMBER]
, [RIGHT_FIXATION_LOSS_NUMBER]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [LEFT_SPHERE_NUMBER]
, [RIGHT_SPHERE_NUMBER]
, [LEFT_CYLINDER_NUMBER]
, [RIGHT_CYLINDER_NUMBER]
, [LEFT_MEAN_DEVIATION_COMMENTS]
, [RIGHT_MEAN_DEVIATION_COMMENTS]
, [LEFT_REFRACTION_UNKNOWN_FLAG]
, [RIGHT_REFRACTION_UNKNOWN_FLAG]
, [LEFT_KINETIC_VISUAL_FIELDS_GOLDMAN_COMMENTS]
, [RIGHT_KINETIC_VISUAL_FIELDS_GOLDMAN_COMMENTS]
, [LEFT_CONFRONTATION_PERFORMED]
, [RIGHT_CONFRONTATION_PERFORMED]
, [LEFT_CONFRONTATION_STATUS]
, [RIGHT_CONFRONTATION_STATUS]
, [LEFT_REFERENCE_SCALE]
, [RIGHT_REFERENCE_SCALE]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_EYEWEAR_DTL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_EYEWEAR_DTL_H]
GO
Create trigger [DVEIR].[TRG_ER_EYEWEAR_DTL_H] on [DVEIR].[ER_EYEWEAR_DTL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_EYEWEAR_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_EYEWEAR_DTL_ID]
, [ER_INJURY_ID]
, [STD_ER_EYEWEAR_TYPE_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ER_EYEWEAR_DTL_ID]
, [ER_INJURY_ID]
, [STD_ER_EYEWEAR_TYPE_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[DVEIR].[TRG_ER_EYEWEAR_DTL_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_EYEWEAR_DTL_DEL_H]
go
CREATE TRIGGER  [DVEIR].[TRG_ER_EYEWEAR_DTL_DEL_H]
on  [DVEIR].[ER_EYEWEAR_DTL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_EYEWEAR_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_EYEWEAR_DTL_ID]
, [ER_INJURY_ID]
, [STD_ER_EYEWEAR_TYPE_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ER_EYEWEAR_DTL_ID]
, [ER_INJURY_ID]
, [STD_ER_EYEWEAR_TYPE_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_GLOBE_EXAM_DTL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_GLOBE_EXAM_DTL_H]
GO
Create trigger [DVEIR].[TRG_ER_GLOBE_EXAM_DTL_H] on [DVEIR].[ER_GLOBE_EXAM_DTL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_GLOBE_EXAM_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_GLOBE_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_GLOBE_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ER_GLOBE_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_GLOBE_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[DVEIR].[TRG_ER_GLOBE_EXAM_DTL_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_GLOBE_EXAM_DTL_DEL_H]
go
CREATE TRIGGER  [DVEIR].[TRG_ER_GLOBE_EXAM_DTL_DEL_H]
on  [DVEIR].[ER_GLOBE_EXAM_DTL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_GLOBE_EXAM_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_GLOBE_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_GLOBE_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ER_GLOBE_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_GLOBE_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_IMAGING_DTL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_IMAGING_DTL_H]
GO
Create trigger [DVEIR].[TRG_ER_IMAGING_DTL_H] on [DVEIR].[ER_IMAGING_DTL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_IMAGING_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_IMAGING_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_IMG_MTHD_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ER_IMAGING_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_IMG_MTHD_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[DVEIR].[TRG_ER_IMAGING_DTL_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_IMAGING_DTL_DEL_H]
go
CREATE TRIGGER  [DVEIR].[TRG_ER_IMAGING_DTL_DEL_H]
on  [DVEIR].[ER_IMAGING_DTL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_IMAGING_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_IMAGING_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_IMG_MTHD_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ER_IMAGING_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_IMG_MTHD_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_INJURY_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_INJURY_H]
GO
Create trigger [DVEIR].[TRG_ER_INJURY_H] on [DVEIR].[ER_INJURY]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_INJURY_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_INJURY_ID]
, [PATIENT_ID]
, [STD_ER_INJRY_METHOD_ID]
, [STD_ER_INJURY_PLACE_ID]
, [STD_ER_INJURY_TYPE_ID]
, [STD_ER_INJRY_CAUSE_ID]
, [STD_ER_ELAPSED_TIME_ID]
, [INJURY_DATE]
, [INTHEATER_INJRY_IND]
, [WORK_RELATED_IND]
, [WORK_SAFETY_PRESENT_IND]
, [EYE_WEAR_PRESENT_IND]
, [COMBAT_RELATED_INJRY_IND]
, [PPE_DEVICE_PRESENT_IND]
, [DRUG_ALCOHOL_USE_IND]
, [SEATBELT_WORN_IND]
, [AIRBAG_DEPLOYED_IND]
, [EXAM_DATE]
, [CONCOMITANT_TBI_IND]
, [PENETRATING_INJURY_IND]
, [HEAD_TRAUMA_IND]
, [HEAD_TRAUMA_TBI_IND]
, [BLAST_IND]
, [BLAST_TBI_IND]
, [EYE_COMPLAINT_COMMENT_TEXT]
, [INJURY_TYPE_COMMENT_TEXT]
, [INJURY_CAUSE_COMMENT_TEXT]
, [INJURY_PLACE_COMMENT_TEXT]
, [INJURY_GEO_LOCATION_DESCR]
, [GENERAL_COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ER_INJURY_ID]
, [PATIENT_ID]
, [STD_ER_INJRY_METHOD_ID]
, [STD_ER_INJURY_PLACE_ID]
, [STD_ER_INJURY_TYPE_ID]
, [STD_ER_INJRY_CAUSE_ID]
, [STD_ER_ELAPSED_TIME_ID]
, [INJURY_DATE]
, [INTHEATER_INJRY_IND]
, [WORK_RELATED_IND]
, [WORK_SAFETY_PRESENT_IND]
, [EYE_WEAR_PRESENT_IND]
, [COMBAT_RELATED_INJRY_IND]
, [PPE_DEVICE_PRESENT_IND]
, [DRUG_ALCOHOL_USE_IND]
, [SEATBELT_WORN_IND]
, [AIRBAG_DEPLOYED_IND]
, [EXAM_DATE]
, [CONCOMITANT_TBI_IND]
, [PENETRATING_INJURY_IND]
, [HEAD_TRAUMA_IND]
, [HEAD_TRAUMA_TBI_IND]
, [BLAST_IND]
, [BLAST_TBI_IND]
, [EYE_COMPLAINT_COMMENT_TEXT]
, [INJURY_TYPE_COMMENT_TEXT]
, [INJURY_CAUSE_COMMENT_TEXT]
, [INJURY_PLACE_COMMENT_TEXT]
, [INJURY_GEO_LOCATION_DESCR]
, [GENERAL_COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[DVEIR].[TRG_ER_INJURY_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_INJURY_DEL_H]
go
CREATE TRIGGER  [DVEIR].[TRG_ER_INJURY_DEL_H]
on  [DVEIR].[ER_INJURY] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_INJURY_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_INJURY_ID]
, [PATIENT_ID]
, [STD_ER_INJRY_METHOD_ID]
, [STD_ER_INJURY_PLACE_ID]
, [STD_ER_INJURY_TYPE_ID]
, [STD_ER_INJRY_CAUSE_ID]
, [STD_ER_ELAPSED_TIME_ID]
, [INJURY_DATE]
, [INTHEATER_INJRY_IND]
, [WORK_RELATED_IND]
, [WORK_SAFETY_PRESENT_IND]
, [EYE_WEAR_PRESENT_IND]
, [COMBAT_RELATED_INJRY_IND]
, [PPE_DEVICE_PRESENT_IND]
, [DRUG_ALCOHOL_USE_IND]
, [SEATBELT_WORN_IND]
, [AIRBAG_DEPLOYED_IND]
, [EXAM_DATE]
, [CONCOMITANT_TBI_IND]
, [PENETRATING_INJURY_IND]
, [HEAD_TRAUMA_IND]
, [HEAD_TRAUMA_TBI_IND]
, [BLAST_IND]
, [BLAST_TBI_IND]
, [EYE_COMPLAINT_COMMENT_TEXT]
, [INJURY_TYPE_COMMENT_TEXT]
, [INJURY_CAUSE_COMMENT_TEXT]
, [INJURY_PLACE_COMMENT_TEXT]
, [INJURY_GEO_LOCATION_DESCR]
, [GENERAL_COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ER_INJURY_ID]
, [PATIENT_ID]
, [STD_ER_INJRY_METHOD_ID]
, [STD_ER_INJURY_PLACE_ID]
, [STD_ER_INJURY_TYPE_ID]
, [STD_ER_INJRY_CAUSE_ID]
, [STD_ER_ELAPSED_TIME_ID]
, [INJURY_DATE]
, [INTHEATER_INJRY_IND]
, [WORK_RELATED_IND]
, [WORK_SAFETY_PRESENT_IND]
, [EYE_WEAR_PRESENT_IND]
, [COMBAT_RELATED_INJRY_IND]
, [PPE_DEVICE_PRESENT_IND]
, [DRUG_ALCOHOL_USE_IND]
, [SEATBELT_WORN_IND]
, [AIRBAG_DEPLOYED_IND]
, [EXAM_DATE]
, [CONCOMITANT_TBI_IND]
, [PENETRATING_INJURY_IND]
, [HEAD_TRAUMA_IND]
, [HEAD_TRAUMA_TBI_IND]
, [BLAST_IND]
, [BLAST_TBI_IND]
, [EYE_COMPLAINT_COMMENT_TEXT]
, [INJURY_TYPE_COMMENT_TEXT]
, [INJURY_CAUSE_COMMENT_TEXT]
, [INJURY_PLACE_COMMENT_TEXT]
, [INJURY_GEO_LOCATION_DESCR]
, [GENERAL_COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_IRIS_EXAM_DTL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_IRIS_EXAM_DTL_H]
GO
Create trigger [DVEIR].[TRG_ER_IRIS_EXAM_DTL_H] on [DVEIR].[ER_IRIS_EXAM_DTL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_IRIS_EXAM_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_IRIS_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_IRIS_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ER_IRIS_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_IRIS_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[DVEIR].[TRG_ER_IRIS_EXAM_DTL_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_IRIS_EXAM_DTL_DEL_H]
go
CREATE TRIGGER  [DVEIR].[TRG_ER_IRIS_EXAM_DTL_DEL_H]
on  [DVEIR].[ER_IRIS_EXAM_DTL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_IRIS_EXAM_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_IRIS_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_IRIS_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ER_IRIS_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_IRIS_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_LENS_EXAM_DTL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_LENS_EXAM_DTL_H]
GO
Create trigger [DVEIR].[TRG_ER_LENS_EXAM_DTL_H] on [DVEIR].[ER_LENS_EXAM_DTL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_LENS_EXAM_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_LENS_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_LENS_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ER_LENS_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_LENS_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[DVEIR].[TRG_ER_LENS_EXAM_DTL_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_LENS_EXAM_DTL_DEL_H]
go
CREATE TRIGGER  [DVEIR].[TRG_ER_LENS_EXAM_DTL_DEL_H]
on  [DVEIR].[ER_LENS_EXAM_DTL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_LENS_EXAM_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_LENS_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_LENS_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ER_LENS_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_LENS_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_LID_EXAM_DTL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_LID_EXAM_DTL_H]
GO
Create trigger [DVEIR].[TRG_ER_LID_EXAM_DTL_H] on [DVEIR].[ER_LID_EXAM_DTL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_LID_EXAM_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_LID_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_LID_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ER_LID_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_LID_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[DVEIR].[TRG_ER_LID_EXAM_DTL_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_LID_EXAM_DTL_DEL_H]
go
CREATE TRIGGER  [DVEIR].[TRG_ER_LID_EXAM_DTL_DEL_H]
on  [DVEIR].[ER_LID_EXAM_DTL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_LID_EXAM_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_LID_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_LID_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ER_LID_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_LID_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_MISC_EXAM_DTL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_MISC_EXAM_DTL_H]
GO
Create trigger [DVEIR].[TRG_ER_MISC_EXAM_DTL_H] on [DVEIR].[ER_MISC_EXAM_DTL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_MISC_EXAM_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_MISC_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_MISC_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ER_MISC_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_MISC_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[DVEIR].[TRG_ER_MISC_EXAM_DTL_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_MISC_EXAM_DTL_DEL_H]
go
CREATE TRIGGER  [DVEIR].[TRG_ER_MISC_EXAM_DTL_DEL_H]
on  [DVEIR].[ER_MISC_EXAM_DTL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_MISC_EXAM_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_MISC_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_MISC_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ER_MISC_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_MISC_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_MOTILITY_EXAM_DTL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_MOTILITY_EXAM_DTL_H]
GO
Create trigger [DVEIR].[TRG_ER_MOTILITY_EXAM_DTL_H] on [DVEIR].[ER_MOTILITY_EXAM_DTL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_MOTILITY_EXAM_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_MOTILITY_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_MOTILITY_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [COMMENT_NAME]
, [ER_Exam_Lookup_ID]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ER_MOTILITY_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_MOTILITY_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [COMMENT_NAME]
, [ER_Exam_Lookup_ID]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[DVEIR].[TRG_ER_MOTILITY_EXAM_DTL_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_MOTILITY_EXAM_DTL_DEL_H]
go
CREATE TRIGGER  [DVEIR].[TRG_ER_MOTILITY_EXAM_DTL_DEL_H]
on  [DVEIR].[ER_MOTILITY_EXAM_DTL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_MOTILITY_EXAM_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_MOTILITY_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_MOTILITY_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [COMMENT_NAME]
, [ER_Exam_Lookup_ID]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ER_MOTILITY_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_MOTILITY_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [COMMENT_NAME]
, [ER_Exam_Lookup_ID]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_ORBIT_EXAM_DTL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_ORBIT_EXAM_DTL_H]
GO
Create trigger [DVEIR].[TRG_ER_ORBIT_EXAM_DTL_H] on [DVEIR].[ER_ORBIT_EXAM_DTL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_ORBIT_EXAM_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_ORBIT_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_ORBIT_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ER_ORBIT_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_ORBIT_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[DVEIR].[TRG_ER_ORBIT_EXAM_DTL_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_ORBIT_EXAM_DTL_DEL_H]
go
CREATE TRIGGER  [DVEIR].[TRG_ER_ORBIT_EXAM_DTL_DEL_H]
on  [DVEIR].[ER_ORBIT_EXAM_DTL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_ORBIT_EXAM_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_ORBIT_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_ORBIT_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ER_ORBIT_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_ORBIT_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_OUTCOME_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_OUTCOME_H]
GO
Create trigger [DVEIR].[TRG_ER_OUTCOME_H] on [DVEIR].[ER_OUTCOME]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_OUTCOME_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_OUTCOME_ID]
, [PATIENT_ID]
, [STD_ER_VISION_STATUS_ID]
, [DUTY_RETURN_IND]
, [DUTY_RETURN_DSCR]
, [CURRENT_DISABILITY_RATING_NUMB]
, [DISABILITY_RATING_DATE]
, [REHABILITATION_REFERRAL_IND]
, [VFQ_NUMBER]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [STD_ER_VFQ_QUESTIONNAIRE_TYPE_ID]
, [PROSTHETICS_ORDERED_COMMENTS]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ER_OUTCOME_ID]
, [PATIENT_ID]
, [STD_ER_VISION_STATUS_ID]
, [DUTY_RETURN_IND]
, [DUTY_RETURN_DSCR]
, [CURRENT_DISABILITY_RATING_NUMB]
, [DISABILITY_RATING_DATE]
, [REHABILITATION_REFERRAL_IND]
, [VFQ_NUMBER]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [STD_ER_VFQ_QUESTIONNAIRE_TYPE_ID]
, [PROSTHETICS_ORDERED_COMMENTS]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[DVEIR].[TRG_ER_OUTCOME_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_OUTCOME_DEL_H]
go
CREATE TRIGGER  [DVEIR].[TRG_ER_OUTCOME_DEL_H]
on  [DVEIR].[ER_OUTCOME] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_OUTCOME_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_OUTCOME_ID]
, [PATIENT_ID]
, [STD_ER_VISION_STATUS_ID]
, [DUTY_RETURN_IND]
, [DUTY_RETURN_DSCR]
, [CURRENT_DISABILITY_RATING_NUMB]
, [DISABILITY_RATING_DATE]
, [REHABILITATION_REFERRAL_IND]
, [VFQ_NUMBER]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [STD_ER_VFQ_QUESTIONNAIRE_TYPE_ID]
, [PROSTHETICS_ORDERED_COMMENTS]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ER_OUTCOME_ID]
, [PATIENT_ID]
, [STD_ER_VISION_STATUS_ID]
, [DUTY_RETURN_IND]
, [DUTY_RETURN_DSCR]
, [CURRENT_DISABILITY_RATING_NUMB]
, [DISABILITY_RATING_DATE]
, [REHABILITATION_REFERRAL_IND]
, [VFQ_NUMBER]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [STD_ER_VFQ_QUESTIONNAIRE_TYPE_ID]
, [PROSTHETICS_ORDERED_COMMENTS]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_OUTCOME_ETL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_OUTCOME_ETL_H]
GO
Create trigger [DVEIR].[TRG_ER_OUTCOME_ETL_H] on [DVEIR].[ER_OUTCOME_ETL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_OUTCOME_ETL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_OUTCOME_ID]
, [PATIENT_ID]
, [STD_ER_VISION_STATUS_ID]
, [DUTY_RETURN_IND]
, [DUTY_RETURN_DSCR]
, [CURRENT_DISABILITY_RATING_NUMB]
, [DISABILITY_RATING_DATE]
, [REHABILITATION_REFERRAL_IND]
, [VFQ_NUMBER]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [STD_ER_VFQ_QUESTIONNAIRE_TYPE_ID]
, [PROSTHETICS_ORDERED_COMMENTS]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ER_OUTCOME_ID]
, [PATIENT_ID]
, [STD_ER_VISION_STATUS_ID]
, [DUTY_RETURN_IND]
, [DUTY_RETURN_DSCR]
, [CURRENT_DISABILITY_RATING_NUMB]
, [DISABILITY_RATING_DATE]
, [REHABILITATION_REFERRAL_IND]
, [VFQ_NUMBER]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [STD_ER_VFQ_QUESTIONNAIRE_TYPE_ID]
, [PROSTHETICS_ORDERED_COMMENTS]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[DVEIR].[TRG_ER_OUTCOME_ETL_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_OUTCOME_ETL_DEL_H]
go
CREATE TRIGGER  [DVEIR].[TRG_ER_OUTCOME_ETL_DEL_H]
on  [DVEIR].[ER_OUTCOME_ETL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_OUTCOME_ETL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_OUTCOME_ID]
, [PATIENT_ID]
, [STD_ER_VISION_STATUS_ID]
, [DUTY_RETURN_IND]
, [DUTY_RETURN_DSCR]
, [CURRENT_DISABILITY_RATING_NUMB]
, [DISABILITY_RATING_DATE]
, [REHABILITATION_REFERRAL_IND]
, [VFQ_NUMBER]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [STD_ER_VFQ_QUESTIONNAIRE_TYPE_ID]
, [PROSTHETICS_ORDERED_COMMENTS]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ER_OUTCOME_ID]
, [PATIENT_ID]
, [STD_ER_VISION_STATUS_ID]
, [DUTY_RETURN_IND]
, [DUTY_RETURN_DSCR]
, [CURRENT_DISABILITY_RATING_NUMB]
, [DISABILITY_RATING_DATE]
, [REHABILITATION_REFERRAL_IND]
, [VFQ_NUMBER]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [STD_ER_VFQ_QUESTIONNAIRE_TYPE_ID]
, [PROSTHETICS_ORDERED_COMMENTS]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_PPE_DTL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_PPE_DTL_H]
GO
Create trigger [DVEIR].[TRG_ER_PPE_DTL_H] on [DVEIR].[ER_PPE_DTL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_PPE_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_PPE_DTL_ID]
, [ER_INJURY_ID]
, [STD_ER_PPE_DEVICE_TYPE_ID]
, [STD_ER_PPE_STATUS_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ER_PPE_DTL_ID]
, [ER_INJURY_ID]
, [STD_ER_PPE_DEVICE_TYPE_ID]
, [STD_ER_PPE_STATUS_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[DVEIR].[TRG_ER_PPE_DTL_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_PPE_DTL_DEL_H]
go
CREATE TRIGGER  [DVEIR].[TRG_ER_PPE_DTL_DEL_H]
on  [DVEIR].[ER_PPE_DTL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_PPE_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_PPE_DTL_ID]
, [ER_INJURY_ID]
, [STD_ER_PPE_DEVICE_TYPE_ID]
, [STD_ER_PPE_STATUS_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ER_PPE_DTL_ID]
, [ER_INJURY_ID]
, [STD_ER_PPE_DEVICE_TYPE_ID]
, [STD_ER_PPE_STATUS_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_PRE_INJURY_DIAG_DTL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_PRE_INJURY_DIAG_DTL_H]
GO
Create trigger [DVEIR].[TRG_ER_PRE_INJURY_DIAG_DTL_H] on [DVEIR].[ER_PRE_INJURY_DIAG_DTL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_PRE_INJURY_DIAG_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_PRE_INJURY_DIAG_DTL_ID]
, [ER_HISTORY_ID]
, [STD_ER_ICD9_CODE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [DIAGNOSIS_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ER_PRE_INJURY_DIAG_DTL_ID]
, [ER_HISTORY_ID]
, [STD_ER_ICD9_CODE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [DIAGNOSIS_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[DVEIR].[TRG_ER_PRE_INJURY_DIAG_DTL_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_PRE_INJURY_DIAG_DTL_DEL_H]
go
CREATE TRIGGER  [DVEIR].[TRG_ER_PRE_INJURY_DIAG_DTL_DEL_H]
on  [DVEIR].[ER_PRE_INJURY_DIAG_DTL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_PRE_INJURY_DIAG_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_PRE_INJURY_DIAG_DTL_ID]
, [ER_HISTORY_ID]
, [STD_ER_ICD9_CODE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [DIAGNOSIS_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ER_PRE_INJURY_DIAG_DTL_ID]
, [ER_HISTORY_ID]
, [STD_ER_ICD9_CODE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [DIAGNOSIS_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_PRE_INJURY_IMAGING_DTL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_PRE_INJURY_IMAGING_DTL_H]
GO
Create trigger [DVEIR].[TRG_ER_PRE_INJURY_IMAGING_DTL_H] on [DVEIR].[ER_PRE_INJURY_IMAGING_DTL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_PRE_INJURY_IMAGING_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_PRE_INJURY_IMAGING_DTL_ID]
, [ER_HISTORY_ID]
, [STD_ER_IMG_MTHD_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [IMAGING_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ER_PRE_INJURY_IMAGING_DTL_ID]
, [ER_HISTORY_ID]
, [STD_ER_IMG_MTHD_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [IMAGING_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[DVEIR].[TRG_ER_PRE_INJURY_IMAGING_DTL_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_PRE_INJURY_IMAGING_DTL_DEL_H]
go
CREATE TRIGGER  [DVEIR].[TRG_ER_PRE_INJURY_IMAGING_DTL_DEL_H]
on  [DVEIR].[ER_PRE_INJURY_IMAGING_DTL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_PRE_INJURY_IMAGING_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_PRE_INJURY_IMAGING_DTL_ID]
, [ER_HISTORY_ID]
, [STD_ER_IMG_MTHD_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [IMAGING_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ER_PRE_INJURY_IMAGING_DTL_ID]
, [ER_HISTORY_ID]
, [STD_ER_IMG_MTHD_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [IMAGING_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_PRE_INJURY_PROCEDURE_DTL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_PRE_INJURY_PROCEDURE_DTL_H]
GO
Create trigger [DVEIR].[TRG_ER_PRE_INJURY_PROCEDURE_DTL_H] on [DVEIR].[ER_PRE_INJURY_PROCEDURE_DTL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_PRE_INJURY_PROCEDURE_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_PRE_INJURY_PROCEDURE_DTL_ID]
, [ER_HISTORY_ID]
, [STD_ER_CPT4_CODE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [PROCEDURE_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ER_PRE_INJURY_PROCEDURE_DTL_ID]
, [ER_HISTORY_ID]
, [STD_ER_CPT4_CODE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [PROCEDURE_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[DVEIR].[TRG_ER_PRE_INJURY_PROCEDURE_DTL_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_PRE_INJURY_PROCEDURE_DTL_DEL_H]
go
CREATE TRIGGER  [DVEIR].[TRG_ER_PRE_INJURY_PROCEDURE_DTL_DEL_H]
on  [DVEIR].[ER_PRE_INJURY_PROCEDURE_DTL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_PRE_INJURY_PROCEDURE_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_PRE_INJURY_PROCEDURE_DTL_ID]
, [ER_HISTORY_ID]
, [STD_ER_CPT4_CODE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [PROCEDURE_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ER_PRE_INJURY_PROCEDURE_DTL_ID]
, [ER_HISTORY_ID]
, [STD_ER_CPT4_CODE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [PROCEDURE_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_PROBLEM_LIST_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_PROBLEM_LIST_H]
GO
Create trigger [DVEIR].[TRG_ER_PROBLEM_LIST_H] on [DVEIR].[ER_PROBLEM_LIST]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_PROBLEM_LIST_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [PROBLEM_ID]
, [PATIENT_ID]
, [ONSET_DATE]
, [LAST_UPDATED_DATE]
, [PROBLEM_DESC]
, [EXPOSURE_DESC]
, [PROVIDER_ID]
, [PROVIDER_NAME]
, [ACTIVE_INACTIVE_IND]
, [FACILITY_STATION_NUMBER]
, [FACILITY_NAME]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [PROBLEM_ID]
, [PATIENT_ID]
, [ONSET_DATE]
, [LAST_UPDATED_DATE]
, [PROBLEM_DESC]
, [EXPOSURE_DESC]
, [PROVIDER_ID]
, [PROVIDER_NAME]
, [ACTIVE_INACTIVE_IND]
, [FACILITY_STATION_NUMBER]
, [FACILITY_NAME]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[DVEIR].[TRG_ER_PROBLEM_LIST_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_PROBLEM_LIST_DEL_H]
go
CREATE TRIGGER  [DVEIR].[TRG_ER_PROBLEM_LIST_DEL_H]
on  [DVEIR].[ER_PROBLEM_LIST] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_PROBLEM_LIST_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [PROBLEM_ID]
, [PATIENT_ID]
, [ONSET_DATE]
, [LAST_UPDATED_DATE]
, [PROBLEM_DESC]
, [EXPOSURE_DESC]
, [PROVIDER_ID]
, [PROVIDER_NAME]
, [ACTIVE_INACTIVE_IND]
, [FACILITY_STATION_NUMBER]
, [FACILITY_NAME]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [PROBLEM_ID]
, [PATIENT_ID]
, [ONSET_DATE]
, [LAST_UPDATED_DATE]
, [PROBLEM_DESC]
, [EXPOSURE_DESC]
, [PROVIDER_ID]
, [PROVIDER_NAME]
, [ACTIVE_INACTIVE_IND]
, [FACILITY_STATION_NUMBER]
, [FACILITY_NAME]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_PROCEDURE_DTL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_PROCEDURE_DTL_H]
GO
Create trigger [DVEIR].[TRG_ER_PROCEDURE_DTL_H] on [DVEIR].[ER_PROCEDURE_DTL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_PROCEDURE_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_PROCEDURE_DTL_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ER_ENCOUNTER_ID]
, [CODE]
, [DESCRIPTION_TEXT]
, [ICD9_FLAG]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ER_PROCEDURE_DTL_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ER_ENCOUNTER_ID]
, [CODE]
, [DESCRIPTION_TEXT]
, [ICD9_FLAG]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[DVEIR].[TRG_ER_PROCEDURE_DTL_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_PROCEDURE_DTL_DEL_H]
go
CREATE TRIGGER  [DVEIR].[TRG_ER_PROCEDURE_DTL_DEL_H]
on  [DVEIR].[ER_PROCEDURE_DTL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_PROCEDURE_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_PROCEDURE_DTL_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ER_ENCOUNTER_ID]
, [CODE]
, [DESCRIPTION_TEXT]
, [ICD9_FLAG]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ER_PROCEDURE_DTL_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ER_ENCOUNTER_ID]
, [CODE]
, [DESCRIPTION_TEXT]
, [ICD9_FLAG]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_PROCEDURE_DTL_ETL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_PROCEDURE_DTL_ETL_H]
GO
Create trigger [DVEIR].[TRG_ER_PROCEDURE_DTL_ETL_H] on [DVEIR].[ER_PROCEDURE_DTL_ETL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_PROCEDURE_DTL_ETL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_PROCEDURE_DTL_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ER_ENCOUNTER_ID]
, [CODE]
, [DESCRIPTION_TEXT]
, [ICD9_FLAG]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ER_PROCEDURE_DTL_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ER_ENCOUNTER_ID]
, [CODE]
, [DESCRIPTION_TEXT]
, [ICD9_FLAG]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[DVEIR].[TRG_ER_PROCEDURE_DTL_ETL_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_PROCEDURE_DTL_ETL_DEL_H]
go
CREATE TRIGGER  [DVEIR].[TRG_ER_PROCEDURE_DTL_ETL_DEL_H]
on  [DVEIR].[ER_PROCEDURE_DTL_ETL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_PROCEDURE_DTL_ETL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_PROCEDURE_DTL_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ER_ENCOUNTER_ID]
, [CODE]
, [DESCRIPTION_TEXT]
, [ICD9_FLAG]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ER_PROCEDURE_DTL_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ER_ENCOUNTER_ID]
, [CODE]
, [DESCRIPTION_TEXT]
, [ICD9_FLAG]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_PROSTHETIC_DTL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_PROSTHETIC_DTL_H]
GO
Create trigger [DVEIR].[TRG_ER_PROSTHETIC_DTL_H] on [DVEIR].[ER_PROSTHETIC_DTL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_PROSTHETIC_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_PROSTHETIC_DTL_ID]
, [ER_OUTCOME_ID]
, [STD_ER_PROSTHETIC_TYPE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [OTHER_PROSTHETIC_DSCR]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ER_PROSTHETIC_DTL_ID]
, [ER_OUTCOME_ID]
, [STD_ER_PROSTHETIC_TYPE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [OTHER_PROSTHETIC_DSCR]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[DVEIR].[TRG_ER_PROSTHETIC_DTL_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_PROSTHETIC_DTL_DEL_H]
go
CREATE TRIGGER  [DVEIR].[TRG_ER_PROSTHETIC_DTL_DEL_H]
on  [DVEIR].[ER_PROSTHETIC_DTL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_PROSTHETIC_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_PROSTHETIC_DTL_ID]
, [ER_OUTCOME_ID]
, [STD_ER_PROSTHETIC_TYPE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [OTHER_PROSTHETIC_DSCR]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ER_PROSTHETIC_DTL_ID]
, [ER_OUTCOME_ID]
, [STD_ER_PROSTHETIC_TYPE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [OTHER_PROSTHETIC_DSCR]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_PUPIL_EXAM_DTL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_PUPIL_EXAM_DTL_H]
GO
Create trigger [DVEIR].[TRG_ER_PUPIL_EXAM_DTL_H] on [DVEIR].[ER_PUPIL_EXAM_DTL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_PUPIL_EXAM_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_PUPIL_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_PUPIL_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ER_PUPIL_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_PUPIL_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[DVEIR].[TRG_ER_PUPIL_EXAM_DTL_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_PUPIL_EXAM_DTL_DEL_H]
go
CREATE TRIGGER  [DVEIR].[TRG_ER_PUPIL_EXAM_DTL_DEL_H]
on  [DVEIR].[ER_PUPIL_EXAM_DTL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_PUPIL_EXAM_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_PUPIL_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_PUPIL_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ER_PUPIL_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_PUPIL_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_RAPD_EXAM_DTL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_RAPD_EXAM_DTL_H]
GO
Create trigger [DVEIR].[TRG_ER_RAPD_EXAM_DTL_H] on [DVEIR].[ER_RAPD_EXAM_DTL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_RAPD_EXAM_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_ RAPD_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ER_ RAPD_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[DVEIR].[TRG_ER_RAPD_EXAM_DTL_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_RAPD_EXAM_DTL_DEL_H]
go
CREATE TRIGGER  [DVEIR].[TRG_ER_RAPD_EXAM_DTL_DEL_H]
on  [DVEIR].[ER_RAPD_EXAM_DTL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_RAPD_EXAM_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_ RAPD_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ER_ RAPD_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_REFERRAL_REVIEWCOMMENT_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_REFERRAL_REVIEWCOMMENT_H]
GO
Create trigger [DVEIR].[TRG_ER_REFERRAL_REVIEWCOMMENT_H] on [DVEIR].[ER_REFERRAL_REVIEWCOMMENT]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_REFERRAL_REVIEWCOMMENT_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ID]
, [REFERRAL_ID]
, [DATE_ENTERED]
, [RESOLVED_FLAG]
, [RESOLVED_BY]
, [DATE_RESOLVED]
, [APPROVED_FLAG]
, [APPROVED_BY]
, [DATE_APPROVED]
, [ANCHORid]
, [LOCATION_FRIENDLY_NAME]
, [CREATED]
, [CREATEDBY]
, [UPDATED]
, [UPDATEDBY]
, [COMMENT_TEXT]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ID]
, [REFERRAL_ID]
, [DATE_ENTERED]
, [RESOLVED_FLAG]
, [RESOLVED_BY]
, [DATE_RESOLVED]
, [APPROVED_FLAG]
, [APPROVED_BY]
, [DATE_APPROVED]
, [ANCHORid]
, [LOCATION_FRIENDLY_NAME]
, [CREATED]
, [CREATEDBY]
, [UPDATED]
, [UPDATEDBY]
, [COMMENT_TEXT]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[DVEIR].[TRG_ER_REFERRAL_REVIEWCOMMENT_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_REFERRAL_REVIEWCOMMENT_DEL_H]
go
CREATE TRIGGER  [DVEIR].[TRG_ER_REFERRAL_REVIEWCOMMENT_DEL_H]
on  [DVEIR].[ER_REFERRAL_REVIEWCOMMENT] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_REFERRAL_REVIEWCOMMENT_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ID]
, [REFERRAL_ID]
, [DATE_ENTERED]
, [RESOLVED_FLAG]
, [RESOLVED_BY]
, [DATE_RESOLVED]
, [APPROVED_FLAG]
, [APPROVED_BY]
, [DATE_APPROVED]
, [ANCHORid]
, [LOCATION_FRIENDLY_NAME]
, [CREATED]
, [CREATEDBY]
, [UPDATED]
, [UPDATEDBY]
, [COMMENT_TEXT]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ID]
, [REFERRAL_ID]
, [DATE_ENTERED]
, [RESOLVED_FLAG]
, [RESOLVED_BY]
, [DATE_RESOLVED]
, [APPROVED_FLAG]
, [APPROVED_BY]
, [DATE_APPROVED]
, [ANCHORid]
, [LOCATION_FRIENDLY_NAME]
, [CREATED]
, [CREATEDBY]
, [UPDATED]
, [UPDATEDBY]
, [COMMENT_TEXT]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_RETINA_EXAM_DTL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_RETINA_EXAM_DTL_H]
GO
Create trigger [DVEIR].[TRG_ER_RETINA_EXAM_DTL_H] on [DVEIR].[ER_RETINA_EXAM_DTL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_RETINA_EXAM_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_RETINA_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_RETINA_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ER_RETINA_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_RETINA_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[DVEIR].[TRG_ER_RETINA_EXAM_DTL_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_RETINA_EXAM_DTL_DEL_H]
go
CREATE TRIGGER  [DVEIR].[TRG_ER_RETINA_EXAM_DTL_DEL_H]
on  [DVEIR].[ER_RETINA_EXAM_DTL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_RETINA_EXAM_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_RETINA_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_RETINA_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ER_RETINA_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_RETINA_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_SCLERA_EXAM_DTL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_SCLERA_EXAM_DTL_H]
GO
Create trigger [DVEIR].[TRG_ER_SCLERA_EXAM_DTL_H] on [DVEIR].[ER_SCLERA_EXAM_DTL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_SCLERA_EXAM_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_SCLERA_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_SCLERA_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ER_SCLERA_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_SCLERA_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[DVEIR].[TRG_ER_SCLERA_EXAM_DTL_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_SCLERA_EXAM_DTL_DEL_H]
go
CREATE TRIGGER  [DVEIR].[TRG_ER_SCLERA_EXAM_DTL_DEL_H]
on  [DVEIR].[ER_SCLERA_EXAM_DTL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_SCLERA_EXAM_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_SCLERA_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_SCLERA_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ER_SCLERA_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_SCLERA_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_TRAUMA_DTL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_TRAUMA_DTL_H]
GO
Create trigger [DVEIR].[TRG_ER_TRAUMA_DTL_H] on [DVEIR].[ER_TRAUMA_DTL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_TRAUMA_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_PPE_DTL_ID]
, [ER_INJURY_ID]
, [STD_ER_TBI_TYPE_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ER_PPE_DTL_ID]
, [ER_INJURY_ID]
, [STD_ER_TBI_TYPE_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[DVEIR].[TRG_ER_TRAUMA_DTL_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_TRAUMA_DTL_DEL_H]
go
CREATE TRIGGER  [DVEIR].[TRG_ER_TRAUMA_DTL_DEL_H]
on  [DVEIR].[ER_TRAUMA_DTL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_TRAUMA_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_PPE_DTL_ID]
, [ER_INJURY_ID]
, [STD_ER_TBI_TYPE_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ER_PPE_DTL_ID]
, [ER_INJURY_ID]
, [STD_ER_TBI_TYPE_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_VITREOUS_EXAM_DTL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_VITREOUS_EXAM_DTL_H]
GO
Create trigger [DVEIR].[TRG_ER_VITREOUS_EXAM_DTL_H] on [DVEIR].[ER_VITREOUS_EXAM_DTL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_VITREOUS_EXAM_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_VITREOUS_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_VITREOUS_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ER_VITREOUS_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_VITREOUS_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[DVEIR].[TRG_ER_VITREOUS_EXAM_DTL_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_VITREOUS_EXAM_DTL_DEL_H]
go
CREATE TRIGGER  [DVEIR].[TRG_ER_VITREOUS_EXAM_DTL_DEL_H]
on  [DVEIR].[ER_VITREOUS_EXAM_DTL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_VITREOUS_EXAM_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_VITREOUS_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_VITREOUS_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ER_VITREOUS_EXAM_DTL_ID]
, [ER_EXAM_ID]
, [STD_ER_VITREOUS_ISSUE_ID]
, [LEFT_FLAG]
, [RIGHT_FLAG]
, [EXAM_DATE]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_WORK_SAFETY_DTL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_WORK_SAFETY_DTL_H]
GO
Create trigger [DVEIR].[TRG_ER_WORK_SAFETY_DTL_H] on [DVEIR].[ER_WORK_SAFETY_DTL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_WORK_SAFETY_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_WORK_SAFETY_DTL_ID]
, [ER_INJURY_ID]
, [STD_ER_SAFETY_TYPE_ID]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ER_WORK_SAFETY_DTL_ID]
, [ER_INJURY_ID]
, [STD_ER_SAFETY_TYPE_ID]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[DVEIR].[TRG_ER_WORK_SAFETY_DTL_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_WORK_SAFETY_DTL_DEL_H]
go
CREATE TRIGGER  [DVEIR].[TRG_ER_WORK_SAFETY_DTL_DEL_H]
on  [DVEIR].[ER_WORK_SAFETY_DTL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_WORK_SAFETY_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_WORK_SAFETY_DTL_ID]
, [ER_INJURY_ID]
, [STD_ER_SAFETY_TYPE_ID]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ER_WORK_SAFETY_DTL_ID]
, [ER_INJURY_ID]
, [STD_ER_SAFETY_TYPE_ID]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[EFR].[TRG_FRAGMENT_ANALYSIS_H]'))
DROP TRIGGER [EFR].[TRG_FRAGMENT_ANALYSIS_H]
GO
Create trigger [EFR].[TRG_FRAGMENT_ANALYSIS_H] on [EFR].[FRAGMENT_ANALYSIS]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [EFR].[FRAGMENT_ANALYSIS_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [FRAGMENT_ANALYSIS_ID]
, [WKF_CASE_ACTIVITY_ID]
, [LAB_ORDER_ID]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [LAB_REPORT_DATE]
, [LAB_UID_NUMBER]
, [METALS_LAB_CODE]
, [FRAGMENT_PROD_EVENT_DATE]
, [FRAGMENT_ID_NUMBER]
, [FRAGMENT_DESCR]
, [FRAGMENT_LENGTH_MEASURE]
, [FRAGMENT_WIDTH_MEASURE]
, [FRAGMENT_HEIGHT_MEASURE]
, [DIMENSION_UNITS]
, [FRAGMENT_MASS_MEASURE]
, [MASS_UNITS]
, [FRAGMENT_RADIOACTIVE_TEST_IND]
, [FRAGMENT_RADIOACTIVE_RESULT]
, [TESTING_RESULT_TEXT]
, [COMMENT_TEXT]
, [TISSUE_SENT_FLAG]
, [TISSUE_SENT_DATE]
, [TISSUE_RESULT_TEXT]
, [BSO_NUMBER]
, [LAB_NAME]
, [LAB_ID_NUMBER]
, [RESULT_ACKNOWLEDGE_FLAG]
, [RESULT_ACKNOWLEDGE_DATE]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [FRAGMENT_ANALYSIS_ID]
, [WKF_CASE_ACTIVITY_ID]
, [LAB_ORDER_ID]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [LAB_REPORT_DATE]
, [LAB_UID_NUMBER]
, [METALS_LAB_CODE]
, [FRAGMENT_PROD_EVENT_DATE]
, [FRAGMENT_ID_NUMBER]
, [FRAGMENT_DESCR]
, [FRAGMENT_LENGTH_MEASURE]
, [FRAGMENT_WIDTH_MEASURE]
, [FRAGMENT_HEIGHT_MEASURE]
, [DIMENSION_UNITS]
, [FRAGMENT_MASS_MEASURE]
, [MASS_UNITS]
, [FRAGMENT_RADIOACTIVE_TEST_IND]
, [FRAGMENT_RADIOACTIVE_RESULT]
, [TESTING_RESULT_TEXT]
, [COMMENT_TEXT]
, [TISSUE_SENT_FLAG]
, [TISSUE_SENT_DATE]
, [TISSUE_RESULT_TEXT]
, [BSO_NUMBER]
, [LAB_NAME]
, [LAB_ID_NUMBER]
, [RESULT_ACKNOWLEDGE_FLAG]
, [RESULT_ACKNOWLEDGE_DATE]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[EFR].[TRG_FRAGMENT_ANALYSIS_DEL_H]'))
DROP TRIGGER [EFR].[TRG_FRAGMENT_ANALYSIS_DEL_H]
go
CREATE TRIGGER  [EFR].[TRG_FRAGMENT_ANALYSIS_DEL_H]
on  [EFR].[FRAGMENT_ANALYSIS] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [EFR].[FRAGMENT_ANALYSIS_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [FRAGMENT_ANALYSIS_ID]
, [WKF_CASE_ACTIVITY_ID]
, [LAB_ORDER_ID]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [LAB_REPORT_DATE]
, [LAB_UID_NUMBER]
, [METALS_LAB_CODE]
, [FRAGMENT_PROD_EVENT_DATE]
, [FRAGMENT_ID_NUMBER]
, [FRAGMENT_DESCR]
, [FRAGMENT_LENGTH_MEASURE]
, [FRAGMENT_WIDTH_MEASURE]
, [FRAGMENT_HEIGHT_MEASURE]
, [DIMENSION_UNITS]
, [FRAGMENT_MASS_MEASURE]
, [MASS_UNITS]
, [FRAGMENT_RADIOACTIVE_TEST_IND]
, [FRAGMENT_RADIOACTIVE_RESULT]
, [TESTING_RESULT_TEXT]
, [COMMENT_TEXT]
, [TISSUE_SENT_FLAG]
, [TISSUE_SENT_DATE]
, [TISSUE_RESULT_TEXT]
, [BSO_NUMBER]
, [LAB_NAME]
, [LAB_ID_NUMBER]
, [RESULT_ACKNOWLEDGE_FLAG]
, [RESULT_ACKNOWLEDGE_DATE]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [FRAGMENT_ANALYSIS_ID]
, [WKF_CASE_ACTIVITY_ID]
, [LAB_ORDER_ID]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [LAB_REPORT_DATE]
, [LAB_UID_NUMBER]
, [METALS_LAB_CODE]
, [FRAGMENT_PROD_EVENT_DATE]
, [FRAGMENT_ID_NUMBER]
, [FRAGMENT_DESCR]
, [FRAGMENT_LENGTH_MEASURE]
, [FRAGMENT_WIDTH_MEASURE]
, [FRAGMENT_HEIGHT_MEASURE]
, [DIMENSION_UNITS]
, [FRAGMENT_MASS_MEASURE]
, [MASS_UNITS]
, [FRAGMENT_RADIOACTIVE_TEST_IND]
, [FRAGMENT_RADIOACTIVE_RESULT]
, [TESTING_RESULT_TEXT]
, [COMMENT_TEXT]
, [TISSUE_SENT_FLAG]
, [TISSUE_SENT_DATE]
, [TISSUE_RESULT_TEXT]
, [BSO_NUMBER]
, [LAB_NAME]
, [LAB_ID_NUMBER]
, [RESULT_ACKNOWLEDGE_FLAG]
, [RESULT_ACKNOWLEDGE_DATE]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[EFR].[TRG_FRAGMENT_COLLECTION_H]'))
DROP TRIGGER [EFR].[TRG_FRAGMENT_COLLECTION_H]
GO
Create trigger [EFR].[TRG_FRAGMENT_COLLECTION_H] on [EFR].[FRAGMENT_COLLECTION]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [EFR].[FRAGMENT_COLLECTION_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [FRAGMENT_COLLECTION_ID]
, [PATIENT_ID]
, [STD_REGISTRY_ID]
, [WKF_CASE_ACTIVITY_ID]
, [STD_INSTITUTION_ID]
, [FRAGMENT_REFERENCE_NUMBER]
, [FRAGMENT_DSCR]
, [REMOVAL_DATE]
, [BODY_LOCATION_DSCR]
, [TISSUE_COMPARTMENT_DSCR]
, [FRAGMENTS_REMAINING_IND]
, [FRAGMENTS_REMAINING_NUMBER]
, [INJURY_DATE]
, [INJURY_GEO_LOCATION_DSCR]
, [PROVIDER_COMMENTS]
, [OTHER_REMOVAL_PROVIDER_DSCR]
, [OTHER_REMOVAL_FACILITY_DSCR]
, [LAB_SEND_DATE]
, [LAB_RETURN_DATE]
, [SHIPMENT_TRACKING_NUMBER]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [FRAGMENT_COLLECTION_ID]
, [PATIENT_ID]
, [STD_REGISTRY_ID]
, [WKF_CASE_ACTIVITY_ID]
, [STD_INSTITUTION_ID]
, [FRAGMENT_REFERENCE_NUMBER]
, [FRAGMENT_DSCR]
, [REMOVAL_DATE]
, [BODY_LOCATION_DSCR]
, [TISSUE_COMPARTMENT_DSCR]
, [FRAGMENTS_REMAINING_IND]
, [FRAGMENTS_REMAINING_NUMBER]
, [INJURY_DATE]
, [INJURY_GEO_LOCATION_DSCR]
, [PROVIDER_COMMENTS]
, [OTHER_REMOVAL_PROVIDER_DSCR]
, [OTHER_REMOVAL_FACILITY_DSCR]
, [LAB_SEND_DATE]
, [LAB_RETURN_DATE]
, [SHIPMENT_TRACKING_NUMBER]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[EFR].[TRG_FRAGMENT_COLLECTION_DEL_H]'))
DROP TRIGGER [EFR].[TRG_FRAGMENT_COLLECTION_DEL_H]
go
CREATE TRIGGER  [EFR].[TRG_FRAGMENT_COLLECTION_DEL_H]
on  [EFR].[FRAGMENT_COLLECTION] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [EFR].[FRAGMENT_COLLECTION_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [FRAGMENT_COLLECTION_ID]
, [PATIENT_ID]
, [STD_REGISTRY_ID]
, [WKF_CASE_ACTIVITY_ID]
, [STD_INSTITUTION_ID]
, [FRAGMENT_REFERENCE_NUMBER]
, [FRAGMENT_DSCR]
, [REMOVAL_DATE]
, [BODY_LOCATION_DSCR]
, [TISSUE_COMPARTMENT_DSCR]
, [FRAGMENTS_REMAINING_IND]
, [FRAGMENTS_REMAINING_NUMBER]
, [INJURY_DATE]
, [INJURY_GEO_LOCATION_DSCR]
, [PROVIDER_COMMENTS]
, [OTHER_REMOVAL_PROVIDER_DSCR]
, [OTHER_REMOVAL_FACILITY_DSCR]
, [LAB_SEND_DATE]
, [LAB_RETURN_DATE]
, [SHIPMENT_TRACKING_NUMBER]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [FRAGMENT_COLLECTION_ID]
, [PATIENT_ID]
, [STD_REGISTRY_ID]
, [WKF_CASE_ACTIVITY_ID]
, [STD_INSTITUTION_ID]
, [FRAGMENT_REFERENCE_NUMBER]
, [FRAGMENT_DSCR]
, [REMOVAL_DATE]
, [BODY_LOCATION_DSCR]
, [TISSUE_COMPARTMENT_DSCR]
, [FRAGMENTS_REMAINING_IND]
, [FRAGMENTS_REMAINING_NUMBER]
, [INJURY_DATE]
, [INJURY_GEO_LOCATION_DSCR]
, [PROVIDER_COMMENTS]
, [OTHER_REMOVAL_PROVIDER_DSCR]
, [OTHER_REMOVAL_FACILITY_DSCR]
, [LAB_SEND_DATE]
, [LAB_RETURN_DATE]
, [SHIPMENT_TRACKING_NUMBER]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[VITAS].[TRG_IM_IMPLANT_DEVICE_STATUS_H]'))
DROP TRIGGER [VITAS].[TRG_IM_IMPLANT_DEVICE_STATUS_H]
GO
Create trigger [VITAS].[TRG_IM_IMPLANT_DEVICE_STATUS_H] on [VITAS].[IM_IMPLANT_DEVICE_STATUS]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [VITAS].[IM_IMPLANT_DEVICE_STATUS_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ID]
, [STD_IM_DEVICE_STATUS_ID]
, [STATUS_DATE]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [IM_IMPLANT_ITEM_ID]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ID]
, [STD_IM_DEVICE_STATUS_ID]
, [STATUS_DATE]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [IM_IMPLANT_ITEM_ID]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[VITAS].[TRG_IM_IMPLANT_DEVICE_STATUS_DEL_H]'))
DROP TRIGGER [VITAS].[TRG_IM_IMPLANT_DEVICE_STATUS_DEL_H]
go
CREATE TRIGGER  [VITAS].[TRG_IM_IMPLANT_DEVICE_STATUS_DEL_H]
on  [VITAS].[IM_IMPLANT_DEVICE_STATUS] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [VITAS].[IM_IMPLANT_DEVICE_STATUS_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ID]
, [STD_IM_DEVICE_STATUS_ID]
, [STATUS_DATE]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [IM_IMPLANT_ITEM_ID]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ID]
, [STD_IM_DEVICE_STATUS_ID]
, [STATUS_DATE]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [IM_IMPLANT_ITEM_ID]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[VITAS].[TRG_IM_IMPLANT_ITEM_H]'))
DROP TRIGGER [VITAS].[TRG_IM_IMPLANT_ITEM_H]
GO
Create trigger [VITAS].[TRG_IM_IMPLANT_ITEM_H] on [VITAS].[IM_IMPLANT_ITEM]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [VITAS].[IM_IMPLANT_ITEM_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ID]
, [IMPLANT_ITEM_NAME]
, [IMPLANT_ITEM_DESC]
, [SIZE]
, [MODEL_NUMBER]
, [STOCK_NUMBER]
, [LOT_NUMBER]
, [SERIAL_NUMBER]
, [MANUFACTURE_DATE]
, [STERILE_CODE]
, [STERILE_NUMBER]
, [STERILE_RESPONSIBILITY]
, [STERILITY_EXPIRATION_DATE]
, [BAR_CODE]
, [BAR_CODE_IMAGE]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [IM_PATIENT_SURGERY_ID]
, [SERIAL_LOT_NUMBER]
, [STD_IMPLANT_TYPE_OTHER]
, [STD_IM_SPECIALTY_AREA_OTHER]
, [QUANTITY]
, [MANUFACTURER_TEXT]
, [DISTRIBUTOR_TEXT]
, [STD_IM_IMPLANT_TYPE_ID]
, [STD_IM_SPECIALTY_AREA_ID]
, [HCPCS_Desc]
, [SPECIALTY_AREA]
, [IMPLANT_ALERT_FLAG]
, [RECALL_ID]
, [STD_IM_NOTIFICATION_STATUS_ID]
, [NOTIFICATION_LETTER_FROM]
, [NOTIFICATION_LETTER_TO]
, [NOTIFICATION_LETTER_BODY]
, [NOTIFICATION_LETTER_CLOSING]
, [PATIENT_LOCATION_PRIMARY_PROVIDER]
, [RECALL_EMAIL_PROCESSED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ID]
, [IMPLANT_ITEM_NAME]
, [IMPLANT_ITEM_DESC]
, [SIZE]
, [MODEL_NUMBER]
, [STOCK_NUMBER]
, [LOT_NUMBER]
, [SERIAL_NUMBER]
, [MANUFACTURE_DATE]
, [STERILE_CODE]
, [STERILE_NUMBER]
, [STERILE_RESPONSIBILITY]
, [STERILITY_EXPIRATION_DATE]
, [BAR_CODE]
, [BAR_CODE_IMAGE]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [IM_PATIENT_SURGERY_ID]
, [SERIAL_LOT_NUMBER]
, [STD_IMPLANT_TYPE_OTHER]
, [STD_IM_SPECIALTY_AREA_OTHER]
, [QUANTITY]
, [MANUFACTURER_TEXT]
, [DISTRIBUTOR_TEXT]
, [STD_IM_IMPLANT_TYPE_ID]
, [STD_IM_SPECIALTY_AREA_ID]
, [HCPCS_Desc]
, [SPECIALTY_AREA]
, [IMPLANT_ALERT_FLAG]
, [RECALL_ID]
, [STD_IM_NOTIFICATION_STATUS_ID]
, [NOTIFICATION_LETTER_FROM]
, [NOTIFICATION_LETTER_TO]
, [NOTIFICATION_LETTER_BODY]
, [NOTIFICATION_LETTER_CLOSING]
, [PATIENT_LOCATION_PRIMARY_PROVIDER]
, [RECALL_EMAIL_PROCESSED]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[VITAS].[TRG_IM_IMPLANT_ITEM_DEL_H]'))
DROP TRIGGER [VITAS].[TRG_IM_IMPLANT_ITEM_DEL_H]
go
CREATE TRIGGER  [VITAS].[TRG_IM_IMPLANT_ITEM_DEL_H]
on  [VITAS].[IM_IMPLANT_ITEM] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [VITAS].[IM_IMPLANT_ITEM_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ID]
, [IMPLANT_ITEM_NAME]
, [IMPLANT_ITEM_DESC]
, [SIZE]
, [MODEL_NUMBER]
, [STOCK_NUMBER]
, [LOT_NUMBER]
, [SERIAL_NUMBER]
, [MANUFACTURE_DATE]
, [STERILE_CODE]
, [STERILE_NUMBER]
, [STERILE_RESPONSIBILITY]
, [STERILITY_EXPIRATION_DATE]
, [BAR_CODE]
, [BAR_CODE_IMAGE]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [IM_PATIENT_SURGERY_ID]
, [SERIAL_LOT_NUMBER]
, [STD_IMPLANT_TYPE_OTHER]
, [STD_IM_SPECIALTY_AREA_OTHER]
, [QUANTITY]
, [MANUFACTURER_TEXT]
, [DISTRIBUTOR_TEXT]
, [STD_IM_IMPLANT_TYPE_ID]
, [STD_IM_SPECIALTY_AREA_ID]
, [HCPCS_Desc]
, [SPECIALTY_AREA]
, [IMPLANT_ALERT_FLAG]
, [RECALL_ID]
, [STD_IM_NOTIFICATION_STATUS_ID]
, [NOTIFICATION_LETTER_FROM]
, [NOTIFICATION_LETTER_TO]
, [NOTIFICATION_LETTER_BODY]
, [NOTIFICATION_LETTER_CLOSING]
, [PATIENT_LOCATION_PRIMARY_PROVIDER]
, [RECALL_EMAIL_PROCESSED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ID]
, [IMPLANT_ITEM_NAME]
, [IMPLANT_ITEM_DESC]
, [SIZE]
, [MODEL_NUMBER]
, [STOCK_NUMBER]
, [LOT_NUMBER]
, [SERIAL_NUMBER]
, [MANUFACTURE_DATE]
, [STERILE_CODE]
, [STERILE_NUMBER]
, [STERILE_RESPONSIBILITY]
, [STERILITY_EXPIRATION_DATE]
, [BAR_CODE]
, [BAR_CODE_IMAGE]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [IM_PATIENT_SURGERY_ID]
, [SERIAL_LOT_NUMBER]
, [STD_IMPLANT_TYPE_OTHER]
, [STD_IM_SPECIALTY_AREA_OTHER]
, [QUANTITY]
, [MANUFACTURER_TEXT]
, [DISTRIBUTOR_TEXT]
, [STD_IM_IMPLANT_TYPE_ID]
, [STD_IM_SPECIALTY_AREA_ID]
, [HCPCS_Desc]
, [SPECIALTY_AREA]
, [IMPLANT_ALERT_FLAG]
, [RECALL_ID]
, [STD_IM_NOTIFICATION_STATUS_ID]
, [NOTIFICATION_LETTER_FROM]
, [NOTIFICATION_LETTER_TO]
, [NOTIFICATION_LETTER_BODY]
, [NOTIFICATION_LETTER_CLOSING]
, [PATIENT_LOCATION_PRIMARY_PROVIDER]
, [RECALL_EMAIL_PROCESSED]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[VITAS].[TRG_IM_IMPLANT_ITEM_MATERIAL_TYPE_H]'))
DROP TRIGGER [VITAS].[TRG_IM_IMPLANT_ITEM_MATERIAL_TYPE_H]
GO
Create trigger [VITAS].[TRG_IM_IMPLANT_ITEM_MATERIAL_TYPE_H] on [VITAS].[IM_IMPLANT_ITEM_MATERIAL_TYPE]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [VITAS].[IM_IMPLANT_ITEM_MATERIAL_TYPE_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ID]
, [IM_IMPLANT_ITEM_ID]
, [STD_IM_MATERIAL_TYPE_ID]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ID]
, [IM_IMPLANT_ITEM_ID]
, [STD_IM_MATERIAL_TYPE_ID]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[VITAS].[TRG_IM_IMPLANT_ITEM_MATERIAL_TYPE_DEL_H]'))
DROP TRIGGER [VITAS].[TRG_IM_IMPLANT_ITEM_MATERIAL_TYPE_DEL_H]
go
CREATE TRIGGER  [VITAS].[TRG_IM_IMPLANT_ITEM_MATERIAL_TYPE_DEL_H]
on  [VITAS].[IM_IMPLANT_ITEM_MATERIAL_TYPE] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [VITAS].[IM_IMPLANT_ITEM_MATERIAL_TYPE_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ID]
, [IM_IMPLANT_ITEM_ID]
, [STD_IM_MATERIAL_TYPE_ID]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ID]
, [IM_IMPLANT_ITEM_ID]
, [STD_IM_MATERIAL_TYPE_ID]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[VITAS].[TRG_IM_NOTIFICATION_LETTER_H]'))
DROP TRIGGER [VITAS].[TRG_IM_NOTIFICATION_LETTER_H]
GO
Create trigger [VITAS].[TRG_IM_NOTIFICATION_LETTER_H] on [VITAS].[IM_NOTIFICATION_LETTER]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [VITAS].[IM_NOTIFICATION_LETTER_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ID]
, [PARENT_NOTIFICATION_LETTER_ID]
, [STD_IM_ALERT_ID]
, [STD_IM_NOTIFICATION_TYPE]
, [STD_OTHER_NOTIFICATION_ID]
, [OTHER_NOTIFICATION_TEXT]
, [NOTIFICATION_SUBJECT]
, [NOTIFICATION_BODY]
, [NOTIFICATION_CLOSING]
, [CREATED]
, [CREATEDBY]
, [UPDATED]
, [UPDATEDBY]
, [ROW_VERSON]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ID]
, [PARENT_NOTIFICATION_LETTER_ID]
, [STD_IM_ALERT_ID]
, [STD_IM_NOTIFICATION_TYPE]
, [STD_OTHER_NOTIFICATION_ID]
, [OTHER_NOTIFICATION_TEXT]
, [NOTIFICATION_SUBJECT]
, [NOTIFICATION_BODY]
, [NOTIFICATION_CLOSING]
, [CREATED]
, [CREATEDBY]
, [UPDATED]
, [UPDATEDBY]
, [ROW_VERSON]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[VITAS].[TRG_IM_NOTIFICATION_LETTER_DEL_H]'))
DROP TRIGGER [VITAS].[TRG_IM_NOTIFICATION_LETTER_DEL_H]
go
CREATE TRIGGER  [VITAS].[TRG_IM_NOTIFICATION_LETTER_DEL_H]
on  [VITAS].[IM_NOTIFICATION_LETTER] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [VITAS].[IM_NOTIFICATION_LETTER_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ID]
, [PARENT_NOTIFICATION_LETTER_ID]
, [STD_IM_ALERT_ID]
, [STD_IM_NOTIFICATION_TYPE]
, [STD_OTHER_NOTIFICATION_ID]
, [OTHER_NOTIFICATION_TEXT]
, [NOTIFICATION_SUBJECT]
, [NOTIFICATION_BODY]
, [NOTIFICATION_CLOSING]
, [CREATED]
, [CREATEDBY]
, [UPDATED]
, [UPDATEDBY]
, [ROW_VERSON]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ID]
, [PARENT_NOTIFICATION_LETTER_ID]
, [STD_IM_ALERT_ID]
, [STD_IM_NOTIFICATION_TYPE]
, [STD_OTHER_NOTIFICATION_ID]
, [OTHER_NOTIFICATION_TEXT]
, [NOTIFICATION_SUBJECT]
, [NOTIFICATION_BODY]
, [NOTIFICATION_CLOSING]
, [CREATED]
, [CREATEDBY]
, [UPDATED]
, [UPDATEDBY]
, [ROW_VERSON]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[VITAS].[TRG_IM_NOTIFICATION_LIST_H]'))
DROP TRIGGER [VITAS].[TRG_IM_NOTIFICATION_LIST_H]
GO
Create trigger [VITAS].[TRG_IM_NOTIFICATION_LIST_H] on [VITAS].[IM_NOTIFICATION_LIST]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [VITAS].[IM_NOTIFICATION_LIST_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ID]
, [DATE_LIST_CREATED]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ID]
, [DATE_LIST_CREATED]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[VITAS].[TRG_IM_NOTIFICATION_LIST_DEL_H]'))
DROP TRIGGER [VITAS].[TRG_IM_NOTIFICATION_LIST_DEL_H]
go
CREATE TRIGGER  [VITAS].[TRG_IM_NOTIFICATION_LIST_DEL_H]
on  [VITAS].[IM_NOTIFICATION_LIST] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [VITAS].[IM_NOTIFICATION_LIST_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ID]
, [DATE_LIST_CREATED]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ID]
, [DATE_LIST_CREATED]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[VITAS].[TRG_IM_NOTIFICATION_LIST_DETAIL_H]'))
DROP TRIGGER [VITAS].[TRG_IM_NOTIFICATION_LIST_DETAIL_H]
GO
Create trigger [VITAS].[TRG_IM_NOTIFICATION_LIST_DETAIL_H] on [VITAS].[IM_NOTIFICATION_LIST_DETAIL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [VITAS].[IM_NOTIFICATION_LIST_DETAIL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ID]
, [NOTIFICATION_LIST_NO]
, [IM_PATIENT_SURGERY_ID]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ID]
, [NOTIFICATION_LIST_NO]
, [IM_PATIENT_SURGERY_ID]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[VITAS].[TRG_IM_NOTIFICATION_LIST_DETAIL_DEL_H]'))
DROP TRIGGER [VITAS].[TRG_IM_NOTIFICATION_LIST_DETAIL_DEL_H]
go
CREATE TRIGGER  [VITAS].[TRG_IM_NOTIFICATION_LIST_DETAIL_DEL_H]
on  [VITAS].[IM_NOTIFICATION_LIST_DETAIL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [VITAS].[IM_NOTIFICATION_LIST_DETAIL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ID]
, [NOTIFICATION_LIST_NO]
, [IM_PATIENT_SURGERY_ID]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ID]
, [NOTIFICATION_LIST_NO]
, [IM_PATIENT_SURGERY_ID]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[VITAS].[TRG_IM_PATIENT_SURGERY_H]'))
DROP TRIGGER [VITAS].[TRG_IM_PATIENT_SURGERY_H]
GO
Create trigger [VITAS].[TRG_IM_PATIENT_SURGERY_H] on [VITAS].[IM_PATIENT_SURGERY]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [VITAS].[IM_PATIENT_SURGERY_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ID]
, [PATIENT_ID]
, [DATE_IMPLANTED]
, [OTHER_IMPLANT_PHYSICIAN_FIRST_NAME]
, [OTHER_IMPLANT_PHYSICIAN_LAST_NAME]
, [OTHER_IMPLANT_PHYSICIAN_MIDDLE_NAME]
, [OTHER_IMPLANT_PHYSICIAN_NOTES]
, [STD_IMPLANT_FACILITY_ID]
, [STD_INFORMATION_SOURCE_ID]
, [ANATOMICAL_LOCATION]
, [PATIENT_REPORTED_IMPLANT_PROVIDER]
, [SOURCE_OF_INFORMATION_ID]
, [SERVICE_LATERALITY]
, [SERVICE_LOCATION]
, [ARRIVAL_DATE]
, [PROCESSING_DATE]
, [PURCHASE_PRICE]
, [PRINCIPAL_PRE_OP_DIAG]
, [PRINCIPAL_POST_OP_DIAG]
, [ASA_CLASS]
, [SERVICE_MAJOR_MINOR]
, [COMMENT_TEXT]
, [VA_IMPLANT_FLAG]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [SURGERY_CASE_NUMBER]
, [SURGEON_ID]
, [SURGEON_FIRST_NAME]
, [SURGEON_MIDDLE_NAME]
, [SURGEON_LAST_NAME]
, [ATTEND_SURGEON_ID]
, [ATTEND_SURGEON_FIRST_NAME]
, [ATTEND_SURGEON_MIDDLE_NAME]
, [ATTEND_SURGEON_LAST_NAME]
, [ExplantDate]
, [PartialExplantDate]
, [AbandonDate]
, [Date_Implanted_Text]
, [Facility_Name]
, [Facility_Address_1]
, [Facility_Address_2]
, [Facility_Address_3]
, [Facility_City]
, [Facility_State]
, [Facility_zip]
, [Facility_zip4]
, [Facility_Country]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ID]
, [PATIENT_ID]
, [DATE_IMPLANTED]
, [OTHER_IMPLANT_PHYSICIAN_FIRST_NAME]
, [OTHER_IMPLANT_PHYSICIAN_LAST_NAME]
, [OTHER_IMPLANT_PHYSICIAN_MIDDLE_NAME]
, [OTHER_IMPLANT_PHYSICIAN_NOTES]
, [STD_IMPLANT_FACILITY_ID]
, [STD_INFORMATION_SOURCE_ID]
, [ANATOMICAL_LOCATION]
, [PATIENT_REPORTED_IMPLANT_PROVIDER]
, [SOURCE_OF_INFORMATION_ID]
, [SERVICE_LATERALITY]
, [SERVICE_LOCATION]
, [ARRIVAL_DATE]
, [PROCESSING_DATE]
, [PURCHASE_PRICE]
, [PRINCIPAL_PRE_OP_DIAG]
, [PRINCIPAL_POST_OP_DIAG]
, [ASA_CLASS]
, [SERVICE_MAJOR_MINOR]
, [COMMENT_TEXT]
, [VA_IMPLANT_FLAG]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [SURGERY_CASE_NUMBER]
, [SURGEON_ID]
, [SURGEON_FIRST_NAME]
, [SURGEON_MIDDLE_NAME]
, [SURGEON_LAST_NAME]
, [ATTEND_SURGEON_ID]
, [ATTEND_SURGEON_FIRST_NAME]
, [ATTEND_SURGEON_MIDDLE_NAME]
, [ATTEND_SURGEON_LAST_NAME]
, [ExplantDate]
, [PartialExplantDate]
, [AbandonDate]
, [Date_Implanted_Text]
, [Facility_Name]
, [Facility_Address_1]
, [Facility_Address_2]
, [Facility_Address_3]
, [Facility_City]
, [Facility_State]
, [Facility_zip]
, [Facility_zip4]
, [Facility_Country]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[VITAS].[TRG_IM_PATIENT_SURGERY_DEL_H]'))
DROP TRIGGER [VITAS].[TRG_IM_PATIENT_SURGERY_DEL_H]
go
CREATE TRIGGER  [VITAS].[TRG_IM_PATIENT_SURGERY_DEL_H]
on  [VITAS].[IM_PATIENT_SURGERY] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [VITAS].[IM_PATIENT_SURGERY_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ID]
, [PATIENT_ID]
, [DATE_IMPLANTED]
, [OTHER_IMPLANT_PHYSICIAN_FIRST_NAME]
, [OTHER_IMPLANT_PHYSICIAN_LAST_NAME]
, [OTHER_IMPLANT_PHYSICIAN_MIDDLE_NAME]
, [OTHER_IMPLANT_PHYSICIAN_NOTES]
, [STD_IMPLANT_FACILITY_ID]
, [STD_INFORMATION_SOURCE_ID]
, [ANATOMICAL_LOCATION]
, [PATIENT_REPORTED_IMPLANT_PROVIDER]
, [SOURCE_OF_INFORMATION_ID]
, [SERVICE_LATERALITY]
, [SERVICE_LOCATION]
, [ARRIVAL_DATE]
, [PROCESSING_DATE]
, [PURCHASE_PRICE]
, [PRINCIPAL_PRE_OP_DIAG]
, [PRINCIPAL_POST_OP_DIAG]
, [ASA_CLASS]
, [SERVICE_MAJOR_MINOR]
, [COMMENT_TEXT]
, [VA_IMPLANT_FLAG]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [SURGERY_CASE_NUMBER]
, [SURGEON_ID]
, [SURGEON_FIRST_NAME]
, [SURGEON_MIDDLE_NAME]
, [SURGEON_LAST_NAME]
, [ATTEND_SURGEON_ID]
, [ATTEND_SURGEON_FIRST_NAME]
, [ATTEND_SURGEON_MIDDLE_NAME]
, [ATTEND_SURGEON_LAST_NAME]
, [ExplantDate]
, [PartialExplantDate]
, [AbandonDate]
, [Date_Implanted_Text]
, [Facility_Name]
, [Facility_Address_1]
, [Facility_Address_2]
, [Facility_Address_3]
, [Facility_City]
, [Facility_State]
, [Facility_zip]
, [Facility_zip4]
, [Facility_Country]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ID]
, [PATIENT_ID]
, [DATE_IMPLANTED]
, [OTHER_IMPLANT_PHYSICIAN_FIRST_NAME]
, [OTHER_IMPLANT_PHYSICIAN_LAST_NAME]
, [OTHER_IMPLANT_PHYSICIAN_MIDDLE_NAME]
, [OTHER_IMPLANT_PHYSICIAN_NOTES]
, [STD_IMPLANT_FACILITY_ID]
, [STD_INFORMATION_SOURCE_ID]
, [ANATOMICAL_LOCATION]
, [PATIENT_REPORTED_IMPLANT_PROVIDER]
, [SOURCE_OF_INFORMATION_ID]
, [SERVICE_LATERALITY]
, [SERVICE_LOCATION]
, [ARRIVAL_DATE]
, [PROCESSING_DATE]
, [PURCHASE_PRICE]
, [PRINCIPAL_PRE_OP_DIAG]
, [PRINCIPAL_POST_OP_DIAG]
, [ASA_CLASS]
, [SERVICE_MAJOR_MINOR]
, [COMMENT_TEXT]
, [VA_IMPLANT_FLAG]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [SURGERY_CASE_NUMBER]
, [SURGEON_ID]
, [SURGEON_FIRST_NAME]
, [SURGEON_MIDDLE_NAME]
, [SURGEON_LAST_NAME]
, [ATTEND_SURGEON_ID]
, [ATTEND_SURGEON_FIRST_NAME]
, [ATTEND_SURGEON_MIDDLE_NAME]
, [ATTEND_SURGEON_LAST_NAME]
, [ExplantDate]
, [PartialExplantDate]
, [AbandonDate]
, [Date_Implanted_Text]
, [Facility_Name]
, [Facility_Address_1]
, [Facility_Address_2]
, [Facility_Address_3]
, [Facility_City]
, [Facility_State]
, [Facility_zip]
, [Facility_zip4]
, [Facility_Country]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[VITAS].[TRG_IM_PRIMARY_CARE_PHYSICIAN_H]'))
DROP TRIGGER [VITAS].[TRG_IM_PRIMARY_CARE_PHYSICIAN_H]
GO
Create trigger [VITAS].[TRG_IM_PRIMARY_CARE_PHYSICIAN_H] on [VITAS].[IM_PRIMARY_CARE_PHYSICIAN]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [VITAS].[IM_PRIMARY_CARE_PHYSICIAN_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ID]
, [PATIENT_ID]
, [STD_INSTITUTION_ID]
, [INSTITUTION_OTHER]
, [NPI]
, [SSN]
, [FIRST_NAME]
, [MIDDLE_NAME]
, [LAST_NAME]
, [ADDRESS_LINE1]
, [ADDRESS_LINE2]
, [ADDRESS_LINE3]
, [CITY]
, [STATE]
, [COUNTY]
, [COUNTRY]
, [POSTAL_CODE]
, [ZIP_PLUS_4]
, [WORK_PHONE]
, [EMAIL_ADDRESS]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [FAX_NUMBER]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ID]
, [PATIENT_ID]
, [STD_INSTITUTION_ID]
, [INSTITUTION_OTHER]
, [NPI]
, [SSN]
, [FIRST_NAME]
, [MIDDLE_NAME]
, [LAST_NAME]
, [ADDRESS_LINE1]
, [ADDRESS_LINE2]
, [ADDRESS_LINE3]
, [CITY]
, [STATE]
, [COUNTY]
, [COUNTRY]
, [POSTAL_CODE]
, [ZIP_PLUS_4]
, [WORK_PHONE]
, [EMAIL_ADDRESS]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [FAX_NUMBER]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[VITAS].[TRG_IM_PRIMARY_CARE_PHYSICIAN_DEL_H]'))
DROP TRIGGER [VITAS].[TRG_IM_PRIMARY_CARE_PHYSICIAN_DEL_H]
go
CREATE TRIGGER  [VITAS].[TRG_IM_PRIMARY_CARE_PHYSICIAN_DEL_H]
on  [VITAS].[IM_PRIMARY_CARE_PHYSICIAN] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [VITAS].[IM_PRIMARY_CARE_PHYSICIAN_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ID]
, [PATIENT_ID]
, [STD_INSTITUTION_ID]
, [INSTITUTION_OTHER]
, [NPI]
, [SSN]
, [FIRST_NAME]
, [MIDDLE_NAME]
, [LAST_NAME]
, [ADDRESS_LINE1]
, [ADDRESS_LINE2]
, [ADDRESS_LINE3]
, [CITY]
, [STATE]
, [COUNTY]
, [COUNTRY]
, [POSTAL_CODE]
, [ZIP_PLUS_4]
, [WORK_PHONE]
, [EMAIL_ADDRESS]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [FAX_NUMBER]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ID]
, [PATIENT_ID]
, [STD_INSTITUTION_ID]
, [INSTITUTION_OTHER]
, [NPI]
, [SSN]
, [FIRST_NAME]
, [MIDDLE_NAME]
, [LAST_NAME]
, [ADDRESS_LINE1]
, [ADDRESS_LINE2]
, [ADDRESS_LINE3]
, [CITY]
, [STATE]
, [COUNTY]
, [COUNTRY]
, [POSTAL_CODE]
, [ZIP_PLUS_4]
, [WORK_PHONE]
, [EMAIL_ADDRESS]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [FAX_NUMBER]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[VITAS].[TRG_IM_RECALL_H]'))
DROP TRIGGER [VITAS].[TRG_IM_RECALL_H]
GO
Create trigger [VITAS].[TRG_IM_RECALL_H] on [VITAS].[IM_RECALL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [VITAS].[IM_RECALL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [RECALL_ID]
, [MANUFACTURER]
, [MODEL]
, [SERIAL_NO]
, [LOT_NO]
, [RECALL_LETTER_URL]
, [TARGET_DATE]
, [SOURCE_RECALL_ID]
, [MATCHES_FOUND]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [PATIENT_NOTIFICATION_LETTER]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [RECALL_ID]
, [MANUFACTURER]
, [MODEL]
, [SERIAL_NO]
, [LOT_NO]
, [RECALL_LETTER_URL]
, [TARGET_DATE]
, [SOURCE_RECALL_ID]
, [MATCHES_FOUND]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [PATIENT_NOTIFICATION_LETTER]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[VITAS].[TRG_IM_RECALL_DEL_H]'))
DROP TRIGGER [VITAS].[TRG_IM_RECALL_DEL_H]
go
CREATE TRIGGER  [VITAS].[TRG_IM_RECALL_DEL_H]
on  [VITAS].[IM_RECALL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [VITAS].[IM_RECALL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [RECALL_ID]
, [MANUFACTURER]
, [MODEL]
, [SERIAL_NO]
, [LOT_NO]
, [RECALL_LETTER_URL]
, [TARGET_DATE]
, [SOURCE_RECALL_ID]
, [MATCHES_FOUND]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [PATIENT_NOTIFICATION_LETTER]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [RECALL_ID]
, [MANUFACTURER]
, [MODEL]
, [SERIAL_NO]
, [LOT_NO]
, [RECALL_LETTER_URL]
, [TARGET_DATE]
, [SOURCE_RECALL_ID]
, [MATCHES_FOUND]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [PATIENT_NOTIFICATION_LETTER]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[VITAS].[TRG_IM_RECORD_ACTION_TAKEN_H]'))
DROP TRIGGER [VITAS].[TRG_IM_RECORD_ACTION_TAKEN_H]
GO
Create trigger [VITAS].[TRG_IM_RECORD_ACTION_TAKEN_H] on [VITAS].[IM_RECORD_ACTION_TAKEN]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [VITAS].[IM_RECORD_ACTION_TAKEN_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ID]
, [STD_IM_ACTION_TYPE_ID]
, [INITIAL_NOTIFICATION_LETTER_SEND_FLAG]
, [DATE_LETTER_SENT]
, [PATIENT_CONTACTED_FLAG]
, [DATE_CONTACTED]
, [RECOMMEND_ACTION_TAKEN_IND]
, [DATE_ACTION_TAKEN]
, [RECOMMEDED_ACTION_NOT_TAKEN_IND]
, [STD_IM_NO_ACTION_TAKEN_ID]
, [NO_ACTION_TAKEN_REASON_OTHER]
, [FURTHER_CLINICAL_ACTION_FLAG]
, [SEND_TO_EMAIL]
, [COMMENT_TEXT]
, [DATE_IMPLANT_EXPLANTED]
, [STD_IM_EXPLANTED_REASON_ID]
, [EXPLANTED_REASON_NOTES]
, [DATE_ABANDONED]
, [STD_IM_ABANDONED_REASON_ID]
, [ABANDONED_REASON_NOTES]
, [DATE_OTHER]
, [ACTION_OTHER]
, [OTHER_NOTES]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [IM_IMPLANT_ITEM_ID]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ID]
, [STD_IM_ACTION_TYPE_ID]
, [INITIAL_NOTIFICATION_LETTER_SEND_FLAG]
, [DATE_LETTER_SENT]
, [PATIENT_CONTACTED_FLAG]
, [DATE_CONTACTED]
, [RECOMMEND_ACTION_TAKEN_IND]
, [DATE_ACTION_TAKEN]
, [RECOMMEDED_ACTION_NOT_TAKEN_IND]
, [STD_IM_NO_ACTION_TAKEN_ID]
, [NO_ACTION_TAKEN_REASON_OTHER]
, [FURTHER_CLINICAL_ACTION_FLAG]
, [SEND_TO_EMAIL]
, [COMMENT_TEXT]
, [DATE_IMPLANT_EXPLANTED]
, [STD_IM_EXPLANTED_REASON_ID]
, [EXPLANTED_REASON_NOTES]
, [DATE_ABANDONED]
, [STD_IM_ABANDONED_REASON_ID]
, [ABANDONED_REASON_NOTES]
, [DATE_OTHER]
, [ACTION_OTHER]
, [OTHER_NOTES]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [IM_IMPLANT_ITEM_ID]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[VITAS].[TRG_IM_RECORD_ACTION_TAKEN_DEL_H]'))
DROP TRIGGER [VITAS].[TRG_IM_RECORD_ACTION_TAKEN_DEL_H]
go
CREATE TRIGGER  [VITAS].[TRG_IM_RECORD_ACTION_TAKEN_DEL_H]
on  [VITAS].[IM_RECORD_ACTION_TAKEN] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [VITAS].[IM_RECORD_ACTION_TAKEN_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ID]
, [STD_IM_ACTION_TYPE_ID]
, [INITIAL_NOTIFICATION_LETTER_SEND_FLAG]
, [DATE_LETTER_SENT]
, [PATIENT_CONTACTED_FLAG]
, [DATE_CONTACTED]
, [RECOMMEND_ACTION_TAKEN_IND]
, [DATE_ACTION_TAKEN]
, [RECOMMEDED_ACTION_NOT_TAKEN_IND]
, [STD_IM_NO_ACTION_TAKEN_ID]
, [NO_ACTION_TAKEN_REASON_OTHER]
, [FURTHER_CLINICAL_ACTION_FLAG]
, [SEND_TO_EMAIL]
, [COMMENT_TEXT]
, [DATE_IMPLANT_EXPLANTED]
, [STD_IM_EXPLANTED_REASON_ID]
, [EXPLANTED_REASON_NOTES]
, [DATE_ABANDONED]
, [STD_IM_ABANDONED_REASON_ID]
, [ABANDONED_REASON_NOTES]
, [DATE_OTHER]
, [ACTION_OTHER]
, [OTHER_NOTES]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [IM_IMPLANT_ITEM_ID]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ID]
, [STD_IM_ACTION_TYPE_ID]
, [INITIAL_NOTIFICATION_LETTER_SEND_FLAG]
, [DATE_LETTER_SENT]
, [PATIENT_CONTACTED_FLAG]
, [DATE_CONTACTED]
, [RECOMMEND_ACTION_TAKEN_IND]
, [DATE_ACTION_TAKEN]
, [RECOMMEDED_ACTION_NOT_TAKEN_IND]
, [STD_IM_NO_ACTION_TAKEN_ID]
, [NO_ACTION_TAKEN_REASON_OTHER]
, [FURTHER_CLINICAL_ACTION_FLAG]
, [SEND_TO_EMAIL]
, [COMMENT_TEXT]
, [DATE_IMPLANT_EXPLANTED]
, [STD_IM_EXPLANTED_REASON_ID]
, [EXPLANTED_REASON_NOTES]
, [DATE_ABANDONED]
, [STD_IM_ABANDONED_REASON_ID]
, [ABANDONED_REASON_NOTES]
, [DATE_OTHER]
, [ACTION_OTHER]
, [OTHER_NOTES]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [IM_IMPLANT_ITEM_ID]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[EFR].[TRG_INJURY_DETAIL_H]'))
DROP TRIGGER [EFR].[TRG_INJURY_DETAIL_H]
GO
Create trigger [EFR].[TRG_INJURY_DETAIL_H] on [EFR].[INJURY_DETAIL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [EFR].[INJURY_DETAIL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [INJURY_DETAIL_ID]
, [PATIENT_ID]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [INJURY_DETAIL_ID]
, [PATIENT_ID]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[EFR].[TRG_INJURY_DETAIL_DEL_H]'))
DROP TRIGGER [EFR].[TRG_INJURY_DETAIL_DEL_H]
go
CREATE TRIGGER  [EFR].[TRG_INJURY_DETAIL_DEL_H]
on  [EFR].[INJURY_DETAIL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [EFR].[INJURY_DETAIL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [INJURY_DETAIL_ID]
, [PATIENT_ID]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [INJURY_DETAIL_ID]
, [PATIENT_ID]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[EFR].[TRG_INTERPRETATION_LETTER_H]'))
DROP TRIGGER [EFR].[TRG_INTERPRETATION_LETTER_H]
GO
Create trigger [EFR].[TRG_INTERPRETATION_LETTER_H] on [EFR].[INTERPRETATION_LETTER]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [EFR].[INTERPRETATION_LETTER_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [INTERPRETATION_LETTER_ID]
, [WKF_CASE_ACTIVITY_ID]
, [PROVIDER_INTERPRETATION_TEXT]
, [PROVIDER_NAME]
, [PROVIDER_ADDR1]
, [PROVIDER_ADDR2]
, [PROVIDER_ADDR3]
, [PROVIDER_STATE]
, [PROVIDER_CITY]
, [PROVIDER_POSTAL]
, [PROVIDER_ZIPPLUS4]
, [PROVIDER_COUNTRY]
, [PROVIDER_PHONE]
, [PATIENT_NAME]
, [PATIENT_ADDR1]
, [PATIENT_ADDR2]
, [PATIENT_ADDR3]
, [PATIENT_STATE]
, [PATIENT_CITY]
, [PATIENT_POSTAL]
, [PATIENT_ZIPPLUS4]
, [PATIENT_COUNTRY]
, [PATIENT_PHONE]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [FROM_ADDRESS]
, [Letter_SUBJECT]
, [STD_SIGNING_CLINICIAN_ID]
, [CCName]
, [PROVIDER_COMMENTS]
, [PROVIDER_INSTITUTION_NAME]
, [PATIENT_INTERPRETATION_TEXT]
, [PATIENT_COMMENT]
, [PRINT_QUEUE]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [INTERPRETATION_LETTER_ID]
, [WKF_CASE_ACTIVITY_ID]
, [PROVIDER_INTERPRETATION_TEXT]
, [PROVIDER_NAME]
, [PROVIDER_ADDR1]
, [PROVIDER_ADDR2]
, [PROVIDER_ADDR3]
, [PROVIDER_STATE]
, [PROVIDER_CITY]
, [PROVIDER_POSTAL]
, [PROVIDER_ZIPPLUS4]
, [PROVIDER_COUNTRY]
, [PROVIDER_PHONE]
, [PATIENT_NAME]
, [PATIENT_ADDR1]
, [PATIENT_ADDR2]
, [PATIENT_ADDR3]
, [PATIENT_STATE]
, [PATIENT_CITY]
, [PATIENT_POSTAL]
, [PATIENT_ZIPPLUS4]
, [PATIENT_COUNTRY]
, [PATIENT_PHONE]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [FROM_ADDRESS]
, [Letter_SUBJECT]
, [STD_SIGNING_CLINICIAN_ID]
, [CCName]
, [PROVIDER_COMMENTS]
, [PROVIDER_INSTITUTION_NAME]
, [PATIENT_INTERPRETATION_TEXT]
, [PATIENT_COMMENT]
, [PRINT_QUEUE]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[EFR].[TRG_INTERPRETATION_LETTER_DEL_H]'))
DROP TRIGGER [EFR].[TRG_INTERPRETATION_LETTER_DEL_H]
go
CREATE TRIGGER  [EFR].[TRG_INTERPRETATION_LETTER_DEL_H]
on  [EFR].[INTERPRETATION_LETTER] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [EFR].[INTERPRETATION_LETTER_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [INTERPRETATION_LETTER_ID]
, [WKF_CASE_ACTIVITY_ID]
, [PROVIDER_INTERPRETATION_TEXT]
, [PROVIDER_NAME]
, [PROVIDER_ADDR1]
, [PROVIDER_ADDR2]
, [PROVIDER_ADDR3]
, [PROVIDER_STATE]
, [PROVIDER_CITY]
, [PROVIDER_POSTAL]
, [PROVIDER_ZIPPLUS4]
, [PROVIDER_COUNTRY]
, [PROVIDER_PHONE]
, [PATIENT_NAME]
, [PATIENT_ADDR1]
, [PATIENT_ADDR2]
, [PATIENT_ADDR3]
, [PATIENT_STATE]
, [PATIENT_CITY]
, [PATIENT_POSTAL]
, [PATIENT_ZIPPLUS4]
, [PATIENT_COUNTRY]
, [PATIENT_PHONE]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [FROM_ADDRESS]
, [Letter_SUBJECT]
, [STD_SIGNING_CLINICIAN_ID]
, [CCName]
, [PROVIDER_COMMENTS]
, [PROVIDER_INSTITUTION_NAME]
, [PATIENT_INTERPRETATION_TEXT]
, [PATIENT_COMMENT]
, [PRINT_QUEUE]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [INTERPRETATION_LETTER_ID]
, [WKF_CASE_ACTIVITY_ID]
, [PROVIDER_INTERPRETATION_TEXT]
, [PROVIDER_NAME]
, [PROVIDER_ADDR1]
, [PROVIDER_ADDR2]
, [PROVIDER_ADDR3]
, [PROVIDER_STATE]
, [PROVIDER_CITY]
, [PROVIDER_POSTAL]
, [PROVIDER_ZIPPLUS4]
, [PROVIDER_COUNTRY]
, [PROVIDER_PHONE]
, [PATIENT_NAME]
, [PATIENT_ADDR1]
, [PATIENT_ADDR2]
, [PATIENT_ADDR3]
, [PATIENT_STATE]
, [PATIENT_CITY]
, [PATIENT_POSTAL]
, [PATIENT_ZIPPLUS4]
, [PATIENT_COUNTRY]
, [PATIENT_PHONE]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [FROM_ADDRESS]
, [Letter_SUBJECT]
, [STD_SIGNING_CLINICIAN_ID]
, [CCName]
, [PROVIDER_COMMENTS]
, [PROVIDER_INSTITUTION_NAME]
, [PATIENT_INTERPRETATION_TEXT]
, [PATIENT_COMMENT]
, [PRINT_QUEUE]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[EFR].[TRG_LAB_ORDER_H]'))
DROP TRIGGER [EFR].[TRG_LAB_ORDER_H]
GO
Create trigger [EFR].[TRG_LAB_ORDER_H] on [EFR].[LAB_ORDER]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [EFR].[LAB_ORDER_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [LAB_ORDER_ID]
, [STD_INSTITUTION_ID]
, [PATIENT_ID]
, [STD_REGISTRY_ID]
, [WKF_CASE_ACTIVITY_ID]
, [FRAGMENT_COLLECTION_ID]
, [LAB_SEND_DATE]
, [REQUEST_NUMBER]
, [LAB_RETURN_DATE]
, [SHIPMENT_TRACKING_NUMBER]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [BSO_NUMBER]
, [LAB_NAME]
, [LAB_RECEIVED_DATE]
, [SPECIAL_INSTRUCTION]
, [SAMPLE_DESC]
, [LAB_REPORT_DATE]
, [LAB_ID_NUMBER]
, [METALS_LAB_CODE]
, [FRAGMENT_PROD_EVENT_DATE]
, [RESULT_ACKNOWLEDGE_DATE]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [LAB_ORDER_ID]
, [STD_INSTITUTION_ID]
, [PATIENT_ID]
, [STD_REGISTRY_ID]
, [WKF_CASE_ACTIVITY_ID]
, [FRAGMENT_COLLECTION_ID]
, [LAB_SEND_DATE]
, [REQUEST_NUMBER]
, [LAB_RETURN_DATE]
, [SHIPMENT_TRACKING_NUMBER]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [BSO_NUMBER]
, [LAB_NAME]
, [LAB_RECEIVED_DATE]
, [SPECIAL_INSTRUCTION]
, [SAMPLE_DESC]
, [LAB_REPORT_DATE]
, [LAB_ID_NUMBER]
, [METALS_LAB_CODE]
, [FRAGMENT_PROD_EVENT_DATE]
, [RESULT_ACKNOWLEDGE_DATE]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[EFR].[TRG_LAB_ORDER_DEL_H]'))
DROP TRIGGER [EFR].[TRG_LAB_ORDER_DEL_H]
go
CREATE TRIGGER  [EFR].[TRG_LAB_ORDER_DEL_H]
on  [EFR].[LAB_ORDER] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [EFR].[LAB_ORDER_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [LAB_ORDER_ID]
, [STD_INSTITUTION_ID]
, [PATIENT_ID]
, [STD_REGISTRY_ID]
, [WKF_CASE_ACTIVITY_ID]
, [FRAGMENT_COLLECTION_ID]
, [LAB_SEND_DATE]
, [REQUEST_NUMBER]
, [LAB_RETURN_DATE]
, [SHIPMENT_TRACKING_NUMBER]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [BSO_NUMBER]
, [LAB_NAME]
, [LAB_RECEIVED_DATE]
, [SPECIAL_INSTRUCTION]
, [SAMPLE_DESC]
, [LAB_REPORT_DATE]
, [LAB_ID_NUMBER]
, [METALS_LAB_CODE]
, [FRAGMENT_PROD_EVENT_DATE]
, [RESULT_ACKNOWLEDGE_DATE]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [LAB_ORDER_ID]
, [STD_INSTITUTION_ID]
, [PATIENT_ID]
, [STD_REGISTRY_ID]
, [WKF_CASE_ACTIVITY_ID]
, [FRAGMENT_COLLECTION_ID]
, [LAB_SEND_DATE]
, [REQUEST_NUMBER]
, [LAB_RETURN_DATE]
, [SHIPMENT_TRACKING_NUMBER]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [BSO_NUMBER]
, [LAB_NAME]
, [LAB_RECEIVED_DATE]
, [SPECIAL_INSTRUCTION]
, [SAMPLE_DESC]
, [LAB_REPORT_DATE]
, [LAB_ID_NUMBER]
, [METALS_LAB_CODE]
, [FRAGMENT_PROD_EVENT_DATE]
, [RESULT_ACKNOWLEDGE_DATE]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[EFR].[TRG_LAB_ORDER_DETAIL_H]'))
DROP TRIGGER [EFR].[TRG_LAB_ORDER_DETAIL_H]
GO
Create trigger [EFR].[TRG_LAB_ORDER_DETAIL_H] on [EFR].[LAB_ORDER_DETAIL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [EFR].[LAB_ORDER_DETAIL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [LAB_ORDER_DETAIL_ID]
, [LAB_ORDER_ID]
, [STD_ANALYTETYPE_ID]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [OTHER_ANALYTE_NAME]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [LAB_ORDER_DETAIL_ID]
, [LAB_ORDER_ID]
, [STD_ANALYTETYPE_ID]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [OTHER_ANALYTE_NAME]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[EFR].[TRG_LAB_ORDER_DETAIL_DEL_H]'))
DROP TRIGGER [EFR].[TRG_LAB_ORDER_DETAIL_DEL_H]
go
CREATE TRIGGER  [EFR].[TRG_LAB_ORDER_DETAIL_DEL_H]
on  [EFR].[LAB_ORDER_DETAIL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [EFR].[LAB_ORDER_DETAIL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [LAB_ORDER_DETAIL_ID]
, [LAB_ORDER_ID]
, [STD_ANALYTETYPE_ID]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [OTHER_ANALYTE_NAME]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [LAB_ORDER_DETAIL_ID]
, [LAB_ORDER_ID]
, [STD_ANALYTETYPE_ID]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [OTHER_ANALYTE_NAME]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[EFR].[TRG_LABRESULT_CHANGE_TRACKING_H]'))
DROP TRIGGER [EFR].[TRG_LABRESULT_CHANGE_TRACKING_H]
GO
Create trigger [EFR].[TRG_LABRESULT_CHANGE_TRACKING_H] on [EFR].[LABRESULT_CHANGE_TRACKING]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [EFR].[LABRESULT_CHANGE_TRACKING_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [LABRESULT_CHANGE_TRACKING_ID]
, [CHANGE_DATE]
, [CHANGE_FIELD]
, [CHANGE_DESCRIPTION]
, [WKF_CASE_ID]
, [NAVIGATION_URL]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [LABRESULT_CHANGE_TRACKING_ID]
, [CHANGE_DATE]
, [CHANGE_FIELD]
, [CHANGE_DESCRIPTION]
, [WKF_CASE_ID]
, [NAVIGATION_URL]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[EFR].[TRG_LABRESULT_CHANGE_TRACKING_DEL_H]'))
DROP TRIGGER [EFR].[TRG_LABRESULT_CHANGE_TRACKING_DEL_H]
go
CREATE TRIGGER  [EFR].[TRG_LABRESULT_CHANGE_TRACKING_DEL_H]
on  [EFR].[LABRESULT_CHANGE_TRACKING] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [EFR].[LABRESULT_CHANGE_TRACKING_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [LABRESULT_CHANGE_TRACKING_ID]
, [CHANGE_DATE]
, [CHANGE_FIELD]
, [CHANGE_DESCRIPTION]
, [WKF_CASE_ID]
, [NAVIGATION_URL]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [LABRESULT_CHANGE_TRACKING_ID]
, [CHANGE_DATE]
, [CHANGE_FIELD]
, [CHANGE_DESCRIPTION]
, [WKF_CASE_ID]
, [NAVIGATION_URL]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[EFR].[TRG_LETTER_TEMPLATE_H]'))
DROP TRIGGER [EFR].[TRG_LETTER_TEMPLATE_H]
GO
Create trigger [EFR].[TRG_LETTER_TEMPLATE_H] on [EFR].[LETTER_TEMPLATE]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [EFR].[LETTER_TEMPLATE_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [LETTER_TEMPLATE_ID]
, [STD_LETTERTYPE_ID]
, [TEMPLATE_REFERENCE_NUMBER]
, [TEMPLATE_NAME]
, [TEMPLATE_DSCR]
, [TEMPLATE_XML]
, [TEMPLATE_START_DATE]
, [TEMPLATE_END_DATE]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [LETTER_TEMPLATE_ID]
, [STD_LETTERTYPE_ID]
, [TEMPLATE_REFERENCE_NUMBER]
, [TEMPLATE_NAME]
, [TEMPLATE_DSCR]
, [TEMPLATE_XML]
, [TEMPLATE_START_DATE]
, [TEMPLATE_END_DATE]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[EFR].[TRG_LETTER_TEMPLATE_DEL_H]'))
DROP TRIGGER [EFR].[TRG_LETTER_TEMPLATE_DEL_H]
go
CREATE TRIGGER  [EFR].[TRG_LETTER_TEMPLATE_DEL_H]
on  [EFR].[LETTER_TEMPLATE] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [EFR].[LETTER_TEMPLATE_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [LETTER_TEMPLATE_ID]
, [STD_LETTERTYPE_ID]
, [TEMPLATE_REFERENCE_NUMBER]
, [TEMPLATE_NAME]
, [TEMPLATE_DSCR]
, [TEMPLATE_XML]
, [TEMPLATE_START_DATE]
, [TEMPLATE_END_DATE]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [LETTER_TEMPLATE_ID]
, [STD_LETTERTYPE_ID]
, [TEMPLATE_REFERENCE_NUMBER]
, [TEMPLATE_NAME]
, [TEMPLATE_DSCR]
, [TEMPLATE_XML]
, [TEMPLATE_START_DATE]
, [TEMPLATE_END_DATE]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[EFR].[TRG_MAILING_H]'))
DROP TRIGGER [EFR].[TRG_MAILING_H]
GO
Create trigger [EFR].[TRG_MAILING_H] on [EFR].[MAILING]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [EFR].[MAILING_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [MAILING_ID]
, [PATIENT_ID]
, [STD_REGISTRY_ID]
, [WKF_CASE_ACTIVITY_ID]
, [STD_LETTERTYPE_ID]
, [LETTER_TEMPLATE_ID]
, [REGISTRY_DEMOGRAPHICS_ID]
, [MAILING_SEND_DATE]
, [MAILING_XML]
, [SUBJECT_NAME]
, [SIGNATURE_NAME]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [MAILING_ID]
, [PATIENT_ID]
, [STD_REGISTRY_ID]
, [WKF_CASE_ACTIVITY_ID]
, [STD_LETTERTYPE_ID]
, [LETTER_TEMPLATE_ID]
, [REGISTRY_DEMOGRAPHICS_ID]
, [MAILING_SEND_DATE]
, [MAILING_XML]
, [SUBJECT_NAME]
, [SIGNATURE_NAME]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[EFR].[TRG_MAILING_DEL_H]'))
DROP TRIGGER [EFR].[TRG_MAILING_DEL_H]
go
CREATE TRIGGER  [EFR].[TRG_MAILING_DEL_H]
on  [EFR].[MAILING] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [EFR].[MAILING_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [MAILING_ID]
, [PATIENT_ID]
, [STD_REGISTRY_ID]
, [WKF_CASE_ACTIVITY_ID]
, [STD_LETTERTYPE_ID]
, [LETTER_TEMPLATE_ID]
, [REGISTRY_DEMOGRAPHICS_ID]
, [MAILING_SEND_DATE]
, [MAILING_XML]
, [SUBJECT_NAME]
, [SIGNATURE_NAME]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [MAILING_ID]
, [PATIENT_ID]
, [STD_REGISTRY_ID]
, [WKF_CASE_ACTIVITY_ID]
, [STD_LETTERTYPE_ID]
, [LETTER_TEMPLATE_ID]
, [REGISTRY_DEMOGRAPHICS_ID]
, [MAILING_SEND_DATE]
, [MAILING_XML]
, [SUBJECT_NAME]
, [SIGNATURE_NAME]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_MDWS_PROCESS_LOG_H]'))
DROP TRIGGER [dbo].[TRG_MDWS_PROCESS_LOG_H]
GO
Create trigger [dbo].[TRG_MDWS_PROCESS_LOG_H] on [dbo].[MDWS_PROCESS_LOG]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [dbo].[MDWS_PROCESS_LOG_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ID]
, [PARAMETERS_PASSED]
, [PARAMETERS_RETURNED]
, [ERROR_RETURNED]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ID]
, [PARAMETERS_PASSED]
, [PARAMETERS_RETURNED]
, [ERROR_RETURNED]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[dbo].[TRG_MDWS_PROCESS_LOG_DEL_H]'))
DROP TRIGGER [dbo].[TRG_MDWS_PROCESS_LOG_DEL_H]
go
CREATE TRIGGER  [dbo].[TRG_MDWS_PROCESS_LOG_DEL_H]
on  [dbo].[MDWS_PROCESS_LOG] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [dbo].[MDWS_PROCESS_LOG_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ID]
, [PARAMETERS_PASSED]
, [PARAMETERS_RETURNED]
, [ERROR_RETURNED]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ID]
, [PARAMETERS_PASSED]
, [PARAMETERS_RETURNED]
, [ERROR_RETURNED]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_PROVIDER_H]'))
DROP TRIGGER [dbo].[TRG_PROVIDER_H]
GO
Create trigger [dbo].[TRG_PROVIDER_H] on [dbo].[PROVIDER]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [dbo].[PROVIDER_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [PROVIDER_ID]
, [STD_INSTITUTION_ID]
, [VPID_NUMBER]
, [SSN]
, [DSN_NUMBER]
, [NPI_NUMBER]
, [FIRST_NAME]
, [MIDDLE_NAME]
, [LAST_NAME]
, [ADDRESS_LINE1]
, [ADDRESS_LINE2]
, [ADDRESS_LINE3]
, [CITY]
, [STATE]
, [COUNTY]
, [COUNTRY]
, [POSTAL_CODE]
, [ZIP_PLUS_4]
, [HOME_PHONE]
, [WORK_PHONE]
, [EMAIL_ADDRESS]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [FAX_NUMBER]
, [STAFFIEN]
, [PROVIDER_CLASS]
, [STA3N]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [PROVIDER_ID]
, [STD_INSTITUTION_ID]
, [VPID_NUMBER]
, [SSN]
, [DSN_NUMBER]
, [NPI_NUMBER]
, [FIRST_NAME]
, [MIDDLE_NAME]
, [LAST_NAME]
, [ADDRESS_LINE1]
, [ADDRESS_LINE2]
, [ADDRESS_LINE3]
, [CITY]
, [STATE]
, [COUNTY]
, [COUNTRY]
, [POSTAL_CODE]
, [ZIP_PLUS_4]
, [HOME_PHONE]
, [WORK_PHONE]
, [EMAIL_ADDRESS]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [FAX_NUMBER]
, [STAFFIEN]
, [PROVIDER_CLASS]
, [STA3N]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[dbo].[TRG_PROVIDER_DEL_H]'))
DROP TRIGGER [dbo].[TRG_PROVIDER_DEL_H]
go
CREATE TRIGGER  [dbo].[TRG_PROVIDER_DEL_H]
on  [dbo].[PROVIDER] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [dbo].[PROVIDER_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [PROVIDER_ID]
, [STD_INSTITUTION_ID]
, [VPID_NUMBER]
, [SSN]
, [DSN_NUMBER]
, [NPI_NUMBER]
, [FIRST_NAME]
, [MIDDLE_NAME]
, [LAST_NAME]
, [ADDRESS_LINE1]
, [ADDRESS_LINE2]
, [ADDRESS_LINE3]
, [CITY]
, [STATE]
, [COUNTY]
, [COUNTRY]
, [POSTAL_CODE]
, [ZIP_PLUS_4]
, [HOME_PHONE]
, [WORK_PHONE]
, [EMAIL_ADDRESS]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [FAX_NUMBER]
, [STAFFIEN]
, [PROVIDER_CLASS]
, [STA3N]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [PROVIDER_ID]
, [STD_INSTITUTION_ID]
, [VPID_NUMBER]
, [SSN]
, [DSN_NUMBER]
, [NPI_NUMBER]
, [FIRST_NAME]
, [MIDDLE_NAME]
, [LAST_NAME]
, [ADDRESS_LINE1]
, [ADDRESS_LINE2]
, [ADDRESS_LINE3]
, [CITY]
, [STATE]
, [COUNTY]
, [COUNTRY]
, [POSTAL_CODE]
, [ZIP_PLUS_4]
, [HOME_PHONE]
, [WORK_PHONE]
, [EMAIL_ADDRESS]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [FAX_NUMBER]
, [STAFFIEN]
, [PROVIDER_CLASS]
, [STA3N]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_PROVIDER_CLASS_DTL_H]'))
DROP TRIGGER [dbo].[TRG_PROVIDER_CLASS_DTL_H]
GO
Create trigger [dbo].[TRG_PROVIDER_CLASS_DTL_H] on [dbo].[PROVIDER_CLASS_DTL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [dbo].[PROVIDER_CLASS_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [PROVIDER_CLASS_DTL_ID]
, [PROVIDER_ID]
, [STD_PROVIDER_CLASS_ID]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [PROVIDER_CLASS_DTL_ID]
, [PROVIDER_ID]
, [STD_PROVIDER_CLASS_ID]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[dbo].[TRG_PROVIDER_CLASS_DTL_DEL_H]'))
DROP TRIGGER [dbo].[TRG_PROVIDER_CLASS_DTL_DEL_H]
go
CREATE TRIGGER  [dbo].[TRG_PROVIDER_CLASS_DTL_DEL_H]
on  [dbo].[PROVIDER_CLASS_DTL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [dbo].[PROVIDER_CLASS_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [PROVIDER_CLASS_DTL_ID]
, [PROVIDER_ID]
, [STD_PROVIDER_CLASS_ID]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [PROVIDER_CLASS_DTL_ID]
, [PROVIDER_ID]
, [STD_PROVIDER_CLASS_ID]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[EFR].[TRG_QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT_H]'))
DROP TRIGGER [EFR].[TRG_QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT_H]
GO
Create trigger [EFR].[TRG_QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT_H] on [EFR].[QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [EFR].[QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ID]
, [WKF_CASE_ACTIVITY_ID]
, [VAMC_Name]
, [VAMC_Street_Address1]
, [VAMC_Street_Address2]
, [VAMC_Street_Address3]
, [VAMC_City]
, [VAMC_State]
, [VAMC_PostalCiode]
, [VAMC_ZipPlus4]
, [VAMC_Country]
, [Form_Complete_Date]
, [Branch_of_Services]
, [Injury_Month]
, [Injury_Day]
, [Injury_Year]
, [Injury_Geographical_Location]
, [Injury_Geographical_Location_other]
, [Injury_City]
, [Who_Referred_You]
, [Who_Referred_You_Other]
, [Bullet_Injury_Ind]
, [Blast_Explosion_Ind]
, [Distance_from_Explosion_Meter]
, [Injured_on_Vehicle_Ind]
, [Injured_by_OtherSource_Desc]
, [Injury_Back_Head]
, [Injury_Back_Neck]
, [Injury_Upper_Back]
, [Injury_Lower_Back]
, [Injury_Buttocks]
, [Injury_Front_Head]
, [Injury_Front_Neck]
, [Injury_Chest]
, [Injury_Abdomen]
, [Injury_Groin_Pelvis]
, [Injury_Left_Shoulder]
, [Injury_Left_Upper_Arm]
, [Injury_Left_Lower_Arm]
, [Injury_Left_Hand_Wrist_Fingers]
, [Injury_Left_Upper_Leg_Thigh]
, [Injury_Left_Knee]
, [Injury_Left_Lower_Leg]
, [Injury_Left_Ankle]
, [Injury_Left_Foot_Toes]
, [Injury_Right_Shoulder]
, [Injury_Right_Upper_Arm]
, [Injury_Right_Lower_Arm]
, [Injury_Right_Hand_Wrist_Fingers]
, [Injury_Right_Upper_Leg_Thigh]
, [Injury_Right_Knee]
, [Injury_Right_Lower_Leg]
, [Injury_Right_Ankle]
, [Injury_Right_Foot_Toes]
, [Shrapnel_Frag_Bullet_Surgery_Ind]
, [Send_to_Lab_Analysis_Ind]
, [Fragment_Remains_inPatient_Ind]
, [Remain_in_Back_Head]
, [Remain_in_Back_Neck]
, [Remain_in_Upper_Back]
, [Remain_in_Lower_Back]
, [Remain_in_Buttocks]
, [Remain_in_Front_Head]
, [Remain_in_Front_Neck]
, [Remain_in_Chest]
, [Remain_in_Abdomen]
, [Remain_in_Groin_Pelvis]
, [Remain_in_Left_Shoulder]
, [Remain_in_Left_Upper_Arm]
, [Remain_in_Left_Lower_Arm]
, [Remain_in_Left_Hand_Wrist_Fingers]
, [Remain_in_Left_Upper_Leg_Thigh]
, [Remain_in_Left_Knee]
, [Remain_in_Left_Lower_Leg]
, [Remain_in_Left_Ankle]
, [Remain_in_Left_Foot_Toes]
, [Remain_in_Right_Shoulder]
, [Remain_in_Right_Upper_Arm]
, [Remain_in_Right_Lower_Arm]
, [Remain_in_Right_Hand_Wrist_Fingers]
, [Remain_in_Right_Upper_Leg_Thigh]
, [Remain_in_Right_Knee]
, [Remain_in_Right_Lower_Leg]
, [Remain_in_Right_Ankle]
, [Remain_in_Right_Foot_Toes]
, [Treated_In_the_Where]
, [Other_Foreign_Material_Ind]
, [Other_Foreign_Material_Desc]
, [Urine_Collection_Ind]
, [Date_Urine_Collected]
, [Shrapnel_In_Body_Ind]
, [Shrapnel_In_Body_Desc]
, [CREATED]
, [CREATEDBY]
, [UPDATED]
, [UPDATEDBY]
, [TREATLOCAT_FIELD]
, [TREATLOCAT_SUPPORTHOSP]
, [TREATLOCAT_GERMANY]
, [TREATLOCAT_FACILITY]
, [TREATLOCAT_MEDCENTER]
, [TREATLOCAT_FIELD_Where]
, [TREATLOCAT_SUPPORTHOSP_Where]
, [TREATLOCAT_FACILITY_Where]
, [TREATLOCAT_MEDCENTER_Where]
, [Other_Foreign_Material_DescLoca]
, [Shrapnel_In_Body_DescLoca]
, [Injured_by_IED_FLAG]
, [Injured_by_RPG_FLAG]
, [Injured_by_LandMine_FLAG]
, [Injured_by_Grenade_FLAG]
, [Injured_by_EnemyFire_FLAG]
, [Injured_by_FriendlyFire_FLAG]
, [Injured_by_UnknownSource_FLAG]
, [Injured_by_OtherSource_FLAG]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ID]
, [WKF_CASE_ACTIVITY_ID]
, [VAMC_Name]
, [VAMC_Street_Address1]
, [VAMC_Street_Address2]
, [VAMC_Street_Address3]
, [VAMC_City]
, [VAMC_State]
, [VAMC_PostalCiode]
, [VAMC_ZipPlus4]
, [VAMC_Country]
, [Form_Complete_Date]
, [Branch_of_Services]
, [Injury_Month]
, [Injury_Day]
, [Injury_Year]
, [Injury_Geographical_Location]
, [Injury_Geographical_Location_other]
, [Injury_City]
, [Who_Referred_You]
, [Who_Referred_You_Other]
, [Bullet_Injury_Ind]
, [Blast_Explosion_Ind]
, [Distance_from_Explosion_Meter]
, [Injured_on_Vehicle_Ind]
, [Injured_by_OtherSource_Desc]
, [Injury_Back_Head]
, [Injury_Back_Neck]
, [Injury_Upper_Back]
, [Injury_Lower_Back]
, [Injury_Buttocks]
, [Injury_Front_Head]
, [Injury_Front_Neck]
, [Injury_Chest]
, [Injury_Abdomen]
, [Injury_Groin_Pelvis]
, [Injury_Left_Shoulder]
, [Injury_Left_Upper_Arm]
, [Injury_Left_Lower_Arm]
, [Injury_Left_Hand_Wrist_Fingers]
, [Injury_Left_Upper_Leg_Thigh]
, [Injury_Left_Knee]
, [Injury_Left_Lower_Leg]
, [Injury_Left_Ankle]
, [Injury_Left_Foot_Toes]
, [Injury_Right_Shoulder]
, [Injury_Right_Upper_Arm]
, [Injury_Right_Lower_Arm]
, [Injury_Right_Hand_Wrist_Fingers]
, [Injury_Right_Upper_Leg_Thigh]
, [Injury_Right_Knee]
, [Injury_Right_Lower_Leg]
, [Injury_Right_Ankle]
, [Injury_Right_Foot_Toes]
, [Shrapnel_Frag_Bullet_Surgery_Ind]
, [Send_to_Lab_Analysis_Ind]
, [Fragment_Remains_inPatient_Ind]
, [Remain_in_Back_Head]
, [Remain_in_Back_Neck]
, [Remain_in_Upper_Back]
, [Remain_in_Lower_Back]
, [Remain_in_Buttocks]
, [Remain_in_Front_Head]
, [Remain_in_Front_Neck]
, [Remain_in_Chest]
, [Remain_in_Abdomen]
, [Remain_in_Groin_Pelvis]
, [Remain_in_Left_Shoulder]
, [Remain_in_Left_Upper_Arm]
, [Remain_in_Left_Lower_Arm]
, [Remain_in_Left_Hand_Wrist_Fingers]
, [Remain_in_Left_Upper_Leg_Thigh]
, [Remain_in_Left_Knee]
, [Remain_in_Left_Lower_Leg]
, [Remain_in_Left_Ankle]
, [Remain_in_Left_Foot_Toes]
, [Remain_in_Right_Shoulder]
, [Remain_in_Right_Upper_Arm]
, [Remain_in_Right_Lower_Arm]
, [Remain_in_Right_Hand_Wrist_Fingers]
, [Remain_in_Right_Upper_Leg_Thigh]
, [Remain_in_Right_Knee]
, [Remain_in_Right_Lower_Leg]
, [Remain_in_Right_Ankle]
, [Remain_in_Right_Foot_Toes]
, [Treated_In_the_Where]
, [Other_Foreign_Material_Ind]
, [Other_Foreign_Material_Desc]
, [Urine_Collection_Ind]
, [Date_Urine_Collected]
, [Shrapnel_In_Body_Ind]
, [Shrapnel_In_Body_Desc]
, [CREATED]
, [CREATEDBY]
, [UPDATED]
, [UPDATEDBY]
, [TREATLOCAT_FIELD]
, [TREATLOCAT_SUPPORTHOSP]
, [TREATLOCAT_GERMANY]
, [TREATLOCAT_FACILITY]
, [TREATLOCAT_MEDCENTER]
, [TREATLOCAT_FIELD_Where]
, [TREATLOCAT_SUPPORTHOSP_Where]
, [TREATLOCAT_FACILITY_Where]
, [TREATLOCAT_MEDCENTER_Where]
, [Other_Foreign_Material_DescLoca]
, [Shrapnel_In_Body_DescLoca]
, [Injured_by_IED_FLAG]
, [Injured_by_RPG_FLAG]
, [Injured_by_LandMine_FLAG]
, [Injured_by_Grenade_FLAG]
, [Injured_by_EnemyFire_FLAG]
, [Injured_by_FriendlyFire_FLAG]
, [Injured_by_UnknownSource_FLAG]
, [Injured_by_OtherSource_FLAG]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[EFR].[TRG_QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT_DEL_H]'))
DROP TRIGGER [EFR].[TRG_QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT_DEL_H]
go
CREATE TRIGGER  [EFR].[TRG_QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT_DEL_H]
on  [EFR].[QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [EFR].[QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ID]
, [WKF_CASE_ACTIVITY_ID]
, [VAMC_Name]
, [VAMC_Street_Address1]
, [VAMC_Street_Address2]
, [VAMC_Street_Address3]
, [VAMC_City]
, [VAMC_State]
, [VAMC_PostalCiode]
, [VAMC_ZipPlus4]
, [VAMC_Country]
, [Form_Complete_Date]
, [Branch_of_Services]
, [Injury_Month]
, [Injury_Day]
, [Injury_Year]
, [Injury_Geographical_Location]
, [Injury_Geographical_Location_other]
, [Injury_City]
, [Who_Referred_You]
, [Who_Referred_You_Other]
, [Bullet_Injury_Ind]
, [Blast_Explosion_Ind]
, [Distance_from_Explosion_Meter]
, [Injured_on_Vehicle_Ind]
, [Injured_by_OtherSource_Desc]
, [Injury_Back_Head]
, [Injury_Back_Neck]
, [Injury_Upper_Back]
, [Injury_Lower_Back]
, [Injury_Buttocks]
, [Injury_Front_Head]
, [Injury_Front_Neck]
, [Injury_Chest]
, [Injury_Abdomen]
, [Injury_Groin_Pelvis]
, [Injury_Left_Shoulder]
, [Injury_Left_Upper_Arm]
, [Injury_Left_Lower_Arm]
, [Injury_Left_Hand_Wrist_Fingers]
, [Injury_Left_Upper_Leg_Thigh]
, [Injury_Left_Knee]
, [Injury_Left_Lower_Leg]
, [Injury_Left_Ankle]
, [Injury_Left_Foot_Toes]
, [Injury_Right_Shoulder]
, [Injury_Right_Upper_Arm]
, [Injury_Right_Lower_Arm]
, [Injury_Right_Hand_Wrist_Fingers]
, [Injury_Right_Upper_Leg_Thigh]
, [Injury_Right_Knee]
, [Injury_Right_Lower_Leg]
, [Injury_Right_Ankle]
, [Injury_Right_Foot_Toes]
, [Shrapnel_Frag_Bullet_Surgery_Ind]
, [Send_to_Lab_Analysis_Ind]
, [Fragment_Remains_inPatient_Ind]
, [Remain_in_Back_Head]
, [Remain_in_Back_Neck]
, [Remain_in_Upper_Back]
, [Remain_in_Lower_Back]
, [Remain_in_Buttocks]
, [Remain_in_Front_Head]
, [Remain_in_Front_Neck]
, [Remain_in_Chest]
, [Remain_in_Abdomen]
, [Remain_in_Groin_Pelvis]
, [Remain_in_Left_Shoulder]
, [Remain_in_Left_Upper_Arm]
, [Remain_in_Left_Lower_Arm]
, [Remain_in_Left_Hand_Wrist_Fingers]
, [Remain_in_Left_Upper_Leg_Thigh]
, [Remain_in_Left_Knee]
, [Remain_in_Left_Lower_Leg]
, [Remain_in_Left_Ankle]
, [Remain_in_Left_Foot_Toes]
, [Remain_in_Right_Shoulder]
, [Remain_in_Right_Upper_Arm]
, [Remain_in_Right_Lower_Arm]
, [Remain_in_Right_Hand_Wrist_Fingers]
, [Remain_in_Right_Upper_Leg_Thigh]
, [Remain_in_Right_Knee]
, [Remain_in_Right_Lower_Leg]
, [Remain_in_Right_Ankle]
, [Remain_in_Right_Foot_Toes]
, [Treated_In_the_Where]
, [Other_Foreign_Material_Ind]
, [Other_Foreign_Material_Desc]
, [Urine_Collection_Ind]
, [Date_Urine_Collected]
, [Shrapnel_In_Body_Ind]
, [Shrapnel_In_Body_Desc]
, [CREATED]
, [CREATEDBY]
, [UPDATED]
, [UPDATEDBY]
, [TREATLOCAT_FIELD]
, [TREATLOCAT_SUPPORTHOSP]
, [TREATLOCAT_GERMANY]
, [TREATLOCAT_FACILITY]
, [TREATLOCAT_MEDCENTER]
, [TREATLOCAT_FIELD_Where]
, [TREATLOCAT_SUPPORTHOSP_Where]
, [TREATLOCAT_FACILITY_Where]
, [TREATLOCAT_MEDCENTER_Where]
, [Other_Foreign_Material_DescLoca]
, [Shrapnel_In_Body_DescLoca]
, [Injured_by_IED_FLAG]
, [Injured_by_RPG_FLAG]
, [Injured_by_LandMine_FLAG]
, [Injured_by_Grenade_FLAG]
, [Injured_by_EnemyFire_FLAG]
, [Injured_by_FriendlyFire_FLAG]
, [Injured_by_UnknownSource_FLAG]
, [Injured_by_OtherSource_FLAG]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ID]
, [WKF_CASE_ACTIVITY_ID]
, [VAMC_Name]
, [VAMC_Street_Address1]
, [VAMC_Street_Address2]
, [VAMC_Street_Address3]
, [VAMC_City]
, [VAMC_State]
, [VAMC_PostalCiode]
, [VAMC_ZipPlus4]
, [VAMC_Country]
, [Form_Complete_Date]
, [Branch_of_Services]
, [Injury_Month]
, [Injury_Day]
, [Injury_Year]
, [Injury_Geographical_Location]
, [Injury_Geographical_Location_other]
, [Injury_City]
, [Who_Referred_You]
, [Who_Referred_You_Other]
, [Bullet_Injury_Ind]
, [Blast_Explosion_Ind]
, [Distance_from_Explosion_Meter]
, [Injured_on_Vehicle_Ind]
, [Injured_by_OtherSource_Desc]
, [Injury_Back_Head]
, [Injury_Back_Neck]
, [Injury_Upper_Back]
, [Injury_Lower_Back]
, [Injury_Buttocks]
, [Injury_Front_Head]
, [Injury_Front_Neck]
, [Injury_Chest]
, [Injury_Abdomen]
, [Injury_Groin_Pelvis]
, [Injury_Left_Shoulder]
, [Injury_Left_Upper_Arm]
, [Injury_Left_Lower_Arm]
, [Injury_Left_Hand_Wrist_Fingers]
, [Injury_Left_Upper_Leg_Thigh]
, [Injury_Left_Knee]
, [Injury_Left_Lower_Leg]
, [Injury_Left_Ankle]
, [Injury_Left_Foot_Toes]
, [Injury_Right_Shoulder]
, [Injury_Right_Upper_Arm]
, [Injury_Right_Lower_Arm]
, [Injury_Right_Hand_Wrist_Fingers]
, [Injury_Right_Upper_Leg_Thigh]
, [Injury_Right_Knee]
, [Injury_Right_Lower_Leg]
, [Injury_Right_Ankle]
, [Injury_Right_Foot_Toes]
, [Shrapnel_Frag_Bullet_Surgery_Ind]
, [Send_to_Lab_Analysis_Ind]
, [Fragment_Remains_inPatient_Ind]
, [Remain_in_Back_Head]
, [Remain_in_Back_Neck]
, [Remain_in_Upper_Back]
, [Remain_in_Lower_Back]
, [Remain_in_Buttocks]
, [Remain_in_Front_Head]
, [Remain_in_Front_Neck]
, [Remain_in_Chest]
, [Remain_in_Abdomen]
, [Remain_in_Groin_Pelvis]
, [Remain_in_Left_Shoulder]
, [Remain_in_Left_Upper_Arm]
, [Remain_in_Left_Lower_Arm]
, [Remain_in_Left_Hand_Wrist_Fingers]
, [Remain_in_Left_Upper_Leg_Thigh]
, [Remain_in_Left_Knee]
, [Remain_in_Left_Lower_Leg]
, [Remain_in_Left_Ankle]
, [Remain_in_Left_Foot_Toes]
, [Remain_in_Right_Shoulder]
, [Remain_in_Right_Upper_Arm]
, [Remain_in_Right_Lower_Arm]
, [Remain_in_Right_Hand_Wrist_Fingers]
, [Remain_in_Right_Upper_Leg_Thigh]
, [Remain_in_Right_Knee]
, [Remain_in_Right_Lower_Leg]
, [Remain_in_Right_Ankle]
, [Remain_in_Right_Foot_Toes]
, [Treated_In_the_Where]
, [Other_Foreign_Material_Ind]
, [Other_Foreign_Material_Desc]
, [Urine_Collection_Ind]
, [Date_Urine_Collected]
, [Shrapnel_In_Body_Ind]
, [Shrapnel_In_Body_Desc]
, [CREATED]
, [CREATEDBY]
, [UPDATED]
, [UPDATEDBY]
, [TREATLOCAT_FIELD]
, [TREATLOCAT_SUPPORTHOSP]
, [TREATLOCAT_GERMANY]
, [TREATLOCAT_FACILITY]
, [TREATLOCAT_MEDCENTER]
, [TREATLOCAT_FIELD_Where]
, [TREATLOCAT_SUPPORTHOSP_Where]
, [TREATLOCAT_FACILITY_Where]
, [TREATLOCAT_MEDCENTER_Where]
, [Other_Foreign_Material_DescLoca]
, [Shrapnel_In_Body_DescLoca]
, [Injured_by_IED_FLAG]
, [Injured_by_RPG_FLAG]
, [Injured_by_LandMine_FLAG]
, [Injured_by_Grenade_FLAG]
, [Injured_by_EnemyFire_FLAG]
, [Injured_by_FriendlyFire_FLAG]
, [Injured_by_UnknownSource_FLAG]
, [Injured_by_OtherSource_FLAG]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[EFR].[TRG_QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM_H]'))
DROP TRIGGER [EFR].[TRG_QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM_H]
GO
Create trigger [EFR].[TRG_QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM_H] on [EFR].[QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [EFR].[QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ID]
, [WKF_CASE_ACTIVITY_ID]
, [Date_Lab_Received_Specimen]
, [Fragment_1_Location]
, [Fragment_2_Location]
, [Fragment_3_Location]
, [Date_Fragment_Removal]
, [Duty_Location_Injury_Occurred]
, [Other_Location_Injury_Occurred]
, [Name_Referring_VAMC]
, [Referring_VAMC_Street_Address1]
, [Referring_VAMC_Street_Address2]
, [Referring_VAMC_Street_Address3]
, [Referring_VAMC_City]
, [Referring_VAMC_State]
, [Referring_VAMC_PostalCode]
, [Referring_VAMC_ZipPlus4]
, [Referring_VAMC_Country]
, [Referring_Provider_Name]
, [Provider_Pager_Number]
, [Provider_Telephone_Number]
, [Provider_Fax_Number]
, [Referring_Facility_Contact_Name]
, [Referring_Facility_Contact_Phone]
, [Referring_VAMC_MailCode]
, [CREATED]
, [CREATEDBY]
, [UPDATED]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ID]
, [WKF_CASE_ACTIVITY_ID]
, [Date_Lab_Received_Specimen]
, [Fragment_1_Location]
, [Fragment_2_Location]
, [Fragment_3_Location]
, [Date_Fragment_Removal]
, [Duty_Location_Injury_Occurred]
, [Other_Location_Injury_Occurred]
, [Name_Referring_VAMC]
, [Referring_VAMC_Street_Address1]
, [Referring_VAMC_Street_Address2]
, [Referring_VAMC_Street_Address3]
, [Referring_VAMC_City]
, [Referring_VAMC_State]
, [Referring_VAMC_PostalCode]
, [Referring_VAMC_ZipPlus4]
, [Referring_VAMC_Country]
, [Referring_Provider_Name]
, [Provider_Pager_Number]
, [Provider_Telephone_Number]
, [Provider_Fax_Number]
, [Referring_Facility_Contact_Name]
, [Referring_Facility_Contact_Phone]
, [Referring_VAMC_MailCode]
, [CREATED]
, [CREATEDBY]
, [UPDATED]
, [UPDATEDBY]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[EFR].[TRG_QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM_DEL_H]'))
DROP TRIGGER [EFR].[TRG_QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM_DEL_H]
go
CREATE TRIGGER  [EFR].[TRG_QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM_DEL_H]
on  [EFR].[QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [EFR].[QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ID]
, [WKF_CASE_ACTIVITY_ID]
, [Date_Lab_Received_Specimen]
, [Fragment_1_Location]
, [Fragment_2_Location]
, [Fragment_3_Location]
, [Date_Fragment_Removal]
, [Duty_Location_Injury_Occurred]
, [Other_Location_Injury_Occurred]
, [Name_Referring_VAMC]
, [Referring_VAMC_Street_Address1]
, [Referring_VAMC_Street_Address2]
, [Referring_VAMC_Street_Address3]
, [Referring_VAMC_City]
, [Referring_VAMC_State]
, [Referring_VAMC_PostalCode]
, [Referring_VAMC_ZipPlus4]
, [Referring_VAMC_Country]
, [Referring_Provider_Name]
, [Provider_Pager_Number]
, [Provider_Telephone_Number]
, [Provider_Fax_Number]
, [Referring_Facility_Contact_Name]
, [Referring_Facility_Contact_Phone]
, [Referring_VAMC_MailCode]
, [CREATED]
, [CREATEDBY]
, [UPDATED]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ID]
, [WKF_CASE_ACTIVITY_ID]
, [Date_Lab_Received_Specimen]
, [Fragment_1_Location]
, [Fragment_2_Location]
, [Fragment_3_Location]
, [Date_Fragment_Removal]
, [Duty_Location_Injury_Occurred]
, [Other_Location_Injury_Occurred]
, [Name_Referring_VAMC]
, [Referring_VAMC_Street_Address1]
, [Referring_VAMC_Street_Address2]
, [Referring_VAMC_Street_Address3]
, [Referring_VAMC_City]
, [Referring_VAMC_State]
, [Referring_VAMC_PostalCode]
, [Referring_VAMC_ZipPlus4]
, [Referring_VAMC_Country]
, [Referring_Provider_Name]
, [Provider_Pager_Number]
, [Provider_Telephone_Number]
, [Provider_Fax_Number]
, [Referring_Facility_Contact_Name]
, [Referring_Facility_Contact_Phone]
, [Referring_VAMC_MailCode]
, [CREATED]
, [CREATEDBY]
, [UPDATED]
, [UPDATEDBY]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_REFERRAL_H]'))
DROP TRIGGER [dbo].[TRG_REFERRAL_H]
GO
Create trigger [dbo].[TRG_REFERRAL_H] on [dbo].[REFERRAL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [dbo].[REFERRAL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REFERRAL_ID]
, [STD_REFERRALSTS_ID]
, [STD_REGISTRY_ID]
, [PATIENT_ID]
, [STD_INSTITUTION_ID]
, [REFERRAL_DATE]
, [REFERRAL_CLASS_TEXT]
, [PROVIDER_ID_NUMBER]
, [PROVIDER_NAME]
, [PROVIDER_PHONE]
, [PROVIDER_EMAIL]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [COMMENT_TEXT]
, [ADDRESS_LINE1]
, [ADDRESS_LINE2]
, [ADDRESS_LINE3]
, [CITY]
, [COUNTRY]
, [COUNTY]
, [POSTAL_CODE]
, [STATE]
, [VAMC_CONTACT_EMAIL]
, [VAMC_CONTACT_NAME]
, [VAMC_CONTACT_PHONE]
, [ZIP_PLUS_4]
, [VAMC_CONTACT_FAX]
, [PROVIDER_ADDRESS_LINE1]
, [PROVIDER_ADDRESS_LINE2]
, [PROVIDER_ADDRESS_LINE3]
, [PROVIDER_CITY]
, [PROVIDER_STATE]
, [PROVIDER_COUNTY]
, [PROVIDER_COUNTRY]
, [PROVIDER_POSTAL_CODE]
, [PROVIDER_ZIP_PLUS_4]
, [PROVIDER_FAX]
, [STD_REMINDERCLASS_ID]
, [REVIEW_BY]
, [REVIEW_DATE]
, [DUPLICATE_FLAG]
, [ORDERBY_PROVIDER_ID_NUMBER]
, [ORDERBY_PROVIDER_NAME]
, [ORDERBY_PROVIDER_PHONE]
, [ORDERBY_PROVIDER_EMAIL]
, [ORDERBY_PROVIDER_ADDRESS_LINE1]
, [ORDERBY_PROVIDER_ADDRESS_LINE2]
, [ORDERBY_PROVIDER_ADDRESS_LINE3]
, [ORDERBY_PROVIDER_CITY]
, [ORDERBY_PROVIDER_STATE]
, [ORDERBY_PROVIDER_COUNTRY]
, [ORDERBY_PROVIDER_POSTAL_CODE]
, [ORDERBY_PROVIDER_ZIP_PLUS_4]
, [ORDERBY_PROVIDER_FAX]
, [STD_REFERRALRANK_ID]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [REFERRAL_ID]
, [STD_REFERRALSTS_ID]
, [STD_REGISTRY_ID]
, [PATIENT_ID]
, [STD_INSTITUTION_ID]
, [REFERRAL_DATE]
, [REFERRAL_CLASS_TEXT]
, [PROVIDER_ID_NUMBER]
, [PROVIDER_NAME]
, [PROVIDER_PHONE]
, [PROVIDER_EMAIL]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [COMMENT_TEXT]
, [ADDRESS_LINE1]
, [ADDRESS_LINE2]
, [ADDRESS_LINE3]
, [CITY]
, [COUNTRY]
, [COUNTY]
, [POSTAL_CODE]
, [STATE]
, [VAMC_CONTACT_EMAIL]
, [VAMC_CONTACT_NAME]
, [VAMC_CONTACT_PHONE]
, [ZIP_PLUS_4]
, [VAMC_CONTACT_FAX]
, [PROVIDER_ADDRESS_LINE1]
, [PROVIDER_ADDRESS_LINE2]
, [PROVIDER_ADDRESS_LINE3]
, [PROVIDER_CITY]
, [PROVIDER_STATE]
, [PROVIDER_COUNTY]
, [PROVIDER_COUNTRY]
, [PROVIDER_POSTAL_CODE]
, [PROVIDER_ZIP_PLUS_4]
, [PROVIDER_FAX]
, [STD_REMINDERCLASS_ID]
, [REVIEW_BY]
, [REVIEW_DATE]
, [DUPLICATE_FLAG]
, [ORDERBY_PROVIDER_ID_NUMBER]
, [ORDERBY_PROVIDER_NAME]
, [ORDERBY_PROVIDER_PHONE]
, [ORDERBY_PROVIDER_EMAIL]
, [ORDERBY_PROVIDER_ADDRESS_LINE1]
, [ORDERBY_PROVIDER_ADDRESS_LINE2]
, [ORDERBY_PROVIDER_ADDRESS_LINE3]
, [ORDERBY_PROVIDER_CITY]
, [ORDERBY_PROVIDER_STATE]
, [ORDERBY_PROVIDER_COUNTRY]
, [ORDERBY_PROVIDER_POSTAL_CODE]
, [ORDERBY_PROVIDER_ZIP_PLUS_4]
, [ORDERBY_PROVIDER_FAX]
, [STD_REFERRALRANK_ID]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[dbo].[TRG_REFERRAL_DEL_H]'))
DROP TRIGGER [dbo].[TRG_REFERRAL_DEL_H]
go
CREATE TRIGGER  [dbo].[TRG_REFERRAL_DEL_H]
on  [dbo].[REFERRAL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [dbo].[REFERRAL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REFERRAL_ID]
, [STD_REFERRALSTS_ID]
, [STD_REGISTRY_ID]
, [PATIENT_ID]
, [STD_INSTITUTION_ID]
, [REFERRAL_DATE]
, [REFERRAL_CLASS_TEXT]
, [PROVIDER_ID_NUMBER]
, [PROVIDER_NAME]
, [PROVIDER_PHONE]
, [PROVIDER_EMAIL]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [COMMENT_TEXT]
, [ADDRESS_LINE1]
, [ADDRESS_LINE2]
, [ADDRESS_LINE3]
, [CITY]
, [COUNTRY]
, [COUNTY]
, [POSTAL_CODE]
, [STATE]
, [VAMC_CONTACT_EMAIL]
, [VAMC_CONTACT_NAME]
, [VAMC_CONTACT_PHONE]
, [ZIP_PLUS_4]
, [VAMC_CONTACT_FAX]
, [PROVIDER_ADDRESS_LINE1]
, [PROVIDER_ADDRESS_LINE2]
, [PROVIDER_ADDRESS_LINE3]
, [PROVIDER_CITY]
, [PROVIDER_STATE]
, [PROVIDER_COUNTY]
, [PROVIDER_COUNTRY]
, [PROVIDER_POSTAL_CODE]
, [PROVIDER_ZIP_PLUS_4]
, [PROVIDER_FAX]
, [STD_REMINDERCLASS_ID]
, [REVIEW_BY]
, [REVIEW_DATE]
, [DUPLICATE_FLAG]
, [ORDERBY_PROVIDER_ID_NUMBER]
, [ORDERBY_PROVIDER_NAME]
, [ORDERBY_PROVIDER_PHONE]
, [ORDERBY_PROVIDER_EMAIL]
, [ORDERBY_PROVIDER_ADDRESS_LINE1]
, [ORDERBY_PROVIDER_ADDRESS_LINE2]
, [ORDERBY_PROVIDER_ADDRESS_LINE3]
, [ORDERBY_PROVIDER_CITY]
, [ORDERBY_PROVIDER_STATE]
, [ORDERBY_PROVIDER_COUNTRY]
, [ORDERBY_PROVIDER_POSTAL_CODE]
, [ORDERBY_PROVIDER_ZIP_PLUS_4]
, [ORDERBY_PROVIDER_FAX]
, [STD_REFERRALRANK_ID]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [REFERRAL_ID]
, [STD_REFERRALSTS_ID]
, [STD_REGISTRY_ID]
, [PATIENT_ID]
, [STD_INSTITUTION_ID]
, [REFERRAL_DATE]
, [REFERRAL_CLASS_TEXT]
, [PROVIDER_ID_NUMBER]
, [PROVIDER_NAME]
, [PROVIDER_PHONE]
, [PROVIDER_EMAIL]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [COMMENT_TEXT]
, [ADDRESS_LINE1]
, [ADDRESS_LINE2]
, [ADDRESS_LINE3]
, [CITY]
, [COUNTRY]
, [COUNTY]
, [POSTAL_CODE]
, [STATE]
, [VAMC_CONTACT_EMAIL]
, [VAMC_CONTACT_NAME]
, [VAMC_CONTACT_PHONE]
, [ZIP_PLUS_4]
, [VAMC_CONTACT_FAX]
, [PROVIDER_ADDRESS_LINE1]
, [PROVIDER_ADDRESS_LINE2]
, [PROVIDER_ADDRESS_LINE3]
, [PROVIDER_CITY]
, [PROVIDER_STATE]
, [PROVIDER_COUNTY]
, [PROVIDER_COUNTRY]
, [PROVIDER_POSTAL_CODE]
, [PROVIDER_ZIP_PLUS_4]
, [PROVIDER_FAX]
, [STD_REMINDERCLASS_ID]
, [REVIEW_BY]
, [REVIEW_DATE]
, [DUPLICATE_FLAG]
, [ORDERBY_PROVIDER_ID_NUMBER]
, [ORDERBY_PROVIDER_NAME]
, [ORDERBY_PROVIDER_PHONE]
, [ORDERBY_PROVIDER_EMAIL]
, [ORDERBY_PROVIDER_ADDRESS_LINE1]
, [ORDERBY_PROVIDER_ADDRESS_LINE2]
, [ORDERBY_PROVIDER_ADDRESS_LINE3]
, [ORDERBY_PROVIDER_CITY]
, [ORDERBY_PROVIDER_STATE]
, [ORDERBY_PROVIDER_COUNTRY]
, [ORDERBY_PROVIDER_POSTAL_CODE]
, [ORDERBY_PROVIDER_ZIP_PLUS_4]
, [ORDERBY_PROVIDER_FAX]
, [STD_REFERRALRANK_ID]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_REFERRAL_DETAIL_H]'))
DROP TRIGGER [dbo].[TRG_REFERRAL_DETAIL_H]
GO
Create trigger [dbo].[TRG_REFERRAL_DETAIL_H] on [dbo].[REFERRAL_DETAIL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [dbo].[REFERRAL_DETAIL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REFERRAL_DETAIL_ID]
, [REFERRAL_ID]
, [STD_HEALTHFACTOR_ID]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [COMMENT_TEXT]
, [HF_IEN]
, [DFN]
, [HF_VISITID]
, [VISIT_IEN]
, [ICN]
, [Clinic]
, [CurSta3n]
, [AdmParent_Key]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [REFERRAL_DETAIL_ID]
, [REFERRAL_ID]
, [STD_HEALTHFACTOR_ID]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [COMMENT_TEXT]
, [HF_IEN]
, [DFN]
, [HF_VISITID]
, [VISIT_IEN]
, [ICN]
, [Clinic]
, [CurSta3n]
, [AdmParent_Key]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[dbo].[TRG_REFERRAL_DETAIL_DEL_H]'))
DROP TRIGGER [dbo].[TRG_REFERRAL_DETAIL_DEL_H]
go
CREATE TRIGGER  [dbo].[TRG_REFERRAL_DETAIL_DEL_H]
on  [dbo].[REFERRAL_DETAIL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [dbo].[REFERRAL_DETAIL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REFERRAL_DETAIL_ID]
, [REFERRAL_ID]
, [STD_HEALTHFACTOR_ID]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [COMMENT_TEXT]
, [HF_IEN]
, [DFN]
, [HF_VISITID]
, [VISIT_IEN]
, [ICN]
, [Clinic]
, [CurSta3n]
, [AdmParent_Key]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [REFERRAL_DETAIL_ID]
, [REFERRAL_ID]
, [STD_HEALTHFACTOR_ID]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [COMMENT_TEXT]
, [HF_IEN]
, [DFN]
, [HF_VISITID]
, [VISIT_IEN]
, [ICN]
, [Clinic]
, [CurSta3n]
, [AdmParent_Key]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_REGISTRY_DEMOGRAPHICS_H]'))
DROP TRIGGER [dbo].[TRG_REGISTRY_DEMOGRAPHICS_H]
GO
Create trigger [dbo].[TRG_REGISTRY_DEMOGRAPHICS_H] on [dbo].[REGISTRY_DEMOGRAPHICS]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [dbo].[REGISTRY_DEMOGRAPHICS_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REGISTRY_DEMOGRAPHICS_ID]
, [PATIENT_ID]
, [STD_REGISTRY_ID]
, [ADMIT_DATE_TXT]
, [SERVICE_CONNECTED_IND]
, [INPATIENT_IND]
, [ADDRESS_LINE1]
, [ADDRESS_LINE2]
, [ADDRESS_LINE3]
, [CITY]
, [POSTAL_CODE]
, [HOME_PHONE]
, [CELL_PHONE]
, [ALT_PHONE]
, [EMAIL_ADDRESS]
, [ALT_EMAIL_ADDRESS]
, [ADDRESS_ERROR_CODE]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [STD_ADDRESSTYPE_ID]
, [ZIP_PLUS_4]
, [WORK_PHONE]
, [STATE]
, [COUNTY]
, [COUNTRY]
, [PREFERRED_PHONE_TYPE]
, [NEXT_OF_KIN_RELATIONSHIP]
, [NEXT_OF_KIN_FNAME]
, [NEXT_OF_KIN_MNAME]
, [NEXT_OF_KIN_LNAME]
, [TEMPORARY_ADDRESS_START_DATE]
, [TEMPORARY_ADDRESS_END_DATE]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [REGISTRY_DEMOGRAPHICS_ID]
, [PATIENT_ID]
, [STD_REGISTRY_ID]
, [ADMIT_DATE_TXT]
, [SERVICE_CONNECTED_IND]
, [INPATIENT_IND]
, [ADDRESS_LINE1]
, [ADDRESS_LINE2]
, [ADDRESS_LINE3]
, [CITY]
, [POSTAL_CODE]
, [HOME_PHONE]
, [CELL_PHONE]
, [ALT_PHONE]
, [EMAIL_ADDRESS]
, [ALT_EMAIL_ADDRESS]
, [ADDRESS_ERROR_CODE]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [STD_ADDRESSTYPE_ID]
, [ZIP_PLUS_4]
, [WORK_PHONE]
, [STATE]
, [COUNTY]
, [COUNTRY]
, [PREFERRED_PHONE_TYPE]
, [NEXT_OF_KIN_RELATIONSHIP]
, [NEXT_OF_KIN_FNAME]
, [NEXT_OF_KIN_MNAME]
, [NEXT_OF_KIN_LNAME]
, [TEMPORARY_ADDRESS_START_DATE]
, [TEMPORARY_ADDRESS_END_DATE]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[dbo].[TRG_REGISTRY_DEMOGRAPHICS_DEL_H]'))
DROP TRIGGER [dbo].[TRG_REGISTRY_DEMOGRAPHICS_DEL_H]
go
CREATE TRIGGER  [dbo].[TRG_REGISTRY_DEMOGRAPHICS_DEL_H]
on  [dbo].[REGISTRY_DEMOGRAPHICS] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [dbo].[REGISTRY_DEMOGRAPHICS_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REGISTRY_DEMOGRAPHICS_ID]
, [PATIENT_ID]
, [STD_REGISTRY_ID]
, [ADMIT_DATE_TXT]
, [SERVICE_CONNECTED_IND]
, [INPATIENT_IND]
, [ADDRESS_LINE1]
, [ADDRESS_LINE2]
, [ADDRESS_LINE3]
, [CITY]
, [POSTAL_CODE]
, [HOME_PHONE]
, [CELL_PHONE]
, [ALT_PHONE]
, [EMAIL_ADDRESS]
, [ALT_EMAIL_ADDRESS]
, [ADDRESS_ERROR_CODE]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [STD_ADDRESSTYPE_ID]
, [ZIP_PLUS_4]
, [WORK_PHONE]
, [STATE]
, [COUNTY]
, [COUNTRY]
, [PREFERRED_PHONE_TYPE]
, [NEXT_OF_KIN_RELATIONSHIP]
, [NEXT_OF_KIN_FNAME]
, [NEXT_OF_KIN_MNAME]
, [NEXT_OF_KIN_LNAME]
, [TEMPORARY_ADDRESS_START_DATE]
, [TEMPORARY_ADDRESS_END_DATE]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [REGISTRY_DEMOGRAPHICS_ID]
, [PATIENT_ID]
, [STD_REGISTRY_ID]
, [ADMIT_DATE_TXT]
, [SERVICE_CONNECTED_IND]
, [INPATIENT_IND]
, [ADDRESS_LINE1]
, [ADDRESS_LINE2]
, [ADDRESS_LINE3]
, [CITY]
, [POSTAL_CODE]
, [HOME_PHONE]
, [CELL_PHONE]
, [ALT_PHONE]
, [EMAIL_ADDRESS]
, [ALT_EMAIL_ADDRESS]
, [ADDRESS_ERROR_CODE]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [STD_ADDRESSTYPE_ID]
, [ZIP_PLUS_4]
, [WORK_PHONE]
, [STATE]
, [COUNTY]
, [COUNTRY]
, [PREFERRED_PHONE_TYPE]
, [NEXT_OF_KIN_RELATIONSHIP]
, [NEXT_OF_KIN_FNAME]
, [NEXT_OF_KIN_MNAME]
, [NEXT_OF_KIN_LNAME]
, [TEMPORARY_ADDRESS_START_DATE]
, [TEMPORARY_ADDRESS_END_DATE]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_ROLE_PERMISSIONS_H]'))
DROP TRIGGER [dbo].[TRG_ROLE_PERMISSIONS_H]
GO
Create trigger [dbo].[TRG_ROLE_PERMISSIONS_H] on [dbo].[ROLE_PERMISSIONS]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [dbo].[ROLE_PERMISSIONS_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ROLE_PERMISSION_ID]
, [STD_ROLE_ID]
, [STD_APPPAGE_ID]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
, [INSERT_FLAG]
, [UPDATE_FLAG]
, [DELETE_FLAG]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ROLE_PERMISSION_ID]
, [STD_ROLE_ID]
, [STD_APPPAGE_ID]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
, [INSERT_FLAG]
, [UPDATE_FLAG]
, [DELETE_FLAG]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[dbo].[TRG_ROLE_PERMISSIONS_DEL_H]'))
DROP TRIGGER [dbo].[TRG_ROLE_PERMISSIONS_DEL_H]
go
CREATE TRIGGER  [dbo].[TRG_ROLE_PERMISSIONS_DEL_H]
on  [dbo].[ROLE_PERMISSIONS] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [dbo].[ROLE_PERMISSIONS_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ROLE_PERMISSION_ID]
, [STD_ROLE_ID]
, [STD_APPPAGE_ID]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
, [INSERT_FLAG]
, [UPDATE_FLAG]
, [DELETE_FLAG]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ROLE_PERMISSION_ID]
, [STD_ROLE_ID]
, [STD_APPPAGE_ID]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
, [INSERT_FLAG]
, [UPDATE_FLAG]
, [DELETE_FLAG]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[EFR].[TRG_SHIPPING_DETAIL_H]'))
DROP TRIGGER [EFR].[TRG_SHIPPING_DETAIL_H]
GO
Create trigger [EFR].[TRG_SHIPPING_DETAIL_H] on [EFR].[SHIPPING_DETAIL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [EFR].[SHIPPING_DETAIL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [SHIPPING_DETAIL_ID]
, [STD_REGISTRY_ID]
, [WKF_CASE_ACTIVITY_ID]
, [STD_SHIPMENTTYPE_ID]
, [REGISTRY_DEMOGRAPHICS_ID]
, [REPRESENTATIVE_NAME]
, [SEND_DATE]
, [EXPECTED_RETURN_DATE]
, [RECEIVED_DATE]
, [TRACKING_NUMBER]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [COMMENT_TEXT]
, [REFERRAL_ID]
, [STD_SHIPMENTSTS_ID]
, [STD_SHIPMETHOD_ID]
, [STDSHIPMENTTYPE_ID]
, [SURVEY_RECEIVED_FLAG]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [SHIPPING_DETAIL_ID]
, [STD_REGISTRY_ID]
, [WKF_CASE_ACTIVITY_ID]
, [STD_SHIPMENTTYPE_ID]
, [REGISTRY_DEMOGRAPHICS_ID]
, [REPRESENTATIVE_NAME]
, [SEND_DATE]
, [EXPECTED_RETURN_DATE]
, [RECEIVED_DATE]
, [TRACKING_NUMBER]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [COMMENT_TEXT]
, [REFERRAL_ID]
, [STD_SHIPMENTSTS_ID]
, [STD_SHIPMETHOD_ID]
, [STDSHIPMENTTYPE_ID]
, [SURVEY_RECEIVED_FLAG]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[EFR].[TRG_SHIPPING_DETAIL_DEL_H]'))
DROP TRIGGER [EFR].[TRG_SHIPPING_DETAIL_DEL_H]
go
CREATE TRIGGER  [EFR].[TRG_SHIPPING_DETAIL_DEL_H]
on  [EFR].[SHIPPING_DETAIL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [EFR].[SHIPPING_DETAIL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [SHIPPING_DETAIL_ID]
, [STD_REGISTRY_ID]
, [WKF_CASE_ACTIVITY_ID]
, [STD_SHIPMENTTYPE_ID]
, [REGISTRY_DEMOGRAPHICS_ID]
, [REPRESENTATIVE_NAME]
, [SEND_DATE]
, [EXPECTED_RETURN_DATE]
, [RECEIVED_DATE]
, [TRACKING_NUMBER]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [COMMENT_TEXT]
, [REFERRAL_ID]
, [STD_SHIPMENTSTS_ID]
, [STD_SHIPMETHOD_ID]
, [STDSHIPMENTTYPE_ID]
, [SURVEY_RECEIVED_FLAG]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [SHIPPING_DETAIL_ID]
, [STD_REGISTRY_ID]
, [WKF_CASE_ACTIVITY_ID]
, [STD_SHIPMENTTYPE_ID]
, [REGISTRY_DEMOGRAPHICS_ID]
, [REPRESENTATIVE_NAME]
, [SEND_DATE]
, [EXPECTED_RETURN_DATE]
, [RECEIVED_DATE]
, [TRACKING_NUMBER]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [COMMENT_TEXT]
, [REFERRAL_ID]
, [STD_SHIPMENTSTS_ID]
, [STD_SHIPMETHOD_ID]
, [STDSHIPMENTTYPE_ID]
, [SURVEY_RECEIVED_FLAG]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[EFR].[TRG_SPECIMEN_ANALYSIS_H]'))
DROP TRIGGER [EFR].[TRG_SPECIMEN_ANALYSIS_H]
GO
Create trigger [EFR].[TRG_SPECIMEN_ANALYSIS_H] on [EFR].[SPECIMEN_ANALYSIS]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [EFR].[SPECIMEN_ANALYSIS_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [SPECIMEN_ANALYSIS_ID]
, [LAB_ORDER_ID]
, [WKF_CASE_ACTIVITY_ID]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [LAB_REPORT_DATE]
, [LAB_UID_NUMBER]
, [LAB_NAME]
, [SPECIMEN_COLLECTION_DATE]
, [RESULT_ACKNOWLEDGE_FLAG]
, [RESULT_ACKNOWLEDGE_DATE]
, [RESULT_REJECT_FLAG]
, [RESULT_REJECT_DATE]
, [TIME_ELAPSED_NUMBER]
, [TOTAL_VOLUME_NUMBER]
, [ANALYTE_VOLUME_NUMBER]
, [BSO_NUMBER]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [SPECIMEN_ANALYSIS_ID]
, [LAB_ORDER_ID]
, [WKF_CASE_ACTIVITY_ID]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [LAB_REPORT_DATE]
, [LAB_UID_NUMBER]
, [LAB_NAME]
, [SPECIMEN_COLLECTION_DATE]
, [RESULT_ACKNOWLEDGE_FLAG]
, [RESULT_ACKNOWLEDGE_DATE]
, [RESULT_REJECT_FLAG]
, [RESULT_REJECT_DATE]
, [TIME_ELAPSED_NUMBER]
, [TOTAL_VOLUME_NUMBER]
, [ANALYTE_VOLUME_NUMBER]
, [BSO_NUMBER]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[EFR].[TRG_SPECIMEN_ANALYSIS_DEL_H]'))
DROP TRIGGER [EFR].[TRG_SPECIMEN_ANALYSIS_DEL_H]
go
CREATE TRIGGER  [EFR].[TRG_SPECIMEN_ANALYSIS_DEL_H]
on  [EFR].[SPECIMEN_ANALYSIS] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [EFR].[SPECIMEN_ANALYSIS_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [SPECIMEN_ANALYSIS_ID]
, [LAB_ORDER_ID]
, [WKF_CASE_ACTIVITY_ID]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [LAB_REPORT_DATE]
, [LAB_UID_NUMBER]
, [LAB_NAME]
, [SPECIMEN_COLLECTION_DATE]
, [RESULT_ACKNOWLEDGE_FLAG]
, [RESULT_ACKNOWLEDGE_DATE]
, [RESULT_REJECT_FLAG]
, [RESULT_REJECT_DATE]
, [TIME_ELAPSED_NUMBER]
, [TOTAL_VOLUME_NUMBER]
, [ANALYTE_VOLUME_NUMBER]
, [BSO_NUMBER]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [SPECIMEN_ANALYSIS_ID]
, [LAB_ORDER_ID]
, [WKF_CASE_ACTIVITY_ID]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [LAB_REPORT_DATE]
, [LAB_UID_NUMBER]
, [LAB_NAME]
, [SPECIMEN_COLLECTION_DATE]
, [RESULT_ACKNOWLEDGE_FLAG]
, [RESULT_ACKNOWLEDGE_DATE]
, [RESULT_REJECT_FLAG]
, [RESULT_REJECT_DATE]
, [TIME_ELAPSED_NUMBER]
, [TOTAL_VOLUME_NUMBER]
, [ANALYTE_VOLUME_NUMBER]
, [BSO_NUMBER]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_SURVEY_NOTES_H]'))
DROP TRIGGER [dbo].[TRG_SURVEY_NOTES_H]
GO
Create trigger [dbo].[TRG_SURVEY_NOTES_H] on [dbo].[SURVEY_NOTES]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [dbo].[SURVEY_NOTES_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [NOTE_ID]
, [SURVEYS_ID]
, [NOTE_DATE]
, [ENTRY_DATE]
, [LOCAL_TITLE]
, [EVAL_STANDARD_TITLE]
, [STD_INSTITUTION_ID]
, [OTHER_LOCATION]
, [AUTHOR_FIRST_NAME]
, [AUTHOR_MIDDLE_NAME]
, [AUTHOR_LAST_NAME]
, [STATUS]
, [NOTES_TEXT]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [NOTE_ID]
, [SURVEYS_ID]
, [NOTE_DATE]
, [ENTRY_DATE]
, [LOCAL_TITLE]
, [EVAL_STANDARD_TITLE]
, [STD_INSTITUTION_ID]
, [OTHER_LOCATION]
, [AUTHOR_FIRST_NAME]
, [AUTHOR_MIDDLE_NAME]
, [AUTHOR_LAST_NAME]
, [STATUS]
, [NOTES_TEXT]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[dbo].[TRG_SURVEY_NOTES_DEL_H]'))
DROP TRIGGER [dbo].[TRG_SURVEY_NOTES_DEL_H]
go
CREATE TRIGGER  [dbo].[TRG_SURVEY_NOTES_DEL_H]
on  [dbo].[SURVEY_NOTES] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [dbo].[SURVEY_NOTES_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [NOTE_ID]
, [SURVEYS_ID]
, [NOTE_DATE]
, [ENTRY_DATE]
, [LOCAL_TITLE]
, [EVAL_STANDARD_TITLE]
, [STD_INSTITUTION_ID]
, [OTHER_LOCATION]
, [AUTHOR_FIRST_NAME]
, [AUTHOR_MIDDLE_NAME]
, [AUTHOR_LAST_NAME]
, [STATUS]
, [NOTES_TEXT]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [NOTE_ID]
, [SURVEYS_ID]
, [NOTE_DATE]
, [ENTRY_DATE]
, [LOCAL_TITLE]
, [EVAL_STANDARD_TITLE]
, [STD_INSTITUTION_ID]
, [OTHER_LOCATION]
, [AUTHOR_FIRST_NAME]
, [AUTHOR_MIDDLE_NAME]
, [AUTHOR_LAST_NAME]
, [STATUS]
, [NOTES_TEXT]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_SURVEY_RESULTS_H]'))
DROP TRIGGER [dbo].[TRG_SURVEY_RESULTS_H]
GO
Create trigger [dbo].[TRG_SURVEY_RESULTS_H] on [dbo].[SURVEY_RESULTS]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [dbo].[SURVEY_RESULTS_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [SURVEY_RESULT_ID]
, [SURVEYS_ID]
, [STD_QUESTION_CHOICE_ID]
, [RESULT_TEXT]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [SURVEY_RESULT_ID]
, [SURVEYS_ID]
, [STD_QUESTION_CHOICE_ID]
, [RESULT_TEXT]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[dbo].[TRG_SURVEY_RESULTS_DEL_H]'))
DROP TRIGGER [dbo].[TRG_SURVEY_RESULTS_DEL_H]
go
CREATE TRIGGER  [dbo].[TRG_SURVEY_RESULTS_DEL_H]
on  [dbo].[SURVEY_RESULTS] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [dbo].[SURVEY_RESULTS_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [SURVEY_RESULT_ID]
, [SURVEYS_ID]
, [STD_QUESTION_CHOICE_ID]
, [RESULT_TEXT]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [SURVEY_RESULT_ID]
, [SURVEYS_ID]
, [STD_QUESTION_CHOICE_ID]
, [RESULT_TEXT]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_SURVEYS_H]'))
DROP TRIGGER [dbo].[TRG_SURVEYS_H]
GO
Create trigger [dbo].[TRG_SURVEYS_H] on [dbo].[SURVEYS]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [dbo].[SURVEYS_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [SURVEYS_ID]
, [SURVEY_DATE]
, [SURVEY_STATUS]
, [STD_SURVEY_TYPE_ID]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
, [PROVIDER_ID]
, [PROVIDER_FIRST_NAME]
, [PROVIDER_MIDDLE_NAME]
, [PROVIDER_LAST_NAME]
, [AUTHOR_ID]
, [AUTHOR_FIRST_NAME]
, [AUTHOR_MIDDLE_NAME]
, [AUTHOR_LAST_NAME]
, [patient_ICN]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [SURVEYS_ID]
, [SURVEY_DATE]
, [SURVEY_STATUS]
, [STD_SURVEY_TYPE_ID]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
, [PROVIDER_ID]
, [PROVIDER_FIRST_NAME]
, [PROVIDER_MIDDLE_NAME]
, [PROVIDER_LAST_NAME]
, [AUTHOR_ID]
, [AUTHOR_FIRST_NAME]
, [AUTHOR_MIDDLE_NAME]
, [AUTHOR_LAST_NAME]
, [patient_ICN]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[dbo].[TRG_SURVEYS_DEL_H]'))
DROP TRIGGER [dbo].[TRG_SURVEYS_DEL_H]
go
CREATE TRIGGER  [dbo].[TRG_SURVEYS_DEL_H]
on  [dbo].[SURVEYS] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [dbo].[SURVEYS_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [SURVEYS_ID]
, [SURVEY_DATE]
, [SURVEY_STATUS]
, [STD_SURVEY_TYPE_ID]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
, [PROVIDER_ID]
, [PROVIDER_FIRST_NAME]
, [PROVIDER_MIDDLE_NAME]
, [PROVIDER_LAST_NAME]
, [AUTHOR_ID]
, [AUTHOR_FIRST_NAME]
, [AUTHOR_MIDDLE_NAME]
, [AUTHOR_LAST_NAME]
, [patient_ICN]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [SURVEYS_ID]
, [SURVEY_DATE]
, [SURVEY_STATUS]
, [STD_SURVEY_TYPE_ID]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
, [PROVIDER_ID]
, [PROVIDER_FIRST_NAME]
, [PROVIDER_MIDDLE_NAME]
, [PROVIDER_LAST_NAME]
, [AUTHOR_ID]
, [AUTHOR_FIRST_NAME]
, [AUTHOR_MIDDLE_NAME]
, [AUTHOR_LAST_NAME]
, [patient_ICN]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[EFR].[TRG_SystemParameters_H]'))
DROP TRIGGER [EFR].[TRG_SystemParameters_H]
GO
Create trigger [EFR].[TRG_SystemParameters_H] on [EFR].[SystemParameters]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [EFR].[SystemParameters_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [AcceptMax]
, [DuplicateMax]
, [InvalidMax]
, [CREATED]
, [CREATEDBY]
, [UPDATED]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [AcceptMax]
, [DuplicateMax]
, [InvalidMax]
, [CREATED]
, [CREATEDBY]
, [UPDATED]
, [UPDATEDBY]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[EFR].[TRG_SystemParameters_DEL_H]'))
DROP TRIGGER [EFR].[TRG_SystemParameters_DEL_H]
go
CREATE TRIGGER  [EFR].[TRG_SystemParameters_DEL_H]
on  [EFR].[SystemParameters] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [EFR].[SystemParameters_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [AcceptMax]
, [DuplicateMax]
, [InvalidMax]
, [CREATED]
, [CREATEDBY]
, [UPDATED]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [AcceptMax]
, [DuplicateMax]
, [InvalidMax]
, [CREATED]
, [CREATEDBY]
, [UPDATED]
, [UPDATEDBY]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[TBI].[TRG_TBI_FOLLOWUP_H]'))
DROP TRIGGER [TBI].[TRG_TBI_FOLLOWUP_H]
GO
Create trigger [TBI].[TRG_TBI_FOLLOWUP_H] on [TBI].[TBI_FOLLOWUP]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [TBI].[TBI_FOLLOWUP_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [TBI_FOLLOWUP_ID]
, [STD_TBIIFOLLOWUPLIST_ID]
, [TBI_POLYTRAUMA_ID]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [TBI_FOLLOWUP_ID]
, [STD_TBIIFOLLOWUPLIST_ID]
, [TBI_POLYTRAUMA_ID]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[TBI].[TRG_TBI_FOLLOWUP_DEL_H]'))
DROP TRIGGER [TBI].[TRG_TBI_FOLLOWUP_DEL_H]
go
CREATE TRIGGER  [TBI].[TRG_TBI_FOLLOWUP_DEL_H]
on  [TBI].[TBI_FOLLOWUP] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [TBI].[TBI_FOLLOWUP_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [TBI_FOLLOWUP_ID]
, [STD_TBIIFOLLOWUPLIST_ID]
, [TBI_POLYTRAUMA_ID]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [TBI_FOLLOWUP_ID]
, [STD_TBIIFOLLOWUPLIST_ID]
, [TBI_POLYTRAUMA_ID]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[TBI].[TRG_TBI_INJURY_DETAIL_H]'))
DROP TRIGGER [TBI].[TRG_TBI_INJURY_DETAIL_H]
GO
Create trigger [TBI].[TRG_TBI_INJURY_DETAIL_H] on [TBI].[TBI_INJURY_DETAIL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [TBI].[TBI_INJURY_DETAIL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [TBI_INJURY_DETAIL_ID]
, [STD_TBIINJURYLIST_ID]
, [TBI_POLYTRAUMA_ID]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [TBI_INJURY_DETAIL_ID]
, [STD_TBIINJURYLIST_ID]
, [TBI_POLYTRAUMA_ID]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[TBI].[TRG_TBI_INJURY_DETAIL_DEL_H]'))
DROP TRIGGER [TBI].[TRG_TBI_INJURY_DETAIL_DEL_H]
go
CREATE TRIGGER  [TBI].[TRG_TBI_INJURY_DETAIL_DEL_H]
on  [TBI].[TBI_INJURY_DETAIL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [TBI].[TBI_INJURY_DETAIL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [TBI_INJURY_DETAIL_ID]
, [STD_TBIINJURYLIST_ID]
, [TBI_POLYTRAUMA_ID]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [TBI_INJURY_DETAIL_ID]
, [STD_TBIINJURYLIST_ID]
, [TBI_POLYTRAUMA_ID]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[TBI].[TRG_TBI_POLYTRAUMA_H]'))
DROP TRIGGER [TBI].[TRG_TBI_POLYTRAUMA_H]
GO
Create trigger [TBI].[TRG_TBI_POLYTRAUMA_H] on [TBI].[TBI_POLYTRAUMA]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [TBI].[TBI_POLYTRAUMA_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [TBI_POLYTRAUMA_ID]
, [POLYTRAUMA_CENTER_ID]
, [PATIENT_HOME_VAMC_ID]
, [PATIENT_ID]
, [STD_ETHNICITY_ID]
, [STD_TBIFACILITYSRC_ID]
, [STD_GENDER_ID]
, [STD_MARITALSTATUS_ID]
, [STD_MILITARYDUTYSTS_ID]
, [STD_TBIDSCHRGSTS_ID]
, [STD_RACE_ID]
, [STD_TBIDISCHARGETO_ID]
, [STD_SERVICEBRANCH_ID]
, [STD_TBIPROVIDERLOC_ID]
, [STD_COMBATLOCATION_ID]
, [FIRST_NAME]
, [MIDDLE_NAME]
, [LAST_NAME]
, [ADDRESS_LINE1]
, [ADDRESS_LINE2]
, [ADDRESS_LINE3]
, [CITY]
, [STATE]
, [COUNTY]
, [COUNTRY]
, [POSTAL_CODE]
, [HOME_PHONE]
, [EMAIL_ADDRESS]
, [BLAST_EXPLOSION_INJRY_IND]
, [VEHICLE_INJRY_IND]
, [BULLET_INJRY_IND]
, [OTHER_INJRY_IND]
, [OTHER_INJRY_DSCR]
, [FOLLOWUP_SITE_DSCR]
, [TBI_INJURY_DATE]
, [REHAB_ADMIT_DATE]
, [REHAB_DISCHARGE_DATE]
, [STD_TBI_FRG_ID]
, [ADMISSION_FIM_CODE]
, [DISCHARGE_FIM_CODE]
, [PROVIDER_ID_NUMBER]
, [PROVIDER_NAME]
, [PROVIDER_EMAIL]
, [PROVIDER_PHONE]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [BIRTH_DATE]
, [DEATH_DATE]
, [CASE_MANAGER_NAME]
, [WORK_PHONE]
, [DAYS_OFF_UNIT_TOTAL]
, [SSN]
, [PROVIDER_LOCATION]
, [EMERGE_CONSCIOUSNESS_FLAG]
, [EMERGE_CONSCIOUSNESS_DATE]
, [ALTERED_CONSCIOUSNESS_DATE]
, [STD_TBIEMERGINGETIOLOGY_ID]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [TBI_POLYTRAUMA_ID]
, [POLYTRAUMA_CENTER_ID]
, [PATIENT_HOME_VAMC_ID]
, [PATIENT_ID]
, [STD_ETHNICITY_ID]
, [STD_TBIFACILITYSRC_ID]
, [STD_GENDER_ID]
, [STD_MARITALSTATUS_ID]
, [STD_MILITARYDUTYSTS_ID]
, [STD_TBIDSCHRGSTS_ID]
, [STD_RACE_ID]
, [STD_TBIDISCHARGETO_ID]
, [STD_SERVICEBRANCH_ID]
, [STD_TBIPROVIDERLOC_ID]
, [STD_COMBATLOCATION_ID]
, [FIRST_NAME]
, [MIDDLE_NAME]
, [LAST_NAME]
, [ADDRESS_LINE1]
, [ADDRESS_LINE2]
, [ADDRESS_LINE3]
, [CITY]
, [STATE]
, [COUNTY]
, [COUNTRY]
, [POSTAL_CODE]
, [HOME_PHONE]
, [EMAIL_ADDRESS]
, [BLAST_EXPLOSION_INJRY_IND]
, [VEHICLE_INJRY_IND]
, [BULLET_INJRY_IND]
, [OTHER_INJRY_IND]
, [OTHER_INJRY_DSCR]
, [FOLLOWUP_SITE_DSCR]
, [TBI_INJURY_DATE]
, [REHAB_ADMIT_DATE]
, [REHAB_DISCHARGE_DATE]
, [STD_TBI_FRG_ID]
, [ADMISSION_FIM_CODE]
, [DISCHARGE_FIM_CODE]
, [PROVIDER_ID_NUMBER]
, [PROVIDER_NAME]
, [PROVIDER_EMAIL]
, [PROVIDER_PHONE]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [BIRTH_DATE]
, [DEATH_DATE]
, [CASE_MANAGER_NAME]
, [WORK_PHONE]
, [DAYS_OFF_UNIT_TOTAL]
, [SSN]
, [PROVIDER_LOCATION]
, [EMERGE_CONSCIOUSNESS_FLAG]
, [EMERGE_CONSCIOUSNESS_DATE]
, [ALTERED_CONSCIOUSNESS_DATE]
, [STD_TBIEMERGINGETIOLOGY_ID]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[TBI].[TRG_TBI_POLYTRAUMA_DEL_H]'))
DROP TRIGGER [TBI].[TRG_TBI_POLYTRAUMA_DEL_H]
go
CREATE TRIGGER  [TBI].[TRG_TBI_POLYTRAUMA_DEL_H]
on  [TBI].[TBI_POLYTRAUMA] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [TBI].[TBI_POLYTRAUMA_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [TBI_POLYTRAUMA_ID]
, [POLYTRAUMA_CENTER_ID]
, [PATIENT_HOME_VAMC_ID]
, [PATIENT_ID]
, [STD_ETHNICITY_ID]
, [STD_TBIFACILITYSRC_ID]
, [STD_GENDER_ID]
, [STD_MARITALSTATUS_ID]
, [STD_MILITARYDUTYSTS_ID]
, [STD_TBIDSCHRGSTS_ID]
, [STD_RACE_ID]
, [STD_TBIDISCHARGETO_ID]
, [STD_SERVICEBRANCH_ID]
, [STD_TBIPROVIDERLOC_ID]
, [STD_COMBATLOCATION_ID]
, [FIRST_NAME]
, [MIDDLE_NAME]
, [LAST_NAME]
, [ADDRESS_LINE1]
, [ADDRESS_LINE2]
, [ADDRESS_LINE3]
, [CITY]
, [STATE]
, [COUNTY]
, [COUNTRY]
, [POSTAL_CODE]
, [HOME_PHONE]
, [EMAIL_ADDRESS]
, [BLAST_EXPLOSION_INJRY_IND]
, [VEHICLE_INJRY_IND]
, [BULLET_INJRY_IND]
, [OTHER_INJRY_IND]
, [OTHER_INJRY_DSCR]
, [FOLLOWUP_SITE_DSCR]
, [TBI_INJURY_DATE]
, [REHAB_ADMIT_DATE]
, [REHAB_DISCHARGE_DATE]
, [STD_TBI_FRG_ID]
, [ADMISSION_FIM_CODE]
, [DISCHARGE_FIM_CODE]
, [PROVIDER_ID_NUMBER]
, [PROVIDER_NAME]
, [PROVIDER_EMAIL]
, [PROVIDER_PHONE]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [BIRTH_DATE]
, [DEATH_DATE]
, [CASE_MANAGER_NAME]
, [WORK_PHONE]
, [DAYS_OFF_UNIT_TOTAL]
, [SSN]
, [PROVIDER_LOCATION]
, [EMERGE_CONSCIOUSNESS_FLAG]
, [EMERGE_CONSCIOUSNESS_DATE]
, [ALTERED_CONSCIOUSNESS_DATE]
, [STD_TBIEMERGINGETIOLOGY_ID]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [TBI_POLYTRAUMA_ID]
, [POLYTRAUMA_CENTER_ID]
, [PATIENT_HOME_VAMC_ID]
, [PATIENT_ID]
, [STD_ETHNICITY_ID]
, [STD_TBIFACILITYSRC_ID]
, [STD_GENDER_ID]
, [STD_MARITALSTATUS_ID]
, [STD_MILITARYDUTYSTS_ID]
, [STD_TBIDSCHRGSTS_ID]
, [STD_RACE_ID]
, [STD_TBIDISCHARGETO_ID]
, [STD_SERVICEBRANCH_ID]
, [STD_TBIPROVIDERLOC_ID]
, [STD_COMBATLOCATION_ID]
, [FIRST_NAME]
, [MIDDLE_NAME]
, [LAST_NAME]
, [ADDRESS_LINE1]
, [ADDRESS_LINE2]
, [ADDRESS_LINE3]
, [CITY]
, [STATE]
, [COUNTY]
, [COUNTRY]
, [POSTAL_CODE]
, [HOME_PHONE]
, [EMAIL_ADDRESS]
, [BLAST_EXPLOSION_INJRY_IND]
, [VEHICLE_INJRY_IND]
, [BULLET_INJRY_IND]
, [OTHER_INJRY_IND]
, [OTHER_INJRY_DSCR]
, [FOLLOWUP_SITE_DSCR]
, [TBI_INJURY_DATE]
, [REHAB_ADMIT_DATE]
, [REHAB_DISCHARGE_DATE]
, [STD_TBI_FRG_ID]
, [ADMISSION_FIM_CODE]
, [DISCHARGE_FIM_CODE]
, [PROVIDER_ID_NUMBER]
, [PROVIDER_NAME]
, [PROVIDER_EMAIL]
, [PROVIDER_PHONE]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [BIRTH_DATE]
, [DEATH_DATE]
, [CASE_MANAGER_NAME]
, [WORK_PHONE]
, [DAYS_OFF_UNIT_TOTAL]
, [SSN]
, [PROVIDER_LOCATION]
, [EMERGE_CONSCIOUSNESS_FLAG]
, [EMERGE_CONSCIOUSNESS_DATE]
, [ALTERED_CONSCIOUSNESS_DATE]
, [STD_TBIEMERGINGETIOLOGY_ID]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[TBI].[TRG_TBI_TRACKING_H]'))
DROP TRIGGER [TBI].[TRG_TBI_TRACKING_H]
GO
Create trigger [TBI].[TRG_TBI_TRACKING_H] on [TBI].[TBI_TRACKING]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [TBI].[TBI_TRACKING_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [TBI_TRACKING_ID]
, [WKF_CASE_ID]
, [REFERRAL_SCHEDULE_DATE]
, [CONSULT_NOT_APPLICABLE_FLAG]
, [STD_TBIREFERRALSTS_ID]
, [TBI_DIAGNOSIS_IND]
, [STD_TBITEAMTYPE_ID]
, [PATIENT_ID]
, [STD_INSTITUTION_ID]
, [REFERRAL_COMPLETE_DATE]
, [OTHER_TBI_FACILITY_DSCR]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [TBI_TRACKING_ID]
, [WKF_CASE_ID]
, [REFERRAL_SCHEDULE_DATE]
, [CONSULT_NOT_APPLICABLE_FLAG]
, [STD_TBIREFERRALSTS_ID]
, [TBI_DIAGNOSIS_IND]
, [STD_TBITEAMTYPE_ID]
, [PATIENT_ID]
, [STD_INSTITUTION_ID]
, [REFERRAL_COMPLETE_DATE]
, [OTHER_TBI_FACILITY_DSCR]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[TBI].[TRG_TBI_TRACKING_DEL_H]'))
DROP TRIGGER [TBI].[TRG_TBI_TRACKING_DEL_H]
go
CREATE TRIGGER  [TBI].[TRG_TBI_TRACKING_DEL_H]
on  [TBI].[TBI_TRACKING] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [TBI].[TBI_TRACKING_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [TBI_TRACKING_ID]
, [WKF_CASE_ID]
, [REFERRAL_SCHEDULE_DATE]
, [CONSULT_NOT_APPLICABLE_FLAG]
, [STD_TBIREFERRALSTS_ID]
, [TBI_DIAGNOSIS_IND]
, [STD_TBITEAMTYPE_ID]
, [PATIENT_ID]
, [STD_INSTITUTION_ID]
, [REFERRAL_COMPLETE_DATE]
, [OTHER_TBI_FACILITY_DSCR]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [TBI_TRACKING_ID]
, [WKF_CASE_ID]
, [REFERRAL_SCHEDULE_DATE]
, [CONSULT_NOT_APPLICABLE_FLAG]
, [STD_TBIREFERRALSTS_ID]
, [TBI_DIAGNOSIS_IND]
, [STD_TBITEAMTYPE_ID]
, [PATIENT_ID]
, [STD_INSTITUTION_ID]
, [REFERRAL_COMPLETE_DATE]
, [OTHER_TBI_FACILITY_DSCR]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_USER_LOGIN_DETAIL_H]'))
DROP TRIGGER [dbo].[TRG_USER_LOGIN_DETAIL_H]
GO
Create trigger [dbo].[TRG_USER_LOGIN_DETAIL_H] on [dbo].[USER_LOGIN_DETAIL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [dbo].[USER_LOGIN_DETAIL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [USER_LOGIN_ID]
, [USER_ID]
, [STD_REGISTRY_ID]
, [LAST_LOGIN_SUCCESS_DATE]
, [LAST_LOGIN_FAILURE_DATE]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [ACTIVITY_TYPE_ID]
, [ACTIVITY_DESC]
, [OBJECT_NUMBER]
, [WEB_URL]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [USER_LOGIN_ID]
, [USER_ID]
, [STD_REGISTRY_ID]
, [LAST_LOGIN_SUCCESS_DATE]
, [LAST_LOGIN_FAILURE_DATE]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [ACTIVITY_TYPE_ID]
, [ACTIVITY_DESC]
, [OBJECT_NUMBER]
, [WEB_URL]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[dbo].[TRG_USER_LOGIN_DETAIL_DEL_H]'))
DROP TRIGGER [dbo].[TRG_USER_LOGIN_DETAIL_DEL_H]
go
CREATE TRIGGER  [dbo].[TRG_USER_LOGIN_DETAIL_DEL_H]
on  [dbo].[USER_LOGIN_DETAIL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [dbo].[USER_LOGIN_DETAIL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [USER_LOGIN_ID]
, [USER_ID]
, [STD_REGISTRY_ID]
, [LAST_LOGIN_SUCCESS_DATE]
, [LAST_LOGIN_FAILURE_DATE]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [ACTIVITY_TYPE_ID]
, [ACTIVITY_DESC]
, [OBJECT_NUMBER]
, [WEB_URL]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [USER_LOGIN_ID]
, [USER_ID]
, [STD_REGISTRY_ID]
, [LAST_LOGIN_SUCCESS_DATE]
, [LAST_LOGIN_FAILURE_DATE]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [ACTIVITY_TYPE_ID]
, [ACTIVITY_DESC]
, [OBJECT_NUMBER]
, [WEB_URL]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_USER_REGISTRIES_H]'))
DROP TRIGGER [dbo].[TRG_USER_REGISTRIES_H]
GO
Create trigger [dbo].[TRG_USER_REGISTRIES_H] on [dbo].[USER_REGISTRIES]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [dbo].[USER_REGISTRIES_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [USER_REGISTRY_ID]
, [STD_REGISTRY_ID]
, [USER_ID]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [USER_REGISTRY_ID]
, [STD_REGISTRY_ID]
, [USER_ID]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[dbo].[TRG_USER_REGISTRIES_DEL_H]'))
DROP TRIGGER [dbo].[TRG_USER_REGISTRIES_DEL_H]
go
CREATE TRIGGER  [dbo].[TRG_USER_REGISTRIES_DEL_H]
on  [dbo].[USER_REGISTRIES] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [dbo].[USER_REGISTRIES_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [USER_REGISTRY_ID]
, [STD_REGISTRY_ID]
, [USER_ID]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [USER_REGISTRY_ID]
, [STD_REGISTRY_ID]
, [USER_ID]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_USER_ROLES_H]'))
DROP TRIGGER [dbo].[TRG_USER_ROLES_H]
GO
Create trigger [dbo].[TRG_USER_ROLES_H] on [dbo].[USER_ROLES]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [dbo].[USER_ROLES_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [USER_ROLE_ID]
, [USER_ID]
, [STD_ROLE_ID]
, [STD_INSTITUTION_ID]
, [INACTIVE_FLAG]
, [INACTIVE_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [USER_ROLE_ID]
, [USER_ID]
, [STD_ROLE_ID]
, [STD_INSTITUTION_ID]
, [INACTIVE_FLAG]
, [INACTIVE_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[dbo].[TRG_USER_ROLES_DEL_H]'))
DROP TRIGGER [dbo].[TRG_USER_ROLES_DEL_H]
go
CREATE TRIGGER  [dbo].[TRG_USER_ROLES_DEL_H]
on  [dbo].[USER_ROLES] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [dbo].[USER_ROLES_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [USER_ROLE_ID]
, [USER_ID]
, [STD_ROLE_ID]
, [STD_INSTITUTION_ID]
, [INACTIVE_FLAG]
, [INACTIVE_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [USER_ROLE_ID]
, [USER_ID]
, [STD_ROLE_ID]
, [STD_INSTITUTION_ID]
, [INACTIVE_FLAG]
, [INACTIVE_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_USERS_H]'))
DROP TRIGGER [dbo].[TRG_USERS_H]
GO
Create trigger [dbo].[TRG_USERS_H] on [dbo].[USERS]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [dbo].[USERS_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [USER_ID]
, [USERNAME]
, [FULL_NAME]
, [PASSWORD]
, [PASSWORD_CREATE_DATE]
, [PASSWORD_CHANGE_DATE]
, [PASSWORD_EXPIRE_DATE]
, [ACCOUNT_EXPIRE_DATE]
, [ACCOUNT_LOCK_DATE]
, [INITIAL_LOGIN_DATE]
, [NUMBER_OF_LOGIN_ATTEMPTS]
, [AGREEMENT_SIGNATURE_CODE]
, [SIGNATURE_VERIFIED_IND]
, [FIRST_NAME]
, [MIDDLE_NAME]
, [LAST_NAME]
, [MAIDEN_NAME]
, [EMPLOYEE_NUMBER]
, [JOB_TITLE]
, [EMAIL_ADDRESS]
, [TELEPHONE_NUMBER]
, [FAX_NUMBER]
, [INACTIVE_FLAG]
, [INACTIVE_DATE]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [USER_ID]
, [USERNAME]
, [FULL_NAME]
, [PASSWORD]
, [PASSWORD_CREATE_DATE]
, [PASSWORD_CHANGE_DATE]
, [PASSWORD_EXPIRE_DATE]
, [ACCOUNT_EXPIRE_DATE]
, [ACCOUNT_LOCK_DATE]
, [INITIAL_LOGIN_DATE]
, [NUMBER_OF_LOGIN_ATTEMPTS]
, [AGREEMENT_SIGNATURE_CODE]
, [SIGNATURE_VERIFIED_IND]
, [FIRST_NAME]
, [MIDDLE_NAME]
, [LAST_NAME]
, [MAIDEN_NAME]
, [EMPLOYEE_NUMBER]
, [JOB_TITLE]
, [EMAIL_ADDRESS]
, [TELEPHONE_NUMBER]
, [FAX_NUMBER]
, [INACTIVE_FLAG]
, [INACTIVE_DATE]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[dbo].[TRG_USERS_DEL_H]'))
DROP TRIGGER [dbo].[TRG_USERS_DEL_H]
go
CREATE TRIGGER  [dbo].[TRG_USERS_DEL_H]
on  [dbo].[USERS] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [dbo].[USERS_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [USER_ID]
, [USERNAME]
, [FULL_NAME]
, [PASSWORD]
, [PASSWORD_CREATE_DATE]
, [PASSWORD_CHANGE_DATE]
, [PASSWORD_EXPIRE_DATE]
, [ACCOUNT_EXPIRE_DATE]
, [ACCOUNT_LOCK_DATE]
, [INITIAL_LOGIN_DATE]
, [NUMBER_OF_LOGIN_ATTEMPTS]
, [AGREEMENT_SIGNATURE_CODE]
, [SIGNATURE_VERIFIED_IND]
, [FIRST_NAME]
, [MIDDLE_NAME]
, [LAST_NAME]
, [MAIDEN_NAME]
, [EMPLOYEE_NUMBER]
, [JOB_TITLE]
, [EMAIL_ADDRESS]
, [TELEPHONE_NUMBER]
, [FAX_NUMBER]
, [INACTIVE_FLAG]
, [INACTIVE_DATE]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [USER_ID]
, [USERNAME]
, [FULL_NAME]
, [PASSWORD]
, [PASSWORD_CREATE_DATE]
, [PASSWORD_CHANGE_DATE]
, [PASSWORD_EXPIRE_DATE]
, [ACCOUNT_EXPIRE_DATE]
, [ACCOUNT_LOCK_DATE]
, [INITIAL_LOGIN_DATE]
, [NUMBER_OF_LOGIN_ATTEMPTS]
, [AGREEMENT_SIGNATURE_CODE]
, [SIGNATURE_VERIFIED_IND]
, [FIRST_NAME]
, [MIDDLE_NAME]
, [LAST_NAME]
, [MAIDEN_NAME]
, [EMPLOYEE_NUMBER]
, [JOB_TITLE]
, [EMAIL_ADDRESS]
, [TELEPHONE_NUMBER]
, [FAX_NUMBER]
, [INACTIVE_FLAG]
, [INACTIVE_DATE]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_WKF_CASE_H]'))
DROP TRIGGER [dbo].[TRG_WKF_CASE_H]
GO
Create trigger [dbo].[TRG_WKF_CASE_H] on [dbo].[WKF_CASE]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [dbo].[WKF_CASE_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [WKF_CASE_ID]
, [PATIENT_ID]
, [STD_WKFCASESTS_ID]
, [STD_WKFCASETYPE_ID]
, [REFERRAL_ID]
, [PARENT_CASE_ID]
, [CASE_NUMBER]
, [CASE_START_DATE]
, [CASE_DUE_DATE]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [WKF_CASE_ID]
, [PATIENT_ID]
, [STD_WKFCASESTS_ID]
, [STD_WKFCASETYPE_ID]
, [REFERRAL_ID]
, [PARENT_CASE_ID]
, [CASE_NUMBER]
, [CASE_START_DATE]
, [CASE_DUE_DATE]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[dbo].[TRG_WKF_CASE_DEL_H]'))
DROP TRIGGER [dbo].[TRG_WKF_CASE_DEL_H]
go
CREATE TRIGGER  [dbo].[TRG_WKF_CASE_DEL_H]
on  [dbo].[WKF_CASE] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [dbo].[WKF_CASE_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [WKF_CASE_ID]
, [PATIENT_ID]
, [STD_WKFCASESTS_ID]
, [STD_WKFCASETYPE_ID]
, [REFERRAL_ID]
, [PARENT_CASE_ID]
, [CASE_NUMBER]
, [CASE_START_DATE]
, [CASE_DUE_DATE]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [WKF_CASE_ID]
, [PATIENT_ID]
, [STD_WKFCASESTS_ID]
, [STD_WKFCASETYPE_ID]
, [REFERRAL_ID]
, [PARENT_CASE_ID]
, [CASE_NUMBER]
, [CASE_START_DATE]
, [CASE_DUE_DATE]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_WKF_CASE_ACTIVITY_H]'))
DROP TRIGGER [dbo].[TRG_WKF_CASE_ACTIVITY_H]
GO
Create trigger [dbo].[TRG_WKF_CASE_ACTIVITY_H] on [dbo].[WKF_CASE_ACTIVITY]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [dbo].[WKF_CASE_ACTIVITY_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [WKF_CASE_ACTIVITY_ID]
, [WKF_CASE_ID]
, [STD_WKFACTIVITYSTS_ID]
, [STD_WKFACTIVITYTYPE_ID]
, [REPRESENTATIVE_NAME]
, [CONTACT_NAME]
, [BEST_CALL_BACK_TIME]
, [CONTACT_EMAIL]
, [CONTACT_PHONE]
, [INFO_CONVEYED_TEXT]
, [INFO_RECEIVED_TEXT]
, [TBI_CONTACT_ATTEMPT_COUNT]
, [TBI_EVALUATION_SCHEDULE_DATE]
, [STD_TBIEVALDELAYTYPE_ID]
, [STD_TBISCHEDULESTS_ID]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [ADDRESS_LINE1]
, [ADDRESS_LINE2]
, [ADDRESS_LINE3]
, [CITY]
, [CONTACT_METHOD_CODE]
, [CONTACT_REASON_CODE]
, [COUNTRY]
, [COUNTY]
, [FOLLOWUP_REMINDER_DATE]
, [FOLLOWUP_PLAN_DATE]
, [FOLLOWUP_REQUIRED_FLAG]
, [FOLLOWUP_WKF_CASE_ID]
, [FOLLOWUP_DECLINED_DATE]
, [INPATIENT_EVAL_DATE]
, [INPATIENT_EVAL_REQUIRED_FLAG]
, [PATIENT_TELEMEDICINE_FLAG]
, [POSTAL_CODE]
, [PROVIDER_TELEMEDICINE_FLAG]
, [STATE]
, [ZIP_PLUS_4]
, [KIT_ORDER_DATE]
, [KIT_USE_STOCK_FLAG]
, [ARCHIVED_FLAG]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [WKF_CASE_ACTIVITY_ID]
, [WKF_CASE_ID]
, [STD_WKFACTIVITYSTS_ID]
, [STD_WKFACTIVITYTYPE_ID]
, [REPRESENTATIVE_NAME]
, [CONTACT_NAME]
, [BEST_CALL_BACK_TIME]
, [CONTACT_EMAIL]
, [CONTACT_PHONE]
, [INFO_CONVEYED_TEXT]
, [INFO_RECEIVED_TEXT]
, [TBI_CONTACT_ATTEMPT_COUNT]
, [TBI_EVALUATION_SCHEDULE_DATE]
, [STD_TBIEVALDELAYTYPE_ID]
, [STD_TBISCHEDULESTS_ID]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [ADDRESS_LINE1]
, [ADDRESS_LINE2]
, [ADDRESS_LINE3]
, [CITY]
, [CONTACT_METHOD_CODE]
, [CONTACT_REASON_CODE]
, [COUNTRY]
, [COUNTY]
, [FOLLOWUP_REMINDER_DATE]
, [FOLLOWUP_PLAN_DATE]
, [FOLLOWUP_REQUIRED_FLAG]
, [FOLLOWUP_WKF_CASE_ID]
, [FOLLOWUP_DECLINED_DATE]
, [INPATIENT_EVAL_DATE]
, [INPATIENT_EVAL_REQUIRED_FLAG]
, [PATIENT_TELEMEDICINE_FLAG]
, [POSTAL_CODE]
, [PROVIDER_TELEMEDICINE_FLAG]
, [STATE]
, [ZIP_PLUS_4]
, [KIT_ORDER_DATE]
, [KIT_USE_STOCK_FLAG]
, [ARCHIVED_FLAG]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[dbo].[TRG_WKF_CASE_ACTIVITY_DEL_H]'))
DROP TRIGGER [dbo].[TRG_WKF_CASE_ACTIVITY_DEL_H]
go
CREATE TRIGGER  [dbo].[TRG_WKF_CASE_ACTIVITY_DEL_H]
on  [dbo].[WKF_CASE_ACTIVITY] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [dbo].[WKF_CASE_ACTIVITY_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [WKF_CASE_ACTIVITY_ID]
, [WKF_CASE_ID]
, [STD_WKFACTIVITYSTS_ID]
, [STD_WKFACTIVITYTYPE_ID]
, [REPRESENTATIVE_NAME]
, [CONTACT_NAME]
, [BEST_CALL_BACK_TIME]
, [CONTACT_EMAIL]
, [CONTACT_PHONE]
, [INFO_CONVEYED_TEXT]
, [INFO_RECEIVED_TEXT]
, [TBI_CONTACT_ATTEMPT_COUNT]
, [TBI_EVALUATION_SCHEDULE_DATE]
, [STD_TBIEVALDELAYTYPE_ID]
, [STD_TBISCHEDULESTS_ID]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [ADDRESS_LINE1]
, [ADDRESS_LINE2]
, [ADDRESS_LINE3]
, [CITY]
, [CONTACT_METHOD_CODE]
, [CONTACT_REASON_CODE]
, [COUNTRY]
, [COUNTY]
, [FOLLOWUP_REMINDER_DATE]
, [FOLLOWUP_PLAN_DATE]
, [FOLLOWUP_REQUIRED_FLAG]
, [FOLLOWUP_WKF_CASE_ID]
, [FOLLOWUP_DECLINED_DATE]
, [INPATIENT_EVAL_DATE]
, [INPATIENT_EVAL_REQUIRED_FLAG]
, [PATIENT_TELEMEDICINE_FLAG]
, [POSTAL_CODE]
, [PROVIDER_TELEMEDICINE_FLAG]
, [STATE]
, [ZIP_PLUS_4]
, [KIT_ORDER_DATE]
, [KIT_USE_STOCK_FLAG]
, [ARCHIVED_FLAG]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [WKF_CASE_ACTIVITY_ID]
, [WKF_CASE_ID]
, [STD_WKFACTIVITYSTS_ID]
, [STD_WKFACTIVITYTYPE_ID]
, [REPRESENTATIVE_NAME]
, [CONTACT_NAME]
, [BEST_CALL_BACK_TIME]
, [CONTACT_EMAIL]
, [CONTACT_PHONE]
, [INFO_CONVEYED_TEXT]
, [INFO_RECEIVED_TEXT]
, [TBI_CONTACT_ATTEMPT_COUNT]
, [TBI_EVALUATION_SCHEDULE_DATE]
, [STD_TBIEVALDELAYTYPE_ID]
, [STD_TBISCHEDULESTS_ID]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [ADDRESS_LINE1]
, [ADDRESS_LINE2]
, [ADDRESS_LINE3]
, [CITY]
, [CONTACT_METHOD_CODE]
, [CONTACT_REASON_CODE]
, [COUNTRY]
, [COUNTY]
, [FOLLOWUP_REMINDER_DATE]
, [FOLLOWUP_PLAN_DATE]
, [FOLLOWUP_REQUIRED_FLAG]
, [FOLLOWUP_WKF_CASE_ID]
, [FOLLOWUP_DECLINED_DATE]
, [INPATIENT_EVAL_DATE]
, [INPATIENT_EVAL_REQUIRED_FLAG]
, [PATIENT_TELEMEDICINE_FLAG]
, [POSTAL_CODE]
, [PROVIDER_TELEMEDICINE_FLAG]
, [STATE]
, [ZIP_PLUS_4]
, [KIT_ORDER_DATE]
, [KIT_USE_STOCK_FLAG]
, [ARCHIVED_FLAG]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_WKF_CASE_ASSIGNMENT_H]'))
DROP TRIGGER [dbo].[TRG_WKF_CASE_ASSIGNMENT_H]
GO
Create trigger [dbo].[TRG_WKF_CASE_ASSIGNMENT_H] on [dbo].[WKF_CASE_ASSIGNMENT]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [dbo].[WKF_CASE_ASSIGNMENT_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [WKF_CASE_ASSIGNMENT_ID]
, [WKF_CASE_ID]
, [CASE_ASSIGNMENT_DATE]
, [CASE_ASSIGNED_BY]
, [CASE_ASSIGNED_TO]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [WKF_CASE_ASSIGNMENT_ID]
, [WKF_CASE_ID]
, [CASE_ASSIGNMENT_DATE]
, [CASE_ASSIGNED_BY]
, [CASE_ASSIGNED_TO]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[dbo].[TRG_WKF_CASE_ASSIGNMENT_DEL_H]'))
DROP TRIGGER [dbo].[TRG_WKF_CASE_ASSIGNMENT_DEL_H]
go
CREATE TRIGGER  [dbo].[TRG_WKF_CASE_ASSIGNMENT_DEL_H]
on  [dbo].[WKF_CASE_ASSIGNMENT] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [dbo].[WKF_CASE_ASSIGNMENT_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [WKF_CASE_ASSIGNMENT_ID]
, [WKF_CASE_ID]
, [CASE_ASSIGNMENT_DATE]
, [CASE_ASSIGNED_BY]
, [CASE_ASSIGNED_TO]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [WKF_CASE_ASSIGNMENT_ID]
, [WKF_CASE_ID]
, [CASE_ASSIGNMENT_DATE]
, [CASE_ASSIGNED_BY]
, [CASE_ASSIGNED_TO]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]

From Deleted
End
go
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_WKF_CASE_COMMENTS_H]'))
DROP TRIGGER [dbo].[TRG_WKF_CASE_COMMENTS_H]
GO
Create trigger [dbo].[TRG_WKF_CASE_COMMENTS_H] on [dbo].[WKF_CASE_COMMENTS]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [dbo].[WKF_CASE_COMMENTS_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [WKF_CASE_COMMENT_ID]
, [WKF_CASE_ID]
, [COMMENT_TEXT]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [WKF_CASE_COMMENT_ID]
, [WKF_CASE_ID]
, [COMMENT_TEXT]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[dbo].[TRG_WKF_CASE_COMMENTS_DEL_H]'))
DROP TRIGGER [dbo].[TRG_WKF_CASE_COMMENTS_DEL_H]
go
CREATE TRIGGER  [dbo].[TRG_WKF_CASE_COMMENTS_DEL_H]
on  [dbo].[WKF_CASE_COMMENTS] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [dbo].[WKF_CASE_COMMENTS_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [WKF_CASE_COMMENT_ID]
, [WKF_CASE_ID]
, [COMMENT_TEXT]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [WKF_CASE_COMMENT_ID]
, [WKF_CASE_ID]
, [COMMENT_TEXT]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]

From Deleted
End
go

IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[EFR].[TRG_ELECTRONIC_HEALTH_RECORD_H]'))
DROP TRIGGER [EFR].[TRG_ELECTRONIC_HEALTH_RECORD_H]
GO
Create trigger [EFR].[TRG_ELECTRONIC_HEALTH_RECORD_H] on [EFR].[ELECTRONIC_HEALTH_RECORD]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [EFR].[ELECTRONIC_HEALTH_RECORD_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [EHR_ID]
, [PATIENT_ID]
, [VISIT_DATE]
, [STATIONNUMBER]
, [INSTITUTION_NAME]
, [SPECIMENT_ID]
, [SPECIMENT_NAME]
, [COLLECTION_DATE]
, [ACCESSION_NUM]
, [FACILITY]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [EHR_ID]
, [PATIENT_ID]
, [VISIT_DATE]
, [STATIONNUMBER]
, [INSTITUTION_NAME]
, [SPECIMENT_ID]
, [SPECIMENT_NAME]
, [COLLECTION_DATE]
, [ACCESSION_NUM]
, [FACILITY]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[EFR].[TRG_ELECTRONIC_HEALTH_RECORD_DEL_H]'))
DROP TRIGGER [EFR].[TRG_ELECTRONIC_HEALTH_RECORD_DEL_H]
go
CREATE TRIGGER  [EFR].[TRG_ELECTRONIC_HEALTH_RECORD_DEL_H]
on  [EFR].[ELECTRONIC_HEALTH_RECORD] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [EFR].[ELECTRONIC_HEALTH_RECORD_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [EHR_ID]
, [PATIENT_ID]
, [VISIT_DATE]
, [STATIONNUMBER]
, [INSTITUTION_NAME]
, [SPECIMENT_ID]
, [SPECIMENT_NAME]
, [COLLECTION_DATE]
, [ACCESSION_NUM]
, [FACILITY]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [EHR_ID]
, [PATIENT_ID]
, [VISIT_DATE]
, [STATIONNUMBER]
, [INSTITUTION_NAME]
, [SPECIMENT_ID]
, [SPECIMENT_NAME]
, [COLLECTION_DATE]
, [ACCESSION_NUM]
, [FACILITY]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

From Deleted
End
go

IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_HISTORY_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_HISTORY_H]
GO
Create trigger [DVEIR].[TRG_ER_HISTORY_H] on [DVEIR].[ER_HISTORY]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_HISTORY_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_HISTORY_ID]
, [PATIENT_ID]
, [REFRACTIVE_ERROR_NUMBER]
, [PAST_EYE_INJRY_IND]
, [PAST_EYE_TRMT_RCVD_IND]
, [PAST_EYE_TEST_IND]
, [PAST_NON_EYE_INJRY_IND]
, [PAST_MHSA_DISORDER_IND]
, [MHSA_TRMT_IND]
, [PTSD_IND]
, [SUICIDE_ATTEMPT_IND]
, [DEPRESSION_IND]
, [DEPRESSION_TRMT_IND]
, [ADD_IND]
, [ADD_TRMT_IND]
, [PRIOR_DRUG_ABUSE_IND]
, [CURRENT_DRUG_ABUSE_IND]
, [DRUG_TRMT_IND]
, [PRIOR_ALCOHOL_ABUSE_IND]
, [CURRENT_ALCOHOL_ABUSE_IND]
, [ALCOHOL_TRMT_IND]
, [TOBACCO_USE_IND]
, [TOBACCO_TRMT_IND]
, [OTHER_SOCIAL_ISSUES_IND]
, [OTHER_TRMT_IND]
, [MSHA_COMMENT_TEXT]
, [ALLERGY_IND]
, [ALLERGY_TRMT_IND]
, [PREGNANCY_IND]
, [PREGNANCY_TRMT_IND]
, [DIABETES_IND]
, [DIABETES_TRMT_IND]
, [INSULIN_DEPENDENT_IND]
, [INSULIN_TRMT_IND]
, [ORAL_INSULIN_IND]
, [ORAL_INSULIN_TRMT_IND]
, [METASTASIS_IND]
, [METASTASIS_TRMT_IND]
, [HIV_AIDS_IND]
, [HIV_AIDS_TRMT_IND]
, [STEROID_THERAPY_IND]
, [STEROID_TRMT_IND]
, [DOCUMENTED_MEDICAL_IND]
, [BRAIN_SYNDRM_IND]
, [BRAIN_SYNDRM_TRMT_IND]
, [NERVE_PALSY_IND]
, [PALSY_TRMT_IND]
, [TBI_IND]
, [TBI_TRMT_IND]
, [TBI_READ_PRBLM_IND]
, [TBI_READ_PRBLM_TRMT_IND]
, [TBI_DIPLOPIA_IND]
, [TBI_DIPLOPIA_TRMT_IND]
, [TBI_DAZZLING_IND]
, [TBI_DAZZLING_TRMT_IND]
, [TBI_PHOTOPHOBIA_IND]
, [TBI_PHOTOPHOBIA_TRMT_IND]
, [TBI_VERGENCE_IND]
, [TBI_VERGENCE_TRMT_IND]
, [TBI_ACM_DYSFN_IND]
, [TBI_ACM_DYSFN_TRMT_IND]
, [NEUROLOGICAL_COMMENT_TEXT]
, [DOCUMENTED_NEUROLOGICAL_IND]
, [BLAST_EXPOSURE_IND]
, [BLAST_TBI_IND]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ER_HISTORY_ID]
, [PATIENT_ID]
, [REFRACTIVE_ERROR_NUMBER]
, [PAST_EYE_INJRY_IND]
, [PAST_EYE_TRMT_RCVD_IND]
, [PAST_EYE_TEST_IND]
, [PAST_NON_EYE_INJRY_IND]
, [PAST_MHSA_DISORDER_IND]
, [MHSA_TRMT_IND]
, [PTSD_IND]
, [SUICIDE_ATTEMPT_IND]
, [DEPRESSION_IND]
, [DEPRESSION_TRMT_IND]
, [ADD_IND]
, [ADD_TRMT_IND]
, [PRIOR_DRUG_ABUSE_IND]
, [CURRENT_DRUG_ABUSE_IND]
, [DRUG_TRMT_IND]
, [PRIOR_ALCOHOL_ABUSE_IND]
, [CURRENT_ALCOHOL_ABUSE_IND]
, [ALCOHOL_TRMT_IND]
, [TOBACCO_USE_IND]
, [TOBACCO_TRMT_IND]
, [OTHER_SOCIAL_ISSUES_IND]
, [OTHER_TRMT_IND]
, [MSHA_COMMENT_TEXT]
, [ALLERGY_IND]
, [ALLERGY_TRMT_IND]
, [PREGNANCY_IND]
, [PREGNANCY_TRMT_IND]
, [DIABETES_IND]
, [DIABETES_TRMT_IND]
, [INSULIN_DEPENDENT_IND]
, [INSULIN_TRMT_IND]
, [ORAL_INSULIN_IND]
, [ORAL_INSULIN_TRMT_IND]
, [METASTASIS_IND]
, [METASTASIS_TRMT_IND]
, [HIV_AIDS_IND]
, [HIV_AIDS_TRMT_IND]
, [STEROID_THERAPY_IND]
, [STEROID_TRMT_IND]
, [DOCUMENTED_MEDICAL_IND]
, [BRAIN_SYNDRM_IND]
, [BRAIN_SYNDRM_TRMT_IND]
, [NERVE_PALSY_IND]
, [PALSY_TRMT_IND]
, [TBI_IND]
, [TBI_TRMT_IND]
, [TBI_READ_PRBLM_IND]
, [TBI_READ_PRBLM_TRMT_IND]
, [TBI_DIPLOPIA_IND]
, [TBI_DIPLOPIA_TRMT_IND]
, [TBI_DAZZLING_IND]
, [TBI_DAZZLING_TRMT_IND]
, [TBI_PHOTOPHOBIA_IND]
, [TBI_PHOTOPHOBIA_TRMT_IND]
, [TBI_VERGENCE_IND]
, [TBI_VERGENCE_TRMT_IND]
, [TBI_ACM_DYSFN_IND]
, [TBI_ACM_DYSFN_TRMT_IND]
, [NEUROLOGICAL_COMMENT_TEXT]
, [DOCUMENTED_NEUROLOGICAL_IND]
, [BLAST_EXPOSURE_IND]
, [BLAST_TBI_IND]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[DVEIR].[TRG_ER_HISTORY_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_HISTORY_DEL_H]
go
CREATE TRIGGER  [DVEIR].[TRG_ER_HISTORY_DEL_H]
on  [DVEIR].[ER_HISTORY] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_HISTORY_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_HISTORY_ID]
, [PATIENT_ID]
, [REFRACTIVE_ERROR_NUMBER]
, [PAST_EYE_INJRY_IND]
, [PAST_EYE_TRMT_RCVD_IND]
, [PAST_EYE_TEST_IND]
, [PAST_NON_EYE_INJRY_IND]
, [PAST_MHSA_DISORDER_IND]
, [MHSA_TRMT_IND]
, [PTSD_IND]
, [SUICIDE_ATTEMPT_IND]
, [DEPRESSION_IND]
, [DEPRESSION_TRMT_IND]
, [ADD_IND]
, [ADD_TRMT_IND]
, [PRIOR_DRUG_ABUSE_IND]
, [CURRENT_DRUG_ABUSE_IND]
, [DRUG_TRMT_IND]
, [PRIOR_ALCOHOL_ABUSE_IND]
, [CURRENT_ALCOHOL_ABUSE_IND]
, [ALCOHOL_TRMT_IND]
, [TOBACCO_USE_IND]
, [TOBACCO_TRMT_IND]
, [OTHER_SOCIAL_ISSUES_IND]
, [OTHER_TRMT_IND]
, [MSHA_COMMENT_TEXT]
, [ALLERGY_IND]
, [ALLERGY_TRMT_IND]
, [PREGNANCY_IND]
, [PREGNANCY_TRMT_IND]
, [DIABETES_IND]
, [DIABETES_TRMT_IND]
, [INSULIN_DEPENDENT_IND]
, [INSULIN_TRMT_IND]
, [ORAL_INSULIN_IND]
, [ORAL_INSULIN_TRMT_IND]
, [METASTASIS_IND]
, [METASTASIS_TRMT_IND]
, [HIV_AIDS_IND]
, [HIV_AIDS_TRMT_IND]
, [STEROID_THERAPY_IND]
, [STEROID_TRMT_IND]
, [DOCUMENTED_MEDICAL_IND]
, [BRAIN_SYNDRM_IND]
, [BRAIN_SYNDRM_TRMT_IND]
, [NERVE_PALSY_IND]
, [PALSY_TRMT_IND]
, [TBI_IND]
, [TBI_TRMT_IND]
, [TBI_READ_PRBLM_IND]
, [TBI_READ_PRBLM_TRMT_IND]
, [TBI_DIPLOPIA_IND]
, [TBI_DIPLOPIA_TRMT_IND]
, [TBI_DAZZLING_IND]
, [TBI_DAZZLING_TRMT_IND]
, [TBI_PHOTOPHOBIA_IND]
, [TBI_PHOTOPHOBIA_TRMT_IND]
, [TBI_VERGENCE_IND]
, [TBI_VERGENCE_TRMT_IND]
, [TBI_ACM_DYSFN_IND]
, [TBI_ACM_DYSFN_TRMT_IND]
, [NEUROLOGICAL_COMMENT_TEXT]
, [DOCUMENTED_NEUROLOGICAL_IND]
, [BLAST_EXPOSURE_IND]
, [BLAST_TBI_IND]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ER_HISTORY_ID]
, [PATIENT_ID]
, [REFRACTIVE_ERROR_NUMBER]
, [PAST_EYE_INJRY_IND]
, [PAST_EYE_TRMT_RCVD_IND]
, [PAST_EYE_TEST_IND]
, [PAST_NON_EYE_INJRY_IND]
, [PAST_MHSA_DISORDER_IND]
, [MHSA_TRMT_IND]
, [PTSD_IND]
, [SUICIDE_ATTEMPT_IND]
, [DEPRESSION_IND]
, [DEPRESSION_TRMT_IND]
, [ADD_IND]
, [ADD_TRMT_IND]
, [PRIOR_DRUG_ABUSE_IND]
, [CURRENT_DRUG_ABUSE_IND]
, [DRUG_TRMT_IND]
, [PRIOR_ALCOHOL_ABUSE_IND]
, [CURRENT_ALCOHOL_ABUSE_IND]
, [ALCOHOL_TRMT_IND]
, [TOBACCO_USE_IND]
, [TOBACCO_TRMT_IND]
, [OTHER_SOCIAL_ISSUES_IND]
, [OTHER_TRMT_IND]
, [MSHA_COMMENT_TEXT]
, [ALLERGY_IND]
, [ALLERGY_TRMT_IND]
, [PREGNANCY_IND]
, [PREGNANCY_TRMT_IND]
, [DIABETES_IND]
, [DIABETES_TRMT_IND]
, [INSULIN_DEPENDENT_IND]
, [INSULIN_TRMT_IND]
, [ORAL_INSULIN_IND]
, [ORAL_INSULIN_TRMT_IND]
, [METASTASIS_IND]
, [METASTASIS_TRMT_IND]
, [HIV_AIDS_IND]
, [HIV_AIDS_TRMT_IND]
, [STEROID_THERAPY_IND]
, [STEROID_TRMT_IND]
, [DOCUMENTED_MEDICAL_IND]
, [BRAIN_SYNDRM_IND]
, [BRAIN_SYNDRM_TRMT_IND]
, [NERVE_PALSY_IND]
, [PALSY_TRMT_IND]
, [TBI_IND]
, [TBI_TRMT_IND]
, [TBI_READ_PRBLM_IND]
, [TBI_READ_PRBLM_TRMT_IND]
, [TBI_DIPLOPIA_IND]
, [TBI_DIPLOPIA_TRMT_IND]
, [TBI_DAZZLING_IND]
, [TBI_DAZZLING_TRMT_IND]
, [TBI_PHOTOPHOBIA_IND]
, [TBI_PHOTOPHOBIA_TRMT_IND]
, [TBI_VERGENCE_IND]
, [TBI_VERGENCE_TRMT_IND]
, [TBI_ACM_DYSFN_IND]
, [TBI_ACM_DYSFN_TRMT_IND]
, [NEUROLOGICAL_COMMENT_TEXT]
, [DOCUMENTED_NEUROLOGICAL_IND]
, [BLAST_EXPOSURE_IND]
, [BLAST_TBI_IND]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]

From Deleted
End
go

begin
INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('05'
           ,'00'
           ,'005'
           ,0
           ,'CreateTriggerScript'
           ,'Create triggers on V5_Registry database.'
           ,'ALL'
           ,GETDATE())
end 
GO
