 
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[DVEIR].[TRG_ACUITY_RANK_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ACUITY_RANK_DEL_H]
go
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[V4_Registry].[DVEIR].[ACUITY_RANK_H]') AND type in (N'U'))
begin
DROP TABLE [V4_Registry].[DVEIR].[ACUITY_RANK_H]
end;
 
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[dbo].[TRG_DatabaseChangeLog_DEL_H]'))
DROP TRIGGER [dbo].[TRG_DatabaseChangeLog_DEL_H]
go
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[V4_Registry].[dbo].[DatabaseChangeLog_H]') AND type in (N'U'))
begin
DROP TABLE [V4_Registry].[dbo].[DatabaseChangeLog_H]
end;
 
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[dbo].[TRG_ETL_ErrorLogs_DEL_H]'))
DROP TRIGGER [dbo].[TRG_ETL_ErrorLogs_DEL_H]
go
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[V4_Registry].[dbo].[ETL_ErrorLogs_H]') AND type in (N'U'))
begin
DROP TABLE [V4_Registry].[dbo].[ETL_ErrorLogs_H]
end;
 
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[dbo].[TRG_ETL_PackageLogs_DEL_H]'))
DROP TRIGGER [dbo].[TRG_ETL_PackageLogs_DEL_H]
go
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[V4_Registry].[dbo].[ETL_PackageLogs_H]') AND type in (N'U'))
begin
DROP TABLE [V4_Registry].[dbo].[ETL_PackageLogs_H]
end;
 
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[RegEye].[TRG_ICD9Conversion_DEL_H]'))
DROP TRIGGER [RegEye].[TRG_ICD9Conversion_DEL_H]
go
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[V4_Registry].[RegEye].[ICD9Conversion_H]') AND type in (N'U'))
begin
DROP TABLE [V4_Registry].[RegEye].[ICD9Conversion_H]
end;
 
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[dbo].[TRG_PatientICNMaster_DEL_H]'))
DROP TRIGGER [dbo].[TRG_PatientICNMaster_DEL_H]
go
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[V4_Registry].[dbo].[PatientICNMaster_H]') AND type in (N'U'))
begin
DROP TABLE [V4_Registry].[dbo].[PatientICNMaster_H]
end;

if exists(Select * from sys.columns where name='bDelete' and object_id=object_id('SURVEYS'))
BEGIN
Alter table SURVEYS
DROP CONSTRAINT SURVEYS_bDel_def
Alter table SURVEYS
DROP column bDelete
END
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SURVEYS_H]') AND type in (N'U'))
begin
DROP TABLE [dbo].[SURVEYS_H]
end;
Create Table [dbo].[SURVEYS_H](
[Audit_SURVEYS_H_ID] [int] IDENTITY(1,1) NOT NULL
, [Audit_Date] [datetime] NOT NULL
, [Audit_Type] [varchar](20) NOT NULL
, [Audit_ApplicationUser] [varchar](128)
, [Audit_SQLUser] [varchar](100)
, [SURVEYS_ID] [int]
, [SURVEY_DATE] [datetime]
, [SURVEY_STATUS] [varchar](10)
, [STD_SURVEY_TYPE_ID] [int]
, [CREATEDBY] [varchar](30)
, [UPDATEDBY] [varchar](30)
, [CREATED] [datetime]
, [UPDATED] [datetime]
, [PROVIDER_ID] [varchar](20)
, [PROVIDER_FIRST_NAME] [varchar](50)
, [PROVIDER_MIDDLE_NAME] [varchar](50)
, [PROVIDER_LAST_NAME] [varchar](50)
, [AUTHOR_ID] [varchar](20)
, [AUTHOR_FIRST_NAME] [varchar](50)
, [AUTHOR_MIDDLE_NAME] [varchar](50)
, [AUTHOR_LAST_NAME] [varchar](50)
, [patient_ICN] [varchar](50)
, CONSTRAINT [SURVEYS_H_PK] PRIMARY KEY CLUSTERED 
(
[Audit_SURVEYS_H_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_SURVEYS_H]'))
DROP TRIGGER [dbo].[TRG_SURVEYS_H]
GO
Create trigger [dbo].[TRG_SURVEYS_H] on [dbo].[SURVEYS]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [dbo].[SURVEYS_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [SURVEYS_ID]
, [SURVEY_DATE]
, [SURVEY_STATUS]
, [STD_SURVEY_TYPE_ID]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
, [PROVIDER_ID]
, [PROVIDER_FIRST_NAME]
, [PROVIDER_MIDDLE_NAME]
, [PROVIDER_LAST_NAME]
, [AUTHOR_ID]
, [AUTHOR_FIRST_NAME]
, [AUTHOR_MIDDLE_NAME]
, [AUTHOR_LAST_NAME]
, [patient_ICN]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [SURVEYS_ID]
, [SURVEY_DATE]
, [SURVEY_STATUS]
, [STD_SURVEY_TYPE_ID]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
, [PROVIDER_ID]
, [PROVIDER_FIRST_NAME]
, [PROVIDER_MIDDLE_NAME]
, [PROVIDER_LAST_NAME]
, [AUTHOR_ID]
, [AUTHOR_FIRST_NAME]
, [AUTHOR_MIDDLE_NAME]
, [AUTHOR_LAST_NAME]
, [patient_ICN]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[dbo].[TRG_SURVEYS_DEL_H]'))
DROP TRIGGER [dbo].[TRG_SURVEYS_DEL_H]
go
CREATE TRIGGER  [dbo].[TRG_SURVEYS_DEL_H]
on  [dbo].[SURVEYS] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [dbo].[SURVEYS_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [SURVEYS_ID]
, [SURVEY_DATE]
, [SURVEY_STATUS]
, [STD_SURVEY_TYPE_ID]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
, [PROVIDER_ID]
, [PROVIDER_FIRST_NAME]
, [PROVIDER_MIDDLE_NAME]
, [PROVIDER_LAST_NAME]
, [AUTHOR_ID]
, [AUTHOR_FIRST_NAME]
, [AUTHOR_MIDDLE_NAME]
, [AUTHOR_LAST_NAME]
, [patient_ICN]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [SURVEYS_ID]
, [SURVEY_DATE]
, [SURVEY_STATUS]
, [STD_SURVEY_TYPE_ID]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
, [PROVIDER_ID]
, [PROVIDER_FIRST_NAME]
, [PROVIDER_MIDDLE_NAME]
, [PROVIDER_LAST_NAME]
, [AUTHOR_ID]
, [AUTHOR_FIRST_NAME]
, [AUTHOR_MIDDLE_NAME]
, [AUTHOR_LAST_NAME]
, [patient_ICN]

From Deleted
End
go

begin
INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('05'
           ,'00'
           ,'002'
           ,0
           ,''
           ,'Drop some triggers and tables from V4_Registry and create table SURVEYS_H and create triggers on table SURVEYS in V5_registry.'
           ,'ALL'
           ,GETDATE())
end 
GO
