/*
Description goes here
*/

SET ANSI_PADDING OFF
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[EFR].[DOD_Fragment_DETAIL]') AND type in (N'U'))
DROP TABLE [EFR].[DOD_Fragment_DETAIL]
GO


SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [EFR].[DOD_Fragment_DETAIL](
	[DOD_Fragment_DETAIL_ID] [int] IDENTITY(1,1) NOT NULL
	,[DOD_Fragment_ID] [int]  NOT NULL
	,SSN varchar(20)               
	,LabIDNumber varchar(50)               
	,FragmentIDNumber varchar(50)
	,AnalyticalMethodCode varchar(200)
	,AnalyticalmethodName varchar(200)
	,AnalyticalMethodDescription varchar(4000)
	,AnalyteName varchar(200)
	,AnalyteResults varchar(200)
	,AnalyteComments varchar(4000)
	,CASNumber varchar(200)

 CONSTRAINT [DOD_Fragment)Detail_PK] PRIMARY KEY CLUSTERED 
(
	[DOD_Fragment_DETAIL_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[EFR].[DOD_Fragment]') AND type in (N'U'))
DROP TABLE [EFR].[DOD_Fragment]
GO


SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [EFR].[DOD_Fragment](
	[DOD_Fragment_ID] [int] IDENTITY(1,1) NOT NULL
	,SSN varchar(20) 
	,LabIDNumber varchar(50) 
	,FragmentIDNumber varchar(50) 
	,DateFragmentRecievedDate varchar(50) 
	,FragmentDescription varchar (4000)
	,FragmentMass varchar(200)
	,UOMMass varchar(200)
	,FragmentLength varchar(200)
	,UOMLength varchar(200)
	,FragmentHeight varchar(200)
	,UOMHeight varchar(200)
	,FragmentWidth varchar(200)
	,UOMWidth varchar(200)
	,RadioactiveIndicator varchar(200)
	,RadioactiveResults varchar(2000)
,CONSTRAINT [DOD_Fragment_PK] PRIMARY KEY CLUSTERED  
(
	[DOD_Fragment_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

ALTER TABLE [EFR].[DOD_Fragment_DETAIL]  WITH NOCHECK ADD  CONSTRAINT [Fragment_DETAIL_FK] FOREIGN KEY([DOD_Fragment_ID] )
REFERENCES [EFR].[DOD_Fragment] ([DOD_Fragment_ID])
GO

begin
INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('05'
           ,'00'
           ,'001'
           ,0
           ,'Adds DoD Fragment tables'
           ,''
           ,'EFR'
           ,GETDATE())
end 
GO