Option Explicit

'SCHEDULING: This script should be run once a day

'Script parameters
Const constFeedName = "RMCDS Export File Splitter"
Const constMaxRecords = 2000

'Environment-specific feed processing parameters are defined immediately after processing INCLUDES

Dim objFSO
Dim objFile
Dim objPastFile
Dim colFiles
Dim arrIncludes
Dim iCount
Dim sText
Dim sLog
Dim sErrMsg
Dim arrFolders
Dim sRet
Dim bContinue
Dim strLatestExtract
Dim dtLatestCreateDate

ReDim arrIncludes(3)
arrIncludes(0) = "GlobalParms.vbs" 'This file must be included first
arrIncludes(1) = "Logger.vbs"
arrIncludes(2) = "GeneralFunctions.vbs"
arrIncludes(3) = "CompressedFolder.class"

For iCount = 0 To UBound(arrIncludes)
	sText = fnIncludeScript(arrIncludes(iCount))
	If Not sText = "" Then
		wscript.Echo "Unable to include script " & arrIncludes(iCount) & " (Err " & Split(sText, "|")(0) & "): " & Split(sText, "|")(1)
		wscript.Quit
	End If
Next

Select Case constEnvironment
	Case "DEVL"
		ExecuteGlobal Replace("Const constFileSourceLocation=#.\Source_Files\#", "#", Chr(34))	'IMPORTANT: Include trailing backslash
		ExecuteGlobal Replace("Const constFileTargetLocation=#.\FTP_Source\#", "#", Chr(34))	'IMPORTANT: Include trailing backslash
		ExecuteGlobal Replace("Const constFileCompletedLocation=#.\Completed\#", "#", Chr(34))	'IMPORTANT: Include trailing backslash
		ExecuteGlobal Replace("Const constProcessingFolder=#.\Processing\#", "#", Chr(34))		'IMPORTANT: Include trailing backslash
	Case "TEST"
		ExecuteGlobal Replace("Const constFileSourceLocation=#.\Source_Files\#", "#", Chr(34))	'IMPORTANT: Include trailing backslash
		ExecuteGlobal Replace("Const constFileTargetLocation=#.\FTP_Source\#", "#", Chr(34))	'IMPORTANT: Include trailing backslash
		ExecuteGlobal Replace("Const constFileCompletedLocation=#.\Completed\#", "#", Chr(34))	'IMPORTANT: Include trailing backslash
		ExecuteGlobal Replace("Const constProcessingFolder=#.\Processing\#", "#", Chr(34))		'IMPORTANT: Include trailing backslash
	Case "PROD"
		ExecuteGlobal Replace("Const constFileSourceLocation=#.\Source_Files\#", "#", Chr(34))	'IMPORTANT: Include trailing backslash
		ExecuteGlobal Replace("Const constFileTargetLocation=#.\FTP_Source\#", "#", Chr(34))	'IMPORTANT: Include trailing backslash
		ExecuteGlobal Replace("Const constFileCompletedLocation=#.\Completed\#", "#", Chr(34))	'IMPORTANT: Include trailing backslash
		ExecuteGlobal Replace("Const constProcessingFolder=#.\Processing\#", "#", Chr(34))		'IMPORTANT: Include trailing backslash
	Case Else
		MsgBox "Unrecognized environment <" & constEnvironment & ">!"
		wscript.Quit
End Select

On Error Resume Next

'Initialize
strLatestExtract = ""
dtLatestCreateDate = ""

bContinue = True

'Construct error log file name
sLog = constLogFolder & fnConstructLogName(constFeedName, Date)

'Establish required global objects
Set objFSO = CreateObject("Scripting.FileSystemObject")

'Establish required folders
ReDim arrFolders(1)
arrFolders(0) = constFileCompletedLocation
arrFolders(1) = constProcessingFolder
For iCount = 0 To UBound(arrFolders)
	sRet = fnEstablishPath(arrFolders(iCount))
	If Not sRet = "" Then
		sErrMsg = Split(sRet, "|")(1)
		fnLogEntry sLog, sErrMsg, constError & " " & Split(sRet, "|")(0)
		bContinue = False
		Exit For
	End If
Next

If bContinue Then
	'Delete all files in the target folder and processing folder
	Err.Clear
	objFSO.DeleteFile constFileTargetLocation & "*.*", True	'Delete read-only files too
	If Not Err.Number = 0 Then
		sErrMsg = "Unable to delete old files in " & constFileTargetLocation & " folder (" & Err.Description & ")"
		fnLogEntry sLog, sErrMsg, constError & " " & Err.Number
	End If
	Err.Clear
	objFSO.DeleteFile constProcessingFolder & "*.*", True	'Delete read-only files too
	If Not Err.Number = 0 Then
		sErrMsg = "Unable to delete old files in " & constProcessingFolder & " folder (" & Err.Description & ")"
		fnLogEntry sLog, sErrMsg, constError & " " & Err.Number
	End If

	'Process each file in the monitored folder
	Err.Clear
	Set colFiles = objFSO.GetFolder(constFileSourceLocation).Files
	If Err.Number = 0 Then
		'Find the latest export file in the source folder
		For Each objFile In colFiles
			If (strLatestExtract = "") Then
				strLatestExtract = objFile.Path
				dtLatestCreateDate = objFile.DateCreated
			Else
				If DateDiff("S", dtLatestCreateDate, objFile.DateCreated) > 0 Then
					'Move file to the archive
					Set objPastFile = objFSO.GetFile(strLatestExtract)
					Err.Clear
					objPastFile.Move(constFileCompletedLocation & "Old_" & objPastFile.Name)
					If Not Err.Number = 0 Then
						sErrMsg = "Unable to move old RMCDS extract " & objPastFile.Path & " to its archival location "
						sErrMsg = sErrMsg & constFileCompletedLocation & " (" & Err.Description & ")"
						fnLogEntry sLog, sErrMsg, constError & " " & Err.Number
					End If
					
					'Save latest extract info
					strLatestExtract = objFile.Path
					dtLatestCreateDate = objFile.DateCreated
				Else
					'Move file to the archive
					Err.Clear
					objFile.Move(constFileCompletedLocation & "Old_" & objFile.Name)
					If Not Err.Number = 0 Then
						sErrMsg = "Unable to move old RMCDS extract " & objFile.Path & " to its archival location "
						sErrMsg = sErrMsg & constFileCompletedLocation & " (" & Err.Description & ")"
						fnLogEntry sLog, sErrMsg, constError & " " & Err.Number
					End If
				End If
			End If
		Next
		
		'Split the latest RMCDS extract into chunks
		If fnSplitFile(strLatestExtract) Then
			If fnZIPChunks() Then
				'Move file to the archive
				Set objFile = objFSO.GetFile(strLatestExtract)
				Err.Clear
				objFile.Move(constFileCompletedLocation & fnConstructDTStamp(Now, False) & "_" & objFile.Name)
				If Not Err.Number = 0 Then
					sErrMsg = "Unable to move split RMCDS extract " & strLatestExtract & " to its archival location "
					sErrMsg = sErrMsg & constFileCompletedLocation & " (" & Err.Description & ")"
					fnLogEntry sLog, sErrMsg, constError & " " & Err.Number
				End If
			End If
		End If
	Else
		sErrMsg = "Unable to retrieve collection of files in " & constFileSourceLocation & " folder (" & Err.Description & ")"
		fnLogEntry sLog, sErrMsg, constError & " " & Err.Number
	End If
End If

'Clean up

On Error Resume Next

Set colFiles = Nothing
objFile.Close
Set objFile = Nothing
objPastFile.Close
Set objPastFile = Nothing
Set colFiles = Nothing
Set objFSO = Nothing

Function fnIncludeScript(strScriptFile)
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
''    Author:     ebgreen (http://www.visualbasicscript.com/m29285.aspx)
''    Purpose:    Implements Include functionality
''    Takes:      strScriptFile - The name of the file containing the script
''                    			  to import. Must be a valid path.
''	  Returns:    sResult 	- Empty string on success,
'                             |-delimited string containing the error code
'                             and error description on failure.
''    Revision History:
''        06/03/10    ZG	Modified error handling
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

	Dim objFSO
	Dim objFile
	Dim strFile

	On Error Resume Next

	Set objFSO = CreateObject ("Scripting.FileSystemObject")

	'Check to see if the INCLUDE file exists. If it does not, return an error
	If objFSO.FileExists(strScriptFile) Then
		'Open the file to be loaded. If the open fails, return an error.
		Err.Clear
		Set objFile = objFSO.OpenTextFile(strScriptFile)
		If Err.Number = 0 Then
			'The file object is created so read all of the file and ececute it globally to load the class for use
			strFile = objFile.ReadAll
			ExecuteGlobal strFile
			If Err.Number = 0 Then
				fnIncludeScript = ""
			Else
				fnIncludeScript = Err.Number & "|" & "The specified INCLUDE file " & strScriptFile & " could not be loaded: " & Err.Description
			End If
		Else
			fnIncludeScript = Err.Number & "|" & "The specified INCLUDE file " & strScriptFile & " could not be opened for reading: " & Err.Description
		End If
	Else
		fnIncludeScript = "53" & "|" & "The specified INCLUDE file " & strScriptFile & " does not exist"
	End If

	objFile.Close
	Set objFile = Nothing
	Set objFSO = Nothing

End Function

Function fnSplitFile(p_sFile)
'*********************************************************************
' Purpose	:	Read records from specified file. Fields will be parsed
'				according to previously retrieved record layout
'				(see fnReadRecordDefinition)
' Parameters:	p_sFile - Full path and name of the file to be split
' Returns:		True on success, false on failure
' Revision History:
' 08/29/11    ZPG	Original creation
'*********************************************************************

	Dim l_bResult
	Dim l_objInput
	Dim l_arrRecords
	Dim l_iCount
	Dim l_sFNPrefix
	Dim l_iChunkNumber
	Dim l_iChunksTotal
	Dim l_sFN
	Dim l_objOutput
	
	REM On Error Resume Next

	'Initialize
	l_bResult = True
	l_iChunkNumber = 0

	'Open the source file 
	Set l_objInput = objFSO.OpenTextFile(p_sFile, ForReading)
	
	'Split text into indifidual records
	l_arrRecords = Split(l_objInput.ReadAll, vbCrLf)
	
	'Remove trailing blank lines
	Do While l_arrRecords(UBound(l_arrRecords)) = ""
		ReDim Preserve l_arrRecords(UBound(l_arrRecords) - 1)
	Loop
	
	'Calculate the number of chunks that will be produced
	l_iChunksTotal = fnRoundUp(UBound(l_arrRecords)/constMaxRecords)
	If l_iChunksTotal = 0.1 Then	'Error in fnRoundUp
		l_bResult = False
	Else
		'Construct file name prefix
		l_sFNPrefix = fnConstructDTStamp(Now, False)
		
		'Output records to file chunk by chunk
		For l_iCount = 0 to UBound(l_arrRecords) 
			'Detect the time when a new chunk should be created
			If l_iChunkNumber < fnRoundUp((l_iCount + 1)/constMaxRecords) Then
				'Close file containing previous chunk
				If Not IsEmpty(l_objOutput) Then l_objOutput.Close
				Err.Clear
				
				'Start new chunk
				l_iChunkNumber = fnRoundUp((l_iCount + 1)/constMaxRecords)
				
				'Construct file name for the current chunk
				l_sFN = l_sFNPrefix & "_" & l_iChunkNumber & "_" & l_iChunksTotal & ".txt"
				
				'Open output file for the new chunk
				Err.Clear
				Set l_objOutput = objFSO.CreateTextFile(constProcessingFolder & l_sFN, True)	'Overwrite if file already exists
				If Not Err.Number = 0 Then
					l_bResult = False
					sErrMsg = "Unable to create file " & constProcessingFolder & l_sFN & " (" & Err.Description & ")"
					fnLogEntry sLog, sErrMsg, constError & " " & Err.Number
					Exit For
				End If
			End If
			
			'Output current record to the file
			l_objOutput.WriteLine(l_arrRecords(l_iCount))
		Next
	End If

	fnSplitFile = l_bResult

	'Clean up
	On Error Resume Next
	l_objInput.Close
	Set l_objInput = Nothing
	l_objOutput.Close
	Set l_objOutput = Nothing

End Function

Function fnZIPChunks()
'*********************************************************************
' Purpose	:	ZIPs all files in the Processing folder and puts them into 
'				the FTP pickup folder
' Parameters:	None
' Returns:		True on success, false on failure
' Revision History:
' 08/30/11    ZPG	Original creation
'*********************************************************************

	Dim l_bResult
	Dim l_colFiles
	Dim l_objFile
	Dim l_objZIP
	Dim l_iCount
	Dim l_sFN

	'Assume success
	l_bResult = True
	
	'Establish a compressed folder object
	Set l_objZIP = New CompressedFolder

	'Scroll through all files in processing folder
	Err.Clear
	Set l_colFiles = objFSO.GetFolder(constProcessingFolder).Files
	If Err.Number = 0 Then
		For Each l_objFile In l_colFiles
			l_sFN = objFSO.GetFolder(constFileTargetLocation).Path & "\" & Split(l_objFile.Name, ".")(0) & ".ZIP" 'Convert relative path to absolute
			l_objZIP.Create l_sFN
			If objFSO.FileExists(l_sFN) Then
				l_objZIP.Add l_objFile.Path, vbFalse 'Don't keep the original
				If Not l_objZIP.Count = 1 Then
					l_bResult = False
					sErrMsg = "Unable to ZIP file " & l_objFile.Path 
					fnLogEntry sLog, sErrMsg, constError 
					Exit For
				End if
			Else
				l_bResult = False
				sErrMsg = "Unable to create ZIP file " & l_sFN 
				fnLogEntry sLog, sErrMsg, constError 
				Exit For
			End If
		Next
	Else
		l_bResult = False
		sErrMsg = "Unable to retrieve collection of files in " & constProcessingFolder & " folder (" & Err.Description & ")"
		fnLogEntry sLog, sErrMsg, constError & " " & Err.Number
	End If

	fnZIPChunks = l_bResult

	'Clean up
	On Error Resume Next
	l_objFile.Close
	Set l_objFile = Nothing
	Set l_colFiles = Nothing
	Set l_objZIP = Nothing
	
End Function

Function fnConstructDTStamp(p_sDateTime, p_bIncludeTime)
'*********************************************************************
' Purpose	:	Constructs date/time stamp for the specified date/time 
' Parameters:	p_sDateTime		- Date and time that will be used to construct the stamp
'				p_bIncludeTime	- Flag indicating whether time should be included in the stamp
' Returns:    	sResult 		- Stamp for the specified date/time
'							  	on success, empty string on failure
' Revision History:
' 08/29/11    ZPG	Original creation 
'*********************************************************************	

	Dim l_sResult
	Dim l_sName

	On Error Resume Next
	
	'Assume failure
	l_sResult = ""
	
	'Construct the suffix
	l_sName = Right(Year(p_sDateTime), 2)
	l_sName = l_sName & Right("0" & Month(p_sDateTime), 2)
	l_sName = l_sName & Right("0" & Day(p_sDateTime), 2)
	If p_bIncludeTime = True Then
		l_sName = l_sName & Right("0" & Hour(p_sDateTime), 2)
		l_sName = l_sName & Right("0" & Minute(p_sDateTime), 2)
		l_sName = l_sName & Right("0" & Second(p_sDateTime), 2)
	End If
	
	'Finish constructing the name if the date part is formed correctly
	If (Len(l_sName) = 12 And p_bIncludeTime = True) Or (Len(l_sName) = 6 And p_bIncludeTime = False) Then 
		l_sResult = l_sName
	End If
	
	fnConstructDTStamp = l_sResult
	
End Function

Function fnRoundUp(p_dblNumber)
'*********************************************************************
' Purpose	:	Rounds up specified number to the nearest whole number 
' Parameters:	p_dblNumber	- Number to be rounded up
' Returns:    	Rounded up value on success, 0.1 on failure
' Revision History:
' 08/29/11    ZPG	Original creation 
'*********************************************************************	

	Dim l_dblResult
	Dim l_dblValue

	If IsNumeric(p_dblNumber) Then
		l_dblResult = Fix(p_dblNumber)
		If l_dblResult < p_dblNumber  Then
			l_dblResult = l_dblResult + 1
		End If
	Else
		l_dblResult = 0.1
	End If
	
	fnRoundUp = l_dblResult
	
End Function

