Option Explicit

'SCHEDULING: This script will be run on demand

'Script parameters
Const constFeedName = "Set_Values"
Const constRecordLayout = "OncoRecordLayout-A.txt" 
Const constAppTitle = "Set Values"
Const constPaddingChar = " "

'Environment-specific feed processing parameters are defined immediately after processing INCLUDES

Dim objFSO
Dim objFile
Dim arrIncludes
Dim iCount
Dim sText
Dim sLog
Dim sErrMsg
Dim sProcName
Dim arrFields
Dim arrRecords
Dim arrRules
Dim sFile
Dim sInstructions

ReDim arrIncludes(2)
arrIncludes(0) = "GlobalParms.vbs" 'This file must be included first
arrIncludes(1) = "Logger.vbs"
arrIncludes(2) = "GeneralFunctions.vbs"

For iCount = 0 To UBound(arrIncludes)
	sText = fnIncludeScript(arrIncludes(iCount))
	If Not sText = "" Then
		wscript.Echo "Unable to include script " & arrIncludes(iCount) & " (Err " & Split(sText, "|")(0) & "): " & Split(sText, "|")(1)
		wscript.Quit
	End If
Next

REM On Error Resume Next

'Construct error log file name
sLog = constLogFolder & fnConstructLogName(constFeedName, Date)

'Prompt for parameters
'sFile = InputBox("Data file name with full path:", constAppTitle, "SaveONCOa.txt")
sFile = InputBox("Data file name with full path:", constAppTitle)
If Trim(sFile) = "" Then wscript.Quit
'sInstructions = InputBox("Instructions file name with full path:", constAppTitle, "SetValues.txt")
sInstructions = InputBox("Instructions file name with full path:", constAppTitle)
If Trim(sInstructions) = "" Then wscript.Quit


'Establish required global objects
Set objFSO = CreateObject("Scripting.FileSystemObject")

'Retrieve record layout
If fnReadRecordDefinition Then
	If objFSO.FileExists(sFile) Then
		Err.Clear 
		Set objFile = objFSO.GetFile(sFile)
		If Err.Number = 0 Then
			If fnReadInstructions Then		
				If fnReadParsedRecords(objFile) Then
					If fnSetValues Then
						If Not fnOutputTabDelimited(constLogFolder & "ValuesSet_" & objFile.Name) Then
							sErrMsg = "Unable to output modified data to " & constLogFolder & "ValuesSet_" & objFile.Name
							fnLogEntry sLog, sErrMsg, constError 
						End If
					Else
						sErrMsg = "Unable to set fields values in file " & objFile.Name
						fnLogEntry sLog, sErrMsg, constError
					End If
				Else
					sErrMsg = "Records couldn't be parsed in file " & sFile
					fnLogEntry sLog, sErrMsg, constError
				End If
			End If
		Else
			sErrMsg = "Specified file " & sFile & " couldn't be accessed (" & Err.Description & ")"
			fnLogEntry sLog, sErrMsg, constError & " " & Err.Number
		End If
	Else
		sErrMsg = "Specified file " & sFile & " couldn't be found" 
		fnLogEntry sLog, sErrMsg, constError
	End If
End If

'Clean up

On Error Resume Next

objFile.Close
Set objFile = Nothing
Set objFSO = Nothing

Function fnIncludeScript(strScriptFile)
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
''    Author:     ebgreen (http://www.visualbasicscript.com/m29285.aspx)
''    Purpose:    Implements Include functionality
''    Takes:      strScriptFile - The name of the file containing the script
''                    			  to import. Must be a valid path.
''	  Returns:    sResult 	- Empty string on success,
'                             |-delimited string containing the error code
'                             and error description on failure.
''    Revision History:
''        06/03/10    ZG	Modified error handling
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

	Dim objFSO
	Dim objFile
	Dim strFile

	On Error Resume Next

	Set objFSO = CreateObject ("Scripting.FileSystemObject")

	'Check to see if the INCLUDE file exists. If it does not, return an error
	If objFSO.FileExists(strScriptFile) Then
		'Open the file to be loaded. If the open fails, return an error.
		Err.Clear
		Set objFile = objFSO.OpenTextFile(strScriptFile)
		If Err.Number = 0 Then
			'The file object is created so read all of the file and ececute it globally to load the class for use
			strFile = objFile.ReadAll
			ExecuteGlobal strFile
			If Err.Number = 0 Then
				fnIncludeScript = ""
			Else
				fnIncludeScript = Err.Number & "|" & "The specified INCLUDE file " & strScriptFile & " could not be loaded: " & Err.Description
			End If
		Else
			fnIncludeScript = Err.Number & "|" & "The specified INCLUDE file " & strScriptFile & " could not be opened for reading: " & Err.Description
		End If
	Else
		fnIncludeScript = "53" & "|" & "The specified INCLUDE file " & strScriptFile & " does not exist"
	End If

	objFile.Close
	Set objFile = Nothing
	Set objFSO = Nothing

End Function

Function fnReadRecordDefinition()
'*********************************************************************
' Purpose	:	Read record definition file. Columns in this  file are:
'				1. Field_Number
'				2. Start_Position
'				3. Length
'				4. Name
'				5. Required_Value
' Parameters:	None
' Returns:		True on success, false on failure
' Revision History:
' 07/01/11    ZPG	Original creation
'*********************************************************************

	Dim l_bResult
	Dim l_objRecordLayout
	Dim l_sLine
	Dim l_arrField

	'Assume success
	l_bResult = True

	If objFSO.FileExists(constRecordLayout) Then
		Set l_objRecordLayout = objFSO.OpenTextFile(constRecordLayout, ForReading)
		'Verify that the first line contains correct column headers
		If l_objRecordLayout.AtEndOfStream Then
			l_bResult = False
			sErrMsg = "Missing column header in the record layout definition file " & constRecordLayout
			fnLogEntry sLog, sErrMsg, constError
		Else
			l_sLine = l_objRecordLayout.ReadLine() 'Read a new line of file list
			'Parse column names in the header
			l_arrField = Split(l_sLine, vbTab)
			If UBound(l_arrField) < 4 Then
				l_bResult = False
				sErrMsg = "Invalid column header in the record layout definition file " & constRecordLayout
				fnLogEntry sLog, sErrMsg, constError
			Else
				If l_arrField(0) = "Field_Number" And l_arrField(1) = "Start_Position" And l_arrField(2) = "Length" And l_arrField(3) = "Name" And l_arrField(4) = "Required_Value" Then
					'Save column headers as the first element of the array (this will make it 1-based for data storage)
					ReDim arrFields(4, 0)
					arrFields(0, 0) = l_arrField(0)	'Field_Number
					arrFields(1, 0) = l_arrField(1)	'Start_Position
					arrFields(2, 0) = l_arrField(2)	'Length
					arrFields(3, 0) = l_arrField(3)	'Name
					arrFields(4, 0) = l_arrField(4)	'Required_Value
					'Read attributes for each field
					Do While Not l_objRecordLayout.AtEndOfStream
						l_sLine = l_objRecordLayout.ReadLine() 'Read a new line of file
						If Not Trim(l_sLine) = "" Then
							ReDim Preserve arrFields(4, UBound(arrFields, 2) + 1)
							l_arrField = Split(l_sLine, vbTab)
							If UBound(l_arrField) < 4 Then
								l_bResult = False
								sErrMsg = "Invalid definition for field " & UBound(arrFields, 2) & " in the record layout definition file " & constRecordLayout
								fnLogEntry sLog, sErrMsg, constError
							Else
								If IsNumeric(l_arrField(0)) And IsNumeric(l_arrField(1)) And IsNumeric(l_arrField(2)) Then
									'Save field attributes
									arrFields(0, UBound(arrFields, 2)) = l_arrField(0)	'Field_Number
									arrFields(1, UBound(arrFields, 2)) = l_arrField(1)	'Start_Position
									arrFields(2, UBound(arrFields, 2)) = l_arrField(2)	'Length
									arrFields(3, UBound(arrFields, 2)) = l_arrField(3)	'Name
									arrFields(4, UBound(arrFields, 2)) = l_arrField(4)	'Required_Value
								Else
									l_bResult = False
									sErrMsg = "Invalid definition for field " & UBound(arrFields, 2) & " in the record layout definition file " & constRecordLayout
									fnLogEntry sLog, sErrMsg, constError
								End If
							End If
						End If
					Loop
				Else
					l_bResult = False
					sErrMsg = "Invalid column name in the header of the record layout definition file " & constRecordLayout
					fnLogEntry sLog, sErrMsg, constError
				End If
			End If
		End If
	Else
		l_bResult = False
		sErrMsg = "Record layout definition file " & constRecordLayout & " is not found"
		fnLogEntry sLog, sErrMsg, constError
	End If

	fnReadRecordDefinition = l_bResult

	'Clean up
	On Error Resume Next
	l_objRecordLayout.Close
	Set l_objRecordLayout = Nothing

End Function

Function fnReadParsedRecords(p_objFile)
'*********************************************************************
' Purpose	:	Read records from specified file. Fields will be parsed
'					according to previously retrieved record layout
'					(see fnReadRecordDefinition) and parsing rules where fields
'					in the record are tab-delimited and records are terminated
'					with vbCrLf
' Parameters:	p_objFile - File containing records to be read
' Returns:		True on success, false on failure
' Revision History:
' 07/01/11    ZPG	Original creation
'*********************************************************************

	Dim l_bResult
	Dim l_objData
	Dim l_sRecord
	Dim l_iCount
	Dim l_sValue

	'Assume success
	l_bResult = True

	'Prepare array that will hold records field by field
	ReDim arrRecords(UBound(arrFields, 2), 0)

	If objFSO.FileExists(p_objFile.Path) Then
		Set l_objData = objFSO.OpenTextFile(p_objFile.Path, ForReading)
		'Discard first line - the header
		If Not l_objData.AtEndOfStream Then 
			l_sRecord = l_objData.ReadLine
		End If
		'Read records
		Do While Not l_objData.AtEndOfStream 
			'Read record
			l_sRecord = l_objData.ReadLine
			'Add a leading tab
			l_sRecord = vbTab & l_sRecord
			'Extract original field values
			ReDim Preserve arrRecords(UBound(arrFields, 2), UBound(arrRecords, 2) + 1)
			For l_iCount = 1 to UBound(arrFields, 2)
				l_sValue = Mid(l_sRecord, arrFields(1, l_iCount) + l_iCount - 1, arrFields(2, l_iCount) + 1)
				'Remove leading tab from the field value
				If Left(l_sValue, 1) = vbTab Then
					arrRecords(l_iCount, UBound(arrRecords, 2)) = Right(l_sValue, Len(l_sValue) - 1)
				Else
					l_bResult = False
					sErrMsg = "Expected tab delimiter is not found between field #" & l_iCount - 1 & " and field #" & l_iCount
					sErrMsg = sErrMsg & " in record #" & UBound(arrFields, 2) & " of data file " & p_objFile.Path 
					fnLogEntry sLog, sErrMsg, constError
					Exit Do
				End If
			Next
		Loop
	Else
		l_bResult = False
		sErrMsg = "Data file " & p_objFile.Path & " is not found"
		fnLogEntry sLog, sErrMsg, constError
	End If

	fnReadParsedRecords = l_bResult

	'Clean up
	On Error Resume Next
	l_objData.Close
	Set l_objData = Nothing

End Function

Function fnOutputTabDelimited(p_sTargetFile)
'*********************************************************************
' Purpose	:	Writes current set of records to a tab-delimited file 
'					by record and by field
' Parameters:	p_sTargetFile	- Full path and name of the file where
'								  		records will be written out
' Returns:		True on success, false on failure
' Revision History:
' 07/14/11    ZPG	Original creation
'*********************************************************************

	Dim l_bResult
	Dim l_objOutputFile
	Dim l_iCount
	Dim l_iCount1
	Dim l_sText
	Dim l_bErr

	sProcName = "fnOutputTabDelimited"

	'Assume failure
	l_bResult = False

	'Create output file
	Err.Clear
	Set l_objOutputFile = objFSO.CreateTextFile(p_sTargetFile, True)	'Overwrite if file already exists
	If Err.Number = 0 Then
		'Create header
		l_sText = ""
		For l_iCount = 1 To UBound(arrFields, 2)
			'Construct field name header
			l_sText = l_sText & vbTab & "(" & arrFields(0, l_iCount) & ") " & arrFields(3, l_iCount)
		Next
		
		'Remove leading tab
		If Left(l_sText, 1) = vbTab Then l_sText = Right(l_sText, Len(l_sText) - 1)
		
		'Output header to the file
		Err.Clear
		l_objOutputFile.WriteLine(l_sText)
		If Err.Number = 0 Then
			'Scroll through all existing records in current set
			For l_iCount = 1 To UBound(arrRecords, 2)
				'Construct the record field by field
				l_sText = ""
				For l_iCount1 = 1 To UBound(arrFields, 2)
					l_sText = l_sText & vbTab & arrRecords(l_iCount1, l_iCount)
				Next
				
				'Remove leading tab
				If Left(l_sText, 1) = vbTab Then l_sText = Right(l_sText, Len(l_sText) - 1)
				
				'Output record to the file
				Err.Clear
				l_objOutputFile.WriteLine(l_sText)
				If Not Err.Number = 0 Then
					sErrMsg = "Unable to write record to the file (" & Err.Description & ")"
					fnLogEntry sLog, sErrMsg, constError & " " & Err.Number 
					l_bErr = True
					Exit For 'l_iCount loop
				End If		
			Next	
			
			If Not l_bErr Then l_bResult = True
		Else
			sErrMsg = "Unable to write record header to the file (" & Err.Description & ")"
			fnLogEntry sLog, sErrMsg, constError & " " & Err.Number 
		End If		
	Else
		sErrMsg = "Unable to create output file " & p_sTargetFile & " (" & Err.Description & ")"
		fnLogEntry sLog, sErrMsg, constError & " " & Err.Number
	End If

	fnOutputTabDelimited = l_bResult

	'Clean up
	On Error Resume Next
	l_objOutputFile.Close
	Set l_objOutputFile = Nothing

End Function

Function fnReadInstructions()
'*********************************************************************
' Purpose	:	Read instructions for setting field values
' NOTE:	Expected rule layout is <Record Number>|<Transformation>|<Comment>
'			Comment is optional
' Parameters:	None
' Returns:		True on success, false on failure
' Revision History:
' 08/05/11    ZPG	Original creation
'*********************************************************************

	Dim l_objRules
	Dim l_bResult
	Dim l_arrRule
	Dim l_sLine

	'Assume success
	l_bResult = True

	ReDim arrRules(1, 0)

	If objFSO.FileExists(sInstructions) Then
		Set l_objRules = objFSO.OpenTextFile(sInstructions, ForReading)
		'Read each rule
		Do While Not l_objRules.AtEndOfStream
			l_sLine = l_objRules.ReadLine() 'Read a new line of file
			If Not Trim(l_sLine) = "" Then
				ReDim Preserve arrRules(1, UBound(arrRules, 2) + 1)
				l_arrRule = Split(l_sLine, "|")
				If (UBound(l_arrRule) = 1) Or (UBound(l_arrRule) = 2) Then
					arrRules(0, UBound(arrRules, 2)) = l_arrRule(0) 'Record number
					arrRules(1, UBound(arrRules, 2)) = l_arrRule(1) 'Transformation
				Else
					l_bResult = False
					sErrMsg = "Invalid instruction #" & UBound(arrRules, 2) & " found in file " & sInstructions
					fnLogEntry sLog, sErrMsg, constError
					Exit Do
				End If
			End If
		Loop
	Else
		l_bResult = False
		sErrMsg = "File " & sInstructions & " containing instructions for setting up field values is not found"
		fnLogEntry sLog, sErrMsg, constError
	End If

	fnReadInstructions = l_bResult

	'Clean up
	On Error Resume Next
	l_objData.Close
	Set l_objData = Nothing

End Function

Function fnSetValues()
'*********************************************************************
' Purpose	:	Set values per instructions in current set of records
' Parameters:	None
' Returns:		True on success, false on failure
' Revision History:
' 08/05/11    ZPG	Original creation
'*********************************************************************

	Dim l_iCount1
	Dim l_iCount2
	Dim l_arrConditions
	Dim l_arrTransformations
	Dim l_bRet
	Dim l_iRet
	Dim l_bResult
	Dim l_sCondition
	Dim l_sTransformation
	Dim l_sCountyCode

	'Initialize
	l_bResult = True

	'Scroll through the set of rules
	For l_iCount1 = 1 To UBound(arrRules, 2)
		'Extract a set of transformations from the current rule
		l_arrTransformations = Split(arrRules(1, l_iCount1), ",")
		'Transform record according to the rule
		For l_iCount2 = 0 To UBound(l_arrTransformations)
			l_bResult = l_bResult And fnTransformField(CInt(arrRules(0, l_iCount1)), l_arrTransformations(l_iCount2))
			If l_bResult = False Then Exit For 'l_iCount2 loop iterating transformations
		Next
		If l_bResult = False Then
			Exit For	'l_iCount1 loop iterating rules
		Else
			If l_bRet Then
			End If
		End If
	Next

	fnSetValues = l_bResult

End Function

Function fnTransformField(p_iRecNum, p_sTransformation)
'*********************************************************************
' Purpose	:	Apply specified transformation to the field of a record
' Parameters:	p_iRecNum 			- Record number
'				p_sTransformation	- Transformation describing the field and its new value
' Returns:		True on success, false on failure
' Revision History:
' 07/02/11    ZPG	Original creation
'*********************************************************************

	Dim l_bResult
	Dim l_arrTransformation
	Dim l_iFieldNum
	Dim l_sNewValue

	sProcName = "fnTransformField"

	'Assume failure
	l_bResult = False

	'Validate specified record number
	If p_iRecNum < 1 Or p_iRecNum > UBound(arrRecords, 2) Then
		sErrMsg = "[" & objFile.Name & "] " & sProcName & ": Invalid record number " & p_iRecNum & " specified for transformation "
		sErrMsg = sErrMsg & p_sTransformation & ". Valid record numbers are 1 through " & UBound(arrRecords, 2) & "."
		fnLogEntry sLog, sErrMsg, constError
	Else
		'Parse transformation specification
		l_arrTransformation = Split(p_sTransformation, "=")
		If UBound(l_arrTransformation) = 1 Then
		l_iFieldNum = CInt(l_arrTransformation(0))
			l_sNewValue = l_arrTransformation(1)
			'Validate field number
			If l_iFieldNum < 1 Or l_iFieldNum > UBound(arrFields, 2) Then
				sErrMsg = "[" & objFile.Name & "] " & sProcName & ": Invalid field number " & l_iFieldNum & " specified for transformation "
				sErrMsg = sErrMsg & p_sTransformation & ". Valid field numbers are 1 through " & UBound(arrFields, 2) & "."
				fnLogEntry sLog, sErrMsg, constError
			Else
				If UCase(l_sNewValue) = "NULL" Then
					'Set record to Null (fill entire field with padding characters)
					arrRecords(l_iFieldNum, p_iRecNum) = String(arrFields(2, l_iFieldNum), constPaddingChar)
					l_bResult = True
				Else
					'Validate new value for the field
					If Len(l_sNewValue) > CInt(arrFields(2, l_iFieldNum)) Then
						sErrMsg = "[" & objFile.Name & "] " & sProcName & ": Value in specified transformation "
						sErrMsg = sErrMsg & p_sTransformation & " is too long. Valid field length is " & arrFields(2, l_iFieldNum) & "."
						fnLogEntry sLog, sErrMsg, constError
					Else
						'Apply transformation to the record
						arrRecords(l_iFieldNum, p_iRecNum) = Left(l_sNewValue & String(arrFields(2, l_iFieldNum), constPaddingChar), arrFields(2, l_iFieldNum))
						l_bResult = True
					End If
				End If
			End If
		Else
			sErrMsg = "[" & objFile.Name & "] " & sProcName & ": Invalid transformation " & p_sTransformation & " specified for record number " & p_iRecNum
			fnLogEntry sLog, sErrMsg, constError
		End If
	End If

	fnTransformField = l_bResult

End Function
