Option Explicit

'SCRIPT PARAMETERS
'NOTE: 	This script expects that the parent script also includes GlobalParms.vbs
'		where database parameters are defined
'Const constExchangeServer="DNS"
Const constExchangeServer="DNS        "	'This setting will allow sending e-mails outside VA
Const constSender="PII             "	'Account used to send emails
Const constServerPort=PORT

Dim arrRecipients

	ReDim arrRecipients(2)
	arrRecipients(0) = "ZPGoldman@sbcglobal.net"
	arrRecipients(1) = "ZGoldman@harris.com"
	arrRecipients(2) = "Zoya.Goldman@gmail.com"
	
	Msgbox  fnSendEmail(arrRecipients, "Test Subject", "test mssg", "")

Function fnSendEmail(p_arrRecipients, p_sSubject, p_sMsg, p_arrAttachments)
'*********************************************************************
' Purpose	:	Sends an e-mail  
' Parameters:	p_arrRecipients	- array of email addresses of email recipients    
'				p_sSubject			- Subject of the email 
'				p_sMsg				- Text that should be sent
'				p_arrAttachments 	- An array of attachment file names 
'									or "" if no attachments.
'									If an attachment cannot be found, it will
'									be listed in the body of the e-mail
' Returns:    	sResult 			- Empty string on success,
'                             		|-delimited string containing the error code 
'                             		and error description on failure.
' Revision History:
' 07/19/11    ZPG	Original creation 
'*********************************************************************	
	
	'Constants - messaging
	Const cdoSendUsingPickup = 1
	Const cdoSendUsingPort = 2
	Const cdoAnonymous = 0 
  
	Dim l_objMessage 
	Dim l_iCount
	Dim l_sRecipients
	Dim l_iNumberOfAttachments
	Dim l_sMissingAttachments
	Dim l_iMissingAttachments
	Dim l_objFSO
	
	REM On Error Resume Next
	
	'Get the list of recipients
	For l_iCount = LBound(p_arrRecipients) to UBound(p_arrRecipients)
		l_sRecipients = l_sRecipients & "; " & p_arrRecipients(l_iCount)
	Next
	l_sRecipients = Right(l_sRecipients, Len(l_sRecipients)-2)
	If Trim(l_sRecipients) = "" Then
		fnSendEmail = "0" & "|" & "No email recipients specified."
	Else
		'Create a Message object
		Set l_objMessage = CreateObject("CDO.Message") 
		
		l_objMessage.Subject = p_sSubject
		l_objMessage.From = constSender  
		l_objMessage.To = l_sRecipients 
		
		'Add attachments
		If Not p_arrAttachments = "" And IsArray(p_arrAttachments) Then
			Set l_objFSO = CreateObject("Scripting.FileSystemObject") 
			l_iNumberOfAttachments=UBound(p_arrAttachments)
			For l_iCount = 0 To l_iNumberOfAttachments
				If l_objFSO.FileExists(p_arrAttachments(l_iCount)) Then
					Err. Clear
					l_objMessage.AddAttachment p_arrAttachments(l_iCount)
				Else
					l_iMissingAttachments = l_iMissingAttachments + 1
					l_sMissingAttachments = l_sMissingAttachments & vbLFCR & p_arrAttachments(l_iCount)
				End If
			Next
			
			If l_iMissingAttachments > 0 Then 
				If l_iMissingAttachments > 1 Then
					l_sMissingAttachments = vbLFCR & vbLFCR & "The following files were not attached because they were not found in the specified location:" & l_sMissingAttachments
				Else
					l_sMissingAttachments = vbLFCR & vbLFCR & "The following file was not attached because it was not found in the specified location:" & l_sMissingAttachments
				End If
				p_sMsg = p_sMsg & l_sMissingAttachments
			End If
		End If
		
		l_objMessage.TextBody = p_sMsg 
				
		'Set configuration
		l_objMessage.Configuration.Fields("http://schemas.microsoft.com/cdo/configuration/sendusing") = cdoSendUsingPort 
		l_objMessage.Configuration.Fields("http://schemas.microsoft.com/cdo/configuration/smtpserver") = constExchangeServer 
		l_objMessage.Configuration.Fields("http://schemas.microsoft.com/cdo/configuration/smtpserverport") = constServerPort 
		l_objMessage.Configuration.Fields("http://schemas.microsoft.com/cdo/configuration/smtpauthenticate") = cdoAnonymous 
		l_objMessage.Configuration.Fields.Update 
	
		l_objMessage.Send 
		If Err.Number = 0 Then 						
			fnSendEmail = ""
		Else
			fnSendEmail = Err.Number & "|" & "Sending the e-mail: " & Err.Description
		End If
	End If
	
	'Cleanup
	Set l_objMessage = Nothing
	Set l_objFSO = Nothing
	
End Function