Option Explicit

'SCHEDULING: This script should be run once a day

'Script parameters
Const constFeedName = "RMCDS Manipulation"
Const constAppEXEName = "z_MENUPG.exe"
Const constAppVersion = "1.0.0.1"
Const constRegPath = "HKLM\SOFTWARE\CCR_CRS\"
Const constLaunchVBSName = "RunRMCDS.vbs"

'Environment-specific feed processing parameters are defined immediately after processing INCLUDES

Dim objFSO
Dim objShell
Dim sRet
Dim iRet
Dim bContinue
Dim objFile
Dim arrIncludes
Dim iCount
Dim sText
Dim sLog
Dim sErrMsg
Dim sProcName
Dim arrRet
Dim sUserID
Dim sPwd
Dim sCmd

ReDim arrIncludes(2)
arrIncludes(0) = "GlobalParms.vbs" 'This file must be included first
arrIncludes(1) = "Logger.vbs"
arrIncludes(2) = "GeneralFunctions.vbs"

For iCount = 0 To UBound(arrIncludes)
	sText = fnIncludeScript(arrIncludes(iCount))
	If Not sText = "" Then
		wscript.Echo "Unable to include script " & arrIncludes(iCount) & " (Err " & Split(sText, "|")(0) & "): " & Split(sText, "|")(1)
		wscript.Quit
	End If
Next

Select Case constEnvironment
	Case "DEVL"
		ExecuteGlobal Replace("Const constAppEXEPath=#C:\Documents and Settings\Zoya\Desktop\RMCDS\rmc-2010\Programs\#", "#", Chr(34))	'IMPORTANT: Include trailing backslash
	Case "TEST"
		ExecuteGlobal Replace("Const constAppEXEPath=#C:\RMCDS\rmc-2010\Programs\#", "#", Chr(34))										'IMPORTANT: Include trailing backslash
	Case "PROD"
		ExecuteGlobal Replace("Const constAppEXEPath=#C:\RMCDS\rmc-2010\Programs\#", "#", Chr(34))										'IMPORTANT: Include trailing backslash
	Case Else
		MsgBox "Unrecognized environment <" & constEnvironment & ">!"
		wscript.Quit
End Select

REM On Error Resume Next

'Construct error log file name
sLog = constLogFolder & fnConstructLogName(constFeedName, Date)

'Establish required global objects
Set objFSO = CreateObject("Scripting.FileSystemObject")
Set objShell = CreateObject("WScript.Shell")

bContinue = False

'Check for EXE presence 
If objFSO.FileExists(constAppEXEPath & constAppEXEName) Then
	'Check EXE file version
	sRet = objFSO.GetFileVersion(constAppEXEPath & constAppEXEName)
	If sRet = constAppVersion Then
		'Retrieve RMCDS login information
		arrRet = fnReadReg(constRegPath & "RMCDS")
		If arrRet(0) = "" Then
			sErrMsg = "Unable to retrieve RMCDS login information from the registry " 
			sErrMsg = sErrMsg & constRegPath & "RMCDS" & " (" & arrRet(2) & ")"
			'Make an error log entry
			fnLogEntry strLog, sErrMsg, constError & " " & arrRet(1)	
		Else
			If InStr(arrRet(0), "/") > 0 Then
				sUserID = Split(arrRet(0), "/")(0)
				sPwd = Split(arrRet(0), "/")(1)
				bContinue = True
			End If
		End If	
	Else
		sErrMsg = "Version of RMCDS EXE file <" & sRet & "> does not match expected version <" & constAppVersion & ">"
		fnLogEntry sLog, sErrMsg, constError
	End If
Else
	sErrMsg = "Unable to find RMCDS EXE file " & constAppEXEPath & constAppEXEName
	fnLogEntry sLog, sErrMsg, constError
End If

If bContinue Then
	sCmd = Chr(34) & constAppEXEPath & constLaunchVBSName & Chr(34) & " " & constAppEXEName
	sCmd = Chr(34) & constAppEXEPath & constAppEXEName & Chr(34) 
	iRet = objShell.Run(sCmd, 1, True)
	If iRet = 0 Then
		WScript.Sleep 2000
		objShell.SendKeys sUserID
		objShell.SendKeys "{TAB}"
		objShell.SendKeys sPwd
		objShell.SendKeys "{ENTER}"
	Else
		sErrMsg = "Script " & constAppEXEPath & constLaunchVBSName & " returned error code " & iRet
		fnLogEntry sLog, sErrMsg, constError
	End If
End If

'Clean up

On Error Resume Next

Set objFSO = Nothing
Set objShell = Nothing

Function fnIncludeScript(strScriptFile)
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
''    Author:     ebgreen (http://www.visualbasicscript.com/m29285.aspx)
''    Purpose:    Implements Include functionality
''    Takes:      strScriptFile - The name of the file containing the script
''                    			  to import. Must be a valid path.
''	  Returns:    sResult 	- Empty string on success,
'                             |-delimited string containing the error code
'                             and error description on failure.
''    Revision History:
''        06/03/10    ZG	Modified error handling
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

	Dim objFSO
	Dim objFile
	Dim strFile

	On Error Resume Next

	Set objFSO = CreateObject ("Scripting.FileSystemObject")

	'Check to see if the INCLUDE file exists. If it does not, return an error
	If objFSO.FileExists(strScriptFile) Then
		'Open the file to be loaded. If the open fails, return an error.
		Err.Clear
		Set objFile = objFSO.OpenTextFile(strScriptFile)
		If Err.Number = 0 Then
			'The file object is created so read all of the file and ececute it globally to load the class for use
			strFile = objFile.ReadAll
			ExecuteGlobal strFile
			If Err.Number = 0 Then
				fnIncludeScript = ""
			Else
				fnIncludeScript = Err.Number & "|" & "The specified INCLUDE file " & strScriptFile & " could not be loaded: " & Err.Description
			End If
		Else
			fnIncludeScript = Err.Number & "|" & "The specified INCLUDE file " & strScriptFile & " could not be opened for reading: " & Err.Description
		End If
	Else
		fnIncludeScript = "53" & "|" & "The specified INCLUDE file " & strScriptFile & " does not exist"
	End If

	objFile.Close
	Set objFile = Nothing
	Set objFSO = Nothing

End Function

