Option Explicit

'SCHEDULING:	This script should be run once a day. 
'IMPORTANT:		Two instances of this script will be running in parallel for new and updated abstracts
'					These runs should never be concurrent as both update VistA site info file

'Script parameters
Const constFeedName = "Messaging"
Const constSiteInfo = "Sites.txt"
'Const constType = "New" 
Const constType = "Updated" 

'Environment-specific feed processing parameters are defined immediately after processing INCLUDES

Dim objFSO
Dim objFile
Dim colFiles
Dim arrIncludes
Dim iCount
Dim sText
Dim sLog
Dim sErrMsg
Dim sProcName
Dim sRet
Dim sFNPrefix
Dim arrSites
Dim iSourceColumn
Dim dtStartDate
Dim dtEndDate
Dim sFileName

Redim arrIncludes(2)
arrIncludes(0) = "GlobalParms.vbs" 'This file must be included first
arrIncludes(1) = "Logger.vbs"
arrIncludes(2) = "GeneralFunctions.vbs"

For iCount = 0 To UBound(arrIncludes)
	sText = fnIncludeScript(arrIncludes(iCount))
	If Not sText = "" Then
		wscript.Echo "Unable to include script " & arrIncludes(iCount) & " (Err " & Split(sText, "|")(0) & "): " & Split(sText, "|")(1)
		wscript.Quit
	End If
Next

Select Case constEnvironment
	Case "DEVL"
		ExecuteGlobal Replace("Const constFileSourceLocation=#.\Source_Files\#", "#", Chr(34))		'IMPORTANT: Include trailing backslash
	Case "TEST"
		ExecuteGlobal Replace("Const constFileSourceLocation=#.\Source_Files\#", "#", Chr(34))		'IMPORTANT: Include trailing backslash
	Case "PROD"
		ExecuteGlobal Replace("Const constFileSourceLocation=#.\Source_Files\#", "#", Chr(34))		'IMPORTANT: Include trailing backslash
	Case Else
		MsgBox "Unrecognized environment <" & constEnvironment & ">!"
		wscript.Quit
End Select

REM On Error Resume Next

'Construct error log file name
sLog = constLogFolder & fnConstructLogName(constFeedName, Date)

'Establish required global objects
Set objFSO = CreateObject("Scripting.FileSystemObject")

'Read the list of VistA sites
If fnReadSiteInfo Then
	'Set parameters for data retrieval
	Select Case UCase(constType)
	Case "NEW"
		iSourceColumn = 2
	Case "UPDATED"
		iSourceColumn = 3
	Case Else
		MsgBox "Unrecognized abstract type <" & constSiteInfo & ">!"
		wscript.Quit
	End Select
	
	'Scroll through array of VistA sites
	For iCount = 1 To UBound(arrSites, 2)
		dtStartDate = FormatDateTime(arrSites(iSourceColumn, iCount), vbShortDate)	
		'Do not allow today's date to be a start date
		If DateDiff("D", dtStartDate, Date) > 1 Then
			dtEndDate = DateAdd("D", -1, Date)
			'Get extracted data from OncoTrax			
			sRet = fnGetAbstracts(arrSites(0, iCount), dtStartDate, dtEndDate, constType)
			If sRet = "" Then
				sErrMsg = "No data returned for " & UCase(constType) & " abstracts for site " & arrSites(0, iCount)
				fnLogEntry sLog, sErrMsg, constError 
			Else
				'Save extracted data to file
				sFileName = fnConstructExtractFileName(arrSites(0, iCount), dtStartDate, dtEndDate)
				If sFileName = "" Then
					sErrMsg = "Unable to construct file name for parameters " & arrSites(0, iCount) & ", " & dtStartDate & ", " & dtEndDate
					fnLogEntry sLog, sErrMsg, constError 
				Else
					If fnOutputData(sRet, constFileSourceLocation & sFileName) Then
						'Update date of last data extract
						arrSites(iSourceColumn, iCount) = FormatDateTime(Now, vbShortDate)		
					Else
						sErrMsg = "Unable to save " & UCase(constType) &  " abstracts for site " & arrSites(0, iCount) 
						sErrMsg = sErrMsg & " for the period between " & dtStartDate & " and " & dtEndDate
						fnLogEntry sLog, sErrMsg, constError 
					End If	
				End If
			End If
		Else
			If DateDiff("D", dtStartDate, Date) = 0 Then
				sErrMsg = UCase(constType) & " abstracts for site " & arrSites(0, iCount) & " have already been retrieved today"
			Else
				sErrMsg = "Last retrieval date of " & UCase(constType) & " abstracts for site " & arrSites(0, iCount) & " in "
				sErrMsg = sErrMsg & constSiteInfo & " cannot be in the future"
			End If  
			fnLogEntry sLog, sErrMsg, constError 
		End If
	Next
	'Save updated VistA site info file 
	sRet = fnArrToText(arrSites)
	If sRet = "" Then
		
	Else
		If Not fnOutputData(sRet, constSiteInfo) Then
			sErrMsg = "Unable to save updated VistA site info file " & constSiteInfo 
			sErrMsg = sErrMsg & " after extracting " & UCase(constType) & " abstracts" 
			fnLogEntry sLog, sErrMsg, constError 
		End If	
	End If
End If

'Clean up

On Error Resume Next

objRS.Close
Set objRS = Nothing
objConn.Close
Set objConn = Nothing
Set colFiles = Nothing
objFile.Close
Set objFile = Nothing
Set objFSO = Nothing

Function fnIncludeScript(strScriptFile)
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
''    Author:     ebgreen (http://www.visualbasicscript.com/m29285.aspx)
''    Purpose:    Implements Include functionality
''    Takes:      strScriptFile - The name of the file containing the script
''                    			  to import. Must be a valid path.
''	  Returns:    sResult 	- Empty string on success,
'                             |-delimited string containing the error code
'                             and error description on failure.
''    Revision History:
''        06/03/10    ZG	Modified error handling
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

	Dim objFSO
	Dim objFile
	Dim strFile

	On Error Resume Next

	Set objFSO = CreateObject ("Scripting.FileSystemObject")

	'Check to see if the INCLUDE file exists. If it does not, return an error
	If objFSO.FileExists(strScriptFile) Then
		'Open the file to be loaded. If the open fails, return an error.
		Err.Clear
		Set objFile = objFSO.OpenTextFile(strScriptFile)
		If Err.Number = 0 Then
			'The file object is created so read all of the file and ececute it globally to load the class for use
			strFile = objFile.ReadAll
			ExecuteGlobal strFile
			If Err.Number = 0 Then
				fnIncludeScript = ""
			Else
				fnIncludeScript = Err.Number & "|" & "The specified INCLUDE file " & strScriptFile & " could not be loaded: " & Err.Description
			End If
		Else
			fnIncludeScript = Err.Number & "|" & "The specified INCLUDE file " & strScriptFile & " could not be opened for reading: " & Err.Description
		End If
	Else
		fnIncludeScript = "53" & "|" & "The specified INCLUDE file " & strScriptFile & " does not exist"
	End If

	objFile.Close
	Set objFile = Nothing
	Set objFSO = Nothing

End Function

Function fnReadSiteInfo()
'*********************************************************************
' Purpose	:	Read VistA site info into global array arrSites. 
'					Columns in this file are:
'					1. Site_Code
'					2. Site_Name
'					3. Last_New
'					4. Last_Updated
' Parameters:	None
' Returns:		True on success, false on failure
' Revision History:
' 08/08/11    ZPG	Original creation
'*********************************************************************

	Dim l_bResult
	Dim l_objSites
	Dim l_sLine
	Dim l_arrField
	Dim l_objDict

	sProcName = "fnReadSiteInfo"
	'Assume success
	l_bResult = True
	
	'Set up a Dictionary object for validation of the list of VistA sites
	Err.Clear
	Set l_objDict = CreateObject("Scripting.Dictionary")
	If Err.Number = 0 Then
		If objFSO.FileExists(constSiteInfo) Then
			Set l_objSites = objFSO.OpenTextFile(constSiteInfo, ForReading)
			'Verify that the first line contains correct column headers
			If l_objSites.AtEndOfStream Then
				l_bResult = False
				sErrMsg = "Missing column header in the VistA site info file " & constSiteInfo
				fnLogEntry sLog, sErrMsg, constError
			Else
				l_sLine = l_objSites.ReadLine() 'Read a new line of file list
				'Parse column names in the header
				l_arrField = Split(l_sLine, vbTab)
				If UBound(l_arrField) < 3 Then
					l_bResult = False
					sErrMsg = "Missing column in the VistA site info file " & constSiteInfo
					fnLogEntry sLog, sErrMsg, constError
				Else
					If l_arrField(0) = "Site_Code" And l_arrField(1) = "Site_Name" And l_arrField(2) = "Last_New" And l_arrField(3) = "Last_Updated" Then
						'Save column headers as the first element of the array (this will make it 1-based for data storage)
						Redim arrSites(3, 0)
						arrSites(0, 0) = l_arrField(0)	'Site_Code
						arrSites(1, 0) = l_arrField(1)	'Site_Name
						arrSites(2, 0) = l_arrField(2)	'Last_New
						arrSites(3, 0) = l_arrField(3)	'Last_Updated
						'Read info for each site
						Do While Not l_objSites.AtEndOfStream
							l_sLine = l_objSites.ReadLine() 'Read a new line of file
							If Not Trim(l_sLine) = "" Then
								Redim Preserve arrSites(3, UBound(arrSites, 2) + 1)
								l_arrField = Split(l_sLine, vbTab)
								If UBound(l_arrField) < 3 Then
									l_bResult = False
									sErrMsg = "Missing value for site info on line " & UBound(arrSites, 2) + 1 & " in the VistA site info file " & constSiteInfo
									fnLogEntry sLog, sErrMsg, constError
								Else
									If IsDate(l_arrField(2)) And IsDate(l_arrField(3)) Then
										'Save site info
										arrSites(0, UBound(arrSites, 2)) = l_arrField(0)	'Site_Code
										arrSites(1, UBound(arrSites, 2)) = l_arrField(1)	'Site_Name
										arrSites(2, UBound(arrSites, 2)) = l_arrField(2)	'Last_New
										arrSites(3, UBound(arrSites, 2)) = l_arrField(3)	'Last_Updated
										'Ensure that the site hasn't been listed multiple times
										If l_objDict.Exists(l_arrField(0)) Then
											l_bResult = False
											sErrMsg = "Site " & l_arrField(0) & " is listed multiple times in the VistA site info file " & constSiteInfo
											fnLogEntry sLog, sErrMsg, constError
										Else
											 l_objDict.Add l_arrField(0), l_arrField(0)
										End If
									Else
										l_bResult = False
										sErrMsg = "Invalid record for site " & l_arrField(0) & " in the VistA site info file " & constSiteInfo
										fnLogEntry sLog, sErrMsg, constError
									End If
								End If
							End If
						Loop
					Else
						l_bResult = False
						sErrMsg = "Invalid column name in the header of the record layout definition file " & constRecordLayout
						fnLogEntry sLog, sErrMsg, constError
					End If
				End If
			End If
		Else
			l_bResult = False
			sErrMsg = "VistA site info file " & constSiteInfo & " is not found"
			fnLogEntry sLog, sErrMsg, constError
		End If
	Else
		l_bResult = False
		sErrMsg = sProcName & ": Unable to create a Dictionary object"
		fnLogEntry sLog, sErrMsg, constError
	End If


	fnReadSiteInfo = l_bResult

	'Clean up
	On Error Resume Next
	l_objSites.Close
	Set l_objSites = Nothing
	Set l_objDict = Nothing

End Function

Function fnOutputData(p_sText, p_sTargetFile)
'*********************************************************************
' Purpose	:	Writes specified text to a file
' Parameters:	p_sText			- Text that must be output to a file 
'					p_sTargetFile	- Full path and name of the file where
'								  		specified text will be written out
' Returns:		True on success, false on failure
' Revision History:
' 08/08/11    ZPG	Original creation
'*********************************************************************

	Dim l_bResult
	Dim l_objOutputFile

	sProcName = "fnOutputData"
	
	'Assume failure
	l_bResult = False

	'Create output file
	Err.Clear
	Set l_objOutputFile = objFSO.CreateTextFile(p_sTargetFile, True)	'Overwrite if file already exists
	If Err.Number = 0 Then
		l_objOutputFile.Write p_sText
		l_objOutputFile.Close
		If Err.Number = 0 Then
			l_bResult = True
		End If
	Else
		sErrMsg = sProcName & ": Unable to create file " & p_sTargetFile & " (" & Err.Description & ")"
		fnLogEntry sLog, sErrMsg, constError & " " & Err.Number
	End If

	fnOutputData = l_bResult

	'Clean up
	On Error Resume Next
	l_objOutputFile.Close
	Set l_objOutputFile = Nothing

End Function

Function fnConstructExtractFileName(p_sSiteID, p_sStartDate, p_sEndDate)
'*********************************************************************
' Purpose	:	Constructs a file name for extracted OncoTraX date 
' Parameters:	p_sSiteID		- Site ID from which data was extracted
'					p_sStartDate	- Extract start date
'					p_sEndDate		- Extract end date
' Returns:    	sResult 			- File name corresponding to specified parameters                   
' Revision History:
' 08/08/11    ZPG	Original creation 
'*********************************************************************	

	Dim l_sResult
	Dim l_sName

 	On Error Resume Next
	
	'Assume failure
	l_sResult = ""
	
	'Construct the suffix
	l_sName = Right("000" & p_sSiteID, 4) & "_" & Right(Year(p_sStartDate), 2)
	l_sName = l_sName & Right("0" & Month(p_sStartDate), 2)
	l_sName = l_sName & Right("0" & Day(p_sStartDate), 2)
	l_sName = l_sName & "_" & Right(Year(p_sEndDate), 2)
	l_sName = l_sName & Right("0" & Month(p_sEndDate), 2)
	l_sName = l_sName & Right("0" & Day(p_sEndDate), 2)
	
	'Finish constructing the name if the date part is formed correctly
	If Len(l_sName) = 18 Then 
		l_sResult = l_sName
	End If
	
	fnConstructExtractFileName = l_sResult
	
End Function

Function fnGetAbstracts(p_iSiteID, p_dtStartDate, p_dtEndDate, p_sType)
'*********************************************************************
' Purpose	:	Replacement of actual RPC DLL that retrieves OncoTraX abstracts
'					For testing purposes only  
' Parameters:	p_iSiteID		- Date and time that will be used to construct the file name suffix
'					p_dtStartDate	- Start date for the abstract retrieval		
'					p_dtEndDate		- End date for the abstract retrieval
'					p_sType			- Extract type (New/Updated)		
' Returns:    	sResult 			- Extracted data on success, empty string on failure 
' Revision History:
' 08/08/11    ZPG	Original creation 
'*********************************************************************	

	Dim l_sResult
	Dim l_sFileName
	Dim l_objData

	On Error Resume Next
	
	If p_sType = "New" Then
		l_sFileName = "SaveONCOa"
	Else
		l_sFileName = "SaveONCOb"
	End If
	
   Set l_objData = objFSO.OpenTextFile(l_sFileName, ForReading)
	l_sResult = l_objData.ReadAll
	
	fnGetAbstracts = l_sResult

	'Clean Up
	On Error Resume Next
	l_objData.Close
	Set l_objData = Nothing
	
End Function

Function fnArrToText(p_arrData)
'*********************************************************************
' Purpose	:	Converts 2-dimensional array to Tab-delimited by field 
'					and CrLf-delimited by record text
' Parameters:	p_arrData		- 2-dimensional array
' Returns:    	sResult 			- Tab-delimited by field and CrLf-delimited by record 
'										text on success, empty string on failure 
' Revision History:
' 08/08/11    ZPG	Original creation 
'*********************************************************************	

	Dim l_sResult
	Dim l_iCount
	Dim l_iCount1
	Dim l_sText

	On Error Resume Next
	
	l_sResult = ""
	
	'Scroll through all existing records in current array
	For l_iCount = 0 To UBound(p_arrData, 2)
		l_sText = ""
		'Create a new line by tab-delimiting each field value 
		For l_iCount1 = 0 To UBound(p_arrData, 1)
			l_sText = l_sText & vbTab & p_arrData(l_iCount1, l_iCount)
		Next
		'Remove leading tab and terminate with CrLf
		l_sText = Right(l_sText, Len(l_sText) - 1) & vbCrLf
		'Append new record to the resulting text
		l_sResult = l_sResult & l_sText
	Next
	'Remove trailing CrLf
	l_sResult = Left(l_sResult, Len(l_sResult) - 2) 	
	
   fnArrToText = l_sResult
   
End Function
