Option Explicit

'SCRIPT PARAMETERS
'NOTE: 	This script expects that the parent script also includes GlobalParms.vbs
'		where database parameters are defined
'Const constExchangeServer="DNS"
Const constExchangeServer="DNS        "	'This setting will allow sending e-mails outside VA
Const constServerPort=PORT

Function fnLogEntry(sLogFile, sEntry, sEntryType)
'*********************************************************************
' Purpose	:	Creates an entry in the specified log file
' Parameters:	sLogFile		- The name of the log file. The log will be
'							  						created if it doesn't exist. However, this 
'							  						function will not create nonexistent folders
'							sEntry			- Text that should be logged
'							sEntryType	- Type of log entry that will be used as a 
'							  						error log entry marker, such as ERROR or WARNING
' Returns:		sResult 		- Empty string on success,
'                           |-delimited string containing the error code 
'                           and error description on failure.
' Revision History:
' 06/03/10    ZPG	Original creation 
' 07/22/10		ZPG	1. Restructured code to ensure object cleanup on premature function exits
' 								2. Renamed local object variables to prevent scope clashes
'*********************************************************************
	
	'Constants - working with text files
	Const ForReading = 1
	Const ForWriting = 2
	Const ForAppending = 8
	
	Dim l_objFSO
	Dim l_objLogFile
	Dim sText
	
	On Error Resume Next
	
	Set l_objFSO = CreateObject("Scripting.FileSystemObject") 
	
	Err.Clear
	If l_objFSO.FileExists(sLogFile) Then
		Set l_objLogFile = l_objFSO.OpenTextFile(sLogFile, ForAppending, True)
	Else
		Set l_objLogFile = l_objFSO.CreateTextFile(sLogFile, True)
	End If
	
	If Err.Number = 0 Then
		sText = Date & " " & Time 
		sEntryType=Trim(sEntryType)
		If sEntryType="" Then 
			sText=sText & ": "
		Else
			sText=sText & " [" & sEntryType & "]: "
		End If
		
		l_objLogFile.WriteLine(sText & sEntry)
		If Err.Number = 0 Then
			fnLogEntry = ""
		Else	'Error writing a message to the log
			fnLogEntry = Err.Number & "|" & Err.Description
		End If		
	Else	'Error opening log file
		fnLogEntry = Err.Number & "|" & Err.Description
	End If
	
	'Clean up
	l_objLogFile.Close
	Set l_objLogFile = Nothing
	Set l_objFSO = Nothing
	
End Function

Function fnRaiseAlert(sSendToGroup, sSubject, sMsg, arrAttachments)
'*********************************************************************
' Purpose	:	Sends an e-mail alert 
' Parameters:	sSendToGroup	- ID of a group of alert recipients or groups defined in   
'							  	or an e-mail address of a single recipient 
'				sSubject		- Subject of the e-mail alert
'				sMsg			- Text that should be sent
'				arrAttachments 	- An array of attachment file names 
'								or "" if no attachments.
'								If an attachment cannot be found, it will
'								be listed in the body of the e-mail
' Returns:    	sResult 		- Empty string on success,
'                             	|-delimited string containing the error code 
'                             	and error description on failure.
' Revision History:
' 06/03/10    ZPG	Original creation 
' 07/22/10		ZPG	1. Restructured code to ensure object cleanup on premature function exits
'									2. Renamed local object variables to prevent scope clashes
'									3. Added local ADO constants
'									4. Added escape sequence for text saved in the database to prevent SQL errors
' 07/27/10		ZPG Broke out e-mail function fnSendEmail 
'*********************************************************************	
	
	'Constants - messaging
	Const cdoSendUsingPickup = 1
	Const cdoSendUsingPORT = P
	Const cdoAnonymous = 0 
  
	Dim sEscapeMsg
	Dim l_objConn
	Dim l_objRS
	Dim sSQL
	Dim sDate
	Dim l_objMessage 
	Dim iCount
	Dim sRecipients
	Dim iNumberOfAttachments
	Dim sMissingAttachments
	Dim l_objFSO
	Dim iMissingAttachments
	
	On Error Resume Next
	
	'Replace single and double quotes in the alert text 
	'to prevent SQL errors in database searches for that text
	sEscapeMsg = Replace(sMsg, Chr(34), "`")
	sEscapeMsg = Replace(sEscapeMsg, Chr(39), "`")
	sEscapeMsg = Replace(sEscapeMsg, Chr(124), ":")
	
	'Make sure alert text is not too long
	If Len(sEscapeMsg) > 255 Then
			sEscapeMsg = Left(sEscapeMsg, 250) & "[...]"
	End If 
	
	'Establish DB connection 
	Set l_objConn = CreateObject("ADODB.Connection")
	l_objConn.Open "Provider=" & constDBProvider & "; Data Source=" & constDBName & ";" 
	
	If Err.Number = 0 Then 
		Set l_objRS= CreateObject("ADODB.Recordset")
		
		'Make sure this alert hasn't been sent yet
		sDate=Date
		sDate=Month(sDate) & "/" & Day(sDate) & "/" & Year(sDate) 'Format current date to M/D/YYYY
		sSQL="SELECT * FROM Alerts WHERE "
		sSQL=sSQL & "Feed_Name='" & constFeedName & "' AND "
		sSQL=sSQL & "Alert_Date=#" & sDate & "# AND "
		sSQL=sSQL & "Alert_Text='" & sEscapeMsg & "';"
		Err.Clear
		l_objRS.CursorLocation = adUseClient 
		l_objRS.Open sSQL, l_objConn, adOpenStatic, adLockOptimistic
		If Err.Number = 0 Then 
			If l_objRS.RecordCount=0 Then 
				'Record this alert so it wouldn't be sent again on the same day
				sSQL = "INSERT INTO Alerts (Feed_Name, Alert_Date, Alert_Text, Registered_Timestamp) "  
				sSQL = sSQL & "VALUES ('" & constFeedName & "', #" & sDate & "#, '" & sEscapeMsg & "', #" & Now & "#);"
				l_objConn.Execute sSQL
				l_objRS.Close
				'Send e-mail
				fnRaiseAlert = fnSendEmail(sSendToGroup, sSubject, sMsg, arrAttachments)
			Else	'Don't send identical alerts the same day
				fnRaiseAlert = ""
			End If
		Else	'Error checking existing alerts
			fnRaiseAlert = Err.Number & "|" & "Checking existing alerts: " & Err.Description
		End If
	Else	'DB connection error
		fnRaiseAlert = Err.Number & "|" & "Establishing connection to " & constDBName & ": " & Err.Description 
	End If
	
	'Cleanup
	l_objRS.Close
	Set l_objRS = Nothing
	l_objConn.Close
	Set l_objConn = Nothing
	Set l_objMessage = Nothing
	
End Function

Function fnSendEmail(sSendToGroup, sSubject, sMsg, arrAttachments)
'*********************************************************************
' Purpose	:	Sends an e-mail  
' Parameters:	sSendToGroup	- ID of a group of alert recipients or groups defined in   
'							  	or an e-mail address of a single recipient 
'				sSubject		- Subject of the e-mail alert
'				sMsg			- Text that should be sent
'				arrAttachments 	- An array of attachment file names 
'								or "" if no attachments.
'								If an attachment cannot be found, it will
'								be listed in the body of the e-mail
' Returns:    	sResult 		- Empty string on success,
'                             	|-delimited string containing the error code 
'                             	and error description on failure.
' Revision History:
' 07/27/10    ZPG	Original creation 
'*********************************************************************	
	
	'Constants - messaging
	Const cdoSendUsingPickup = 1
	Const cdoSendUsingPORT = P
	Const cdoAnonymous = 0 
  
	Dim l_objConn
	Dim l_objRS
	Dim sSQL
	Dim l_objMessage 
	Dim iCount
	Dim sRecipients
	Dim iNumberOfAttachments
	Dim sMissingAttachments
	Dim iMissingAttachments
	Dim l_objFSO
	
	On Error Resume Next
	
	'Establish DB connection 
	Set l_objConn = CreateObject("ADODB.Connection")
	l_objConn.Open "Provider=" & constDBProvider & "; Data Source=" & constDBName & ";" 
	Set l_objRS= CreateObject("ADODB.Recordset")
	If Err.Number = 0 Then 		
		'Get the list of recipients
		Err.Clear
		sSQL="SELECT * FROM EMail_Group_Membership WHERE Group_ID='" & sSendToGroup & "';"
		l_objRS.Open sSQL, l_objConn, adOpenStatic, adLockOptimistic
		If Err.Number = 0 Then 
			If l_objRS.RecordCount > 0 Then
				l_objRS.MoveFirst
				Do While Not l_objRS.EOF 
					sRecipients = sRecipients & "; " & l_objRS("User_EMail")
					l_objRS.MoveNext
				Loop
				sRecipients = Right(sRecipients, Len(sRecipients)-2)
							
				'Create a Message object
				Set l_objMessage = CreateObject("CDO.Message") 
				
				l_objMessage.Subject = sSubject
				l_objMessage.From = constSender  
				l_objMessage.To = sRecipients 
				
				'Add attachments
				If Not arrAttachments = "" And IsArray(arrAttachments) Then
					Set l_objFSO = CreateObject("Scripting.FileSystemObject") 
					iNumberOfAttachments=UBound(arrAttachments)
					For iCount = 0 To iNumberOfAttachments
						If l_objFSO.FileExists(arrAttachments(iCount)) Then
							Err. Clear
							l_objMessage.AddAttachment arrAttachments(iCount)
						Else
							iMissingAttachments = iMissingAttachments + 1
							sMissingAttachments = sMissingAttachments & vbLFCR & arrAttachments(iCount)
						End If
					Next
					
					If iMissingAttachments > 0 Then 
						If iMissingAttachments > 1 Then
							sMissingAttachments = vbLFCR & vbLFCR & "The following files were not attached because they were not found in the specified location:" & sMissingAttachments
						Else
							sMissingAttachments = vbLFCR & vbLFCR & "The following file was not attached because it was not found in the specified location:" & sMissingAttachments
						End If
						sMsg = sMsg & sMissingAttachments
					End If
				End If
				
				l_objMessage.TextBody = sMsg 
						
				'Set configuration
				l_objMessage.Configuration.Fields("http://schemas.microsoft.com/cdo/configuration/sendusing") = cdoSendUsingPort 
				l_objMessage.Configuration.Fields("http://schemas.microsoft.com/cdo/configuration/smtpserver") = constExchangeServer 
				l_objMessage.Configuration.Fields("http://schemas.microsoft.com/cdo/configuration/smtpserverport") = constServerPort 
				l_objMessage.Configuration.Fields("http://schemas.microsoft.com/cdo/configuration/smtpauthenticate") = cdoAnonymous 
				l_objMessage.Configuration.Fields.Update 
			
				l_objMessage.Send 
				If Err.Number = 0 Then 						
					fnSendEmail = ""
				Else
					fnSendEmail = Err.Number & "|" & "Sending the e-mail: " & Err.Description
				End If
			Else 'Group of alert recipients has no associated members
				fnSendEmail = "0" & "|" & "Group " & sSendToGroup & " has no associated members."
			End If
		Else	'Error getting the list of recipients
			fnSendEmail = Err.Number & "|" & "Retrieving the list of recipients: " & Err.Description
		End If
	Else	'DB connection error
		fnSendEmail = Err.Number & "|" & "Establishing connection to " & constDBName & ": " & Err.Description 
	End If
	
	'Cleanup
	l_objRS.Close
	Set l_objRS = Nothing
	l_objConn.Close
	Set l_objConn = Nothing
	Set l_objMessage = Nothing
	Set l_objFSO = Nothing
	
End Function