Option Explicit

'SCHEDULING: This script should be run once a day

'Script parameters
Const constFeedName = "File Concatenation"
Const constProcessingFolder = ".\Processing\"		'IMPORTANT: Include trailing backslash

'Environment-specific feed processing parameters are defined immediately after processing INCLUDES

Dim objFSO
Dim objFile
Dim objOutput
Dim colFiles
Dim arrIncludes
Dim iCount
Dim sText
Dim sLog
Dim sErrMsg
Dim arrFolders
Dim sRet
Dim bContinue
Dim sTargetFolder
Dim sKeepOriginalFiles
Dim sOrigFolder
Dim sDateTime
Dim sOutputFN
Dim objText
Dim bFailure

ReDim arrIncludes(2)
arrIncludes(0) = "GlobalParms.vbs" 'This file must be included first
arrIncludes(1) = "Logger.vbs"
arrIncludes(2) = "GeneralFunctions.vbs"

For iCount = 0 To UBound(arrIncludes)
	sText = fnIncludeScript(arrIncludes(iCount))
	If Not sText = "" Then
		wscript.Echo "Unable to include script " & arrIncludes(iCount) & " (Err " & Split(sText, "|")(0) & "): " & Split(sText, "|")(1)
		wscript.Quit
	End If
Next

Select Case constEnvironment
	Case "DEVL"
		ExecuteGlobal Replace("Const constFileTargetLocation=#.\Ready_For_Upload\#", "#", Chr(34))	'IMPORTANT: Include trailing backslash
	Case "TEST"
		ExecuteGlobal Replace("Const constFileTargetLocation=#.\Ready_For_Upload\#", "#", Chr(34))	'IMPORTANT: Include trailing backslash
	Case "PROD"
		ExecuteGlobal Replace("Const constFileTargetLocation=#.\Ready_For_Upload\#", "#", Chr(34))	'IMPORTANT: Include trailing backslash
	Case Else
		MsgBox "Unrecognized environment <" & constEnvironment & ">!"
		wscript.Quit
End Select

On Error Resume Next

bContinue = True

'Prompt for parameters
	'Target Folder
sTargetFolder = Trim(InputBox("Location of files:", constFeedName, constFileTargetLocation))
If sTargetFolder = "" Then wscript.Quit
If Not Right(sTargetFolder, 1) = "\" Then sTargetFolder = sTargetFolder & "\"
	'Indicator of whether to keep original files after concatenation
Do While Not (sKeepOriginalFiles = "Y" or sKeepOriginalFiles = "N")
	sKeepOriginalFiles = UCase(Trim(InputBox("Save original files? Y/N", constFeedName, "Y")))
	If sKeepOriginalFiles = "" Then 
		wscript.Quit
	ElseIf Not (sKeepOriginalFiles = "Y" or sKeepOriginalFiles = "N") Then
		MsgBox "Please enter either Y or N to continue. Leave textbox blank to quit."
	End If
Loop

'Construct error log file name
sLog = constLogFolder & fnConstructLogName(constFeedName, Date)

'Establish required global objects
Set objFSO = CreateObject("Scripting.FileSystemObject")

'Construct date/time label
 sDateTime = fnConstructFNPrefix(Now)
 
'Establish required folders
If sKeepOriginalFiles = "Y" Then
	'Construct folder path for the location where original files will be moved
	sOrigFolder = sTargetFolder & sDateTime
	
	ReDim arrFolders(1)
	arrFolders(1) = sOrigFolder
Else
	ReDim arrFolders(0)
End If
arrFolders(0) = constProcessingFolder
For iCount = 0 To UBound(arrFolders)
	sRet = fnEstablishPath(arrFolders(iCount))
	If Not sRet = "" Then
		sErrMsg = Split(sRet, "|")(1)
		fnLogEntry sLog, sErrMsg, constError & " " & Split(sRet, "|")(0)
		bContinue = False
		bFailure = True
		Exit For
	End If
Next

If bContinue Then
	'Process each file in the target folder
	Err.Clear
	Set colFiles = objFSO.GetFolder(sTargetFolder).Files
	If Err.Number = 0 Then
		If colFiles.Count > 0 Then
			'Construct output file name
			sOutputFN = constProcessingFolder & sDateTime & ".txt"
			Err.Clear
			Set objOutput = objFSO.CreateTextFile(sOutputFN, True)	'Overwrite if file already exists (should never happen)
			If Err.Number = 0 Then
				For Each objFile In colFiles
					Set objText = objFSO.OpenTextFile(objFile.Path, ForReading)
					If Err.Number = 0 Then
						If Not objText.AtEndOfStream Then
							objOutput.Write objText.ReadAll
							If Err.Number = 0 Then
								objText.Close
								If sKeepOriginalFiles = "Y" Then
									'Move the file from the target folder
									sRet = fnMoveFile(objFile, sOrigFolder, constFileMoveDelay)
									If Not sRet = "" Then
										sErrMsg = "Unable to move processed file " & objFile.Path & " to " 
										sErrMsg = sErrMsg & sOrigFolder & " folder (" & Split(sRet, "|")(1) & ")"
										fnLogEntry sLog, sErrMsg, constError & " " & Split(sRet, "|")(0)
										bFailure = True
									End If
								Else
									objFile.Delete
									If Not Err.Number = 0 Then
										sErrMsg = "Unable to delete processed file " & objFile.Path & " (" & Err.Description & ")"
										fnLogEntry sLog, sErrMsg, constError & " " & Err.Number
										Err.Clear
										bFailure = True
									End If
								End If
							Else
								sErrMsg = "Unable to append file " & objFile.Path & " to " & sOutputFN & " (" & Err.Description & ")"
								fnLogEntry sLog, sErrMsg, constError & " " & Err.Number
								Err.Clear
								bFailure = True
							End If
						End If
					Else
						sErrMsg = "Unable to open file " & objFile.Path & " for reading (" & Err.Description & ")"
						fnLogEntry sLog, sErrMsg, constError & " " & Err.Number
						Err.Clear
						bFailure = True
					End If
				Next
				'Move concatenated file to the target folder
				objOutput.Close
				sRet = fnMoveFile(sOutputFN, sTargetFolder, constFileMoveDelay)
				If Not sRet = "" Then
					sErrMsg = "Unable to move concatenated file " & sOutputFN & " to " 
					sErrMsg = sErrMsg & sTargetFolder & " folder (" & Split(sRet, "|")(1) & ")"
					fnLogEntry sLog, sErrMsg, constError & " " & Split(sRet, "|")(0)
					bFailure = True
				End If
			Else
				sErrMsg = "Unable to create output file " & sOutputFN & " (" & Err.Description & ")"
				fnLogEntry sLog, sErrMsg, constError & " " & Err.Number
				bFailure = True
			End If
		End If
	Else
		sErrMsg = "Unable to retrieve collection of files in " & constFileSourceLocation & " folder (" & Err.Description & ")"
		fnLogEntry sLog, sErrMsg, constError & " " & Err.Number
	End If
End If

'Report status
If bFailure = True Then
	MsgBox "Please review error log " & sLog
Else
	MsgBox "Done: " & sTargetFolder & sDateTime & ".txt"
End If

'Clean up

On Error Resume Next

objOutput.Close
Set objOutput = Nothing
Set objText = Nothing
Set colFiles = Nothing
Set objFile = Nothing
Set objFSO = Nothing

Function fnIncludeScript(strScriptFile)
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
''    Author:     ebgreen (http://www.visualbasicscript.com/m29285.aspx)
''    Purpose:    Implements Include functionality
''    Takes:      strScriptFile - The name of the file containing the script
''                    			  to import. Must be a valid path.
''	  Returns:    sResult 	- Empty string on success,
'                             |-delimited string containing the error code
'                             and error description on failure.
''    Revision History:
''        06/03/10    ZG	Modified error handling
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

	Dim objFSO
	Dim objFile
	Dim strFile

	On Error Resume Next

	Set objFSO = CreateObject ("Scripting.FileSystemObject")

	'Check to see if the INCLUDE file exists. If it does not, return an error
	If objFSO.FileExists(strScriptFile) Then
		'Open the file to be loaded. If the open fails, return an error.
		Err.Clear
		Set objFile = objFSO.OpenTextFile(strScriptFile)
		If Err.Number = 0 Then
			'The file object is created so read all of the file and ececute it globally to load the class for use
			strFile = objFile.ReadAll
			ExecuteGlobal strFile
			If Err.Number = 0 Then
				fnIncludeScript = ""
			Else
				fnIncludeScript = Err.Number & "|" & "The specified INCLUDE file " & strScriptFile & " could not be loaded: " & Err.Description
			End If
		Else
			fnIncludeScript = Err.Number & "|" & "The specified INCLUDE file " & strScriptFile & " could not be opened for reading: " & Err.Description
		End If
	Else
		fnIncludeScript = "53" & "|" & "The specified INCLUDE file " & strScriptFile & " does not exist"
	End If

	objFile.Close
	Set objFile = Nothing
	Set objFSO = Nothing

End Function

Function fnConstructFNPrefix(p_sDateTime)
'*********************************************************************
' Purpose	:	Constructs a file name prefix for the specified date/time 
' Parameters:	p_sDateTime	- Date and time that will be used to construct the file name suffix
' Returns:    	sResult 		- File name suffix for the specified date/time
'							  		on success, empty string on failure
' Revision History:
' 08/02/11    ZPG	Original creation 
'*********************************************************************	

	Dim l_sResult
	Dim l_sName

	On Error Resume Next
	
	'Assume failure
	l_sResult = ""
	
	'Construct the suffix
	l_sName = Right(Year(p_sDateTime), 2)
	l_sName = l_sName & Right("0" & Month(p_sDateTime), 2)
	l_sName = l_sName & Right("0" & Day(p_sDateTime), 2)
	l_sName = l_sName & Right("0" & Hour(p_sDateTime), 2)
	l_sName = l_sName & Right("0" & Minute(p_sDateTime), 2)
	l_sName = l_sName & Right("0" & Second(p_sDateTime), 2)
	
	'Finish constructing the name if the date part is formed correctly
	If Len(l_sName) = 12 Then 
		l_sResult = l_sName
	End If
	
	fnConstructFNPrefix = l_sResult
	
End Function
