using System;
using Spring.Context;
using Spring.Context.Support;
using System.Collections.Specialized;
using System.Configuration;
using gov.va.medora.mdo;
using gov.va.medora.mdo.api;
using gov.va.medora.mdo.dao;
using gov.va.medora.mdws.dto;
using Common.Logging;
using System.Xml;
using System.Reflection;
using System.IO;
using System.Web;

namespace GetOncology
{
    [Serializable]
    public class MySession
    {
        // set by me
        string facadeName;
        SiteTable siteTable;
        string appPwd;
        string appStatus;
        string sitesFileName;
        bool validVisitorSSN;
        string zipCodeDbPath;
        string geographicalDbPath;
        string resourcesPath;

        // set outside class
        public ConnectionManager cxnMgr;
        public User user;
        public Patient patient;
        public ILog log;

        // depreciated
        public MultiSourceQuery msq;
        public Connection cxn;
        public Connection visitCxn;

        public MySession()
        {
            IApplicationContext ctx = ContextRegistry.GetContext();
            siteTable = (SiteTable)ctx.GetObject(MdwsConstants.SITE_TABLE);
            //myProperties = (MyProperties)ctx.GetObject(MdwsConstants.RUNTIME_PROPERTIES);
        }


 
        public string FacadeName
        {
            get { return facadeName; }
        }

        public SiteTable SiteTable
        {
            get { return siteTable; }
        }

        public string AppPwd
        {
            get { return appPwd; }
        }

        public string AppStatus
        {
            get { return appStatus; }
        }

        public string SitesFileName
        {
            get { return sitesFileName; }
        }

        public bool ValidVisitorSSN
        {
            get { return validVisitorSSN; }
        }

        public string ZipCodeDbPath
        {
            get { return zipCodeDbPath; }
        }

        public string GeographicalDbPath
        {
            get { return geographicalDbPath; }
        }

        public string ResourcesPath
        {
            get { return resourcesPath; }
        }

        public Object execute(string className, string methodName, object[] args)
        {
            bool isLog = this.log != null;

            string userIdStr = "";
            if (user != null)
            {
                userIdStr = user.LogonSiteId.Key + '/' + user.LogonSiteUid + ": ";
            }
            string fullClassName = className;
            if (!fullClassName.StartsWith("gov."))
            {
                fullClassName = "gov.va.medora.mdws." + fullClassName;
            }
            Object theLib = Activator.CreateInstance(Type.GetType(fullClassName), new object[] { this });
            Type theClass = theLib.GetType();
            Type[] theParamTypes = new Type[args.Length];
            for (int i = 0; i < args.Length; i++)
            {
                theParamTypes[i] = args[i].GetType();
            }
            MethodInfo theMethod = theClass.GetMethod(methodName, theParamTypes);
            string logArgs = "";
            string logMsg = "";
            for (int i = 0; i < args.Length; i++)
            {
                // Ugly kludge to avoid writing some stuff to log file.  Need some way to automate this.
                if (theMethod.Name == "login")
                {
                    ;
                }
                else if (theMethod.Name == "writeNote" && i == 2)
                {
                    logArgs += "\"[Note text]\",";
                }
                else
                {
                    logArgs += "\"" + args[i].ToString() + "\",";
                }
            }
            if (isLog)
            {
                if (logArgs != "")
                {
                    logArgs = logArgs.Substring(0, logArgs.Length - 1);
                }
                if (userIdStr != "")
                {
                    logMsg = userIdStr;
                }
                logMsg += className + '.' + methodName + '(' + logArgs + ')';
                this.log.Info(logMsg);
                logMsg = "";
            }
            Object result = null;
            if (theMethod == null)
            {
                result = new Exception("Method " + logMsg + " does not exist.");
            }
            try
            {
                result = theMethod.Invoke(theLib, BindingFlags.InvokeMethod, null, args, null);
            }
            catch (Exception e)
            {
                if (e.GetType().IsAssignableFrom(typeof(System.Reflection.TargetInvocationException)) &&
                    e.InnerException != null)
                {
                    result = e.InnerException;
                }
                else
                {
                    result = e;
                }
                if (isLog)
                {
                    if (userIdStr != "")
                    {
                        logMsg = userIdStr + ": ";
                    }
                    logMsg += e.Message + "\r\n" + e.StackTrace;
                    this.log.Error(logMsg);
                    logMsg = "";
                }
                return result;
            }
            if (isLog && result.GetType().IsAssignableFrom(typeof(AbstractTO)))
            {
                AbstractTO dto = (AbstractTO)result;
                if (userIdStr != "")
                {
                    logMsg = userIdStr;
                }
                if (dto.fault != null)
                {
                    logMsg += dto.fault.message;
                    if (dto.fault.stackTrace != "")
                    {
                        logMsg += "\r\n" + dto.fault.stackTrace;
                    }
                    this.log.Error(logMsg);
                }
                else
                {
                    this.log.Info(logMsg + "OK");
                }
            }
            return result;
        }

        void watchSitesFile(string path)
        {
            FileSystemWatcher watcher = new FileSystemWatcher(path);
            watcher.Filter = (sitesFileName + ".xml");
            watcher.NotifyFilter = NotifyFilters.LastAccess | NotifyFilters.LastWrite | NotifyFilters.CreationTime
                | NotifyFilters.DirectoryName | NotifyFilters.FileName | NotifyFilters.Size;
            watcher.EnableRaisingEvents = true;
            watcher.Changed += new FileSystemEventHandler(watcher_Changed);
            watcher.Deleted += new FileSystemEventHandler(watcher_Changed);
            watcher.Created += new FileSystemEventHandler(watcher_Changed);
        }

        void watcher_Changed(object sender, FileSystemEventArgs e)
        {
            siteTable = new SiteTable(resourcesPath + "xml\\" + sitesFileName + ".xml");
        }

    }
}
