#ifndef CSTAGE_H
#define CSTAGE_H

#include "collab.h"


#ifdef __cplusplus
extern "C" {
#endif

#ifdef WIN32
    #ifdef CSTAGE_EXPORTS
    #define CSTAGE_API  __declspec(dllexport)
    #else
    #define CSTAGE_API  __declspec(dllimport)
    #endif
#else
    #define CSTAGE_API
    #define _stdcall
#endif

	void initialize_versioninfo();

CSTAGE_API int CStage_calculate( datacard *dc );
CSTAGE_API int CStage_move_naaccr_to_datacard( datacard *dc, const char *naaccr_buffer );
CSTAGE_API int CStage_move_datacard_to_naaccr( char *naaccr_buffer, const datacard *dc );
CSTAGE_API int CStage_clear_datacard( datacard *dc );
CSTAGE_API int CStage_get_schema_number( const char *site, const char *hist,
														  const char *discriminator);
CSTAGE_API int CStage_get_number_of_schemas( void );
CSTAGE_API const char *CStage_get_schema_name( const int schema_number );
CSTAGE_API const char *CStage_get_schema_title(const int schema_number);
CSTAGE_API const char *CStage_get_schema_subtitle(const int schema_number);
CSTAGE_API const char *CStage_get_schema_sitesummary(const int schema_number);
CSTAGE_API const char *CStage_get_schema_revision_date(const int schema_number);
CSTAGE_API int CStage_get_number_schema_notes(const int schema_number);
CSTAGE_API const char *CStage_get_schema_note(const int schema_number, const int note_number);
CSTAGE_API int CStage_get_number_of_tables( const int schema_number );
CSTAGE_API const char *CStage_get_table_pattern( const int schema_number, const int table_number );
CSTAGE_API int CStage_get_number_of_rows( const int schema_number, const int table_number );
CSTAGE_API const char *CStage_get_description_string( const int schema_number, const int table_number,
												const int row_number );
CSTAGE_API const char *CStage_get_code_string( const int schema_number, const int table_number,
											const int row_number, const int code_cell_number );
CSTAGE_API int CStage_code_is_valid( const int schema_number, const int table_number,
										const int code_cell_number, const char *code );
CSTAGE_API int CStage_validate_inputs(const int schema_number, datacard *dc,
														unsigned long* input_flags, unsigned long* ssf_flags);
CSTAGE_API const char *CStage_get_timestamp( void );
CSTAGE_API const char *CStage_get_version( void );
CSTAGE_API int   CStage_get_number_table_notes( const int schema_number, const int table_number );
CSTAGE_API const char *CStage_get_table_note( const int schema_number, const int table_number,
											const int note_number );
CSTAGE_API int   CStage_get_number_table_footnotes( const int schema_number, const int table_number );
CSTAGE_API const char *CStage_get_table_footnote( const int schema_number, const int table_number,
												const int footnote_number );
CSTAGE_API const char *CStage_get_display_code( const int list, const char *storage_code );
CSTAGE_API const char *CStage_get_table_title( const int schema_number, const int table_number );
CSTAGE_API const char *CStage_get_table_subtitle( const int schema_number, const int table_number );
CSTAGE_API const char *CStage_get_code_col_header( const int schema_number, const int table_number,
												const int code_col_number );
CSTAGE_API const char *CStage_get_descrip_col_header( const int schema_number, const int table_number );
CSTAGE_API const char *CStage_get_table_revision_date(const int schema_number, const int table_number);

CSTAGE_API void CStage_initialize(void);
CSTAGE_API void CStage_uninitialize(void);
CSTAGE_API int EditsInterface(char* func_name, long parm1, long parm2, long parm3, long parm4, long parm5);
CSTAGE_API int CStage_get_table_usage(const int schema_number, const int table_number);
CSTAGE_API int CStage_get_table_currency(const int schema_number, const int table_number);
CSTAGE_API int CStage_get_table_role(const int schema_number, const int table_number);
CSTAGE_API const char *CStage_get_table_id(const int schema_number, const int table_number);

#ifdef __cplusplus
}
#endif

#endif
