#pragma once

enum TableNum { SIZ = 1, EXT, EXTEVAL, NODES, LNEVAL, LNPOS, LNEXAM,
             METS, METSEVAL, SSF1, SSF2, SSF3, SSF4, SSF5, SSF6, 
			 SSF7, SSF8, SSF9, SSF10, SSF11, SSF12, SSF13, SSF14, SSF15,
			 SSF16, SSF17, SSF18, SSF19, SSF20, SSF21, SSF22, SSF23, SSF24, SSF25,
			 HIST7, HIST, AJCC7, AJCC, SEERSUM,
			 EXTRA1, EXTRA2, EXTRA3, EXTRA4, EXTRA5, EXTRA6, EXTRA7, EXTRA8, 
			 EXTRA9, EXTRA10, EXTRA11, EXTRA12, EXTRA13, EXTRA14, EXTRA15,
			 EXTRA16, EXTRA17, EXTRA18, EXTRA19, EXTRA20 };


/* error codes */
#define AOK        	0
#define NONFAILMSG	1

/* error codes relating to AJCC Staging */
#define EXTAJCCFAIL     (1<<1)
#define NODESAJCCFAIL   (1<<2)
#define METSAJCCFAIL    (1<<3)

#define EXTEVALFAIL     (1<<4)
#define NODESEVALFAIL   (1<<5)
#define METSEVALFAIL    (1<<6)

#define STAGEAJCCFAIL   (1<<7)

#define TNMAJCCFAIL     (EXTAJCCFAIL | NODESAJCCFAIL | METSAJCCFAIL )

#define AJCCFAIL        (TNMAJCCFAIL | STAGEAJCCFAIL)

#define EVALSFAIL       (EXTEVALFAIL | NODESEVALFAIL | METSEVALFAIL)

#define TNMorEVALSFAIL  (AJCCFAIL | EVALSFAIL)

/* error codes relating to SEER Summary Stage 77 */
#define EXT77FAIL       (1<<8)
#define NODES77FAIL     (1<<9)
#define METS77FAIL      (1<<10)

#define STAGE77FAIL     (1<<11)

#define TNM77FAIL       (EXT77FAIL | NODES77FAIL | METS77FAIL)

#define SEER77FAIL      (TNM77FAIL | STAGE77FAIL)

/* error codes relating to SEER Summary Stage 2000 */
#define EXT2000FAIL     (1<<12)
#define NODES2000FAIL   (1<<13)
#define METS2000FAIL    (1<<14)

#define STAGE2000FAIL   (1<<15)

#define TNM2000FAIL     (EXT2000FAIL | NODES2000FAIL | METS2000FAIL)

#define SEER2000FAIL    (TNM2000FAIL | STAGE2000FAIL)

#define CSTAGEFAIL      (TNMorEVALSFAIL | TNM7orEVALS7FAIL | SEER77FAIL | SEER2000FAIL)

/* other error codes */
#define TorEFAIL        (EXTAJCCFAIL | EXTEVALFAIL)
#define NorEFAIL        (NODESAJCCFAIL | NODESEVALFAIL)
#define MorEFAIL        (METSAJCCFAIL | METSEVALFAIL)

#define SITEFAIL            (1<<16)
#define HISTFAIL            (1<<17)
#define DISCRIMINATORFAIL   (1<<18)		// Invalid schema discriminator
#define VERSIONFAIL         (1<<19)		// Invalid Year of diagnosis or CS Version Original

#define SITEorHISTFAIL      (SITEFAIL | HISTFAIL)
// Schema selection failed
#define SCHEMASELECTIONFAIL (SITEorHISTFAIL | DISCRIMINATORFAIL)

// New error flags for AJCC 7th edition
#define EXTAJCC7FAIL        (1<<20)
#define NODESAJCC7FAIL      (1<<21)
#define METSAJCC7FAIL       (1<<22)

#define EXTEVALAJCC7FAIL    (1<<23)
#define NODESEVALAJCC7FAIL  (1<<24)
#define METSEVALAJCC7FAIL   (1<<25)

#define STAGEAJCC7FAIL      (1<<26)

// New support error flags for AJCC 7th edition
#define TNMAJCC7FAIL        (EXTAJCC7FAIL | NODESAJCC7FAIL | METSAJCC7FAIL)
#define AJCC7FAIL           (TNMAJCC7FAIL | STAGEAJCC7FAIL)
#define EVALS7FAIL          (EXTEVALAJCC7FAIL | NODESEVALAJCC7FAIL | METSEVALAJCC7FAIL)
#define TNM7orEVALS7FAIL    (AJCC7FAIL | EVALS7FAIL)



// These constants can be used to evaluate the results of CStage_validate_inputs()
#define INPUT_BEHAVIOR          (1<<1)
#define INPUT_GRADE             (1<<2)
#define INPUT_AGE               (1<<3)

#define INPUT_LYMPH_VASCULAR    (1<<5)
#define INPUT_SIZE              (1<<6)
#define INPUT_EXTENSION         (1<<7)
#define INPUT_SIZE_EXT_EVAL     (1<<8)
#define INPUT_NODES             (1<<9)
#define INPUT_NODES_EVAL        (1<<10)
#define INPUT_NODES_POSITIVE    (1<<11)
#define INPUT_NODES_EXAMINED    (1<<12)
#define INPUT_METS              (1<<13)
#define INPUT_METS_EVAL         (1<<14)


#define INPUT_SSF1              (1<<1)
#define INPUT_SSF2              (1<<2)
#define INPUT_SSF3              (1<<3)
#define INPUT_SSF4              (1<<4)
#define INPUT_SSF5              (1<<5)
#define INPUT_SSF6              (1<<6)
#define INPUT_SSF7              (1<<7)
#define INPUT_SSF8              (1<<8)
#define INPUT_SSF9              (1<<9)
#define INPUT_SSF10             (1<<10)
#define INPUT_SSF11             (1<<11)
#define INPUT_SSF12             (1<<12)
#define INPUT_SSF13             (1<<13)
#define INPUT_SSF14             (1<<14)
#define INPUT_SSF15             (1<<15)
#define INPUT_SSF16             (1<<16)
#define INPUT_SSF17             (1<<17)
#define INPUT_SSF18             (1<<18)
#define INPUT_SSF19             (1<<19)
#define INPUT_SSF20             (1<<20)
#define INPUT_SSF21             (1<<21)
#define INPUT_SSF22             (1<<22)
#define INPUT_SSF23             (1<<23)
#define INPUT_SSF24             (1<<24)
#define INPUT_SSF25             (1<<25)



// General error codes
#define CSTAGE_ERROR -1
#define SYSTEM_ERROR -999
#define SYSTEM_SUCCESS 0

// Number of tables defined for every schema
#define N_STANDARD_TABLES	39

// Max message length
#define MAX_MSG_LENGTH 3000


// Constants for table usage
#define TB_USAGE_ACTIVE         0	// Used in calculation of stage
#define TB_USAGE_DRONE          1	// Not used in calculation of stage
#define TB_USAGE_UNDEFINED      2	// Undefined
#define TB_USAGE_DISCRIMINATOR  3	// Schema discriminator

// Constants for table currency
#define TB_CURRENCY_CURRENT     0	// Current
#define TB_CURRENCY_FUTURE      1	// Will be defined in a future release
#define TB_CURRENCY_OBSOLETE    2	// Obsolete

// Constants for table role
#define TB_ROLE_INPUT           0	// CS input table
#define TB_ROLE_HISTOINC        1	// Histology inclusion table
#define TB_ROLE_HISTOEXC        2	// Histology exclusion table
#define TB_ROLE_STAGE           3	// Stage table
#define TB_ROLE_EXTRA           4	// Extra table for intermediate calculation


typedef struct {  /* inputs */
                  char hist[ 4 ];
                  char site[ 5 ];	
                  char diagnosis_year[4];
                  char csver_original[6];
                  char behav;
                  char grade;
                  char age[3];
                  char lvi;
                  char size[3];
                  char ext[3];
                  char exteval;
                  char nodes[3];
                  char nodeseval;
                  char lnpos[2];
                  char lnexam[2];
                  char mets[2];
                  char metseval;
                  char ssf1[3];
                  char ssf2[3];
                  char ssf3[3];
                  char ssf4[3];
                  char ssf5[3];
                  char ssf6[3];
                  char ssf7[3];
                  char ssf8[3];
                  char ssf9[3];
                  char ssf10[3];
                  char ssf11[3];
                  char ssf12[3];
                  char ssf13[3];
                  char ssf14[3];
                  char ssf15[3];
                  char ssf16[3];
                  char ssf17[3];
                  char ssf18[3];
                  char ssf19[3];
                  char ssf20[3];
                  char ssf21[3];
                  char ssf22[3];
                  char ssf23[3];
                  char ssf24[3];
                  char ssf25[3];

                  /* display outputs */
                  char t[12];
                  char tdescr[4];
                  char n[12];
                  char ndescr[4];
                  char m[12];
                  char mdescr[4];
                  char ajcc[12];

                  char ajcc7_t[12];
                  char ajcc7_tdescr[4];
                  char ajcc7_n[12];
                  char ajcc7_ndescr[4];
                  char ajcc7_m[12];
                  char ajcc7_mdescr[4];
                  char ajcc7_stage[12];

                  char t77[8];
                  char n77[8];
                  char m77[8];
                  char ss77[8];
                  char t2000[8];
                  char n2000[8];
                  char m2000[8];
                  char ss2000[8];
                  /* storage outputs */
                  char stor_t[3];
                  char stor_tdescr[3];
                  char stor_n[3];
                  char stor_ndescr[3];
                  char stor_m[3];
                  char stor_mdescr[3];
                  char stor_ajcc[3];

                  char stor_ajcc7_t[4];
                  char stor_ajcc7_tdescr[3];
                  char stor_ajcc7_n[4];
                  char stor_ajcc7_ndescr[3];
                  char stor_ajcc7_m[4];
                  char stor_ajcc7_mdescr[3];
                  char stor_ajcc7_stage[4];

                  char stor_ss77[3];
                  char stor_ss2000[3];
                  /* error messages */
                  unsigned long error;
                  char messages[3000];
                } datacard;
