/*******************************************************************************/
/*  Package:      ONC  Oncology                                               */
/*  Date Created: Jul 26,2004                                                  */
/*  Site Name:    Hines OIFO                                                   */
/*  Developers:   Sergey Gavrilov PII                     )                    */
/*  Description:  This unit contains main entry point of the Oncology web-     */
/*                service (CGI application).                                   */
/*******************************************************************************/
#include "stdafx.h"
#include "OncologyCGI.h"

int GlobalInputDataHasError;
char* GlobalOutputFileName;
//***** CHECKS CGI ENVIRONMENT VARIABLES

void checkEnvironment(
	int *clength)	// Content Length in bytes is returned via this parameter (-1 if not sent by client)
{
	*clength = -1;


	#ifndef _DEBUG
		//--- Request Type
		char *request_method = getenv("REQUEST_METHOD");
		if( request_method == NULL )
			throw TONCFault(EC_UNKNOWN_METHOD);
		if( _strcmpi(request_method, "POST") )
			throw TONCFault(EC_UNSUP_METHOD, request_method);

		//--- Content Type
		char *content_type = getenv("CONTENT_TYPE");
		if( content_type == NULL )
			throw TONCFault(EC_UNKNOWN_CONTENT);
		if( _strcmpi(content_type, "text/xml") )
			throw TONCFault(EC_UNSUP_CONTENT, content_type);

		//--- Content Length
		char *content_length = getenv("CONTENT_LENGTH");
		if( content_length != NULL )
			*clength = atoi(content_length);
	#endif
}




//***** MAIN ENTRY POINT

int __cdecl main()
{
	FILE *stream = NULL;
	bool hasError = false;
	GlobalInputDataHasError = 0;
	TONCParser Parser;
	char* debugFile;

	#ifdef _DEBUG
		//--- Uncomment the following line to perform unit tests.
		//return UnitTests();
		//--- Debug version reads the request from a file.
		freopen_s(&stream, "c:\\temp\\req.txt", "r", stdin);
		//Sleep(30);
	#endif


	//--- HTTP Headers
	puts("Cache-Control: no-store");
	puts("Content-Type: text/xml\n");

	//--- SOAP Header
	puts("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
	printf("<soap:Envelope xmlns:soap=\"http://www.w3.org/2001/12/soap-envelope\"");
	puts(" soap:encodingStyle=\"http://www.w3.org/2001/12/soap-encoding\">");
	puts("<soap:Body>");

	try
	{

		int content_length;

		//--- Check CGI environment variables
		checkEnvironment(&content_length);

		//--- Disable <CR><LF> translation for standard input
		_setmode(_fileno(stdin), _O_BINARY);

		debugFile = Parser.GetDubugFileName();
		
		//--- Parse request parameters and create request descriptor
		TONCRequest *Request = Parser.parseParameters(content_length, debugFile);

		//--- Process the request
		if( Request != NULL )
		{
			try
			{
				Request->executeRequest();
				Request->processErrors();
			}
			catch(...)
			{
				delete Request;
				throw;
				hasError = true;
			}
			delete Request;
		} 
		else
		{
			throw TONCFault(EC_INVALID_REQUEST);
			hasError = true;
		}
	}
	//--- Process exceptions explicitly generated by the Oncology code
	catch(TONCFault Fault)
	{
		Fault.output();
		hasError = true;
	}
	//--- Process all other (unexpected) exceptions
	catch(...)
	{
		TONCFault Fault(EC_SERVER_EXCEPTION);
		Fault.output();
		hasError = true;
	}

	//--- SOAP Trailer
	puts("</soap:Body>");
	puts("</soap:Envelope>");

	#ifdef _DEBUG
		//--- Debug version checks for memory leaks
		_CrtDumpMemoryLeaks();
	#endif

	// Delete the output file if there is error
	if ((hasError || GlobalInputDataHasError > 0) && GlobalOutputFileName != NULL)
	{
		remove (GlobalOutputFileName);
	}

	// Delete the debug file if the DEBUG flag is not set to 1 in the environment variable "ONCSRV_DEBUG"
	char* debug = Parser.GetConfigValue(INI_FILE_NAME, DEBUG_CONFIG_VALUE_START_TAG, DEBUG_CONFIG_VALUE_END_TAG);
	if (debug)
	{
		if (debug[0] != '1')
		{
			remove (debugFile);
		}
	}
	else
	{
		remove (debugFile);
	}

	return EXIT_SUCCESS;
}