/*******************************************************************************/
/*  Package:      ONC  Oncology                                               */
/*  Date Created: Jul 26,2004                                                  */
/*  Site Name:    Hines OIFO                                                   */
/*  Developers:   Sergey Gavrilov PII                     )                    */
/*  Description:  Utilities for Oncology Web-service                           */
/*******************************************************************************/

#include "stdafx.h"
#include "OncologyCGI.h"

//*****	RETURNS THE PATH WHERE THE PROGRAM WAS LAUNCHED FROM

const char* getAppPath()
{
	static char app_path[_MAX_PATH] = "";
	if( strlen(app_path) == 0 )
	{
		char drive[_MAX_DRIVE], dir[_MAX_DIR], fname[_MAX_FNAME], ext[_MAX_EXT];

//JJB 100105 the str's became _s versions
		_splitpath_s( __argv[0], drive, sizeof(drive),
			dir, sizeof(dir), fname, sizeof(fname), ext, sizeof(ext));
		strcat_s(app_path, sizeof(app_path), drive);
		strcat_s(app_path, sizeof(app_path), dir);
	}
	return app_path;
}

//***** OUTPUTS THE PAIR OF TAGS AROUND THE INTEGER VALUE

void IntTag(const char *name, int val)
{
	printf("<%s>%d</%s>\n", name, val, name);
}

//***** ANALOGUE OF THE $PIECE FUNCTION IN MUMPS

string Piece(
	string Value,			// Source string
	string Delimiter,		// Delimiter string
	const int StartPiece,	// Sequential number of the start piece
	const int EndPiece)		// Sequential number of the end piece
{
	if( Value.length()>0 && StartPiece>0 && EndPiece>=StartPiece )
	{
		size_t dlen = Delimiter.length(), end, reslen, start = 0;
		int pnum;
		for( pnum=1; pnum < StartPiece; pnum++ )
		{
			start = Value.find(Delimiter, start);
			if( start != Value.npos )
				start += dlen;
			else break;
		}
		if( start != Value.npos )
		{
			end = Value.find(Delimiter, start);
			for( ; pnum < EndPiece && end != Value.npos; pnum++ )
				end = Value.find(Delimiter, end+dlen);
			reslen = end != Value.npos ? end - start: Value.length() - start;
			return Value.substr(start, reslen);
		}
	}
	return "";
}

string Piece(string Value, string Delimiter, const int StartPiece)
{
	return Piece(Value, Delimiter, StartPiece, StartPiece);
}

//***** OUTPUTS THE PAIR OF TAGS AROUND THE STRING VALUE

void StrTag(const char *name, const char *val)
{
	printf("<%s>", name);
	writeText(val);
	printf("</%s>\n", name);
}

//***** ESCAPES (GENERAL ENTITIES) THE TEXT AND WRAPS THE LINES KEEPING THE ORIGINAL STRUCTURE
// Outputs the <P> and </P> tags to mark the original lines.

void writeStructuredText(const char* text)
{
	const int maxlen2 = 240, maxlen1 = maxlen2-20;
	size_t i, len = 0, txtlen = strlen(text);
	bool nl = true;

	if( !txtlen )
	{
		puts("<P></P>");
		return;
	}

	for( i=0; i<txtlen; i++ )
	{
		if( nl )
		{
			printf("<P>");
			nl = false;
		}
		if( len >= maxlen2 )
		{
			puts("");
			len = 0;
		}
		switch(text[i])
		{
		case '\r':	// Do not separate this case from the '\n'!
			if(text[i+1] == '\n' ) i++;
		case '\n':	// Do not separate this case from the '\r'!
			puts("</P>");
			nl = true;
			break;
		case '&':
			printf("&amp;");
			len += 5;
			break;
		case '<':
			printf("&lt;");
			len += 4;
			break;
		case '>':
			printf("&gt;");
			len += 4;
			break;
		case '\'':
			printf("&apos;");
			len += 6;
			break;
		case '\"':
			printf("&quot;");
			len += 6;
			break;
		case ' ':	// Do not separate this case from the default one!
			if( len >= maxlen1 )
			{
				puts(" ");
				len = 0;
				break;
			}
		default:	// Do not separate this case from the ' '!
			putchar(text[i]);
			len += 1;
			break;
		}
	}

	if( !nl ) puts("</P>");
}

//***** ESCAPES (GENERAL ENTITIES) AND REFORMATS THE TEXT

void writeText(const char* text, bool crlf)
{
	const int maxlen2 = 240, maxlen1 = maxlen2-20;
	size_t i, len = 0, txtlen = strlen(text);

	for( i=0; i<txtlen; i++ )
	{
		if( len >= maxlen2 )
		{
			puts("");
			len = 0;
		}
		switch(text[i])
		{
		case '&':
			printf("&amp;");
			len += 5;
			break;
		case '<':
			printf("&lt;");
			len += 4;
			break;
		case '>':
			printf("&gt;");
			len += 4;
			break;
		case '\'':
			printf("&apos;");
			len += 6;
			break;
		case '\"':
			printf("&quot;");
			len += 6;
			break;
		case ' ':	// Do not separate this case from the default one!
			if( len >= maxlen1 )
			{
				puts(" ");
				len = 0;
				break;
			}
		default:	// Do not separate the default case from the ' '!
			putchar(text[i]);
			len += 1;
			break;
		}
	}

	if( crlf ) puts("");
}

//*****	ENCODES GENERAL ENTITIES ACCORDING TO XML RULES

string xmlEncode(string str)
{
	static const string ECH( "<&\'\">" );
	size_t i1, i2, sl = str.length();
	string result( "" );

	i2 = -1;
	while( 1 )
	{
		i1 = i2 + 1;
		if( i1 >= sl )
			break;
		i2 = str.find_first_of(ECH, i1);
		if( i2 == str.npos )
			break;
		if( i2 > i1 )
			result += str.substr(i1, i2-i1);
		switch(str[i2])
		{
		case '&':
			result += "&amp;";
			break;
		case '<':
			result += "&lt;";
			break;
		case '>':
			result += "&gt;";
			break;
		case '\'':
			result += "&apos;";
			break;
		case '\"':
			result += "&quot;";
			break;
		}
	}

	if( i1 < sl )
		result += str.substr(i1, sl-i1);

	return result;
}