/*******************************************************************************/
/*  Package:      ONC  Oncology                                               */
/*  Date Created: Jul 26,2004                                                  */
/*  Site Name:    Hines OIFO                                                   */
/*  Developers:   Sergey Gavrilov PII                     )                    */
/*  Description:  Implementation of the base request processing class for      */
/*                Oncology Web-service                                         */
/*******************************************************************************/

#include "stdafx.h"
#include "OncologyCGI.h"
#include "ONC_Requests.h"

/*******************************************************************************/
/*                            'GET VERSION' REQUEST                            */
/*******************************************************************************/

void TONCReqGetVersion::execute()
{
	StrTag("CS-APIVER", CStage_get_version());
	StrTag("ED-METAVER", EDITSVersion.c_str());
	StrTag("VERSION", ONCVERSION);
}

bool TONCReqGetVersion::parseTagStart(TONCParser* Parser, const TONCTagCode TagCode, const XML_Char **atts)
{
	bool prc = TONCRequest::parseTagStart(Parser, TagCode, atts);

	//--- Get the version of the default EDITS metafile
	if( TagCode == getCode() )
	{
		TONCReqED* req = new TONCReqED(TagCode);
		try
		{
			req->parseTagStart(Parser, TagCode, atts);
			EDITSVersion = req->getMetafileVersion();
			delete req;
		}
		catch(...)
		{
			delete req;
			throw;
		}
		return true;
	}

	return prc;
}

/*******************************************************************************/
/*                              GENERIC REQUEST                               */
/*******************************************************************************/

TONCRequest::TONCRequest(const TONCTagCode aCode)
{
	Code = aCode;
	Fault = NULL;
	Version = 0;
}

//*****	DESTRUCTOR

TONCRequest::~TONCRequest()
{
	delete Fault;
}

//*****	CREATES THE REQUEST OBJECT CORRESPONDING TO THE REQUEST TAG CODE

TONCRequest* TONCRequest::createRequest(TONCParser *Parser, const TONCTagCode TagCode, const XML_Char **atts)
{
	switch(TagCode)
	{
	case CS_CALCULATE:
		return new TONCReqCSCalculate(TagCode);
	case CS_GET_SCHEMA:
		return new TONCReqCSGetSchema(TagCode);
	case CS_GET_TABLES:
		return new TONCReqCSGetTables(TagCode);
	case ED_RUN_BATCH:
		return new TONCReqEDRunBatch(TagCode);
	case ED_GET_EDITINFO:
		return new TONCReqEDGetEditInfo(TagCode);
	case GET_VERSION:
		return new TONCReqGetVersion(TagCode);
	default:
		break;
	};
	return NULL;
}

//*****	PROCESSES THE REQUEST

void TONCRequest::execute()
{
	throw TONCFault(EC_INVALID_REQUEST);
}

//*****	ENCLOSES THE RESPONSE IN THE CORRESPONDING TAGS

void TONCRequest::executeRequest()
{
	responseTag(1);
	try
	{
		execute();
	}
	catch(...)
	{
		responseTag(0);
		throw;
	}
	responseTag(0);
}

//*****	RETURNS THE VALUE OF THE 'VER' ATTRIBUTE

double TONCRequest::getVersionAttr(const XML_Char **atts)
{
	double ver = 0.0;
	for( int i=0; atts[i]; i+=2 )
		if( !_stricmp(atts[i], "ver") )
		{
			ver = atof(atts[i+1]);
			break;
		}
	return ver;
}

//*****	PROCESSES THE CLOSING TAG

bool TONCRequest::parseTagEnd(TONCParser* Parser, const TONCTagCode TagCode)
{
	return (TagCode == getCode());
}

//*****	PROCESSES THE OPENING TAG

bool TONCRequest::parseTagStart(TONCParser* Parser, const TONCTagCode TagCode, const XML_Char **atts)
{
	if( TagCode == getCode() )
	{
		Version = getVersionAttr(atts);
		return true;
	}
	return false;
}

//*****	ADDS THE ERROR INFO TO THE RESPONSE

void TONCRequest::processErrors()
{
	if( Fault != NULL )
		Fault->output();
}

//***** RENDERS THE ROOT TAG OF THE RESPONSE

void TONCRequest::responseTag(bool open_tag)
{
	if( open_tag )
		printf("<RESPONSE xmlns=\"%s\">\n", getNamespace());
	else
		puts("</RESPONSE>");
}

//*****	STORES THE POINTER TO THE ERROR DSCRIPTOR IN THE CORRESPONDING PROPERTY

void TONCRequest::setFault(TONCFault* aFault)
{
	delete Fault;
	Fault = aFault;
}
