/*
 *   EditsInt.h - This is not your father's editsint.h. We simply need this
 *                definition for both MetaFile.h and EditCAPI.h.
 */
//---------------------------------------------------------------------------

#ifndef EditsIntH
#define EditsIntH

#ifdef EEWINDOWS
    #include <windows.h>
    #include <windef.h>

    /* This sets the visibility for exported functions whenever the DLL
     * is being created.
     */

    #ifdef __IS_DLL__
        #define EE_DLL	 		__declspec(dllexport) __stdcall
    #else
        #define EE_DLL 			__stdcall
    #endif
#else
   /* 10/13/2009: Eric Durbin reports that this does NOT work for Linux.
   #define stdcall __attribute__((stdcall))  // Linux
   #define EE_DLL  stdcall

   ... instead, use this:
   */
   #define EE_DLL      // that is, render it empty space for Linux
#endif

#define EEFILE  int

/* Edit, Edit Set Options    Hex        Dec */
#define EE_NOSKIP           0x0000     /* 0 Edits and Edit Sets */
#define EE_SKIPEMPTY        0x0001     /* 1 Edits and Edit Sets */
#define EE_SKIPFAIL         0x0002     /* 2 Edits and Edit Sets */
#define EE_MULTIFIELD       0x0004     /* 4 Edit SETS only */
#define EE_NEVEREMPTY       0x0004     /* 4 Edits only; Field is never reported empty for EE_SKIPEMPTY */
#define EE_SUPPRESS         0x0008     /* 8 Edits only; Skip edit or field */
#define EE_SUPPRESSWARN     0x0080     /* 128 Edits and Edit Sets */
#define EE_EDITSETOPTION    0x0200     /* 512 Edits only; Use edit set options (default) */
//---------------------------------------------------------------------------
/* Edit Status Bit Flags    Hex          Dec  */
#define EES_PASSED 		    0x0001     /* 1 */
#define	EES_FAILED		    0x0002     /* 2 */
#define EES_WARNED		    0x0004     /* 4 */
#define EES_FIELDSUPPRESSED	0x0008     /* 8 */
#define EES_SKIPEMPTY	    0x0010     /* 16 */
#define EES_SKIPFAIL	    0x0020     /* 32 */
#define EES_SKIPWARN	    0x0040     /* 64 */
#define EES_IRRELEVANT	    0x0080     /* 128 */
#define EES_MISSFIELD	    0x0100     /* 256 */
#define EES_EDITSUPPRESSED	0x0200     /* 512 */
//---------------------------------------------------------------------------
/* Create a callback function pointer type. Arguments consist of a void*
 * pointer to the object making the callback; in practice, this will be the
 * "this" pointer of the TForm (Borland VCL) that will display the contents of
 * of the char* arg passed to it.
 */
typedef void (*CallbackFunction)(void* pt2Object, const char* arg);
typedef void (*CallbackVarsFunction)(void* pt2Object, const char* arg1, int arg2);
//---------------------------------------------------------------------------


#endif  /* ifdef EditsIntH */
