//---------------------------------------------------------------------------

#ifndef EditCApiH
#define EditCApiH

#include "EditsInt.h"
//---------------------------------------------------------------------------
/*   These declarations have been organized according to the groupings
 *   described in the Edits API documentation subject "Functions by Class".
 *   Please refer to that documentation for explanations of the functions
 *   and sample source code.
 */

typedef unsigned int EEt_mh;
#define EEt_mh EEt_mh
 
/* Metafile Initialization */ 
extern "C" int 		EE_DLL EE_Init(char * metafile, char * ver);
extern "C" int 		EE_DLL EEx_Init(int * mfID, char * metafile, char * ver, void* edits_owner = NULL, void* edits_funcptr = NULL );
extern "C" int		EE_DLL EE_Exit();
extern "C" int		EE_DLL EEx_Exit(int mfID);

/* Record */
extern "C" int		EE_DLL EE_AllocRecord(int size, int *handle);
extern "C" int		EE_DLL EEx_AllocRecord(int mfID, int size, int *handle);
extern "C" int 		EE_DLL EE_FreeRecord(int handle);
extern "C" int 		EE_DLL EEx_FreeRecord(int mfID, int handle);
extern "C" int 		EE_DLL EE_RetrieveRecord(int handle, char * string);
extern "C" int 		EE_DLL EEx_RetrieveRecord(int mfID, int handle, char * string);
extern "C" int 		EE_DLL EE_SetRecord(int handle, int c);
extern "C" int 		EE_DLL EEx_SetRecord(int mfID, int handle, int c);
extern "C" int 		EE_DLL EE_UpdateRecord(int handle, char * string);
extern "C" int 		EE_DLL EEx_UpdateRecord(int mfID, int handle, char * string);
extern "C" int 		EE_DLL EE_UpdateRecordEx(int handle, char * string, int start, int len);
extern "C" int 		EE_DLL EEx_UpdateRecordEx(int mfID, int handle, char * string, int start, int len);

/* Record Layout */
extern "C" int 		EE_DLL EE_FieldHandle(char *name, char *type, char *recordname);
extern "C" int 		EE_DLL EEx_FieldHandle(int mfID, char *name, char *type, char *recordname);
extern "C" int 		EE_DLL EE_FieldHandleByLocal(long localnum, char *recordname);
extern "C" int 		EE_DLL EEx_FieldHandleByLocal(int mfID, long localnum, char *recordname);
extern "C" int 		EE_DLL EE_FieldName(int handle, char *type, char *name);
extern "C" int 		EE_DLL EEx_FieldName(int mfID, int handle, char *type, char *name);
extern "C" int      EE_DLL EE_FieldOptions(int handle, int *options);
extern "C" int      EE_DLL EEx_FieldOptions(int mfID, int handle, int* options);
extern "C" int 		EE_DLL EE_FreeRecordLayout(char * RecordName);
extern "C" int 		EE_DLL EEx_FreeRecordLayout(int mfID, char * RecordName);
extern "C" int 		EE_DLL EE_GetRecordLayoutCount(int *count);
extern "C" int 		EE_DLL EEx_GetRecordLayoutCount(int mfID, int *count);
extern "C" int 		EE_DLL EE_GetRecordLayoutField(int *startpos, long *local_num, char * stdname,char * localname, char * type, char * title, int *length, int *handle);
extern "C" int 		EE_DLL EEx_GetRecordLayoutField(int mfID, int *startpos, long *local_num, char * stdname,char * localname, char * type, char * title, int *length, int *handle);
extern "C" int 		EE_DLL EE_GetRecordLayoutInit(char * recordname, int *numflds);
extern "C" int 		EE_DLL EEx_GetRecordLayoutInit(int mfID, char * recordname, int *numflds);
extern "C" int 		EE_DLL EE_GetRecordLayoutName(int i, char * name, int *size);
extern "C" int 		EE_DLL EEx_GetRecordLayoutName(int mfID, int i, char * name, int *size);
// EDITS40
extern "C" int 		EE_DLL EEx_GetRecordLayoutDescript(int mfID, char* record_name, int maxbuflen, int *retlen, char *buffer);
extern "C" int 		EE_DLL EEx_GetEditSetDescript(int mfID, char* edset_name, int maxbuflen, int *retlen, char *buffer);

extern "C" char*	EE_DLL EE_GetRecordPtr(int handle);
extern "C" int 		EE_DLL EE_InitAltRecordLayout(int handle, char * record_name);
extern "C" int 		EE_DLL EEx_InitAltRecordLayout(int mfID, int handle, char * record_name);
extern "C" int 		EE_DLL EE_InitRecordLayout(int handle, char * record_name);
extern "C" int 		EE_DLL EEx_InitRecordLayout(int mfID, int handle, char * record_name);
extern "C" long		EE_DLL EE_LocalNumFromHnd(int handle);
extern "C" long		EE_DLL EEx_LocalNumFromHnd(int mfID, int handle);
extern "C" int      EE_DLL EE_RecordLayoutOptions(char * RecordName, int * options);
extern "C" int      EE_DLL EEx_RecordLayoutOptions(int mfID, char * RecordName, int * options);
extern "C" int 		EE_DLL EE_RecWriteClear( char * RecordName );
extern "C" int 		EE_DLL EEx_RecWriteClear( int mfID, char * RecordName );
extern "C" int 		EE_DLL EE_RecWritten( char * RecordName, int *written );
extern "C" int 		EE_DLL EEx_RecWritten( int mfID, char * RecordName, int *written );
extern "C" int 		EE_DLL EE_UpdateField(int fld, char * temp, char * type);
extern "C" int 		EE_DLL EEx_UpdateField(int mfID, int fld, char * temp, char * type);

/* Edit Set */
extern "C" int      EE_DLL EE_EditOptions(unsigned int SetHnd, int EditIndex, int *EditOption);
extern "C" int      EE_DLL EEx_EditOptions(int mfID, unsigned int SetHnd, int EditIndex, int *EditOption);
extern "C" int 		EE_DLL EE_FreeEditSet(unsigned int SetHnd);
extern "C" int 		EE_DLL EEx_FreeEditSet(int mfID, unsigned int SetHnd);
extern "C" int 		EE_DLL EE_GetEditSetCount(int *count);
extern "C" int 		EE_DLL EEx_GetEditSetCount(int mfID, int *count);
extern "C" int 		EE_DLL EE_GetEditSetHandle(int msg_index_no, int *edsethnd, int *edit_index);
extern "C" int 		EE_DLL EEx_GetEditSetHandle(int mfID, int msg_index_no, int *edsethnd, int *edit_index);
extern "C" int 		EE_DLL EE_GetEditSetName(int index, char * name);
extern "C" int 		EE_DLL EEx_GetEditSetName(int mfID, int index, char * name);
extern "C" int 		EE_DLL EE_GetEditSetSize(int edsethnd, int *numedits);
extern "C" int 		EE_DLL EEx_GetEditSetSize(int mfID, int edsethnd, int *numedits);
extern "C" int 		EE_DLL EE_LoadEditSet( unsigned int *handle, char * name, int *status,int memflag);
extern "C" int 		EE_DLL EEx_LoadEditSet( int mfID, unsigned int *handle, char * name, int *status,int memflag);
extern "C" int      EE_DLL EE_GetEditLogic( int edsethnd, int editindex, int maxbuflen, char *linedelim, int *retlen, char *buffer);
extern "C" int      EE_DLL EEx_GetEditLogic( int mfID, int edsethnd, int editindex, int maxbuflen, char *linedelim, int *retlen, char *buffer);
extern "C" int      EE_DLL EEx_GetEncodedEdit( int mfID, int edsethnd, int edit_index_no, char* editBuffer, int editBuffLen, char* nameBuffer, int nameBuffLen);

/* Flag Array Manipulation */
extern "C" int		EE_DLL EE_CheckFlag(int *flagval, int flagno);
extern "C" int		EE_DLL EEx_CheckFlag(int mfID, int *flagval, int flagno);
extern "C" int 		EE_DLL EE_ClearAllFlags(void);
extern "C" int 		EE_DLL EEx_ClearAllFlags(int mfID);
extern "C" int 		EE_DLL EE_CountFlags(int *count);
extern "C" int 		EE_DLL EEx_CountFlags(int mfID, int *count);
extern "C" int 		EE_DLL EE_SetFlag( int flagno, int flagval );
extern "C" int 		EE_DLL EEx_SetFlag( int mfID, int flagno, int flagval );
extern "C" int 		EE_DLL EE_SumFlags( long *sum );
extern "C" int 		EE_DLL EEx_SumFlags( int mfID, long *sum );

/* Choice Lists */
extern "C" int 		EE_DLL EE_FreeChoices(void);
extern "C" int 		EE_DLL EEx_FreeChoices(int mfID);
extern "C" int 		EE_DLL EE_GetChoices(char *retbuf, int direction, int maxnum, int *numret);
extern "C" int 		EE_DLL EEx_GetChoices(int mfID, char *retbuf, int direction, int maxnum, int *numret);
extern "C" int 		EE_DLL EE_InitChoices(char* FileName, char * srchval, char * fldcodes, int *reclen, long *numrecs);
extern "C" int 		EE_DLL EEx_InitChoices(int mfID, char* FileName, char * srchval, char * fldcodes, int *reclen, long *numrecs);
extern "C" int 		EE_DLL EE_InitFieldChoices(long fldnum, char *srchval, char *fldcodes, int *reclen, long *numrecs);
extern "C" int 		EE_DLL EEx_InitFieldChoices(int mfID, long fldnum, char *srchval, char *fldcodes, int *reclen, long *numrecs);

/* Editing */
extern "C" int      EE_DLL EEx_GetShowEditName(int mfID, char& showEditName);
extern "C" int 		EE_DLL EE_RunBatch( unsigned int SetHnd, int option, int *error_from_edit );
extern "C" int 		EE_DLL EEx_RunBatch( int mfID, unsigned int SetHnd, int option, int *error_from_edit, void* objptr, void* funcptr );
extern "C" int 		EE_DLL EE_RunEditByName(char * Name);
extern "C" int 		EE_DLL EEx_RunEditByName(int mfID, char * Name, void* objptr, void* funcptr );
extern "C" int 		EE_DLL EE_RunSingle(unsigned int SetHnd, long field, int option, int *error_from_edit );
extern "C" int 		EE_DLL EEx_RunSingle(int mfID, unsigned int SetHnd, long field, int option, int *error_from_edit, void* objptr, void* funcptr );
extern "C" int      EE_DLL EEx_SetShowEditName(int mfID, char showEditName);
extern "C" int      EE_DLL EEx_SetDebug(int mfID, char *editName, void *debug_owner, void *varsfuncptr, void *fieldsfuncptr, void *logicfuncptr, void *notesfuncptr); 

/* Error Reporting */
extern "C" int 		EE_DLL EE_GetEditCounts(int edsethnd, int editIndex, int *fields,long *errors, long *warnings, long *skipped);
extern "C" int 		EE_DLL EEx_GetEditCounts(int mfID, int edsethnd, int editIndex, int *fields,long *errors, long *warnings, long *skipped);
extern "C" int 		EE_DLL EE_GetEditDescript(int edsethnd, int editindex, int maxlinelen, int maxbuflen, int *retlen, char *buffer, int fmtoption);
extern "C" int 		EE_DLL EEx_GetEditDescript(int mfID, int edsethnd, int editindex, int maxlinelen, int maxbuflen, int *retlen, char *buffer, int fmtoption);
extern "C" int 		EE_DLL EE_GetEditHelp(int edsethnd, int editindex, int maxlinelen,int maxbuflen, int *retlen, char *buffer, int fmtoption);
extern "C" int 		EE_DLL EEx_GetEditHelp(int mfID, int edsethnd, int editindex, int maxlinelen,int maxbuflen, int *retlen, char *buffer, int fmtoption);
extern "C" int 		EE_DLL EE_GetEditSetInfo(int edsetHandle, char* edsetName, int* edsetSize, int* lastoption, long* locfldnum);
extern "C" int 		EE_DLL EEx_GetEditSetInfo(int mfID, int edsetHandle, char* edsetName, int* edsetSize, int* lastoption, long* locfldnum);

extern "C" int 		EE_DLL EE_GetEditHandle(int edsethnd, int *editIndex, char * name);
extern "C" int 		EE_DLL EEx_GetEditHandle(int mfID, int edsethnd, int *editIndex, char * name);
extern "C" int 		EE_DLL EE_GetEditInfo(int edsethnd, int editIndex, char *fmt, char *pbuf, int buf_size);
extern "C" int 		EE_DLL EEx_GetEditInfo(int mfID, int edsethnd, int editIndex, char *fmt, char *pbuf, int buf_size);
extern "C" int 		EE_DLL EE_GetEditInfoEx( int edsethnd, int editIndex, char *editname, int *ednumflds, int *edstatus, int *edoptions, long *errors, long *warnings, long *skips);
extern "C" int 		EE_DLL EEx_GetEditInfoEx( int mfID, int edsethnd, int editIndex, char *editname, int *ednumflds, int *edstatus, int *edoptions, long *errors, long *warnings, long *skips);
extern "C" int 		EE_DLL EE_GetEditName(int edsethnd, int editIndex, char * name);
extern "C" int 		EE_DLL EEx_GetEditName(int mfID, int edsethnd, int editIndex, char * name);
extern "C" int 		EE_DLL EE_GetMessageCount(int *count);
extern "C" int 		EE_DLL EEx_GetMessageCount(int mfID, int *count);
extern "C" int 		EE_DLL EE_GetMessageText(char *msgtype, int msg_index_no, char * pbuf, int buf_size);
extern "C" int 		EE_DLL EEx_GetMessageText(int mfID, char *msgtype, int msg_index_no, char * pbuf, int buf_size);
extern "C" int 		EE_DLL EE_GetMessageTextEx(char * msgtype, int msg_index_no, char * pbuf, int buf_size, long *error_msg_code, int *edsethnd, int *edit_index, char * editname, int *numfields);
extern "C" int 		EE_DLL EEx_GetMessageTextEx(int mfID, char * msgtype, int msg_index_no, char * pbuf, int buf_size, long *error_msg_code, int *edsethnd, int *edit_index, char * editname, int *numfields);

/* System Functions */
extern "C" int      EE_DLL EEerr_GetEngineErrorMessage(int error_no, char* err_msg, int msg_length, char* func_name = NULL, int name_length = 0);
extern "C" int      EE_DLL EEerr_ExportErrorList(char* filename = NULL);
extern "C" int      EE_DLL EEx_GetLastEngineError(int mfID);
extern "C" int      EE_DLL EEx_GetmfIDList(int mfIDlist[], int listsize);
extern "C" int      EE_DLL EEx_GetOpenFileList(char* mflist[], int listsize);
extern "C" int      EE_DLL EEx_GetVersion(char * verBuffer, unsigned int bufferLen);
extern "C" int 		EE_DLL EE_GetVar(char *varname, char *value);
extern "C" int 		EE_DLL EEx_GetVar(int mfID, char *varname, char *value);
extern "C" int 		EE_DLL EE_GetVarIndex(char * varname, int index, char * value );
extern "C" int 		EE_DLL EEx_GetVarIndex(int mfID, char * varname, int index, char * value );
extern "C" int 		EE_DLL EE_GetVarSize(char * varname, long *size );
extern "C" int 		EE_DLL EEx_GetVarSize(int mfID, char * varname, long *size );
extern "C" int      EE_DLL EEx_SetEditsMessagesCallback(int mfID, void* objptr, void* funcptr);
extern "C" int 		EE_DLL EE_SetVar(char * varname, char * value);
extern "C" int 		EE_DLL EEx_SetVar(int mfID, char * varname, char * value);
extern "C" int 		EE_DLL EE_SetVarIndex(char * varname, char * value, int index);
extern "C" int 		EE_DLL EEx_SetVarIndex(int mfID, char * varname, char * value, int index);
// EDITS40
extern "C" int      EE_DLL EEx_GetMemoSize(int mfID, int memo_type, char* name, int* memo_size);

/* User Functions */
extern "C" long 	(*EE_usr_func[10])(long l1, long l2, long l3, long l4, long l5);

#endif /* ifndef EditCApiH */

