﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using VeteransAffairs.Registries.Business;
using AntiXssEnc = Microsoft.Security.Application;

[ValidationProperty("MonthYearString")]
public partial class controls_MonthYearSelector : System.Web.UI.UserControl
{
    public string Label
    {
        get
        {
            return lblMonthYear.Text;
        }
        set
        {
            lblMonthYear.Text = value;
        }
    }

    public string YearString
    {
        get
        {
            string s = "";

            if (ddlYear.SelectedIndex > 0)
            {
                // Year YYYY
                s += ddlYear.SelectedValue.ToString();
            }

            return s;
        }
    }

    public string MonthYearString
    {
        get
        {
            string s = "";

            if (ddlYear.SelectedIndex > 0)
            {
                if (ddlMonth.SelectedIndex > 0)
                {
                    // Month in MM format, plus /
                    s += ddlMonth.SelectedValue.ToString() + "/";
                }

                // Year YYYY
                s += ddlYear.SelectedValue.ToString();
            }

            return s;
        }

        set
        {
            ddlMonth.SelectedIndex = -1;
            ddlYear.SelectedIndex = -1;

            bool bCanParse = true;

            string mt = "";
            string yt = "";
            int iTemp;

            if (AntiXssEnc.Encoder.HtmlEncode(value).Split('/').Length == 2)
            {
                mt = value.Split('/')[0];
                yt = value.Split('/')[1];

                if (mt.Length > 0 && mt.Length < 3)
                {
                    if (int.TryParse(mt, out iTemp))
                    {
                        if (iTemp > 0 && iTemp < 13)
                        {
                            ddlMonth.SelectedValue = iTemp.ToString();
                        }
                        else if (iTemp == 0)
                        {
                            ddlMonth.SelectedIndex = -1;
                        }
                        else
                        {
                            bCanParse = false;
                        }
                    }
                    else
                    {
                        bCanParse = false;
                    }
                }
                else
                {
                    bCanParse = false;
                }

                // If month is okay, go to year

                if (bCanParse)
                {
                    if (yt.Length == 4)
                    {
                        if (int.TryParse(yt, out iTemp))
                        {
                            if (iTemp >= 1900 && iTemp <= DateTime.Now.Year)
                            {
                                ddlYear.SelectedValue = iTemp.ToString();
                            }
                            else
                            {
                                bCanParse = false;
                            }
                        }
                        else
                        {
                            bCanParse = false;
                        }
                    }
                    else
                    {
                        bCanParse = false;
                    }
                }
            }
            else if (value.Length == 4) // Check for just year
            {
                if (int.TryParse(value, out iTemp))
                {
                    if (iTemp > 1900 && iTemp <= DateTime.Now.Year)
                    {
                        ddlYear.SelectedValue = iTemp.ToString();
                    }
                    else
                    {
                        bCanParse = false;
                    }
                }
                else
                {
                    bCanParse = false;
                }
            }
            else if (!(value == null || value == ""))
            {
                bCanParse = false;                
            }

            // if we can't parse and there is a value, set the label so users can see what it was.

            if (!bCanParse)
            {
                lblDBValue.Text = "Unrecognized date value: " + AntiXssEnc.Encoder.HtmlEncode(value);
                lblDBValue.Visible = true;
            }
        }
    }

    protected void Page_Load(object sender, EventArgs e)
    {
    }

    public void enable(bool b)
    {
        ddlMonth.Enabled = ddlYear.Enabled = b;
    }
    public void populateDateTimeLists()
    {
        string sDisplay = "alpha";

        var setting = Helpers.GetDBConfigEntry("MSSRMonthYearFormat");

        if (setting != null)
        {
            sDisplay = setting.ToString().ToLower();
        }

        ddlMonth.Items.Clear();

        ddlMonth.Items.Add(new ListItem("Select a month", "0"));

        switch (sDisplay)
        {
            case "numeric":
                for (int i = 1; i <= 12; i++)
                {
                    ddlMonth.Items.Add(new ListItem(i.ToString(), i.ToString()));
                }
                break;

            default:
                var monthsAlpha = System.Globalization.CultureInfo.CurrentCulture.DateTimeFormat.MonthNames;
                for (int i = 1; i < monthsAlpha.Length; i++)
                {
                    ddlMonth.Items.Add(new ListItem(monthsAlpha[i-1], i.ToString()));
                }
                break;
        }

        // Year
        ddlYear.Items.Add(new ListItem("Select a year", "0000"));

        for (int j = DateTime.Now.Year; j >= 1900;  j--)
        {
            ddlYear.Items.Add(new ListItem(j.ToString(), j.ToString()));
        }
    }

    public void setRequired(bool b)
    {
        this.sRequired.Visible = b;
    }

    public void setTabIndex(short index)
    {
        ddlMonth.TabIndex = index;
        ddlYear.TabIndex = (short)(index + 1);
    }
}
