﻿using System;
using System.Linq;
using VeteransAffairs.Registries.Business;
using System.Text;
using System.Web.UI.WebControls;
using AntiXssEnc=Microsoft.Security.Application;

public partial class controls_MedicationSelection : System.Web.UI.UserControl
{
    #region Public Member Variables

    public short StartTabIndex
    {
        set
        {
            lblMedicationName.TabIndex = value;
           // rblQSJC.TabIndex = (short)(value + 1);
            //mysQSJCPositive.setTabIndex((short)(value + 2)); // There are two components in this user control
            //mysQSJCNegative.setTabIndex((short)(value + 4));
            rblQCardioTox.TabIndex = (short)(value + 6);
            mysQCardioToxYes.setTabIndex((short)(value + 7));
            cbQCardioToxDateUnknown.TabIndex = (short)(value + 9);
            rblUseStatus.TabIndex = (short)(value + 10);
            RequiredFieldValidatorUseStatus.TabIndex = (short)(value + 11);
            txtOtherDMTName.TabIndex = (short)(value + 12);
            chkBoxCurrentUse.TabIndex = (short)(value + 13);
            rblCurrentDispensingPharmacy.TabIndex = (short)(value + 14);
            mysCurrentApproximateDateStarted.setTabIndex((short)(value + 15));
            txtCurrentNumberOfDosesTaken.TabIndex = (short)(value + 17);
            chkBoxPastUse.TabIndex = (short)(value + 18);
            rblPastDispensingPharmacy.TabIndex = (short)(value + 19);
            mysPastDateStarted.setTabIndex((short)(value + 20));
            mysPastDateStopped.setTabIndex((short)(value + 22));
            txtPastNumberOfDosesTaken.TabIndex = (short)(value + 24);
            rblPastReasonStopped.TabIndex = (short)(value + 25);
            txtSignificantAdverseEventDescription.TabIndex = (short)(value + 26);
            txtOtherReasonStoppedDescription.TabIndex = (short)(value + 27);
            chkBoxAdverseEvents.TabIndex = (short)(value + 28);
            rblAdverseEvents.TabIndex = (short)(value + 29);
            txtAdverseEventsDescription.TabIndex = (short)(value + 30);
        }
    }

    public int MedicationId
    {
        get
        {
            if (ViewState["MedicationId_" + this.ID] != null)
            {
                return (int)ViewState["MedicationId_" + this.ID];
            }
            else
            {
                return 0;
            }
        }
        set
        {
            ViewState["MedicationId_" + this.ID] = value;
        }
    }

    public MSSR_PATIENT_MEDICATION PatientMedication { get; set; } // stores selections from meds.

    public string MedicationName
    {
        get
        {
            if (ViewState["MedicationName_" + this.ID] != null)
            {
                return ViewState["MedicationName_" + this.ID].ToString();
            }
            else
            {
                return null;
            }
        }

        set
        {
            ViewState["MedicationName_" + this.ID] = value;
            lblMedicationName.Text = AntiXssEnc.Encoder.HtmlEncode(value);
        }
    }

    public string HealthFactorName
    {
        get
        {
            if (ViewState["HealthFactorName_" + this.ID] != null)
            {
                return ViewState["HealthFactorName_" + this.ID].ToString();
            }
            else
            {
                return null;
            }
        }
        set
        {
            ViewState["HealthFactorName_" + this.ID] = value;
        }
    }

    #endregion

    #region Public Methods

    /// <summary>
    /// Initializes data and populates structures - called from parent.
    /// </summary>
    public void InitializeData()
    {
        //populateUseStatusList();
        //setMonthYearSelectorValues();
    }

    /// <summary>
    /// Populates and returns a MSSR_PATIENT_MEDICATION with data collected in control.
    /// </summary>
    /// <returns></returns>
    public MSSR_PATIENT_MEDICATION GetPatientMedication()
    {
        setVisibility();

        if (PatientMedication == null)
        {
            PatientMedication = new MSSR_PATIENT_MEDICATION();
        }

        PatientMedication.MEDICATION_ID = MedicationId;
        PatientMedication.OTHER_DMT_NAME = (!String.IsNullOrEmpty(txtOtherDMTName.Text) ? txtOtherDMTName.Text : null);
        PatientMedication.CURRENT_THERAPY = chkBoxCurrentUse.Checked;

        PatientMedication.CURRENT_THERAPY_APPROXIMATE_YEAR_STARTED = (!String.IsNullOrEmpty(mysCurrentApproximateDateStarted.MonthYearString) ? mysCurrentApproximateDateStarted.MonthYearString : null);

        PatientMedication.CurrentNumberOfDosesTaken = (!String.IsNullOrEmpty(txtCurrentNumberOfDosesTaken.Text) ? txtCurrentNumberOfDosesTaken.Text : null);
        
        if (rblCurrentDispensingPharmacy.SelectedIndex > -1)
        {
            PatientMedication.CURRENT_THERAPY_DISPENSING_PHARMACY = Convert.ToInt32(rblCurrentDispensingPharmacy.SelectedValue);
        }
        else
        {
            PatientMedication.CURRENT_THERAPY_DISPENSING_PHARMACY = null;
        }

        if (rblUseStatus.SelectedIndex > -1)
        {
            PatientMedication.MEDICATION_USED = Convert.ToInt32(rblUseStatus.SelectedValue);
        }
        else
        {
            PatientMedication.MEDICATION_USED = null;
        }

        PatientMedication.PAST_USE = chkBoxPastUse.Checked;
        PatientMedication.PAST_USE_APPROXIMATE_YEAR_STARTED = (!String.IsNullOrEmpty(mysPastDateStarted.MonthYearString) ? mysPastDateStarted.MonthYearString : null);
        PatientMedication.PAST_USE_APPROXIMATE_YEAR_STOPPED = (!String.IsNullOrEmpty(mysPastDateStopped.MonthYearString) ? mysPastDateStopped.MonthYearString : null);

        PatientMedication.PastNumberOfDosesTaken = (!String.IsNullOrEmpty(txtPastNumberOfDosesTaken.Text) ? txtPastNumberOfDosesTaken.Text : null);
        if (rblPastDispensingPharmacy.SelectedIndex > -1)
        {
            PatientMedication.PAST_USE_DISPENSING_PHARMACY = Convert.ToInt32(rblPastDispensingPharmacy.SelectedValue);
        }
        else
        {
            PatientMedication.PAST_USE_DISPENSING_PHARMACY = null;
        }

        // TODO: create text area for selection of - 6/Significant adverse event or ... other selection under PARENT_ID 2
        //PatientMedication.PAST_USE_REASON_STOPPED_OTHER

        if (rblPastReasonStopped.SelectedIndex > -1)
        {
            PatientMedication.PAST_USE_REASON_STOPPED = Convert.ToInt32(rblPastReasonStopped.SelectedValue);
            if (rblPastReasonStopped.SelectedItem.Text.ToLower().Contains("other"))
            {
                PatientMedication.PAST_USE_REASON_STOPPED_OTHER = txtOtherReasonStoppedDescription.Text;
            }
            else if (rblPastReasonStopped.SelectedItem.Text.ToLower().Contains("significant adverse event"))
            {
                PatientMedication.SigEventOther = txtSignificantAdverseEventDescription.Text;
            }
            else
            {
                PatientMedication.PAST_USE_REASON_STOPPED_OTHER = "";
            }
        }
        else
        {
            PatientMedication.PAST_USE_REASON_STOPPED = null;
            PatientMedication.PAST_USE_REASON_STOPPED_OTHER = "";
        }

        

        PatientMedication.ADVERSE_EVENTS = chkBoxAdverseEvents.Checked;
        PatientMedication.ADVERSE_EVENTS_DESCRIPTION = (!String.IsNullOrEmpty(txtAdverseEventsDescription.Text) ? txtAdverseEventsDescription.Text : null);

        if (rblAdverseEvents.SelectedIndex > -1)
        {
            PatientMedication.ADVERSE_EVENT = Convert.ToInt32(rblAdverseEvents.SelectedValue);
        }
        else
        {
            PatientMedication.ADVERSE_EVENT = null;
        }

        if (rdNumTxtLfTimeExposureInMonth.Value != null)
        {
            PatientMedication.TOTAL_LIFETIME_EXPOSURE_TO_THIS_THERAPY_IN_MONTHS = (int?) rdNumTxtLfTimeExposureInMonth.Value;
        }

        return PatientMedication;
    }

    /// <summary>
    /// UpdateSurveyWithMedicationSelections: places medication selections in survey
    /// </summary>
    /// <param name="survey"></param>
    public void UpdateSurveyWithMedicationSelections(ref SURVEY survey)
    {
        //SURVEY_RESULT _surveyResult;
    }

    /// <summary>
    /// SetupMedicationSelections: to prep display for form ... and populate
    /// </summary>
    /// <param name="survey"></param>
    public void SetupMedicationSelections(MSSR_PATIENT_MEDICATION patientMed)
    {
        PatientMedication = patientMed; // assign intneral variable value passed in.

        populateUseStatusList();
        setValidatorSettings();

        // setup form.

        ////Changed DWR 5/20/14////
        //At this point the rblUseStatus list is not bound to any data,
        //attempt to hide/show panels based on the value from the db, 
        //as these should match up after binding is done then...
        if (patientMed.MEDICATION_USED.HasValue)
        {
            rblUseStatus.SelectedValue = patientMed.MEDICATION_USED.ToString();
            if (patientMed.MEDICATION_USED == 2)
                pnlCurrentPastUse.Style["display"] = "block";
            else
                pnlCurrentPastUse.Style["display"] = "none";
        }
        else
        {
            pnlCurrentPastUse.Style["display"] = "none";
            
        }

        if (!String.IsNullOrEmpty(patientMed.OTHER_DMT_NAME))
        {
            txtOtherDMTName.Text = patientMed.OTHER_DMT_NAME;
        }

        // current
        if (patientMed.CURRENT_THERAPY.HasValue)
        {
            chkBoxCurrentUse.Checked = (bool)patientMed.CURRENT_THERAPY;
        }
        else
        {
            chkBoxCurrentUse.Checked = false;
        }

        if (patientMed.CURRENT_THERAPY_DISPENSING_PHARMACY.HasValue)
        {
            rblCurrentDispensingPharmacy.SelectedValue = patientMed.CURRENT_THERAPY_DISPENSING_PHARMACY.ToString();
        }

        if (!String.IsNullOrEmpty(patientMed.CURRENT_THERAPY_APPROXIMATE_YEAR_STARTED))
        {
            mysCurrentApproximateDateStarted.MonthYearString = patientMed.CURRENT_THERAPY_APPROXIMATE_YEAR_STARTED;
        }

        if (!String.IsNullOrEmpty(patientMed.CurrentNumberOfDosesTaken))
        {
            txtCurrentNumberOfDosesTaken.Text = patientMed.CurrentNumberOfDosesTaken;
        }

        // past
        if (patientMed.PAST_USE.HasValue)
        {
            chkBoxPastUse.Checked = (bool)patientMed.PAST_USE;
        }
        else
        {
            chkBoxPastUse.Checked = false;
        }

        if (!String.IsNullOrEmpty(patientMed.PAST_USE_APPROXIMATE_YEAR_STARTED))
        {
            mysPastDateStarted.MonthYearString = patientMed.PAST_USE_APPROXIMATE_YEAR_STARTED;
        }

        if (!String.IsNullOrEmpty(patientMed.PAST_USE_APPROXIMATE_YEAR_STOPPED))
        {
            mysPastDateStopped.MonthYearString = patientMed.PAST_USE_APPROXIMATE_YEAR_STOPPED;
        }

        if (!String.IsNullOrEmpty(patientMed.PastNumberOfDosesTaken))
        {
            txtPastNumberOfDosesTaken.Text = patientMed.PastNumberOfDosesTaken;
        }

        if (patientMed.PAST_USE_DISPENSING_PHARMACY.HasValue)
        {
            rblPastDispensingPharmacy.SelectedValue = patientMed.PAST_USE_DISPENSING_PHARMACY.ToString();
        }

        if (patientMed.PAST_USE_REASON_STOPPED.HasValue)
        {
            rblPastReasonStopped.SelectedValue = patientMed.PAST_USE_REASON_STOPPED.ToString();

            if (rblPastReasonStopped.SelectedIndex > -1)
            {
                if (rblPastReasonStopped.SelectedItem.Text.ToLower().Contains("significant adverse event"))
                {
                    txtSignificantAdverseEventDescription.Text = patientMed.SigEventOther.ToString();
                }
                else if (rblPastReasonStopped.SelectedItem.Text.ToLower().Contains("other"))
                {
                    txtOtherReasonStoppedDescription.Text = patientMed.PAST_USE_REASON_STOPPED_OTHER.ToString();
                }
            }
        }

        if (patientMed.ADVERSE_EVENTS.HasValue)
        {
            chkBoxAdverseEvents.Checked = (bool)patientMed.ADVERSE_EVENTS;

            if (chkBoxAdverseEvents.Checked)
            {
                if (!String.IsNullOrEmpty(patientMed.ADVERSE_EVENTS_DESCRIPTION))
                {
                    txtAdverseEventsDescription.Text = patientMed.ADVERSE_EVENTS_DESCRIPTION.ToString();
                }

                if (patientMed.ADVERSE_EVENT.HasValue)
                {
                    rblAdverseEvents.SelectedValue = patientMed.ADVERSE_EVENT.ToString();
                }
            }
            else
            {
                rblAdverseEvents.SelectedIndex = -1;
            }
        }
        else
        {
            chkBoxAdverseEvents.Checked = false;
        }
        if (patientMed.TOTAL_LIFETIME_EXPOSURE_TO_THIS_THERAPY_IN_MONTHS.HasValue)
        {
            rdNumTxtLfTimeExposureInMonth.Value = patientMed.TOTAL_LIFETIME_EXPOSURE_TO_THIS_THERAPY_IN_MONTHS.Value;
        }

        // Do this so the Notes are populated when the page first loads.
        //populateUseStatusList(); This fixes the notes, but then
        // breaks the setting of the current/past use rb
    }

    /// <summary>
    /// 
    /// </summary>
    /// <returns></returns>
    public string GetHealthFactorsForMedication()
    {
        string hfResult = "";

        // Is medication used ... 
        if (rblUseStatus.SelectedIndex > -1)
        {
            if (rblUseStatus.SelectedItem.Text.ToLower().Contains("current"))
            {
                // current or past use selected

                if (chkBoxCurrentUse.Checked)
                {
                    // currently used - MSCOE.AZATHIOPRINE.CURRENT USE
                    hfResult += "MSCOE." + HealthFactorName + ".CURRENT USE, ";

                    #region check dispensing pharm type

                    if (rblCurrentDispensingPharmacy.SelectedIndex > -1)
                    {
                        if (rblCurrentDispensingPharmacy.SelectedItem.Text.ToLower().Contains("non"))
                        {
                            //MSCOE.AZATHIOPRINE.CURRENT NONVA
                            hfResult += "MSCOE." + HealthFactorName + ".CURRENT NONVA, ";
                        }
                        else
                        {
                            //MSCOE.AZATHIOPRINE.CURRENT VA
                            hfResult += "MSCOE." + HealthFactorName + ".CURRENT VA, ";
                        }
                    }

                    #endregion

                    #region check current date started

                    if (!String.IsNullOrEmpty(mysCurrentApproximateDateStarted.MonthYearString))
                    {
                        hfResult += "MSCOE." + HealthFactorName + ".CURRENT STARTED, ";
                    }

                    #endregion
                }

                if (chkBoxPastUse.Checked)
                {
                    // used in past. - MSCOE.AZATHIOPRINE.PAST USE
                    hfResult += "MSCOE." + HealthFactorName + ".PAST USE, ";

                    #region check dispensing pharm type

                    if (rblPastDispensingPharmacy.SelectedIndex > -1)
                    {
                        if (rblPastDispensingPharmacy.SelectedItem.Text.ToLower().Contains("non"))
                        {
                            //MSCOE.AZATHIOPRINE.PAST NONVA
                            hfResult += "MSCOE." + HealthFactorName + ".PAST NONVA, ";
                        }
                        else
                        {
                            //MSCOE.AZATHIOPRINE.PAST VA
                            hfResult += "MSCOE." + HealthFactorName + ".PAST VA, ";
                        }
                    }

                    #endregion

                    #region check past date started

                    if (!String.IsNullOrEmpty(mysPastDateStarted.MonthYearString))
                    {
                        hfResult += "MSCOE." + HealthFactorName + ".PAST STARTED, ";
                    }

                    #endregion

                    #region check past date stopped

                    if (!String.IsNullOrEmpty(mysPastDateStopped.MonthYearString))
                    {
                        hfResult += "MSCOE." + HealthFactorName + ".PAST STOPPED, ";
                    }

                    #endregion

                    #region check reason stopped

                    if (rblPastReasonStopped.SelectedIndex > -1)
                    {
                        if (rblPastReasonStopped.SelectedItem.Text.ToLower().Contains("adverse"))
                        {
                            //MSCOE.AZATHIOPRINE.RSTOP.ADVERSE SE
                            hfResult += "MSCOE." + HealthFactorName + ".RSTOP.ADVERSE SE, ";

                        }
                        else if (rblPastReasonStopped.SelectedItem.Text.ToLower().Contains("ineffective"))
                        {
                            //MSCOE.AZATHIOPRINE.RSTOP.INEFFECTIVE
                            hfResult += "MSCOE." + HealthFactorName + ".RSTOP.INEFFECTIVE, ";

                        }
                        else if (rblPastReasonStopped.SelectedItem.Text.ToLower().Contains("intolerant"))
                        {
                            hfResult += "MSCOE." + HealthFactorName + ".RSTOP.INTOLERANT, ";

                        }
                        else if (rblPastReasonStopped.SelectedItem.Text.ToLower().Contains("maximum"))
                        {
                            hfResult += "MSCOE." + HealthFactorName + ".RSTOP.MAX DOSE, ";

                        }
                    }

                    #endregion
                }
            }
            else
            {
                // never ... selected
                hfResult += "MSCOE." + HealthFactorName + ".NEVER, ";
            }
        }
        else
        {
            hfResult += "MSCOE." + HealthFactorName + ".NEVER, ";
        }

        //MSCOE.AZATHIOPRINE.CURRENT DOSES TAKEN
        //MSCOE.AZATHIOPRINE.PAST DOSES TAKEN

        if (hfResult.EndsWith(", "))
        {
            hfResult = hfResult.Substring(0, hfResult.Length - 2);
        }

        return hfResult;
    }

    /// <summary>
    /// GetMedicationNoteSummary: returns the string of appropriate note summary data for the current selections
    /// </summary>
    /// <returns></returns>
    public string GetMedicationNoteSummary()
    {
        StringBuilder noteSummaryResult = new StringBuilder();

        // Is medication used ... 
        if (rblUseStatus.SelectedIndex > -1)
        {
            if (rblUseStatus.SelectedItem.Text.ToLower().Contains("current"))
            {
                // current or past use selected
                noteSummaryResult.Append("\r\n - " + MedicationName + " Usage Status\r\n");

                if (MedicationName.ToLower().Contains("other"))
                {
                    noteSummaryResult.Append("\tOther DMT Medicine Name: " + txtOtherDMTName.Text + "\r\n");
                }
                else if (MedicationName.ToLower().Contains("mitoxantrone"))
                {
                    noteSummaryResult.Append(writeMitoxantroneData());
                }              

                if (chkBoxCurrentUse.Checked)
                {
                    // currently used - MSCOE.AZATHIOPRINE.CURRENT USE
                    noteSummaryResult.Append("  - Current:\r\n");

                    #region check dispensing pharm type

                    if (rblCurrentDispensingPharmacy.SelectedIndex > -1)
                    {
                        noteSummaryResult.Append("\tDispensing Pharmacy: " + rblCurrentDispensingPharmacy.SelectedItem.Text + "\r\n");
                    }

                    #endregion

                    #region check current date started

                    if (!String.IsNullOrEmpty(mysCurrentApproximateDateStarted.MonthYearString))
                    {
                        noteSummaryResult.Append("\tApproximate date started: " + mysCurrentApproximateDateStarted.MonthYearString + "\r\n");
                    }

                    #endregion

                    #region current number of doses

                    if (!String.IsNullOrEmpty(txtCurrentNumberOfDosesTaken.Text))
                    {
                        noteSummaryResult.Append("\tCurrent number of doses taken: " + txtCurrentNumberOfDosesTaken.Text + "\r\n");
                    }

                    #endregion
                }

                if (chkBoxPastUse.Checked)
                {
                    // used in past. - MSCOE.AZATHIOPRINE.PAST USE
                    noteSummaryResult.Append("  - Past:\r\n");

                    #region check dispensing pharm type

                    if (rblPastDispensingPharmacy.SelectedIndex > -1)
                    {
                        noteSummaryResult.Append("\tDispensing Pharmacy: " + rblPastDispensingPharmacy.SelectedItem.Text + "\r\n");
                    }

                    #endregion

                    #region check past date started

                    if (!String.IsNullOrEmpty(mysPastDateStarted.MonthYearString))
                    {
                        noteSummaryResult.Append("\tApproximate date started: " + mysPastDateStarted.MonthYearString + "\r\n");
                    }

                    #endregion

                    #region check past date stopped

                    if (!String.IsNullOrEmpty(mysPastDateStopped.MonthYearString))
                    {
                        noteSummaryResult.Append("\tApproximate date stopped: " + mysPastDateStopped.MonthYearString + "\r\n");
                    }

                    #endregion


                    #region past number of doses

                    if (!String.IsNullOrEmpty(txtPastNumberOfDosesTaken.Text))
                    {
                        noteSummaryResult.Append("\tPast number of doses taken: " + txtPastNumberOfDosesTaken.Text + "\r\n");
                    }

                    #endregion

                    #region check reason stopped

                    if (rblPastReasonStopped.SelectedIndex > -1)
                    {
                        noteSummaryResult.Append("\tReason Stopped: " + rblPastReasonStopped.SelectedItem.Text + "\r\n");

                        if (rblPastReasonStopped.SelectedItem.Text.ToLower().Contains("other"))
                        {
                            noteSummaryResult.Append("\tOther Reason Stopped Descripton: " + txtOtherReasonStoppedDescription.Text + "\r\n");
                        }
                        else if (rblPastReasonStopped.SelectedItem.Text.ToLower().Contains("significant adverse event"))
                        {
                            noteSummaryResult.Append("\tSignificant Adverse Event Description: " + txtSignificantAdverseEventDescription.Text + "\r\n");
                        }
                    }

                    #endregion
                }

                #region Adverse events
                if (chkBoxAdverseEvents.Checked)
                {
                    noteSummaryResult.Append("  - Adverse Event:\r\n");

                    if (rblAdverseEvents.SelectedIndex > -1)
                    {
                        noteSummaryResult.Append("\tAdverse Event: " + rblAdverseEvents.SelectedItem.Text + "\r\n");
                    }

                    if (!String.IsNullOrEmpty(txtAdverseEventsDescription.Text))
                    {
                        noteSummaryResult.Append("\tAdverse Event Description: " + txtAdverseEventsDescription.Text + "\r\n");
                    }
                }
                #endregion

                #region Total Exposure
                if (rdNumTxtLfTimeExposureInMonth.Value != null)
                {
                    noteSummaryResult.Append("  - Total Lifetime Exposure:\r\n");

                    if (rdNumTxtLfTimeExposureInMonth.Value != null)
                    {
                        noteSummaryResult.Append("\t Total Lifetime Exposure: " + rdNumTxtLfTimeExposureInMonth.Value + "\r\n");
                    }
                }
                #endregion
            }
            else
            {
                // never ... selected
                noteSummaryResult.Append("\r\n - " + MedicationName + " Usage Status\r\n");
                                
                if (MedicationName.ToLower().Contains("mitoxantrone"))
                {
                    noteSummaryResult.Append(writeMitoxantroneData());
                }               

                noteSummaryResult.Append("\t" + rblUseStatus.SelectedItem.Text + "\r\n");
            }
        }
        else
        {
            // not answered - shouldn't be possible
            noteSummaryResult.Append("\r\n - " + MedicationName + " Usage Status\r\n");
            noteSummaryResult.Append("\tN/A\r\n");
        }

        //MSCOE.AZATHIOPRINE.CURRENT DOSES TAKEN
        //MSCOE.AZATHIOPRINE.PAST DOSES TAKEN

        return noteSummaryResult.ToString();
    }
    #endregion

    private void setVisibility()
    {        
        // this is only called on Save, and the visibility of the med controls needs refreshed in this case.
        if (chkBoxCurrentUse.Checked)
            pnlCurrentTherapy.Style["display"] = "block";
        else
            pnlCurrentTherapy.Style["display"] = "none";

        if(chkBoxPastUse.Checked)
            pnlPastTherapy.Style["display"] = "block";
        else
            pnlPastTherapy.Style["display"] = "none";

        if (chkBoxAdverseEvents.Checked)
            pnlAdverseEvents.Style["display"] = "block";
        else
            pnlAdverseEvents.Style["display"] = "none";
    }

    private StringBuilder writeMitoxantroneData()
    {
        StringBuilder noteSummaryResult = new StringBuilder();

        // Put the Cardiotox portion here

        if (rblQCardioTox.SelectedItem != null)
        {
            noteSummaryResult.Append("\t" + LabelForQCardioTox.Text + "\r\n"); 
            noteSummaryResult.Append("\t\t" + rblQCardioTox.SelectedItem.Text + "\r\n");
            
            if (rblQCardioTox.SelectedItem.Text.ToLower().Contains("yes") &&
                (mysQCardioToxYes.MonthYearString.Length > 0 || cbQCardioToxDateUnknown.Checked))
            {
                noteSummaryResult.Append("\t" + mysQCardioToxYes.Label + "\r\n");

                if (mysQCardioToxYes.MonthYearString.Length > 0)//                           
                {
                    noteSummaryResult.Append("\t\t" + mysQCardioToxYes.MonthYearString + "\r\n");
                }
                else if (cbQCardioToxDateUnknown.Checked)
                {
                    noteSummaryResult.Append("\t\t" + cbQCardioToxDateUnknown.Text + "\r\n");
                }
            }
        }

        return noteSummaryResult;
    }


    public void enableCardiotoxPanel(bool enable, string cardioToxText, string cardioToxYesText, string CardioToxDateUnknownText)
    {
        pnlCardiotox.Visible = enable;

        LabelForQCardioTox.Text = cardioToxText;
        mysQCardioToxYes.Label = cardioToxYesText;
        cbQCardioToxDateUnknown.Text = CardioToxDateUnknownText;

        mysQCardioToxYes.populateDateTimeLists();
    }

    #region getters and setters for Cardiotox
    public void hideCardioToxPanel()
    {
        pnlQCardioToxYes.Style["display"] = "none";
    }

    public void setRbQCardioTox(string val)
    {
        if (!String.IsNullOrEmpty(val))
        {
            rblQCardioTox.SelectedValue = val;

            if (rblQCardioTox.SelectedItem.Text.ToLower().Contains("yes"))
            {
                // show pnlQCardioToxYes
                pnlQCardioToxYes.Style["display"] = "block";
            }
            else
            {
                pnlQCardioToxYes.Style["display"] = "none";
            }
        }
        else
        {
            rblQCardioTox.SelectedIndex = -1;
            pnlQCardioToxYes.Style["display"] = "none";
            mysQCardioToxYes.MonthYearString = "";
        }
    }

    public int getRbQCardioToxSelectedIndex()
    {
        return rblQCardioTox.SelectedIndex;
    }

    public string getRbQCardioToxSelectedValue()
    {
        string val = "";

        if (rblQCardioTox.SelectedValue != null)
            val = rblQCardioTox.SelectedValue;

        return val;
    }

    public string getRbQCardioToxSelectedItem()
    {
        string val = "";

        if (rblQCardioTox.SelectedItem != null)
            val = rblQCardioTox.SelectedItem.Text;

        return val;
    }

    public string getCbQCardioToxDateUnknown()
    {
        string val = "";

        if (cbQCardioToxDateUnknown.Checked)
            val = "true";
        else
            val = "false";

        return val;
    }

    public void setCbQCardioToxDateUnknown(string s)
    {
        if (s == "true")
            cbQCardioToxDateUnknown.Checked = true;
        else
            cbQCardioToxDateUnknown.Checked = false;
    }

    public void setTxtQCardioToxDate(string s)
    {
        mysQCardioToxYes.MonthYearString = s;
    }

    public string getTxtQCardioToxDateText()
    {
        return mysQCardioToxYes.MonthYearString;
    }
    #endregion

    public void enableNumberOfDoses(bool b)
    {
        pnlCurrentNumberOfDosesTaken.Visible = b;
        pnlPastNumberOfDosesTaken.Visible = b;
    }

  

    #region Protected Methods

    /// <summary>
    /// Default Page_Load Method
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            
            populateUseStatusList();
            setValidatorSettings();

            RequiredFieldValidatorUseStatus.ErrorMessage = this.MedicationName + " Use Status Selection is required.";
            RequiredFieldValidatorCurPastUseAdvrs.ErrorMessage = this.MedicationName + " Past use, Current use or Adverse event selection is required.";

            if (Helpers.DeSerializSessionItems(Session["IsFirstTimeSurvey"]) != null && Helpers.DeSerializSessionItems(Session["IsFirstTimeSurvey"]).ToLower() == "yes")
            {
                SetMedicationSelectionForFirstTimeSurvey();
            }

            if (MedicationName.ToLower().Contains("other"))
            {
                pnlOtherDMT.Visible = true;
            }
            else
            {
                pnlOtherDMT.Visible = false;
            }

            if (rblUseStatus.SelectedIndex == -1)
            {
                // Never, hide everything
                pnlCurrentPastUse.Style["display"] = "none";
                pnlCurrentTherapy.Style["display"] = "none";
                pnlPastTherapy.Style["display"] = "none";
                pnlAdverseEvents.Style["display"] = "none";
            }
            else
            {
                if (!chkBoxCurrentUse.Checked)
                {
                    pnlCurrentTherapy.Style["display"] = "none";
                }

                if (!chkBoxPastUse.Checked)
                {
                    pnlPastTherapy.Style["display"] = "none";
                }

                if (!chkBoxAdverseEvents.Checked)
                {
                    pnlAdverseEvents.Style["display"] = "none";
                }
            }
            
        }
        if (rblPastReasonStopped.SelectedIndex > -1)
        {
            if (rblPastReasonStopped.SelectedItem.ToString().ToLower().Contains("significant adverse"))
            {
                pnlSignificantAdverseEventDescription.Style["display"] = "block";
                pnlOtherReasonStopped.Style["display"] = "none";
            }
            else if (rblPastReasonStopped.SelectedItem.ToString().ToLower().Contains("other"))
            {
                pnlSignificantAdverseEventDescription.Style["display"] = "none";
                pnlOtherReasonStopped.Style["display"] = "block";
            }
            else
            {
                pnlSignificantAdverseEventDescription.Style["display"] = "none";
                pnlOtherReasonStopped.Style["display"] = "none";
            }
        }
        else
        {
            pnlSignificantAdverseEventDescription.Style["display"] = "none";
            pnlOtherReasonStopped.Style["display"] = "none";
        }

        if (!(rblUseStatus.SelectedItem == null))
            if (rblUseStatus.SelectedItem.Text.Equals("Current Use / Past Use", StringComparison.OrdinalIgnoreCase))
            {
                pnlCurrentPastUse.Style["display"] = "block";
                setVisibility();
            }  
    }

    #endregion

    #region Private Methods

    /// <summary>
    /// populateUseStatusList - populates sub controls.
    /// </summary>
    private void populateUseStatusList()
    {
        using (MSSRDataClassesDataContext ctx = new MSSRDataClassesDataContext())
        {
            rblUseStatus.DataSource = ctx.MSSR_MEDICATION_USED_STATUS;
            rblUseStatus.DataBind();

            
            rblCurrentDispensingPharmacy.DataSource = ctx.MSSR_DISPENSING_PHARMACies;
            rblCurrentDispensingPharmacy.DataBind();

            rblPastDispensingPharmacy.DataSource = ctx.MSSR_DISPENSING_PHARMACies;
            rblPastDispensingPharmacy.DataBind();

            var reasons = (from mrs in ctx.MSSR_MEDICATION_REASON_STOPPEDs
                           join mtrs in ctx.MSSR_MEDICATION_TO_REASON_STOPPEDs on mrs.ID equals mtrs.MSSR_MEDICATION_REASON_STOPPED_ID
                           join m in ctx.MSSR_MEDICATIONs on mtrs.MSSR_MEDICATION_ID equals m.ID
                           where m.ID == MedicationId
                           && mrs.Extention_Parent_ID != 2
                           && mrs.PARENT_ID != 2
                           select mrs).ToList();

            rblPastReasonStopped.DataSource = reasons;
            rblPastReasonStopped.DataBind();

            var adverseEvents = (from mrs in ctx.MSSR_MEDICATION_REASON_STOPPEDs
                                      join mtrs in ctx.MSSR_MEDICATION_TO_REASON_STOPPEDs on mrs.ID equals mtrs.MSSR_MEDICATION_REASON_STOPPED_ID
                                      join m in ctx.MSSR_MEDICATIONs on mtrs.MSSR_MEDICATION_ID equals m.ID
                                      where m.ID == MedicationId
                                      && mrs.Extention_Parent_ID != 2
                                      && mrs.PARENT_ID == 2
                                      select mrs).ToList();

            rblAdverseEvents.DataSource = adverseEvents;
            rblAdverseEvents.DataBind();

            // Add the extension to Intolerance
            foreach (System.Web.UI.WebControls.ListItem name in rblPastReasonStopped.Items)
            {
                if (name.Text.ToLower() == "intolerance to medication")
                {
                    ctx.MSSR_MEDICATION_TO_REASON_STOPPEDs.Where(R => R.MSSR_MEDICATION_ID == MedicationId);

                    var ext = (from mrs in ctx.MSSR_MEDICATION_REASON_STOPPEDs
                               join mtrs in ctx.MSSR_MEDICATION_TO_REASON_STOPPEDs on mrs.ID equals mtrs.MSSR_MEDICATION_REASON_STOPPED_ID
                               join m in ctx.MSSR_MEDICATIONs on mtrs.MSSR_MEDICATION_ID equals m.ID
                               where m.ID == MedicationId
                               && mrs.Extention_Parent_ID == 2
                               select mrs.REASON_STOPPED).FirstOrDefault();

                    if (ext != null)
                    {
                        name.Text += " " + ext.ToString();
                    }
                }
            }          


        }
    }

    private void setValidatorSettings()
    {
        if (mysCurrentApproximateDateStarted.Label != "Approximate date started:")
        {
            mysCurrentApproximateDateStarted.populateDateTimeLists();
            mysCurrentApproximateDateStarted.Label = "Approximate date started:";

            mysPastDateStarted.populateDateTimeLists();
            mysPastDateStarted.Label = "Approximate date started:";

            mysPastDateStopped.populateDateTimeLists();
            mysPastDateStopped.Label = "Approximate date stopped:";
        }
    }

    protected void ValidatePastUseCurrentUseAdverse(object source, ServerValidateEventArgs args)
    {
        if (rblUseStatus.SelectedItem.Text.Equals("Current Use / Past Use", StringComparison.OrdinalIgnoreCase))
        {
            if (chkBoxCurrentUse.Checked == false && chkBoxPastUse.Checked == false && chkBoxAdverseEvents.Checked == false)
            {
                args.IsValid = false;
                pnlCurrentPastUse.Style["display"] = "block";
            }
        }    
    }

    public void SetMedicationSelectionForFirstTimeSurvey()
    {
       rblUseStatus.SelectedIndex = 0;
       pnlCurrentPastUse.Style["display"] = "none";
    }

    protected void ValidatePastUseMedStartStopDate(object source, ServerValidateEventArgs args)
    {
        if (!String.IsNullOrEmpty(mysPastDateStarted.MonthYearString) && !string.IsNullOrEmpty(mysPastDateStopped.MonthYearString))
        {
            if (!IsDateValid(mysPastDateStarted.MonthYearString, mysPastDateStopped.MonthYearString))
            {
                args.IsValid = false;
                CustomValidatorMedStartStopDate.ErrorMessage = "Invalid date. Start/Stop Date. Please Verify.";
            }
            string stoppedDate = FormatDate(mysPastDateStopped.MonthYearString);
            string startedDate = FormatDate(mysPastDateStarted.MonthYearString);
            if (IsStartDateLaterthanStopDate(startedDate, stoppedDate))
            {
                args.IsValid = false;
                CustomValidatorMedStartStopDate.ErrorMessage = "Start date is later than stop date. ";
            }
        }
    }

    protected string FormatDate(string pDate)
    {
        return pDate.Insert(pDate.IndexOf("/") + 1, "01/");

    }
    protected bool IsDateValid(string pStartDate, string pStoppedDate)
    {
        bool isDateValid = false;
        if ((pStoppedDate.Length > 7 || pStoppedDate.Length < 6)
                    || (pStartDate.Length > 7 || pStartDate.Length < 6))
        {
            isDateValid = false;
        }
        else
        { isDateValid = true; }

        return isDateValid;

    }

    protected bool IsStartDateLaterthanStopDate(string pStartDate, string pStopDate)
    {
        DateTime startDate;
        DateTime stopDate;
        int dateComResult = 0;
        bool startdateIsValid = DateTime.TryParse(pStartDate, out startDate);
        bool stopDateIsValid = DateTime.TryParse(pStopDate, out stopDate);

        if (startdateIsValid && stopDateIsValid)
        {
            dateComResult = DateTime.Compare(startDate, stopDate);
        }

        return dateComResult > 0;

    }
    #endregion
}