﻿using System;
using System.Linq;
using VeteransAffairs.Registries.Business;
using System.Web.UI.WebControls;

public partial class controls_CorticosteroidsMedicationSelection : System.Web.UI.UserControl {

    #region Public Member Variables

    public STD_QUESTION CORT { get; set; }

    public STD_QUESTION CORTCU { get; set; }

    public STD_QUESTION CORTCUIVDexPharm { get; set; }
    public STD_QUESTION CORTCUIVDexSchedule { get; set; }
    public STD_QUESTION CORTCUIVDexApproxStarted { get; set; }
    public STD_QUESTION CORTCUIVDexScheduleOther { get; set; }

    public STD_QUESTION CORTCUIVMethPharm { get; set; }
    public STD_QUESTION CORTCUIVMethSchedule { get; set; }
    public STD_QUESTION CORTCUIVMethApproxStarted { get; set; }
    public STD_QUESTION CORTCUIVMethScheduleOther { get; set; }

    public STD_QUESTION CORTCUOralMethPharm { get; set; }
    public STD_QUESTION CORTCUOralMethSchedule { get; set; }
    public STD_QUESTION CORTCUOralMethApproxStarted { get; set; }
    public STD_QUESTION CORTCUOralMethScheduleOther { get; set; }

    public STD_QUESTION CORTCUOralPredPharm { get; set; }
    public STD_QUESTION CORTCUOralPredSchedule { get; set; }
    public STD_QUESTION CORTCUOralPredScheduleOther { get; set; }
    public STD_QUESTION CORTCUOralPredApproxStarted { get; set; }

    // Past
    public STD_QUESTION CORTPU { get; set; }

    public STD_QUESTION CORTPUIVDexPharm { get; set; }
    public STD_QUESTION CORTPUIVDexSchedule { get; set; }
    public STD_QUESTION CORTPUIVDexScheduleOther { get; set; }
    public STD_QUESTION CORTPUIVDexApproxStopped { get; set; }
    public STD_QUESTION CORTPUIVDexApproxStarted { get; set; }

    public STD_QUESTION CORTPUIVMethPharm { get; set; }
    public STD_QUESTION CORTPUIVMethSchedule { get; set; }
    public STD_QUESTION CORTPUIVMethScheduleOther { get; set; }
    public STD_QUESTION CORTPUIVMethApproxStarted { get; set; }
    public STD_QUESTION CORTPUIVMethApproxStopped { get; set; }


    public STD_QUESTION CORTPUOralMethPharm { get; set; }
    public STD_QUESTION CORTPUOralMethSchedule { get; set; }
    public STD_QUESTION CORTPUOralMethScheduleOther { get; set; }
    public STD_QUESTION CORTPUOralMethApproxStopped { get; set; }
    public STD_QUESTION CORTPUOralMethApproxStarted { get; set; }

    public STD_QUESTION CORTPUOralPredPharm { get; set; }
    public STD_QUESTION CORTPUOralPredSchedule { get; set; }
    public STD_QUESTION CORTPUOralPredScheduleOther { get; set; }
    public STD_QUESTION CORTPUOralPredApproxStopped { get; set; }
    public STD_QUESTION CORTPUOralPredApproxStarted { get; set; }

    public STD_QUESTION CORTPUIVDexScheduleTtlTmExpsrInMnt { get; set; }
    public STD_QUESTION CORTPUIVMethScheduleTtlTmExpsrInMnt { get; set; }
    public STD_QUESTION CORTPUOralMethScheduleTtlTmExpsrInMnt { get; set; }
    public STD_QUESTION CORTPUOralPredScheduleTtlTmExpsrInMnt { get; set; }

    public short StartTabIndex
    {
        set
        {
            lblMedicationName.TabIndex = value;
            rblCortUseStatus.TabIndex = (short)(value + 1);
            RequiredFieldValidatorUseStatus.TabIndex = (short)(value + 2);
            chkBoxCurrentUse.TabIndex = (short)(value + 3);
            LabelForDexamethasoneIV.TabIndex = (short)(value + 4);
            //LabelForCORTCUIVDexPharm.TabIndex = (short)(value + 5);
            rblCORTCUIVDexPharm.TabIndex = (short)(value + 6);
            //LabelForCORTCUIVDexSchedule.TabIndex = (short)(value + 7);
            rblCORTCUIVDexSchedule.TabIndex = (short)(value + 8);
            txtCORTCUIVDexScheduleOther.TabIndex = (short)(value + 9);
            //LabelForCORTCUIVDexApproxStarted.TabIndex = (short)(value + 9);
            //txtCORTCUIVDexApproxStarted.TabIndex = (short)(value + 10);
            LabelForMethylprednisoloneIV.TabIndex = (short)(value + 11);
            //LabelForCORTCUIVMethPharm.TabIndex = (short)(value + 12);
            rblCORTCUIVMethPharm.TabIndex = (short)(value + 13);
            //LabelForCORTCUIVMethSchedule.TabIndex = (short)(value + 14);
            rblCORTCUIVMethSchedule.TabIndex = (short)(value + 15);
            txtCORTCUIVMethScheduleOther.TabIndex = (short)(value + 16);
            //LabelForCORTCUIVMethApproxStarted.TabIndex = (short)(value + 16);
            //txtCORTCUIVMethApproxStarted.TabIndex = (short)(value + 17);
            LabelForMethylprednisolonePO.TabIndex = (short)(value + 18);
            //LabelForCORTCUOralMethPharm.TabIndex = (short)(value + 19);
            rblCORTCUOralMethPharm.TabIndex = (short)(value + 20);
            //LabelForCORTCUOralMethSchedule.TabIndex = (short)(value + 21);
            rblCORTCUOralMethSchedule.TabIndex = (short)(value + 22);
            //LabelForCORTCUOralMethApproxStarted.TabIndex = (short)(value + 23);
            //txtCORTCUOralMethApproxStarted.TabIndex = (short)(value + 24);
            txtCORTCUOralMethScheduleOther.TabIndex = (short)(value + 23);
            LabelForPrednisonePO.TabIndex = (short)(value + 25);
            //LabelForCORTCUOralPredPharm.TabIndex = (short)(value + 26);
            rblCORTCUOralPredPharm.TabIndex = (short)(value + 27);
            //LabelForCORTCUOralPredSchedule.TabIndex = (short)(value + 28);
            rblCORTCUOralPredSchedule.TabIndex = (short)(value + 29);
            txtCORTCUOralPredScheduleOther.TabIndex = (short)(value + 29);
            //LabelForCORTCUOralPredApproxStarted.TabIndex = (short)(value + 30);
            //txtCORTCUOralPredApproxStarted.TabIndex = (short)(value + 31);
            chkBoxPastUse.TabIndex = (short)(value + 32);
            LabelForPastDexamethasoneIV.TabIndex = (short)(value + 33);
            //LabelForCORTPUIVDexPharm.TabIndex = (short)(value + 34);
            rblCORTPUIVDexPharm.TabIndex = (short)(value + 35);
            //LabelForCORTPUIVDexSchedule.TabIndex = (short)(value + 36);
            rblCORTPUIVDexSchedule.TabIndex = (short)(value + 37);
            //LabelForCORTPUIVDexApproxStopped.TabIndex = (short)(value + 38);
            //txtCORTPUIVDexApproxStopped.TabIndex = (short)(value + 39);
            LabelForPastMethylprednisoloneIV.TabIndex = (short)(value + 40);
            //LabelForCORTPUIVMethPharm.TabIndex = (short)(value + 41);
            rblCORTPUIVMethPharm.TabIndex = (short)(value + 42);
            //LabelForCORTPUIVMethSchedule.TabIndex = (short)(value + 43);
            rblCORTPUIVMethSchedule.TabIndex = (short)(value + 44);
            //LabelForCORTPUIVMethApproxStopped.TabIndex = (short)(value + 45);
            //txtCORTPUIVMethApproxStopped.TabIndex = (short)(value + 46);
            LabelForPastMethylprednisolonePO.TabIndex = (short)(value + 47);
            //LabelForCORTPUOralMethPharm.TabIndex = (short)(value + 48);
            rblCORTPUOralMethPharm.TabIndex = (short)(value + 49);
            //LabelForCORTPUOralMethSchedule.TabIndex = (short)(value + 50);
            rblCORTPUOralMethSchedule.TabIndex = (short)(value + 51);
            //LabelForCORTCUOralMethApproxStopped.TabIndex = (short)(value + 52);
            //txtCORTPUOralMethApproxStopped.TabIndex = (short)(value + 53);
            LabelForPastPrednisonePO.TabIndex = (short)(value + 54);
            //LabelForCORTPUOralPredPharm.TabIndex = (short)(value + 55);
            rblCORTPUOralPredPharm.TabIndex = (short)(value + 56);
            //LabelForCORTPUOralPredSchedule.TabIndex = (short)(value + 57);
            rblCORTPUOralPredSchedule.TabIndex = (short)(value + 58);
            //LabelForCORTPUOralPredApproxStopped.TabIndex = (short)(value + 59);
            //txtCORTPUOralPredApproxStopped.TabIndex = (short)(value + 60);
        }
    }

    #endregion

    #region Public Methods

    /// <summary>
    /// Initializes data and populates structures - called from parent.
    /// </summary>
    public void InitializeData() {
        populateUseStatusList();
    } 
    
    /// <summary>
    /// checks for data errors with Corticosteriods
    /// </summary>
    public string ValidateData()
    {
        string errorMessage = "";

        if (rblCORTCUIVDexSchedule.SelectedItem != null &&
            rblCORTCUIVDexSchedule.SelectedItem.Text.ToLower().Contains("other") &&
            txtCORTCUIVDexScheduleOther.Text.Trim().Length == 0)
        {
            errorMessage += "Current Use: IV Route - Dexamethasone IV (Decadron): Other Schedule Text is required. \r\n";
        }

        if (rblCORTCUIVMethSchedule.SelectedItem != null &&
            rblCORTCUIVMethSchedule.SelectedItem.Text.ToLower().Contains("other") &&
            txtCORTCUIVMethScheduleOther.Text.Trim().Length == 0)
        {
            errorMessage += "Current Use: IV Route - Methylprednisolone IV (Solumedrol) : Other Schedule Text is required. \r\n";
        }

        if (rblCORTCUOralMethSchedule.SelectedItem != null &&
            rblCORTCUOralMethSchedule.SelectedItem.Text.ToLower().Contains("other") &&
            txtCORTCUOralMethScheduleOther.Text.Trim().Length == 0)
        {
            errorMessage += "Current Use: Oral Route - Methylprednisolone PO (Medrol): Other Schedule Text is required. \r\n";
        }

        if (rblCORTCUOralPredSchedule.SelectedItem != null &&
            rblCORTCUOralPredSchedule.SelectedItem.Text.ToLower().Contains("other") &&
            txtCORTCUOralPredScheduleOther.Text.Trim().Length == 0)
        {
            errorMessage += "Current Use: Oral Route - Prednisone PO: Other Schedule Text is required. \r\n";
        }

        if (rblCORTPUIVDexSchedule.SelectedItem != null &&
            rblCORTPUIVDexSchedule.SelectedItem.Text.ToLower().Contains("other") &&
            txtCORTPUIVDexScheduleOther.Text.Trim().Length == 0)
        {
            errorMessage += "Past Use: IV Route - Dexamethasone IV (Decadron): Other Schedule Text is required. \r\n";
        }

        if (rblCORTPUIVMethSchedule.SelectedItem != null &&
            rblCORTPUIVMethSchedule.SelectedItem.Text.ToLower().Contains("other") &&
            txtCORTPUIVMethScheduleOther.Text.Trim().Length == 0)
        {
            errorMessage += "Past Use: IV Route - Methylprednisolone IV (Solumedrol): Other Schedule Text is required. \r\n";
        }

        if (rblCORTPUOralMethSchedule.SelectedItem != null &&
            rblCORTPUOralMethSchedule.SelectedItem.Text.ToLower().Contains("other") &&
            txtCORTPUOralMethScheduleOther.Text.Trim().Length == 0)
        {
            errorMessage += "Past Use: Oral Route - Methylprednisolone PO (Medrol): Other Schedule Text is required. \r\n";
        }

        if (rblCORTPUOralPredSchedule.SelectedItem != null &&
            rblCORTPUOralPredSchedule.SelectedItem.Text.ToLower().Contains("other") &&
            txtCORTPUOralPredScheduleOther.Text.Trim().Length == 0)
        {
            errorMessage += "Past Use: Oral Route - Prednisone PO: Other Schedule Text is required. \r\n";
        }

        return errorMessage;
    }


    /// <summary>
    /// TODO: Placeholder - implement.  Will accept survey from SaveSurvey method and add "filled-in" selections.
    /// </summary>
    /// <param name="survey"></param>
    public void UpdateSurveyWithCorticosteroidSelections(ref SURVEY survey) {
        SURVEY_RESULT _surveyResult;

        #region CORT

        // CORT
        if (rblCortUseStatus.SelectedIndex > -1) {
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add CORT
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblCortUseStatus.SelectedValue);
                _surveyResult.RESULT_TEXT = rblCortUseStatus.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                throw surveyEx;
            }
        }
        #endregion

        #region CORTCU

        _surveyResult = new SURVEY_RESULT();

        try {
            // Add CORTCU
            _surveyResult.STD_QUESTION_CHOICE_ID = CORTCU.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
            _surveyResult.RESULT_TEXT = (chkBoxCurrentUse.Checked ? "Yes" : "No");
            survey.SURVEY_RESULTs.Add(_surveyResult);
        } catch (Exception surveyEx) {
            Logging.WriteLogToFile("Failure in UpdateSurveyWithCorticosteroidSelections-CORTCU: " + surveyEx.Message);
        }

        #endregion

        #region CORTCUIVDexPharm

        // CORTCUIVDexPharm
        if (rblCORTCUIVDexPharm.SelectedIndex > -1) {
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add CORTCUIVDexPharm
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblCORTCUIVDexPharm.SelectedValue);
                _surveyResult.RESULT_TEXT = rblCORTCUIVDexPharm.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Logging.WriteLogToFile("Failure in UpdateSurveyWithCorticosteroidSelections-CORTCUIVDexPharm: " + surveyEx.Message);
            }
        }

        #endregion

        #region CORTCUIVDexSchedule

        //CORTCUIVDexSchedule
        if (rblCORTCUIVDexSchedule.SelectedIndex > -1) {
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add CORTCUIVDexSchedule
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblCORTCUIVDexSchedule.SelectedValue);
                _surveyResult.RESULT_TEXT = rblCORTCUIVDexSchedule.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Logging.WriteLogToFile("Failure in UpdateSurveyWithCorticosteroidSelections-CORTCUIVDexSchedule: " + surveyEx.Message);
            }
        }

        #endregion

        #region txtCORTCUIVDexScheduleOther

        // Question txtCORTCUIVDexScheduleOther
        if (!String.IsNullOrEmpty(txtCORTCUIVDexScheduleOther.Text))
        {
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 
                _surveyResult.STD_QUESTION_CHOICE_ID = CORTCUIVDexScheduleOther.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = txtCORTCUIVDexScheduleOther.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Logging.WriteLogToFile("Failure in UpdateSurveyWithCorticosteroidSelections-CORTCUIVDexScheduleOther: " + surveyEx.Message);

            }
        }

        #endregion

        #region CORTCUIVDexApproxStarted

        // Question CORTCUIVDexApproxStarted
        if (!String.IsNullOrEmpty(mysCORTCUIVDexApproxStarted.MonthYearString))
        {
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add Question 9DateTran choice
                _surveyResult.STD_QUESTION_CHOICE_ID = CORTCUIVDexApproxStarted.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = mysCORTCUIVDexApproxStarted.MonthYearString;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Logging.WriteLogToFile("Failure in UpdateSurveyWithCorticosteroidSelections-CORTCUIVDexApproxStarted: " + surveyEx.Message);
                
            }
        }

        #endregion

        #region CORTCUIVMethPharm

        // CORTCUIVMethPharm
        if (rblCORTCUIVMethPharm.SelectedIndex > -1) {
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add CORTCUIVMethPharm
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblCORTCUIVMethPharm.SelectedValue);
                _surveyResult.RESULT_TEXT = rblCORTCUIVMethPharm.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Logging.WriteLogToFile("Failure in UpdateSurveyWithCorticosteroidSelections-CORTCUIVMethPharm: " + surveyEx.Message);

            }
        }

        #endregion

        #region CORTCUIVMethSchedule

        //CORTCUIVMethSchedule
        if (rblCORTCUIVMethSchedule.SelectedIndex > -1) {
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add CORTCUIVMethSchedule
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblCORTCUIVMethSchedule.SelectedValue);
                _surveyResult.RESULT_TEXT = rblCORTCUIVMethSchedule.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Logging.WriteLogToFile("Failure in UpdateSurveyWithCorticosteroidSelections-CORTCUIVMethSchedule: " + surveyEx.Message);
            }
        }

        #region txtCORTCUIVMethScheduleOther

        // Question txtCORTCUIVMethScheduleOther
        if (!String.IsNullOrEmpty(txtCORTCUIVMethScheduleOther.Text))
        {
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 
                _surveyResult.STD_QUESTION_CHOICE_ID = CORTCUIVMethScheduleOther.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = txtCORTCUIVMethScheduleOther.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Logging.WriteLogToFile("Failure in UpdateSurveyWithCorticosteroidSelections-CORTCUIVMethScheduleOther: " + surveyEx.Message);
            }
        }

        #endregion

        #region CORTCUIVMethApproxStarted

        // Question CORTCUIVMethApproxStarted
        if (!String.IsNullOrEmpty(mysCORTCUIVMethApproxStarted.MonthYearString))
        {
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add Question CORTCUIVMethApproxStarted choice
                _surveyResult.STD_QUESTION_CHOICE_ID = CORTCUIVMethApproxStarted.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = mysCORTCUIVMethApproxStarted.MonthYearString;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Logging.WriteLogToFile("Failure in UpdateSurveyWithCorticosteroidSelections-CORTCUIVMethApproxStarted: " + surveyEx.Message);

            }
        }

        #endregion

        #region CORTCUOralMethPharm

        // CORTCUOralMethPharm
        if (rblCORTCUOralMethPharm.SelectedIndex > -1) {
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add CORTCUOralMethPharm
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblCORTCUOralMethPharm.SelectedValue);
                _surveyResult.RESULT_TEXT = rblCORTCUOralMethPharm.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Logging.WriteLogToFile("Failure in UpdateSurveyWithCorticosteroidSelections-CORTCUOralMethPharm: " + surveyEx.Message);

            }
        }

        #endregion

        #region CORTCUOralMethSchedule

        //CORTCUOralMethSchedule
        if (rblCORTCUOralMethSchedule.SelectedIndex > -1) {
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add CORTCUOralMethSchedule
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblCORTCUOralMethSchedule.SelectedValue);
                _surveyResult.RESULT_TEXT = rblCORTCUOralMethSchedule.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Logging.WriteLogToFile("Failure in UpdateSurveyWithCorticosteroidSelections-CORTCUOralMethSchedule: " + surveyEx.Message);

            }
        }

        #endregion

        #region txtCORTCUIVMethScheduleOther

        // Question txtCORTCUOralMethScheduleOther
        if (!String.IsNullOrEmpty(txtCORTCUOralMethScheduleOther.Text))
        {
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 
                _surveyResult.STD_QUESTION_CHOICE_ID = CORTCUOralMethScheduleOther.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = txtCORTCUOralMethScheduleOther.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Logging.WriteLogToFile("Failure in UpdateSurveyWithCorticosteroidSelections-CORTCUOralMethScheduleOther: " + surveyEx.Message);
            }
        }

        #endregion

        #endregion

        #region CORTCUOralMethApproxStarted

        // Question CORTCUOralMethApproxStarted
        if (!String.IsNullOrEmpty(mysCORTCUOralMethApproxStarted.MonthYearString))
        {
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add Question CORTCUOralMethApproxStarted choice
                _surveyResult.STD_QUESTION_CHOICE_ID = CORTCUOralMethApproxStarted.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = mysCORTCUOralMethApproxStarted.MonthYearString;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Logging.WriteLogToFile("Failure in UpdateSurveyWithCorticosteroidSelections-CORTCUOralMethApproxStarted: " + surveyEx.Message);

            }
        }

        #endregion

        #region CORTCUOralPredPharm

        // CORTCUOralPredPharm
        if (rblCORTCUOralPredPharm.SelectedIndex > -1) {
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add CORTCUOralPredPharm
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblCORTCUOralPredPharm.SelectedValue);
                _surveyResult.RESULT_TEXT = rblCORTCUOralPredPharm.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Logging.WriteLogToFile("Failure in UpdateSurveyWithCorticosteroidSelections-CORTCUOralPredPharm: " + surveyEx.Message);

            }
        }

        #endregion

        #region CORTCUOralPredSchedule

        //CORTCUOralPredSchedule
        if (rblCORTCUOralPredSchedule.SelectedIndex > -1) {
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add CORTCUOralPredSchedule
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblCORTCUOralPredSchedule.SelectedValue);
                _surveyResult.RESULT_TEXT = rblCORTCUOralPredSchedule.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Logging.WriteLogToFile("Failure in UpdateSurveyWithCorticosteroidSelections-CORTCUOralPredSchedule: " + surveyEx.Message);

            }
        }

        #endregion

        #region txtCORTCUOralPredScheduleOther

        // Question txtCORTCUOralMethScheduleOther
        if (!String.IsNullOrEmpty(txtCORTCUOralPredScheduleOther.Text))
        {
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 
                _surveyResult.STD_QUESTION_CHOICE_ID = CORTCUOralPredScheduleOther.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = txtCORTCUOralPredScheduleOther.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Logging.WriteLogToFile("Failure in UpdateSurveyWithCorticosteroidSelections-CORTCUOralPredScheduleOther: " + surveyEx.Message);
            }
        }

        #endregion

        #region CORTCUOralPredApproxStarted

        // Question CORTCUOralPredApproxStarted
        if (!String.IsNullOrEmpty(mysCORTCUOralPredApproxStarted.MonthYearString))
        {
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add Question CORTCUOralPredApproxStarted choice
                _surveyResult.STD_QUESTION_CHOICE_ID = CORTCUOralPredApproxStarted.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = mysCORTCUOralPredApproxStarted.MonthYearString;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Logging.WriteLogToFile("Failure in UpdateSurveyWithCorticosteroidSelections-CORTCUOralPredApproxStarted: " + surveyEx.Message);

            }
        }

        #endregion

        #region CORTPU

        _surveyResult = new SURVEY_RESULT();

        try {
            // Add CORTPU
            _surveyResult.STD_QUESTION_CHOICE_ID = CORTPU.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
            _surveyResult.RESULT_TEXT = (chkBoxPastUse.Checked ? "Yes" : "No");
            survey.SURVEY_RESULTs.Add(_surveyResult);
        }
        catch (Exception surveyEx)
        {
            Logging.WriteLogToFile("Failure in UpdateSurveyWithCorticosteroidSelections-CORTPU: " + surveyEx.Message);

        }

        #endregion

        #region CORTPUIVDexPharm

        // CORTPUIVDexPharm
        if (rblCORTPUIVDexPharm.SelectedIndex > -1) {
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add CORTPUIVDexPharm
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblCORTPUIVDexPharm.SelectedValue);
                _surveyResult.RESULT_TEXT = rblCORTPUIVDexPharm.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Logging.WriteLogToFile("Failure in UpdateSurveyWithCorticosteroidSelections-CORTPUIVDexPharm: " + surveyEx.Message);

            }
        }

        #endregion

        #region CORTPUIVDexSchedule

        //CORTPUIVDexSchedule
        if (rblCORTPUIVDexSchedule.SelectedIndex > -1) {
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add CORTPUIVDexSchedule
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblCORTPUIVDexSchedule.SelectedValue);
                _surveyResult.RESULT_TEXT = rblCORTPUIVDexSchedule.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Logging.WriteLogToFile("Failure in UpdateSurveyWithCorticosteroidSelections-CORTPUIVDexSchedule: " + surveyEx.Message);

            }
        }

        #endregion

        #region txtPUIVDexScheduleScheduleOther

        // Question txtCORTCUOralMethScheduleOther
        if (!String.IsNullOrEmpty(txtCORTPUIVDexScheduleOther.Text))
        {
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 
                _surveyResult.STD_QUESTION_CHOICE_ID = CORTPUIVDexScheduleOther.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = txtCORTPUIVDexScheduleOther.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Logging.WriteLogToFile("Failure in UpdateSurveyWithCorticosteroidSelections-CORTCUOralPredScheduleOther: " + surveyEx.Message);
            }
        }

        #endregion

        #region CORTPUIVDexApproxStopped

        // Question CORTPUIVDexApproxStopped
        if (!String.IsNullOrEmpty(mysCORTPUIVDexApproxStopped.MonthYearString))
        {
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add Question CORTPUIVDexApproxStopped choice
                _surveyResult.STD_QUESTION_CHOICE_ID = CORTPUIVDexApproxStopped.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = mysCORTPUIVDexApproxStopped.MonthYearString;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Logging.WriteLogToFile("Failure in UpdateSurveyWithCorticosteroidSelections-CORTPUIVDexApproxStopped: " + surveyEx.Message);

            }
        }

        #endregion

        #region CORTPUIVDexApproxStarted
        // Question CORTPUIVDexApproxStarted - Dexamethasone app start date
        if (!String.IsNullOrEmpty(mysCORTPUIVDexApproxStarted.MonthYearString))
        {
            _surveyResult = new SURVEY_RESULT();
            try
            {
                // Add Question CORTPUIVDexApproxStarted choice
                _surveyResult.STD_QUESTION_CHOICE_ID = CORTPUIVDexApproxStarted.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = mysCORTPUIVDexApproxStarted.MonthYearString;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Logging.WriteLogToFile("Failure in UpdateSurveyWithCorticosteroidSelections-CORTPUIVDexApproxStarted: " + surveyEx.Message);
            }
        }

        #endregion

        #region CORTPUIVMethApproxStopped
        if (!string.IsNullOrEmpty(mysCORTPUIVMethApproxStopped.MonthYearString))
        {
            _surveyResult = new SURVEY_RESULT();
            try
            {
                _surveyResult.STD_QUESTION_CHOICE_ID = CORTPUIVMethApproxStopped.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = mysCORTPUIVMethApproxStopped.MonthYearString;
                survey.SURVEY_RESULTs.Add(_surveyResult);

            }
            catch (Exception surveyEx)
            {
                Logging.WriteLogToFile("Failure in UpdateSurveyWithCorticosteroidSelections-CORTPUIVMethApproxStopped: " + surveyEx.Message); ;
            }
        }

        #endregion 

        #region CORTPUIVMethApproxStarted
        // Question CORTPUIVMethApproxStarted - Dexamethasone app start date
        if (!String.IsNullOrEmpty(mysCORTPUIVMethApproxStarted.MonthYearString))
        {
            _surveyResult = new SURVEY_RESULT();
            try
            {
                // Add Question CORTPUIVMethApproxStarted choice
                _surveyResult.STD_QUESTION_CHOICE_ID = CORTPUIVMethApproxStarted.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = mysCORTPUIVMethApproxStarted.MonthYearString;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Logging.WriteLogToFile("Failure in UpdateSurveyWithCorticosteroidSelections-CORTPUIVMethApproxStarted: " + surveyEx.Message);
            }
        }

        #endregion



        #region CORTPUIVMethPharm

        // CORTPUIVMethPharm
        if (rblCORTPUIVMethPharm.SelectedIndex > -1) {
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add CORTPUIVMethPharm
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblCORTPUIVMethPharm.SelectedValue);
                _surveyResult.RESULT_TEXT = rblCORTPUIVMethPharm.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Logging.WriteLogToFile("Failure in UpdateSurveyWithCorticosteroidSelections-CORTPUIVMethPharm: " + surveyEx.Message);

            }
        }

        #endregion

        #region CORTPUIVMethSchedule

        //CORTPUIVMethSchedule
        if (rblCORTPUIVMethSchedule.SelectedIndex > -1) {
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add CORTPUIVMethSchedule
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblCORTPUIVMethSchedule.SelectedValue);
                _surveyResult.RESULT_TEXT = rblCORTPUIVMethSchedule.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Logging.WriteLogToFile("Failure in UpdateSurveyWithCorticosteroidSelections-CORTPUIVMethSchedule: " + surveyEx.Message);

            }
        }

        #endregion

        #region txtCORTPUIVMethScheduleOther

        // Question txtCORTCUOralMethScheduleOther
        if (!String.IsNullOrEmpty(txtCORTPUIVMethScheduleOther.Text))
        {
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 
                _surveyResult.STD_QUESTION_CHOICE_ID = CORTPUIVMethScheduleOther.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = txtCORTPUIVMethScheduleOther.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Logging.WriteLogToFile("Failure in UpdateSurveyWithCorticosteroidSelections-CORTPUIVMethScheduleOther: " + surveyEx.Message);
            }
        }

        #endregion

        

        #region CORTPUIVMethApproxStarted
        // Question CORTPUIVMethApproxStarted
        /*if (!String.IsNullOrEmpty(mysCORTPUIVMethApproxStarted.MonthYearString))
        {
            _surveyResult = new SURVEY_RESULT();
            try
            {
                // Add Question CORTPUIVMethApproxStarted choice
                _surveyResult.STD_QUESTION_CHOICE_ID = CORTPUIVMethApproxStarted.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = mysCORTPUIVMethApproxStarted.MonthYearString;                                               
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Logging.WriteLogToFile("Failure in UpdateSurveyWithCorticosteroidSelections-CORTPUIVMethApproxStarted: " + surveyEx.Message);
            }
        }
        */
        #endregion

        #region CORTPUOralMethPharm

        // CORTPUOralMethPharm
        if (rblCORTPUOralMethPharm.SelectedIndex > -1) {
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add CORTPUOralMethPharm
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblCORTPUOralMethPharm.SelectedValue);
                _surveyResult.RESULT_TEXT = rblCORTPUOralMethPharm.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Logging.WriteLogToFile("Failure in UpdateSurveyWithCorticosteroidSelections-CORTPUOralMethPharm: " + surveyEx.Message);

            }
        }

        #endregion

        #region CORTPUOralMethSchedule

        //CORTPUOralMethSchedule
        if (rblCORTPUOralMethSchedule.SelectedIndex > -1) {
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add CORTPUOralMethSchedule
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblCORTPUOralMethSchedule.SelectedValue);
                _surveyResult.RESULT_TEXT = rblCORTPUOralMethSchedule.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Logging.WriteLogToFile("Failure in UpdateSurveyWithCorticosteroidSelections-CORTPUOralMethSchedule: " + surveyEx.Message);

            }
        }

        #endregion

        #region txtCORTPUOralMethScheduleOther

        // Question txtCORTCUOralMethScheduleOther
        if (!String.IsNullOrEmpty(txtCORTPUOralMethScheduleOther.Text))
        {
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 
                _surveyResult.STD_QUESTION_CHOICE_ID = CORTPUOralMethScheduleOther.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = txtCORTPUOralMethScheduleOther.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Logging.WriteLogToFile("Failure in UpdateSurveyWithCorticosteroidSelections-CORTPUOralMethScheduleOther: " + surveyEx.Message);
            }
        }

        #endregion

        #region CORTPUOralMethApproxStopped

        // Question CORTPUOralMethApproxStopped
        if (!String.IsNullOrEmpty(mysCORTPUOralMethApproxStopped.MonthYearString))
        {
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add Question CORTPUOralMethApproxStopped choice
                _surveyResult.STD_QUESTION_CHOICE_ID = CORTPUOralMethApproxStopped.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = mysCORTPUOralMethApproxStopped.MonthYearString;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Logging.WriteLogToFile("Failure in UpdateSurveyWithCorticosteroidSelections-CORTPUOralMethApproxStopped: " + surveyEx.Message);

            }
        }

        #endregion

        #region CORTPUOralMethApproxStarted
        if (!string.IsNullOrEmpty(mysCORTPUOralMethApproxStarted.MonthYearString))
        {
            _surveyResult = new SURVEY_RESULT();
            try
            {
                _surveyResult.STD_QUESTION_CHOICE_ID = CORTPUOralMethApproxStarted.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = mysCORTPUOralMethApproxStarted.MonthYearString;
                survey.SURVEY_RESULTs.Add(_surveyResult);

            }
            catch (Exception surveyEx)
            {
                Logging.WriteLogToFile("Failure in UpdateSurveyWithCorticosteroidSelections-CORTPUOralMethApproxStarted: " + surveyEx.Message); ;
            }
        }

        #endregion 

        #region CORTPUOralPredPharm

        // CORTPUOralPredPharm
        if (rblCORTPUOralPredPharm.SelectedIndex > -1) {
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add CORTPUOralMethPharm
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblCORTPUOralPredPharm.SelectedValue);
                _surveyResult.RESULT_TEXT = rblCORTPUOralPredPharm.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Logging.WriteLogToFile("Failure in UpdateSurveyWithCorticosteroidSelections-CORTPUOralMethPharm: " + surveyEx.Message);

            }
        }

        #endregion

        #region CORTPUOralPredSchedule

        //CORTPUOralPredSchedule
        if (rblCORTPUOralPredSchedule.SelectedIndex > -1) {
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add CORTPUOralPredSchedule
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblCORTPUOralPredSchedule.SelectedValue);
                _surveyResult.RESULT_TEXT = rblCORTPUOralPredSchedule.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Logging.WriteLogToFile("Failure in UpdateSurveyWithCorticosteroidSelections-CORTPUOralPredSchedule: " + surveyEx.Message);

            }
        }

        #endregion

        #region txtCORTPUOralPredScheduleOther

        // Question txtCORTCUOralMethScheduleOther
        if (!String.IsNullOrEmpty(txtCORTPUOralPredScheduleOther.Text))
        {
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 
                _surveyResult.STD_QUESTION_CHOICE_ID = CORTPUOralPredScheduleOther.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = txtCORTPUOralPredScheduleOther.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Logging.WriteLogToFile("Failure in UpdateSurveyWithCorticosteroidSelections-CORTPUOralPredScheduleOther: " + surveyEx.Message);
            }
        }

        #endregion

        #region CORTPUOralPredApproxStopped

        // Question CORTPUOralPredApproxStopped
        if (!String.IsNullOrEmpty(mysCORTPUOralPredApproxStopped.MonthYearString))
        {
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add Question CORTPUOralPredApproxStopped choice
                _surveyResult.STD_QUESTION_CHOICE_ID = CORTPUOralPredApproxStopped.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = mysCORTPUOralPredApproxStopped.MonthYearString;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Logging.WriteLogToFile("Failure in UpdateSurveyWithCorticosteroidSelections-CORTPUOralPredApproxStopped: " + surveyEx.Message);

            }
        }

        #endregion

        #region CORTPUOralPredApproxStarted
        if (!string.IsNullOrEmpty(mysCORTPUOralPredApproxStarted.MonthYearString))
        {
            _surveyResult = new SURVEY_RESULT();
            try
            {
                _surveyResult.STD_QUESTION_CHOICE_ID = CORTPUOralPredApproxStarted.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = mysCORTPUOralPredApproxStarted.MonthYearString;
                survey.SURVEY_RESULTs.Add(_surveyResult);

            }
            catch (Exception surveyEx)
            {
                Logging.WriteLogToFile("Failure in UpdateSurveyWithCorticosteroidSelections-CORTPUOralPredApproxStarted: " + surveyEx.Message); ;
            }
        }

        #endregion 

        #region CORTPUIVDexScheduleTtlTmExpsrInMnt

       if (rdNumCORTPUIVDexScheduleTtlTmExpsrInMnt.Value != null)
        {
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 
                _surveyResult.STD_QUESTION_CHOICE_ID = CORTPUIVDexScheduleTtlTmExpsrInMnt.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = Convert.ToString(rdNumCORTPUIVDexScheduleTtlTmExpsrInMnt.Value);
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Logging.WriteLogToFile("Failure in UpdateSurveyWithCorticosteroidSelections-CORTPUIVDexScheduleTtlTmExpsrInMnt: " + surveyEx.Message);
            }
        }

        #endregion


       #region CORTPUIVMethScheduleTtlTmExpsrInMnt

       if (rdNumCORTPUIVMethScheduleTtlTmExpsrInMnt.Value != null)
       {
           _surveyResult = new SURVEY_RESULT();

           try
           {
               // Add Question 
               _surveyResult.STD_QUESTION_CHOICE_ID = CORTPUIVMethScheduleTtlTmExpsrInMnt.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
               _surveyResult.RESULT_TEXT = Convert.ToString(rdNumCORTPUIVMethScheduleTtlTmExpsrInMnt.Value);
               survey.SURVEY_RESULTs.Add(_surveyResult);
           }
           catch (Exception surveyEx)
           {
               Logging.WriteLogToFile("Failure in UpdateSurveyWithCorticosteroidSelections-CORTPUIVMethScheduleTtlTmExpsrInMnt: " + surveyEx.Message);
           }
       }
       #endregion
       #region CORTPUOralMethScheduleTtlTmExpsrInMnt

       if (rdNumCORTPUOralMethScheduleTtlTmExpsrInMnt.Value != null)
       {
           _surveyResult = new SURVEY_RESULT();

           try
           {
               // Add Question 
               _surveyResult.STD_QUESTION_CHOICE_ID = CORTPUOralMethScheduleTtlTmExpsrInMnt.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
               _surveyResult.RESULT_TEXT = Convert.ToString(rdNumCORTPUOralMethScheduleTtlTmExpsrInMnt.Value);
               survey.SURVEY_RESULTs.Add(_surveyResult);
           }
           catch (Exception surveyEx)
           {
               Logging.WriteLogToFile("Failure in UpdateSurveyWithCorticosteroidSelections-CORTPUOralMethScheduleTtlTmExpsrInMnt: " + surveyEx.Message);
           }
       }
       #endregion


       #region CORTPUOralPredScheduleTtlTmExpsrInMnt

       if (rdNumCORTPUOralPredScheduleTtlTmExpsrInMnt.Value != null)
       {
           _surveyResult = new SURVEY_RESULT();

           try
           {
               // Add Question 
               _surveyResult.STD_QUESTION_CHOICE_ID = CORTPUOralPredScheduleTtlTmExpsrInMnt.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
               _surveyResult.RESULT_TEXT = Convert.ToString(rdNumCORTPUOralPredScheduleTtlTmExpsrInMnt.Value);
               survey.SURVEY_RESULTs.Add(_surveyResult);
           }
           catch (Exception surveyEx)
           {
               Logging.WriteLogToFile("Failure in UpdateSurveyWithCorticosteroidSelections-CORTPUOralPredScheduleTtlTmExpsrInMnt: " + surveyEx.Message);
           }
       }
       #endregion
    }

    /// <summary>
    /// TODO: call in SetupSurvey ... to prep display for form ... and populate
    /// </summary>
    /// <param name="survey"></param>
    public void SetupCorticosteroidSelections(ref SURVEY survey) {
        pnlCORTCUIVDexScheduleOther.Style["display"] = "none"; 
        pnlCORTCUIVMethScheduleOther.Style["display"] = "none"; 
        pnlCORTCUOralMethScheduleOther.Style["display"] = "none"; 
        pnlCORTCUOralPredScheduleOther.Style["display"] = "none"; 
        pnlCORTPUIVDexScheduleOther.Style["display"] = "none"; 
        pnlCORTPUIVMethScheduleOther.Style["display"] = "none"; 
        pnlCORTPUOralMethScheduleOther.Style["display"] = "none";
        pnlCORTPUOralPredScheduleOther.Style["display"] = "none";

        pnlCurrentPastUse.Style["display"] = "none";

        foreach (var sResult in survey.SURVEY_RESULTs) {
            switch (sResult.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) {

                #region CORT / subs ...

                case "CORT":
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                        rblCortUseStatus.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();

                        if (sResult.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower().Contains("never")) {
                          
                            pnlCurrentPastUse.Style["display"] = "none";
                          
                        } else {
                            pnlCurrentPastUse.Style["display"] = "block";
                            
                        }
                    } else {
                        rblCortUseStatus.SelectedIndex = -1;
                    }
                    break;
                case "CORTCU":
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {

                        if (!String.IsNullOrEmpty(sResult.RESULT_TEXT)) {
                            chkBoxCurrentUse.Checked = (sResult.RESULT_TEXT.Equals("Yes"));
                            if (chkBoxCurrentUse.Checked)
                                pnlCurrentTherapy.Style["display"] = "block";
                            else
                                pnlCurrentTherapy.Style["display"] = "none";
                        } else {
                            chkBoxCurrentUse.Checked = false;
                            pnlCurrentTherapy.Style["display"] = "none";
                        }

                    } else {
                        chkBoxCurrentUse.Checked = false;
                        pnlCurrentTherapy.Style["display"] = "none";
                    }
                    break;
                case "CORTCUIVDexPharm":
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                        rblCORTCUIVDexPharm.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                    } else {
                        rblCORTCUIVDexPharm.SelectedIndex = -1;
                    }
                    break;
                case "CORTCUIVDexSchedule":
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) 
                    {
                        rblCORTCUIVDexSchedule.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();

                        if (rblCORTCUIVDexSchedule.SelectedItem != null &&
                            rblCORTCUIVDexSchedule.SelectedItem.Text.ToLower().Contains("other"))
                        {
                            pnlCORTCUIVDexScheduleOther.Style["display"] = "block";
                        }
                        else
                        {
                            pnlCORTCUIVDexScheduleOther.Style["display"] = "none";
                        }
                    } 
                    else 
                    {
                        rblCORTCUIVDexSchedule.SelectedIndex = -1;
                        pnlCORTCUIVDexScheduleOther.Style["display"] = "none";
                    }
                    break;
                case "CORTCUIVDexScheduleOther":
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        txtCORTCUIVDexScheduleOther.Text = sResult.RESULT_TEXT;
                    }
                    else
                    {
                        txtCORTCUIVDexScheduleOther.Text = "";
                    }
                    break;
                case "CORTCUIVDexApproxStarted":
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                        mysCORTCUIVDexApproxStarted.MonthYearString = sResult.RESULT_TEXT;
                    }
                    break;
                case "CORTCUIVMethPharm":
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                        rblCORTCUIVMethPharm.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                    } else {
                        rblCORTCUIVMethPharm.SelectedIndex = -1;
                    }
                    break;
                case "CORTCUIVMethSchedule":
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) 
                    {
                        rblCORTCUIVMethSchedule.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();

                        if (rblCORTCUIVMethSchedule.SelectedItem != null &&
                            rblCORTCUIVMethSchedule.SelectedItem.Text.ToLower().Contains("other"))
                        {
                            pnlCORTCUIVMethScheduleOther.Style["display"] = "block";
                        }
                        else
                        {
                            pnlCORTCUIVMethScheduleOther.Style["display"] = "none";
                        }
                    } 
                    else 
                    {
                        rblCORTCUIVMethSchedule.SelectedIndex = -1;
                        pnlCORTCUIVMethScheduleOther.Style["display"] = "none";
                    }
                    break;
                case "CORTCUIVMethScheduleOther":
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        txtCORTCUIVMethScheduleOther.Text = sResult.RESULT_TEXT;
                    }
                    else
                    {
                        txtCORTCUIVMethScheduleOther.Text = "";
                    }
                    break;
                case "CORTCUIVMethApproxStarted":
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                        mysCORTCUIVMethApproxStarted.MonthYearString = sResult.RESULT_TEXT;
                    }
                    break;
                case "CORTCUOralMethPharm":
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                        rblCORTCUOralMethPharm.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                    } else {
                        rblCORTCUOralMethPharm.SelectedIndex = -1;
                    }
                    break;
                case "CORTCUOralMethSchedule":
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                        rblCORTCUOralMethSchedule.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();

                        if (rblCORTCUOralMethSchedule.SelectedItem != null &&
                            rblCORTCUOralMethSchedule.SelectedItem.Text.ToLower().Contains("other"))
                        {
                            pnlCORTCUOralMethScheduleOther.Style["display"] = "block";
                        }
                        else
                        {
                            pnlCORTCUOralMethScheduleOther.Style["display"] = "none";
                        }
                    } 
                    else 
                    {
                        rblCORTCUOralMethSchedule.SelectedIndex = -1; 
                        pnlCORTCUOralMethScheduleOther.Style["display"] = "none";
                    }
                    break;
                case "CORTCUOralMethScheduleOther":
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        txtCORTCUOralMethScheduleOther.Text = sResult.RESULT_TEXT;
                    }
                    else
                    {
                        txtCORTCUOralMethScheduleOther.Text = "";
                    }
                    break;
                case "CORTCUOralMethApproxStarted":
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                        mysCORTCUOralMethApproxStarted.MonthYearString = sResult.RESULT_TEXT;
                    }
                    break;
                case "CORTCUOralPredPharm":
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) 
                    {
                        rblCORTCUOralPredPharm.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                    } else 
                    {
                        rblCORTCUOralPredPharm.SelectedIndex = -1;
                    }
                    break;
                case "CORTCUOralPredSchedule":
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) 
                    {
                        rblCORTCUOralPredSchedule.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();

                        if (rblCORTCUOralPredSchedule.SelectedItem != null &&
                            rblCORTCUOralPredSchedule.SelectedItem.Text.ToLower().Contains("other"))
                        {
                            pnlCORTCUOralPredScheduleOther.Style["display"] = "block";
                        }
                        else
                        {
                            pnlCORTCUOralPredScheduleOther.Style["display"] = "none";
                        }
                    } 
                    else 
                    {
                        rblCORTCUOralPredSchedule.SelectedIndex = -1;
                        pnlCORTCUOralPredScheduleOther.Style["display"] = "none";
                    }
                    break;
                case "CORTCUOralPredScheduleOther":
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        txtCORTCUOralPredScheduleOther.Text = sResult.RESULT_TEXT;
                    }
                    else
                    {
                        txtCORTCUOralPredScheduleOther.Text = "";
                    }
                    break;
                case "CORTCUOralPredApproxStarted":
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                        mysCORTCUOralPredApproxStarted.MonthYearString = sResult.RESULT_TEXT;
                    }
                    break;
                case "CORTPU":
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {

                        if (!String.IsNullOrEmpty(sResult.RESULT_TEXT)) {
                            chkBoxPastUse.Checked = (sResult.RESULT_TEXT.Equals("Yes"));

                            if (chkBoxPastUse.Checked)
                            {
                                pnlPastTherapy.Style["display"] = "block";
                            }
                            else
                            {
                                pnlPastTherapy.Style["display"] = "none";
                            }
                        } else {
                            chkBoxPastUse.Checked = false;
                            pnlPastTherapy.Style["display"] = "none";
                        }

                    } else {
                        chkBoxPastUse.Checked = false;
                        pnlPastTherapy.Style["display"] = "none";
                    }
                    break;
                case "CORTPUIVDexPharm":
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                        rblCORTPUIVDexPharm.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                    } else {
                        rblCORTPUIVDexPharm.SelectedIndex = -1;
                    }
                    break;
                case "CORTPUIVDexSchedule":
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) 
                    {
                        rblCORTPUIVDexSchedule.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();

                        if (rblCORTPUIVDexSchedule.SelectedItem != null &&
                            rblCORTPUIVDexSchedule.SelectedItem.Text.ToLower().Contains("other"))
                        {
                            pnlCORTPUIVDexScheduleOther.Style["display"] = "block";
                        }
                        else
                        {
                            pnlCORTPUIVDexScheduleOther.Style["display"] = "none";
                        }
                    } 
                    else 
                    {
                        rblCORTPUIVDexSchedule.SelectedIndex = -1;
                        pnlCORTPUIVDexScheduleOther.Style["display"] = "none";
                    }
                    break;
                case "CORTPUIVDexScheduleOther":
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        txtCORTPUIVDexScheduleOther.Text = sResult.RESULT_TEXT;
                    }
                    else
                    {
                        txtCORTPUIVDexScheduleOther.Text = "";
                    }
                    break;
                case "CORTPUIVDexApproxStarted":
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        mysCORTPUIVDexApproxStarted.MonthYearString = sResult.RESULT_TEXT;
                    }
                    break;
                case "CORTPUIVDexApproxStopped":
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                        mysCORTPUIVDexApproxStopped.MonthYearString = sResult.RESULT_TEXT;
                    }
                    break;
                
                case "CORTPUIVMethPharm":
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                        rblCORTPUIVMethPharm.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                    } else {
                        rblCORTPUIVMethPharm.SelectedIndex = -1;
                    }
                    break;
                case "CORTPUIVMethSchedule":
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) 
                    {
                        rblCORTPUIVMethSchedule.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();

                        if (rblCORTPUIVMethSchedule.SelectedItem != null &&
                            rblCORTPUIVMethSchedule.SelectedItem.Text.ToLower().Contains("other"))
                        {
                            pnlCORTPUIVMethScheduleOther.Style["display"] = "block";
                        }
                        else
                        {
                            pnlCORTPUIVMethScheduleOther.Style["display"] = "none";
                        }
                    } 
                    else 
                    {
                        rblCORTPUIVMethSchedule.SelectedIndex = -1;
                        pnlCORTPUIVMethScheduleOther.Style["display"] = "none";
                    }
                    break;
                case "CORTPUIVMethScheduleOther":
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        txtCORTPUIVMethScheduleOther.Text = sResult.RESULT_TEXT;
                    }
                    else
                    {
                        txtCORTPUIVMethScheduleOther.Text = "";
                    }
                    break;
                case "CORTPUIVMethApproxStarted":
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        mysCORTPUIVMethApproxStarted.MonthYearString = sResult.RESULT_TEXT;
                    }
                    break;
                case "CORTPUIVMethApproxStopped":
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                        mysCORTPUIVMethApproxStopped.MonthYearString = sResult.RESULT_TEXT;
                    }
                    break;
                
                case "CORTPUOralMethPharm":
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                        rblCORTPUOralMethPharm.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                    } else {
                        rblCORTPUOralMethPharm.SelectedIndex = -1;
                    }
                    break;
                case "CORTPUOralMethSchedule":
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) 
                    {
                        rblCORTPUOralMethSchedule.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();

                        if (rblCORTPUOralMethSchedule.SelectedItem != null &&
                            rblCORTPUOralMethSchedule.SelectedItem.Text.ToLower().Contains("other"))
                        {
                            pnlCORTPUOralMethScheduleOther.Style["display"] = "block";
                        }
                        else
                        {
                            pnlCORTPUOralMethScheduleOther.Style["display"] = "none";
                        }
                    } 
                    else 
                    {
                        rblCORTPUOralMethSchedule.SelectedIndex = -1;
                        pnlCORTPUOralMethScheduleOther.Style["display"] = "none";
                    }
                    break;
                case "CORTPUOralMethScheduleOther":
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        txtCORTPUOralMethScheduleOther.Text = sResult.RESULT_TEXT;
                    }
                    else
                    {
                        txtCORTPUOralMethScheduleOther.Text = "";
                    }
                    break;
                case "CORTPUOralMethApproxStarted":
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        mysCORTPUOralMethApproxStarted.MonthYearString = sResult.RESULT_TEXT;
                    }
                    break;
                case "CORTPUOralMethApproxStopped":
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                        mysCORTPUOralMethApproxStopped.MonthYearString = sResult.RESULT_TEXT;
                    }
                    break;
                
                case "CORTPUOralPredPharm":
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                        rblCORTPUOralPredPharm.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                    } else {
                        rblCORTPUOralPredPharm.SelectedIndex = -1;
                    }
                    break;
                case "CORTPUOralPredSchedule":
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) 
                    {
                        rblCORTPUOralPredSchedule.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();

                        if (rblCORTPUOralPredSchedule.SelectedItem != null &&
                            rblCORTPUOralPredSchedule.SelectedItem.Text.ToLower().Contains("other"))
                        {
                            pnlCORTPUOralPredScheduleOther.Style["display"] = "block";
                        }
                        else
                        {
                            pnlCORTPUOralPredScheduleOther.Style["display"] = "none";
                        }
                    } 
                    else 
                    {
                        rblCORTPUOralPredSchedule.SelectedIndex = -1;
                        pnlCORTPUOralPredScheduleOther.Style["display"] = "none";
                    }
                    break;
                case "CORTPUOralPredScheduleOther":
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        txtCORTPUOralPredScheduleOther.Text = sResult.RESULT_TEXT;
                    }
                    else
                    {
                        txtCORTPUOralPredScheduleOther.Text = "";
                    }
                    break;
                case "CORTPUOralPredApproxStarted":
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        mysCORTPUOralPredApproxStarted.MonthYearString = sResult.RESULT_TEXT;
                    }
                    break;
                case "CORTPUOralPredApproxStopped":
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                        mysCORTPUOralPredApproxStopped.MonthYearString = sResult.RESULT_TEXT;
                    }
                    break;
                case "CORTPUIVDexScheduleTtlTmExpsrInMnt":
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        rdNumCORTPUIVDexScheduleTtlTmExpsrInMnt.Value = Convert.ToInt32(sResult.RESULT_TEXT);
                    }
                    break;
                case "CORTPUIVMethScheduleTtlTmExpsrInMnt":
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        rdNumCORTPUIVMethScheduleTtlTmExpsrInMnt.Value = Convert.ToInt32(sResult.RESULT_TEXT);
                    }
                    break;

                case "CORTPUOralMethScheduleTtlTmExpsrInMnt":
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        rdNumCORTPUOralMethScheduleTtlTmExpsrInMnt.Value = Convert.ToInt32(sResult.RESULT_TEXT);
                    }
                    break;

                case "CORTPUOralPredScheduleTtlTmExpsrInMnt":
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        rdNumCORTPUOralPredScheduleTtlTmExpsrInMnt.Value = Convert.ToInt32(sResult.RESULT_TEXT);
                    }
                    break;

                default:
                    break;

                #endregion

            }
        }
    }

    /// <summary>
    /// GetCorticosteroidHealthFactors: returns the string of appropriate Health Factors for the current selections
    /// </summary>
    /// <returns></returns>
    public string GetCorticosteroidHealthFactors() {
        string returnStr = "";

        if (rblCortUseStatus.SelectedItem != null) {
            if (!String.IsNullOrEmpty(rblCortUseStatus.SelectedItem.Text)) {
                if (rblCortUseStatus.SelectedItem.Text.ToLower() == "never") {
                    //MSCOE.CORTICOSTEROIDS.NEVER
                    returnStr = "MSCOE.CORTICOSTEROIDS.NEVER";

                } else if (rblCortUseStatus.SelectedItem.Text.ToLower().Contains("current")) {

                    // current use
                    if (chkBoxCurrentUse.Checked) {
                        //MSCOE.CORTICOSTEROIDS.CURRENT USE
                        returnStr = "MSCOE.CORTICOSTEROIDS.CURRENT USE";

                        if (areCurrentMedsUsed()) {
                            if (!String.IsNullOrEmpty(returnStr)) {
                                returnStr += ", MSCOE.CORTICOSTEROIDS.CURRENT MED";
                            } else {
                                returnStr += "MSCOE.CORTICOSTEROIDS.CURRENT MED";
                            }
                        }

                        if (areCurrentMedsStarted()) {
                            if (!String.IsNullOrEmpty(returnStr)) {
                                returnStr += ", MSCOE.CORTICOSTEROIDS.CURRENT STARTED";
                            } else {
                                returnStr += "MSCOE.CORTICOSTEROIDS.CURRENT STARTED";
                            }
                        }
                    }

                    // past use
                    if (chkBoxPastUse.Checked) {
                        if (!String.IsNullOrEmpty(returnStr)) {
                            returnStr += ", MSCOE.CORTICOSTEROIDS.PAST USE";
                        } else {
                            returnStr += "MSCOE.CORTICOSTEROIDS.PAST USE";
                        }

                        if (arePastMedsUsed()) {
                            if (!String.IsNullOrEmpty(returnStr)) {
                                returnStr += ", MSCOE.CORTICOSTEROIDS.PAST MED, MSCOE.CORTICOSTEROIDS.PAST STARTED";
                            } else {
                                returnStr += "MSCOE.CORTICOSTEROIDS.PAST MED, MSCOE.CORTICOSTEROIDS.PAST STARTED";
                            }
                        }

                        if (arePastMedsStopped()) {
                            if (!String.IsNullOrEmpty(returnStr)) {
                                returnStr += ", MSCOE.CORTICOSTEROIDS.PAST STOPPED";
                            } else {
                                returnStr += "MSCOE.CORTICOSTEROIDS.PAST STOPPED";
                            }
                        }
                    }

                    // Currently, not used ...
                    //MSCOE.CORTICOSTEROIDS.RSTOP.ADVERSE SE
                    //MSCOE.CORTICOSTEROIDS.RSTOP.INEFFECTIVE
                    //MSCOE.CORTICOSTEROIDS.RSTOP.INTOLERANT
                    //MSCOE.CORTICOSTEROIDS.RSTOP.MAX DOSE
                }
            }
        }

        return returnStr;
    }

    /// <summary>
    /// GetCorticosteroidNoteSummary: returns the string of appropriate note summary data for the current selections
    /// </summary>
    /// <returns></returns>
    public string GetCorticosteroidNoteSummary() {
        string returnStr = "";

        if (rblCortUseStatus.SelectedItem != null) {
            if (!String.IsNullOrEmpty(rblCortUseStatus.SelectedItem.Text)) {
                if (rblCortUseStatus.SelectedItem.Text.ToLower() == "never taken") {
                    //never
                    returnStr = "\r\nCorticosteroid Use:\r\n\tNever Taken\r\n";

                } else if (rblCortUseStatus.SelectedItem.Text.ToLower().Contains("current")) {

                    returnStr = "\r\nCorticosteroid Use:\r\n";

                    bool b = false;

                    // current use
                    if (chkBoxCurrentUse.Checked) {

                        returnStr += "- Current Use:\r\n";

                        //Dexamethasone IV (Decadron)
                        returnStr += "  - Dexamethasone IV (Decadron)\r\n";

                        if (rblCORTCUIVDexPharm.SelectedIndex > -1) {
                            returnStr += "\tDispensing Pharmacy: " + rblCORTCUIVDexPharm.SelectedItem.Text + "\r\n";
                            b = true;
                        }

                        if (rblCORTCUIVDexSchedule.SelectedIndex > -1) {
                            returnStr += "\tSchedule: " + rblCORTCUIVDexSchedule.SelectedItem.Text + "\r\n";
                            b = true;

                            if (!String.IsNullOrEmpty(txtCORTCUIVDexScheduleOther.Text))
                            {
                                returnStr += "\tOther Schedule: " + txtCORTCUIVDexScheduleOther.Text + "\r\n";
                            }
                        }                        

                        if (!String.IsNullOrEmpty(mysCORTCUIVDexApproxStarted.MonthYearString))
                        {
                            returnStr += "\tApproximate Date Started: " + mysCORTCUIVDexApproxStarted.MonthYearString + "\r\n";
                            b = true;
                        }

                        if (!b)
                            returnStr += "\tNo Selections\r\n";
                        else
                            b = false;

                        //Methylprednisolone IV (Solumedrol)
                        returnStr += "  - Methylprednisolone IV (Solumedrol)\r\n";

                        if (rblCORTCUIVMethPharm.SelectedIndex > -1) {
                            returnStr += "\tDispensing Pharmacy: " + rblCORTCUIVMethPharm.SelectedItem.Text + "\r\n";
                            b = true;
                        }

                        if (rblCORTCUIVMethSchedule.SelectedIndex > -1) {
                            returnStr += "\tSchedule: " + rblCORTCUIVMethSchedule.SelectedItem.Text + "\r\n";
                            b = true;

                            if (!String.IsNullOrEmpty(txtCORTCUIVMethScheduleOther.Text))
                            {
                                returnStr += "\tOther Schedule: " + txtCORTCUIVMethScheduleOther.Text + "\r\n";
                            }
                        }

                        if (!String.IsNullOrEmpty(mysCORTCUIVMethApproxStarted.MonthYearString))
                        {
                            returnStr += "\tApproximate Date Started: " + mysCORTCUIVMethApproxStarted.MonthYearString + "\r\n";
                            b = true;
                        }

                        if (!b)
                            returnStr += "\tNo Selections\r\n";
                        else
                            b = false;             

                        //Methylprednisolone PO (Medrol)
                        returnStr += "  - Methylprednisolone PO (Medrol)\r\n";

                        if (rblCORTCUOralMethPharm.SelectedIndex > -1) {
                            returnStr += "\tDispensing Pharmacy: " + rblCORTCUOralMethPharm.SelectedItem.Text + "\r\n";
                            b = true;
                        }

                        if (rblCORTCUOralMethSchedule.SelectedIndex > -1) {
                            returnStr += "\tSchedule: " + rblCORTCUOralMethSchedule.SelectedItem.Text + "\r\n";
                            b = true;

                            if (!String.IsNullOrEmpty(txtCORTCUOralMethScheduleOther.Text))
                            {
                                returnStr += "\tOther Schedule: " + txtCORTCUOralMethScheduleOther.Text + "\r\n";
                            }
                        }

                        if (!String.IsNullOrEmpty(mysCORTCUOralMethApproxStarted.MonthYearString))
                        {
                            returnStr += "\tApproximate Date Started: " + mysCORTCUOralMethApproxStarted.MonthYearString + "\r\n";
                            b = true;
                        }

                        if (!b)
                            returnStr += "\tNo Selections\r\n";
                        else
                            b = false;

                        //Prednisone PO
                        returnStr += "  - Prednisone PO\r\n";

                        if (rblCORTCUOralPredPharm.SelectedIndex > -1) {
                            returnStr += "\tDispensing Pharmacy: " + rblCORTCUOralPredPharm.SelectedItem.Text + "\r\n";
                            b = true;
                        }

                        if (rblCORTCUOralPredSchedule.SelectedIndex > -1) {
                            returnStr += "\tSchedule: " + rblCORTCUOralPredSchedule.SelectedItem.Text + "\r\n";
                            b = true;

                            if (!String.IsNullOrEmpty(txtCORTCUOralPredScheduleOther.Text))
                            {
                                returnStr += "\tOther Schedule: " + txtCORTCUOralPredScheduleOther.Text + "\r\n";
                            }
                        }

                        if (!String.IsNullOrEmpty(mysCORTCUOralPredApproxStarted.MonthYearString))
                        {
                            returnStr += "\tApproximate Date Started: " + mysCORTCUOralPredApproxStarted.MonthYearString + "\r\n";
                            b = true;
                        }

                        if (!b)
                            returnStr += "\tNo Selections\r\n";
                        else
                            b = false;
                    }

                    // past use
                    if (chkBoxPastUse.Checked) {

                        //returnStr += " - Past Use:\r\n";
                        string pastUseString = "";

                        //Dexamethasone IV (Decadron)
                        pastUseString += "  - Dexamethasone IV (Decadron)\r\n";

                        if (rblCORTPUIVDexPharm.SelectedIndex > -1) {
                            pastUseString += "\tDispensing Pharmacy: " + rblCORTPUIVDexPharm.SelectedItem.Text + "\r\n";
                            b = true;
                        }

                        if (rblCORTPUIVDexSchedule.SelectedIndex > -1) {
                            pastUseString += "\tSchedule: " + rblCORTPUIVDexSchedule.SelectedItem.Text + "\r\n";
                            b = true;

                            if (!String.IsNullOrEmpty(txtCORTPUIVDexScheduleOther.Text))
                            {
                                pastUseString += "\tOther Schedule: " + txtCORTPUIVDexScheduleOther.Text + "\r\n";
                            }
                        }
                        if (!String.IsNullOrEmpty(mysCORTPUIVDexApproxStarted.MonthYearString))
                        {
                            pastUseString += "\tApproximate Date Started: " + mysCORTPUIVDexApproxStarted.MonthYearString + "\r\n";
                            b = true;
                        }
                        if (!String.IsNullOrEmpty(mysCORTPUIVDexApproxStopped.MonthYearString))
                        {
                            pastUseString += "\tApproximate Date Stopped: " + mysCORTPUIVDexApproxStopped.MonthYearString + "\r\n";
                            b = true;
                        }

                        if (rdNumCORTPUIVDexScheduleTtlTmExpsrInMnt.Value != null)
                        {
                            pastUseString += "\tTotal Lifetime Exposure to this Therapy in Months: " + rdNumCORTPUIVDexScheduleTtlTmExpsrInMnt.Value + "\r\n";
                            b = true;
                        }


                        if (!b)
                            pastUseString += "\tNo Selections\r\n";
                        else
                            b = false;

                        //Methylprednisolone IV (Solumedrol)
                        pastUseString += "  - Methylprednisolone IV (Solumedrol)\r\n";

                        if (rblCORTPUIVMethPharm.SelectedIndex > -1) {
                            pastUseString += "\tDispensing Pharmacy: " + rblCORTPUIVMethPharm.SelectedItem.Text + "\r\n";
                            b = true;
                        }

                        if (rblCORTPUIVMethSchedule.SelectedIndex > -1) {
                            pastUseString += "\tSchedule: " + rblCORTPUIVMethSchedule.SelectedItem.Text + "\r\n";
                            b = true;

                            if (!String.IsNullOrEmpty(txtCORTPUIVMethScheduleOther.Text))
                            {
                                pastUseString += "\tOther Schedule: " + txtCORTPUIVMethScheduleOther.Text + "\r\n";
                            }
                        }
                        if (!String.IsNullOrEmpty(mysCORTPUIVMethApproxStarted.MonthYearString))
                        {
                            pastUseString += "\tApproximate Date Started: " + mysCORTPUIVMethApproxStarted.MonthYearString + "\r\n";
                            b = true;
                        }
                        if (!String.IsNullOrEmpty(mysCORTPUIVMethApproxStopped.MonthYearString))
                        {
                            pastUseString += "\tApproximate Date Stopped: " + mysCORTPUIVMethApproxStopped.MonthYearString + "\r\n";
                            b = true;
                        }
                        if (rdNumCORTPUIVMethScheduleTtlTmExpsrInMnt.Value != null)
                        {
                            pastUseString += "\tTotal Lifetime Exposure to this Therapy in Months: " + rdNumCORTPUIVMethScheduleTtlTmExpsrInMnt.Value + "\r\n";
                            b = true;
                        }

                        if (!b)
                            pastUseString += "\tNo Selections\r\n";
                        else
                            b = false;

                        //Methylprednisolone PO (Medrol)
                        pastUseString += "  - Methylprednisolone PO (Medrol)\r\n";

                        if (rblCORTPUOralMethPharm.SelectedIndex > -1) {
                            pastUseString += "\tDispensing Pharmacy: " + rblCORTPUOralMethPharm.SelectedItem.Text + "\r\n";
                            b = true;
                        }

                        if (rblCORTPUOralMethSchedule.SelectedIndex > -1) {
                            pastUseString += "\tSchedule: " + rblCORTPUOralMethSchedule.SelectedItem.Text + "\r\n";
                            b = true;

                            if (!String.IsNullOrEmpty(txtCORTPUOralMethScheduleOther.Text))
                            {
                                pastUseString += "\tOther Schedule: " + txtCORTPUOralMethScheduleOther.Text + "\r\n";
                            }
                        }
                        if (!String.IsNullOrEmpty(mysCORTPUOralMethApproxStarted.MonthYearString))
                        {
                            pastUseString += "\tApproximate Date Started: " + mysCORTPUOralMethApproxStarted.MonthYearString + "\r\n";
                            b = true;
                        }
                        if (!String.IsNullOrEmpty(mysCORTPUOralMethApproxStopped.MonthYearString))
                        {
                            pastUseString += "\tApproximate Date Stopped: " + mysCORTPUOralMethApproxStopped.MonthYearString + "\r\n";
                            b = true;
                        }
                        if (rdNumCORTPUOralMethScheduleTtlTmExpsrInMnt.Value != null)
                        {
                            pastUseString += "\tTotal Lifetime Exposure to this Therapy in Months: " + rdNumCORTPUOralMethScheduleTtlTmExpsrInMnt.Value + "\r\n";
                            b = true;
                        }

                        if (!b)
                            pastUseString += "\tNo Selections\r\n";
                        else
                            b = false;

                        //Prednisone PO
                        pastUseString += "  - Prednisone PO\r\n";

                        if (rblCORTPUOralPredPharm.SelectedIndex > -1) {
                            pastUseString += "\tDispensing Pharmacy: " + rblCORTPUOralPredPharm.SelectedItem.Text + "\r\n";
                            b = true;
                        }

                        if (rblCORTPUOralPredSchedule.SelectedIndex > -1) {
                            pastUseString += "\tSchedule: " + rblCORTPUOralPredSchedule.SelectedItem.Text + "\r\n";
                            b = true;

                            if (!String.IsNullOrEmpty(txtCORTPUOralPredScheduleOther.Text))
                            {
                                pastUseString += "\tOther Schedule: " + txtCORTPUOralPredScheduleOther.Text + "\r\n";
                            }
                        }
                        if (!String.IsNullOrEmpty(mysCORTPUOralPredApproxStarted.MonthYearString))
                        {
                            pastUseString += "\tApproximate Date Started: " + mysCORTPUOralPredApproxStarted.MonthYearString + "\r\n";
                            b = true;
                        }
                        if (!String.IsNullOrEmpty(mysCORTPUOralPredApproxStopped.MonthYearString))
                        {
                            pastUseString += "\tApproximate Date Stopped: " + mysCORTPUOralPredApproxStopped.MonthYearString + "\r\n";
                            b = true;
                        }
                        if (rdNumCORTPUOralPredScheduleTtlTmExpsrInMnt.Value != null)
                        {
                            pastUseString += "\tTotal Lifetime Exposure to this Therapy in Months: " + rdNumCORTPUOralPredScheduleTtlTmExpsrInMnt.Value + "\r\n";
                            b = true;
                        }
                        if (!b)
                            pastUseString += "\tNo Selections\r\n";
                        else
                            b = false;

                        // Concat the two strings together
                        if (!String.IsNullOrEmpty(pastUseString)) {
                            returnStr += "- Past Use:\r\n" + pastUseString;                            
                        }
                    }

                    // Currently, not used ...
                    //MSCOE.CORTICOSTEROIDS.RSTOP.ADVERSE SE
                    //MSCOE.CORTICOSTEROIDS.RSTOP.INEFFECTIVE
                    //MSCOE.CORTICOSTEROIDS.RSTOP.INTOLERANT
                    //MSCOE.CORTICOSTEROIDS.RSTOP.MAX DOSE
                }
            }
        }

        return returnStr;
    }

    /// <summary>
    /// GetCorticosteroidCurrentMeds: returns the string of medications that are currently being taken
    /// </summary>
    /// <returns></returns>
    public string GetCorticosteroidCurrentMeds() {
        string returnStr = "";
        if (rblCortUseStatus.SelectedItem.Text.ToLower().Contains("current")) {

            // current use
            if (chkBoxCurrentUse.Checked) {

                //Dexamethasone IV (Decadron)
                if (rblCORTCUIVDexPharm.SelectedIndex > -1) {
                    returnStr += LabelForDexamethasoneIV.Text + ", ";
                }

                //Methylprednisolone IV (Solumedrol)
                if (rblCORTCUIVMethPharm.SelectedIndex > -1) {
                    returnStr += LabelForMethylprednisoloneIV.Text + ", ";
                }

                //Methylprednisolone PO (Medrol)
                if (rblCORTCUOralMethPharm.SelectedIndex > -1) {
                    returnStr += LabelForMethylprednisolonePO.Text + ", ";
                }

                //Prednisone PO
                if (rblCORTCUOralPredPharm.SelectedIndex > -1) {
                    returnStr += LabelForPrednisonePO.Text + ", ";
                }
            }
        }

        if (returnStr.EndsWith(", ")) {
            returnStr = returnStr.Substring(0, returnStr.Length - 2);
        }

        return returnStr.ToUpper();
    }

    /// <summary>
    /// GetCorticosteroidPastMeds: returns the string of medications that were previously taken
    /// </summary>
    /// <returns></returns>
    public string GetCorticosteroidPastMeds() {
        string returnStr = "";

        if (chkBoxPastUse.Checked) {
            //Dexamethasone IV (Decadron)
            if (rblCORTPUIVDexPharm.SelectedIndex > -1) {
                returnStr += LabelForPastDexamethasoneIV.Text + ", ";
            }

            //Methylprednisolone IV (Solumedrol)
            if (rblCORTPUIVMethPharm.SelectedIndex > -1) {
                returnStr += LabelForPastMethylprednisoloneIV.Text + ", ";
            }

            //Methylprednisolone PO (Medrol)
            if (rblCORTPUOralMethPharm.SelectedIndex > -1) {
                returnStr += LabelForPastMethylprednisolonePO.Text + ", ";
            }

            //Prednisone PO
            if (rblCORTPUOralPredPharm.SelectedIndex > -1) {
                returnStr += LabelForPastPrednisonePO.Text + ", ";
            }
        }

        if (returnStr.EndsWith(", ")) {
            returnStr = returnStr.Substring(0, returnStr.Length - 2);
        }
        
        return returnStr.ToUpper();
    }

    #endregion

    #region Protected Methods

    /// <summary>
    /// Default Page_Load Method
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e) {
        if (!IsPostBack)
        {
            //populateUseStatusList();
            if (Session["IsFirstTimeSurvey"] != null && Session["IsFirstTimeSurvey"].ToString().ToLower()=="yes")
            {
                rblCortUseStatus.SelectedIndex = 0;
                pnlCurrentPastUse.Style["display"] = "none";
            }
            if (rblCortUseStatus.SelectedIndex == -1)
            {
                // Never, hide everything
                pnlCurrentPastUse.Style["display"] = "none";
                pnlCurrentTherapy.Style["display"] = "none";
                pnlPastTherapy.Style["display"] = "none"; 
                
                pnlCORTCUIVDexScheduleOther.Style["display"] = "none";
                pnlCORTCUIVMethScheduleOther.Style["display"] = "none";
                pnlCORTCUOralMethScheduleOther.Style["display"] = "none";
                pnlCORTCUOralPredScheduleOther.Style["display"] = "none";
                pnlCORTPUIVDexScheduleOther.Style["display"] = "none";
                pnlCORTPUIVMethScheduleOther.Style["display"] = "none";
                pnlCORTPUOralMethScheduleOther.Style["display"] = "none";
                pnlCORTPUOralPredScheduleOther.Style["display"] = "none";
            }
        }
        SetCurrentUsePastUseVisibility();


    }
    #endregion

    #region Private Methods

    /// <summary>
    /// setup and bind controls to data.
    /// </summary>
    private void populateUseStatusList() {

        SetValidatorSettings();
        if (CORT != null) {
            rblCortUseStatus.DataSource = CORT.STD_QUESTION_CHOICEs;
            rblCortUseStatus.DataBind();
        }

        if (CORTCUIVDexPharm != null) {
            rblCORTCUIVDexPharm.DataSource = CORTCUIVDexPharm.STD_QUESTION_CHOICEs;
            rblCORTCUIVDexPharm.DataBind();
        }

        if (CORTCUIVDexSchedule != null) {
            rblCORTCUIVDexSchedule.DataSource = CORTCUIVDexSchedule.STD_QUESTION_CHOICEs;
            rblCORTCUIVDexSchedule.DataBind();
        }

        //if (CORTCUIVDexApproxStarted != null) {
        //}

        if (CORTCUIVMethPharm != null) {
            rblCORTCUIVMethPharm.DataSource = CORTCUIVMethPharm.STD_QUESTION_CHOICEs;
            rblCORTCUIVMethPharm.DataBind();
        }

        if (CORTCUIVMethSchedule != null) {
            rblCORTCUIVMethSchedule.DataSource = CORTCUIVMethSchedule.STD_QUESTION_CHOICEs;
            rblCORTCUIVMethSchedule.DataBind();
        }

        //if (CORTCUIVMethApproxStarted != null) {
        //}

        if (CORTCUOralMethPharm != null) {
            rblCORTCUOralMethPharm.DataSource = CORTCUOralMethPharm.STD_QUESTION_CHOICEs;
            rblCORTCUOralMethPharm.DataBind();
        }

        if (CORTCUOralMethSchedule != null) {
            rblCORTCUOralMethSchedule.DataSource = CORTCUOralMethSchedule.STD_QUESTION_CHOICEs;
            rblCORTCUOralMethSchedule.DataBind();
        }

        //if (CORTCUOralMethApproxStarted != null) {
        //}

        if (CORTCUOralPredPharm != null) {
            rblCORTCUOralPredPharm.DataSource = CORTCUOralPredPharm.STD_QUESTION_CHOICEs;
            rblCORTCUOralPredPharm.DataBind();
        }

        if (CORTCUOralPredSchedule != null) {
            rblCORTCUOralPredSchedule.DataSource = CORTCUOralPredSchedule.STD_QUESTION_CHOICEs;
            rblCORTCUOralPredSchedule.DataBind();
        }

        //if (CORTCUOralPredApproxStarted != null) {
        //}


        #region Past Variable setting

        if (CORTPUIVDexPharm != null) {
            rblCORTPUIVDexPharm.DataSource = CORTPUIVDexPharm.STD_QUESTION_CHOICEs;
            rblCORTPUIVDexPharm.DataBind();
        }

        if (CORTPUIVDexSchedule != null) {
            rblCORTPUIVDexSchedule.DataSource = CORTPUIVDexSchedule.STD_QUESTION_CHOICEs;
            rblCORTPUIVDexSchedule.DataBind();
        }

        //if (CORTPUIVDexApproxStarted != null) {
        //}

        if (CORTPUIVMethPharm != null) {
            rblCORTPUIVMethPharm.DataSource = CORTPUIVMethPharm.STD_QUESTION_CHOICEs;
            rblCORTPUIVMethPharm.DataBind();
        }

        if (CORTPUIVMethSchedule != null) {
            rblCORTPUIVMethSchedule.DataSource = CORTPUIVMethSchedule.STD_QUESTION_CHOICEs;
            rblCORTPUIVMethSchedule.DataBind();
        }

        //if (CORTPUIVMethApproxStarted != null) {
        //}

        if (CORTPUOralMethPharm != null) {
            rblCORTPUOralMethPharm.DataSource = CORTPUOralMethPharm.STD_QUESTION_CHOICEs;
            rblCORTPUOralMethPharm.DataBind();
        }

        if (CORTPUOralMethSchedule != null) {
            rblCORTPUOralMethSchedule.DataSource = CORTPUOralMethSchedule.STD_QUESTION_CHOICEs;
            rblCORTPUOralMethSchedule.DataBind();
        }

        

        if (CORTPUOralPredPharm != null) {
            rblCORTPUOralPredPharm.DataSource = CORTPUOralPredPharm.STD_QUESTION_CHOICEs;
            rblCORTPUOralPredPharm.DataBind();
        }

        if (CORTPUOralPredSchedule != null) {
            rblCORTPUOralPredSchedule.DataSource = CORTPUOralPredSchedule.STD_QUESTION_CHOICEs;
            rblCORTPUOralPredSchedule.DataBind();
        }

        

        #endregion
    }

    /// <summary>
    /// Look at Current use controls and determine if any meds are selected ... if so, return true.
    /// </summary>
    /// <returns></returns>
    private bool areCurrentMedsUsed() {
        if ((rblCORTCUIVDexPharm.SelectedIndex > -1) || (rblCORTCUIVMethPharm.SelectedIndex > -1) || (rblCORTCUOralMethPharm.SelectedIndex > -1) || (rblCORTCUOralPredPharm.SelectedIndex > -1)) {
            return true;
        }

        return false;
    }

    /// <summary>
    /// Look at Current use date started controls and if populated, return true.
    /// </summary>
    /// <returns></returns>
    private bool areCurrentMedsStarted() {
        if (!String.IsNullOrEmpty(mysCORTCUIVDexApproxStarted.MonthYearString) || 
            !String.IsNullOrEmpty(mysCORTCUIVMethApproxStarted.MonthYearString) || 
            !String.IsNullOrEmpty(mysCORTCUOralMethApproxStarted.MonthYearString) ||
            !String.IsNullOrEmpty(mysCORTCUOralPredApproxStarted.MonthYearString))
        {
            return true;
        }

        return false;
    }

    /// <summary>
    /// Look at Past use controls and determine if any meds are selected ... if so, return true.
    /// </summary>
    /// <returns></returns>
    private bool arePastMedsUsed() {
        if ((rblCORTPUIVDexPharm.SelectedIndex > -1) || (rblCORTPUIVMethPharm.SelectedIndex > -1) || (rblCORTPUOralMethPharm.SelectedIndex > -1) || (rblCORTPUOralPredPharm.SelectedIndex > -1)) {
            return true;
        }

        return false;
    }

    /// <summary>
    /// Look at Past use date started controls and if populated, return true.
    /// </summary>
    /// <returns></returns>
    private bool arePastMedsStopped() {
        if (!String.IsNullOrEmpty(mysCORTPUIVDexApproxStopped.MonthYearString) 
            || !String.IsNullOrEmpty(mysCORTPUIVMethApproxStopped.MonthYearString) ||
            !String.IsNullOrEmpty(mysCORTPUOralMethApproxStopped.MonthYearString) ||
            !String.IsNullOrEmpty(mysCORTPUOralPredApproxStopped.MonthYearString))
        {
            return true;
        }

        return false;
    }

    public void SetValidatorSettings()
    {
        mysCORTCUIVDexApproxStarted.populateDateTimeLists();
        mysCORTCUIVDexApproxStarted.Label = "Approximate date started:";

        mysCORTCUIVMethApproxStarted.populateDateTimeLists();
        mysCORTCUIVMethApproxStarted.Label = "Approximate date started:";

        mysCORTCUOralMethApproxStarted.populateDateTimeLists();
        mysCORTCUOralMethApproxStarted.Label = "Approximate date started:";

        mysCORTCUOralPredApproxStarted.populateDateTimeLists();
        mysCORTCUOralPredApproxStarted.Label = "Approximate date started:";

        mysCORTPUIVDexApproxStopped.populateDateTimeLists();
        mysCORTPUIVDexApproxStopped.Label = "Approximate date stopped:";

        mysCORTPUIVDexApproxStarted.populateDateTimeLists();
        mysCORTPUIVDexApproxStarted.Label = "Approximate date started:";

        mysCORTPUIVMethApproxStopped.populateDateTimeLists();
        mysCORTPUIVMethApproxStopped.Label = "Approximate date stopped:";

        mysCORTPUIVMethApproxStarted.populateDateTimeLists();
        mysCORTPUIVMethApproxStarted.Label = "Approximate date started:";

        mysCORTPUOralMethApproxStopped.populateDateTimeLists();
        mysCORTPUOralMethApproxStopped.Label = "Approximate date stopped:";

        mysCORTPUOralMethApproxStarted.populateDateTimeLists();
        mysCORTPUOralMethApproxStarted.Label = "Approximate date started:";

        mysCORTPUOralPredApproxStopped.populateDateTimeLists();
        mysCORTPUOralPredApproxStopped.Label = "Approximate date stopped:";

        mysCORTPUOralPredApproxStarted.populateDateTimeLists();
        mysCORTPUOralPredApproxStarted.Label = "Approximate date started:";
    }

    protected void ValidatePastUseCurrentUseAdverse(object source, ServerValidateEventArgs args)
    {
        if (rblCortUseStatus.SelectedItem.Text.Equals("Current Use / Past Use", StringComparison.OrdinalIgnoreCase))
        {
            if (chkBoxCurrentUse.Checked == false && chkBoxPastUse.Checked == false)
            {
                args.IsValid = false;
                pnlCurrentPastUse.Style["display"] = "block";
            }
        }
    }

    protected void ValidatePastUseMedStartStopDate(object source, ServerValidateEventArgs args)
    {
        if (!String.IsNullOrEmpty(mysCORTPUIVDexApproxStopped.MonthYearString) && !string.IsNullOrEmpty(mysCORTPUIVDexApproxStarted.MonthYearString))
        {
            if (!IsDateValid(mysCORTPUIVDexApproxStarted.MonthYearString, mysCORTPUIVDexApproxStopped.MonthYearString))
            {
                args.IsValid = false;
                CustomValidatorPUIVDex.ErrorMessage = "Dexamethasone IV: Invalid date. ";
                return;
            }
            string stoppedDate = FormatDate(mysCORTPUIVDexApproxStopped.MonthYearString);
            string startedDate = FormatDate(mysCORTPUIVDexApproxStarted.MonthYearString);          
                if (IsStartDateLaterthanStopDate(startedDate,stoppedDate))
                {
                    args.IsValid = false;
                    CustomValidatorPUIVDex.ErrorMessage = "Dexamethasone IV: Start date is later than stop date. ";
                }                      
        }

    }
    protected void ValidatePastUseMedStartStopDatePUIVMeth(object source, ServerValidateEventArgs args)
    {
        if (!String.IsNullOrEmpty(mysCORTPUIVMethApproxStopped.MonthYearString) && !string.IsNullOrEmpty(mysCORTPUIVMethApproxStarted.MonthYearString))
        {
            if (!IsDateValid(mysCORTPUIVMethApproxStarted.MonthYearString, mysCORTPUIVMethApproxStopped.MonthYearString))
            {
                args.IsValid = false;
                CustomValidatorPUIVMeth.ErrorMessage = "Methylprednisolone IV: Invalid date. ";
                return;
            }
            string stoppedDate = FormatDate(mysCORTPUIVMethApproxStopped.MonthYearString);
            string startedDate = FormatDate(mysCORTPUIVMethApproxStarted.MonthYearString);
            if (IsStartDateLaterthanStopDate(startedDate, stoppedDate))
            {
                args.IsValid = false;
                CustomValidatorPUIVMeth.ErrorMessage = "Methylprednisolone IV: Start date is later than stop date. ";
            }
        }
    }

    protected void ValidatePastUseMedStartStopDatePUOralMeth(object source, ServerValidateEventArgs args)
    {
        if (!String.IsNullOrEmpty(mysCORTPUOralMethApproxStopped.MonthYearString) && !string.IsNullOrEmpty(mysCORTPUOralMethApproxStarted.MonthYearString))
        {
            if (!IsDateValid(mysCORTPUOralMethApproxStarted.MonthYearString, mysCORTPUOralMethApproxStopped.MonthYearString))
            {
                args.IsValid = false;
                CustomValidatorPUOralMeth.ErrorMessage = "Methylprednisolone PO: Invalid date. ";
                return;
            }
            string stoppedDate = FormatDate(mysCORTPUOralMethApproxStopped.MonthYearString);
            string startedDate = FormatDate(mysCORTPUOralMethApproxStarted.MonthYearString);
            if (IsStartDateLaterthanStopDate(startedDate, stoppedDate))
            {
                args.IsValid = false;
                CustomValidatorPUOralMeth.ErrorMessage = "Methylprednisolone PO: Start date is later than stop date. ";
            }
        }
    }

    protected void ValidatePastUseMedStartStopDatePUOralPred(object source, ServerValidateEventArgs args)
    {
        if (!String.IsNullOrEmpty(mysCORTPUOralPredApproxStopped.MonthYearString) && !string.IsNullOrEmpty(mysCORTPUOralPredApproxStarted.MonthYearString))
        {
            if (!IsDateValid(mysCORTPUOralPredApproxStarted.MonthYearString,mysCORTPUOralPredApproxStopped.MonthYearString))
            {
                args.IsValid = false;
                CustomValidatorPUOralPred.ErrorMessage = "Prednisone PO: Invalid date. ";
            }
            string stoppedDate = FormatDate(mysCORTPUOralPredApproxStopped.MonthYearString);
            string startedDate = FormatDate(mysCORTPUOralPredApproxStarted.MonthYearString);
            if (IsStartDateLaterthanStopDate(startedDate, stoppedDate))
            {
                args.IsValid = false;
                CustomValidatorPUOralPred.ErrorMessage = "Prednisone PO: Start date is later than stop date. ";
            }
        }
    }



    protected bool IsStartDateLaterthanStopDate(string pStartDate, string pStopDate)
    {
        DateTime startDate;
        DateTime stopDate;
        int dateComResult = 0;
        bool startdateIsValid = DateTime.TryParse(pStartDate, out startDate);
        bool stopDateIsValid = DateTime.TryParse(pStopDate, out stopDate);

        if (startdateIsValid && stopDateIsValid)
        {
            dateComResult = DateTime.Compare(startDate, stopDate);
        }

        return dateComResult > 0;

    }
    protected bool IsDateValid(string pStartDate, string pStoppedDate)
    {
        bool isDateValid = false;
        if ((pStoppedDate.Length > 7 || pStoppedDate.Length < 6)
                    || (pStartDate.Length > 7 || pStartDate.Length < 6))
        {
            isDateValid = false;
        }
        else
        { isDateValid = true; }

        return isDateValid;

    }

    protected string FormatDate(string pDate)
    {
        return pDate.Insert(pDate.IndexOf("/") + 1, "01/");
    
    }

    private void SetCurrentUsePastUseVisibility() 
    {
        if (rblCortUseStatus.SelectedIndex > -1)
        {
            if (rblCortUseStatus.SelectedItem.Text.Equals("Current Use / Past Use", StringComparison.OrdinalIgnoreCase))
            {
                pnlCurrentPastUse.Style["display"] = "block";
            }
            if (chkBoxCurrentUse.Checked)
            {
                pnlCurrentTherapy.Style["display"] = "block";
            }
            if (chkBoxPastUse.Checked)
            {
                pnlPastTherapy.Style["display"] = "block";
            }
        }        
    }
    #endregion
  
}