﻿<%@ Control Language="C#" AutoEventWireup="true" CodeFile="CorticosteroidsMedicationSelection.ascx.cs" Inherits="controls_CorticosteroidsMedicationSelection" %>
<%@ Register TagPrefix="MSSR" TagName="MonthYearSelector" Src="~/controls/MonthYearSelector.ascx" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<div id="divMedContainer" style="padding-left: 10px;">
    <asp:Label ID="lblMedicationName" runat="server" Text="Corticosteroids" CssClass="medinputs" Font-Bold="true" AssociatedControlID="rblCortUseStatus" />
    (only include those used for maintenance therapy, not relapse therapy)
    <br />
    <!-- Radio Button List: bound to USED_STATUS AutoPostBack="true" OnSelectedIndexChanged="rblCortUseStatus_SelectedIndexChanged"-->
    <asp:RadioButtonList ID="rblCortUseStatus" runat="server" RepeatDirection="Vertical" DataTextField="CHOICE_TEXT"
        DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" onclick="ShowHideCurrentPastUseCortico(this)">
    </asp:RadioButtonList>
    <!--Question Use Status Required Validator-->
    <asp:RequiredFieldValidator ID="RequiredFieldValidatorUseStatus" runat="server" ControlToValidate="rblCortUseStatus" ValidationGroup="OnSave"
        Display="Dynamic" ErrorMessage="Corticosteroids Use Status Selection is required."></asp:RequiredFieldValidator>
    <asp:CustomValidator ID="CortiRequiredFieldValidatorCurPastUseAdvrs" runat="server" Display="Dynamic"
        ValidationGroup="OnSave" ErrorMessage="Corticosteroids Past use or Current use selection
        is required."
        ControlToValidate="rblCortUseStatus" OnServerValidate="ValidatePastUseCurrentUseAdverse" />
    <!-- Panel for Current Use sub-questions -->
    <asp:Panel ID="pnlCurrentPastUse" runat="server" GroupingText=" ">
        <br />
        <div style="padding-left: 20px;">
            <!-- Current Use OnCheckedChanged="chkBoxCurrentUse_CheckedChanged" AutoPostBack="true" -->
            <asp:CheckBox ID="chkBoxCurrentUse" runat="server" Text="Current Therapy" onclick="CurrentUseClickedCortico(this)" /><br />
            <asp:Panel ID="pnlCurrentTherapy" runat="server">
                <div style="padding-left: 20px;">
                    <br />

                    <!-- Current Meds Area -->
                    <p style="font-weight: 600">IV Route:</p>

                    <!-- Current: IV Dex-->
                    <asp:Label ID="LabelForDexamethasoneIV" runat="server" Font-Bold="true" Text="Dexamethasone IV (Decadron)" />
                    <br />
                    <div style="padding-left: 20px;">
                        <asp:Label ID="LabelForCORTCUIVDexPharm" AssociatedControlID="rblCORTCUIVDexPharm" runat="server">Dispensing Pharmacy:</asp:Label>
                        <asp:RadioButtonList ID="rblCORTCUIVDexPharm" runat="server" RepeatDirection="Vertical" DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"
                            CssClass="" ValidationGroup="OnSave">
                        </asp:RadioButtonList>
                        <br />
                        <asp:Label ID="LabelForCORTCUIVDexSchedule" AssociatedControlID="rblCORTCUIVDexSchedule" runat="server">Schedule:</asp:Label><br />
                        <asp:RadioButtonList ID="rblCORTCUIVDexSchedule" runat="server"
                            RepeatDirection="Vertical" CssClass="" ValidationGroup="OnSave"
                            DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"
                            onclick="rblScheduleClickedCortico(this)">
                        </asp:RadioButtonList>
                        <!-- Other Schedule Panel -->
                        <asp:Panel ID="pnlCORTCUIVDexScheduleOther" runat="server">
                            <div style="padding: 5px; padding-left: 25px;">
                                <asp:TextBox ID="txtCORTCUIVDexScheduleOther" runat="server" MaxLength="50" />
                                <span class="requiredField">*</span>
                                <asp:Label ID="Label4" runat="server" Font-Italic="true" Font-Size="Smaller">
                                &nbsp;&nbsp;(50 chars max)</asp:Label>

                            </div>
                        </asp:Panel>
                        <br />
                        <MSSR:MonthYearSelector ID="mysCORTCUIVDexApproxStarted" runat="server"></MSSR:MonthYearSelector>
                    </div>
                    <br />
                    <br />

                    <!-- Current: IV Meth -->
                    <asp:Label ID="LabelForMethylprednisoloneIV" runat="server" Font-Bold="true" Text="Methylprednisolone IV (Solumedrol)" />
                    <br />
                    <div style="padding-left: 20px;">
                        <asp:Label ID="LabelForCORTCUIVMethPharm" AssociatedControlID="rblCORTCUIVMethPharm" runat="server">Dispensing Pharmacy:</asp:Label>
                        <asp:RadioButtonList ID="rblCORTCUIVMethPharm" runat="server" RepeatDirection="Vertical" DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"
                            CssClass="" ValidationGroup="OnSave">
                        </asp:RadioButtonList>
                        <br />
                        <asp:Label ID="LabelForCORTCUIVMethSchedule" AssociatedControlID="rblCORTCUIVMethSchedule" runat="server">Schedule:</asp:Label><br />
                        <asp:RadioButtonList ID="rblCORTCUIVMethSchedule" runat="server" RepeatDirection="Vertical" CssClass="" ValidationGroup="OnSave"
                            DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"
                            onclick="rblScheduleClickedCortico(this)">
                        </asp:RadioButtonList>
                        <!-- Other Schedule Panel -->
                        <asp:Panel ID="pnlCORTCUIVMethScheduleOther" runat="server">
                            <div style="padding: 5px; padding-left: 25px;">
                                <asp:TextBox ID="txtCORTCUIVMethScheduleOther" runat="server" MaxLength="50" />
                                <span class="requiredField">*</span>
                                <asp:Label ID="Label1" runat="server" Font-Italic="true" Font-Size="Smaller">
                                &nbsp;&nbsp;(50 chars max)</asp:Label>
                            </div>
                        </asp:Panel>
                        <br />
                        <MSSR:MonthYearSelector ID="mysCORTCUIVMethApproxStarted" runat="server"></MSSR:MonthYearSelector>
                    </div>
                    <br />
                    <br />

                    <p style="font-weight: 600">Oral Route</p>

                    <!-- Current: Oral Meth -->
                    <asp:Label ID="LabelForMethylprednisolonePO" runat="server" Font-Bold="true" Text="Methylprednisolone PO (Medrol)" />
                    <br />
                    <div style="padding-left: 20px;">
                        <asp:Label ID="LabelForCORTCUOralMethPharm" AssociatedControlID="rblCORTCUOralMethPharm" runat="server">Dispensing Pharmacy:</asp:Label>
                        <asp:RadioButtonList ID="rblCORTCUOralMethPharm" runat="server" RepeatDirection="Vertical" DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"
                            CssClass="" ValidationGroup="OnSave">
                        </asp:RadioButtonList>
                        <br />
                        <asp:Label ID="LabelForCORTCUOralMethSchedule" AssociatedControlID="rblCORTCUOralMethSchedule" runat="server">Schedule:</asp:Label><br />
                        <asp:RadioButtonList ID="rblCORTCUOralMethSchedule" runat="server" RepeatDirection="Vertical" CssClass="" ValidationGroup="OnSave"
                            DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"
                            onclick="rblScheduleClickedCortico(this)">
                        </asp:RadioButtonList>
                        <!-- Other Schedule Panel -->
                        <asp:Panel ID="pnlCORTCUOralMethScheduleOther" runat="server">
                            <div style="padding: 5px; padding-left: 25px;">
                                <asp:TextBox ID="txtCORTCUOralMethScheduleOther" runat="server" MaxLength="50" />
                                <span class="requiredField">*</span>
                                <asp:Label ID="Label2" runat="server" Font-Italic="true" Font-Size="Smaller">
                                &nbsp;&nbsp;(50 chars max)</asp:Label>
                            </div>
                        </asp:Panel>
                        <br />
                        <MSSR:MonthYearSelector ID="mysCORTCUOralMethApproxStarted" runat="server"></MSSR:MonthYearSelector>
                    </div>
                    <br />
                    <br />

                    <!-- Current: Oral Prednizone -->
                    <asp:Label ID="LabelForPrednisonePO" runat="server" Font-Bold="true" Text="Prednisone PO" />
                    <br />
                    <div style="padding-left: 20px;">
                        <asp:Label ID="LabelForCORTCUOralPredPharm" AssociatedControlID="rblCORTCUOralPredPharm" runat="server">Dispensing Pharmacy:</asp:Label>
                        <asp:RadioButtonList ID="rblCORTCUOralPredPharm" runat="server" RepeatDirection="Vertical" DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"
                            CssClass="" ValidationGroup="OnSave">
                        </asp:RadioButtonList>
                        <br />
                        <asp:Label ID="LabelForCORTCUOralPredSchedule" AssociatedControlID="rblCORTCUOralPredSchedule" runat="server">Schedule:</asp:Label><br />
                        <asp:RadioButtonList ID="rblCORTCUOralPredSchedule" runat="server" RepeatDirection="Vertical" CssClass="" ValidationGroup="OnSave"
                            DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"
                            onclick="rblScheduleClickedCortico(this)">
                        </asp:RadioButtonList>
                        <!-- Other Schedule Panel -->
                        <asp:Panel ID="pnlCORTCUOralPredScheduleOther" runat="server">
                            <div style="padding: 5px; padding-left: 25px;">
                                <asp:TextBox ID="txtCORTCUOralPredScheduleOther" runat="server" MaxLength="50" />
                                <span class="requiredField">*</span>
                                <asp:Label ID="Label3" runat="server" Font-Italic="true" Font-Size="Smaller">
                                &nbsp;&nbsp;(50 chars max)</asp:Label>
                            </div>
                        </asp:Panel>
                        <br />
                        <MSSR:MonthYearSelector ID="mysCORTCUOralPredApproxStarted" runat="server"></MSSR:MonthYearSelector>
                    </div>
                    <br />
                </div>
            </asp:Panel>
            <br />
            <!-- Past Use OnCheckedChanged="chkBoxPastUse_CheckedChanged" AutoPostBack="true" -->
            <asp:CheckBox ID="chkBoxPastUse" runat="server" Text="Past Use" onclick="PastUseClickedCortico(this)" /><br />
            <asp:Panel ID="pnlPastTherapy" runat="server">
                <div style="padding-left: 20px;">
                    <br />
                    <!-- Past Meds Area -->
                    <p style="font-weight: 600">IV Route</p>

                    <!-- Past: IV Dex-->
                    <asp:Label ID="LabelForPastDexamethasoneIV" runat="server" Font-Bold="true" Text="Dexamethasone IV (Decadron)" />
                    <br />
                    <div style="padding-left: 20px;">
                        <asp:Label ID="LabelForCORTPUIVDexPharm" AssociatedControlID="rblCORTPUIVDexPharm" runat="server">Dispensing Pharmacy:</asp:Label>
                        <asp:RadioButtonList ID="rblCORTPUIVDexPharm" runat="server" RepeatDirection="Vertical" DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"
                            CssClass="" ValidationGroup="OnSave">
                        </asp:RadioButtonList>
                        <br />
                        <asp:Label ID="LabelForCORTPUIVDexSchedule" AssociatedControlID="rblCORTPUIVDexSchedule" runat="server">Schedule:</asp:Label><br />
                        <asp:RadioButtonList ID="rblCORTPUIVDexSchedule" runat="server" RepeatDirection="Vertical" CssClass="" ValidationGroup="OnSave"
                            DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"
                            onclick="rblScheduleClickedCortico(this)">
                        </asp:RadioButtonList>
                        <!-- Other Schedule Panel -->
                        <asp:Panel ID="pnlCORTPUIVDexScheduleOther" runat="server">
                            <div style="padding: 5px; padding-left: 25px;">
                                <asp:TextBox ID="txtCORTPUIVDexScheduleOther" runat="server" MaxLength="50" />
                                <span class="requiredField">*</span>
                                <asp:Label ID="Label5" runat="server" Font-Italic="true" Font-Size="Smaller">
                                &nbsp;&nbsp;(50 chars max)</asp:Label>
                            </div>
                        </asp:Panel>
                        <br />
                        <MSSR:MonthYearSelector ID="mysCORTPUIVDexApproxStarted" runat="server"></MSSR:MonthYearSelector>
                        <MSSR:MonthYearSelector ID="mysCORTPUIVDexApproxStopped" runat="server"></MSSR:MonthYearSelector>
                        <asp:CustomValidator ID="CustomValidatorPUIVDex" OnServerValidate="ValidatePastUseMedStartStopDate" runat="server" ErrorMessage="Please verify...year stopped should be after year started."></asp:CustomValidator>
                        <asp:Panel runat="server">
                            <label>Total lifetime exposure to this therapy in months</label>
                            <telerik:radnumerictextbox runat="server" tooltip="Total lifetime exposure to this therapy in months" width="50px"
                                id="rdNumCORTPUIVDexScheduleTtlTmExpsrInMnt" numberformat-decimaldigits="0" minvalue="1" showspinbuttons="True" />
                        </asp:Panel>
                    </div>
                    <br />
                    <br />

                    <!-- Past: IV Meth -->
                    <asp:Label ID="LabelForPastMethylprednisoloneIV" runat="server" Font-Bold="true" Text="Methylprednisolone IV (Solumedrol)" />
                    <br />
                    <div style="padding-left: 20px;">
                        <asp:Label ID="LabelForCORTPUIVMethPharm" AssociatedControlID="rblCORTPUIVMethPharm" runat="server">Dispensing Pharmacy:</asp:Label>
                        <asp:RadioButtonList ID="rblCORTPUIVMethPharm" runat="server" RepeatDirection="Vertical" DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"
                            CssClass="" ValidationGroup="OnSave">
                        </asp:RadioButtonList>
                        <br />
                        <asp:Label ID="LabelForCORTPUIVMethSchedule" AssociatedControlID="rblCORTPUIVMethSchedule" runat="server">Schedule:</asp:Label><br />
                        <asp:RadioButtonList ID="rblCORTPUIVMethSchedule" runat="server" RepeatDirection="Vertical" CssClass="" ValidationGroup="OnSave"
                            DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"
                            onclick="rblScheduleClickedCortico(this)">
                        </asp:RadioButtonList>
                        <!-- Other Schedule Panel -->
                        <asp:Panel ID="pnlCORTPUIVMethScheduleOther" runat="server">
                            <div style="padding: 5px; padding-left: 25px;">
                                <asp:TextBox ID="txtCORTPUIVMethScheduleOther" runat="server" MaxLength="50" />
                                <span class="requiredField">*</span>
                                <asp:Label ID="Label6" runat="server" Font-Italic="true" Font-Size="Smaller">
                                &nbsp;&nbsp;(50 chars max)</asp:Label>

                            </div>
                        </asp:Panel>
                        <br />
                        <MSSR:MonthYearSelector ID="mysCORTPUIVMethApproxStarted" runat="server"></MSSR:MonthYearSelector>
                        <MSSR:MonthYearSelector ID="mysCORTPUIVMethApproxStopped" runat="server"></MSSR:MonthYearSelector>
                        <asp:CustomValidator ID="CustomValidatorPUIVMeth" OnServerValidate="ValidatePastUseMedStartStopDatePUIVMeth" runat="server"></asp:CustomValidator>
                        <asp:Panel runat="server">
                            <label>Total lifetime exposure to this therapy in months</label>
                            <telerik:radnumerictextbox runat="server" tooltip="Total lifetime exposure to this therapy in months" width="50px"
                                id="rdNumCORTPUIVMethScheduleTtlTmExpsrInMnt" numberformat-decimaldigits="0" minvalue="1" showspinbuttons="True" />
                        </asp:Panel>
                    </div>
                    <br />
                    <br />

                    <p style="font-weight: 600">Oral Route</p>

                    <!-- Past: Oral Meth -->
                    <asp:Label ID="LabelForPastMethylprednisolonePO" runat="server" Font-Bold="true" Text="Methylprednisolone PO (Medrol)" />
                    <br />
                    <div style="padding-left: 20px;">
                        <asp:Label ID="LabelForCORTPUOralMethPharm" AssociatedControlID="rblCORTPUOralMethPharm" runat="server">Dispensing Pharmacy:</asp:Label>
                        <asp:RadioButtonList ID="rblCORTPUOralMethPharm" runat="server" RepeatDirection="Vertical" DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"
                            CssClass="" ValidationGroup="OnSave">
                        </asp:RadioButtonList>
                        <br />
                        <asp:Label ID="LabelForCORTPUOralMethSchedule" AssociatedControlID="rblCORTPUOralMethSchedule" runat="server">Schedule:</asp:Label><br />
                        <asp:RadioButtonList ID="rblCORTPUOralMethSchedule" runat="server" RepeatDirection="Vertical" CssClass="" ValidationGroup="OnSave"
                            DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"
                            onclick="rblScheduleClickedCortico(this)">
                        </asp:RadioButtonList>
                        <!-- Other Schedule Panel -->
                        <asp:Panel ID="pnlCORTPUOralMethScheduleOther" runat="server">
                            <div style="padding: 5px; padding-left: 25px;">
                                <asp:TextBox ID="txtCORTPUOralMethScheduleOther" runat="server" MaxLength="50" />
                                <span class="requiredField">*</span>
                                <asp:Label ID="Label7" runat="server" Font-Italic="true" Font-Size="Smaller">
                                &nbsp;&nbsp;(50 chars max)</asp:Label>
                            </div>
                        </asp:Panel>
                        <br />
                        <MSSR:MonthYearSelector ID="mysCORTPUOralMethApproxStarted" runat="server"></MSSR:MonthYearSelector>
                        <MSSR:MonthYearSelector ID="mysCORTPUOralMethApproxStopped" runat="server"></MSSR:MonthYearSelector>
                        <asp:CustomValidator ID="CustomValidatorPUOralMeth" OnServerValidate="ValidatePastUseMedStartStopDatePUOralMeth" runat="server"></asp:CustomValidator>
                        <asp:Panel runat="server">
                            <label>Total lifetime exposure to this therapy in months</label>
                            <telerik:radnumerictextbox runat="server" tooltip="Total lifetime exposure to this therapy in months" width="50px"
                                id="rdNumCORTPUOralMethScheduleTtlTmExpsrInMnt" numberformat-decimaldigits="0" minvalue="1" showspinbuttons="True" />
                        </asp:Panel>
                    </div>
                    <br />
                    <br />

                    <!-- Past: Oral Prednizone -->
                    <asp:Label ID="LabelForPastPrednisonePO" runat="server" Font-Bold="true" Text="Prednisone PO" />
                    <br />
                    <div style="padding-left: 20px;">
                        <asp:Label ID="LabelForCORTPUOralPredPharm" AssociatedControlID="rblCORTPUOralPredPharm" runat="server">Dispensing Pharmacy:</asp:Label>
                        <asp:RadioButtonList ID="rblCORTPUOralPredPharm" runat="server" RepeatDirection="Vertical" DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"
                            CssClass="" ValidationGroup="OnSave">
                        </asp:RadioButtonList>
                        <br />
                        <asp:Label ID="LabelForCORTPUOralPredSchedule" AssociatedControlID="rblCORTPUOralPredSchedule" runat="server">Schedule:</asp:Label><br />
                        <asp:RadioButtonList ID="rblCORTPUOralPredSchedule" runat="server" RepeatDirection="Vertical" CssClass="" ValidationGroup="OnSave"
                            DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"
                            onclick="rblScheduleClickedCortico(this)">
                        </asp:RadioButtonList>
                        <!-- Other Schedule Panel -->
                        <asp:Panel ID="pnlCORTPUOralPredScheduleOther" runat="server">
                            <div style="padding: 5px; padding-left: 25px;">
                                <asp:TextBox ID="txtCORTPUOralPredScheduleOther" runat="server" MaxLength="50" />
                                <span class="requiredField">*</span>
                                <asp:Label ID="Label8" runat="server" Font-Italic="true" Font-Size="Smaller">
                                &nbsp;&nbsp;(50 chars max)</asp:Label>
                            </div>
                        </asp:Panel>
                        <br />
                        <MSSR:MonthYearSelector ID="mysCORTPUOralPredApproxStarted" runat="server"></MSSR:MonthYearSelector>
                        <MSSR:MonthYearSelector ID="mysCORTPUOralPredApproxStopped" runat="server"></MSSR:MonthYearSelector>
                        <asp:CustomValidator ID="CustomValidatorPUOralPred" OnServerValidate="ValidatePastUseMedStartStopDatePUOralPred" runat="server"></asp:CustomValidator>

                        <asp:Panel runat="server">
                            <label>Total lifetime exposure to this therapy in months</label>
                            <telerik:radnumerictextbox runat="server" tooltip="Total lifetime exposure to this therapy in months" width="50px"
                                id="rdNumCORTPUOralPredScheduleTtlTmExpsrInMnt" numberformat-decimaldigits="0" minvalue="1" showspinbuttons="True" />
                        </asp:Panel>
                    </div>
                    <br />
                </div>
            </asp:Panel>
            <br />
        </div>
    </asp:Panel>
</div>
