﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using MSSR.Security;
using MSSREnh;
using Telerik.Web.UI;
using VeteransAffairs.Registries.BusinessManager;

public partial class QualityPerformanceMetrics : BasePage
{
    private UserAccountManager _user = (UserAccountManager)HttpContext.Current.User;

    protected void Page_Load(object sender, EventArgs e)
    {
        //only adminstrators
        if (!IsUserAdmin())
        {
            Logging.WriteLogToFile("WARNING - NOT Authorized. Quality Performance aspx - Not authorized. Redirecting to error page.");
            Response.Redirect("ErrorPage.aspx?id=100");
        }
        if (!Page.IsPostBack)
        {
            SetBreadCrumb();
            PopulateFacilityDropdownList();
            PopulateMedsDropdownList();

            PopulateRdgrdPatDem(null, null, null, null, null, null, null, null);
            PopulateReportSummaryChart(null, null, null, null, null);
        }
    }

    private void PopulateRdgrdPatDem(DateTime? startDate, DateTime? endDate, string stationId, string relpase, string medName, string medNameAdditional, string icdCptCode, string edmusScore)
    {
        var rMgr = new ReportViewManager();
        rdgrdPatDem.DataSource = rMgr.GetQpmByFacilityDovMedicationDetails(startDate, endDate, stationId, relpase, medName, medNameAdditional, icdCptCode, edmusScore);
        rdgrdPatDem.DataBind();

    }

    private bool IsUserAdmin()
    {
        bool isUserAdmin = false;
        if (_user.GetRoles().Contains((int)MssrRoleCode.MSSR_SYSTEM_ADMINISTRATOR))
        {
            isUserAdmin = true;
        }
        return isUserAdmin;
    }

    public override string TopMenuName()
    {
        return "Reporting";
    }

    public override string MenuItemName()
    {
        return "QUALITY PERFORMANCE METRICS";
    }

    public override string AppObjectCode()
    {
        return "QUALITY PERFORMANCE METRICS";
    }

    private void SetBreadCrumb()
    {
        if (Master != null)
        {
            var labelBreadCrumb = (Label)Master.FindControl("LabelBreadCrumb");
            if (labelBreadCrumb != null)
                labelBreadCrumb.Text = " Quality Performance Metrics ";
        }
    }

    private void PopulateFacilityDropdownList()
    {
        ddlFacility.Items.Clear();
        List<string> limitedStationsList = null;
        if (ShouldLimitResults())
            limitedStationsList = AllowedStations();

        using (MSSRDataClassesDataContext ctx = new MSSRDataClassesDataContext())
        {
            //Get distinct list of station IDs that the current status table has results for
            var distinctStations = from stn in ctx.MSSR_CURRENT_STATUS
                                   group stn by stn.Sta3n into g
                                   select new { Key = g.Key, Count = g.Count() };
            //Loop through results, and build list to query institution table
            List<string> distinctStationsList = new List<string>();
            foreach (object currItem in distinctStations)
            {
                if (currItem != null)
                {
                    Type t = currItem.GetType();
                    System.Reflection.PropertyInfo pKey = t.GetProperty("Key");
                    string keyValue = pKey.GetValue(currItem, null).ToString();
                    if (limitedStationsList == null || limitedStationsList.Contains(keyValue))
                    {
                        distinctStationsList.Add(keyValue);
                    }
                }
            }

            var rMgr = new ReportViewManager();
            IEnumerable<GetVisnFacilityListing_Result> facility = rMgr.GetVisnFacilityListing();

            //using (VeteransAffairs.Registries.Business.RegistriesLinqDataContext bctx = new VeteransAffairs.Registries.Business.RegistriesLinqDataContext())
            //{
            var institutions = (from inst in facility
                                where distinctStationsList.Contains(inst.STATIONNUMBER)
                                //orderby inst.VISTANAME
                                select inst);

            //Get all institution information
            foreach (var inst in institutions)
            {
                if (inst.STATIONNUMBER != null)
                    ddlFacility.Items.Add(new RadComboBoxItem(inst.Name, inst.STATIONNUMBER));
            }

            // Insert 'All' option first
            if (!ShouldLimitResults())
            {
                //ddlFacility.Items.Insert(0, new RadComboBoxItem("Any Location", "All"));
                //lblFacFiltered.Visible = false;

            }
            else
            {
                lblFacFiltered.Visible = true;
            }
            //}
        }
    }

    private bool ShouldLimitResults()
    {
        int[] currentUserRoles = _user.GetRoles();
        if (currentUserRoles.Contains((int)MssrRoleCode.MSSR_LOCAL_ADMINISTRATOR) ||
            currentUserRoles.Contains((int)MssrRoleCode.MSSR_LOCAL) ||
            currentUserRoles.Contains((int)MssrRoleCode.MSSR_LOCAL_READONLY))
        {
            return true;
        }
        else
        {
            return false;
        }

    }

    private List<string> AllowedStations()
    {
        int[] institutionIDs = _user.GetInstitutions();
        using (VeteransAffairs.Registries.Business.RegistriesLinqDataContext bctx = new VeteransAffairs.Registries.Business.RegistriesLinqDataContext())
        {
            var institutions = (from inst in bctx.STD_INSTITUTIONs
                                where institutionIDs.Contains(inst.ID)
                                select inst.STATIONNUMBER);

            return institutions.ToList();
        }

    }

    private void PopulateMedsDropdownList()
    {
        using (MSSRDataClassesDataContext ctx = new MSSRDataClassesDataContext())
        {
            var results = from meds in ctx.MSSR_MEDICATIONs
                          select meds;

            List<ListItem> liList = new List<ListItem>();
            ListItem liItem = null;
            foreach (MSSR_MEDICATION currMed in (results.ToList()))
            {
                liItem = new ListItem();
                liItem.Value = currMed.ID.ToString();
                liItem.Text = currMed.MEDICATION;
                liList.Add(liItem);
            }

            //Manually add Corticosteroids to the drop down,
            //these items are not dynamic so should not need added to
            //without a coding change anyway
            liItem = new ListItem();
            liItem.Text = "Dexamethasone IV (Decadron)";
            liItem.Value = "100000";
            liList.Add(liItem);

            liItem = new ListItem();
            liItem.Text = "Methylprednisolone IV (Solumedrol)";
            liItem.Value = "100001";
            liList.Add(liItem);

            liItem = new ListItem();
            liItem.Text = "Methylprednisolone PO (Medrol)";
            liItem.Value = "100002";
            liList.Add(liItem);

            liItem = new ListItem();
            liItem.Text = "Prednisone PO";
            liItem.Value = "100003";
            liList.Add(liItem);

            liItem = new ListItem();
            liItem.Text = "CORTICOSTEROIDS (PREDNISONE) (DEXAMETHASONE)";
            liItem.Value = "PREDNISONE (DEXAMETHASONE)";
            liList.Add(liItem);

            liItem = new ListItem();
            liItem.Text = "GLATIRAMER ACETATE";
            liItem.Value = "GLATIRAMER (ACETATE)";
            liList.Add(liItem);

            liItem = new ListItem();
            liItem.Text = "TERIFLUNOMIDE";
            liItem.Value = "TERIFLUNOMIDE";
            liList.Add(liItem);

            liItem = new ListItem();
            liItem.Text = "NO MEDICATION";
            liItem.Value = "NO MEDICATION";
            liList.Add(liItem);

            liList.Sort((a, b) => string.Compare(a.Text, b.Text));

            ddlMeds.DataSource = liList;
            ddlMeds.DataBind();
            ddlMeds.Items.Insert(0, new RadComboBoxItem("Any Medication", ""));
        }
    }

    protected void btnGo_Click(object sender, EventArgs e)
    {
        DateTime? startDate = null;
        DateTime? endDate = null;
        string relapse = null;
        string medName = null;
        string tempMed = null;
        string tempMedAdditional = null;
        string listOfStations = null;
        string icdCptCode = null;
        string edmusScore = null;

        var stationIds = ddlFacility.CheckedItems;
        var ids = new StringBuilder();
        foreach (var item in stationIds)
        {
            ids.Append(item.Value).Append(",");
        }
        if (!string.IsNullOrEmpty(ids.ToString()))
        {
            listOfStations = ids.ToString();
        }
        if (rdpStartDate.SelectedDate.HasValue)
        {
            startDate = rdpStartDate.SelectedDate.Value;
        }
        if (!string.IsNullOrEmpty(rcbEdmusScore.SelectedValue))
        {
            edmusScore = rcbEdmusScore.SelectedValue;
        }
        
        if (rdpEndDate.SelectedDate.HasValue)
        {
            endDate = rdpEndDate.SelectedDate.Value;
        }
        if (!string.IsNullOrEmpty(rcbRelapseScore.SelectedValue))
        {
            relapse = rcbRelapseScore.SelectedValue;
        }
        
        if (!string.IsNullOrEmpty(rdCmbxICDCPTCode.SelectedValue))
        {
            icdCptCode = rdCmbxICDCPTCode.SelectedValue;
        }
        if (ddlMeds.SelectedIndex != -1)
        {
            medName = ddlMeds.SelectedValue;
            tempMed = ddlMeds.SelectedValue;
        }

        if (!string.IsNullOrEmpty(medName))
        {
            if (!string.IsNullOrEmpty(tempMed))
            {
                if (tempMed.Contains('(') && tempMed.Contains(')'))
                {
                    tempMedAdditional = tempMed.Substring(tempMed.LastIndexOf('(') + 1,
                        (tempMed.LastIndexOf(')')) - (tempMed.LastIndexOf('(') + 1));
                    tempMed = tempMed.Substring(0, tempMed.IndexOf('('));
                }
            }
        }
        else
        {
            tempMedAdditional = null;
            tempMed = null;
        }

        if (!string.IsNullOrEmpty(tempMedAdditional))
        {
            tempMedAdditional = tempMedAdditional.Trim();
        }
        if (!string.IsNullOrEmpty(tempMed))
        {
            tempMed = tempMed.Trim();
        }
        listOfStations = !string.IsNullOrEmpty(listOfStations) ? listOfStations.TrimEnd() : null;

        PopulateRdgrdPatDemOnDataSource(startDate, endDate, listOfStations, relapse, tempMed, tempMedAdditional, icdCptCode, edmusScore);
        PopulateReportSummaryChart(startDate, endDate, listOfStations, tempMed, tempMedAdditional);
    }



    private void PopulateRdgrdPatDemOnDataSource(DateTime? startDate, DateTime? endDate, string stationId, string relpase, string medName, string medNameAdditional, string icdCptCode, string edmusScore)
    {
        var rMgr = new ReportViewManager();
        rdgrdPatDem.DataSource = rMgr.GetQpmByFacilityDovMedicationDetails(startDate, endDate, stationId, relpase, medName, medNameAdditional, icdCptCode, edmusScore);
        rdgrdPatDem.DataBind();
    }

    private void PopulateReportSummaryChart(DateTime? startDate, DateTime? endDate, string stationId, string medName, string medNameAdditional)
    {
        var rMgr = new ReportViewManager();
        chtQualityPerforamceMetrics.DataSource = rMgr.GetQualityPerformanceMetricsSummary(startDate, endDate, stationId,  medName, medNameAdditional);
        chtQualityPerforamceMetrics.DataBind();
    }

    protected void GridViewOnNeedOfDataSource(object sender, GridNeedDataSourceEventArgs e)
    {
        PopulateGridView();
    }

    private void PopulateGridView()
    {
        DateTime? startDate = null;
        DateTime? endDate = null;
        string relapse = null;
        string medName = null;
        string tempMed = null;
        string tempMedAdditional = null;
        string listOfStations = null;
        string icdCptCode = null;
        string edmusScore = null;

        var stationIds = ddlFacility.CheckedItems;
        var ids = new StringBuilder();
        foreach (var item in stationIds)
        {
            ids.Append(item.Value).Append(",");
        }
        if (!string.IsNullOrEmpty(ids.ToString()))
        {
            listOfStations = ids.ToString();
        }
        if (rdpStartDate.SelectedDate.HasValue)
        {
            startDate = rdpStartDate.SelectedDate.Value;
        }
        if (!string.IsNullOrEmpty(rcbEdmusScore.SelectedValue))
        {
            edmusScore = rcbEdmusScore.SelectedValue;
        }

        if (rdpEndDate.SelectedDate.HasValue)
        {
            endDate = rdpEndDate.SelectedDate.Value;
        }
        if (!string.IsNullOrEmpty(rcbRelapseScore.SelectedValue))
        {
            relapse = rcbRelapseScore.SelectedValue;
        }

        if (!string.IsNullOrEmpty(rdCmbxICDCPTCode.SelectedValue))
        {
            icdCptCode = rdCmbxICDCPTCode.SelectedValue;
        }
        if (ddlMeds.SelectedIndex != -1)
        {
            medName = ddlMeds.SelectedValue;
            tempMed = ddlMeds.SelectedValue;
        }

        if (!string.IsNullOrEmpty(medName))
        {
            if (!string.IsNullOrEmpty(tempMed))
            {
                if (tempMed.Contains('(') && tempMed.Contains(')'))
                {
                    tempMedAdditional = tempMed.Substring(tempMed.LastIndexOf('(') + 1,
                        (tempMed.LastIndexOf(')')) - (tempMed.LastIndexOf('(') + 1));
                    tempMed = tempMed.Substring(0, tempMed.IndexOf('('));
                }
            }
        }
        else
        {
            tempMedAdditional = null;
            tempMed = null;
        }

        if (!string.IsNullOrEmpty(tempMedAdditional))
        {
            tempMedAdditional = tempMedAdditional.Trim();
        }
        if (!string.IsNullOrEmpty(tempMed))
        {
            tempMed = tempMed.Trim();
        }
        listOfStations = !string.IsNullOrEmpty(listOfStations) ? listOfStations.TrimEnd() : null;

        OnPopulateRdgrdPatDemOnDataSource(startDate, endDate, listOfStations, relapse, tempMed, tempMedAdditional, icdCptCode, edmusScore);
       
    }

    private void OnPopulateRdgrdPatDemOnDataSource(DateTime? startDate, DateTime? endDate, string stationId, string relpase, string medName, string medNameAdditional, string icdCptCode, string edmusScore)
    {
        var rMgr = new ReportViewManager();
        rdgrdPatDem.DataSource = rMgr.GetQpmByFacilityDovMedicationDetails(startDate, endDate, stationId, relpase, medName, medNameAdditional, icdCptCode, edmusScore);
        
    }
}