﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Linq.Dynamic;

using MSSR.Security;
using VeteransAffairs.Registries.BusinessManager;
using System.Web;

using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;
using System.IO;
using System.Drawing;

public partial class Patients : BasePage {

    #region Member Variables

    private UserAccountManager _user = (UserAccountManager)HttpContext.Current.User;

    // Request Variables for filtering from other page.
    private string NameSoSeNo = "";
    private string Location = "";
    private string Diagnosis = "";
    private string Source = "";
    private string EDMUSMin = "";
    private string EDMUSMax = "";
    private string ReportedRelapses = "";
    private string MedStatus = "";
    private string MedTimeframe = "";
    private string MedName = "";

    private bool foundRequestVar = false;

    #endregion

    #region Public Overrides

    public override string TopMenuName() {
        return "Patients";
    }

    public override string MenuItemName() {
        return "Patients";
    }

    public override string AppObjectCode() {
        return "MSSR PATIENTS";
    }

    #endregion

    #region Protected Methods

    /// <summary>
    /// Page_Load method
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e) {
        try {
            var master = this.Master as RegistryMaster;
            if (master != null)
            {
                master.SetDirtyFlag(false);
                
            }
            //(this.Master as RegistryMaster).SetDirtyFlag(false);
        } catch (Exception ex) {

            Logging.WriteLogToFile("Failure in Patients Page_Load setting dirty flag: " + ex.Message);
        }

        grdMSPatients.PageSize = (ddlPageSize.SelectedItem.Value == "-1" ? int.MaxValue : int.Parse(ddlPageSize.SelectedItem.Value));
        if (!IsPostBack)
        {
            grdMSPatients.DataSource = null;
            grdMSPatients.DataBind();

            pnlPagingControls.Visible = false;
            populateFacilityDropdownList();
            populateMedsDropdownList();

            #region Gather Request Variables

            if (!String.IsNullOrEmpty(Request.QueryString["NameSSN"]))
            {
                NameSoSeNo = Request.QueryString["NameSSN"];
                foundRequestVar = true;
            }

            if (!String.IsNullOrEmpty(Request.QueryString["Location"]))
            {
                Location = Request.QueryString["Location"];
                foundRequestVar = true;
            }

            if (!String.IsNullOrEmpty(Request.QueryString["Diagnosis"]))
            {
                Diagnosis = Request.QueryString["Diagnosis"];
                foundRequestVar = true;
            }

            if (!String.IsNullOrEmpty(Request.QueryString["Source"]))
            {
                Source = Request.QueryString["Source"];
                foundRequestVar = true;
            }

            if (!String.IsNullOrEmpty(Request.QueryString["EDMUSMin"]))
            {
                EDMUSMin = Request.QueryString["EDMUSMin"];
                foundRequestVar = true;
            }

            if (!String.IsNullOrEmpty(Request.QueryString["EDMUSMax"]))
            {
                EDMUSMax = Request.QueryString["EDMUSMax"];
                foundRequestVar = true;
            }

            if (!String.IsNullOrEmpty(Request.QueryString["ReportedRelapses"]))
            {
                ReportedRelapses = Request.QueryString["ReportedRelapses"];
                foundRequestVar = true;
            }

            if (!String.IsNullOrEmpty(Request.QueryString["MedStatus"]))
            {
                MedStatus = Request.QueryString["MedStatus"];
                foundRequestVar = true;
            }

            if (!String.IsNullOrEmpty(Request.QueryString["MedTimeframe"]))
            {
                MedTimeframe = Request.QueryString["MedTimeframe"];
                foundRequestVar = true;
            }

            if (!String.IsNullOrEmpty(Request.QueryString["MedName"]))
            {
                MedName = Request.QueryString["MedName"];
                foundRequestVar = true;
            }

            #endregion
        }
        else
        {
            if (ddlOnNotOn.SelectedValue != "Any")
            {
                ddlMeds.Enabled = true;
            }
        }

        // Call setBreadCrumb() to set the "BreadCrumb" trail in the top of the content pane.
        setBreadCrumb();
    }

    /// <summary>
    /// Called right before Render, after Page_Load.
    /// </summary>
    /// <param name="e"></param>
    protected override void OnPreRender(EventArgs e) {

        if (foundRequestVar) {
            //If we are filtering by any url paramters we want to ensure that
            //the drop down with current status, and the gender list is set to any.
            ddlOnNotOn.SelectedIndex = 0;
            rblGender.SelectedIndex = 0;

            // NameSSN filter
            if (!String.IsNullOrEmpty(NameSoSeNo)) {
                txtNameSoSeNo.Text = NameSoSeNo;
            }

            // Location filter
            if (!String.IsNullOrEmpty(Location)) {
                ddlFacility.SelectedIndex = -1;
                foreach (ListItem li in ddlFacility.Items) {
                    if (li.Text.ToLower().Contains(Location.ToLower())) {
                        li.Selected = true;
                        break;
                    }
                }
            }

            // Diagnosis filter
            if (!String.IsNullOrEmpty(Diagnosis)) {
                ddlDiagnosis.SelectedIndex = -1;
                foreach (ListItem li in ddlDiagnosis.Items) {
                    if (li.Text.ToLower().Contains(Diagnosis.ToLower())) {
                        li.Selected = true;
                        break;
                    }
                }
            }

            // Source filter
            if (!String.IsNullOrEmpty(Source)) {
                rblSource.SelectedIndex = -1;
                foreach (ListItem li in rblSource.Items) {
                    if (li.Text.ToLower().Contains(Diagnosis.ToLower())) {
                        li.Selected = true;
                        break;
                    }
                }
            }

            // EDMUSMin filter
            if (!String.IsNullOrEmpty(EDMUSMin)) {
                ddlMSScore1.ClearSelection();
                string temp = EDMUSMin.ToLower().Replace("a", "").Replace("b", "");
                foreach (ListItem li in ddlMSScore1.Items) {
                    if (li.Text.ToLower().Contains(temp)) {
                        li.Selected = true;
                        break;
                    }
                }
            }

            // EDMUSMax filter
            if (!String.IsNullOrEmpty(EDMUSMax)) {
                ddlMSScore2.ClearSelection();
                string temp = EDMUSMax.ToLower().Replace("a", "").Replace("b", "");
                foreach (ListItem li in ddlMSScore2.Items) {
                    if (li.Text.ToLower().Contains(temp)) {
                        li.Selected = true;
                        break;
                    }
                }
            }

            if (ddlMSScore2.SelectedIndex <= 0) {
                ddlMSScore2.SelectedIndex = 10;
            }

            // ReportedRelapses filter
            if (!String.IsNullOrEmpty(ReportedRelapses)) {
                rblRelapses.SelectedIndex = -1;
                foreach (ListItem li in rblRelapses.Items) {
                    if (li.Text.ToLower().Contains(ReportedRelapses.ToLower())) {
                        li.Selected = true;
                        break;
                    }
                }
            }

            // MedStatus filter
            if (!String.IsNullOrEmpty(MedStatus)) {
                ddlOnNotOn.SelectedIndex = -1;
                foreach (ListItem li in ddlOnNotOn.Items) {
                    if (li.Text.ToLower().Contains(MedStatus.ToLower())) {
                        li.Selected = true;
                        break;
                    }
                }
            }

            // MedTimeframe filter
            if (!String.IsNullOrEmpty(MedTimeframe)) {
                ddlMedsCurrentEver.SelectedIndex = -1;
                foreach (ListItem li in ddlMedsCurrentEver.Items) {
                    if (li.Text.ToLower().Contains(MedTimeframe.ToLower())) {
                        li.Selected = true;
                        break;
                    }
                }
            }

            // MedName filter
            if (!String.IsNullOrEmpty(MedName)) {
                ddlMeds.SelectedIndex = -1;
                foreach (ListItem li in ddlMeds.Items) {
                    if (li.Text.ToLower().Contains(MedName.ToLower())) {
                        //Filtering by a medication, so we only want to show those
                        //people who are on that medication
                        ddlOnNotOn.SelectedIndex = 1;
                        li.Selected = true;
                        break;
                    }
                }
            }

        } else {
            // if no filter ... set default to "all" 0 - 10
            if (ddlMSScore1.SelectedIndex <= 0) {
                ddlMSScore1.SelectedIndex = 0;
            }

            if (ddlMSScore2.SelectedIndex <= 0) {
                ddlMSScore2.SelectedIndex = 10;
            }
        }

        filterData(); // call filter with passed variables.

        base.OnPreRender(e);
    }

    /// <summary>
    /// Event Handler for btnGo click.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnGo_Click(object sender, EventArgs e) {

        HiddenFieldCurrentPageNumber.Value = "0";
        filterData();
        
        #region Old Redirect Code
        //Response.Redirect("FilterResults.aspx?Facility="
        //           + ddlFacility.SelectedValue.ToString()
        //           + "&Diagnosis="
        //           + ddlDiagnosis.SelectedValue.ToString()
        //           + "&Gender="
        //           + rblGender.SelectedValue.ToString()
        //           + "&Source="
        //           + rblSource.SelectedValue.ToString()
        //           + "&AssessmentDue="
        //           + ddlAssessmentDue.SelectedValue.ToString()
        //           + "&MSScore1="
        //           + ddlMSScore1.SelectedValue.ToString()
        //           + "&MSScore2="
        //           + ddlMSScore2.SelectedValue.ToString()
        //           + "&Relapses="
        //           + rblRelapses.SelectedValue.ToString()
        //           + "&Meds="
        //           + ddlMeds.SelectedValue.ToString()
        //            + "&CurrentEver="
        //           + ddlMedsCurrentEver.SelectedValue.ToString()
        //            + "&OnNotOn="
        //           + ddlOnNotOn.SelectedValue.ToString()
        //             );
        #endregion
    }

    /// <summary>
    /// Clears filter choices
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnClear_Click(object sender, EventArgs e) {
        txtNameSoSeNo.Text = "";
        ddlFacility.SelectedIndex = 0;
        ddlDiagnosis.SelectedIndex = 0;
        //rblSource.ClearSelection();
        ddlAssessmentDue.ClearSelection();
        rblGender.SelectedIndex = 0;
        ddlMSScore1.SelectedIndex = 0;
        ddlMSScore2.SelectedIndex = 10;
        rblRelapses.SelectedIndex = 0;
        ddlOnNotOn.SelectedIndex = 0;
        ddlMedsCurrentEver.SelectedIndex = 0;
        ddlMeds.SelectedIndex = 0;
        ddlMeds.Enabled = false;
    }

    /// <summary>
    /// Fired when columns are sorted.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void grdMSPatients_Sorting(object sender, GridViewSortEventArgs e) {

        #region get members

        String OnNotOn = "Any";
        //Get stuff from  lists in Main
        int Sta3n = 0;
        String Diagnosis = "All";
        String Source = "All";
        String Gender = "All";
        //String AssessmentType = "All";
        String AssessmentDue = "All";
        int MSScore1 = 0;
        int MSScore2 = 10;

        String Relapses = "All";
        String MedSource = "All";
        String Meds = "All";
        String MedsAdditional = string.Empty;
        String CurrentEver = "All";

        if (!(ddlFacility.SelectedValue == null)) {
            if (ddlFacility.SelectedValue.ToLower() != "all")
                Sta3n = Convert.ToInt32(ddlFacility.SelectedValue);
        }

        if (!(ddlDiagnosis.SelectedValue == null))
            Diagnosis = ddlDiagnosis.SelectedValue;
        if (!(rblSource.SelectedValue == null))
            Source = rblSource.SelectedValue;
        if (!(rblGender.SelectedValue == null))
            Gender = rblGender.SelectedValue;
        //AssessmentType = Request.QueryString["AssessmentType"];
        if (!(ddlAssessmentDue.SelectedValue == null))
            AssessmentDue = ddlAssessmentDue.SelectedValue;
        if (!(ddlMSScore1.SelectedValue == null))
            MSScore1 = Convert.ToInt32(ddlMSScore1.SelectedValue);
        if (!(ddlMSScore2.SelectedValue == null))
            MSScore2 = Convert.ToInt32(ddlMSScore2.SelectedValue);
        if (!(rblRelapses.SelectedValue == null))
            Relapses = rblRelapses.SelectedValue;
        //if (!(Request.QueryString["MedSource"] == null))
        //    MedSource = Request.QueryString["MedSource"];
        if (!(ddlMeds.SelectedValue == null)) {
            //If medication name is followed by another name in parenthesis
            //remove that name, and only use the first one for the linq query
            string tempMedAdditional = string.Empty;
            string tempMed = ddlMeds.SelectedValue;
            if (tempMed.Contains('(') && tempMed.Contains(')')) {
                tempMedAdditional = tempMed.Substring(tempMed.LastIndexOf('(') + 1, (tempMed.LastIndexOf(')')) - (tempMed.LastIndexOf('(') + 1));
                tempMed = tempMed.Substring(0, tempMed.IndexOf('('));
            }
            Meds = tempMed.Trim();
            Meds = MapMedicationNamesForSearch(Meds);
            MedsAdditional = tempMedAdditional.Trim();
        }
        if (!(ddlMedsCurrentEver.SelectedValue == null))
            CurrentEver = ddlMedsCurrentEver.SelectedValue;
        if (!(ddlOnNotOn.SelectedValue == null))
            OnNotOn = ddlOnNotOn.SelectedValue;

        String NameOrSsn = txtNameSoSeNo.Text.Trim();

        #endregion

        using (MSSRDataClassesDataContext db = new MSSRDataClassesDataContext()) {
            var pats = from eg in db.VW_MSSR_CURRENT_ALL_PATIENTs
                       orderby eg.PatientName
                       select new {
                           eg.PatientName,
                           NameSSN = eg.PatientName + " (" + eg.PatientSSN.Substring(eg.PatientSSN.Length - 4) + ")",
                           eg.PatientSID,
                           eg.PatientICN,
                           eg.Sta3n,
                           eg.PatientSSN,
                           eg.Age,
                           eg.Gender,
                           eg.BaselineAssessDate,
                           eg.LastAssessDate,
                           eg.LastAssessType,
                           eg.LastSymptomYear,
                           eg.LastMSSubType,
                           eg.LastRelapses,
                           eg.LastEdumsScore,
                           eg.PreviousEdmusScore,
                           eg.VISTANAME,
                           ProstheticsCount =eg.NumOfProsthetics,
                           PharmacyCount = eg.NumOfPharmacy,
                           LabCount = eg.NumOfLabs,
                           RadioCount = eg.NumOfRadio,
                           NumOfFeeInpatient = eg.NumOfFeeInpatient,
                           NumOfFeeOutpatient = eg.NumOfFeeOutpatient,
                           NumOfFeePharmacy = eg.NumOfFeePharmacy,
                           RxAll = (CurrentEver == "Ever" ? eg.RxEverAll + "DESC": eg.RxAll + "DESC"),
                           eg.OTHER_DMT_NAME,
                           eg.MSDiagnosis,
                           eg.Race,
                           eg.Ethnicity,
                           RaceEthnicity = (eg.Ethnicity != null && eg.Race != null ?
                                               eg.Race + " " + ((eg.Ethnicity.ToLower() == "h") ? "(H)" : "(NH)") :
                                                    eg.Ethnicity != null ?
                                                     "UNK " + eg.Ethnicity :
                                                      eg.Race),
                           //MSScore1 = (eg.PreviousEdmusScore == null ? 99 : (eg.PreviousEdmusScore.Contains("6") ? 6 : Convert.ToInt32(eg.PreviousEdmusScore)))
                           MSScore1 = (eg.LastEdumsScore == null ? 99 : (eg.LastEdumsScore.Contains("6") ? 6 : Convert.ToInt32(eg.LastEdumsScore)))
                       };

            #endregion

           if (!String.IsNullOrEmpty(NameOrSsn)) {
                pats = pats.AsQueryable().Where(eg => eg.PatientSSN.Contains(NameOrSsn.Trim())
                                                        || eg.PatientName.Trim().ToLower().Contains(NameOrSsn.Trim().ToLower()));
            }


            if (Sta3n > 0 || Sta3n == -1)
                pats = pats.AsQueryable().Where(eg => eg.Sta3n.Equals(Sta3n));

            if (Diagnosis != "All") {
                if (Diagnosis == "RRMS" || Diagnosis == "SPMS" || Diagnosis == "PPMS" || Diagnosis == "PRMS")
                    pats = pats.AsQueryable().Where(eg => eg.LastMSSubType.Equals(Diagnosis));
                else
                    pats = pats.AsQueryable().Where(eg => eg.MSDiagnosis.Equals(Diagnosis));
            }
            /*if(Source != "All")
                pats = pats.AsQueryable().Where(eg => eg.LastAssessType.Equals(Source));*/
            if (Gender != "All")
                pats = pats.AsQueryable().Where(eg => eg.Gender.Equals(Gender));
            /*if (AssessmentType != "All")
                pats = pats.AsQueryable().Where(eg => eg.LastAssessType.Equals(AssessmentType));*/
            if (AssessmentDue == "Now")
                pats = pats.AsQueryable().Where(eg => eg.LastAssessDate <= DateTime.Today.AddMonths(-12));
            else if (AssessmentDue == "1")
                pats = pats.AsQueryable().Where(eg => eg.LastAssessDate >= DateTime.Today.AddMonths(-12)
                                                          && eg.LastAssessDate <= DateTime.Today.AddMonths(-11));
            else if (AssessmentDue == "2")
                pats = pats.AsQueryable().Where(eg => eg.LastAssessDate >= DateTime.Today.AddMonths(-12)
                                                        && eg.LastAssessDate <= DateTime.Today.AddMonths(-10));
            else if (AssessmentDue == "3")
                pats = pats.AsQueryable().Where(eg => eg.LastAssessDate >= DateTime.Today.AddMonths(-12)
                                                        && eg.LastAssessDate <= DateTime.Today.AddMonths(-9));
            else if (AssessmentDue == "6")
                pats = pats.AsQueryable().Where(eg => eg.LastAssessDate >= DateTime.Today.AddMonths(-12)
                                                        && eg.LastAssessDate <= DateTime.Today.AddMonths(-6));
            else if (AssessmentDue == "6Plus")
                pats = pats.AsQueryable().Where(eg => eg.LastAssessDate >= DateTime.Today.AddMonths(-6));

            if (OnNotOn == "On") {
                //Select patients who are on a medication if "All" is 
                //selected in the medications drop down list...
                if (Meds == "All")
                    pats = pats.AsQueryable().Where(eg => eg.RxAll != null);
                //Select patients who are on a medication that equals the medication
                //drop down selelection or the meds additional in () if available...
                else if (Meds != null) {
                    if (!string.IsNullOrEmpty(MedsAdditional))
                        pats = pats.AsQueryable().Where(eg => eg.RxAll.Contains(Meds) || eg.RxAll.Contains(MedsAdditional));
                    else
                        pats = pats.AsQueryable().Where(eg => eg.RxAll.Contains(Meds));
                }
            } else if (OnNotOn == "NotOn") {
                //Select all patients who are not on any medication if 
                //"All" is selected in the medication drop down list...
                if (Meds == "All")
                    pats = pats.AsQueryable().Where(eg => eg.RxAll == null);
                //Select patients who are not on any medications, or who are
                // on medications not including the select in the medication drop down list...
                else if (Meds != null) {
                    if (!string.IsNullOrEmpty(MedsAdditional))
                        pats = pats.AsQueryable().Where(eg => (!eg.RxAll.Contains(Meds)) && (!eg.RxAll.Contains(MedsAdditional)) || eg.RxAll == null);
                    else
                        pats = pats.AsQueryable().Where(eg => (!eg.RxAll.Contains(Meds)) || eg.RxAll == null);
                }
            }
            //else if (OnNotOn == "Any")
            //{

            //}

            if (!(MSScore1 == 0 && MSScore2 == 10)) {
                pats = pats.AsQueryable().Where(eg => eg.MSScore1 >= MSScore1 && eg.MSScore1 <= MSScore2
                                           && eg.MSScore1 != 99);
            }

            if (Relapses != "All") {
                if (Relapses == "0" || Relapses == "1")
                    pats = pats.AsQueryable().Where(eg => eg.LastRelapses == Convert.ToInt32(Relapses));
                else
                    pats = pats.AsQueryable().Where(eg => eg.LastRelapses > 1);
            }

            //if (TestPatientFlag == "Y") {
            //    pats = pats.AsQueryable().Where(eg => eg.PatientSID <= 10);
            //} else {
            //    pats = pats.AsQueryable().Where(eg => eg.PatientSID > 10);
            //}

            SortDirection direction = e.SortDirection;

            if (!String.IsNullOrEmpty(HiddenFieldSortDirection.Value) && !String.IsNullOrEmpty(HiddenFieldSortExpression.Value)) {
                if (e.SortExpression == HiddenFieldSortExpression.Value) {
                    if (HiddenFieldSortDirection.Value == "ASC") {
                        HiddenFieldSortDirection.Value = "DESC";
                        direction = SortDirection.Descending;
                    } else {
                        HiddenFieldSortDirection.Value = "ASC";
                        direction = SortDirection.Ascending;
                    }
                } else {
                    HiddenFieldSortDirection.Value = "ASC";
                    direction = SortDirection.Ascending;
                }
            } else {
                HiddenFieldSortDirection.Value = (e.SortDirection == SortDirection.Ascending) ? "ASC" : "DESC";
            }

            var pats2 = pats.OrderBy(e.SortExpression + " " + HiddenFieldSortDirection.Value);
            HiddenFieldSortExpression.Value = e.SortExpression;

            int totalRecords = pats2.Count();
            HiddenFieldTotalRecords.Value = totalRecords.ToString();

            int pageCount = Convert.ToInt32(Math.Ceiling(Convert.ToDecimal(totalRecords) / Convert.ToDecimal(grdMSPatients.PageSize)));
            HiddenFieldPageCount.Value = pageCount.ToString();

            pnlRecordCount.Visible = true;

            int currentRecord = (Convert.ToInt32(HiddenFieldCurrentPageNumber.Value) * grdMSPatients.PageSize);

            lblPageStatus.Text = "Page " + (Convert.ToInt32(HiddenFieldCurrentPageNumber.Value) + 1) + " of " + HiddenFieldPageCount.Value + ".";
            lblRecordCount.Text = totalRecords + "  (Showing Records " + (currentRecord + 1) + " - " + ((currentRecord + grdMSPatients.PageSize) > totalRecords ? totalRecords : (currentRecord + grdMSPatients.PageSize)) + ")";

            if (CurrentEver == "Ever")
                grdMSPatients.Columns[13].HeaderText = "VA Ever";

            grdMSPatients.RowDataBound += new GridViewRowEventHandler(this.grdMSPatients_RowDataBound);

            grdMSPatients.DataSource = pats2.Skip(Convert.ToInt32(HiddenFieldCurrentPageNumber.Value) * grdMSPatients.PageSize).Take(grdMSPatients.PageSize);
            grdMSPatients.DataBind();

            setEnabledStatusOfPagingControls();

            pnlPagingControls.Visible = true;
        }
    }

    /// <summary>
    /// Fired on row data bound
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void grdMSPatients_RowDataBound(object sender, GridViewRowEventArgs e) {
        CultureInfo provider = CultureInfo.InvariantCulture;

        foreach (GridViewRow row in grdMSPatients.Rows) {
            if (row.RowType == DataControlRowType.DataRow) {
                if (row.RowType == DataControlRowType.Header) {
                    e.Row.CssClass = "locked";
                }
            }
        }
    }

    /// <summary>
    /// Fired on row created - to create merged cells at top of table.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void grdMSPatients_RowCreated(object sender, GridViewRowEventArgs e) {

        if (e.Row.RowType == DataControlRowType.Header) {
            #region Object creation

            //Creating a gridview object            
            GridView objGridView = (GridView)sender;

            //Creating a gridview row object
            GridViewRow objgridviewrow = new GridViewRow(1, 0, DataControlRowType.Header, DataControlRowState.Insert);

            //Creating a table cell object
            TableHeaderCell objtablecell = new TableHeaderCell();
            #endregion

            #region Merge cells
            //Add a blank cell at the first two cell headers(i.e. User Id & Name)
            //This can be achieved by making the colspan property of the table cell object as 2
            // and the text property of the table cell object will be blank
            //Henceforth, add the table cell object to the grid view row object
            /*
            AddMergedCells(objgridviewrow, objtablecell, 6, "PATIENT");
            AddMergedCells(objgridviewrow, objtablecell, 10, "MS ASSESSMENT");
            AddMergedCells(objgridviewrow, objtablecell, 2, "MS/NMO MEDS");
            
            ////Show links to all only if the user is an Administrator
            if (_user.GetRoles().Contains((int)MssrRoleCode.MSSR_SYSTEM_ADMINISTRATOR))
            {
                AddMergedCells(objgridviewrow, objtablecell, 1, "PROSTHETICS");
                AddMergedCells(objgridviewrow, objtablecell, 1, "PHARMACY");
                AddMergedCells(objgridviewrow, objtablecell, 1, "LABORATORY");
                AddMergedCells(objgridviewrow, objtablecell, 1, "RADIOLOGY");
                AddMergedCells(objgridviewrow, objtablecell, 3, "FEE BASED");                
            }

            */
            ///*
            if (IsUserAuthorizedToEditSurvey())
            {
                AddMergedCells(objgridviewrow, objtablecell, 8, "PATIENT");
                AddMergedCells(objgridviewrow, objtablecell, 8, "MS ASSESSMENT");
                AddMergedCells(objgridviewrow, objtablecell, 2, "MS/NMO MEDS");

                ////Show links to all only if the user is an Administrator
                if (_user.GetRoles().Contains((int)MssrRoleCode.MSSR_SYSTEM_ADMINISTRATOR))
                {
                    AddMergedCells(objgridviewrow, objtablecell, 1, "PROSTHETICS");
                    AddMergedCells(objgridviewrow, objtablecell, 1, "PHARMACY");
                    AddMergedCells(objgridviewrow, objtablecell, 1, "LABORATORY");
                    AddMergedCells(objgridviewrow, objtablecell, 1, "RADIOLOGY");
                    AddMergedCells(objgridviewrow, objtablecell, 3, "FEE BASED");
                }
            }
            else
            {
                AddMergedCells(objgridviewrow, objtablecell, 8, "PATIENT");
                AddMergedCells(objgridviewrow, objtablecell, 8, "MS ASSESSMENT");
                AddMergedCells(objgridviewrow, objtablecell, 2, "MS/NMO MEDS");

                ////Show links to all only if the user is an Administrator
                if (_user.GetRoles().Contains((int)MssrRoleCode.MSSR_SYSTEM_ADMINISTRATOR))
                {
                    AddMergedCells(objgridviewrow, objtablecell, 1, "PROSTHETICS");
                    AddMergedCells(objgridviewrow, objtablecell, 1, "PHARMACY");
                    AddMergedCells(objgridviewrow, objtablecell, 1, "LABORATORY");
                    AddMergedCells(objgridviewrow, objtablecell, 1, "RADIOLOGY");
                    AddMergedCells(objgridviewrow, objtablecell, 3, "FEE BASED");
                }   
            }
            //*/
            objGridView.Controls[0].Controls.AddAt(0, objgridviewrow);
            #endregion
        }
        ////Show links to all only if the user is an Administrator
        if (_user.GetRoles().Contains((int)MssrRoleCode.MSSR_SYSTEM_ADMINISTRATOR))
        {
            //edit survey.
            if (IsUserAuthorizedToEditSurvey())
            {
                ((System.Web.UI.WebControls.GridView)(sender)).Columns[0].Visible = true;
                ((System.Web.UI.WebControls.GridView)(sender)).Columns[1].Visible = true;
            }            
           
            //non-fee based
            ((System.Web.UI.WebControls.GridView)(sender)).Columns[18].Visible = true;
            ((System.Web.UI.WebControls.GridView)(sender)).Columns[19].Visible = true;
            ((System.Web.UI.WebControls.GridView)(sender)).Columns[20].Visible = true;
            ((System.Web.UI.WebControls.GridView)(sender)).Columns[21].Visible = true;
            //Fee based
            ((System.Web.UI.WebControls.GridView)(sender)).Columns[22].Visible = true;
            ((System.Web.UI.WebControls.GridView)(sender)).Columns[23].Visible = true;
            ((System.Web.UI.WebControls.GridView)(sender)).Columns[24].Visible = true;
            //sets the selected index to Culpepper algorithm
            //rblSource.SelectedIndex = 0;
            rblSource.Items[0].Enabled = true;
            rblSource.Items[1].Enabled = true;
            rblSource.Items[2].Enabled = true;
        }
        else
        {
            //nothing for now..
        }

    }

    /// <summary>
    /// Hide or Show instructions
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lnkBtnToggleFilters_OnClick(object sender, EventArgs e) {
        if (pnlFilterArea.Visible) {
            pnlFilterArea.Visible = false;
            lnkBtnToggleFilters.Text = "Show";
        } else {
            pnlFilterArea.Visible = true;
            lnkBtnToggleFilters.Text = "Hide";
        }
    }
    #region Export To Excel Overide Function
    /// <summary>
    /// Export To Excel Overide Function
    /// </summary>
    /// <param name="GridView1"></param>
    /// <param name="filename"></param>
    private void ExportToExcel(GridView GridView1, string filename)
    {
        PrepareGridViewForExport(GridView1);

        string attachment = "attachment; filename=" + filename;
        Response.ClearContent();
        Response.AddHeader("content-disposition", attachment);
        Response.ContentType = "application/ms-excel";
        StringWriter sw = new StringWriter();
        HtmlTextWriter htw = new HtmlTextWriter(sw);

        // Create a form to contain the grid
        HtmlForm frm = new HtmlForm();
        GridView1.Parent.Controls.Add(frm);
        frm.Attributes["runat"] = "server";
        frm.Controls.Add(GridView1);
        frm.RenderControl(htw);

        //style to format numbers to string
        string style = @"<style> .textmode { mso-number-format:\@; } </style>";
        Response.Write(style);
        Response.Write(sw.ToString());
        Response.Flush();
        Response.End();

    }
    /// <summary>
    /// Button click to export grid to Excel.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>

    protected void imgBtnExportToExcel_Click(object sender, System.Web.UI.ImageClickEventArgs e)
    {

        string fileName = "Patients_Export_" + DateTime.Now.ToLocalTime() + ".xls";
        ExportToExcel(grdMSPatients, fileName);

    }
    #endregion
    /// <summary>
    /// Button click to export grid to Excel.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void imgBtnExportToExcel_Click_old(object sender, System.Web.UI.ImageClickEventArgs e) {
        //string sortExpression = HiddenFieldSortExpression.Value; // p13
        //string sortDirection = HiddenFieldSortDirection.Value; // p14

        //// filters - txtNameSoSeNo, ddlFacility, ddlDiagnosis, rblSource, ddlAssessmentDue, rblGender, ddlMSScore1, ddlMSScore2, rblRelapses, ddlOnNotOn, ddlMedsCurrentEver, ddlMeds
        //string nameSSN = txtNameSoSeNo.Text; // p1
        //string selectedFacility = ddlFacility.SelectedValue; // p2
        //string selectedDiagnosis = ddlDiagnosis.SelectedValue; // p3
        //string selectedSource = rblSource.SelectedValue; // p4
        //string assessmentDue = ddlAssessmentDue.SelectedValue; // p5
        //string selectedGender = rblGender.SelectedValue; // p6
        //string msScore1 = ddlMSScore1.SelectedValue; // p7
        //string msScore2 = ddlMSScore2.SelectedValue; // p8
        //string relapses = rblRelapses.SelectedValue; // p9
        //string onNotOn = ddlOnNotOn.SelectedValue; // p10
        //string medsCurrentEver = ddlMedsCurrentEver.SelectedValue; // p11
        //string selectedMedication = ddlMeds.SelectedValue; // p12

        //StringBuilder sbUrl = new StringBuilder();
        //sbUrl.Append("p1=" + Server.UrlEncode(nameSSN));
        //sbUrl.Append("&p2=" + Server.UrlEncode(selectedFacility));
        //sbUrl.Append("&p3=" + Server.UrlEncode(selectedDiagnosis));
        //sbUrl.Append("&p4=" + Server.UrlEncode(selectedSource));
        //sbUrl.Append("&p5=" + Server.UrlEncode(assessmentDue));
        //sbUrl.Append("&p6=" + Server.UrlEncode(selectedGender));
        //sbUrl.Append("&p7=" + Server.UrlEncode(msScore1));
        //sbUrl.Append("&p8=" + Server.UrlEncode(msScore2));
        //sbUrl.Append("&p9=" + Server.UrlEncode(relapses));
        //sbUrl.Append("&p10=" + Server.UrlEncode(onNotOn));
        //sbUrl.Append("&p11=" + Server.UrlEncode(medsCurrentEver));
        //sbUrl.Append("&p12=" + Server.UrlEncode(selectedMedication));
        //sbUrl.Append("&p13=" + Server.UrlEncode(sortExpression));
        //sbUrl.Append("&p14=" + Server.UrlEncode(sortDirection));

        /*
        string destinationUrl = string.Concat("/MSSR_UserInterface/Export/ExportPatientToExcel.aspx?", sbUrl.ToString());
        string currentHost = Request.Url.Host;
        if (Helpers.IsDestinationUrlLocal(destinationUrl, currentHost))
        {
            Response.Redirect(destinationUrl);
        }*/
        //Response.Redirect("Export/ExportPatientToExcel.aspx?" + sbUrl.ToString());
    }

  

    #region Private Methods

    /// <summary>
    /// Takes in a medication name and then handles those that have
    /// special mapping needed for searching.
    /// This handles naming inconsistencies in the legacy data.
    /// </summary>
    /// <param name="inputName"></param>
    /// <returns></returns>
    private string MapMedicationNamesForSearch(string inputName) {
        if (inputName.Equals("Dimethyl Fumerate")) {
            return "Dimethyl Fum";
        }
        //if (inputName.Equals("GLATIRAMER ACETATE", StringComparison.OrdinalIgnoreCase))
        //{
        //    return "Glatiramer (Copaxone)";
        //}
        //if (inputName.ToUpper().Equals("CORTICOSTEROIDS"))
        //{
        //    return "PREDNISONE DEXAMETHASONE";
        //}
        return inputName;
    }

    /// <summary>
    /// Determines based on the current users role whether
    /// or not the data they see on this screen needs to be filtered down
    /// </summary>
    /// <returns></returns>
    private bool shouldLimitResults() {
        int[] currentUserRoles = _user.GetRoles();
        if (currentUserRoles.Contains((int)MssrRoleCode.MSSR_LOCAL_ADMINISTRATOR) ||
            currentUserRoles.Contains((int)MssrRoleCode.MSSR_LOCAL) ||
            currentUserRoles.Contains((int)MssrRoleCode.MSSR_LOCAL_READONLY)) {
            return true;
        } else {
            return false;
        }

    }

    /// <summary>
    /// Returns a list of allowed station ids for users who need
    /// the data on this page to be filtered down
    /// </summary>
    /// <returns></returns>
    private List<string> allowedStations() {
        int[] institutionIDs = _user.GetInstitutions();
        using (VeteransAffairs.Registries.Business.RegistriesLinqDataContext bctx = new VeteransAffairs.Registries.Business.RegistriesLinqDataContext()) {
            var institutions = (from inst in bctx.STD_INSTITUTIONs
                                where institutionIDs.Contains(inst.ID)
                                select inst.STATIONNUMBER);

            return institutions.ToList();
        }

    }

    /// <summary>
    /// setBreadCrumb: Finds the LabelBreadCrumb control in the MasterPage.  Once found, the label is set with the desired text. 
    /// This text may also contain concatenated strings and links.
    /// </summary>
    private void setBreadCrumb() {
        Label LabelBreadCrumb = (Label)Master.FindControl("LabelBreadCrumb");
        LabelBreadCrumb.Text = "MSSR Patients";
    }

    /// <summary>
    /// Calls the LINQ context and populates the Facility DropDownList control.
    /// </summary>
    private void populateFacilityDropdownList() {
        ddlFacility.Items.Clear();
        List<string> limitedStationsList = null;
        if (shouldLimitResults())
            limitedStationsList = allowedStations();

        using (MSSRDataClassesDataContext ctx = new MSSRDataClassesDataContext()) {
            //Get distinct list of station IDs that the current status table has results for
            var distinctStations = from stn in ctx.MSSR_CURRENT_STATUS
                                   group stn by stn.Sta3n into g
                                   select new { Key = g.Key, Count = g.Count() };
            //Loop through results, and build list to query institution table
            List<string> distinctStationsList = new List<string>();
            foreach (object currItem in distinctStations) {
                if (currItem != null) {
                    Type t = currItem.GetType();
                    System.Reflection.PropertyInfo pKey = t.GetProperty("Key");
                    string keyValue = pKey.GetValue(currItem, null).ToString();
                    if (limitedStationsList == null || limitedStationsList.Contains(keyValue)) {
                        distinctStationsList.Add(keyValue);
                    }
                }
            }

            using (VeteransAffairs.Registries.Business.RegistriesLinqDataContext bctx = new VeteransAffairs.Registries.Business.RegistriesLinqDataContext()) {
                var institutions = (from inst in bctx.STD_INSTITUTIONs
                                    where distinctStationsList.Contains(inst.STATIONNUMBER)
                                    orderby inst.VISTANAME
                                    select inst);

                //Get all institution information
                foreach (VeteransAffairs.Registries.Business.STD_INSTITUTION inst in institutions) {
                    if (inst.STATIONNUMBER != null)
                        ddlFacility.Items.Add(new ListItem(inst.VISTANAME + " (" + inst.STATIONNUMBER + ")", inst.STATIONNUMBER.ToString()));
                }

                // Insert 'All' option first
                if (!shouldLimitResults()) {
                    ddlFacility.Items.Insert(0, new ListItem("Any Location", "All"));
                    lblFacFiltered.Visible = false;

                } else {
                    lblFacFiltered.Visible = true;
                }
            }
        }
    }

    /// <summary>
    /// Calls the LINQ context and populates the Meds DropDownList control.
    /// </summary>
    private void populateMedsDropdownList() {
        using (MSSRDataClassesDataContext ctx = new MSSRDataClassesDataContext()) {
            var results = from meds in ctx.MSSR_MEDICATIONs
                          select meds;

            List<ListItem> liList = new List<ListItem>();
            ListItem liItem = null;
            foreach (MSSR_MEDICATION currMed in (results.ToList())) {
                liItem = new ListItem();
                liItem.Value = currMed.ID.ToString();
                liItem.Text = currMed.MEDICATION;
                liList.Add(liItem);
            }

            //Manually add Corticosteroids to the drop down,
            //these items are not dynamic so should not need added to
            //without a coding change anyway
            liItem = new ListItem();
            liItem.Text = "Dexamethasone IV (Decadron)";
            liItem.Value = "100000";
            liList.Add(liItem);

            liItem = new ListItem();
            liItem.Text = "Methylprednisolone IV (Solumedrol)";
            liItem.Value = "100001";
            liList.Add(liItem);

            liItem = new ListItem();
            liItem.Text = "Methylprednisolone PO (Medrol)";
            liItem.Value = "100002";
            liList.Add(liItem);

            liItem = new ListItem();
            liItem.Text = "Prednisone PO";
            liItem.Value = "100003";
            liList.Add(liItem);

            liItem = new ListItem();
            liItem.Text = "CORTICOSTEROIDS (PREDNISONE) (DEXAMETHASONE)";
            liItem.Value = "PREDNISONE (DEXAMETHASONE)";
            liList.Add(liItem);

            liItem = new ListItem();
            liItem.Text = "GLATIRAMER ACETATE";
            liItem.Value = "GLATIRAMER (ACETATE)";
            liList.Add(liItem);

            liItem = new ListItem();
            liItem.Text = "TERIFLUNOMIDE";
            liItem.Value = "TERIFLUNOMIDE";
            liList.Add(liItem);

            liItem = new ListItem();
            liItem.Text = "INTERFERON BETA-1B (EXTAVIA)";
            liItem.Value = "INTERFERON BETA-1B (EXTAVIA)";
            liList.Add(liItem);

            liItem = new ListItem();
            liItem.Text = "GLATIRAMER (GLATOPA)";
            liItem.Value = "GLATIRAMER (GLATOPA)";
            liList.Add(liItem);

            liItem = new ListItem();
            liItem.Text = "INTERFERON BETA-1A (PLEGRITY)";
            liItem.Value = "INTERFERON BETA-1A (PLEGRITY)";
            liList.Add(liItem);

            liItem = new ListItem();
            liItem.Text = "NO MEDICATION";
            liItem.Value = "NO MEDICATION";
            liList.Add(liItem);

            liList.Sort((a, b) => string.Compare(a.Text, b.Text));

            ddlMeds.DataSource = liList;
            ddlMeds.DataBind();
            ddlMeds.Items.Insert(0, new ListItem("Any Medication", "All"));
        }
    }

    /// <summary>
    /// Filter and query performed for data matching filters.
    /// </summary>
    private void filterData() {
        #region Gather Request Variables

        // (Legacy)

        //Get stuff from  lists in Main
        int Sta3n = 0;
        String NameOrSsn = "";
        String Diagnosis = "All";
        String Source = "All";
        String Gender = "All";
        //String AssessmentType = "All";
        String AssessmentDue = "All";
        int MSScore1 = 0;
        int MSScore2 = 10;

        String Relapses = "All";
        String MedSource = "All";
        String Meds = "All";
        string MedsAdditional = string.Empty; // List<string> MedsAdditional = new List<string>();
        String CurrentEver = "All";
        String OnNotOn = "Any";

        if (!string.IsNullOrEmpty(ddlFacility.SelectedValue)) {
            if (ddlFacility.SelectedValue.ToLower() != "all")
                Sta3n = Convert.ToInt32(ddlFacility.SelectedValue);
        } else {
            Sta3n = -1;
        }

        NameOrSsn = txtNameSoSeNo.Text.Trim();

        if (!(ddlDiagnosis.SelectedValue == null))
            Diagnosis = ddlDiagnosis.SelectedValue;
        if (!(rblSource.SelectedValue == null))
            Source = rblSource.SelectedValue;
        if (!(rblGender.SelectedValue == null))
            Gender = rblGender.SelectedValue;
        //AssessmentType = Request.QueryString["AssessmentType"];
        if (!(ddlAssessmentDue.SelectedValue == null))
            AssessmentDue = ddlAssessmentDue.SelectedValue;
        if (!(ddlMSScore1.SelectedValue == null))
            MSScore1 = Convert.ToInt32(ddlMSScore1.SelectedValue);
        if (!(ddlMSScore2.SelectedValue == null))
            MSScore2 = Convert.ToInt32(ddlMSScore2.SelectedValue);
        if (!(rblRelapses.SelectedValue == null))
            Relapses = rblRelapses.SelectedValue;
        //if (!(Request.QueryString["MedSource"] == null))
        //    MedSource = Request.QueryString["MedSource"];
        if (!(ddlMeds.SelectedValue == null)) {
            //If medication name is followed by another name in parenthesis
            //remove that name, and only use the first one for the linq query
            string tempMedAdditional = string.Empty; //List<string> tempMedAdditional = new List<string>();
            string tempMed = ddlMeds.SelectedValue;
            if (tempMed.Contains('(') && tempMed.Contains(')')) {
                tempMedAdditional = tempMed.Substring(tempMed.LastIndexOf('(') + 1, (tempMed.LastIndexOf(')')) - (tempMed.LastIndexOf('(') + 1));
                tempMed = tempMed.Substring(0, tempMed.IndexOf('('));
            }
            Meds = tempMed.Trim();
            Meds = MapMedicationNamesForSearch(Meds);
            MedsAdditional = tempMedAdditional;
        }
        if (!(ddlMedsCurrentEver.SelectedValue == null))
            CurrentEver = ddlMedsCurrentEver.SelectedValue; //CurrentEver = "Ever";//
        if (!(ddlOnNotOn.SelectedValue == null))
            OnNotOn = ddlOnNotOn.SelectedValue;

        #endregion

        using (MSSRDataClassesDataContext db = new MSSRDataClassesDataContext()) {
            var pats = from eg in db.VW_MSSR_CURRENT_ALL_PATIENTs
                       orderby eg.PatientName
                       select new {
                           eg.PatientName,
                           NameSSN = eg.PatientName + " (" + eg.PatientSSN.Substring(eg.PatientSSN.Length - 4) + ")",
                           eg.PatientSID,
                           eg.PatientICN,
                           eg.Sta3n,
                           eg.PatientSSN,
                           eg.Age,
                           eg.Gender,
                           eg.BaselineAssessDate,
                           eg.LastAssessDate,
                           eg.LastAssessType,
                           eg.LastSymptomYear,
                           eg.LastMSSubType,
                           eg.LastRelapses,
                           eg.LastEdumsScore,
                           eg.PreviousEdmusScore,
                           eg.VISTANAME,                           
                           ProstheticsCount =eg.NumOfProsthetics,
                           PharmacyCount = eg.NumOfPharmacy,
                           LabCount = eg.NumOfLabs,
                           RadioCount = eg.NumOfRadio,
                           NumOfFeeInpatient = eg.NumOfFeeInpatient,
                           NumOfFeeOutpatient = eg.NumOfFeeOutpatient,
                           NumOfFeePharmacy = eg.NumOfFeePharmacy,
                           RxAll = (CurrentEver == "Ever" ? eg.RxEverAll : eg.RxAll),//eg.RxAll),
                           eg.OTHER_DMT_NAME,
                           eg.MSDiagnosis,
                           eg.Race,
                           eg.Ethnicity,
                           RaceEthnicity = (eg.Ethnicity != null && eg.Race != null ?
                                               eg.Race + " " + ((eg.Ethnicity.ToLower() == "h") ? "(H)" : "(NH)") :
                                                    eg.Ethnicity != null ?
                                                     "UNK " + eg.Ethnicity :
                                                      eg.Race),
                           //MSScore1 = (eg.PreviousEdmusScore == null ? 99 : (eg.PreviousEdmusScore.Contains("6") ? 6 : Convert.ToInt32(eg.PreviousEdmusScore)))
                           MSScore1 = (eg.LastEdumsScore == null ? 99 : (eg.LastEdumsScore.Contains("6") ? 6 : Convert.ToInt32(eg.LastEdumsScore)))
                       };
          
            if (Sta3n > 0 || Sta3n == -1)
                pats = pats.AsQueryable().Where(eg => eg.Sta3n.Equals(Sta3n));

            if (!String.IsNullOrEmpty(NameOrSsn)) {
                pats = pats.AsQueryable().Where(eg => eg.PatientSSN.Contains(NameOrSsn.Trim())
                                                        || eg.PatientName.Trim().ToLower().Contains(NameOrSsn.Trim().ToLower()));
            }

            if (Diagnosis != "All") {
                if (Diagnosis == "RRMS" || Diagnosis == "SPMS" || Diagnosis == "PPMS" || Diagnosis == "PRMS")
                    pats = pats.AsQueryable().Where(eg => eg.LastMSSubType.Equals(Diagnosis));
                else
                    pats = pats.AsQueryable().Where(eg => eg.MSDiagnosis.Equals(Diagnosis));
            }

            if (Source == "Assessment")
            {
                pats = pats.AsQueryable().Where(eg => eg.LastAssessDate.HasValue);                
                //grdMSPatients.Columns["Sta3n"].Visible = false;
               
            }
            if (Source == "NonAssessment")
                pats = pats.AsQueryable().Where(eg => eg.LastAssessDate == null);
                        

            if (Gender != "All")
                pats = pats.AsQueryable().Where(eg => eg.Gender.Equals(Gender));
            /*if (AssessmentType != "All")
                pats = pats.AsQueryable().Where(eg => eg.LastAssessType.Equals(AssessmentType));*/
            if (AssessmentDue == "Now")
                pats = pats.AsQueryable().Where(eg => eg.LastAssessDate <= DateTime.Today.AddMonths(-12));
            else if (AssessmentDue == "1")
                pats = pats.AsQueryable().Where(eg => eg.LastAssessDate >= DateTime.Today.AddMonths(-12)
                                                          && eg.LastAssessDate <= DateTime.Today.AddMonths(-11));
            else if (AssessmentDue == "2")
                pats = pats.AsQueryable().Where(eg => eg.LastAssessDate >= DateTime.Today.AddMonths(-12)
                                                        && eg.LastAssessDate <= DateTime.Today.AddMonths(-10));
            else if (AssessmentDue == "3")
                pats = pats.AsQueryable().Where(eg => eg.LastAssessDate >= DateTime.Today.AddMonths(-12)
                                                        && eg.LastAssessDate <= DateTime.Today.AddMonths(-9));
            else if (AssessmentDue == "6")
                pats = pats.AsQueryable().Where(eg => eg.LastAssessDate >= DateTime.Today.AddMonths(-12)
                                                        && eg.LastAssessDate <= DateTime.Today.AddMonths(-6));
            else if (AssessmentDue == "6Plus")
                pats = pats.AsQueryable().Where(eg => eg.LastAssessDate >= DateTime.Today.AddMonths(-6));

            if (OnNotOn == "On") {
                //Select patients who are on a medication if "All" is 
                //selected in the medications drop down list...
                if (Meds == "All")
                    pats = pats.AsQueryable().Where(eg => eg.RxAll != null);
                //Select patients who are on a medication that equals the medication
                //drop down selelection or the meds additional in () if available...
                else if (Meds.ToUpper() == "NO MEDICATION")
                    pats = pats.AsQueryable().Where(eg => eg.RxAll == null || eg.RxAll.Trim().Length == 0);

                else if (Meds != null)
                {
                    if (!string.IsNullOrEmpty(MedsAdditional))
                        if (Meds.ToUpper() == "CORTICOSTEROIDS")
                            pats = pats.AsQueryable().Where(eg => eg.RxAll.ToUpper().Contains("PREDNISONE") || eg.RxAll.ToUpper().Contains("DEXAMETHASONE") || eg.RxAll.ToUpper().Contains("METHYLPREDNISOLONE IV (SOLUMEDROL)"));
                        else if (Meds.ToUpper() == "GLATIRAMER ACETATE")
                            pats = pats.AsQueryable().Where(eg => eg.RxAll.ToUpper().Contains("GLATIRAMER") || eg.RxAll.ToUpper().Contains("ACETATE") || eg.RxAll.ToUpper().Contains("COPAXONE") || eg.RxAll.ToUpper().Contains("GLATOPA"));
                        else if (Meds.ToUpper() == "GLATIRAMER")
                            pats = pats.AsQueryable().Where(eg => eg.RxAll.ToUpper().Contains("GLATIRAMER") && eg.RxAll.ToUpper().Contains("GLATOPA"));
                        else if (Meds.ToUpper().Contains("DACLIZUMAB"))
                            pats = pats.AsQueryable().Where(eg => eg.RxAll.ToUpper().Contains("DACLIZUMAB") || eg.RxAll.ToUpper().Contains("ZENAPAX") || eg.RxAll.ToUpper().Contains("ZIMBRYTA"));
                        else if (Meds.ToUpper() == "DIMETHYL FUMARATE")
                            pats = pats.AsQueryable().Where(eg => eg.RxAll.ToUpper().Contains("DIMETHYL") || eg.RxAll.ToUpper().Contains("FUMARATE") || eg.RxAll.ToUpper().Contains("TECFIDERA"));
                        else if (Meds.ToUpper() == "MYCOPHENOLATE MOFETIL")
                            pats = pats.AsQueryable().Where(eg => eg.RxAll.ToUpper().Contains("MYCOPHENOLATE MOFETIL") || eg.RxAll.ToUpper().Contains("MYCOPHENOLATE (GOLDEN STATE) 250MG CAP"));
                        else if (Meds.ToUpper() == "TERIFLUNOMIDE")
                            pats = pats.AsQueryable().Where(eg => eg.RxAll.ToUpper().Contains("TERIFLUNOMIDE"));
                        else if (Meds.ToUpper() == "INTERFERON BETA-1A" && MedsAdditional.ToUpper() == "AVONEX")
                            pats = pats.AsQueryable().Where(eg => (eg.RxAll.ToUpper().Contains("INTERFERON BETA-1A") && eg.RxAll.ToUpper().Contains("AVONEX")) || eg.RxAll.ToUpper().Contains("PEGINTERFERON BETA-1A")
                                || eg.RxAll.ToUpper().Contains("INTERFERON BETA-1A INJ 30MCG POWDER/VIAL"));
                        else if (Meds.ToUpper() == "INTERFERON BETA-1A" && MedsAdditional.ToUpper() == "REBIF")
                            pats = pats.AsQueryable().Where(eg => (eg.RxAll.ToUpper().Contains("INTERFERON BETA-1A") && eg.RxAll.ToUpper().Contains("REBIF")));
                        else if (Meds.ToUpper() == "INTERFERON BETA-1B" && MedsAdditional.ToUpper() == "EXTAVIA")
                            pats = pats.AsQueryable().Where(eg => (eg.RxAll.ToUpper().Contains("INTERFERON BETA-1B") && eg.RxAll.ToUpper().Contains("EXTAVIA")));
                        else if (Meds.ToUpper() == "INTERFERON BETA-1A" && MedsAdditional.ToUpper() == "PLEGRITY")
                            pats = pats.AsQueryable().Where(eg => (eg.RxAll.ToUpper().Contains("INTERFERON BETA-1A") && eg.RxAll.ToUpper().Contains("PEGINTERFERON BETA-1A")));
                        else if (Meds.ToUpper() == "OTHER DMTS")
                            pats = pats.AsQueryable().Where(eg => eg.OTHER_DMT_NAME != null);
                        else
                            pats = pats.AsQueryable().Where(eg => eg.RxAll.Contains(Meds.ToUpper()) || eg.RxAll.Contains(MedsAdditional.ToUpper()));
                    else
                        pats = pats.AsQueryable().Where(eg => eg.RxAll.Contains(Meds.ToUpper()));
                }
            } else if (OnNotOn == "NotOn") {
                //Select all patients who are not on any medication if 
                //"All" is selected in the medication drop down list...
                if (Meds == "All")
                    pats = pats.AsQueryable().Where(eg => eg.RxAll == null || eg.RxAll == "");
                //Select patients who are not on any medications, or who are
                // on medications not including the select in the medication drop down list...
                else if (Meds != null) {
                    if (!string.IsNullOrEmpty(MedsAdditional))
                        pats = pats.AsQueryable().Where(eg => (!eg.RxAll.Contains(Meds)) && (!eg.RxAll.Contains(MedsAdditional)) || eg.RxAll == null);                
                    else
                        pats = pats.AsQueryable().Where(eg => (!eg.RxAll.Contains(Meds)) || eg.RxAll == null);
                }
            }
            //else if (OnNotOn == "Any")
            //{           
            //}

            if (!(MSScore1 == 0 && MSScore2 == 10)) {
                pats = pats.AsQueryable().Where(eg => eg.MSScore1 >= MSScore1 && eg.MSScore1 <= MSScore2
                                           && eg.MSScore1 != 99);

            }

            if (Relapses != "All") {
                if (Relapses == "0" || Relapses == "1")
                    pats = pats.AsQueryable().Where(eg => eg.LastRelapses == Convert.ToInt32(Relapses));
                else
                    pats = pats.AsQueryable().Where(eg => eg.LastRelapses > 1);
            }

            //if (TestPatientFlag == "Y") {
            //    pats = pats.AsQueryable().Where(eg => eg.PatientSID <= 10);
            //} else {
            //    pats = pats.AsQueryable().Where(eg => eg.PatientSID > 10);
            //}

            int totalRecords = pats.Count();
            HiddenFieldTotalRecords.Value = totalRecords.ToString();

            int pageCount = Convert.ToInt32(Math.Ceiling(Convert.ToDecimal(totalRecords) / Convert.ToDecimal(grdMSPatients.PageSize)));
            HiddenFieldPageCount.Value = pageCount.ToString();

            pnlRecordCount.Visible = true;

            if (!String.IsNullOrEmpty(HiddenFieldSortDirection.Value) && !String.IsNullOrEmpty(HiddenFieldSortExpression.Value)) {
                pats = pats.OrderBy(HiddenFieldSortExpression.Value + " " + HiddenFieldSortDirection.Value);
            }

            grdMSPatients.DataSource = pats.Skip(Convert.ToInt32(HiddenFieldCurrentPageNumber.Value) * grdMSPatients.PageSize).Take(grdMSPatients.PageSize);
            grdMSPatients.DataBind();

            int currentRecord = (Convert.ToInt32(HiddenFieldCurrentPageNumber.Value) * grdMSPatients.PageSize);

            lblPageStatus.Text = "Page " + (Convert.ToInt32(HiddenFieldCurrentPageNumber.Value) + 1) + " of " + HiddenFieldPageCount.Value + ".";
            lblRecordCount.Text = totalRecords + "  (Showing Records " + (currentRecord + 1) + " - " + ((currentRecord + grdMSPatients.PageSize) > totalRecords ? totalRecords : (currentRecord + grdMSPatients.PageSize)) + ")";
        }

        setEnabledStatusOfPagingControls();

        pnlPagingControls.Visible = true;
    }

    #endregion

    #region Static Methods

    /// <summary>
    /// Function : AddMergedCells
    /// Purpose: Adds merged cell in the header
    /// </summary>
    /// <param name="objgridviewrow"></param>
    /// <param name="objtablecell"></param>
    /// <param name="colspan"></param>
    /// <param name="celltext"></param>
    private static void AddMergedCells(GridViewRow objgridviewrow, TableHeaderCell objtablecell, int colspan, string celltext)
    {
        objtablecell = new TableHeaderCell();
        objtablecell.Text = celltext;
        objtablecell.ColumnSpan = colspan;
        //objtablecell.BackColor = Color.FromName("#F4F4F4");
        objtablecell.BackColor = System.Drawing.Color.GhostWhite;
        objtablecell.Font.Bold = true;
        objtablecell.HorizontalAlign = HorizontalAlign.Center;
        objtablecell.Font.Size = 10;
        objgridviewrow.Cells.Add(objtablecell);
        //objgridviewrow.BackColor.Equals("#F4F4F4");
    }
    #endregion

    #region Paging Control Methods

    /// <summary>
    /// Fired on clicking First Page.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnFirstPage_Click(object sender, EventArgs e) {
        HiddenFieldCurrentPageNumber.Value = "0";
        filterData();
    }

    /// <summary>
    /// Fired when clicking Previous Page button.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnPrevPage_Click(object sender, EventArgs e) {
        int currentPageNumber = Convert.ToInt32(HiddenFieldCurrentPageNumber.Value);
        if (currentPageNumber > 0) {
            currentPageNumber = currentPageNumber - 1;
            HiddenFieldCurrentPageNumber.Value = currentPageNumber.ToString();
            filterData();
        }
    }

    /// <summary>
    /// Fired when clicking Next button
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnNextPage_Click(object sender, EventArgs e) {
        int currentPageNumber = Convert.ToInt32(HiddenFieldCurrentPageNumber.Value);
        if (currentPageNumber < Convert.ToInt32(HiddenFieldPageCount.Value)) {
            currentPageNumber = currentPageNumber + 1;
            HiddenFieldCurrentPageNumber.Value = currentPageNumber.ToString();
            filterData();
        }
    }

    /// <summary>
    /// Fired when clicking Last button
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnLastPage_Click(object sender, EventArgs e) {
        int lastPage = Convert.ToInt32(HiddenFieldPageCount.Value);
        lastPage = lastPage - 1;
        HiddenFieldCurrentPageNumber.Value = lastPage.ToString();
        filterData();
    }

    /// <summary>
    /// setEnabledStatusOfPagingControls: determines if buttons should be enabled or disabled based on the page.
    /// </summary>
    private void setEnabledStatusOfPagingControls() {
        int currentPageNumber = Convert.ToInt32(HiddenFieldCurrentPageNumber.Value);
        int lastPageNumber = Convert.ToInt32(HiddenFieldPageCount.Value) - 1;

        if (currentPageNumber == 0 && lastPageNumber > 0) {
            btnFirstPage.Enabled = false;
            btnPrevPage.Enabled = false;
            btnNextPage.Enabled = true;
            btnLastPage.Enabled = true;
        } else if (currentPageNumber == 0 && lastPageNumber == 0) {
            btnFirstPage.Enabled = false;
            btnPrevPage.Enabled = false;
            btnNextPage.Enabled = false;
            btnLastPage.Enabled = false;
        } else if (currentPageNumber == 1 && lastPageNumber == 1) {
            btnFirstPage.Enabled = false;
            btnPrevPage.Enabled = false;
            btnNextPage.Enabled = false;
            btnLastPage.Enabled = false;
        } else if (currentPageNumber > 0 && currentPageNumber < lastPageNumber) {
            btnFirstPage.Enabled = true;
            btnPrevPage.Enabled = true;
            btnNextPage.Enabled = true;
            btnLastPage.Enabled = true;
        } else if (currentPageNumber > 0 && currentPageNumber == lastPageNumber) {
            btnFirstPage.Enabled = true;
            btnPrevPage.Enabled = true;
            btnNextPage.Enabled = false;
            btnLastPage.Enabled = false;
        }
    }

    //private List<string> GetParsedMedName(string medName)
    //{
    //    List<string> listofMeds = new List<string>();
    //    string remmed = medName;
    //    string currmed = string.Empty;
    //    while (remmed.Contains('(') && remmed.Contains(')'))
    //    {
    //        currmed = medName.Substring(remmed.LastIndexOf('(') + 1, (remmed.LastIndexOf(')')) - (remmed.LastIndexOf('(') + 1));
    //        remmed = remmed.Substring(0, remmed.Length - currmed.Length - 3);
    //        listofMeds.Add(currmed.ToLower());
    //    }
    //    listofMeds.Add(remmed.ToLower());
    //    return listofMeds;
    //}
    #endregion

    protected void Edit_Surveys(object sender, CommandEventArgs e)
    {
        Logging.WriteLogToFile("SURVEY Edit Button Clicked On Patients Page - Edit Survey Start.");
        if (IsUserAuthorizedToEditSurvey())
        {
            var patientIcn = e.CommandArgument.ToString();
            Session.Add("patientIcnMsatEdit", Helpers.SerializSessionItemsObj(patientIcn));
            Logging.WriteLogToFile(string.Format("SURVEY EDIT Authorized and opening patient ICN {0} on Patients page for survey edit.", patientIcn));
            Response.Redirect("SurveyEdit.aspx?patientIcn=" + patientIcn);
        }
        else
        {
            Logging.WriteLogToFile("Warning::SURVEY EDIT: Error opening survey edit module – Not Authorized. Redirecting to error page.");
            Response.Redirect("ErrorPage.aspx?id=100");
        }
    }

    protected void Create_Surveys(object sender, CommandEventArgs e)
    {
        Session["patientIcnMsatCreateSurvey"] = null;
        string[] cmdArgs;
        cmdArgs = e.CommandArgument.ToString().Split(',');
        var patientIcn = cmdArgs[0];
        var stationId = cmdArgs[1];

        Logging.WriteLogToFile(string.Format("Create Survey Button Clicked On Patients Page - Create Survey Start.{0} by {1}", patientIcn, _user.UserName));
        if (IsUserAuthorizedToEditSurvey())
        {
            Session.Add("patientIcnMsatCreateSurvey", Helpers.SerializSessionItemsObj(patientIcn));
            Session.Add("stationIdMsatCreateSurvey", Helpers.SerializSessionItemsObj(stationId));
            Logging.WriteLogToFile(string.Format("Create Survey Authorized and opening patient ICN {0} on Patients page for create survey.", patientIcn));
            Response.Redirect("CreateSurvey.aspx?patientIcn=" + patientIcn);
        }
        else
        {
            Logging.WriteLogToFile("Warning::SURVEY CREATE: Error opening create survey module – Not Authorized. Redirecting to error page.");
            Response.Redirect("ErrorPage.aspx?id=100");
        }
    }

    private bool IsUserAuthorizedToEditSurvey()
    {
        bool allowedToEdit = false;
        var editMnger = new SurveyEditUserManager();
        allowedToEdit = editMnger.IsUserAuthozizedToEditSurvey(_user);
        return allowedToEdit;
    }
}